/* MainWindow.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from MainWindow.vala, do not modify */

/*
 * SPDX-License-Identifier: LGPL-3.0-or-later
 * SPDX-FileCopyrightText: 2021 elementary, Inc. (https://elementary.io)
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <granite-7.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <adwaita.h>
#include <float.h>
#include <math.h>

#define MUSIC_MAIN_WINDOW_ACTION_PREFIX "win."
#define MUSIC_MAIN_WINDOW_ACTION_OPEN "action-open"
#define MUSIC_APPLICATION_ACTION_PREFIX "app."
#define MUSIC_APPLICATION_ACTION_SHUFFLE "action-shuffle"
#define MUSIC_APPLICATION_ACTION_CLEAR_QUEUE "action-clear-queue"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MUSIC_TYPE_MAIN_WINDOW (music_main_window_get_type ())
#define MUSIC_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_MAIN_WINDOW, MusicMainWindow))
#define MUSIC_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_TYPE_MAIN_WINDOW, MusicMainWindowClass))
#define MUSIC_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_MAIN_WINDOW))
#define MUSIC_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_TYPE_MAIN_WINDOW))
#define MUSIC_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_TYPE_MAIN_WINDOW, MusicMainWindowClass))

typedef struct _MusicMainWindow MusicMainWindow;
typedef struct _MusicMainWindowClass MusicMainWindowClass;
typedef struct _MusicMainWindowPrivate MusicMainWindowPrivate;

#define MUSIC_TYPE_SEARCH_BAR (music_search_bar_get_type ())
#define MUSIC_SEARCH_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_SEARCH_BAR, MusicSearchBar))
#define MUSIC_SEARCH_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_TYPE_SEARCH_BAR, MusicSearchBarClass))
#define MUSIC_IS_SEARCH_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_SEARCH_BAR))
#define MUSIC_IS_SEARCH_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_TYPE_SEARCH_BAR))
#define MUSIC_SEARCH_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_TYPE_SEARCH_BAR, MusicSearchBarClass))

typedef struct _MusicSearchBar MusicSearchBar;
typedef struct _MusicSearchBarClass MusicSearchBarClass;
enum  {
	MUSIC_MAIN_WINDOW_0_PROPERTY,
	MUSIC_MAIN_WINDOW_NUM_PROPERTIES
};
static GParamSpec* music_main_window_properties[MUSIC_MAIN_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_free0(var) (var = (g_free (var), NULL))

#define MUSIC_TYPE_PLAYBACK_MANAGER (music_playback_manager_get_type ())
#define MUSIC_PLAYBACK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_PLAYBACK_MANAGER, MusicPlaybackManager))
#define MUSIC_PLAYBACK_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_TYPE_PLAYBACK_MANAGER, MusicPlaybackManagerClass))
#define MUSIC_IS_PLAYBACK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_PLAYBACK_MANAGER))
#define MUSIC_IS_PLAYBACK_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_TYPE_PLAYBACK_MANAGER))
#define MUSIC_PLAYBACK_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_TYPE_PLAYBACK_MANAGER, MusicPlaybackManagerClass))

typedef struct _MusicPlaybackManager MusicPlaybackManager;
typedef struct _MusicPlaybackManagerClass MusicPlaybackManagerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block3Data Block3Data;

#define MUSIC_TYPE_NOW_PLAYING_VIEW (music_now_playing_view_get_type ())
#define MUSIC_NOW_PLAYING_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_NOW_PLAYING_VIEW, MusicNowPlayingView))
#define MUSIC_NOW_PLAYING_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_TYPE_NOW_PLAYING_VIEW, MusicNowPlayingViewClass))
#define MUSIC_IS_NOW_PLAYING_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_NOW_PLAYING_VIEW))
#define MUSIC_IS_NOW_PLAYING_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_TYPE_NOW_PLAYING_VIEW))
#define MUSIC_NOW_PLAYING_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_TYPE_NOW_PLAYING_VIEW, MusicNowPlayingViewClass))

typedef struct _MusicNowPlayingView MusicNowPlayingView;
typedef struct _MusicNowPlayingViewClass MusicNowPlayingViewClass;
#define __vala_GdkFileList_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkFileList_free (var), NULL)))

#define MUSIC_TYPE_TRACK_ROW (music_track_row_get_type ())
#define MUSIC_TRACK_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_TRACK_ROW, MusicTrackRow))
#define MUSIC_TRACK_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_TYPE_TRACK_ROW, MusicTrackRowClass))
#define MUSIC_IS_TRACK_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_TRACK_ROW))
#define MUSIC_IS_TRACK_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_TYPE_TRACK_ROW))
#define MUSIC_TRACK_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_TYPE_TRACK_ROW, MusicTrackRowClass))

typedef struct _MusicTrackRow MusicTrackRow;
typedef struct _MusicTrackRowClass MusicTrackRowClass;

#define MUSIC_TYPE_AUDIO_OBJECT (music_audio_object_get_type ())
#define MUSIC_AUDIO_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObject))
#define MUSIC_AUDIO_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObjectClass))
#define MUSIC_IS_AUDIO_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_AUDIO_OBJECT))
#define MUSIC_IS_AUDIO_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_TYPE_AUDIO_OBJECT))
#define MUSIC_AUDIO_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObjectClass))

typedef struct _MusicAudioObject MusicAudioObject;
typedef struct _MusicAudioObjectClass MusicAudioObjectClass;

struct _MusicMainWindow {
	GtkApplicationWindow parent_instance;
	MusicMainWindowPrivate * priv;
};

struct _MusicMainWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _MusicMainWindowPrivate {
	GranitePlaceholder* queue_placeholder;
	GranitePlaceholder* search_placeholder;
	GtkButton* repeat_button;
	GtkButton* shuffle_button;
	MusicSearchBar* search_bar;
	GtkListView* queue_listview;
	GtkRevealer* search_revealer;
	GtkScrolledWindow* scrolled;
	GtkSingleSelection* selection_model;
	GtkStack* queue_stack;
	GSettings* settings;
};

struct _Block2Data {
	int _ref_count_;
	MusicMainWindow* self;
	GtkFileDialog* file_dialog;
};

struct _Block3Data {
	int _ref_count_;
	MusicMainWindow* self;
	MusicPlaybackManager* playback_manager;
	GraniteToast* error_toast;
};

static gint MusicMainWindow_private_offset;
static gpointer music_main_window_parent_class = NULL;

VALA_EXTERN GType music_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicMainWindow, g_object_unref)
VALA_EXTERN GType music_search_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicSearchBar, g_object_unref)
VALA_EXTERN void music_main_window_start_search (MusicMainWindow* self);
VALA_EXTERN void music_search_bar_start_search (MusicSearchBar* self);
static void music_main_window_open_files (MusicMainWindow* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda10_ (Block2Data* _data2_,
                  GObject* obj,
                  GAsyncResult* res);
static void _vala_array_add4 (GFile** * array,
                       gint* length,
                       gint* size,
                       GFile* value);
VALA_EXTERN GFile** music_application_loop_through_files (GFile** files,
                                              gint files_length1,
                                              gint* result_length1);
VALA_EXTERN GType music_playback_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicPlaybackManager, g_object_unref)
VALA_EXTERN MusicPlaybackManager* music_playback_manager_get_default (void);
VALA_EXTERN void music_playback_manager_queue_files (MusicPlaybackManager* self,
                                         GFile** files,
                                         gint files_length1);
static void _gtk_window_destroy_gtk_dialog_response (GtkDialog* _sender,
                                              gint response_id,
                                              gpointer self);
static void ___lambda10__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void music_main_window_update_repeat_button (MusicMainWindow* self);
static void music_main_window_on_items_changed (MusicMainWindow* self);
VALA_EXTERN GtkSearchEntry* music_search_bar_get_search_entry (MusicSearchBar* self);
VALA_EXTERN MusicMainWindow* music_main_window_new (void);
VALA_EXTERN MusicMainWindow* music_main_window_construct (GType object_type);
static GObject * music_main_window_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
VALA_EXTERN GListStore* music_playback_manager_get_queue_liststore (MusicPlaybackManager* self);
VALA_EXTERN MusicSearchBar* music_search_bar_new (GListModel* list_model);
VALA_EXTERN MusicSearchBar* music_search_bar_construct (GType object_type,
                                            GListModel* list_model);
VALA_EXTERN GtkFilterListModel* music_search_bar_get_filter_model (MusicSearchBar* self);
static void _music_main_window_open_files_g_simple_action_activate (GSimpleAction* _sender,
                                                             GVariant* parameter,
                                                             gpointer self);
VALA_EXTERN GType music_now_playing_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicNowPlayingView, g_object_unref)
VALA_EXTERN MusicNowPlayingView* music_now_playing_view_new (void);
VALA_EXTERN MusicNowPlayingView* music_now_playing_view_construct (GType object_type);
static void _music_main_window_update_repeat_button_g_settings_changed (GSettings* _sender,
                                                                 const gchar* key,
                                                                 gpointer self);
static gboolean _music_main_window___lambda16_ (MusicMainWindow* self,
                                         GtkDropTarget* target,
                                         GValue* value,
                                         gdouble x,
                                         gdouble y);
static GdkFileList* _vala_GdkFileList_copy (GdkFileList* self);
static void _vala_array_add5 (GFile** * array,
                       gint* length,
                       gint* size,
                       GFile* value);
static void _vala_GdkFileList_free (GdkFileList* self);
static gboolean __music_main_window___lambda16__gtk_drop_target_drop (GtkDropTarget* _sender,
                                                               GValue* value,
                                                               gdouble x,
                                                               gdouble y,
                                                               gpointer self);
static void _music_main_window___lambda17_ (Block3Data* _data3_);
VALA_EXTERN guint music_playback_manager_get_n_items (MusicPlaybackManager* self);
static void __music_main_window___lambda17__g_list_model_items_changed (GListModel* _sender,
                                                                 guint position,
                                                                 guint removed,
                                                                 guint added,
                                                                 gpointer self);
static void _music_main_window___lambda18_ (Block3Data* _data3_,
                                     gint count);
static void __music_main_window___lambda18__music_playback_manager_invalids_found (MusicPlaybackManager* _sender,
                                                                            gint count,
                                                                            gpointer self);
static void _music_main_window___lambda19_ (MusicMainWindow* self);
static void __music_main_window___lambda19__gtk_button_clicked (GtkButton* _sender,
                                                         gpointer self);
static void _music_main_window___lambda20_ (MusicMainWindow* self,
                                     GObject* obj);
VALA_EXTERN MusicTrackRow* music_track_row_new (void);
VALA_EXTERN MusicTrackRow* music_track_row_construct (GType object_type);
VALA_EXTERN GType music_track_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicTrackRow, g_object_unref)
static void __music_main_window___lambda20__gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                                         GObject* object,
                                                                         gpointer self);
static void _music_main_window___lambda27_ (MusicMainWindow* self,
                                     GObject* obj);
VALA_EXTERN GType music_audio_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicAudioObject, g_object_unref)
VALA_EXTERN void music_track_row_set_audio_object (MusicTrackRow* self,
                                       MusicAudioObject* value);
static void __music_main_window___lambda27__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                                        GObject* object,
                                                                        gpointer self);
static void _music_main_window___lambda28_ (Block3Data* _data3_,
                                     guint index);
VALA_EXTERN void music_playback_manager_set_current_audio (MusicPlaybackManager* self,
                                               MusicAudioObject* value);
static void __music_main_window___lambda28__gtk_list_view_activate (GtkListView* _sender,
                                                             guint position,
                                                             gpointer self);
static void _music_main_window_on_items_changed_g_list_model_items_changed (GListModel* _sender,
                                                                     guint position,
                                                                     guint removed,
                                                                     guint added,
                                                                     gpointer self);
static void _music_main_window___lambda29_ (Block3Data* _data3_);
static void __music_main_window___lambda29__music_search_bar_activated (MusicSearchBar* _sender,
                                                                 gpointer self);
static void _music_main_window___lambda30_ (MusicMainWindow* self);
static void __music_main_window___lambda30__gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                      gpointer self);
static void music_main_window_finalize (GObject * obj);
static GType music_main_window_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
music_main_window_get_instance_private (MusicMainWindow* self)
{
	return G_STRUCT_MEMBER_P (self, MusicMainWindow_private_offset);
}

void
music_main_window_start_search (MusicMainWindow* self)
{
	GtkRevealer* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->search_revealer;
	_tmp1_ = gtk_revealer_get_child_revealed (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		MusicSearchBar* _tmp3_;
		_tmp3_ = self->priv->search_bar;
		music_search_bar_start_search (_tmp3_);
	}
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		MusicMainWindow* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->file_dialog);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_vala_array_add4 (GFile** * array,
                  gint* length,
                  gint* size,
                  GFile* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_gtk_window_destroy_gtk_dialog_response (GtkDialog* _sender,
                                         gint response_id,
                                         gpointer self)
{
	gtk_window_destroy ((GtkWindow*) self);
}

static void
__lambda10_ (Block2Data* _data2_,
             GObject* obj,
             GAsyncResult* res)
{
	MusicMainWindow* self;
	GError* _inner_error0_ = NULL;
	self = _data2_->self;
	g_return_if_fail (res != NULL);
	{
		GListModel* files = NULL;
		GListModel* _tmp0_;
		GFile** file_array = NULL;
		GFile** _tmp1_;
		gint file_array_length1;
		gint _file_array_size_;
		GFile** files_to_play = NULL;
		GFile** _tmp7_;
		gint _tmp7__length1;
		gint _tmp8_ = 0;
		GFile** _tmp9_;
		gint files_to_play_length1;
		gint _files_to_play_size_;
		MusicPlaybackManager* _tmp10_;
		GFile** _tmp11_;
		gint _tmp11__length1;
		_tmp0_ = gtk_file_dialog_open_multiple_finish (_data2_->file_dialog, res, &_inner_error0_);
		files = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = g_new0 (GFile*, 0 + 1);
		file_array = _tmp1_;
		file_array_length1 = 0;
		_file_array_size_ = file_array_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp2_ = FALSE;
				_tmp2_ = TRUE;
				while (TRUE) {
					GListModel* _tmp4_;
					GListModel* _tmp5_;
					GObject* _tmp6_;
					if (!_tmp2_) {
						gint _tmp3_;
						_tmp3_ = i;
						i = _tmp3_ + 1;
					}
					_tmp2_ = FALSE;
					_tmp4_ = files;
					if (!(((guint) i) < g_list_model_get_n_items (_tmp4_))) {
						break;
					}
					_tmp5_ = files;
					_tmp6_ = g_list_model_get_item (_tmp5_, (guint) i);
					_vala_array_add4 (&file_array, &file_array_length1, &_file_array_size_, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, g_file_get_type (), GFile));
				}
			}
		}
		_tmp7_ = file_array;
		_tmp7__length1 = file_array_length1;
		_tmp9_ = music_application_loop_through_files (_tmp7_, (gint) _tmp7__length1, &_tmp8_);
		files_to_play = _tmp9_;
		files_to_play_length1 = _tmp8_;
		_files_to_play_size_ = files_to_play_length1;
		_tmp10_ = music_playback_manager_get_default ();
		_tmp11_ = files_to_play;
		_tmp11__length1 = files_to_play_length1;
		music_playback_manager_queue_files (_tmp10_, _tmp11_, (gint) _tmp11__length1);
		files_to_play = (_vala_array_free (files_to_play, files_to_play_length1, (GDestroyNotify) g_object_unref), NULL);
		file_array = (_vala_array_free (file_array, file_array_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (files);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		GraniteMessageDialog* dialog = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		GThemedIcon* _tmp15_;
		GThemedIcon* _tmp16_;
		GThemedIcon* _tmp17_;
		GtkWindow* _tmp18_;
		GraniteMessageDialog* _tmp19_ = NULL;
		GraniteMessageDialog* _tmp20_;
		GraniteMessageDialog* _tmp21_;
		GraniteMessageDialog* _tmp22_;
		GraniteMessageDialog* _tmp23_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = e;
		if (g_error_matches (_tmp12_, gtk_dialog_error_quark (), GTK_DIALOG_ERROR_DISMISSED)) {
			_g_error_free0 (e);
			return;
		}
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		_tmp15_ = (GThemedIcon*) g_themed_icon_new ("document-open");
		_tmp16_ = _tmp15_;
		_tmp17_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
		_tmp18_ = _g_object_ref0 ((GtkWindow*) self);
		_tmp19_ = granite_message_dialog_new (_ ("Couldn't add audio files"), _tmp14_, (GIcon*) _tmp16_, GTK_BUTTONS_CLOSE);
		granite_message_dialog_set_badge_icon (_tmp19_, (GIcon*) _tmp17_);
		_g_object_unref0 (_tmp17_);
		gtk_window_set_modal ((GtkWindow*) _tmp19_, TRUE);
		gtk_window_set_transient_for ((GtkWindow*) _tmp19_, _tmp18_);
		_g_object_unref0 (_tmp18_);
		g_object_ref_sink (_tmp19_);
		_tmp20_ = _tmp19_;
		_g_object_unref0 (_tmp16_);
		dialog = _tmp20_;
		_tmp21_ = dialog;
		gtk_window_present ((GtkWindow*) _tmp21_);
		_tmp22_ = dialog;
		_tmp23_ = dialog;
		g_signal_connect_object ((GtkDialog*) _tmp22_, "response", (GCallback) _gtk_window_destroy_gtk_dialog_response, (GtkWindow*) _tmp23_, 0);
		_g_object_unref0 (dialog);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda10__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda10_ (self, source_object, res);
	block2_data_unref (self);
}

static void
music_main_window_open_files (MusicMainWindow* self)
{
	Block2Data* _data2_;
	GtkFileFilter* all_files_filter = NULL;
	gchar* _tmp0_;
	GtkFileFilter* _tmp1_ = NULL;
	GtkFileFilter* music_files_filter = NULL;
	gchar* _tmp2_;
	GtkFileFilter* _tmp3_ = NULL;
	GListStore* filter_model = NULL;
	GListStore* _tmp4_;
	gchar* _tmp5_;
	GtkFileFilter* _tmp6_;
	GListModel* _tmp7_;
	gchar* _tmp8_;
	GtkFileDialog* _tmp9_ = NULL;
	MusicMainWindow* _tmp10_;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = g_strdup (_ ("All files"));
	_tmp1_ = gtk_file_filter_new ();
	g_object_set (_tmp1_, "name", _tmp0_, NULL);
	_g_free0 (_tmp0_);
	all_files_filter = _tmp1_;
	gtk_file_filter_add_pattern (all_files_filter, "*");
	_tmp2_ = g_strdup (_ ("Music files"));
	_tmp3_ = gtk_file_filter_new ();
	g_object_set (_tmp3_, "name", _tmp2_, NULL);
	_g_free0 (_tmp2_);
	music_files_filter = _tmp3_;
	gtk_file_filter_add_mime_type (music_files_filter, "audio/*");
	_tmp4_ = g_list_store_new (gtk_file_filter_get_type ());
	filter_model = _tmp4_;
	g_list_store_append (filter_model, (GObject*) all_files_filter);
	g_list_store_append (filter_model, (GObject*) music_files_filter);
	_tmp5_ = g_strdup (_ ("Open"));
	_tmp6_ = _g_object_ref0 (music_files_filter);
	_tmp7_ = _g_object_ref0 ((GListModel*) filter_model);
	_tmp8_ = g_strdup (_ ("Open audio files"));
	_tmp9_ = gtk_file_dialog_new ();
	gtk_file_dialog_set_accept_label (_tmp9_, _tmp5_);
	_g_free0 (_tmp5_);
	gtk_file_dialog_set_default_filter (_tmp9_, _tmp6_);
	_g_object_unref0 (_tmp6_);
	gtk_file_dialog_set_filters (_tmp9_, _tmp7_);
	_g_object_unref0 (_tmp7_);
	gtk_file_dialog_set_modal (_tmp9_, TRUE);
	gtk_file_dialog_set_title (_tmp9_, _tmp8_);
	_g_free0 (_tmp8_);
	_data2_->file_dialog = _tmp9_;
	_tmp10_ = self;
	gtk_file_dialog_open_multiple (_data2_->file_dialog, (GtkWindow*) _tmp10_, NULL, ___lambda10__gasync_ready_callback, block2_data_ref (_data2_));
	_g_object_unref0 (filter_model);
	_g_object_unref0 (music_files_filter);
	_g_object_unref0 (all_files_filter);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static void
music_main_window_update_repeat_button (MusicMainWindow* self)
{
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	static GQuark _tmp3_label2 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_string (_tmp0_, "repeat-mode");
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	g_free (_tmp2_);
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("disabled")))) {
		switch (0) {
			default:
			{
				GtkButton* _tmp5_;
				GtkButton* _tmp6_;
				_tmp5_ = self->priv->repeat_button;
				gtk_button_set_icon_name (_tmp5_, "media-playlist-no-repeat-symbolic");
				_tmp6_ = self->priv->repeat_button;
				gtk_widget_set_tooltip_text ((GtkWidget*) _tmp6_, _ ("Repeat None"));
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("all")))) {
		switch (0) {
			default:
			{
				GtkButton* _tmp7_;
				GtkButton* _tmp8_;
				_tmp7_ = self->priv->repeat_button;
				gtk_button_set_icon_name (_tmp7_, "media-playlist-repeat-symbolic");
				_tmp8_ = self->priv->repeat_button;
				gtk_widget_set_tooltip_text ((GtkWidget*) _tmp8_, _ ("Repeat All"));
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label2) ? _tmp3_label2 : (_tmp3_label2 = g_quark_from_static_string ("one")))) {
		switch (0) {
			default:
			{
				GtkButton* _tmp9_;
				GtkButton* _tmp10_;
				_tmp9_ = self->priv->repeat_button;
				gtk_button_set_icon_name (_tmp9_, "media-playlist-repeat-song-symbolic");
				_tmp10_ = self->priv->repeat_button;
				gtk_widget_set_tooltip_text ((GtkWidget*) _tmp10_, _ ("Repeat One"));
				break;
			}
		}
	}
}

static void
music_main_window_on_items_changed (MusicMainWindow* self)
{
	GtkSingleSelection* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	MusicSearchBar* _tmp5_;
	GtkSearchEntry* _tmp6_;
	GtkSearchEntry* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->selection_model;
	g_object_get (_tmp0_, "n-items", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > ((guint) 0)) {
		GtkStack* _tmp3_;
		GtkScrolledWindow* _tmp4_;
		_tmp3_ = self->priv->queue_stack;
		_tmp4_ = self->priv->scrolled;
		gtk_stack_set_visible_child (_tmp3_, (GtkWidget*) _tmp4_);
		return;
	}
	_tmp5_ = self->priv->search_bar;
	_tmp6_ = music_search_bar_get_search_entry (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = gtk_editable_get_text ((GtkEditable*) _tmp7_);
	_tmp9_ = _tmp8_;
	if (g_strcmp0 (_tmp9_, "") != 0) {
		GtkStack* _tmp10_;
		GranitePlaceholder* _tmp11_;
		_tmp10_ = self->priv->queue_stack;
		_tmp11_ = self->priv->search_placeholder;
		gtk_stack_set_visible_child (_tmp10_, (GtkWidget*) _tmp11_);
	} else {
		GtkStack* _tmp12_;
		GranitePlaceholder* _tmp13_;
		_tmp12_ = self->priv->queue_stack;
		_tmp13_ = self->priv->queue_placeholder;
		gtk_stack_set_visible_child (_tmp12_, (GtkWidget*) _tmp13_);
	}
}

MusicMainWindow*
music_main_window_construct (GType object_type)
{
	MusicMainWindow * self = NULL;
	self = (MusicMainWindow*) g_object_new (object_type, NULL);
	return self;
}

MusicMainWindow*
music_main_window_new (void)
{
	return music_main_window_construct (MUSIC_TYPE_MAIN_WINDOW);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		MusicMainWindow* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->error_toast);
		_g_object_unref0 (_data3_->playback_manager);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
_music_main_window_open_files_g_simple_action_activate (GSimpleAction* _sender,
                                                        GVariant* parameter,
                                                        gpointer self)
{
	music_main_window_open_files ((MusicMainWindow*) self);
}

static void
_music_main_window_update_repeat_button_g_settings_changed (GSettings* _sender,
                                                            const gchar* key,
                                                            gpointer self)
{
	music_main_window_update_repeat_button ((MusicMainWindow*) self);
}

static GdkFileList*
_vala_GdkFileList_copy (GdkFileList* self)
{
	return g_boxed_copy (gdk_file_list_get_type (), self);
}

static gpointer
__vala_GdkFileList_copy0 (gpointer self)
{
	return self ? _vala_GdkFileList_copy (self) : NULL;
}

static void
_vala_array_add5 (GFile** * array,
                  gint* length,
                  gint* size,
                  GFile* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_GdkFileList_free (GdkFileList* self)
{
	g_boxed_free (gdk_file_list_get_type (), self);
}

static gboolean
_music_main_window___lambda16_ (MusicMainWindow* self,
                                GtkDropTarget* target,
                                GValue* value,
                                gdouble x,
                                gdouble y)
{
	gboolean result;
	g_return_val_if_fail (target != NULL, FALSE);
	g_return_val_if_fail (value != NULL, FALSE);
	if (G_VALUE_TYPE (value) == gdk_file_list_get_type ()) {
		GdkFileList* list = NULL;
		GValue _tmp0_;
		GdkFileList* _tmp1_;
		GFile** file_array = NULL;
		GFile** _tmp2_;
		gint file_array_length1;
		gint _file_array_size_;
		GdkFileList* _tmp3_;
		GSList* _tmp4_;
		GFile** files_to_play = NULL;
		GFile** _tmp7_;
		gint _tmp7__length1;
		gint _tmp8_ = 0;
		GFile** _tmp9_;
		gint files_to_play_length1;
		gint _files_to_play_size_;
		MusicPlaybackManager* _tmp10_;
		GFile** _tmp11_;
		gint _tmp11__length1;
		_tmp0_ = *value;
		_tmp1_ = __vala_GdkFileList_copy0 (g_value_get_boxed (&_tmp0_));
		list = _tmp1_;
		_tmp2_ = g_new0 (GFile*, 0 + 1);
		file_array = _tmp2_;
		file_array_length1 = 0;
		_file_array_size_ = file_array_length1;
		_tmp3_ = list;
		_tmp4_ = gdk_file_list_get_files (_tmp3_);
		{
			GSList* file_collection = NULL;
			GSList* file_it = NULL;
			file_collection = _tmp4_;
			for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
				GFile* file = NULL;
				file = (GFile*) file_it->data;
				{
					GFile* _tmp5_;
					GFile* _tmp6_;
					_tmp5_ = file;
					_tmp6_ = _g_object_ref0 (_tmp5_);
					_vala_array_add5 (&file_array, &file_array_length1, &_file_array_size_, _tmp6_);
				}
			}
			(file_collection == NULL) ? NULL : (file_collection = (g_slist_free (file_collection), NULL));
		}
		_tmp7_ = file_array;
		_tmp7__length1 = file_array_length1;
		_tmp9_ = music_application_loop_through_files (_tmp7_, (gint) _tmp7__length1, &_tmp8_);
		files_to_play = _tmp9_;
		files_to_play_length1 = _tmp8_;
		_files_to_play_size_ = files_to_play_length1;
		_tmp10_ = music_playback_manager_get_default ();
		_tmp11_ = files_to_play;
		_tmp11__length1 = files_to_play_length1;
		music_playback_manager_queue_files (_tmp10_, _tmp11_, (gint) _tmp11__length1);
		result = TRUE;
		files_to_play = (_vala_array_free (files_to_play, files_to_play_length1, (GDestroyNotify) g_object_unref), NULL);
		file_array = (_vala_array_free (file_array, file_array_length1, (GDestroyNotify) g_object_unref), NULL);
		__vala_GdkFileList_free0 (list);
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
__music_main_window___lambda16__gtk_drop_target_drop (GtkDropTarget* _sender,
                                                      GValue* value,
                                                      gdouble x,
                                                      gdouble y,
                                                      gpointer self)
{
	gboolean result;
	result = _music_main_window___lambda16_ ((MusicMainWindow*) self, _sender, value, x, y);
	return result;
}

static void
_music_main_window___lambda17_ (Block3Data* _data3_)
{
	MusicMainWindow* self;
	MusicPlaybackManager* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	self = _data3_->self;
	_tmp0_ = _data3_->playback_manager;
	_tmp1_ = music_playback_manager_get_n_items (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == ((guint) 0)) {
		GtkStack* _tmp3_;
		GranitePlaceholder* _tmp4_;
		MusicSearchBar* _tmp5_;
		GtkSearchEntry* _tmp6_;
		GtkSearchEntry* _tmp7_;
		_tmp3_ = self->priv->queue_stack;
		_tmp4_ = self->priv->queue_placeholder;
		gtk_stack_set_visible_child (_tmp3_, (GtkWidget*) _tmp4_);
		_tmp5_ = self->priv->search_bar;
		_tmp6_ = music_search_bar_get_search_entry (_tmp5_);
		_tmp7_ = _tmp6_;
		gtk_editable_set_text ((GtkEditable*) _tmp7_, "");
	}
}

static void
__music_main_window___lambda17__g_list_model_items_changed (GListModel* _sender,
                                                            guint position,
                                                            guint removed,
                                                            guint added,
                                                            gpointer self)
{
	_music_main_window___lambda17_ (self);
}

static void
_music_main_window___lambda18_ (Block3Data* _data3_,
                                gint count)
{
	MusicMainWindow* self;
	GraniteToast* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GraniteToast* _tmp3_;
	self = _data3_->self;
	_tmp0_ = _data3_->error_toast;
	_tmp1_ = g_strdup_printf (ngettext ("%d invalid file was not added to the queue", "%d invalid files were not added to the queue", (gulong) count), count);
	_tmp2_ = _tmp1_;
	granite_toast_set_title (_tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = _data3_->error_toast;
	granite_toast_send_notification (_tmp3_);
}

static void
__music_main_window___lambda18__music_playback_manager_invalids_found (MusicPlaybackManager* _sender,
                                                                       gint count,
                                                                       gpointer self)
{
	_music_main_window___lambda18_ (self, count);
}

static void
_music_main_window___lambda19_ (MusicMainWindow* self)
{
	gint enum_step = 0;
	GSettings* _tmp0_;
	_tmp0_ = self->priv->settings;
	enum_step = g_settings_get_enum (_tmp0_, "repeat-mode");
	if (enum_step < 2) {
		GSettings* _tmp1_;
		_tmp1_ = self->priv->settings;
		g_settings_set_enum (_tmp1_, "repeat-mode", enum_step + 1);
	} else {
		GSettings* _tmp2_;
		_tmp2_ = self->priv->settings;
		g_settings_set_enum (_tmp2_, "repeat-mode", 0);
	}
}

static void
__music_main_window___lambda19__gtk_button_clicked (GtkButton* _sender,
                                                    gpointer self)
{
	_music_main_window___lambda19_ ((MusicMainWindow*) self);
}

static void
_music_main_window___lambda20_ (MusicMainWindow* self,
                                GObject* obj)
{
	GtkListItem* list_item = NULL;
	GtkListItem* _tmp0_;
	GtkListItem* _tmp1_;
	MusicTrackRow* _tmp2_;
	MusicTrackRow* _tmp3_;
	g_return_if_fail (obj != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (obj, gtk_list_item_get_type (), GtkListItem));
	list_item = _tmp0_;
	_tmp1_ = list_item;
	_tmp2_ = music_track_row_new ();
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	gtk_list_item_set_child (_tmp1_, (GtkWidget*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (list_item);
}

static void
__music_main_window___lambda20__gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                                    GObject* object,
                                                                    gpointer self)
{
	_music_main_window___lambda20_ ((MusicMainWindow*) self, object);
}

static void
_music_main_window___lambda27_ (MusicMainWindow* self,
                                GObject* obj)
{
	GtkListItem* list_item = NULL;
	GtkListItem* _tmp0_;
	GtkListItem* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	GtkListItem* _tmp4_;
	GObject* _tmp5_;
	GObject* _tmp6_;
	g_return_if_fail (obj != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (obj, gtk_list_item_get_type (), GtkListItem));
	list_item = _tmp0_;
	_tmp1_ = list_item;
	_tmp2_ = gtk_list_item_get_child (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = list_item;
	_tmp5_ = gtk_list_item_get_item (_tmp4_);
	_tmp6_ = _tmp5_;
	music_track_row_set_audio_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, MUSIC_TYPE_TRACK_ROW, MusicTrackRow), G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObject));
	_g_object_unref0 (list_item);
}

static void
__music_main_window___lambda27__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                                   GObject* object,
                                                                   gpointer self)
{
	_music_main_window___lambda27_ ((MusicMainWindow*) self, object);
}

static void
_music_main_window___lambda28_ (Block3Data* _data3_,
                                guint index)
{
	MusicMainWindow* self;
	MusicPlaybackManager* _tmp0_;
	GtkSingleSelection* _tmp1_;
	GObject* _tmp2_;
	MusicAudioObject* _tmp3_;
	self = _data3_->self;
	_tmp0_ = _data3_->playback_manager;
	_tmp1_ = self->priv->selection_model;
	_tmp2_ = g_list_model_get_item ((GListModel*) _tmp1_, index);
	_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObject);
	music_playback_manager_set_current_audio (_tmp0_, _tmp3_);
	_g_object_unref0 (_tmp3_);
}

static void
__music_main_window___lambda28__gtk_list_view_activate (GtkListView* _sender,
                                                        guint position,
                                                        gpointer self)
{
	_music_main_window___lambda28_ (self, position);
}

static void
_music_main_window_on_items_changed_g_list_model_items_changed (GListModel* _sender,
                                                                guint position,
                                                                guint removed,
                                                                guint added,
                                                                gpointer self)
{
	music_main_window_on_items_changed ((MusicMainWindow*) self);
}

static void
_music_main_window___lambda29_ (Block3Data* _data3_)
{
	MusicMainWindow* self;
	guint selected = 0U;
	GtkSingleSelection* _tmp0_;
	self = _data3_->self;
	_tmp0_ = self->priv->selection_model;
	selected = gtk_single_selection_get_selected (_tmp0_);
	if (selected != ((guint) -1)) {
		MusicAudioObject* selected_audio = NULL;
		GtkSingleSelection* _tmp1_;
		GObject* _tmp2_;
		MusicPlaybackManager* _tmp3_;
		MusicAudioObject* _tmp4_;
		_tmp1_ = self->priv->selection_model;
		_tmp2_ = g_list_model_get_item ((GListModel*) _tmp1_, selected);
		selected_audio = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObject);
		_tmp3_ = _data3_->playback_manager;
		_tmp4_ = selected_audio;
		music_playback_manager_set_current_audio (_tmp3_, _tmp4_);
		_g_object_unref0 (selected_audio);
	}
}

static void
__music_main_window___lambda29__music_search_bar_activated (MusicSearchBar* _sender,
                                                            gpointer self)
{
	_music_main_window___lambda29_ (self);
}

static void
_music_main_window___lambda30_ (MusicMainWindow* self)
{
	gboolean _tmp0_ = FALSE;
	GtkSingleSelection* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	_tmp1_ = self->priv->selection_model;
	g_object_get (_tmp1_, "n-items", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if (_tmp3_ <= ((guint) 0)) {
		MusicSearchBar* _tmp4_;
		GtkSearchEntry* _tmp5_;
		GtkSearchEntry* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp4_ = self->priv->search_bar;
		_tmp5_ = music_search_bar_get_search_entry (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = gtk_editable_get_text ((GtkEditable*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp0_ = g_strcmp0 (_tmp8_, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GranitePlaceholder* _tmp9_;
		MusicSearchBar* _tmp10_;
		GtkSearchEntry* _tmp11_;
		GtkSearchEntry* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp9_ = self->priv->search_placeholder;
		_tmp10_ = self->priv->search_bar;
		_tmp11_ = music_search_bar_get_search_entry (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = gtk_editable_get_text ((GtkEditable*) _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strdup_printf (_ ("No Results for “%s”"), _tmp14_);
		_tmp16_ = _tmp15_;
		granite_placeholder_set_title (_tmp9_, _tmp16_);
		_g_free0 (_tmp16_);
	}
}

static void
__music_main_window___lambda30__gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                 gpointer self)
{
	_music_main_window___lambda30_ ((MusicMainWindow*) self);
}

static GObject *
music_main_window_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MusicMainWindow * self;
	Block3Data* _data3_;
	MusicPlaybackManager* _tmp0_;
	MusicPlaybackManager* _tmp1_;
	GtkWindowControls* start_window_controls = NULL;
	GtkWindowControls* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GtkButton* _tmp5_ = NULL;
	GtkButton* _tmp6_;
	MusicPlaybackManager* _tmp7_;
	GListStore* _tmp8_;
	GListStore* _tmp9_;
	MusicSearchBar* _tmp10_;
	MusicSearchBar* _tmp11_;
	GtkWidget* _tmp12_;
	GtkRevealer* _tmp13_ = NULL;
	MusicPlaybackManager* _tmp14_;
	GtkRevealer* _tmp15_;
	GtkHeaderBar* queue_header = NULL;
	GtkRevealer* _tmp16_;
	GtkWidget* _tmp17_;
	GtkHeaderBar* _tmp18_ = NULL;
	GtkHeaderBar* _tmp19_;
	GtkHeaderBar* _tmp20_;
	GtkWindowControls* _tmp21_;
	GtkHeaderBar* _tmp22_;
	GtkButton* _tmp23_;
	GtkHeaderBar* _tmp24_;
	GtkButton* _tmp25_;
	gchar* _tmp26_;
	GThemedIcon* _tmp27_;
	GranitePlaceholder* _tmp28_ = NULL;
	gchar* _tmp29_;
	GThemedIcon* _tmp30_;
	GranitePlaceholder* _tmp31_ = NULL;
	MusicSearchBar* _tmp32_;
	GtkFilterListModel* _tmp33_;
	GtkFilterListModel* _tmp34_;
	GListModel* _tmp35_;
	GtkSingleSelection* _tmp36_;
	GtkSignalListItemFactory* factory = NULL;
	GtkSignalListItemFactory* _tmp37_;
	GtkSingleSelection* _tmp38_;
	GtkSelectionModel* _tmp39_;
	GtkSignalListItemFactory* _tmp40_;
	GtkListItemFactory* _tmp41_;
	GtkListView* _tmp42_ = NULL;
	GtkListView* _tmp43_;
	GtkWidget* _tmp44_;
	GtkScrolledWindow* _tmp45_ = NULL;
	GtkStack* _tmp46_;
	GtkStack* _tmp47_;
	GranitePlaceholder* _tmp48_;
	GtkStack* _tmp49_;
	GranitePlaceholder* _tmp50_;
	GtkStack* _tmp51_;
	GtkScrolledWindow* _tmp52_;
	GtkDropTarget* drop_target = NULL;
	GtkDropTarget* _tmp53_;
	GtkLabel* add_button_label = NULL;
	GtkLabel* _tmp54_;
	GtkBox* add_button_box = NULL;
	GtkBox* _tmp55_;
	GtkBox* _tmp56_;
	GtkImage* _tmp57_;
	GtkImage* _tmp58_;
	GtkBox* _tmp59_;
	GtkLabel* _tmp60_;
	GSimpleAction* open_action = NULL;
	GSimpleAction* _tmp61_;
	GSimpleAction* _tmp62_;
	GtkButton* add_button = NULL;
	GtkBox* _tmp63_;
	GtkWidget* _tmp64_;
	gchar* _tmp65_;
	GtkButton* _tmp66_ = NULL;
	GtkButton* _tmp67_;
	GtkLabel* _tmp68_;
	GtkButton* _tmp69_;
	GtkLabel* clear_button_label = NULL;
	GtkLabel* _tmp70_;
	GtkBox* clear_button_box = NULL;
	GtkBox* _tmp71_;
	GtkBox* _tmp72_;
	GtkImage* _tmp73_;
	GtkImage* _tmp74_;
	GtkBox* _tmp75_;
	GtkLabel* _tmp76_;
	GtkButton* clear_button = NULL;
	GtkBox* _tmp77_;
	GtkWidget* _tmp78_;
	gchar* _tmp79_;
	GtkButton* _tmp80_ = NULL;
	GtkButton* _tmp81_;
	GtkLabel* _tmp82_;
	GtkButton* _tmp83_;
	GtkActionBar* queue_action_bar = NULL;
	GtkActionBar* _tmp84_;
	GtkActionBar* _tmp85_;
	GtkButton* _tmp86_;
	GtkActionBar* _tmp87_;
	GtkButton* _tmp88_;
	AdwToolbarView* queue = NULL;
	GtkStack* _tmp89_;
	GtkWidget* _tmp90_;
	AdwToolbarView* _tmp91_ = NULL;
	AdwToolbarView* _tmp92_;
	GtkDropTarget* _tmp93_;
	GtkEventController* _tmp94_;
	AdwToolbarView* _tmp95_;
	AdwToolbarView* _tmp96_;
	GtkHeaderBar* _tmp97_;
	AdwToolbarView* _tmp98_;
	GtkActionBar* _tmp99_;
	GraniteToast* _tmp100_;
	GtkOverlay* queue_overlay = NULL;
	AdwToolbarView* _tmp101_;
	GtkWidget* _tmp102_;
	GtkOverlay* _tmp103_ = NULL;
	GtkOverlay* _tmp104_;
	GraniteToast* _tmp105_;
	GtkWindowHandle* queue_handle = NULL;
	GtkOverlay* _tmp106_;
	GtkWidget* _tmp107_;
	GtkWindowHandle* _tmp108_ = NULL;
	GtkWindowControls* end_window_controls = NULL;
	GtkWindowControls* _tmp109_;
	GtkHeaderBar* end_header = NULL;
	GtkLabel* _tmp110_;
	GtkHeaderBar* _tmp111_ = NULL;
	GtkHeaderBar* _tmp112_;
	GtkHeaderBar* _tmp113_;
	GtkHeaderBar* _tmp114_;
	GtkWindowControls* _tmp115_;
	MusicNowPlayingView* now_playing_view = NULL;
	MusicNowPlayingView* _tmp116_ = NULL;
	GtkBox* now_playing = NULL;
	GtkBox* _tmp117_;
	GtkBox* _tmp118_;
	GtkHeaderBar* _tmp119_;
	GtkBox* _tmp120_;
	MusicNowPlayingView* _tmp121_;
	GtkWindowHandle* now_playing_handle = NULL;
	GtkBox* _tmp122_;
	GtkWidget* _tmp123_;
	GtkWindowHandle* _tmp124_ = NULL;
	GtkPaned* paned = NULL;
	GtkWindowHandle* _tmp125_;
	GtkWidget* _tmp126_;
	GtkWindowHandle* _tmp127_;
	GtkWidget* _tmp128_;
	GtkPaned* _tmp129_ = NULL;
	GtkPaned* _tmp130_;
	GtkGrid* null_title = NULL;
	GtkGrid* _tmp131_ = NULL;
	GtkGrid* _tmp132_;
	GSettings* _tmp133_;
	GSettings* _tmp134_;
	GtkPaned* _tmp135_;
	GSettings* _tmp136_;
	GtkApplication* app = NULL;
	GApplication* _tmp137_;
	GtkApplication* _tmp138_;
	gchar* _tmp139_;
	gchar** _tmp140_;
	gchar** _tmp141_;
	gint _tmp141__length1;
	GSimpleAction* _tmp142_;
	GtkDropTarget* _tmp143_;
	MusicPlaybackManager* _tmp144_;
	GListStore* _tmp145_;
	GListStore* _tmp146_;
	MusicPlaybackManager* _tmp147_;
	GtkButton* _tmp148_;
	GtkSignalListItemFactory* _tmp149_;
	GtkSignalListItemFactory* _tmp150_;
	GtkListView* _tmp151_;
	GtkSingleSelection* _tmp152_;
	MusicSearchBar* _tmp153_;
	MusicSearchBar* _tmp154_;
	GtkSearchEntry* _tmp155_;
	GtkSearchEntry* _tmp156_;
	parent_class = G_OBJECT_CLASS (music_main_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MUSIC_TYPE_MAIN_WINDOW, MusicMainWindow);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = music_playback_manager_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data3_->playback_manager = _tmp1_;
	_tmp2_ = (GtkWindowControls*) gtk_window_controls_new (GTK_PACK_START);
	g_object_ref_sink (_tmp2_);
	start_window_controls = _tmp2_;
	_tmp3_ = g_strdup (MUSIC_APPLICATION_ACTION_PREFIX MUSIC_APPLICATION_ACTION_SHUFFLE);
	_tmp4_ = g_strdup (_ ("Shuffle"));
	_tmp5_ = (GtkButton*) gtk_button_new_from_icon_name ("media-playlist-shuffle-symbolic");
	gtk_actionable_set_action_name ((GtkActionable*) _tmp5_, _tmp3_);
	_g_free0 (_tmp3_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp5_, _tmp4_);
	_g_free0 (_tmp4_);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->shuffle_button);
	self->priv->shuffle_button = _tmp5_;
	_tmp6_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->repeat_button);
	self->priv->repeat_button = _tmp6_;
	_tmp7_ = _data3_->playback_manager;
	_tmp8_ = music_playback_manager_get_queue_liststore (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = music_search_bar_new ((GListModel*) _tmp9_);
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->search_bar);
	self->priv->search_bar = _tmp10_;
	_tmp11_ = self->priv->search_bar;
	_tmp12_ = _g_object_ref0 ((GtkWidget*) _tmp11_);
	_tmp13_ = (GtkRevealer*) gtk_revealer_new ();
	gtk_revealer_set_child (_tmp13_, _tmp12_);
	_g_object_unref0 (_tmp12_);
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->search_revealer);
	self->priv->search_revealer = _tmp13_;
	_tmp14_ = _data3_->playback_manager;
	_tmp15_ = self->priv->search_revealer;
	g_object_bind_property_with_closures ((GObject*) _tmp14_, "has-items", (GObject*) _tmp15_, "reveal-child", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp16_ = self->priv->search_revealer;
	_tmp17_ = _g_object_ref0 ((GtkWidget*) _tmp16_);
	_tmp18_ = (GtkHeaderBar*) gtk_header_bar_new ();
	gtk_header_bar_set_show_title_buttons (_tmp18_, FALSE);
	gtk_header_bar_set_title_widget (_tmp18_, _tmp17_);
	_g_object_unref0 (_tmp17_);
	g_object_ref_sink (_tmp18_);
	queue_header = _tmp18_;
	_tmp19_ = queue_header;
	gtk_widget_add_css_class ((GtkWidget*) _tmp19_, GRANITE_STYLE_CLASS_DEFAULT_DECORATION);
	_tmp20_ = queue_header;
	_tmp21_ = start_window_controls;
	gtk_header_bar_pack_start (_tmp20_, (GtkWidget*) _tmp21_);
	_tmp22_ = queue_header;
	_tmp23_ = self->priv->shuffle_button;
	gtk_header_bar_pack_end (_tmp22_, (GtkWidget*) _tmp23_);
	_tmp24_ = queue_header;
	_tmp25_ = self->priv->repeat_button;
	gtk_header_bar_pack_end (_tmp24_, (GtkWidget*) _tmp25_);
	_tmp26_ = g_strdup (_ ("Audio files opened from Files will appear here"));
	_tmp27_ = (GThemedIcon*) g_themed_icon_new ("playlist-queue");
	_tmp28_ = granite_placeholder_new (_ ("Queue is Empty"));
	granite_placeholder_set_description (_tmp28_, _tmp26_);
	_g_free0 (_tmp26_);
	granite_placeholder_set_icon (_tmp28_, (GIcon*) _tmp27_);
	_g_object_unref0 (_tmp27_);
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (self->priv->queue_placeholder);
	self->priv->queue_placeholder = _tmp28_;
	_tmp29_ = g_strdup (_ ("Try changing search terms"));
	_tmp30_ = (GThemedIcon*) g_themed_icon_new ("edit-find-symbolic");
	_tmp31_ = granite_placeholder_new ("");
	granite_placeholder_set_description (_tmp31_, _tmp29_);
	_g_free0 (_tmp29_);
	granite_placeholder_set_icon (_tmp31_, (GIcon*) _tmp30_);
	_g_object_unref0 (_tmp30_);
	g_object_ref_sink (_tmp31_);
	_g_object_unref0 (self->priv->search_placeholder);
	self->priv->search_placeholder = _tmp31_;
	_tmp32_ = self->priv->search_bar;
	_tmp33_ = music_search_bar_get_filter_model (_tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = _g_object_ref0 ((GListModel*) _tmp34_);
	_tmp36_ = gtk_single_selection_new (_tmp35_);
	_g_object_unref0 (self->priv->selection_model);
	self->priv->selection_model = _tmp36_;
	_tmp37_ = (GtkSignalListItemFactory*) gtk_signal_list_item_factory_new ();
	factory = _tmp37_;
	_tmp38_ = self->priv->selection_model;
	_tmp39_ = _g_object_ref0 ((GtkSelectionModel*) _tmp38_);
	_tmp40_ = factory;
	_tmp41_ = _g_object_ref0 ((GtkListItemFactory*) _tmp40_);
	_tmp42_ = (GtkListView*) gtk_list_view_new (_tmp39_, _tmp41_);
	gtk_list_view_set_single_click_activate (_tmp42_, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp42_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp42_, TRUE);
	g_object_ref_sink (_tmp42_);
	_g_object_unref0 (self->priv->queue_listview);
	self->priv->queue_listview = _tmp42_;
	_tmp43_ = self->priv->queue_listview;
	_tmp44_ = _g_object_ref0 ((GtkWidget*) _tmp43_);
	_tmp45_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	gtk_scrolled_window_set_child (_tmp45_, _tmp44_);
	_g_object_unref0 (_tmp44_);
	g_object_ref_sink (_tmp45_);
	_g_object_unref0 (self->priv->scrolled);
	self->priv->scrolled = _tmp45_;
	_tmp46_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp46_);
	_g_object_unref0 (self->priv->queue_stack);
	self->priv->queue_stack = _tmp46_;
	_tmp47_ = self->priv->queue_stack;
	_tmp48_ = self->priv->queue_placeholder;
	gtk_stack_add_child (_tmp47_, (GtkWidget*) _tmp48_);
	_tmp49_ = self->priv->queue_stack;
	_tmp50_ = self->priv->search_placeholder;
	gtk_stack_add_child (_tmp49_, (GtkWidget*) _tmp50_);
	_tmp51_ = self->priv->queue_stack;
	_tmp52_ = self->priv->scrolled;
	gtk_stack_add_child (_tmp51_, (GtkWidget*) _tmp52_);
	_tmp53_ = gtk_drop_target_new (gdk_file_list_get_type (), GDK_ACTION_COPY);
	drop_target = _tmp53_;
	_tmp54_ = (GtkLabel*) gtk_label_new (_ ("Open Files…"));
	g_object_ref_sink (_tmp54_);
	add_button_label = _tmp54_;
	_tmp55_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp55_);
	add_button_box = _tmp55_;
	_tmp56_ = add_button_box;
	_tmp57_ = (GtkImage*) gtk_image_new_from_icon_name ("document-open-symbolic");
	g_object_ref_sink (_tmp57_);
	_tmp58_ = _tmp57_;
	gtk_box_append (_tmp56_, (GtkWidget*) _tmp58_);
	_g_object_unref0 (_tmp58_);
	_tmp59_ = add_button_box;
	_tmp60_ = add_button_label;
	gtk_box_append (_tmp59_, (GtkWidget*) _tmp60_);
	_tmp61_ = g_simple_action_new (MUSIC_MAIN_WINDOW_ACTION_OPEN, NULL);
	open_action = _tmp61_;
	_tmp62_ = open_action;
	g_signal_connect_object (_tmp62_, "activate", (GCallback) _music_main_window_open_files_g_simple_action_activate, self, 0);
	_tmp63_ = add_button_box;
	_tmp64_ = _g_object_ref0 ((GtkWidget*) _tmp63_);
	_tmp65_ = g_strdup (MUSIC_MAIN_WINDOW_ACTION_PREFIX MUSIC_MAIN_WINDOW_ACTION_OPEN);
	_tmp66_ = (GtkButton*) gtk_button_new ();
	gtk_button_set_child (_tmp66_, _tmp64_);
	_g_object_unref0 (_tmp64_);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp66_, _tmp65_);
	_g_free0 (_tmp65_);
	g_object_ref_sink (_tmp66_);
	add_button = _tmp66_;
	_tmp67_ = add_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp67_, GRANITE_STYLE_CLASS_FLAT);
	_tmp68_ = add_button_label;
	_tmp69_ = add_button;
	gtk_label_set_mnemonic_widget (_tmp68_, (GtkWidget*) _tmp69_);
	_tmp70_ = (GtkLabel*) gtk_label_new (_ ("Clear Queue"));
	g_object_ref_sink (_tmp70_);
	clear_button_label = _tmp70_;
	_tmp71_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp71_);
	clear_button_box = _tmp71_;
	_tmp72_ = clear_button_box;
	_tmp73_ = (GtkImage*) gtk_image_new_from_icon_name ("edit-clear-all-symbolic");
	g_object_ref_sink (_tmp73_);
	_tmp74_ = _tmp73_;
	gtk_box_append (_tmp72_, (GtkWidget*) _tmp74_);
	_g_object_unref0 (_tmp74_);
	_tmp75_ = clear_button_box;
	_tmp76_ = clear_button_label;
	gtk_box_append (_tmp75_, (GtkWidget*) _tmp76_);
	_tmp77_ = clear_button_box;
	_tmp78_ = _g_object_ref0 ((GtkWidget*) _tmp77_);
	_tmp79_ = g_strdup (MUSIC_APPLICATION_ACTION_PREFIX MUSIC_APPLICATION_ACTION_CLEAR_QUEUE);
	_tmp80_ = (GtkButton*) gtk_button_new ();
	gtk_button_set_child (_tmp80_, _tmp78_);
	_g_object_unref0 (_tmp78_);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp80_, _tmp79_);
	_g_free0 (_tmp79_);
	g_object_ref_sink (_tmp80_);
	clear_button = _tmp80_;
	_tmp81_ = clear_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp81_, GRANITE_STYLE_CLASS_FLAT);
	_tmp82_ = clear_button_label;
	_tmp83_ = clear_button;
	gtk_label_set_mnemonic_widget (_tmp82_, (GtkWidget*) _tmp83_);
	_tmp84_ = (GtkActionBar*) gtk_action_bar_new ();
	g_object_ref_sink (_tmp84_);
	queue_action_bar = _tmp84_;
	_tmp85_ = queue_action_bar;
	_tmp86_ = add_button;
	gtk_action_bar_pack_start (_tmp85_, (GtkWidget*) _tmp86_);
	_tmp87_ = queue_action_bar;
	_tmp88_ = clear_button;
	gtk_action_bar_pack_end (_tmp87_, (GtkWidget*) _tmp88_);
	_tmp89_ = self->priv->queue_stack;
	_tmp90_ = _g_object_ref0 ((GtkWidget*) _tmp89_);
	_tmp91_ = (AdwToolbarView*) adw_toolbar_view_new ();
	adw_toolbar_view_set_bottom_bar_style (_tmp91_, ADW_TOOLBAR_RAISED);
	adw_toolbar_view_set_content (_tmp91_, _tmp90_);
	_g_object_unref0 (_tmp90_);
	g_object_ref_sink (_tmp91_);
	queue = _tmp91_;
	_tmp92_ = queue;
	_tmp93_ = drop_target;
	_tmp94_ = _g_object_ref0 ((GtkEventController*) _tmp93_);
	gtk_widget_add_controller ((GtkWidget*) _tmp92_, _tmp94_);
	_tmp95_ = queue;
	gtk_widget_add_css_class ((GtkWidget*) _tmp95_, GRANITE_STYLE_CLASS_VIEW);
	_tmp96_ = queue;
	_tmp97_ = queue_header;
	adw_toolbar_view_add_top_bar (_tmp96_, (GtkWidget*) _tmp97_);
	_tmp98_ = queue;
	_tmp99_ = queue_action_bar;
	adw_toolbar_view_add_bottom_bar (_tmp98_, (GtkWidget*) _tmp99_);
	_tmp100_ = granite_toast_new ("");
	g_object_ref_sink (_tmp100_);
	_data3_->error_toast = _tmp100_;
	_tmp101_ = queue;
	_tmp102_ = _g_object_ref0 ((GtkWidget*) _tmp101_);
	_tmp103_ = (GtkOverlay*) gtk_overlay_new ();
	gtk_overlay_set_child (_tmp103_, _tmp102_);
	_g_object_unref0 (_tmp102_);
	g_object_ref_sink (_tmp103_);
	queue_overlay = _tmp103_;
	_tmp104_ = queue_overlay;
	_tmp105_ = _data3_->error_toast;
	gtk_overlay_add_overlay (_tmp104_, (GtkWidget*) _tmp105_);
	_tmp106_ = queue_overlay;
	_tmp107_ = _g_object_ref0 ((GtkWidget*) _tmp106_);
	_tmp108_ = (GtkWindowHandle*) gtk_window_handle_new ();
	gtk_window_handle_set_child (_tmp108_, _tmp107_);
	_g_object_unref0 (_tmp107_);
	g_object_ref_sink (_tmp108_);
	queue_handle = _tmp108_;
	_tmp109_ = (GtkWindowControls*) gtk_window_controls_new (GTK_PACK_END);
	g_object_ref_sink (_tmp109_);
	end_window_controls = _tmp109_;
	_tmp110_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp110_);
	_tmp111_ = (GtkHeaderBar*) gtk_header_bar_new ();
	gtk_header_bar_set_show_title_buttons (_tmp111_, FALSE);
	gtk_header_bar_set_title_widget (_tmp111_, (GtkWidget*) _tmp110_);
	_g_object_unref0 (_tmp110_);
	g_object_ref_sink (_tmp111_);
	end_header = _tmp111_;
	_tmp112_ = end_header;
	gtk_widget_add_css_class ((GtkWidget*) _tmp112_, GRANITE_STYLE_CLASS_FLAT);
	_tmp113_ = end_header;
	gtk_widget_add_css_class ((GtkWidget*) _tmp113_, GRANITE_STYLE_CLASS_DEFAULT_DECORATION);
	_tmp114_ = end_header;
	_tmp115_ = end_window_controls;
	gtk_header_bar_pack_end (_tmp114_, (GtkWidget*) _tmp115_);
	_tmp116_ = music_now_playing_view_new ();
	gtk_widget_set_margin_top ((GtkWidget*) _tmp116_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp116_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp116_, 24);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp116_, 12);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp116_, TRUE);
	g_object_ref_sink (_tmp116_);
	now_playing_view = _tmp116_;
	_tmp117_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp117_);
	now_playing = _tmp117_;
	_tmp118_ = now_playing;
	_tmp119_ = end_header;
	gtk_box_append (_tmp118_, (GtkWidget*) _tmp119_);
	_tmp120_ = now_playing;
	_tmp121_ = now_playing_view;
	gtk_box_append (_tmp120_, (GtkWidget*) _tmp121_);
	_tmp122_ = now_playing;
	_tmp123_ = _g_object_ref0 ((GtkWidget*) _tmp122_);
	_tmp124_ = (GtkWindowHandle*) gtk_window_handle_new ();
	gtk_window_handle_set_child (_tmp124_, _tmp123_);
	_g_object_unref0 (_tmp123_);
	g_object_ref_sink (_tmp124_);
	now_playing_handle = _tmp124_;
	_tmp125_ = queue_handle;
	_tmp126_ = _g_object_ref0 ((GtkWidget*) _tmp125_);
	_tmp127_ = now_playing_handle;
	_tmp128_ = _g_object_ref0 ((GtkWidget*) _tmp127_);
	_tmp129_ = (GtkPaned*) gtk_paned_new (GTK_ORIENTATION_HORIZONTAL);
	gtk_paned_set_start_child (_tmp129_, _tmp126_);
	_g_object_unref0 (_tmp126_);
	gtk_paned_set_end_child (_tmp129_, _tmp128_);
	_g_object_unref0 (_tmp128_);
	gtk_paned_set_resize_end_child (_tmp129_, FALSE);
	gtk_paned_set_shrink_end_child (_tmp129_, FALSE);
	gtk_paned_set_shrink_start_child (_tmp129_, FALSE);
	g_object_ref_sink (_tmp129_);
	paned = _tmp129_;
	_tmp130_ = paned;
	gtk_window_set_child ((GtkWindow*) self, (GtkWidget*) _tmp130_);
	_tmp131_ = (GtkGrid*) gtk_grid_new ();
	gtk_widget_set_visible ((GtkWidget*) _tmp131_, FALSE);
	g_object_ref_sink (_tmp131_);
	null_title = _tmp131_;
	_tmp132_ = null_title;
	gtk_window_set_titlebar ((GtkWindow*) self, (GtkWidget*) _tmp132_);
	_tmp133_ = g_settings_new ("io.elementary.music");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp133_;
	_tmp134_ = self->priv->settings;
	_tmp135_ = paned;
	g_settings_bind (_tmp134_, "pane-position", (GObject*) _tmp135_, "position", G_SETTINGS_BIND_DEFAULT);
	_tmp136_ = self->priv->settings;
	g_signal_connect_object (_tmp136_, "changed::repeat-mode", (GCallback) _music_main_window_update_repeat_button_g_settings_changed, self, 0);
	music_main_window_update_repeat_button (self);
	_tmp137_ = g_application_get_default ();
	app = G_TYPE_CHECK_INSTANCE_CAST (_tmp137_, gtk_application_get_type (), GtkApplication);
	_tmp138_ = app;
	_tmp139_ = g_strdup ("<Ctrl>O");
	_tmp140_ = g_new0 (gchar*, 1 + 1);
	_tmp140_[0] = _tmp139_;
	_tmp141_ = _tmp140_;
	_tmp141__length1 = 1;
	gtk_application_set_accels_for_action (_tmp138_, MUSIC_MAIN_WINDOW_ACTION_PREFIX MUSIC_MAIN_WINDOW_ACTION_OPEN, _tmp141_);
	_tmp141_ = (_vala_array_free (_tmp141_, _tmp141__length1, (GDestroyNotify) g_free), NULL);
	_tmp142_ = open_action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp142_);
	_tmp143_ = drop_target;
	g_signal_connect_object (_tmp143_, "drop", (GCallback) __music_main_window___lambda16__gtk_drop_target_drop, self, 0);
	_tmp144_ = _data3_->playback_manager;
	_tmp145_ = music_playback_manager_get_queue_liststore (_tmp144_);
	_tmp146_ = _tmp145_;
	g_signal_connect_data ((GListModel*) _tmp146_, "items-changed", (GCallback) __music_main_window___lambda17__g_list_model_items_changed, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp147_ = _data3_->playback_manager;
	g_signal_connect_data (_tmp147_, "invalids-found", (GCallback) __music_main_window___lambda18__music_playback_manager_invalids_found, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp148_ = self->priv->repeat_button;
	g_signal_connect_object (_tmp148_, "clicked", (GCallback) __music_main_window___lambda19__gtk_button_clicked, self, 0);
	_tmp149_ = factory;
	g_signal_connect_object (_tmp149_, "setup", (GCallback) __music_main_window___lambda20__gtk_signal_list_item_factory_setup, self, 0);
	_tmp150_ = factory;
	g_signal_connect_object (_tmp150_, "bind", (GCallback) __music_main_window___lambda27__gtk_signal_list_item_factory_bind, self, 0);
	_tmp151_ = self->priv->queue_listview;
	g_signal_connect_data (_tmp151_, "activate", (GCallback) __music_main_window___lambda28__gtk_list_view_activate, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp152_ = self->priv->selection_model;
	g_signal_connect_object ((GListModel*) _tmp152_, "items-changed", (GCallback) _music_main_window_on_items_changed_g_list_model_items_changed, self, 0);
	_tmp153_ = self->priv->search_bar;
	g_signal_connect_data (_tmp153_, "activated", (GCallback) __music_main_window___lambda29__music_search_bar_activated, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp154_ = self->priv->search_bar;
	_tmp155_ = music_search_bar_get_search_entry (_tmp154_);
	_tmp156_ = _tmp155_;
	g_signal_connect_object (_tmp156_, "search-changed", (GCallback) __music_main_window___lambda30__gtk_search_entry_search_changed, self, 0);
	_g_object_unref0 (null_title);
	_g_object_unref0 (paned);
	_g_object_unref0 (now_playing_handle);
	_g_object_unref0 (now_playing);
	_g_object_unref0 (now_playing_view);
	_g_object_unref0 (end_header);
	_g_object_unref0 (end_window_controls);
	_g_object_unref0 (queue_handle);
	_g_object_unref0 (queue_overlay);
	_g_object_unref0 (queue);
	_g_object_unref0 (queue_action_bar);
	_g_object_unref0 (clear_button);
	_g_object_unref0 (clear_button_box);
	_g_object_unref0 (clear_button_label);
	_g_object_unref0 (add_button);
	_g_object_unref0 (open_action);
	_g_object_unref0 (add_button_box);
	_g_object_unref0 (add_button_label);
	_g_object_unref0 (drop_target);
	_g_object_unref0 (factory);
	_g_object_unref0 (queue_header);
	_g_object_unref0 (start_window_controls);
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return obj;
}

static void
music_main_window_class_init (MusicMainWindowClass * klass,
                              gpointer klass_data)
{
	music_main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MusicMainWindow_private_offset);
	G_OBJECT_CLASS (klass)->constructor = music_main_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = music_main_window_finalize;
}

static void
music_main_window_instance_init (MusicMainWindow * self,
                                 gpointer klass)
{
	self->priv = music_main_window_get_instance_private (self);
}

static void
music_main_window_finalize (GObject * obj)
{
	MusicMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MUSIC_TYPE_MAIN_WINDOW, MusicMainWindow);
	_g_object_unref0 (self->priv->queue_placeholder);
	_g_object_unref0 (self->priv->search_placeholder);
	_g_object_unref0 (self->priv->repeat_button);
	_g_object_unref0 (self->priv->shuffle_button);
	_g_object_unref0 (self->priv->search_bar);
	_g_object_unref0 (self->priv->queue_listview);
	_g_object_unref0 (self->priv->search_revealer);
	_g_object_unref0 (self->priv->scrolled);
	_g_object_unref0 (self->priv->selection_model);
	_g_object_unref0 (self->priv->queue_stack);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (music_main_window_parent_class)->finalize (obj);
}

static GType
music_main_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MusicMainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) music_main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MusicMainWindow), 0, (GInstanceInitFunc) music_main_window_instance_init, NULL };
	GType music_main_window_type_id;
	music_main_window_type_id = g_type_register_static (gtk_application_window_get_type (), "MusicMainWindow", &g_define_type_info, 0);
	MusicMainWindow_private_offset = g_type_add_instance_private (music_main_window_type_id, sizeof (MusicMainWindowPrivate));
	return music_main_window_type_id;
}

GType
music_main_window_get_type (void)
{
	static volatile gsize music_main_window_type_id__once = 0;
	if (g_once_init_enter (&music_main_window_type_id__once)) {
		GType music_main_window_type_id;
		music_main_window_type_id = music_main_window_get_type_once ();
		g_once_init_leave (&music_main_window_type_id__once, music_main_window_type_id);
	}
	return music_main_window_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

