/* Util.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Util.vala, do not modify */

/*
* Copyright 2019 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
*/

#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <libecal/libecal.h>
#include <libedataserver/libedataserver.h>
#include <glib-object.h>
#include <libical-glib/libical-glib.h>
#include <float.h>
#include <math.h>
#include <granite-7.h>
#include <glib/gi18n-lib.h>
#include <geocode-glib/geocode-glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_ECalComponentId_free0(var) ((var == NULL) ? NULL : (var = (_vala_ECalComponentId_free (var), NULL)))

#define TASKS_TYPE_TASK_MODEL (tasks_task_model_get_type ())
#define TASKS_TASK_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKS_TYPE_TASK_MODEL, TasksTaskModel))
#define TASKS_TASK_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKS_TYPE_TASK_MODEL, TasksTaskModelClass))
#define TASKS_IS_TASK_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKS_TYPE_TASK_MODEL))
#define TASKS_IS_TASK_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKS_TYPE_TASK_MODEL))
#define TASKS_TASK_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKS_TYPE_TASK_MODEL, TasksTaskModelClass))

typedef struct _TasksTaskModel TasksTaskModel;
typedef struct _TasksTaskModelClass TasksTaskModelClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define TASKS_TYPE_LOCATION (tasks_location_get_type ())
typedef struct _TasksLocation TasksLocation;
typedef enum  {
	TASKS_LOCATION_PROXIMITY_ARRIVE,
	TASKS_LOCATION_PROXIMITY_DEPART
} TasksLocationProximity;

#define TASKS_TYPE_LOCATION_PROXIMITY (tasks_location_proximity_get_type ())
#define __vala_ECalComponentAlarmTrigger_free0(var) ((var == NULL) ? NULL : (var = (_vala_ECalComponentAlarmTrigger_free (var), NULL)))
#define __vala_ECalComponentAlarm_free0(var) ((var == NULL) ? NULL : (var = (_vala_ECalComponentAlarm_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _TasksLocation {
	gchar* postal_address;
	gchar* display_name;
	gdouble longitude;
	gdouble latitude;
	gint accuracy;
	TasksLocationProximity proximity;
};

VALA_EXTERN GRegex* tasks_util_line_break_to_space_regex;
GRegex* tasks_util_line_break_to_space_regex = NULL;
VALA_EXTERN TasksTaskModel* tasks_application_model;

VALA_EXTERN gchar* tasks_util_line_break_to_space (const gchar* str);
VALA_EXTERN gboolean tasks_util_calcomponent_equal_func (ECalComponent* a,
                                             ECalComponent* b);
static void _vala_ECalComponentId_free (ECalComponentId* self);
VALA_EXTERN gboolean tasks_util_esource_equal_func (ESource* a,
                                        ESource* b);
VALA_EXTERN guint tasks_util_esource_hash_func (ESource* source);
VALA_EXTERN gchar* tasks_util_get_esource_collection_display_name (ESource* source);
VALA_EXTERN GType tasks_task_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TasksTaskModel, g_object_unref)
VALA_EXTERN ESourceRegistry* tasks_task_model_get_registry_sync (TasksTaskModel* self,
                                                     GError** error);
VALA_EXTERN ICalTime* tasks_util_datetimes_to_icaltime (GDateTime* date,
                                            GDateTime* time_local,
                                            ICalTimezone* timezone);
VALA_EXTERN GTimeZone* tasks_util_icaltime_get_timezone (ICalTime* date);
VALA_EXTERN GDateTime* tasks_util_ical_to_date_time (ICalTime* date);
VALA_EXTERN GDateTime* tasks_util_ical_to_date_time_local (ICalTime* date);
VALA_EXTERN ICalTime* tasks_util_ical_convert_to_local (ICalTime* time);
VALA_EXTERN gchar* tasks_util_get_relative_date (GDateTime* date_time);
VALA_EXTERN gchar* tasks_util_get_gtasks_position_property_value (ECalComponent* ecalcomponent);
VALA_EXTERN gchar* tasks_util_get_apple_sortorder_property_value (ECalComponent* ecalcomponent);
VALA_EXTERN ICalDuration* tasks_util_get_apple_sortorder_default_value (ECalComponent* ecalcomponent);
VALA_EXTERN GType tasks_location_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType tasks_location_proximity_get_type (void) G_GNUC_CONST ;
VALA_EXTERN TasksLocation* tasks_location_dup (const TasksLocation* self);
VALA_EXTERN void tasks_location_free (TasksLocation* self);
VALA_EXTERN void tasks_location_copy (const TasksLocation* self,
                          TasksLocation* dest);
VALA_EXTERN void tasks_location_destroy (TasksLocation* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (TasksLocation, tasks_location_destroy)
VALA_EXTERN TasksLocation* tasks_util_get_ecalcomponent_location (ECalComponent* ecalcomponent);
static void _vala_ECalComponentAlarm_free (ECalComponentAlarm* self);
static void __vala_ECalComponentAlarm_free0_ (gpointer var);
static inline void _g_slist_free___vala_ECalComponentAlarm_free0_ (GSList* self);
VALA_EXTERN TasksLocationProximity tasks_location_proximity_from_string (const gchar* val);
VALA_EXTERN void tasks_util_set_ecalcomponent_location (ECalComponent* ecalcomponent,
                                            TasksLocation* location);
VALA_EXTERN const gchar* tasks_location_proximity_to_string (TasksLocationProximity self);
static void _vala_ECalComponentAlarmTrigger_free (ECalComponentAlarmTrigger* self);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

gchar*
tasks_util_line_break_to_space (const gchar* str)
{
	GRegex* _tmp0_;
	gchar* _tmp14_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = tasks_util_line_break_to_space_regex;
	if (_tmp0_ == NULL) {
		{
			GRegex* _tmp1_ = NULL;
			GRegex* _tmp2_;
			GRegex* _tmp3_;
			_tmp2_ = g_regex_new ("(^\\s+|\\s+$|\n|\\s\\s+)", 0, 0, &_inner_error0_);
			_tmp1_ = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch0_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp3_ = _tmp1_;
			_tmp1_ = NULL;
			_g_regex_unref0 (tasks_util_line_break_to_space_regex);
			tasks_util_line_break_to_space_regex = _tmp3_;
			_g_regex_unref0 (_tmp1_);
		}
		goto __finally0;
		__catch0_g_regex_error:
		{
			GError* e = NULL;
			GError* _tmp4_;
			const gchar* _tmp5_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp4_ = e;
			_tmp5_ = _tmp4_->message;
			g_critical ("Util.vala:34: %s", _tmp5_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	{
		gchar* _tmp6_ = NULL;
		GRegex* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp7_ = tasks_util_line_break_to_space_regex;
		_tmp8_ = strlen (str);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_regex_replace (_tmp7_, str, (gssize) _tmp9_, 0, " ", 0, &_inner_error0_);
		_tmp6_ = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp11_ = _tmp6_;
		_tmp6_ = NULL;
		result = _tmp11_;
		_g_free0 (_tmp6_);
		return result;
	}
	goto __finally1;
	__catch1_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_warning ("Util.vala:41: %s", _tmp13_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp14_ = g_strdup (str);
	result = _tmp14_;
	return result;
}

static void
_vala_ECalComponentId_free (ECalComponentId* self)
{
	g_boxed_free (e_cal_component_id_get_type (), self);
}

gboolean
tasks_util_calcomponent_equal_func (ECalComponent* a,
                                    ECalComponent* b)
{
	ECalComponentId* _tmp0_;
	ECalComponentId* _tmp1_;
	ECalComponentId* _tmp2_;
	ECalComponentId* _tmp3_;
	gboolean _tmp4_;
	gboolean result;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp0_ = e_cal_component_get_id (a);
	_tmp1_ = _tmp0_;
	_tmp2_ = e_cal_component_get_id (b);
	_tmp3_ = _tmp2_;
	_tmp4_ = e_cal_component_id_equal (_tmp1_, _tmp3_);
	__vala_ECalComponentId_free0 (_tmp3_);
	__vala_ECalComponentId_free0 (_tmp1_);
	result = _tmp4_;
	return result;
}

gboolean
tasks_util_esource_equal_func (ESource* a,
                               ESource* b)
{
	gboolean result;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	result = e_source_equal (a, b);
	return result;
}

guint
tasks_util_esource_hash_func (ESource* source)
{
	guint result;
	g_return_val_if_fail (source != NULL, 0U);
	result = e_source_hash (source);
	return result;
}

gchar*
tasks_util_get_esource_collection_display_name (ESource* source)
{
	gchar* display_name = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (source != NULL, NULL);
	_tmp0_ = g_strdup ("");
	display_name = _tmp0_;
	{
		ESourceRegistry* registry = NULL;
		TasksTaskModel* _tmp1_;
		ESourceRegistry* _tmp2_;
		ESource* collection_source = NULL;
		ESource* _tmp3_;
		ESource* _tmp4_;
		_tmp1_ = tasks_application_model;
		_tmp2_ = tasks_task_model_get_registry_sync (_tmp1_, &_inner_error0_);
		registry = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = e_source_registry_find_extension (registry, source, E_SOURCE_EXTENSION_COLLECTION);
		collection_source = _tmp3_;
		_tmp4_ = collection_source;
		if (_tmp4_ != NULL) {
			ESource* _tmp5_;
			const gchar* _tmp6_;
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp5_ = collection_source;
			_tmp6_ = e_source_get_display_name (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = g_strdup (_tmp7_);
			_g_free0 (display_name);
			display_name = _tmp8_;
		} else {
			if (e_source_has_extension (source, E_SOURCE_EXTENSION_TASK_LIST)) {
				ESourceExtension* _tmp9_;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				gchar* _tmp12_;
				_tmp9_ = e_source_get_extension (source, E_SOURCE_EXTENSION_TASK_LIST);
				_tmp10_ = e_source_backend_get_backend_name ((ESourceBackend*) G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, e_source_task_list_get_type (), ESourceTaskList));
				_tmp11_ = _tmp10_;
				_tmp12_ = g_strdup (_tmp11_);
				_g_free0 (display_name);
				display_name = _tmp12_;
			}
		}
		_g_object_unref0 (collection_source);
		_g_object_unref0 (registry);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_warning ("Util.vala:80: %s", _tmp14_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (display_name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = display_name;
	return result;
}

/**
     * Converts two DateTimes representing a date and a time to one TimeType.
     *
     * The first contains the date; its time settings are ignored. The second
     * one contains the time itself; its date settings are ignored. If the time
     * is `null`, the resulting TimeType is of `DATE` type; if it is given, the
     * TimeType is of `DATE-TIME` type.
     *
     * This also accepts an optional `timezone` argument. If it is given a
     * timezone, the resulting TimeType will be relative to the given timezone.
     * If it is `null`, the resulting TimeType will be "floating" with no
     * timezone. If the argument is not given, it will default to the system
     * timezone.
     */
ICalTime*
tasks_util_datetimes_to_icaltime (GDateTime* date,
                                  GDateTime* time_local,
                                  ICalTimezone* timezone)
{
	ICalTime* _result_ = NULL;
	ICalTime* _tmp0_;
	ICalTime* result;
	g_return_val_if_fail (date != NULL, NULL);
	_tmp0_ = i_cal_time_new_from_day_of_year (g_date_time_get_day_of_year (date), g_date_time_get_year (date));
	_result_ = _tmp0_;
	if (time_local == NULL) {
		ICalTime* _tmp1_;
		ICalTime* _tmp2_;
		_tmp1_ = _result_;
		i_cal_time_set_is_date (_tmp1_, TRUE);
		_tmp2_ = _result_;
		i_cal_time_set_time (_tmp2_, 0, 0, 0);
	} else {
		ICalTime* _tmp3_;
		ICalTime* _tmp4_;
		ICalTime* _tmp5_;
		ICalTime* _tmp6_;
		const gchar* _tmp7_;
		ICalTime* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = _result_;
		i_cal_time_set_is_date (_tmp3_, FALSE);
		_tmp4_ = _result_;
		i_cal_time_set_timezone (_tmp4_, timezone);
		_tmp5_ = _result_;
		i_cal_time_set_time (_tmp5_, g_date_time_get_hour (time_local), g_date_time_get_minute (time_local), g_date_time_get_second (time_local));
		_tmp6_ = _result_;
		_tmp7_ = i_cal_time_get_tzid (_tmp6_);
		g_debug ("Util.vala:125: %s", _tmp7_);
		_tmp8_ = _result_;
		_tmp9_ = i_cal_time_as_ical_string (_tmp8_);
		_tmp10_ = _tmp9_;
		g_debug ("Util.vala:126: %s", _tmp10_);
		_g_free0 (_tmp10_);
	}
	result = _result_;
	return result;
}

/**
     * Gets the timezone of the given TimeType as a GLib.TimeZone.
     *
     * For floating times, returns the local timezone.
     * Dates (with no time component) are considered floating.
     */
static const gchar*
string_offset (const gchar* self,
               glong offset)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (const gchar*) (((gchar*) self) + offset);
	return result;
}

static GTimeZone*
vala_g_time_zone_new_identifier (const gchar* identifier,
                                 GError** error)
{
	GTimeZone* self;
	GError* _inner_error0_ = NULL;
	self = (GTimeZone*) g_time_zone_new_identifier (identifier);
	if (((GTimeZone*) self) == NULL) {
		GError* _tmp0_;
		_tmp0_ = g_error_new_literal (G_CONVERT_ERROR, G_CONVERT_ERROR_ILLEGAL_SEQUENCE, "Invalid identifier argument");
		_inner_error0_ = _tmp0_;
		g_propagate_error (error, _inner_error0_);
		_g_time_zone_unref0 (self);
		return NULL;
	}
	return self;
}

GTimeZone*
tasks_util_icaltime_get_timezone (ICalTime* date)
{
	gchar* tzid = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp6_;
	ICalTimezone* timezone = NULL;
	gboolean _tmp22_ = FALSE;
	ICalTimezone* _tmp23_;
	ICalTimezone* _tmp26_;
	gint is_daylight = 0;
	gint interval = 0;
	ICalTimezone* _tmp28_;
	gint _tmp29_ = 0;
	gint _tmp30_;
	gboolean is_positive = FALSE;
	gint hours = 0;
	gint minutes = 0;
	const gchar* _tmp31_ = NULL;
	gchar* hour_string = NULL;
	gchar* _tmp32_;
	GError* _inner_error0_ = NULL;
	GTimeZone* result;
	g_return_val_if_fail (date != NULL, NULL);
	if (i_cal_time_is_date (date)) {
		GTimeZone* _tmp0_;
		_tmp0_ = g_time_zone_new_local ();
		result = _tmp0_;
		return result;
	}
	_tmp1_ = i_cal_time_get_tzid (date);
	_tmp2_ = g_strdup (_tmp1_);
	tzid = _tmp2_;
	_tmp3_ = tzid;
	if (_tmp3_ == NULL) {
		ICalTimezone* _tmp4_;
		GTimeZone* _tmp5_;
		_tmp4_ = i_cal_time_get_timezone (date);
		_vala_assert (_tmp4_ == NULL, "date.get_timezone () == null");
		_tmp5_ = g_time_zone_new_local ();
		result = _tmp5_;
		_g_free0 (tzid);
		return result;
	}
	_tmp6_ = tzid;
	if (_tmp6_ != NULL) {
		{
			gchar* prefix = NULL;
			gchar* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			_tmp7_ = g_strdup ("/freeassociation.sourceforge.net/");
			prefix = _tmp7_;
			_tmp8_ = tzid;
			_tmp9_ = prefix;
			if (g_str_has_prefix (_tmp8_, _tmp9_)) {
				GTimeZone* _tmp10_ = NULL;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				const gchar* _tmp15_;
				GTimeZone* _tmp16_;
				GTimeZone* _tmp17_;
				_tmp11_ = tzid;
				_tmp12_ = prefix;
				_tmp13_ = strlen (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = string_offset (_tmp11_, (glong) _tmp14_);
				_tmp16_ = vala_g_time_zone_new_identifier (_tmp15_, &_inner_error0_);
				_tmp10_ = _tmp16_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (prefix);
					goto __catch0_g_error;
				}
				_tmp17_ = _tmp10_;
				_tmp10_ = NULL;
				result = _tmp17_;
				_g_time_zone_unref0 (_tmp10_);
				_g_free0 (prefix);
				_g_free0 (tzid);
				return result;
			} else {
				GTimeZone* _tmp18_ = NULL;
				const gchar* _tmp19_;
				GTimeZone* _tmp20_;
				GTimeZone* _tmp21_;
				_tmp19_ = tzid;
				_tmp20_ = vala_g_time_zone_new_identifier (_tmp19_, &_inner_error0_);
				_tmp18_ = _tmp20_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (prefix);
					goto __catch0_g_error;
				}
				_tmp21_ = _tmp18_;
				_tmp18_ = NULL;
				result = _tmp21_;
				_g_time_zone_unref0 (_tmp18_);
				_g_free0 (prefix);
				_g_free0 (tzid);
				return result;
			}
			_g_free0 (prefix);
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (tzid);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	timezone = NULL;
	_tmp23_ = timezone;
	if (_tmp23_ == NULL) {
		ICalTimezone* _tmp24_;
		_tmp24_ = i_cal_time_get_timezone (date);
		_tmp22_ = _tmp24_ != NULL;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		ICalTimezone* _tmp25_;
		_tmp25_ = i_cal_time_get_timezone (date);
		timezone = _tmp25_;
	}
	_tmp26_ = timezone;
	if (_tmp26_ == NULL) {
		GTimeZone* _tmp27_;
		_tmp27_ = g_time_zone_new_local ();
		result = _tmp27_;
		_g_free0 (tzid);
		return result;
	}
	_tmp28_ = timezone;
	_tmp30_ = i_cal_timezone_get_utc_offset (_tmp28_, date, &_tmp29_);
	is_daylight = _tmp29_;
	interval = _tmp30_;
	is_positive = interval >= 0;
	interval = abs (interval);
	hours = interval / 3600;
	minutes = (interval % 3600) / 60;
	if (is_positive) {
		_tmp31_ = "+";
	} else {
		_tmp31_ = "-";
	}
	_tmp32_ = g_strdup_printf ("%s%02d:%02d", _tmp31_, hours, minutes);
	hour_string = _tmp32_;
	{
		GTimeZone* _tmp33_ = NULL;
		const gchar* _tmp34_;
		GTimeZone* _tmp35_;
		GTimeZone* _tmp36_;
		_tmp34_ = hour_string;
		_tmp35_ = vala_g_time_zone_new_identifier (_tmp34_, &_inner_error0_);
		_tmp33_ = _tmp35_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp36_ = _tmp33_;
		_tmp33_ = NULL;
		result = _tmp36_;
		_g_time_zone_unref0 (_tmp33_);
		_g_free0 (hour_string);
		_g_free0 (tzid);
		return result;
	}
	goto __finally1;
	__catch1_g_error:
	{
		GTimeZone* _tmp37_;
		g_clear_error (&_inner_error0_);
		_tmp37_ = g_time_zone_new_local ();
		result = _tmp37_;
		_g_free0 (hour_string);
		_g_free0 (tzid);
		return result;
	}
	__finally1:
	_g_free0 (hour_string);
	_g_free0 (tzid);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

/**
     * Converts the given ICal.Time to a GLib.DateTime.
     *
     * XXX : Track next versions of evolution in order to convert ICal.Timezone
     * to GLib.TimeZone with a dedicated function…
     *
     * **Note:** All timezone information in the original @date is lost.
     * While this function attempts to convert the timezone data contained in
     * @date to GLib, this process does not always work. You should never
     * assume that the {@link GLib.TimeZone} contained in the resulting
     * DateTime is correct. The wall-clock date and time are correct for the
     * original timezone, however.
     *
     * For example, a timezone like `Western European Standard Time` is not
     * easily representable in GLib. The resulting {@link GLib.TimeZone} is
     * likely to be the system's local timezone, which is (probably) incorrect.
     * However, if the event occurs at 8:15 AM on January 1, 2020, the time
     * contained in the returned DateTime will be 8:15 AM on January 1, 2020
     * in the local timezone. The wall clock time is correct, but the time
     * zone is not.
     */
GDateTime*
tasks_util_ical_to_date_time (ICalTime* date)
{
	gint year = 0;
	gint month = 0;
	gint day = 0;
	gint hour = 0;
	gint minute = 0;
	gint second = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GTimeZone* _tmp6_;
	GTimeZone* _tmp7_;
	GDateTime* _tmp8_;
	GDateTime* _tmp9_;
	GDateTime* result;
	g_return_val_if_fail (date != NULL, NULL);
	i_cal_time_get_date (date, &_tmp0_, &_tmp1_, &_tmp2_);
	year = _tmp0_;
	month = _tmp1_;
	day = _tmp2_;
	i_cal_time_get_time (date, &_tmp3_, &_tmp4_, &_tmp5_);
	hour = _tmp3_;
	minute = _tmp4_;
	second = _tmp5_;
	_tmp6_ = tasks_util_icaltime_get_timezone (date);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_date_time_new (_tmp7_, year, month, day, hour, minute, (gdouble) second);
	_tmp9_ = _tmp8_;
	_g_time_zone_unref0 (_tmp7_);
	result = _tmp9_;
	return result;
}

/**
     * Converts the given ICal.Time to a GLib.DateTime, represented in the
     * system timezone.
     *
     * All timezone information in the original @date is lost. However, the
     * {@link GLib.TimeZone} contained in the resulting DateTime is correct,
     * since there is a well-defined local timezone between both libical and
     * GLib.
     */
GDateTime*
tasks_util_ical_to_date_time_local (ICalTime* date)
{
	ICalTime* converted = NULL;
	ICalTime* _tmp0_;
	gint year = 0;
	gint month = 0;
	gint day = 0;
	gint hour = 0;
	gint minute = 0;
	gint second = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	GDateTime* _tmp7_;
	GDateTime* result;
	g_return_val_if_fail (date != NULL, NULL);
	_vala_assert (!i_cal_time_is_null_time (date), "!date.is_null_time ()");
	_tmp0_ = tasks_util_ical_convert_to_local (date);
	converted = _tmp0_;
	i_cal_time_get_date (converted, &_tmp1_, &_tmp2_, &_tmp3_);
	year = _tmp1_;
	month = _tmp2_;
	day = _tmp3_;
	i_cal_time_get_time (converted, &_tmp4_, &_tmp5_, &_tmp6_);
	hour = _tmp4_;
	minute = _tmp5_;
	second = _tmp6_;
	_tmp7_ = g_date_time_new_local (year, month, day, hour, minute, (gdouble) second);
	result = _tmp7_;
	_g_object_unref0 (converted);
	return result;
}

/** Converts the given ICal.Time to the local (or system) timezone
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

ICalTime*
tasks_util_ical_convert_to_local (ICalTime* time)
{
	ICalTimezone* system_tz = NULL;
	ICalTimezone* _tmp0_;
	ICalTimezone* _tmp1_;
	ICalTime* _tmp2_;
	ICalTime* result;
	g_return_val_if_fail (time != NULL, NULL);
	_tmp0_ = e_cal_util_get_system_timezone ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	system_tz = _tmp1_;
	_tmp2_ = i_cal_time_convert_to_zone (time, system_tz);
	result = _tmp2_;
	_g_object_unref0 (system_tz);
	return result;
}

/**
     * Compares a {@link GLib.DateTime} to {@link GLib.DateTime.now_local} and returns a location, relative date string.
     * Results appear as natural-language strings like "Today", "Yesterday", "Fri, Apr 17", "Jan 15", "Sep 18 2019".
     *
     * @param date_time a {@link GLib.DateTime} to compare against {@link GLib.DateTime.now_local}
     *
     * @return a localized, relative date string
     */
gchar*
tasks_util_get_relative_date (GDateTime* date_time)
{
	GDateTime* now = NULL;
	GDateTime* _tmp0_;
	GTimeSpan diff = 0LL;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	gchar* result;
	g_return_val_if_fail (date_time != NULL, NULL);
	_tmp0_ = g_date_time_new_now_local ();
	now = _tmp0_;
	_tmp1_ = now;
	diff = g_date_time_difference (_tmp1_, date_time);
	_tmp2_ = now;
	if (granite_date_time_is_same_day (date_time, _tmp2_)) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup (_ ("Today"));
		result = _tmp3_;
		_g_date_time_unref0 (now);
		return result;
	} else {
		GDateTime* _tmp4_;
		GDateTime* _tmp5_;
		GDateTime* _tmp6_;
		gboolean _tmp7_;
		_tmp4_ = g_date_time_add_days (date_time, 1);
		_tmp5_ = _tmp4_;
		_tmp6_ = now;
		_tmp7_ = granite_date_time_is_same_day (_tmp5_, _tmp6_);
		_g_date_time_unref0 (_tmp5_);
		if (_tmp7_) {
			gchar* _tmp8_;
			_tmp8_ = g_strdup (_ ("Yesterday"));
			result = _tmp8_;
			_g_date_time_unref0 (now);
			return result;
		} else {
			GDateTime* _tmp9_;
			GDateTime* _tmp10_;
			GDateTime* _tmp11_;
			gboolean _tmp12_;
			_tmp9_ = g_date_time_add_days (date_time, -1);
			_tmp10_ = _tmp9_;
			_tmp11_ = now;
			_tmp12_ = granite_date_time_is_same_day (_tmp10_, _tmp11_);
			_g_date_time_unref0 (_tmp10_);
			if (_tmp12_) {
				gchar* _tmp13_;
				_tmp13_ = g_strdup (_ ("Tomorrow"));
				result = _tmp13_;
				_g_date_time_unref0 (now);
				return result;
			} else {
				gboolean _tmp14_ = FALSE;
				if (diff < (6 * G_TIME_SPAN_DAY)) {
					_tmp14_ = diff > (-6 * G_TIME_SPAN_DAY);
				} else {
					_tmp14_ = FALSE;
				}
				if (_tmp14_) {
					gchar* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					_tmp15_ = granite_date_time_get_default_date_format (TRUE, TRUE, FALSE);
					_tmp16_ = _tmp15_;
					_tmp17_ = g_date_time_format (date_time, _tmp16_);
					_tmp18_ = _tmp17_;
					_g_free0 (_tmp16_);
					result = _tmp18_;
					_g_date_time_unref0 (now);
					return result;
				} else {
					GDateTime* _tmp19_;
					_tmp19_ = now;
					if (g_date_time_get_year (date_time) == g_date_time_get_year (_tmp19_)) {
						gchar* _tmp20_;
						gchar* _tmp21_;
						gchar* _tmp22_;
						gchar* _tmp23_;
						_tmp20_ = granite_date_time_get_default_date_format (FALSE, TRUE, FALSE);
						_tmp21_ = _tmp20_;
						_tmp22_ = g_date_time_format (date_time, _tmp21_);
						_tmp23_ = _tmp22_;
						_g_free0 (_tmp21_);
						result = _tmp23_;
						_g_date_time_unref0 (now);
						return result;
					} else {
						gchar* _tmp24_;
						gchar* _tmp25_;
						gchar* _tmp26_;
						gchar* _tmp27_;
						_tmp24_ = granite_date_time_get_default_date_format (FALSE, TRUE, TRUE);
						_tmp25_ = _tmp24_;
						_tmp26_ = g_date_time_format (date_time, _tmp25_);
						_tmp27_ = _tmp26_;
						_g_free0 (_tmp25_);
						result = _tmp27_;
						_g_date_time_unref0 (now);
						return result;
					}
				}
			}
		}
	}
}

/**
     * Returns the value of X-EVOLUTION-GTASKS-POSITION property if set,
     * otherwise return "00000000000000000000"
     */
gchar*
tasks_util_get_gtasks_position_property_value (ECalComponent* ecalcomponent)
{
	ICalComponent* icalcomponent = NULL;
	ICalComponent* _tmp0_;
	ICalComponent* _tmp1_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (ecalcomponent != NULL, NULL);
	_tmp0_ = e_cal_component_get_icalcomponent (ecalcomponent);
	icalcomponent = _tmp0_;
	_tmp1_ = icalcomponent;
	if (_tmp1_ != NULL) {
		gchar* gtasks_position = NULL;
		ICalComponent* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = icalcomponent;
		_tmp3_ = e_cal_util_component_dup_x_property (_tmp2_, "X-EVOLUTION-GTASKS-POSITION");
		gtasks_position = _tmp3_;
		_tmp4_ = gtasks_position;
		if (_tmp4_ != NULL) {
			result = gtasks_position;
			return result;
		}
		_g_free0 (gtasks_position);
	}
	_tmp5_ = g_strdup ("00000000000000000000");
	result = _tmp5_;
	return result;
}

/**
     * Returns the value of X-APPLE-SORT-ORDER property if set
     */
gchar*
tasks_util_get_apple_sortorder_property_value (ECalComponent* ecalcomponent)
{
	ICalComponent* icalcomponent = NULL;
	ICalComponent* _tmp0_;
	ICalComponent* _tmp1_;
	gchar* result;
	g_return_val_if_fail (ecalcomponent != NULL, NULL);
	_tmp0_ = e_cal_component_get_icalcomponent (ecalcomponent);
	icalcomponent = _tmp0_;
	_tmp1_ = icalcomponent;
	if (_tmp1_ != NULL) {
		ICalComponent* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = icalcomponent;
		_tmp3_ = e_cal_util_component_dup_x_property (_tmp2_, "X-APPLE-SORT-ORDER");
		result = _tmp3_;
		return result;
	}
	result = NULL;
	return result;
}

/**
    * Calculates the number of seconds between the ECal.Component's
    * creation date and the Cocoa/Webkit epoch (= 20010101T000000Z).
    *
    * The same value is calculated on iOS devices and used for sorting
    * in case there is no X-APPLE-SORT-ORDER property value set.
    *
    * So this default value calculation ensures we achieve the same sort
    * order of tasks like we have on iOS devices.
    */
ICalDuration*
tasks_util_get_apple_sortorder_default_value (ECalComponent* ecalcomponent)
{
	ICalTime* _tmp0_;
	ICalTime* _tmp1_;
	ICalTime* _tmp2_;
	ICalTime* _tmp3_;
	ICalDuration* _tmp4_;
	ICalDuration* _tmp5_;
	ICalDuration* result;
	g_return_val_if_fail (ecalcomponent != NULL, NULL);
	_tmp0_ = e_cal_component_get_created (ecalcomponent);
	_tmp1_ = _tmp0_;
	_tmp2_ = i_cal_time_new_from_string ("20010101T000000Z");
	_tmp3_ = _tmp2_;
	_tmp4_ = i_cal_time_subtract (_tmp1_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}

static void
_vala_ECalComponentAlarm_free (ECalComponentAlarm* self)
{
	g_boxed_free (e_cal_component_alarm_get_type (), self);
}

static void
__vala_ECalComponentAlarm_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (_vala_ECalComponentAlarm_free (var), NULL));
}

static inline void
_g_slist_free___vala_ECalComponentAlarm_free0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) __vala_ECalComponentAlarm_free0_);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

static gpointer
_tasks_location_dup0 (gpointer self)
{
	return self ? tasks_location_dup (self) : NULL;
}

TasksLocation*
tasks_util_get_ecalcomponent_location (ECalComponent* ecalcomponent)
{
	ICalComponent* icalcomponent = NULL;
	ICalComponent* _tmp0_;
	gchar* postal_address = NULL;
	ICalComponent* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* display_name = NULL;
	gint accuracy = 0;
	TasksLocationProximity proximity = 0;
	gdouble longitude = 0.0;
	gdouble latitude = 0.0;
	ICalProperty* geo_property = NULL;
	ICalComponent* _tmp4_;
	ICalProperty* _tmp5_;
	ICalProperty* _tmp6_;
	ICalProperty* apple_proximity_property = NULL;
	ICalProperty* apple_location_property = NULL;
	gboolean _tmp22_ = FALSE;
	ICalProperty* _tmp23_;
	gboolean _tmp31_ = FALSE;
	ICalProperty* _tmp32_;
	gboolean _tmp94_ = FALSE;
	gboolean _tmp95_ = FALSE;
	GError* _inner_error0_ = NULL;
	TasksLocation* result;
	g_return_val_if_fail (ecalcomponent != NULL, NULL);
	_tmp0_ = e_cal_component_get_icalcomponent (ecalcomponent);
	icalcomponent = _tmp0_;
	_tmp1_ = icalcomponent;
	_tmp2_ = i_cal_component_get_location (_tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	postal_address = _tmp3_;
	display_name = NULL;
	accuracy = GEOCODE_LOCATION_ACCURACY_UNKNOWN;
	proximity = TASKS_LOCATION_PROXIMITY_ARRIVE;
	latitude = (gdouble) 0;
	longitude = latitude;
	_tmp4_ = icalcomponent;
	_tmp5_ = i_cal_component_get_first_property (_tmp4_, I_CAL_GEO_PROPERTY);
	geo_property = _tmp5_;
	_tmp6_ = geo_property;
	if (_tmp6_ != NULL) {
		ICalGeo* geo = NULL;
		ICalProperty* _tmp7_;
		ICalGeo* _tmp8_;
		ICalGeo* _tmp9_;
		ICalGeo* _tmp10_;
		_tmp7_ = geo_property;
		_tmp8_ = i_cal_property_get_geo (_tmp7_);
		geo = _tmp8_;
		_tmp9_ = geo;
		longitude = i_cal_geo_get_lon (_tmp9_);
		_tmp10_ = geo;
		latitude = i_cal_geo_get_lat (_tmp10_);
		_g_object_unref0 (geo);
	}
	apple_proximity_property = NULL;
	apple_location_property = NULL;
	if (e_cal_component_has_alarms (ecalcomponent)) {
		GSList* all_alarms = NULL;
		GSList* _tmp11_;
		GSList* _tmp12_;
		_tmp11_ = e_cal_component_get_all_alarms (ecalcomponent);
		all_alarms = _tmp11_;
		_tmp12_ = all_alarms;
		{
			GSList* alarm_collection = NULL;
			GSList* alarm_it = NULL;
			alarm_collection = _tmp12_;
			for (alarm_it = alarm_collection; alarm_it != NULL; alarm_it = alarm_it->next) {
				ECalComponentAlarm* alarm = NULL;
				alarm = (ECalComponentAlarm*) alarm_it->data;
				{
					ICalComponent* ical_component = NULL;
					ICalComponent* _tmp13_;
					ECalComponentAlarm* _tmp14_;
					ICalComponent* _tmp15_;
					ICalProperty* _tmp16_;
					ICalProperty* _tmp19_;
					_tmp13_ = i_cal_component_new_valarm ();
					ical_component = _tmp13_;
					_tmp14_ = alarm;
					_tmp15_ = ical_component;
					e_cal_component_alarm_fill_component (_tmp14_, _tmp15_);
					_tmp16_ = apple_proximity_property;
					if (_tmp16_ == NULL) {
						ICalComponent* _tmp17_;
						ICalProperty* _tmp18_;
						_tmp17_ = ical_component;
						_tmp18_ = e_cal_util_component_find_x_property (_tmp17_, "X-APPLE-PROXIMITY");
						_g_object_unref0 (apple_proximity_property);
						apple_proximity_property = _tmp18_;
					}
					_tmp19_ = apple_location_property;
					if (_tmp19_ == NULL) {
						ICalComponent* _tmp20_;
						ICalProperty* _tmp21_;
						_tmp20_ = ical_component;
						_tmp21_ = e_cal_util_component_find_x_property (_tmp20_, "X-APPLE-STRUCTURED-LOCATION");
						_g_object_unref0 (apple_location_property);
						apple_location_property = _tmp21_;
					}
					_g_object_unref0 (ical_component);
				}
			}
		}
		(all_alarms == NULL) ? NULL : (all_alarms = (_g_slist_free___vala_ECalComponentAlarm_free0_ (all_alarms), NULL));
	}
	_tmp23_ = apple_proximity_property;
	if (_tmp23_ != NULL) {
		ICalProperty* _tmp24_;
		ICalValue* _tmp25_;
		ICalValue* _tmp26_;
		_tmp24_ = apple_proximity_property;
		_tmp25_ = i_cal_property_get_value (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp22_ = _tmp26_ != NULL;
		_g_object_unref0 (_tmp26_);
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		gchar* apple_proximity_property_value = NULL;
		ICalProperty* _tmp27_;
		gchar* _tmp28_;
		const gchar* _tmp29_;
		_tmp27_ = apple_proximity_property;
		_tmp28_ = i_cal_property_get_value_as_string (_tmp27_);
		apple_proximity_property_value = _tmp28_;
		_tmp29_ = apple_proximity_property_value;
		if (_tmp29_ != NULL) {
			const gchar* _tmp30_;
			_tmp30_ = apple_proximity_property_value;
			proximity = tasks_location_proximity_from_string (_tmp30_);
		}
		_g_free0 (apple_proximity_property_value);
	}
	_tmp32_ = apple_location_property;
	if (_tmp32_ != NULL) {
		ICalProperty* _tmp33_;
		ICalValue* _tmp34_;
		ICalValue* _tmp35_;
		_tmp33_ = apple_location_property;
		_tmp34_ = i_cal_property_get_value (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp31_ = _tmp35_ != NULL;
		_g_object_unref0 (_tmp35_);
	} else {
		_tmp31_ = FALSE;
	}
	if (_tmp31_) {
		gchar* apple_location_property_parameter_x_address = NULL;
		gchar* apple_location_property_parameter_x_title = NULL;
		ICalParameter* apple_location_property_x_parameter = NULL;
		ICalProperty* _tmp36_;
		ICalParameter* _tmp37_;
		gboolean _tmp59_ = FALSE;
		const gchar* _tmp60_;
		gboolean _tmp66_ = FALSE;
		const gchar* _tmp67_;
		gchar* apple_location_property_value = NULL;
		ICalProperty* _tmp73_;
		gchar* _tmp74_;
		gboolean _tmp75_ = FALSE;
		const gchar* _tmp76_;
		apple_location_property_parameter_x_address = NULL;
		apple_location_property_parameter_x_title = NULL;
		_tmp36_ = apple_location_property;
		_tmp37_ = i_cal_property_get_first_parameter (_tmp36_, I_CAL_X_PARAMETER);
		apple_location_property_x_parameter = _tmp37_;
		while (TRUE) {
			gboolean _tmp38_ = FALSE;
			ICalParameter* _tmp39_;
			ICalParameter* _tmp43_;
			const gchar* _tmp44_;
			const gchar* _tmp45_;
			GQuark _tmp47_ = 0U;
			static GQuark _tmp46_label0 = 0;
			static GQuark _tmp46_label1 = 0;
			ICalProperty* _tmp57_;
			ICalParameter* _tmp58_;
			_tmp39_ = apple_location_property_x_parameter;
			if (_tmp39_ != NULL) {
				gboolean _tmp40_ = FALSE;
				const gchar* _tmp41_;
				_tmp41_ = apple_location_property_parameter_x_address;
				if (_tmp41_ == NULL) {
					_tmp40_ = TRUE;
				} else {
					const gchar* _tmp42_;
					_tmp42_ = apple_location_property_parameter_x_title;
					_tmp40_ = _tmp42_ == NULL;
				}
				_tmp38_ = _tmp40_;
			} else {
				_tmp38_ = FALSE;
			}
			if (!_tmp38_) {
				break;
			}
			_tmp43_ = apple_location_property_x_parameter;
			_tmp44_ = i_cal_parameter_get_xname (_tmp43_);
			_tmp45_ = _tmp44_;
			_tmp47_ = (NULL == _tmp45_) ? 0 : g_quark_from_string (_tmp45_);
			if (_tmp47_ == ((0 != _tmp46_label0) ? _tmp46_label0 : (_tmp46_label0 = g_quark_from_static_string ("X-ADDRESS")))) {
				switch (0) {
					default:
					{
						ICalParameter* _tmp48_;
						const gchar* _tmp49_;
						gchar* _tmp50_;
						const gchar* _tmp51_;
						_tmp48_ = apple_location_property_x_parameter;
						_tmp49_ = i_cal_parameter_get_xvalue (_tmp48_);
						_tmp50_ = g_strdup (_tmp49_);
						_g_free0 (apple_location_property_parameter_x_address);
						apple_location_property_parameter_x_address = _tmp50_;
						_tmp51_ = apple_location_property_parameter_x_address;
						if (_tmp51_ != NULL) {
							const gchar* _tmp52_;
							gchar* _tmp53_;
							_tmp52_ = apple_location_property_parameter_x_address;
							_tmp53_ = string_replace (_tmp52_, "\\\\n", " ");
							_g_free0 (apple_location_property_parameter_x_address);
							apple_location_property_parameter_x_address = _tmp53_;
						}
						break;
					}
				}
			} else if (_tmp47_ == ((0 != _tmp46_label1) ? _tmp46_label1 : (_tmp46_label1 = g_quark_from_static_string ("X-TITLE")))) {
				switch (0) {
					default:
					{
						ICalParameter* _tmp54_;
						const gchar* _tmp55_;
						gchar* _tmp56_;
						_tmp54_ = apple_location_property_x_parameter;
						_tmp55_ = i_cal_parameter_get_xvalue (_tmp54_);
						_tmp56_ = g_strdup (_tmp55_);
						_g_free0 (apple_location_property_parameter_x_title);
						apple_location_property_parameter_x_title = _tmp56_;
						break;
					}
				}
			} else {
				switch (0) {
					default:
					{
						break;
					}
				}
			}
			_tmp57_ = apple_location_property;
			_tmp58_ = i_cal_property_get_next_parameter (_tmp57_, I_CAL_X_PARAMETER);
			_g_object_unref0 (apple_location_property_x_parameter);
			apple_location_property_x_parameter = _tmp58_;
		}
		_tmp60_ = apple_location_property_parameter_x_address;
		if (_tmp60_ != NULL) {
			const gchar* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			_tmp61_ = apple_location_property_parameter_x_address;
			_tmp62_ = string_strip (_tmp61_);
			_tmp63_ = _tmp62_;
			_tmp59_ = g_strcmp0 (_tmp63_, "") != 0;
			_g_free0 (_tmp63_);
		} else {
			_tmp59_ = FALSE;
		}
		if (_tmp59_) {
			const gchar* _tmp64_;
			gchar* _tmp65_;
			_tmp64_ = apple_location_property_parameter_x_address;
			_tmp65_ = g_strdup (_tmp64_);
			_g_free0 (postal_address);
			postal_address = _tmp65_;
		}
		_tmp67_ = apple_location_property_parameter_x_title;
		if (_tmp67_ != NULL) {
			const gchar* _tmp68_;
			gchar* _tmp69_;
			gchar* _tmp70_;
			_tmp68_ = apple_location_property_parameter_x_title;
			_tmp69_ = string_strip (_tmp68_);
			_tmp70_ = _tmp69_;
			_tmp66_ = g_strcmp0 (_tmp70_, "") != 0;
			_g_free0 (_tmp70_);
		} else {
			_tmp66_ = FALSE;
		}
		if (_tmp66_) {
			const gchar* _tmp71_;
			gchar* _tmp72_;
			_tmp71_ = apple_location_property_parameter_x_title;
			_tmp72_ = g_strdup (_tmp71_);
			_g_free0 (display_name);
			display_name = _tmp72_;
		}
		_tmp73_ = apple_location_property;
		_tmp74_ = i_cal_property_get_value_as_string (_tmp73_);
		apple_location_property_value = _tmp74_;
		_tmp76_ = apple_location_property_value;
		if (_tmp76_ != NULL) {
			const gchar* _tmp77_;
			gchar* _tmp78_;
			gchar* _tmp79_;
			_tmp77_ = apple_location_property_value;
			_tmp78_ = g_utf8_strdown (_tmp77_, (gssize) -1);
			_tmp79_ = _tmp78_;
			_tmp75_ = string_contains (_tmp79_, "geo:");
			_g_free0 (_tmp79_);
		} else {
			_tmp75_ = FALSE;
		}
		if (_tmp75_) {
			const gchar* _tmp80_;
			gchar* _tmp81_;
			gchar* _tmp82_;
			gchar* _tmp83_;
			gchar* _tmp84_;
			gchar* _tmp85_;
			gchar** apple_location_property_value_geo = NULL;
			const gchar* _tmp86_;
			gchar** _tmp87_;
			gchar** _tmp88_;
			gint apple_location_property_value_geo_length1;
			gint _apple_location_property_value_geo_size_;
			gchar** _tmp89_;
			gint _tmp89__length1;
			_tmp80_ = apple_location_property_value;
			_tmp81_ = g_utf8_strdown (_tmp80_, (gssize) -1);
			_tmp82_ = _tmp81_;
			_tmp83_ = string_replace (_tmp82_, "geo:", "");
			_tmp84_ = _tmp83_;
			_tmp85_ = string_replace (_tmp84_, "\\", "");
			_g_free0 (apple_location_property_value);
			apple_location_property_value = _tmp85_;
			_g_free0 (_tmp84_);
			_g_free0 (_tmp82_);
			_tmp86_ = apple_location_property_value;
			_tmp88_ = _tmp87_ = g_strsplit (_tmp86_, ",", 0);
			apple_location_property_value_geo = _tmp88_;
			apple_location_property_value_geo_length1 = _vala_array_length (_tmp87_);
			_apple_location_property_value_geo_size_ = apple_location_property_value_geo_length1;
			_tmp89_ = apple_location_property_value_geo;
			_tmp89__length1 = apple_location_property_value_geo_length1;
			if (_tmp89__length1 > 1) {
				gchar** _tmp90_;
				gint _tmp90__length1;
				const gchar* _tmp91_;
				gchar** _tmp92_;
				gint _tmp92__length1;
				const gchar* _tmp93_;
				_tmp90_ = apple_location_property_value_geo;
				_tmp90__length1 = apple_location_property_value_geo_length1;
				_tmp91_ = _tmp90_[0];
				latitude = double_parse (_tmp91_);
				_tmp92_ = apple_location_property_value_geo;
				_tmp92__length1 = apple_location_property_value_geo_length1;
				_tmp93_ = _tmp92_[1];
				longitude = double_parse (_tmp93_);
			}
			apple_location_property_value_geo = (_vala_array_free (apple_location_property_value_geo, apple_location_property_value_geo_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_free0 (apple_location_property_value);
		_g_object_unref0 (apple_location_property_x_parameter);
		_g_free0 (apple_location_property_parameter_x_title);
		_g_free0 (apple_location_property_parameter_x_address);
	}
	if (longitude != ((gdouble) 0)) {
		_tmp95_ = latitude != ((gdouble) 0);
	} else {
		_tmp95_ = FALSE;
	}
	if (_tmp95_) {
		_tmp94_ = TRUE;
	} else {
		gboolean _tmp96_ = FALSE;
		const gchar* _tmp97_;
		_tmp97_ = postal_address;
		if (_tmp97_ != NULL) {
			const gchar* _tmp98_;
			gchar* _tmp99_;
			gchar* _tmp100_;
			gint _tmp101_;
			gint _tmp102_;
			_tmp98_ = postal_address;
			_tmp99_ = string_strip (_tmp98_);
			_tmp100_ = _tmp99_;
			_tmp101_ = strlen (_tmp100_);
			_tmp102_ = _tmp101_;
			_tmp96_ = _tmp102_ > 0;
			_g_free0 (_tmp100_);
		} else {
			_tmp96_ = FALSE;
		}
		_tmp94_ = _tmp96_;
	}
	if (_tmp94_) {
		TasksLocation location = {0};
		const gchar* _tmp103_;
		gchar* _tmp104_;
		const gchar* _tmp105_;
		gchar* _tmp106_;
		TasksLocation _tmp107_ = {0};
		gboolean _tmp108_ = FALSE;
		TasksLocation _tmp109_;
		const gchar* _tmp110_;
		TasksLocation _tmp134_;
		TasksLocation* _tmp135_;
		TasksLocation* _tmp136_;
		_tmp103_ = postal_address;
		_tmp104_ = g_strdup (_tmp103_);
		_tmp105_ = display_name;
		_tmp106_ = g_strdup (_tmp105_);
		memset (&_tmp107_, 0, sizeof (TasksLocation));
		_g_free0 (_tmp107_.postal_address);
		_tmp107_.postal_address = _tmp104_;
		_g_free0 (_tmp107_.display_name);
		_tmp107_.display_name = _tmp106_;
		_tmp107_.longitude = longitude;
		_tmp107_.latitude = latitude;
		_tmp107_.accuracy = accuracy;
		_tmp107_.proximity = proximity;
		location = _tmp107_;
		_tmp109_ = location;
		_tmp110_ = _tmp109_.postal_address;
		if (_tmp110_ == NULL) {
			_tmp108_ = TRUE;
		} else {
			TasksLocation _tmp111_;
			const gchar* _tmp112_;
			gchar* _tmp113_;
			gchar* _tmp114_;
			gint _tmp115_;
			gint _tmp116_;
			_tmp111_ = location;
			_tmp112_ = _tmp111_.postal_address;
			_tmp113_ = string_strip (_tmp112_);
			_tmp114_ = _tmp113_;
			_tmp115_ = strlen (_tmp114_);
			_tmp116_ = _tmp115_;
			_tmp108_ = _tmp116_ == 0;
			_g_free0 (_tmp114_);
		}
		if (_tmp108_) {
			{
				GeocodePlace* place = NULL;
				TasksLocation _tmp117_;
				TasksLocation _tmp118_;
				TasksLocation _tmp119_;
				GeocodeLocation* _tmp120_;
				GeocodeLocation* _tmp121_;
				GeocodeReverse* _tmp122_;
				GeocodeReverse* _tmp123_;
				GeocodePlace* _tmp124_;
				GeocodePlace* _tmp125_;
				GeocodePlace* _tmp126_;
				GeocodeLocation* _tmp127_;
				GeocodeLocation* _tmp128_;
				const gchar* _tmp129_;
				const gchar* _tmp130_;
				gchar* _tmp131_;
				_tmp117_ = location;
				_tmp118_ = location;
				_tmp119_ = location;
				_tmp120_ = geocode_location_new (_tmp117_.latitude, _tmp118_.longitude, (gdouble) _tmp119_.accuracy);
				_tmp121_ = _tmp120_;
				_tmp122_ = geocode_reverse_new_for_location (_tmp121_);
				_tmp123_ = _tmp122_;
				_tmp124_ = geocode_reverse_resolve (_tmp123_, &_inner_error0_);
				_tmp125_ = _tmp124_;
				_g_object_unref0 (_tmp123_);
				_g_object_unref0 (_tmp121_);
				place = _tmp125_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp126_ = place;
				_tmp127_ = geocode_place_get_location (_tmp126_);
				_tmp128_ = _tmp127_;
				_tmp129_ = geocode_location_get_description (_tmp128_);
				_tmp130_ = _tmp129_;
				_tmp131_ = g_strdup (_tmp130_);
				_g_free0 (location.postal_address);
				location.postal_address = _tmp131_;
				_g_object_unref0 (place);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp132_;
				const gchar* _tmp133_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp132_ = e;
				_tmp133_ = _tmp132_->message;
				g_warning ("Util.vala:461: %s", _tmp133_);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				tasks_location_destroy (&location);
				_g_object_unref0 (apple_location_property);
				_g_object_unref0 (apple_proximity_property);
				_g_object_unref0 (geo_property);
				_g_free0 (display_name);
				_g_free0 (postal_address);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp134_ = location;
		_tmp135_ = _tasks_location_dup0 (&_tmp134_);
		_tmp136_ = _tmp135_;
		tasks_location_destroy (&_tmp134_);
		result = _tmp136_;
		_g_object_unref0 (apple_location_property);
		_g_object_unref0 (apple_proximity_property);
		_g_object_unref0 (geo_property);
		_g_free0 (display_name);
		_g_free0 (postal_address);
		return result;
	}
	result = NULL;
	_g_object_unref0 (apple_location_property);
	_g_object_unref0 (apple_proximity_property);
	_g_object_unref0 (geo_property);
	_g_free0 (display_name);
	_g_free0 (postal_address);
	return result;
}

static void
_vala_ECalComponentAlarmTrigger_free (ECalComponentAlarmTrigger* self)
{
	g_boxed_free (e_cal_component_alarm_trigger_get_type (), self);
}

void
tasks_util_set_ecalcomponent_location (ECalComponent* ecalcomponent,
                                       TasksLocation* location)
{
	ICalComponent* icalcomponent = NULL;
	ICalComponent* _tmp0_;
	ICalComponent* _tmp1_;
	gint geo_property_count = 0;
	ICalComponent* _tmp2_;
	g_return_if_fail (ecalcomponent != NULL);
	_tmp0_ = e_cal_component_get_icalcomponent (ecalcomponent);
	icalcomponent = _tmp0_;
	_tmp1_ = icalcomponent;
	i_cal_component_set_location (_tmp1_, "");
	_tmp2_ = icalcomponent;
	geo_property_count = i_cal_component_count_properties (_tmp2_, I_CAL_GEO_PROPERTY);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				ICalProperty* remove_prop = NULL;
				ICalComponent* _tmp5_;
				ICalProperty* _tmp6_;
				ICalComponent* _tmp7_;
				ICalProperty* _tmp8_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				if (!(i < geo_property_count)) {
					break;
				}
				_tmp5_ = icalcomponent;
				_tmp6_ = i_cal_component_get_first_property (_tmp5_, I_CAL_GEO_PROPERTY);
				remove_prop = _tmp6_;
				_tmp7_ = icalcomponent;
				_tmp8_ = remove_prop;
				i_cal_component_remove_property (_tmp7_, _tmp8_);
				_g_object_unref0 (remove_prop);
			}
		}
	}
	if (e_cal_component_has_alarms (ecalcomponent)) {
		GSList* all_alarms = NULL;
		GSList* _tmp9_;
		GSList* _tmp10_;
		_tmp9_ = e_cal_component_get_all_alarms (ecalcomponent);
		all_alarms = _tmp9_;
		_tmp10_ = all_alarms;
		{
			GSList* alarm_collection = NULL;
			GSList* alarm_it = NULL;
			alarm_collection = _tmp10_;
			for (alarm_it = alarm_collection; alarm_it != NULL; alarm_it = alarm_it->next) {
				ECalComponentAlarm* alarm = NULL;
				alarm = (ECalComponentAlarm*) alarm_it->data;
				{
					ICalComponent* ical_component = NULL;
					ICalComponent* _tmp11_;
					ECalComponentAlarm* _tmp12_;
					ICalComponent* _tmp13_;
					ICalComponent* _tmp14_;
					_tmp11_ = i_cal_component_new_valarm ();
					ical_component = _tmp11_;
					_tmp12_ = alarm;
					_tmp13_ = ical_component;
					e_cal_component_alarm_fill_component (_tmp12_, _tmp13_);
					_tmp14_ = ical_component;
					if (e_cal_util_component_has_x_property (_tmp14_, "X-APPLE-STRUCTURED-LOCATION")) {
						ECalComponentAlarm* _tmp15_;
						const gchar* _tmp16_;
						_tmp15_ = alarm;
						_tmp16_ = e_cal_component_alarm_get_uid (_tmp15_);
						e_cal_component_remove_alarm (ecalcomponent, _tmp16_);
					}
					_g_object_unref0 (ical_component);
				}
			}
		}
		(all_alarms == NULL) ? NULL : (all_alarms = (_g_slist_free___vala_ECalComponentAlarm_free0_ (all_alarms), NULL));
	}
	if (location != NULL) {
		const gchar* _tmp17_;
		ICalProperty* geo_property = NULL;
		ICalProperty* _tmp20_;
		ICalGeo* geo = NULL;
		ICalGeo* _tmp21_;
		ICalProperty* _tmp22_;
		ICalGeo* _tmp23_;
		ICalComponent* _tmp24_;
		ICalProperty* _tmp25_;
		ECalComponentAlarm* location_alarm = NULL;
		ECalComponentAlarm* _tmp26_;
		ECalComponentAlarm* _tmp27_;
		ECalComponentAlarmTrigger* location_alarm_trigger = NULL;
		ICalDuration* _tmp28_;
		ICalDuration* _tmp29_;
		ECalComponentAlarmTrigger* _tmp30_;
		ECalComponentAlarmTrigger* _tmp31_;
		ECalComponentAlarm* _tmp32_;
		ECalComponentAlarmTrigger* _tmp33_;
		ECalComponentPropertyBag* location_alarm_property_bag = NULL;
		ECalComponentAlarm* _tmp34_;
		ECalComponentPropertyBag* _tmp35_;
		ICalProperty* location_alarm_x_apple_proximity_property = NULL;
		ICalProperty* _tmp36_;
		ICalProperty* _tmp37_;
		ICalProperty* _tmp38_;
		const gchar* _tmp39_;
		ICalValue* _tmp40_;
		ICalValue* _tmp41_;
		ECalComponentPropertyBag* _tmp42_;
		ICalProperty* _tmp43_;
		ICalProperty* location_alarm_x_apple_structured_location_property = NULL;
		ICalProperty* _tmp44_;
		ICalProperty* _tmp45_;
		ICalProperty* _tmp46_;
		const gchar* _tmp47_ = NULL;
		const gchar* _tmp48_;
		ICalProperty* _tmp50_;
		ICalProperty* _tmp51_;
		ICalProperty* _tmp52_;
		const gchar* _tmp53_ = NULL;
		const gchar* _tmp54_;
		ICalProperty* _tmp56_;
		ICalProperty* _tmp57_;
		gchar* _tmp58_;
		gchar* _tmp59_;
		ICalValue* _tmp60_;
		ICalValue* _tmp61_;
		ECalComponentPropertyBag* _tmp62_;
		ICalProperty* _tmp63_;
		ECalComponentAlarm* _tmp64_;
		_tmp17_ = (*location).postal_address;
		if (_tmp17_ != NULL) {
			ICalComponent* _tmp18_;
			const gchar* _tmp19_;
			_tmp18_ = icalcomponent;
			_tmp19_ = (*location).postal_address;
			i_cal_component_set_location (_tmp18_, _tmp19_);
		}
		_tmp20_ = i_cal_property_new (I_CAL_GEO_PROPERTY);
		geo_property = _tmp20_;
		_tmp21_ = i_cal_geo_new ((*location).latitude, (*location).longitude);
		geo = _tmp21_;
		_tmp22_ = geo_property;
		_tmp23_ = geo;
		i_cal_property_set_geo (_tmp22_, _tmp23_);
		_tmp24_ = icalcomponent;
		_tmp25_ = geo_property;
		i_cal_component_add_property (_tmp24_, _tmp25_);
		_tmp26_ = e_cal_component_alarm_new ();
		location_alarm = _tmp26_;
		_tmp27_ = location_alarm;
		e_cal_component_alarm_set_action (_tmp27_, E_CAL_COMPONENT_ALARM_DISPLAY);
		_tmp28_ = i_cal_duration_new_null_duration ();
		_tmp29_ = _tmp28_;
		_tmp30_ = e_cal_component_alarm_trigger_new_relative (E_CAL_COMPONENT_ALARM_TRIGGER_RELATIVE_START, _tmp29_);
		_tmp31_ = _tmp30_;
		_g_object_unref0 (_tmp29_);
		location_alarm_trigger = _tmp31_;
		_tmp32_ = location_alarm;
		_tmp33_ = location_alarm_trigger;
		e_cal_component_alarm_set_trigger (_tmp32_, _tmp33_);
		_tmp34_ = location_alarm;
		_tmp35_ = e_cal_component_alarm_get_property_bag (_tmp34_);
		location_alarm_property_bag = _tmp35_;
		_tmp36_ = i_cal_property_new (I_CAL_X_PROPERTY);
		location_alarm_x_apple_proximity_property = _tmp36_;
		_tmp37_ = location_alarm_x_apple_proximity_property;
		i_cal_property_set_x_name (_tmp37_, "X-APPLE-PROXIMITY");
		_tmp38_ = location_alarm_x_apple_proximity_property;
		_tmp39_ = tasks_location_proximity_to_string ((*location).proximity);
		_tmp40_ = i_cal_value_new_x (_tmp39_);
		_tmp41_ = _tmp40_;
		i_cal_property_set_value (_tmp38_, _tmp41_);
		_g_object_unref0 (_tmp41_);
		_tmp42_ = location_alarm_property_bag;
		_tmp43_ = location_alarm_x_apple_proximity_property;
		e_cal_component_property_bag_add (_tmp42_, _tmp43_);
		_tmp44_ = i_cal_property_new (I_CAL_X_PROPERTY);
		location_alarm_x_apple_structured_location_property = _tmp44_;
		_tmp45_ = location_alarm_x_apple_structured_location_property;
		i_cal_property_set_x_name (_tmp45_, "X-APPLE-STRUCTURED-LOCATION");
		_tmp46_ = location_alarm_x_apple_structured_location_property;
		i_cal_property_set_parameter_from_string (_tmp46_, "VALUE", "URI");
		_tmp48_ = (*location).postal_address;
		if (_tmp48_ == NULL) {
			_tmp47_ = "";
		} else {
			const gchar* _tmp49_;
			_tmp49_ = (*location).postal_address;
			_tmp47_ = _tmp49_;
		}
		_tmp50_ = location_alarm_x_apple_structured_location_property;
		i_cal_property_set_parameter_from_string (_tmp50_, "X-ADDRESS", _tmp47_);
		_tmp51_ = location_alarm_x_apple_structured_location_property;
		i_cal_property_set_parameter_from_string (_tmp51_, "X-APPLE-RADIUS", "100");
		_tmp52_ = location_alarm_x_apple_structured_location_property;
		i_cal_property_set_parameter_from_string (_tmp52_, "X-APPLE-REFERENCEFRAME", "1");
		_tmp54_ = (*location).display_name;
		if (_tmp54_ == NULL) {
			_tmp53_ = "";
		} else {
			const gchar* _tmp55_;
			_tmp55_ = (*location).display_name;
			_tmp53_ = _tmp55_;
		}
		_tmp56_ = location_alarm_x_apple_structured_location_property;
		i_cal_property_set_parameter_from_string (_tmp56_, "X-TITLE", _tmp53_);
		_tmp57_ = location_alarm_x_apple_structured_location_property;
		_tmp58_ = g_strdup_printf ("geo:%f,%f", (*location).latitude, (*location).longitude);
		_tmp59_ = _tmp58_;
		_tmp60_ = i_cal_value_new_x (_tmp59_);
		_tmp61_ = _tmp60_;
		i_cal_property_set_value (_tmp57_, _tmp61_);
		_g_object_unref0 (_tmp61_);
		_g_free0 (_tmp59_);
		_tmp62_ = location_alarm_property_bag;
		_tmp63_ = location_alarm_x_apple_structured_location_property;
		e_cal_component_property_bag_add (_tmp62_, _tmp63_);
		_tmp64_ = location_alarm;
		e_cal_component_add_alarm (ecalcomponent, _tmp64_);
		_g_object_unref0 (location_alarm_x_apple_structured_location_property);
		_g_object_unref0 (location_alarm_x_apple_proximity_property);
		__vala_ECalComponentAlarmTrigger_free0 (location_alarm_trigger);
		__vala_ECalComponentAlarm_free0 (location_alarm);
		_g_object_unref0 (geo);
		_g_object_unref0 (geo_property);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

