/* This file is part of GDB.

   Copyright 2002, 2007 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   --

   This file was generated by the program igen */

#ifndef SUPPORT_H
#define SUPPORT_H

PSIM_INLINE_SUPPORT\
(unsigned_word) semantic_illegal
(cpu *processor,
 idecode_cache *cache_entry,
 unsigned_word cia);

PSIM_INLINE_SUPPORT\
(unsigned_word) semantic_floating_point_unavailable
(cpu *processor,
 idecode_cache *cache_entry,
 unsigned_word cia);

PSIM_INLINE_SUPPORT\
(uint64_t) DOUBLE
(uint32_t WORD);

PSIM_INLINE_SUPPORT\
(uint32_t) SINGLE
(uint64_t FRS);

PSIM_INLINE_SUPPORT\
(void) Round_Single
(cpu *processor, int sign, int *exp, uint64_t *frac_grx);

PSIM_INLINE_SUPPORT\
(void) Round_Integer
(cpu *processor, int sign, uint64_t *frac, int *frac64, int gbit, int rbit, int xbit, fpscreg round_mode);

PSIM_INLINE_SUPPORT\
(void) Round_Float
(cpu *processor, int sign, int *exp, uint64_t *frac, fpscreg round_mode);

PSIM_INLINE_SUPPORT\
(void) convert_to_integer
(cpu *processor, unsigned_word cia, uint64_t *frt, uint64_t frb, fpscreg round_mode, int tgt_precision);

PSIM_INLINE_SUPPORT\
(int) sign
(uint64_t FRS);

PSIM_INLINE_SUPPORT\
(int) biased_exp
(uint64_t frs, int single);

PSIM_INLINE_SUPPORT\
(uint64_t) fraction
(uint64_t frs, int single);

PSIM_INLINE_SUPPORT\
(int) is_nor
(uint64_t frs, int single);

PSIM_INLINE_SUPPORT\
(int) is_zero
(uint64_t FRS);

PSIM_INLINE_SUPPORT\
(int) is_den
(uint64_t frs, int single);

PSIM_INLINE_SUPPORT\
(int) is_inf
(uint64_t frs, int single);

PSIM_INLINE_SUPPORT\
(int) is_NaN
(uint64_t frs, int single);

PSIM_INLINE_SUPPORT\
(int) is_SNaN
(uint64_t frs, int single);

PSIM_INLINE_SUPPORT\
(int) is_QNaN
(uint64_t frs, int single);

PSIM_INLINE_SUPPORT\
(int) is_less_than
(uint64_t *fra, uint64_t *frb);

PSIM_INLINE_SUPPORT\
(int) is_greater_than
(uint64_t *fra, uint64_t *frb);

PSIM_INLINE_SUPPORT\
(int) is_equan_to
(uint64_t *fra, uint64_t *frb);

PSIM_INLINE_SUPPORT\
(uint64_t) select_qnan
(uint64_t fra, uint64_t frb, uint64_t frc, int instruction_is_frsp, int generate_qnan, int single);

PSIM_INLINE_SUPPORT\
(int) is_invalid_operation
(cpu *processor, unsigned_word cia, uint64_t fra, uint64_t frb, fpscreg check, int single, int negate);

PSIM_INLINE_SUPPORT\
(void) invalid_arithemetic_operation
(cpu *processor, unsigned_word cia, uint64_t *frt, uint64_t fra, uint64_t frb, uint64_t frc, int instruction_is_frsp, int instruction_is_convert_to_64bit, int instruction_is_convert_to_32bit, int single);

PSIM_INLINE_SUPPORT\
(int) is_invalid_zero_divide
(cpu *processor, unsigned_word cia, uint64_t fra, uint64_t frb, int single);

PSIM_INLINE_SUPPORT\
(void) invalid_zero_divide_operation
(cpu *processor, unsigned_word cia, uint64_t *frt, uint64_t fra, uint64_t frb, int single);


#if (SUPPORT_INLINE & INCLUDE_MODULE)
# include "support.c"
#endif

#endif /* _SUPPORT_H_*/
