// components/paint_preview/common/mojom/paint_preview_recorder.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PAINT_PREVIEW_COMMON_MOJOM_PAINT_PREVIEW_RECORDER_MOJOM_SHARED_H_
#define COMPONENTS_PAINT_PREVIEW_COMMON_MOJOM_PAINT_PREVIEW_RECORDER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/paint_preview/common/mojom/paint_preview_recorder.mojom-shared-internal.h"
#include "components/paint_preview/common/mojom/paint_preview_types.mojom-shared.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "components/paint_preview/common/mojom/paint_preview_recorder.mojom-data-view.h"




namespace std {

template <>
struct hash<::paint_preview::mojom::PaintPreviewStatus>
    : public mojo::internal::EnumHashImpl<::paint_preview::mojom::PaintPreviewStatus> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::paint_preview::mojom::PaintPreviewStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::paint_preview::mojom::PaintPreviewStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::paint_preview::mojom::PaintPreviewStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::paint_preview::mojom::PaintPreviewCaptureParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::paint_preview::mojom::PaintPreviewCaptureParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::paint_preview::mojom::internal::PaintPreviewCaptureParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::paint_preview::mojom::RecordingPersistence>(
      Traits::persistence(input),
      &fragment->persistence);

    decltype(Traits::guid(input)) in_guid = Traits::guid(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->guid)::BaseType> guid_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_guid,
      guid_fragment);

    fragment->guid.Set(
        guid_fragment.is_null() ? nullptr : guid_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->guid.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null guid in PaintPreviewCaptureParams struct");

    decltype(Traits::clip_rect(input)) in_clip_rect = Traits::clip_rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->clip_rect)::BaseType> clip_rect_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_clip_rect,
      clip_rect_fragment);

    fragment->clip_rect.Set(
        clip_rect_fragment.is_null() ? nullptr : clip_rect_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->clip_rect.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null clip_rect in PaintPreviewCaptureParams struct");

    fragment->clip_rect_is_hint = Traits::clip_rect_is_hint(input);

    fragment->is_main_frame = Traits::is_main_frame(input);

    fragment->capture_links = Traits::capture_links(input);

    decltype(Traits::file(input)) in_file = Traits::file(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->file)::BaseType> file_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
      in_file,
      file_fragment);

    fragment->file.Set(
        file_fragment.is_null() ? nullptr : file_fragment.data());

    fragment->max_capture_size = Traits::max_capture_size(input);

    fragment->max_decoded_image_size_bytes = Traits::max_decoded_image_size_bytes(input);

    fragment->skip_accelerated_content = Traits::skip_accelerated_content(input);
  }

  static bool Deserialize(::paint_preview::mojom::internal::PaintPreviewCaptureParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::paint_preview::mojom::PaintPreviewCaptureParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::paint_preview::mojom::LinkDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::paint_preview::mojom::LinkDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::paint_preview::mojom::internal::LinkData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in LinkData struct");

    decltype(Traits::rect(input)) in_rect = Traits::rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->rect)::BaseType> rect_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_rect,
      rect_fragment);

    fragment->rect.Set(
        rect_fragment.is_null() ? nullptr : rect_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->rect.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null rect in LinkData struct");
  }

  static bool Deserialize(::paint_preview::mojom::internal::LinkData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::paint_preview::mojom::LinkDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::paint_preview::mojom::PaintPreviewCaptureResponseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::paint_preview::mojom::PaintPreviewCaptureResponseDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::paint_preview::mojom::internal::PaintPreviewCaptureResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::embedding_token(input)) in_embedding_token = Traits::embedding_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->embedding_token)::BaseType> embedding_token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_embedding_token,
      embedding_token_fragment);

    fragment->embedding_token.Set(
        embedding_token_fragment.is_null() ? nullptr : embedding_token_fragment.data());

    decltype(Traits::content_id_to_embedding_token(input)) in_content_id_to_embedding_token = Traits::content_id_to_embedding_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->content_id_to_embedding_token)::BaseType>
        content_id_to_embedding_token_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& content_id_to_embedding_token_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<uint32_t, ::mojo_base::mojom::UnguessableTokenDataView>>(
      in_content_id_to_embedding_token,
      content_id_to_embedding_token_fragment,
      &content_id_to_embedding_token_validate_params);

    fragment->content_id_to_embedding_token.Set(
        content_id_to_embedding_token_fragment.is_null() ? nullptr : content_id_to_embedding_token_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->content_id_to_embedding_token.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null content_id_to_embedding_token in PaintPreviewCaptureResponse struct");

    decltype(Traits::links(input)) in_links = Traits::links(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->links)::BaseType>
        links_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& links_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::paint_preview::mojom::LinkDataDataView>>(
      in_links,
      links_fragment,
      &links_validate_params);

    fragment->links.Set(
        links_fragment.is_null() ? nullptr : links_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->links.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null links in PaintPreviewCaptureResponse struct");

    decltype(Traits::blink_recording_time(input)) in_blink_recording_time = Traits::blink_recording_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->blink_recording_time)::BaseType> blink_recording_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_blink_recording_time,
      blink_recording_time_fragment);

    fragment->blink_recording_time.Set(
        blink_recording_time_fragment.is_null() ? nullptr : blink_recording_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->blink_recording_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null blink_recording_time in PaintPreviewCaptureResponse struct");

    fragment->serialized_size = Traits::serialized_size(input);

    decltype(Traits::scroll_offsets(input)) in_scroll_offsets = Traits::scroll_offsets(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scroll_offsets)::BaseType> scroll_offsets_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::PointDataView>(
      in_scroll_offsets,
      scroll_offsets_fragment);

    fragment->scroll_offsets.Set(
        scroll_offsets_fragment.is_null() ? nullptr : scroll_offsets_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->scroll_offsets.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null scroll_offsets in PaintPreviewCaptureResponse struct");

    decltype(Traits::frame_offsets(input)) in_frame_offsets = Traits::frame_offsets(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_offsets)::BaseType> frame_offsets_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::PointDataView>(
      in_frame_offsets,
      frame_offsets_fragment);

    fragment->frame_offsets.Set(
        frame_offsets_fragment.is_null() ? nullptr : frame_offsets_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->frame_offsets.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_offsets in PaintPreviewCaptureResponse struct");

    decltype(Traits::skp(input)) in_skp = Traits::skp(input);
    mojo::internal::MessageFragment<decltype(fragment->skp)>
        skp_fragment(fragment.message());
    skp_fragment.Claim(&fragment->skp);
    
    mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
      in_skp,
      skp_fragment,
      true);
  }

  static bool Deserialize(::paint_preview::mojom::internal::PaintPreviewCaptureResponse_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::paint_preview::mojom::PaintPreviewCaptureResponseDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace paint_preview::mojom {

inline void PaintPreviewCaptureParamsDataView::GetGuidDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->guid.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void PaintPreviewCaptureParamsDataView::GetClipRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->clip_rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void PaintPreviewCaptureParamsDataView::GetFileDataView(
    ::mojo_base::mojom::FileDataView* output) {
  auto pointer = data_->file.Get();
  *output = ::mojo_base::mojom::FileDataView(pointer, message_);
}


inline void LinkDataDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void LinkDataDataView::GetRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}


inline void PaintPreviewCaptureResponseDataView::GetEmbeddingTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->embedding_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void PaintPreviewCaptureResponseDataView::GetContentIdToEmbeddingTokenDataView(
    mojo::MapDataView<uint32_t, ::mojo_base::mojom::UnguessableTokenDataView>* output) {
  auto pointer = data_->content_id_to_embedding_token.Get();
  *output = mojo::MapDataView<uint32_t, ::mojo_base::mojom::UnguessableTokenDataView>(pointer, message_);
}
inline void PaintPreviewCaptureResponseDataView::GetLinksDataView(
    mojo::ArrayDataView<LinkDataDataView>* output) {
  auto pointer = data_->links.Get();
  *output = mojo::ArrayDataView<LinkDataDataView>(pointer, message_);
}
inline void PaintPreviewCaptureResponseDataView::GetBlinkRecordingTimeDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->blink_recording_time.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void PaintPreviewCaptureResponseDataView::GetScrollOffsetsDataView(
    ::gfx::mojom::PointDataView* output) {
  auto pointer = data_->scroll_offsets.Get();
  *output = ::gfx::mojom::PointDataView(pointer, message_);
}
inline void PaintPreviewCaptureResponseDataView::GetFrameOffsetsDataView(
    ::gfx::mojom::PointDataView* output) {
  auto pointer = data_->frame_offsets.Get();
  *output = ::gfx::mojom::PointDataView(pointer, message_);
}
inline void PaintPreviewCaptureResponseDataView::GetSkpDataView(
    ::mojo_base::mojom::BigBufferDataView* output) {
  auto pointer = &data_->skp;
  *output = ::mojo_base::mojom::BigBufferDataView(pointer, message_);
}



}  // paint_preview::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::paint_preview::mojom::PaintPreviewStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::paint_preview::mojom::PaintPreviewStatus value);
};

} // namespace perfetto

#endif  // COMPONENTS_PAINT_PREVIEW_COMMON_MOJOM_PAINT_PREVIEW_RECORDER_MOJOM_SHARED_H_