// components/printing/common/print.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PRINTING_COMMON_PRINT_MOJOM_H_
#define COMPONENTS_PRINTING_COMMON_PRINT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/printing/common/print.mojom-features.h"  // IWYU pragma: export
#include "components/printing/common/print.mojom-shared.h"  // IWYU pragma: export
#include "components/printing/common/print.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/shared_memory.mojom.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "mojo/public/mojom/base/values.mojom.h"
#include "printing/mojom/print.mojom.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "base/types/expected.h"




namespace printing::mojom {

class PrintPreviewUIProxy;

template <typename ImplRefTraits>
class PrintPreviewUIStub;

class PrintPreviewUIRequestValidator;


class PrintPreviewUI
    : public PrintPreviewUIInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "printing.mojom.PrintPreviewUI";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PrintPreviewUIInterfaceBase;
  using Proxy_ = PrintPreviewUIProxy;

  template <typename ImplRefTraits>
  using Stub_ = PrintPreviewUIStub<ImplRefTraits>;

  using RequestValidator_ = PrintPreviewUIRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetOptionsFromDocumentMinVersion = 0,
    kDidPrepareDocumentForPreviewMinVersion = 0,
    kDidPreviewPageMinVersion = 0,
    kMetafileReadyForPrintingMinVersion = 0,
    kPrintPreviewFailedMinVersion = 0,
    kPrintPreviewCancelledMinVersion = 0,
    kPrinterSettingsInvalidMinVersion = 0,
    kDidGetDefaultPageLayoutMinVersion = 0,
    kDidStartPreviewMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetOptionsFromDocument_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidPrepareDocumentForPreview_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidPreviewPage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MetafileReadyForPrinting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PrintPreviewFailed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PrintPreviewCancelled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PrinterSettingsInvalid_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidGetDefaultPageLayout_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidStartPreview_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PrintPreviewUI() = default;

  virtual void SetOptionsFromDocument(OptionsFromDocumentParamsPtr params, int32_t request_id) = 0;

  virtual void DidPrepareDocumentForPreview(int32_t document_cookie, int32_t request_id) = 0;

  virtual void DidPreviewPage(DidPreviewPageParamsPtr params, int32_t request_id) = 0;

  virtual void MetafileReadyForPrinting(DidPreviewDocumentParamsPtr params, int32_t request_id) = 0;

  virtual void PrintPreviewFailed(int32_t document_cookie, int32_t request_id) = 0;

  virtual void PrintPreviewCancelled(int32_t document_cookie, int32_t request_id) = 0;

  virtual void PrinterSettingsInvalid(int32_t document_cookie, int32_t request_id) = 0;

  virtual void DidGetDefaultPageLayout(::printing::mojom::PageSizeMarginsPtr page_layout_in_points, const ::gfx::RectF& printable_area_in_points, bool all_pages_have_custom_size, bool all_pages_have_custom_orientation, int32_t request_id) = 0;

  virtual void DidStartPreview(DidStartPreviewParamsPtr params, int32_t request_id) = 0;
};

class PrintRenderFrameProxy;

template <typename ImplRefTraits>
class PrintRenderFrameStub;

class PrintRenderFrameRequestValidator;
class PrintRenderFrameResponseValidator;


class PrintRenderFrame
    : public PrintRenderFrameInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "printing.mojom.PrintRenderFrame";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PrintRenderFrameInterfaceBase;
  using Proxy_ = PrintRenderFrameProxy;

  template <typename ImplRefTraits>
  using Stub_ = PrintRenderFrameStub<ImplRefTraits>;

  using RequestValidator_ = PrintRenderFrameRequestValidator;
  using ResponseValidator_ = PrintRenderFrameResponseValidator;
  enum MethodMinVersions : uint32_t {
    kPrintRequestedPagesMinVersion = 0,
    kPrintWithParamsMinVersion = 0,
    kPrintForSystemDialogMinVersion = 0,
    kInitiatePrintPreviewMinVersion = 0,
    kSetPrintPreviewUIMinVersion = 0,
    kPrintPreviewMinVersion = 0,
    kOnPrintPreviewDialogClosedMinVersion = 0,
    kPrintFrameContentMinVersion = 0,
    kConnectToPdfRendererMinVersion = 0,
    kPrintingDoneMinVersion = 0,
    kPrintNodeUnderContextMenuMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct PrintRequestedPages_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PrintWithParams_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PrintForSystemDialog_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct InitiatePrintPreview_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPrintPreviewUI_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PrintPreview_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnPrintPreviewDialogClosed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PrintFrameContent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ConnectToPdfRenderer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PrintingDone_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PrintNodeUnderContextMenu_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PrintRenderFrame() = default;

  virtual void PrintRequestedPages() = 0;

  using PrintWithParamsCallback = base::OnceCallback<void(base::expected<
  PrintWithParamsResultDataPtr,
  PrintFailureReason>)>;
  using PrintWithParamsResult = base::expected<
  PrintWithParamsResultDataPtr,
  PrintFailureReason>;
  using PrintWithParamsMojoCallback = base::OnceCallback<void(PrintRenderFrame_PrintWithParams_ResponseParam_ResultPtr)>;

  virtual void PrintWithParams(PrintPagesParamsPtr params, PrintWithParamsCallback callback) = 0;

  virtual void PrintForSystemDialog() = 0;

  virtual void InitiatePrintPreview(bool has_selection) = 0;

  virtual void SetPrintPreviewUI(::mojo::PendingAssociatedRemote<PrintPreviewUI> preview) = 0;

  virtual void PrintPreview(::base::Value::Dict settings) = 0;

  virtual void OnPrintPreviewDialogClosed() = 0;

  using PrintFrameContentCallback = base::OnceCallback<void(int32_t, DidPrintContentParamsPtr)>;
  using PrintFrameContentMojoCallback = base::OnceCallback<void(int32_t, DidPrintContentParamsPtr)>;

  virtual void PrintFrameContent(PrintFrameContentParamsPtr params, PrintFrameContentCallback callback) = 0;

  virtual void ConnectToPdfRenderer() = 0;

  virtual void PrintingDone(bool success) = 0;

  virtual void PrintNodeUnderContextMenu() = 0;
};

class PrintManagerHostProxy;

template <typename ImplRefTraits>
class PrintManagerHostStub;

class PrintManagerHostRequestValidator;
class PrintManagerHostResponseValidator;


class PrintManagerHost
    : public PrintManagerHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "printing.mojom.PrintManagerHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    420275248, 
    423247580, 
    499863598, 
    814513477, 
    1006333489, 
    1248185011
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PrintManagerHostInterfaceBase;
  using Proxy_ = PrintManagerHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = PrintManagerHostStub<ImplRefTraits>;

  using RequestValidator_ = PrintManagerHostRequestValidator;
  using ResponseValidator_ = PrintManagerHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kDidGetPrintedPagesCountMinVersion = 0,
    kGetDefaultPrintSettingsMinVersion = 0,
    kDidShowPrintDialogMinVersion = 0,
    kDidPrintDocumentMinVersion = 0,
    kIsPrintingEnabledMinVersion = 0,
    kScriptedPrintMinVersion = 0,
    kPrintingFailedMinVersion = 0,
    kUpdatePrintSettingsMinVersion = 0,
    kSetupScriptedPrintPreviewMinVersion = 0,
    kShowScriptedPrintPreviewMinVersion = 0,
    kRequestPrintPreviewMinVersion = 0,
    kCheckForCancelMinVersion = 0,
    kMetafileReadyForPrintingMinVersion = 0,
    kSetAccessibilityTreeMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct DidGetPrintedPagesCount_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetDefaultPrintSettings_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidShowPrintDialog_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidPrintDocument_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IsPrintingEnabled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ScriptedPrint_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PrintingFailed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdatePrintSettings_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetupScriptedPrintPreview_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowScriptedPrintPreview_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestPrintPreview_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CheckForCancel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MetafileReadyForPrinting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetAccessibilityTree_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PrintManagerHost() = default;

  virtual void DidGetPrintedPagesCount(int32_t cookie, uint32_t number_pages) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetDefaultPrintSettings(PrintParamsPtr* out_default_settings);
  using GetDefaultPrintSettingsCallback = base::OnceCallback<void(PrintParamsPtr)>;
  using GetDefaultPrintSettingsMojoCallback = base::OnceCallback<void(PrintParamsPtr)>;

  virtual void GetDefaultPrintSettings(GetDefaultPrintSettingsCallback callback) = 0;

  virtual void DidShowPrintDialog() = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool DidPrintDocument(DidPrintDocumentParamsPtr params, bool* out_completed);
  using DidPrintDocumentCallback = base::OnceCallback<void(bool)>;
  using DidPrintDocumentMojoCallback = base::OnceCallback<void(bool)>;

  virtual void DidPrintDocument(DidPrintDocumentParamsPtr params, DidPrintDocumentCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool IsPrintingEnabled(bool* out_printing_enabled);
  using IsPrintingEnabledCallback = base::OnceCallback<void(bool)>;
  using IsPrintingEnabledMojoCallback = base::OnceCallback<void(bool)>;

  virtual void IsPrintingEnabled(IsPrintingEnabledCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool ScriptedPrint(ScriptedPrintParamsPtr params, PrintPagesParamsPtr* out_settings);
  using ScriptedPrintCallback = base::OnceCallback<void(PrintPagesParamsPtr)>;
  using ScriptedPrintMojoCallback = base::OnceCallback<void(PrintPagesParamsPtr)>;

  virtual void ScriptedPrint(ScriptedPrintParamsPtr params, ScriptedPrintCallback callback) = 0;

  virtual void PrintingFailed(int32_t cookie, PrintFailureReason reason) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool UpdatePrintSettings(::base::Value::Dict job_settings, PrintPagesParamsPtr* out_current_settings);
  using UpdatePrintSettingsCallback = base::OnceCallback<void(PrintPagesParamsPtr)>;
  using UpdatePrintSettingsMojoCallback = base::OnceCallback<void(PrintPagesParamsPtr)>;

  virtual void UpdatePrintSettings(::base::Value::Dict job_settings, UpdatePrintSettingsCallback callback) = 0;

  using SetupScriptedPrintPreviewCallback = base::OnceCallback<void()>;
  using SetupScriptedPrintPreviewMojoCallback = base::OnceCallback<void()>;

  virtual void SetupScriptedPrintPreview(SetupScriptedPrintPreviewCallback callback) = 0;

  virtual void ShowScriptedPrintPreview(bool is_modifiable) = 0;

  virtual void RequestPrintPreview(RequestPrintPreviewParamsPtr params) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool CheckForCancel(int32_t preview_ui_id, int32_t request_id, bool* out_cancel);
  using CheckForCancelCallback = base::OnceCallback<void(bool)>;
  using CheckForCancelMojoCallback = base::OnceCallback<void(bool)>;

  virtual void CheckForCancel(int32_t preview_ui_id, int32_t request_id, CheckForCancelCallback callback) = 0;

  virtual void MetafileReadyForPrinting(DidPreviewDocumentParamsPtr params, int32_t request_id) = 0;

  virtual void SetAccessibilityTree(int32_t cookie, const ::ui::AXTreeUpdate& accessibility_tree) = 0;
};



class  PrintPreviewUIProxy
    : public PrintPreviewUI {
 public:
  using InterfaceType = PrintPreviewUI;

  explicit PrintPreviewUIProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetOptionsFromDocument(OptionsFromDocumentParamsPtr params, int32_t request_id) final;
  
  void DidPrepareDocumentForPreview(int32_t document_cookie, int32_t request_id) final;
  
  void DidPreviewPage(DidPreviewPageParamsPtr params, int32_t request_id) final;
  
  void MetafileReadyForPrinting(DidPreviewDocumentParamsPtr params, int32_t request_id) final;
  
  void PrintPreviewFailed(int32_t document_cookie, int32_t request_id) final;
  
  void PrintPreviewCancelled(int32_t document_cookie, int32_t request_id) final;
  
  void PrinterSettingsInvalid(int32_t document_cookie, int32_t request_id) final;
  
  void DidGetDefaultPageLayout(::printing::mojom::PageSizeMarginsPtr page_layout_in_points, const ::gfx::RectF& printable_area_in_points, bool all_pages_have_custom_size, bool all_pages_have_custom_orientation, int32_t request_id) final;
  
  void DidStartPreview(DidStartPreviewParamsPtr params, int32_t request_id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PrintRenderFrameProxy
    : public PrintRenderFrame {
 public:
  using InterfaceType = PrintRenderFrame;

  explicit PrintRenderFrameProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void PrintRequestedPages() final;
  
  void PrintWithParams(PrintPagesParamsPtr params, PrintWithParamsCallback callback) final;
  
  void PrintForSystemDialog() final;
  
  void InitiatePrintPreview(bool has_selection) final;
  
  void SetPrintPreviewUI(::mojo::PendingAssociatedRemote<PrintPreviewUI> preview) final;
  
  void PrintPreview(::base::Value::Dict settings) final;
  
  void OnPrintPreviewDialogClosed() final;
  
  void PrintFrameContent(PrintFrameContentParamsPtr params, PrintFrameContentCallback callback) final;
  
  void ConnectToPdfRenderer() final;
  
  void PrintingDone(bool success) final;
  
  void PrintNodeUnderContextMenu() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PrintManagerHostProxy
    : public PrintManagerHost {
 public:
  using InterfaceType = PrintManagerHost;

  explicit PrintManagerHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DidGetPrintedPagesCount(int32_t cookie, uint32_t number_pages) final;
  
  bool GetDefaultPrintSettings(PrintParamsPtr* out_default_settings) final;
  
  void GetDefaultPrintSettings(GetDefaultPrintSettingsCallback callback) final;
  
  void DidShowPrintDialog() final;
  
  bool DidPrintDocument(DidPrintDocumentParamsPtr params, bool* out_completed) final;
  
  void DidPrintDocument(DidPrintDocumentParamsPtr params, DidPrintDocumentCallback callback) final;
  
  bool IsPrintingEnabled(bool* out_printing_enabled) final;
  
  void IsPrintingEnabled(IsPrintingEnabledCallback callback) final;
  
  bool ScriptedPrint(ScriptedPrintParamsPtr params, PrintPagesParamsPtr* out_settings) final;
  
  void ScriptedPrint(ScriptedPrintParamsPtr params, ScriptedPrintCallback callback) final;
  
  void PrintingFailed(int32_t cookie, PrintFailureReason reason) final;
  
  bool UpdatePrintSettings(::base::Value::Dict job_settings, PrintPagesParamsPtr* out_current_settings) final;
  
  void UpdatePrintSettings(::base::Value::Dict job_settings, UpdatePrintSettingsCallback callback) final;
  
  void SetupScriptedPrintPreview(SetupScriptedPrintPreviewCallback callback) final;
  
  void ShowScriptedPrintPreview(bool is_modifiable) final;
  
  void RequestPrintPreview(RequestPrintPreviewParamsPtr params) final;
  
  bool CheckForCancel(int32_t preview_ui_id, int32_t request_id, bool* out_cancel) final;
  
  void CheckForCancel(int32_t preview_ui_id, int32_t request_id, CheckForCancelCallback callback) final;
  
  void MetafileReadyForPrinting(DidPreviewDocumentParamsPtr params, int32_t request_id) final;
  
  void SetAccessibilityTree(int32_t cookie, const ::ui::AXTreeUpdate& accessibility_tree) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PrintPreviewUIStubDispatch {
 public:
  static bool Accept(PrintPreviewUI* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PrintPreviewUI* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PrintPreviewUI>>
class PrintPreviewUIStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PrintPreviewUIStub() = default;
  ~PrintPreviewUIStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PrintPreviewUIStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PrintPreviewUIStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PrintRenderFrameStubDispatch {
 public:
  static bool Accept(PrintRenderFrame* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PrintRenderFrame* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PrintRenderFrame>>
class PrintRenderFrameStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PrintRenderFrameStub() = default;
  ~PrintRenderFrameStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PrintRenderFrameStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PrintRenderFrameStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PrintManagerHostStubDispatch {
 public:
  static bool Accept(PrintManagerHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PrintManagerHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PrintManagerHost>>
class PrintManagerHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PrintManagerHostStub() = default;
  ~PrintManagerHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PrintManagerHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PrintManagerHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PrintPreviewUIRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PrintRenderFrameRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PrintManagerHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PrintRenderFrameResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PrintManagerHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  PreviewIds {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PreviewIds, T>::value>;
  using DataView = PreviewIdsDataView;
  using Data_ = internal::PreviewIds_Data;

  template <typename... Args>
  static PreviewIdsPtr New(Args&&... args) {
    return PreviewIdsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PreviewIdsPtr From(const U& u) {
    return mojo::TypeConverter<PreviewIdsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PreviewIds>::Convert(*this);
  }


  PreviewIds();

  PreviewIds(
      int32_t request_id,
      int32_t ui_id);


  ~PreviewIds();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PreviewIdsPtr>
  PreviewIdsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PreviewIds::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PreviewIds::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PreviewIds::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PreviewIds::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PreviewIds::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PreviewIds::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PreviewIds_UnserializedMessageContext<
            UserType, PreviewIds::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PreviewIds::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PreviewIds::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PreviewIds_UnserializedMessageContext<
            UserType, PreviewIds::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PreviewIds::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t request_id;
  
  int32_t ui_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PreviewIds::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PreviewIds::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PreviewIds::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PreviewIds::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  RequestPrintPreviewParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RequestPrintPreviewParams, T>::value>;
  using DataView = RequestPrintPreviewParamsDataView;
  using Data_ = internal::RequestPrintPreviewParams_Data;

  template <typename... Args>
  static RequestPrintPreviewParamsPtr New(Args&&... args) {
    return RequestPrintPreviewParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RequestPrintPreviewParamsPtr From(const U& u) {
    return mojo::TypeConverter<RequestPrintPreviewParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RequestPrintPreviewParams>::Convert(*this);
  }


  RequestPrintPreviewParams();

  RequestPrintPreviewParams(
      bool is_modifiable,
      bool webnode_only,
      bool has_selection,
      bool selection_only);


  ~RequestPrintPreviewParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RequestPrintPreviewParamsPtr>
  RequestPrintPreviewParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RequestPrintPreviewParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RequestPrintPreviewParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RequestPrintPreviewParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RequestPrintPreviewParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RequestPrintPreviewParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RequestPrintPreviewParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RequestPrintPreviewParams_UnserializedMessageContext<
            UserType, RequestPrintPreviewParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RequestPrintPreviewParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RequestPrintPreviewParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RequestPrintPreviewParams_UnserializedMessageContext<
            UserType, RequestPrintPreviewParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RequestPrintPreviewParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool is_modifiable;
  
  bool webnode_only;
  
  bool has_selection;
  
  bool selection_only;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RequestPrintPreviewParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RequestPrintPreviewParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RequestPrintPreviewParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RequestPrintPreviewParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  OptionsFromDocumentParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<OptionsFromDocumentParams, T>::value>;
  using DataView = OptionsFromDocumentParamsDataView;
  using Data_ = internal::OptionsFromDocumentParams_Data;

  template <typename... Args>
  static OptionsFromDocumentParamsPtr New(Args&&... args) {
    return OptionsFromDocumentParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OptionsFromDocumentParamsPtr From(const U& u) {
    return mojo::TypeConverter<OptionsFromDocumentParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, OptionsFromDocumentParams>::Convert(*this);
  }


  OptionsFromDocumentParams();

  OptionsFromDocumentParams(
      bool is_scaling_disabled,
      int32_t copies,
      ::printing::mojom::DuplexMode duplex);


  ~OptionsFromDocumentParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OptionsFromDocumentParamsPtr>
  OptionsFromDocumentParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, OptionsFromDocumentParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, OptionsFromDocumentParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, OptionsFromDocumentParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OptionsFromDocumentParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OptionsFromDocumentParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        OptionsFromDocumentParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::OptionsFromDocumentParams_UnserializedMessageContext<
            UserType, OptionsFromDocumentParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<OptionsFromDocumentParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return OptionsFromDocumentParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::OptionsFromDocumentParams_UnserializedMessageContext<
            UserType, OptionsFromDocumentParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<OptionsFromDocumentParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool is_scaling_disabled;
  
  int32_t copies;
  
  ::printing::mojom::DuplexMode duplex;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, OptionsFromDocumentParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, OptionsFromDocumentParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, OptionsFromDocumentParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, OptionsFromDocumentParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}














class  PrintRenderFrame_PrintWithParams_ResponseParam_Result {
 public:
  using DataView = PrintRenderFrame_PrintWithParams_ResponseParam_ResultDataView;
  using Data_ = internal::PrintRenderFrame_PrintWithParams_ResponseParam_Result_Data;
  using Tag = Data_::PrintRenderFrame_PrintWithParams_ResponseParam_Result_Tag;

  template <typename... Args>
  static PrintRenderFrame_PrintWithParams_ResponseParam_ResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |success|.
  static PrintRenderFrame_PrintWithParams_ResponseParam_ResultPtr NewSuccess(
      PrintWithParamsResultDataPtr value);
  // Construct an instance holding |failure|.
  static PrintRenderFrame_PrintWithParams_ResponseParam_ResultPtr NewFailure(
      PrintFailureReason value);

  template <typename U>
  static PrintRenderFrame_PrintWithParams_ResponseParam_ResultPtr From(const U& u) {
    return mojo::TypeConverter<PrintRenderFrame_PrintWithParams_ResponseParam_ResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PrintRenderFrame_PrintWithParams_ResponseParam_Result>::Convert(*this);
  }
  ~PrintRenderFrame_PrintWithParams_ResponseParam_Result();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  PrintRenderFrame_PrintWithParams_ResponseParam_Result(const PrintRenderFrame_PrintWithParams_ResponseParam_Result& other) = delete;
  PrintRenderFrame_PrintWithParams_ResponseParam_Result& operator=(const PrintRenderFrame_PrintWithParams_ResponseParam_Result& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = PrintRenderFrame_PrintWithParams_ResponseParam_ResultPtr>
  PrintRenderFrame_PrintWithParams_ResponseParam_ResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, PrintRenderFrame_PrintWithParams_ResponseParam_Result>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, PrintRenderFrame_PrintWithParams_ResponseParam_Result>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_success() const { return tag_ == Tag::kSuccess; }
  const PrintWithParamsResultDataPtr& get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  PrintWithParamsResultDataPtr& get_success() {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  void set_success(PrintWithParamsResultDataPtr success);

  bool is_failure() const { return tag_ == Tag::kFailure; }
  PrintFailureReason get_failure() const {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  void set_failure(PrintFailureReason failure);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PrintRenderFrame_PrintWithParams_ResponseParam_Result::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<PrintRenderFrame_PrintWithParams_ResponseParam_Result::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
        PrintWithParamsResultDataPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
        PrintFailureReason value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    PrintWithParamsResultDataPtr success;
    PrintFailureReason failure;
  };

  PrintRenderFrame_PrintWithParams_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
      PrintWithParamsResultDataPtr value);
  PrintRenderFrame_PrintWithParams_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
      PrintFailureReason value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};







class  PrintFrameContentParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PrintFrameContentParams, T>::value>;
  using DataView = PrintFrameContentParamsDataView;
  using Data_ = internal::PrintFrameContentParams_Data;

  template <typename... Args>
  static PrintFrameContentParamsPtr New(Args&&... args) {
    return PrintFrameContentParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PrintFrameContentParamsPtr From(const U& u) {
    return mojo::TypeConverter<PrintFrameContentParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PrintFrameContentParams>::Convert(*this);
  }


  PrintFrameContentParams();

  PrintFrameContentParams(
      const ::gfx::Rect& printable_area,
      int32_t document_cookie);


  ~PrintFrameContentParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PrintFrameContentParamsPtr>
  PrintFrameContentParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PrintFrameContentParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PrintFrameContentParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PrintFrameContentParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PrintFrameContentParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PrintFrameContentParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PrintFrameContentParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PrintFrameContentParams_UnserializedMessageContext<
            UserType, PrintFrameContentParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PrintFrameContentParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PrintFrameContentParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PrintFrameContentParams_UnserializedMessageContext<
            UserType, PrintFrameContentParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PrintFrameContentParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::Rect printable_area;
  
  int32_t document_cookie;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PrintFrameContentParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PrintFrameContentParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PrintFrameContentParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PrintFrameContentParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  DidPrintContentParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DidPrintContentParams, T>::value>;
  using DataView = DidPrintContentParamsDataView;
  using Data_ = internal::DidPrintContentParams_Data;

  template <typename... Args>
  static DidPrintContentParamsPtr New(Args&&... args) {
    return DidPrintContentParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DidPrintContentParamsPtr From(const U& u) {
    return mojo::TypeConverter<DidPrintContentParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DidPrintContentParams>::Convert(*this);
  }


  DidPrintContentParams();

  DidPrintContentParams(
      ::base::ReadOnlySharedMemoryRegion metafile_data_region,
      const base::flat_map<uint32_t, ::base::UnguessableToken>& subframe_content_info);

DidPrintContentParams(const DidPrintContentParams&) = delete;
DidPrintContentParams& operator=(const DidPrintContentParams&) = delete;

  ~DidPrintContentParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DidPrintContentParamsPtr>
  DidPrintContentParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DidPrintContentParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DidPrintContentParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DidPrintContentParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DidPrintContentParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DidPrintContentParams_UnserializedMessageContext<
            UserType, DidPrintContentParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DidPrintContentParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DidPrintContentParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DidPrintContentParams_UnserializedMessageContext<
            UserType, DidPrintContentParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DidPrintContentParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::ReadOnlySharedMemoryRegion metafile_data_region;
  
  base::flat_map<uint32_t, ::base::UnguessableToken> subframe_content_info;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DidPrintContentParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DidPrintContentParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DidPrintContentParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DidPrintContentParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  DidStartPreviewParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DidStartPreviewParams, T>::value>;
  using DataView = DidStartPreviewParamsDataView;
  using Data_ = internal::DidStartPreviewParams_Data;

  template <typename... Args>
  static DidStartPreviewParamsPtr New(Args&&... args) {
    return DidStartPreviewParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DidStartPreviewParamsPtr From(const U& u) {
    return mojo::TypeConverter<DidStartPreviewParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DidStartPreviewParams>::Convert(*this);
  }


  DidStartPreviewParams();

  DidStartPreviewParams(
      uint32_t page_count,
      std::vector<uint32_t> pages_to_render,
      int32_t pages_per_sheet,
      const ::gfx::SizeF& page_size,
      int32_t fit_to_page_scaling);


  ~DidStartPreviewParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DidStartPreviewParamsPtr>
  DidStartPreviewParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DidStartPreviewParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DidStartPreviewParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DidStartPreviewParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DidStartPreviewParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DidStartPreviewParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DidStartPreviewParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DidStartPreviewParams_UnserializedMessageContext<
            UserType, DidStartPreviewParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DidStartPreviewParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DidStartPreviewParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DidStartPreviewParams_UnserializedMessageContext<
            UserType, DidStartPreviewParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DidStartPreviewParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t page_count;
  
  std::vector<uint32_t> pages_to_render;
  
  int32_t pages_per_sheet;
  
  ::gfx::SizeF page_size;
  
  int32_t fit_to_page_scaling;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DidStartPreviewParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DidStartPreviewParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DidStartPreviewParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DidStartPreviewParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  DidPreviewPageParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DidPreviewPageParams, T>::value>;
  using DataView = DidPreviewPageParamsDataView;
  using Data_ = internal::DidPreviewPageParams_Data;

  template <typename... Args>
  static DidPreviewPageParamsPtr New(Args&&... args) {
    return DidPreviewPageParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DidPreviewPageParamsPtr From(const U& u) {
    return mojo::TypeConverter<DidPreviewPageParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DidPreviewPageParams>::Convert(*this);
  }


  DidPreviewPageParams();

  DidPreviewPageParams(
      DidPrintContentParamsPtr content,
      uint32_t page_index,
      int32_t document_cookie);

DidPreviewPageParams(const DidPreviewPageParams&) = delete;
DidPreviewPageParams& operator=(const DidPreviewPageParams&) = delete;

  ~DidPreviewPageParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DidPreviewPageParamsPtr>
  DidPreviewPageParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DidPreviewPageParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DidPreviewPageParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DidPreviewPageParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DidPreviewPageParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DidPreviewPageParams_UnserializedMessageContext<
            UserType, DidPreviewPageParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DidPreviewPageParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DidPreviewPageParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DidPreviewPageParams_UnserializedMessageContext<
            UserType, DidPreviewPageParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DidPreviewPageParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  DidPrintContentParamsPtr content;
  
  uint32_t page_index;
  
  int32_t document_cookie;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DidPreviewPageParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DidPreviewPageParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DidPreviewPageParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DidPreviewPageParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  DidPreviewDocumentParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DidPreviewDocumentParams, T>::value>;
  using DataView = DidPreviewDocumentParamsDataView;
  using Data_ = internal::DidPreviewDocumentParams_Data;

  template <typename... Args>
  static DidPreviewDocumentParamsPtr New(Args&&... args) {
    return DidPreviewDocumentParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DidPreviewDocumentParamsPtr From(const U& u) {
    return mojo::TypeConverter<DidPreviewDocumentParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DidPreviewDocumentParams>::Convert(*this);
  }


  DidPreviewDocumentParams();

  DidPreviewDocumentParams(
      DidPrintContentParamsPtr content,
      int32_t document_cookie,
      uint32_t expected_pages_count);

DidPreviewDocumentParams(const DidPreviewDocumentParams&) = delete;
DidPreviewDocumentParams& operator=(const DidPreviewDocumentParams&) = delete;

  ~DidPreviewDocumentParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DidPreviewDocumentParamsPtr>
  DidPreviewDocumentParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DidPreviewDocumentParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DidPreviewDocumentParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DidPreviewDocumentParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DidPreviewDocumentParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DidPreviewDocumentParams_UnserializedMessageContext<
            UserType, DidPreviewDocumentParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DidPreviewDocumentParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DidPreviewDocumentParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DidPreviewDocumentParams_UnserializedMessageContext<
            UserType, DidPreviewDocumentParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DidPreviewDocumentParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  DidPrintContentParamsPtr content;
  
  int32_t document_cookie;
  
  uint32_t expected_pages_count;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DidPreviewDocumentParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DidPreviewDocumentParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DidPreviewDocumentParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DidPreviewDocumentParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PrintParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PrintParams, T>::value>;
  using DataView = PrintParamsDataView;
  using Data_ = internal::PrintParams_Data;

  template <typename... Args>
  static PrintParamsPtr New(Args&&... args) {
    return PrintParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PrintParamsPtr From(const U& u) {
    return mojo::TypeConverter<PrintParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PrintParams>::Convert(*this);
  }


  PrintParams();

  PrintParams(
      const ::gfx::SizeF& page_size,
      const ::gfx::SizeF& content_size,
      const ::gfx::RectF& printable_area,
      float margin_top,
      float margin_left,
      ::printing::mojom::PageOrientation page_orientation,
      const ::gfx::Size& dpi,
      double scale_factor,
      int32_t document_cookie,
      bool selection_only,
      int32_t preview_ui_id,
      int32_t preview_request_id,
      bool is_first_request,
      ::printing::mojom::PrintScalingOption print_scaling_option,
      bool print_to_pdf,
      bool display_header_footer,
      const ::std::u16string& title,
      const ::std::u16string& url,
      const ::std::u16string& header_template,
      const ::std::u16string& footer_template,
      bool rasterize_pdf,
      int32_t rasterize_pdf_dpi,
      bool should_print_backgrounds,
      ::printing::mojom::SkiaDocumentType printed_doc_type,
      bool prefer_css_page_size,
      uint32_t pages_per_sheet,
      std::optional<bool> generate_tagged_pdf,
      ::printing::mojom::GenerateDocumentOutline generate_document_outline);


  ~PrintParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PrintParamsPtr>
  PrintParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PrintParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PrintParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PrintParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PrintParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PrintParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PrintParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PrintParams_UnserializedMessageContext<
            UserType, PrintParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PrintParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PrintParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PrintParams_UnserializedMessageContext<
            UserType, PrintParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PrintParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::SizeF page_size;
  
  ::gfx::SizeF content_size;
  
  ::gfx::RectF printable_area;
  
  float margin_top;
  
  float margin_left;
  
  ::printing::mojom::PageOrientation page_orientation;
  
  ::gfx::Size dpi;
  
  double scale_factor;
  
  int32_t document_cookie;
  
  bool selection_only;
  
  int32_t preview_ui_id;
  
  int32_t preview_request_id;
  
  bool is_first_request;
  
  ::printing::mojom::PrintScalingOption print_scaling_option;
  
  bool print_to_pdf;
  
  bool display_header_footer;
  
  ::std::u16string title;
  
  ::std::u16string url;
  
  ::std::u16string header_template;
  
  ::std::u16string footer_template;
  
  bool rasterize_pdf;
  
  int32_t rasterize_pdf_dpi;
  
  bool should_print_backgrounds;
  
  ::printing::mojom::SkiaDocumentType printed_doc_type;
  
  bool prefer_css_page_size;
  
  uint32_t pages_per_sheet;
  
  std::optional<bool> generate_tagged_pdf;
  
  ::printing::mojom::GenerateDocumentOutline generate_document_outline;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PrintParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PrintParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PrintParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PrintParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PrintPagesParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PrintPagesParams, T>::value>;
  using DataView = PrintPagesParamsDataView;
  using Data_ = internal::PrintPagesParams_Data;

  template <typename... Args>
  static PrintPagesParamsPtr New(Args&&... args) {
    return PrintPagesParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PrintPagesParamsPtr From(const U& u) {
    return mojo::TypeConverter<PrintPagesParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PrintPagesParams>::Convert(*this);
  }


  PrintPagesParams();

  PrintPagesParams(
      PrintParamsPtr params,
      std::vector<::printing::PageRange> pages);

PrintPagesParams(const PrintPagesParams&) = delete;
PrintPagesParams& operator=(const PrintPagesParams&) = delete;

  ~PrintPagesParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PrintPagesParamsPtr>
  PrintPagesParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PrintPagesParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PrintPagesParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PrintPagesParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PrintPagesParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PrintPagesParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PrintPagesParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PrintPagesParams_UnserializedMessageContext<
            UserType, PrintPagesParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PrintPagesParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PrintPagesParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PrintPagesParams_UnserializedMessageContext<
            UserType, PrintPagesParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PrintPagesParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  PrintParamsPtr params;
  
  std::vector<::printing::PageRange> pages;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PrintPagesParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PrintPagesParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PrintPagesParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PrintPagesParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  DidPrintDocumentParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DidPrintDocumentParams, T>::value>;
  using DataView = DidPrintDocumentParamsDataView;
  using Data_ = internal::DidPrintDocumentParams_Data;

  template <typename... Args>
  static DidPrintDocumentParamsPtr New(Args&&... args) {
    return DidPrintDocumentParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DidPrintDocumentParamsPtr From(const U& u) {
    return mojo::TypeConverter<DidPrintDocumentParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DidPrintDocumentParams>::Convert(*this);
  }


  DidPrintDocumentParams();

  DidPrintDocumentParams(
      DidPrintContentParamsPtr content,
      int32_t document_cookie,
      const ::gfx::Size& page_size,
      const ::gfx::Rect& content_area,
      const ::gfx::Point& physical_offsets);

DidPrintDocumentParams(const DidPrintDocumentParams&) = delete;
DidPrintDocumentParams& operator=(const DidPrintDocumentParams&) = delete;

  ~DidPrintDocumentParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DidPrintDocumentParamsPtr>
  DidPrintDocumentParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DidPrintDocumentParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DidPrintDocumentParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DidPrintDocumentParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DidPrintDocumentParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DidPrintDocumentParams_UnserializedMessageContext<
            UserType, DidPrintDocumentParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DidPrintDocumentParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DidPrintDocumentParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DidPrintDocumentParams_UnserializedMessageContext<
            UserType, DidPrintDocumentParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DidPrintDocumentParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  DidPrintContentParamsPtr content;
  
  int32_t document_cookie;
  
  ::gfx::Size page_size;
  
  ::gfx::Rect content_area;
  
  ::gfx::Point physical_offsets;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DidPrintDocumentParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DidPrintDocumentParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DidPrintDocumentParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DidPrintDocumentParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ScriptedPrintParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ScriptedPrintParams, T>::value>;
  using DataView = ScriptedPrintParamsDataView;
  using Data_ = internal::ScriptedPrintParams_Data;

  template <typename... Args>
  static ScriptedPrintParamsPtr New(Args&&... args) {
    return ScriptedPrintParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ScriptedPrintParamsPtr From(const U& u) {
    return mojo::TypeConverter<ScriptedPrintParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ScriptedPrintParams>::Convert(*this);
  }


  ScriptedPrintParams();

  ScriptedPrintParams(
      int32_t cookie,
      uint32_t expected_pages_count,
      bool has_selection,
      bool is_scripted,
      ::printing::mojom::MarginType margin_type);


  ~ScriptedPrintParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ScriptedPrintParamsPtr>
  ScriptedPrintParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ScriptedPrintParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ScriptedPrintParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ScriptedPrintParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScriptedPrintParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScriptedPrintParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ScriptedPrintParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ScriptedPrintParams_UnserializedMessageContext<
            UserType, ScriptedPrintParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ScriptedPrintParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ScriptedPrintParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ScriptedPrintParams_UnserializedMessageContext<
            UserType, ScriptedPrintParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ScriptedPrintParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t cookie;
  
  uint32_t expected_pages_count;
  
  bool has_selection;
  
  bool is_scripted;
  
  ::printing::mojom::MarginType margin_type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ScriptedPrintParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ScriptedPrintParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ScriptedPrintParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ScriptedPrintParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PrintWithParamsResultData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PrintWithParamsResultData, T>::value>;
  using DataView = PrintWithParamsResultDataDataView;
  using Data_ = internal::PrintWithParamsResultData_Data;

  template <typename... Args>
  static PrintWithParamsResultDataPtr New(Args&&... args) {
    return PrintWithParamsResultDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PrintWithParamsResultDataPtr From(const U& u) {
    return mojo::TypeConverter<PrintWithParamsResultDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PrintWithParamsResultData>::Convert(*this);
  }


  PrintWithParamsResultData();

  PrintWithParamsResultData(
      DidPrintDocumentParamsPtr params,
      const ::ui::AXTreeUpdate& accessibility_tree,
      ::printing::mojom::GenerateDocumentOutline generate_document_outline);

PrintWithParamsResultData(const PrintWithParamsResultData&) = delete;
PrintWithParamsResultData& operator=(const PrintWithParamsResultData&) = delete;

  ~PrintWithParamsResultData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PrintWithParamsResultDataPtr>
  PrintWithParamsResultDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PrintWithParamsResultData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PrintWithParamsResultData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PrintWithParamsResultData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PrintWithParamsResultData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PrintWithParamsResultData_UnserializedMessageContext<
            UserType, PrintWithParamsResultData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PrintWithParamsResultData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PrintWithParamsResultData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PrintWithParamsResultData_UnserializedMessageContext<
            UserType, PrintWithParamsResultData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PrintWithParamsResultData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  DidPrintDocumentParamsPtr params;
  
  ::ui::AXTreeUpdate accessibility_tree;
  
  ::printing::mojom::GenerateDocumentOutline generate_document_outline;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PrintWithParamsResultData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PrintWithParamsResultData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PrintWithParamsResultData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PrintWithParamsResultData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
PrintRenderFrame_PrintWithParams_ResponseParam_ResultPtr PrintRenderFrame_PrintWithParams_ResponseParam_Result::Clone() const {
  switch (tag_) {
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(data_.success));
    case Tag::kFailure:
      return NewFailure(
          mojo::Clone(data_.failure));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, PrintRenderFrame_PrintWithParams_ResponseParam_Result>::value>::type*>
bool PrintRenderFrame_PrintWithParams_ResponseParam_Result::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSuccess:
      return mojo::Equals(data_.success, other.data_.success);
    case Tag::kFailure:
      return mojo::Equals(data_.failure, other.data_.failure);
  }

  return false;
}
template <typename StructPtrType>
PreviewIdsPtr PreviewIds::Clone() const {
  return New(
      mojo::Clone(request_id),
      mojo::Clone(ui_id)
  );
}

template <typename T, PreviewIds::EnableIfSame<T>*>
bool PreviewIds::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->request_id, other_struct.request_id))
    return false;
  if (!mojo::Equals(this->ui_id, other_struct.ui_id))
    return false;
  return true;
}

template <typename T, PreviewIds::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.request_id < rhs.request_id)
    return true;
  if (rhs.request_id < lhs.request_id)
    return false;
  if (lhs.ui_id < rhs.ui_id)
    return true;
  if (rhs.ui_id < lhs.ui_id)
    return false;
  return false;
}
template <typename StructPtrType>
RequestPrintPreviewParamsPtr RequestPrintPreviewParams::Clone() const {
  return New(
      mojo::Clone(is_modifiable),
      mojo::Clone(webnode_only),
      mojo::Clone(has_selection),
      mojo::Clone(selection_only)
  );
}

template <typename T, RequestPrintPreviewParams::EnableIfSame<T>*>
bool RequestPrintPreviewParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->is_modifiable, other_struct.is_modifiable))
    return false;
  if (!mojo::Equals(this->webnode_only, other_struct.webnode_only))
    return false;
  if (!mojo::Equals(this->has_selection, other_struct.has_selection))
    return false;
  if (!mojo::Equals(this->selection_only, other_struct.selection_only))
    return false;
  return true;
}

template <typename T, RequestPrintPreviewParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.is_modifiable < rhs.is_modifiable)
    return true;
  if (rhs.is_modifiable < lhs.is_modifiable)
    return false;
  if (lhs.webnode_only < rhs.webnode_only)
    return true;
  if (rhs.webnode_only < lhs.webnode_only)
    return false;
  if (lhs.has_selection < rhs.has_selection)
    return true;
  if (rhs.has_selection < lhs.has_selection)
    return false;
  if (lhs.selection_only < rhs.selection_only)
    return true;
  if (rhs.selection_only < lhs.selection_only)
    return false;
  return false;
}
template <typename StructPtrType>
PrintFrameContentParamsPtr PrintFrameContentParams::Clone() const {
  return New(
      mojo::Clone(printable_area),
      mojo::Clone(document_cookie)
  );
}

template <typename T, PrintFrameContentParams::EnableIfSame<T>*>
bool PrintFrameContentParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->printable_area, other_struct.printable_area))
    return false;
  if (!mojo::Equals(this->document_cookie, other_struct.document_cookie))
    return false;
  return true;
}

template <typename T, PrintFrameContentParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.printable_area < rhs.printable_area)
    return true;
  if (rhs.printable_area < lhs.printable_area)
    return false;
  if (lhs.document_cookie < rhs.document_cookie)
    return true;
  if (rhs.document_cookie < lhs.document_cookie)
    return false;
  return false;
}
template <typename StructPtrType>
OptionsFromDocumentParamsPtr OptionsFromDocumentParams::Clone() const {
  return New(
      mojo::Clone(is_scaling_disabled),
      mojo::Clone(copies),
      mojo::Clone(duplex)
  );
}

template <typename T, OptionsFromDocumentParams::EnableIfSame<T>*>
bool OptionsFromDocumentParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->is_scaling_disabled, other_struct.is_scaling_disabled))
    return false;
  if (!mojo::Equals(this->copies, other_struct.copies))
    return false;
  if (!mojo::Equals(this->duplex, other_struct.duplex))
    return false;
  return true;
}

template <typename T, OptionsFromDocumentParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.is_scaling_disabled < rhs.is_scaling_disabled)
    return true;
  if (rhs.is_scaling_disabled < lhs.is_scaling_disabled)
    return false;
  if (lhs.copies < rhs.copies)
    return true;
  if (rhs.copies < lhs.copies)
    return false;
  if (lhs.duplex < rhs.duplex)
    return true;
  if (rhs.duplex < lhs.duplex)
    return false;
  return false;
}
template <typename StructPtrType>
DidPrintContentParamsPtr DidPrintContentParams::Clone() const {
  return New(
      mojo::Clone(metafile_data_region),
      mojo::Clone(subframe_content_info)
  );
}

template <typename T, DidPrintContentParams::EnableIfSame<T>*>
bool DidPrintContentParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->metafile_data_region, other_struct.metafile_data_region))
    return false;
  if (!mojo::Equals(this->subframe_content_info, other_struct.subframe_content_info))
    return false;
  return true;
}

template <typename T, DidPrintContentParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.metafile_data_region < rhs.metafile_data_region)
    return true;
  if (rhs.metafile_data_region < lhs.metafile_data_region)
    return false;
  if (lhs.subframe_content_info < rhs.subframe_content_info)
    return true;
  if (rhs.subframe_content_info < lhs.subframe_content_info)
    return false;
  return false;
}
template <typename StructPtrType>
DidStartPreviewParamsPtr DidStartPreviewParams::Clone() const {
  return New(
      mojo::Clone(page_count),
      mojo::Clone(pages_to_render),
      mojo::Clone(pages_per_sheet),
      mojo::Clone(page_size),
      mojo::Clone(fit_to_page_scaling)
  );
}

template <typename T, DidStartPreviewParams::EnableIfSame<T>*>
bool DidStartPreviewParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->page_count, other_struct.page_count))
    return false;
  if (!mojo::Equals(this->pages_to_render, other_struct.pages_to_render))
    return false;
  if (!mojo::Equals(this->pages_per_sheet, other_struct.pages_per_sheet))
    return false;
  if (!mojo::Equals(this->page_size, other_struct.page_size))
    return false;
  if (!mojo::Equals(this->fit_to_page_scaling, other_struct.fit_to_page_scaling))
    return false;
  return true;
}

template <typename T, DidStartPreviewParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.page_count < rhs.page_count)
    return true;
  if (rhs.page_count < lhs.page_count)
    return false;
  if (lhs.pages_to_render < rhs.pages_to_render)
    return true;
  if (rhs.pages_to_render < lhs.pages_to_render)
    return false;
  if (lhs.pages_per_sheet < rhs.pages_per_sheet)
    return true;
  if (rhs.pages_per_sheet < lhs.pages_per_sheet)
    return false;
  if (lhs.page_size < rhs.page_size)
    return true;
  if (rhs.page_size < lhs.page_size)
    return false;
  if (lhs.fit_to_page_scaling < rhs.fit_to_page_scaling)
    return true;
  if (rhs.fit_to_page_scaling < lhs.fit_to_page_scaling)
    return false;
  return false;
}
template <typename StructPtrType>
DidPreviewPageParamsPtr DidPreviewPageParams::Clone() const {
  return New(
      mojo::Clone(content),
      mojo::Clone(page_index),
      mojo::Clone(document_cookie)
  );
}

template <typename T, DidPreviewPageParams::EnableIfSame<T>*>
bool DidPreviewPageParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->content, other_struct.content))
    return false;
  if (!mojo::Equals(this->page_index, other_struct.page_index))
    return false;
  if (!mojo::Equals(this->document_cookie, other_struct.document_cookie))
    return false;
  return true;
}

template <typename T, DidPreviewPageParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.content < rhs.content)
    return true;
  if (rhs.content < lhs.content)
    return false;
  if (lhs.page_index < rhs.page_index)
    return true;
  if (rhs.page_index < lhs.page_index)
    return false;
  if (lhs.document_cookie < rhs.document_cookie)
    return true;
  if (rhs.document_cookie < lhs.document_cookie)
    return false;
  return false;
}
template <typename StructPtrType>
DidPreviewDocumentParamsPtr DidPreviewDocumentParams::Clone() const {
  return New(
      mojo::Clone(content),
      mojo::Clone(document_cookie),
      mojo::Clone(expected_pages_count)
  );
}

template <typename T, DidPreviewDocumentParams::EnableIfSame<T>*>
bool DidPreviewDocumentParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->content, other_struct.content))
    return false;
  if (!mojo::Equals(this->document_cookie, other_struct.document_cookie))
    return false;
  if (!mojo::Equals(this->expected_pages_count, other_struct.expected_pages_count))
    return false;
  return true;
}

template <typename T, DidPreviewDocumentParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.content < rhs.content)
    return true;
  if (rhs.content < lhs.content)
    return false;
  if (lhs.document_cookie < rhs.document_cookie)
    return true;
  if (rhs.document_cookie < lhs.document_cookie)
    return false;
  if (lhs.expected_pages_count < rhs.expected_pages_count)
    return true;
  if (rhs.expected_pages_count < lhs.expected_pages_count)
    return false;
  return false;
}
template <typename StructPtrType>
PrintParamsPtr PrintParams::Clone() const {
  return New(
      mojo::Clone(page_size),
      mojo::Clone(content_size),
      mojo::Clone(printable_area),
      mojo::Clone(margin_top),
      mojo::Clone(margin_left),
      mojo::Clone(page_orientation),
      mojo::Clone(dpi),
      mojo::Clone(scale_factor),
      mojo::Clone(document_cookie),
      mojo::Clone(selection_only),
      mojo::Clone(preview_ui_id),
      mojo::Clone(preview_request_id),
      mojo::Clone(is_first_request),
      mojo::Clone(print_scaling_option),
      mojo::Clone(print_to_pdf),
      mojo::Clone(display_header_footer),
      mojo::Clone(title),
      mojo::Clone(url),
      mojo::Clone(header_template),
      mojo::Clone(footer_template),
      mojo::Clone(rasterize_pdf),
      mojo::Clone(rasterize_pdf_dpi),
      mojo::Clone(should_print_backgrounds),
      mojo::Clone(printed_doc_type),
      mojo::Clone(prefer_css_page_size),
      mojo::Clone(pages_per_sheet),
      mojo::Clone(generate_tagged_pdf),
      mojo::Clone(generate_document_outline)
  );
}

template <typename T, PrintParams::EnableIfSame<T>*>
bool PrintParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->page_size, other_struct.page_size))
    return false;
  if (!mojo::Equals(this->content_size, other_struct.content_size))
    return false;
  if (!mojo::Equals(this->printable_area, other_struct.printable_area))
    return false;
  if (!mojo::Equals(this->margin_top, other_struct.margin_top))
    return false;
  if (!mojo::Equals(this->margin_left, other_struct.margin_left))
    return false;
  if (!mojo::Equals(this->page_orientation, other_struct.page_orientation))
    return false;
  if (!mojo::Equals(this->dpi, other_struct.dpi))
    return false;
  if (!mojo::Equals(this->scale_factor, other_struct.scale_factor))
    return false;
  if (!mojo::Equals(this->document_cookie, other_struct.document_cookie))
    return false;
  if (!mojo::Equals(this->selection_only, other_struct.selection_only))
    return false;
  if (!mojo::Equals(this->preview_ui_id, other_struct.preview_ui_id))
    return false;
  if (!mojo::Equals(this->preview_request_id, other_struct.preview_request_id))
    return false;
  if (!mojo::Equals(this->is_first_request, other_struct.is_first_request))
    return false;
  if (!mojo::Equals(this->print_scaling_option, other_struct.print_scaling_option))
    return false;
  if (!mojo::Equals(this->print_to_pdf, other_struct.print_to_pdf))
    return false;
  if (!mojo::Equals(this->display_header_footer, other_struct.display_header_footer))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->header_template, other_struct.header_template))
    return false;
  if (!mojo::Equals(this->footer_template, other_struct.footer_template))
    return false;
  if (!mojo::Equals(this->rasterize_pdf, other_struct.rasterize_pdf))
    return false;
  if (!mojo::Equals(this->rasterize_pdf_dpi, other_struct.rasterize_pdf_dpi))
    return false;
  if (!mojo::Equals(this->should_print_backgrounds, other_struct.should_print_backgrounds))
    return false;
  if (!mojo::Equals(this->printed_doc_type, other_struct.printed_doc_type))
    return false;
  if (!mojo::Equals(this->prefer_css_page_size, other_struct.prefer_css_page_size))
    return false;
  if (!mojo::Equals(this->pages_per_sheet, other_struct.pages_per_sheet))
    return false;
  if (!mojo::Equals(this->generate_tagged_pdf, other_struct.generate_tagged_pdf))
    return false;
  if (!mojo::Equals(this->generate_document_outline, other_struct.generate_document_outline))
    return false;
  return true;
}

template <typename T, PrintParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.page_size < rhs.page_size)
    return true;
  if (rhs.page_size < lhs.page_size)
    return false;
  if (lhs.content_size < rhs.content_size)
    return true;
  if (rhs.content_size < lhs.content_size)
    return false;
  if (lhs.printable_area < rhs.printable_area)
    return true;
  if (rhs.printable_area < lhs.printable_area)
    return false;
  if (lhs.margin_top < rhs.margin_top)
    return true;
  if (rhs.margin_top < lhs.margin_top)
    return false;
  if (lhs.margin_left < rhs.margin_left)
    return true;
  if (rhs.margin_left < lhs.margin_left)
    return false;
  if (lhs.page_orientation < rhs.page_orientation)
    return true;
  if (rhs.page_orientation < lhs.page_orientation)
    return false;
  if (lhs.dpi < rhs.dpi)
    return true;
  if (rhs.dpi < lhs.dpi)
    return false;
  if (lhs.scale_factor < rhs.scale_factor)
    return true;
  if (rhs.scale_factor < lhs.scale_factor)
    return false;
  if (lhs.document_cookie < rhs.document_cookie)
    return true;
  if (rhs.document_cookie < lhs.document_cookie)
    return false;
  if (lhs.selection_only < rhs.selection_only)
    return true;
  if (rhs.selection_only < lhs.selection_only)
    return false;
  if (lhs.preview_ui_id < rhs.preview_ui_id)
    return true;
  if (rhs.preview_ui_id < lhs.preview_ui_id)
    return false;
  if (lhs.preview_request_id < rhs.preview_request_id)
    return true;
  if (rhs.preview_request_id < lhs.preview_request_id)
    return false;
  if (lhs.is_first_request < rhs.is_first_request)
    return true;
  if (rhs.is_first_request < lhs.is_first_request)
    return false;
  if (lhs.print_scaling_option < rhs.print_scaling_option)
    return true;
  if (rhs.print_scaling_option < lhs.print_scaling_option)
    return false;
  if (lhs.print_to_pdf < rhs.print_to_pdf)
    return true;
  if (rhs.print_to_pdf < lhs.print_to_pdf)
    return false;
  if (lhs.display_header_footer < rhs.display_header_footer)
    return true;
  if (rhs.display_header_footer < lhs.display_header_footer)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.header_template < rhs.header_template)
    return true;
  if (rhs.header_template < lhs.header_template)
    return false;
  if (lhs.footer_template < rhs.footer_template)
    return true;
  if (rhs.footer_template < lhs.footer_template)
    return false;
  if (lhs.rasterize_pdf < rhs.rasterize_pdf)
    return true;
  if (rhs.rasterize_pdf < lhs.rasterize_pdf)
    return false;
  if (lhs.rasterize_pdf_dpi < rhs.rasterize_pdf_dpi)
    return true;
  if (rhs.rasterize_pdf_dpi < lhs.rasterize_pdf_dpi)
    return false;
  if (lhs.should_print_backgrounds < rhs.should_print_backgrounds)
    return true;
  if (rhs.should_print_backgrounds < lhs.should_print_backgrounds)
    return false;
  if (lhs.printed_doc_type < rhs.printed_doc_type)
    return true;
  if (rhs.printed_doc_type < lhs.printed_doc_type)
    return false;
  if (lhs.prefer_css_page_size < rhs.prefer_css_page_size)
    return true;
  if (rhs.prefer_css_page_size < lhs.prefer_css_page_size)
    return false;
  if (lhs.pages_per_sheet < rhs.pages_per_sheet)
    return true;
  if (rhs.pages_per_sheet < lhs.pages_per_sheet)
    return false;
  if (lhs.generate_tagged_pdf < rhs.generate_tagged_pdf)
    return true;
  if (rhs.generate_tagged_pdf < lhs.generate_tagged_pdf)
    return false;
  if (lhs.generate_document_outline < rhs.generate_document_outline)
    return true;
  if (rhs.generate_document_outline < lhs.generate_document_outline)
    return false;
  return false;
}
template <typename StructPtrType>
PrintPagesParamsPtr PrintPagesParams::Clone() const {
  return New(
      mojo::Clone(params),
      mojo::Clone(pages)
  );
}

template <typename T, PrintPagesParams::EnableIfSame<T>*>
bool PrintPagesParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->params, other_struct.params))
    return false;
  if (!mojo::Equals(this->pages, other_struct.pages))
    return false;
  return true;
}

template <typename T, PrintPagesParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.params < rhs.params)
    return true;
  if (rhs.params < lhs.params)
    return false;
  if (lhs.pages < rhs.pages)
    return true;
  if (rhs.pages < lhs.pages)
    return false;
  return false;
}
template <typename StructPtrType>
DidPrintDocumentParamsPtr DidPrintDocumentParams::Clone() const {
  return New(
      mojo::Clone(content),
      mojo::Clone(document_cookie),
      mojo::Clone(page_size),
      mojo::Clone(content_area),
      mojo::Clone(physical_offsets)
  );
}

template <typename T, DidPrintDocumentParams::EnableIfSame<T>*>
bool DidPrintDocumentParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->content, other_struct.content))
    return false;
  if (!mojo::Equals(this->document_cookie, other_struct.document_cookie))
    return false;
  if (!mojo::Equals(this->page_size, other_struct.page_size))
    return false;
  if (!mojo::Equals(this->content_area, other_struct.content_area))
    return false;
  if (!mojo::Equals(this->physical_offsets, other_struct.physical_offsets))
    return false;
  return true;
}

template <typename T, DidPrintDocumentParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.content < rhs.content)
    return true;
  if (rhs.content < lhs.content)
    return false;
  if (lhs.document_cookie < rhs.document_cookie)
    return true;
  if (rhs.document_cookie < lhs.document_cookie)
    return false;
  if (lhs.page_size < rhs.page_size)
    return true;
  if (rhs.page_size < lhs.page_size)
    return false;
  if (lhs.content_area < rhs.content_area)
    return true;
  if (rhs.content_area < lhs.content_area)
    return false;
  if (lhs.physical_offsets < rhs.physical_offsets)
    return true;
  if (rhs.physical_offsets < lhs.physical_offsets)
    return false;
  return false;
}
template <typename StructPtrType>
ScriptedPrintParamsPtr ScriptedPrintParams::Clone() const {
  return New(
      mojo::Clone(cookie),
      mojo::Clone(expected_pages_count),
      mojo::Clone(has_selection),
      mojo::Clone(is_scripted),
      mojo::Clone(margin_type)
  );
}

template <typename T, ScriptedPrintParams::EnableIfSame<T>*>
bool ScriptedPrintParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->cookie, other_struct.cookie))
    return false;
  if (!mojo::Equals(this->expected_pages_count, other_struct.expected_pages_count))
    return false;
  if (!mojo::Equals(this->has_selection, other_struct.has_selection))
    return false;
  if (!mojo::Equals(this->is_scripted, other_struct.is_scripted))
    return false;
  if (!mojo::Equals(this->margin_type, other_struct.margin_type))
    return false;
  return true;
}

template <typename T, ScriptedPrintParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.cookie < rhs.cookie)
    return true;
  if (rhs.cookie < lhs.cookie)
    return false;
  if (lhs.expected_pages_count < rhs.expected_pages_count)
    return true;
  if (rhs.expected_pages_count < lhs.expected_pages_count)
    return false;
  if (lhs.has_selection < rhs.has_selection)
    return true;
  if (rhs.has_selection < lhs.has_selection)
    return false;
  if (lhs.is_scripted < rhs.is_scripted)
    return true;
  if (rhs.is_scripted < lhs.is_scripted)
    return false;
  if (lhs.margin_type < rhs.margin_type)
    return true;
  if (rhs.margin_type < lhs.margin_type)
    return false;
  return false;
}
template <typename StructPtrType>
PrintWithParamsResultDataPtr PrintWithParamsResultData::Clone() const {
  return New(
      mojo::Clone(params),
      mojo::Clone(accessibility_tree),
      mojo::Clone(generate_document_outline)
  );
}

template <typename T, PrintWithParamsResultData::EnableIfSame<T>*>
bool PrintWithParamsResultData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->params, other_struct.params))
    return false;
  if (!mojo::Equals(this->accessibility_tree, other_struct.accessibility_tree))
    return false;
  if (!mojo::Equals(this->generate_document_outline, other_struct.generate_document_outline))
    return false;
  return true;
}

template <typename T, PrintWithParamsResultData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.params < rhs.params)
    return true;
  if (rhs.params < lhs.params)
    return false;
  if (lhs.accessibility_tree < rhs.accessibility_tree)
    return true;
  if (rhs.accessibility_tree < lhs.accessibility_tree)
    return false;
  if (lhs.generate_document_outline < rhs.generate_document_outline)
    return true;
  if (rhs.generate_document_outline < lhs.generate_document_outline)
    return false;
  return false;
}


}  // printing::mojom

namespace mojo {


template <>
struct  StructTraits<::printing::mojom::PreviewIds::DataView,
                                         ::printing::mojom::PreviewIdsPtr> {
  static bool IsNull(const ::printing::mojom::PreviewIdsPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::PreviewIdsPtr* output) { output->reset(); }

  static decltype(::printing::mojom::PreviewIds::request_id) request_id(
      const ::printing::mojom::PreviewIdsPtr& input) {
    return input->request_id;
  }

  static decltype(::printing::mojom::PreviewIds::ui_id) ui_id(
      const ::printing::mojom::PreviewIdsPtr& input) {
    return input->ui_id;
  }

  static bool Read(::printing::mojom::PreviewIds::DataView input, ::printing::mojom::PreviewIdsPtr* output);
};


template <>
struct  StructTraits<::printing::mojom::RequestPrintPreviewParams::DataView,
                                         ::printing::mojom::RequestPrintPreviewParamsPtr> {
  static bool IsNull(const ::printing::mojom::RequestPrintPreviewParamsPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::RequestPrintPreviewParamsPtr* output) { output->reset(); }

  static decltype(::printing::mojom::RequestPrintPreviewParams::is_modifiable) is_modifiable(
      const ::printing::mojom::RequestPrintPreviewParamsPtr& input) {
    return input->is_modifiable;
  }

  static decltype(::printing::mojom::RequestPrintPreviewParams::webnode_only) webnode_only(
      const ::printing::mojom::RequestPrintPreviewParamsPtr& input) {
    return input->webnode_only;
  }

  static decltype(::printing::mojom::RequestPrintPreviewParams::has_selection) has_selection(
      const ::printing::mojom::RequestPrintPreviewParamsPtr& input) {
    return input->has_selection;
  }

  static decltype(::printing::mojom::RequestPrintPreviewParams::selection_only) selection_only(
      const ::printing::mojom::RequestPrintPreviewParamsPtr& input) {
    return input->selection_only;
  }

  static bool Read(::printing::mojom::RequestPrintPreviewParams::DataView input, ::printing::mojom::RequestPrintPreviewParamsPtr* output);
};


template <>
struct  StructTraits<::printing::mojom::PrintFrameContentParams::DataView,
                                         ::printing::mojom::PrintFrameContentParamsPtr> {
  static bool IsNull(const ::printing::mojom::PrintFrameContentParamsPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::PrintFrameContentParamsPtr* output) { output->reset(); }

  static const decltype(::printing::mojom::PrintFrameContentParams::printable_area)& printable_area(
      const ::printing::mojom::PrintFrameContentParamsPtr& input) {
    return input->printable_area;
  }

  static decltype(::printing::mojom::PrintFrameContentParams::document_cookie) document_cookie(
      const ::printing::mojom::PrintFrameContentParamsPtr& input) {
    return input->document_cookie;
  }

  static bool Read(::printing::mojom::PrintFrameContentParams::DataView input, ::printing::mojom::PrintFrameContentParamsPtr* output);
};


template <>
struct  StructTraits<::printing::mojom::OptionsFromDocumentParams::DataView,
                                         ::printing::mojom::OptionsFromDocumentParamsPtr> {
  static bool IsNull(const ::printing::mojom::OptionsFromDocumentParamsPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::OptionsFromDocumentParamsPtr* output) { output->reset(); }

  static decltype(::printing::mojom::OptionsFromDocumentParams::is_scaling_disabled) is_scaling_disabled(
      const ::printing::mojom::OptionsFromDocumentParamsPtr& input) {
    return input->is_scaling_disabled;
  }

  static decltype(::printing::mojom::OptionsFromDocumentParams::copies) copies(
      const ::printing::mojom::OptionsFromDocumentParamsPtr& input) {
    return input->copies;
  }

  static decltype(::printing::mojom::OptionsFromDocumentParams::duplex) duplex(
      const ::printing::mojom::OptionsFromDocumentParamsPtr& input) {
    return input->duplex;
  }

  static bool Read(::printing::mojom::OptionsFromDocumentParams::DataView input, ::printing::mojom::OptionsFromDocumentParamsPtr* output);
};


template <>
struct  StructTraits<::printing::mojom::DidPrintContentParams::DataView,
                                         ::printing::mojom::DidPrintContentParamsPtr> {
  static bool IsNull(const ::printing::mojom::DidPrintContentParamsPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::DidPrintContentParamsPtr* output) { output->reset(); }

  static  decltype(::printing::mojom::DidPrintContentParams::metafile_data_region)& metafile_data_region(
       ::printing::mojom::DidPrintContentParamsPtr& input) {
    return input->metafile_data_region;
  }

  static const decltype(::printing::mojom::DidPrintContentParams::subframe_content_info)& subframe_content_info(
      const ::printing::mojom::DidPrintContentParamsPtr& input) {
    return input->subframe_content_info;
  }

  static bool Read(::printing::mojom::DidPrintContentParams::DataView input, ::printing::mojom::DidPrintContentParamsPtr* output);
};


template <>
struct  StructTraits<::printing::mojom::DidStartPreviewParams::DataView,
                                         ::printing::mojom::DidStartPreviewParamsPtr> {
  static bool IsNull(const ::printing::mojom::DidStartPreviewParamsPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::DidStartPreviewParamsPtr* output) { output->reset(); }

  static decltype(::printing::mojom::DidStartPreviewParams::page_count) page_count(
      const ::printing::mojom::DidStartPreviewParamsPtr& input) {
    return input->page_count;
  }

  static const decltype(::printing::mojom::DidStartPreviewParams::pages_to_render)& pages_to_render(
      const ::printing::mojom::DidStartPreviewParamsPtr& input) {
    return input->pages_to_render;
  }

  static decltype(::printing::mojom::DidStartPreviewParams::pages_per_sheet) pages_per_sheet(
      const ::printing::mojom::DidStartPreviewParamsPtr& input) {
    return input->pages_per_sheet;
  }

  static const decltype(::printing::mojom::DidStartPreviewParams::page_size)& page_size(
      const ::printing::mojom::DidStartPreviewParamsPtr& input) {
    return input->page_size;
  }

  static decltype(::printing::mojom::DidStartPreviewParams::fit_to_page_scaling) fit_to_page_scaling(
      const ::printing::mojom::DidStartPreviewParamsPtr& input) {
    return input->fit_to_page_scaling;
  }

  static bool Read(::printing::mojom::DidStartPreviewParams::DataView input, ::printing::mojom::DidStartPreviewParamsPtr* output);
};


template <>
struct  StructTraits<::printing::mojom::DidPreviewPageParams::DataView,
                                         ::printing::mojom::DidPreviewPageParamsPtr> {
  static bool IsNull(const ::printing::mojom::DidPreviewPageParamsPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::DidPreviewPageParamsPtr* output) { output->reset(); }

  static  decltype(::printing::mojom::DidPreviewPageParams::content)& content(
       ::printing::mojom::DidPreviewPageParamsPtr& input) {
    return input->content;
  }

  static decltype(::printing::mojom::DidPreviewPageParams::page_index) page_index(
      const ::printing::mojom::DidPreviewPageParamsPtr& input) {
    return input->page_index;
  }

  static decltype(::printing::mojom::DidPreviewPageParams::document_cookie) document_cookie(
      const ::printing::mojom::DidPreviewPageParamsPtr& input) {
    return input->document_cookie;
  }

  static bool Read(::printing::mojom::DidPreviewPageParams::DataView input, ::printing::mojom::DidPreviewPageParamsPtr* output);
};


template <>
struct  StructTraits<::printing::mojom::DidPreviewDocumentParams::DataView,
                                         ::printing::mojom::DidPreviewDocumentParamsPtr> {
  static bool IsNull(const ::printing::mojom::DidPreviewDocumentParamsPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::DidPreviewDocumentParamsPtr* output) { output->reset(); }

  static  decltype(::printing::mojom::DidPreviewDocumentParams::content)& content(
       ::printing::mojom::DidPreviewDocumentParamsPtr& input) {
    return input->content;
  }

  static decltype(::printing::mojom::DidPreviewDocumentParams::document_cookie) document_cookie(
      const ::printing::mojom::DidPreviewDocumentParamsPtr& input) {
    return input->document_cookie;
  }

  static decltype(::printing::mojom::DidPreviewDocumentParams::expected_pages_count) expected_pages_count(
      const ::printing::mojom::DidPreviewDocumentParamsPtr& input) {
    return input->expected_pages_count;
  }

  static bool Read(::printing::mojom::DidPreviewDocumentParams::DataView input, ::printing::mojom::DidPreviewDocumentParamsPtr* output);
};


template <>
struct  StructTraits<::printing::mojom::PrintParams::DataView,
                                         ::printing::mojom::PrintParamsPtr> {
  static bool IsNull(const ::printing::mojom::PrintParamsPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::PrintParamsPtr* output) { output->reset(); }

  static const decltype(::printing::mojom::PrintParams::page_size)& page_size(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->page_size;
  }

  static const decltype(::printing::mojom::PrintParams::content_size)& content_size(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->content_size;
  }

  static const decltype(::printing::mojom::PrintParams::printable_area)& printable_area(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->printable_area;
  }

  static decltype(::printing::mojom::PrintParams::margin_top) margin_top(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->margin_top;
  }

  static decltype(::printing::mojom::PrintParams::margin_left) margin_left(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->margin_left;
  }

  static decltype(::printing::mojom::PrintParams::page_orientation) page_orientation(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->page_orientation;
  }

  static const decltype(::printing::mojom::PrintParams::dpi)& dpi(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->dpi;
  }

  static decltype(::printing::mojom::PrintParams::scale_factor) scale_factor(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->scale_factor;
  }

  static decltype(::printing::mojom::PrintParams::document_cookie) document_cookie(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->document_cookie;
  }

  static decltype(::printing::mojom::PrintParams::selection_only) selection_only(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->selection_only;
  }

  static decltype(::printing::mojom::PrintParams::preview_ui_id) preview_ui_id(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->preview_ui_id;
  }

  static decltype(::printing::mojom::PrintParams::preview_request_id) preview_request_id(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->preview_request_id;
  }

  static decltype(::printing::mojom::PrintParams::is_first_request) is_first_request(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->is_first_request;
  }

  static decltype(::printing::mojom::PrintParams::print_scaling_option) print_scaling_option(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->print_scaling_option;
  }

  static decltype(::printing::mojom::PrintParams::print_to_pdf) print_to_pdf(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->print_to_pdf;
  }

  static decltype(::printing::mojom::PrintParams::display_header_footer) display_header_footer(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->display_header_footer;
  }

  static const decltype(::printing::mojom::PrintParams::title)& title(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->title;
  }

  static const decltype(::printing::mojom::PrintParams::url)& url(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->url;
  }

  static const decltype(::printing::mojom::PrintParams::header_template)& header_template(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->header_template;
  }

  static const decltype(::printing::mojom::PrintParams::footer_template)& footer_template(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->footer_template;
  }

  static decltype(::printing::mojom::PrintParams::rasterize_pdf) rasterize_pdf(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->rasterize_pdf;
  }

  static decltype(::printing::mojom::PrintParams::rasterize_pdf_dpi) rasterize_pdf_dpi(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->rasterize_pdf_dpi;
  }

  static decltype(::printing::mojom::PrintParams::should_print_backgrounds) should_print_backgrounds(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->should_print_backgrounds;
  }

  static decltype(::printing::mojom::PrintParams::printed_doc_type) printed_doc_type(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->printed_doc_type;
  }

  static decltype(::printing::mojom::PrintParams::prefer_css_page_size) prefer_css_page_size(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->prefer_css_page_size;
  }

  static decltype(::printing::mojom::PrintParams::pages_per_sheet) pages_per_sheet(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->pages_per_sheet;
  }

  static decltype(::printing::mojom::PrintParams::generate_tagged_pdf) generate_tagged_pdf(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->generate_tagged_pdf;
  }

  static decltype(::printing::mojom::PrintParams::generate_document_outline) generate_document_outline(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->generate_document_outline;
  }

  static bool Read(::printing::mojom::PrintParams::DataView input, ::printing::mojom::PrintParamsPtr* output);
};


template <>
struct  StructTraits<::printing::mojom::PrintPagesParams::DataView,
                                         ::printing::mojom::PrintPagesParamsPtr> {
  static bool IsNull(const ::printing::mojom::PrintPagesParamsPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::PrintPagesParamsPtr* output) { output->reset(); }

  static const decltype(::printing::mojom::PrintPagesParams::params)& params(
      const ::printing::mojom::PrintPagesParamsPtr& input) {
    return input->params;
  }

  static const decltype(::printing::mojom::PrintPagesParams::pages)& pages(
      const ::printing::mojom::PrintPagesParamsPtr& input) {
    return input->pages;
  }

  static bool Read(::printing::mojom::PrintPagesParams::DataView input, ::printing::mojom::PrintPagesParamsPtr* output);
};


template <>
struct  StructTraits<::printing::mojom::DidPrintDocumentParams::DataView,
                                         ::printing::mojom::DidPrintDocumentParamsPtr> {
  static bool IsNull(const ::printing::mojom::DidPrintDocumentParamsPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::DidPrintDocumentParamsPtr* output) { output->reset(); }

  static  decltype(::printing::mojom::DidPrintDocumentParams::content)& content(
       ::printing::mojom::DidPrintDocumentParamsPtr& input) {
    return input->content;
  }

  static decltype(::printing::mojom::DidPrintDocumentParams::document_cookie) document_cookie(
      const ::printing::mojom::DidPrintDocumentParamsPtr& input) {
    return input->document_cookie;
  }

  static const decltype(::printing::mojom::DidPrintDocumentParams::page_size)& page_size(
      const ::printing::mojom::DidPrintDocumentParamsPtr& input) {
    return input->page_size;
  }

  static const decltype(::printing::mojom::DidPrintDocumentParams::content_area)& content_area(
      const ::printing::mojom::DidPrintDocumentParamsPtr& input) {
    return input->content_area;
  }

  static const decltype(::printing::mojom::DidPrintDocumentParams::physical_offsets)& physical_offsets(
      const ::printing::mojom::DidPrintDocumentParamsPtr& input) {
    return input->physical_offsets;
  }

  static bool Read(::printing::mojom::DidPrintDocumentParams::DataView input, ::printing::mojom::DidPrintDocumentParamsPtr* output);
};


template <>
struct  StructTraits<::printing::mojom::ScriptedPrintParams::DataView,
                                         ::printing::mojom::ScriptedPrintParamsPtr> {
  static bool IsNull(const ::printing::mojom::ScriptedPrintParamsPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::ScriptedPrintParamsPtr* output) { output->reset(); }

  static decltype(::printing::mojom::ScriptedPrintParams::cookie) cookie(
      const ::printing::mojom::ScriptedPrintParamsPtr& input) {
    return input->cookie;
  }

  static decltype(::printing::mojom::ScriptedPrintParams::expected_pages_count) expected_pages_count(
      const ::printing::mojom::ScriptedPrintParamsPtr& input) {
    return input->expected_pages_count;
  }

  static decltype(::printing::mojom::ScriptedPrintParams::has_selection) has_selection(
      const ::printing::mojom::ScriptedPrintParamsPtr& input) {
    return input->has_selection;
  }

  static decltype(::printing::mojom::ScriptedPrintParams::is_scripted) is_scripted(
      const ::printing::mojom::ScriptedPrintParamsPtr& input) {
    return input->is_scripted;
  }

  static decltype(::printing::mojom::ScriptedPrintParams::margin_type) margin_type(
      const ::printing::mojom::ScriptedPrintParamsPtr& input) {
    return input->margin_type;
  }

  static bool Read(::printing::mojom::ScriptedPrintParams::DataView input, ::printing::mojom::ScriptedPrintParamsPtr* output);
};


template <>
struct  StructTraits<::printing::mojom::PrintWithParamsResultData::DataView,
                                         ::printing::mojom::PrintWithParamsResultDataPtr> {
  static bool IsNull(const ::printing::mojom::PrintWithParamsResultDataPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::PrintWithParamsResultDataPtr* output) { output->reset(); }

  static  decltype(::printing::mojom::PrintWithParamsResultData::params)& params(
       ::printing::mojom::PrintWithParamsResultDataPtr& input) {
    return input->params;
  }

  static const decltype(::printing::mojom::PrintWithParamsResultData::accessibility_tree)& accessibility_tree(
      const ::printing::mojom::PrintWithParamsResultDataPtr& input) {
    return input->accessibility_tree;
  }

  static decltype(::printing::mojom::PrintWithParamsResultData::generate_document_outline) generate_document_outline(
      const ::printing::mojom::PrintWithParamsResultDataPtr& input) {
    return input->generate_document_outline;
  }

  static bool Read(::printing::mojom::PrintWithParamsResultData::DataView input, ::printing::mojom::PrintWithParamsResultDataPtr* output);
};


template <>
struct  UnionTraits<::printing::mojom::PrintRenderFrame_PrintWithParams_ResponseParam_Result::DataView,
                                        ::printing::mojom::PrintRenderFrame_PrintWithParams_ResponseParam_ResultPtr> {
  static bool IsNull(const ::printing::mojom::PrintRenderFrame_PrintWithParams_ResponseParam_ResultPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::PrintRenderFrame_PrintWithParams_ResponseParam_ResultPtr* output) { output->reset(); }

  static ::printing::mojom::PrintRenderFrame_PrintWithParams_ResponseParam_Result::Tag GetTag(const ::printing::mojom::PrintRenderFrame_PrintWithParams_ResponseParam_ResultPtr& input) {
    return input->which();
  }

  static  ::printing::mojom::PrintWithParamsResultDataPtr& success( ::printing::mojom::PrintRenderFrame_PrintWithParams_ResponseParam_ResultPtr& input) {
    return input->get_success();
  }

  static  ::printing::mojom::PrintFailureReason failure(const ::printing::mojom::PrintRenderFrame_PrintWithParams_ResponseParam_ResultPtr& input) {
    return input->get_failure();
  }

  static bool Read(::printing::mojom::PrintRenderFrame_PrintWithParams_ResponseParam_Result::DataView input, ::printing::mojom::PrintRenderFrame_PrintWithParams_ResponseParam_ResultPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_PRINTING_COMMON_PRINT_MOJOM_H_