// components/services/quarantine/public/mojom/quarantine.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_QUARANTINE_PUBLIC_MOJOM_QUARANTINE_MOJOM_H_
#define COMPONENTS_SERVICES_QUARANTINE_PUBLIC_MOJOM_QUARANTINE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/quarantine/public/mojom/quarantine.mojom-features.h"  // IWYU pragma: export
#include "components/services/quarantine/public/mojom/quarantine.mojom-shared.h"  // IWYU pragma: export
#include "components/services/quarantine/public/mojom/quarantine.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "sandbox/policy/mojom/sandbox.mojom-forward.h"
#include "url/mojom/url.mojom.h"
#include "url/mojom/origin.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace quarantine::mojom {

class QuarantineProxy;

template <typename ImplRefTraits>
class QuarantineStub;

class QuarantineRequestValidator;
class QuarantineResponseValidator;


class Quarantine
    : public QuarantineInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "quarantine.mojom.Quarantine";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr auto kServiceSandbox = sandbox::mojom::Sandbox::kNoSandbox;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = QuarantineInterfaceBase;
  using Proxy_ = QuarantineProxy;

  template <typename ImplRefTraits>
  using Stub_ = QuarantineStub<ImplRefTraits>;

  using RequestValidator_ = QuarantineRequestValidator;
  using ResponseValidator_ = QuarantineResponseValidator;
  enum MethodMinVersions : uint32_t {
    kQuarantineFileMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct QuarantineFile_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Quarantine() = default;

  using QuarantineFileCallback = base::OnceCallback<void(QuarantineFileResult)>;
  using QuarantineFileMojoCallback = base::OnceCallback<void(QuarantineFileResult)>;

  virtual void QuarantineFile(const ::base::FilePath& full_path, const ::GURL& source_url, const ::GURL& referrer_url, const std::optional<::url::Origin>& request_initiator, const std::string& client_guid, QuarantineFileCallback callback) = 0;
};



class  QuarantineProxy
    : public Quarantine {
 public:
  using InterfaceType = Quarantine;

  explicit QuarantineProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void QuarantineFile(const ::base::FilePath& full_path, const ::GURL& source_url, const ::GURL& referrer_url, const std::optional<::url::Origin>& request_initiator, const std::string& client_guid, QuarantineFileCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  QuarantineStubDispatch {
 public:
  static bool Accept(Quarantine* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Quarantine* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Quarantine>>
class QuarantineStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  QuarantineStub() = default;
  ~QuarantineStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return QuarantineStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return QuarantineStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  QuarantineRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  QuarantineResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // quarantine::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_QUARANTINE_PUBLIC_MOJOM_QUARANTINE_MOJOM_H_