// content/browser/attribution_reporting/attribution_internals.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_BROWSER_ATTRIBUTION_REPORTING_ATTRIBUTION_INTERNALS_MOJOM_SHARED_INTERNAL_H_
#define CONTENT_BROWSER_ATTRIBUTION_REPORTING_ATTRIBUTION_INTERNALS_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "components/attribution_reporting/registration.mojom-shared-internal.h"
#include "components/attribution_reporting/source_type.mojom-shared-internal.h"
#include "components/attribution_reporting/trigger_data_matching.mojom-shared-internal.h"
#include "content/browser/attribution_reporting/aggregatable_result.mojom-shared-internal.h"
#include "content/browser/attribution_reporting/process_aggregatable_debug_report_result.mojom-shared-internal.h"
#include "content/browser/attribution_reporting/attribution_reporting.mojom-shared-internal.h"
#include "content/browser/attribution_reporting/event_level_result.mojom-shared-internal.h"
#include "content/browser/attribution_reporting/store_source_result.mojom-shared-internal.h"
#include "services/network/public/mojom/attribution.mojom-shared-internal.h"
#include "url/mojom/origin.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace attribution_internals::mojom {
namespace internal {
class ReportID_Data;
class WebUIReportEventLevelData_Data;
class AggregatableHistogramContribution_Data;
class WebUIReportAggregatableAttributionData_Data;
class Empty_Data;
class WebUIReport_Data;
class WebUIDebugReport_Data;
class WebUIAggregatableDebugReport_Data;
class WebUISource_Data;
class WebUIRegistration_Data;
class WebUITrigger_Data;
class WebUISourceRegistration_Data;
class WebUIOsRegistration_Data;
class WebUIReportData_Data;
class NetworkStatus_Data;
class ReportStatus_Data;
class SendAggregatableDebugReportResult_Data;

struct WebUISource_Attributability_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)


class  WebUIReportData_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  WebUIReportData_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~WebUIReportData_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<WebUIReportData_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class WebUIReportData_Tag : uint32_t {

    
    kEventLevelData,
    
    kAggregatableAttributionData,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<internal::WebUIReportEventLevelData_Data> f_event_level_data;
    mojo::internal::Pointer<internal::WebUIReportAggregatableAttributionData_Data> f_aggregatable_attribution_data;
    uint64_t unknown;
  };

  uint32_t size;
  WebUIReportData_Tag tag;
  Union_ data;
};
static_assert(sizeof(WebUIReportData_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(WebUIReportData_Data)");


class  NetworkStatus_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  NetworkStatus_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~NetworkStatus_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<NetworkStatus_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class NetworkStatus_Tag : uint32_t {

    
    kHttpResponseCode,
    
    kNetworkError,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    int32_t f_http_response_code;
    mojo::internal::Pointer<mojo::internal::String_Data> f_network_error;
    uint64_t unknown;
  };

  uint32_t size;
  NetworkStatus_Tag tag;
  Union_ data;
};
static_assert(sizeof(NetworkStatus_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(NetworkStatus_Data)");


class  ReportStatus_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  ReportStatus_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~ReportStatus_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<ReportStatus_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class ReportStatus_Tag : uint32_t {

    
    kPending,
    
    kReplacedByHigherPriorityReport,
    
    kProhibitedByBrowserPolicy,
    
    kExpired,
    
    kNetworkStatus,
    
    kFailedToAssemble,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<internal::Empty_Data> f_pending;
    mojo::internal::Pointer<mojo::internal::String_Data> f_replaced_by_higher_priority_report;
    mojo::internal::Pointer<internal::Empty_Data> f_prohibited_by_browser_policy;
    mojo::internal::Pointer<internal::Empty_Data> f_expired;
    mojo::internal::Pointer<internal::NetworkStatus_Data> f_network_status;
    mojo::internal::Pointer<internal::Empty_Data> f_failed_to_assemble;
    uint64_t unknown;
  };

  uint32_t size;
  ReportStatus_Tag tag;
  Union_ data;
};
static_assert(sizeof(ReportStatus_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(ReportStatus_Data)");


class  SendAggregatableDebugReportResult_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  SendAggregatableDebugReportResult_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~SendAggregatableDebugReportResult_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<SendAggregatableDebugReportResult_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class SendAggregatableDebugReportResult_Tag : uint32_t {

    
    kAssemblyFailed,
    
    kNetworkStatus,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<internal::Empty_Data> f_assembly_failed;
    mojo::internal::Pointer<internal::NetworkStatus_Data> f_network_status;
    uint64_t unknown;
  };

  uint32_t size;
  SendAggregatableDebugReportResult_Tag tag;
  Union_ data;
};
static_assert(sizeof(SendAggregatableDebugReportResult_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(SendAggregatableDebugReportResult_Data)");
class  ReportID_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int64_t value;

 private:
  friend class mojo::internal::MessageFragment<ReportID_Data>;

  ReportID_Data();
  ~ReportID_Data() = delete;
};
static_assert(sizeof(ReportID_Data) == 16,
              "Bad sizeof(ReportID_Data)");
// Used by ReportID::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ReportID_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ReportID_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ReportID_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ReportID_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ReportID_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  WebUIReportEventLevelData_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int64_t priority;
  uint8_t attributed_truthfully : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<WebUIReportEventLevelData_Data>;

  WebUIReportEventLevelData_Data();
  ~WebUIReportEventLevelData_Data() = delete;
};
static_assert(sizeof(WebUIReportEventLevelData_Data) == 24,
              "Bad sizeof(WebUIReportEventLevelData_Data)");
// Used by WebUIReportEventLevelData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct WebUIReportEventLevelData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  WebUIReportEventLevelData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~WebUIReportEventLevelData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<WebUIReportEventLevelData_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    WebUIReportEventLevelData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  AggregatableHistogramContribution_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> key;
  uint32_t value;
  uint8_t pad1_[4];
  uint64_t filtering_id;

 private:
  friend class mojo::internal::MessageFragment<AggregatableHistogramContribution_Data>;

  AggregatableHistogramContribution_Data();
  ~AggregatableHistogramContribution_Data() = delete;
};
static_assert(sizeof(AggregatableHistogramContribution_Data) == 32,
              "Bad sizeof(AggregatableHistogramContribution_Data)");
// Used by AggregatableHistogramContribution::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct AggregatableHistogramContribution_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  AggregatableHistogramContribution_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~AggregatableHistogramContribution_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<AggregatableHistogramContribution_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    AggregatableHistogramContribution_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  WebUIReportAggregatableAttributionData_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::AggregatableHistogramContribution_Data>>> contributions;
  mojo::internal::Pointer<mojo::internal::String_Data> aggregation_coordinator;
  uint8_t is_null_report : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<WebUIReportAggregatableAttributionData_Data>;

  WebUIReportAggregatableAttributionData_Data();
  ~WebUIReportAggregatableAttributionData_Data() = delete;
};
static_assert(sizeof(WebUIReportAggregatableAttributionData_Data) == 32,
              "Bad sizeof(WebUIReportAggregatableAttributionData_Data)");
// Used by WebUIReportAggregatableAttributionData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct WebUIReportAggregatableAttributionData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  WebUIReportAggregatableAttributionData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~WebUIReportAggregatableAttributionData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<WebUIReportAggregatableAttributionData_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    WebUIReportAggregatableAttributionData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  Empty_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Empty_Data>;

  Empty_Data();
  ~Empty_Data() = delete;
};
static_assert(sizeof(Empty_Data) == 8,
              "Bad sizeof(Empty_Data)");
// Used by Empty::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Empty_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Empty_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Empty_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Empty_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Empty_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  WebUIReport_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::ReportID_Data> id;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> report_url;
  double trigger_time;
  double report_time;
  mojo::internal::Pointer<mojo::internal::String_Data> report_body;
  internal::ReportStatus_Data status;
  internal::WebUIReportData_Data data;

 private:
  friend class mojo::internal::MessageFragment<WebUIReport_Data>;

  WebUIReport_Data();
  ~WebUIReport_Data() = delete;
};
static_assert(sizeof(WebUIReport_Data) == 80,
              "Bad sizeof(WebUIReport_Data)");
// Used by WebUIReport::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct WebUIReport_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  WebUIReport_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~WebUIReport_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<WebUIReport_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    WebUIReport_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  WebUIDebugReport_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  double time;
  mojo::internal::Pointer<mojo::internal::String_Data> body;
  internal::NetworkStatus_Data status;

 private:
  friend class mojo::internal::MessageFragment<WebUIDebugReport_Data>;

  WebUIDebugReport_Data();
  ~WebUIDebugReport_Data() = delete;
};
static_assert(sizeof(WebUIDebugReport_Data) == 48,
              "Bad sizeof(WebUIDebugReport_Data)");
// Used by WebUIDebugReport::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct WebUIDebugReport_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  WebUIDebugReport_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~WebUIDebugReport_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<WebUIDebugReport_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    WebUIDebugReport_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  WebUIAggregatableDebugReport_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  double time;
  mojo::internal::Pointer<mojo::internal::String_Data> body;
  int32_t process_result;
  uint8_t pad3_[4];
  internal::SendAggregatableDebugReportResult_Data send_result;

 private:
  friend class mojo::internal::MessageFragment<WebUIAggregatableDebugReport_Data>;

  WebUIAggregatableDebugReport_Data();
  ~WebUIAggregatableDebugReport_Data() = delete;
};
static_assert(sizeof(WebUIAggregatableDebugReport_Data) == 56,
              "Bad sizeof(WebUIAggregatableDebugReport_Data)");
// Used by WebUIAggregatableDebugReport::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct WebUIAggregatableDebugReport_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  WebUIAggregatableDebugReport_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~WebUIAggregatableDebugReport_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<WebUIAggregatableDebugReport_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    WebUIAggregatableDebugReport_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  WebUISource_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int64_t id;
  uint64_t source_event_id;
  mojo::internal::Pointer<::url::mojom::internal::Origin_Data> source_origin;
  mojo::internal::Pointer<::attribution_reporting::mojom::internal::DestinationSet_Data> destinations;
  mojo::internal::Pointer<::url::mojom::internal::Origin_Data> reporting_origin;
  double source_time;
  double expiry_time;
  mojo::internal::Pointer<::attribution_reporting::mojom::internal::EventReportWindows_Data> event_report_windows;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint32_t>> trigger_data;
  int32_t max_event_level_reports;
  int32_t source_type;
  double aggregatable_report_window_time;
  int64_t priority;
  uint8_t debug_key_$flag : 1;
  uint8_t cookie_based_debug_allowed : 1;
  uint8_t pad14_[3];
  int32_t remaining_aggregatable_attribution_budget;
  uint64_t debug_key_$value;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint64_t>> dedup_keys;
  mojo::internal::Pointer<::attribution_reporting::mojom::internal::FilterData_Data> filter_data;
  mojo::internal::Pointer<mojo::internal::Map_Data<mojo::internal::Pointer<mojo::internal::String_Data>, mojo::internal::Pointer<mojo::internal::String_Data>>> aggregation_keys;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint64_t>> aggregatable_dedup_keys;
  int32_t trigger_data_matching;
  int32_t remaining_aggregatable_debug_budget;
  double event_level_epsilon;
  mojo::internal::Pointer<mojo::internal::String_Data> aggregatable_debug_key_piece;
  mojo::internal::Pointer<mojo::internal::String_Data> attribution_scopes_data_json;
  mojo::internal::Pointer<mojo::internal::String_Data> aggregatable_named_budgets;
  int32_t attributability;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<WebUISource_Data>;

  WebUISource_Data();
  ~WebUISource_Data() = delete;
};
static_assert(sizeof(WebUISource_Data) == 200,
              "Bad sizeof(WebUISource_Data)");
// Used by WebUISource::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct WebUISource_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  WebUISource_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~WebUISource_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<WebUISource_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    WebUISource_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  WebUIRegistration_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  double time;
  mojo::internal::Pointer<::url::mojom::internal::Origin_Data> context_origin;
  mojo::internal::Pointer<::url::mojom::internal::Origin_Data> reporting_origin;
  mojo::internal::Pointer<mojo::internal::String_Data> registration_json;
  uint8_t cleared_debug_key_$flag : 1;
  uint8_t pad4_[7];
  uint64_t cleared_debug_key_$value;

 private:
  friend class mojo::internal::MessageFragment<WebUIRegistration_Data>;

  WebUIRegistration_Data();
  ~WebUIRegistration_Data() = delete;
};
static_assert(sizeof(WebUIRegistration_Data) == 56,
              "Bad sizeof(WebUIRegistration_Data)");
// Used by WebUIRegistration::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct WebUIRegistration_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  WebUIRegistration_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~WebUIRegistration_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<WebUIRegistration_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    WebUIRegistration_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  WebUITrigger_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::WebUIRegistration_Data> registration;
  int32_t event_level_result;
  int32_t aggregatable_result;

 private:
  friend class mojo::internal::MessageFragment<WebUITrigger_Data>;

  WebUITrigger_Data();
  ~WebUITrigger_Data() = delete;
};
static_assert(sizeof(WebUITrigger_Data) == 24,
              "Bad sizeof(WebUITrigger_Data)");
// Used by WebUITrigger::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct WebUITrigger_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  WebUITrigger_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~WebUITrigger_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<WebUITrigger_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    WebUITrigger_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  WebUISourceRegistration_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::WebUIRegistration_Data> registration;
  int32_t type;
  int32_t status;

 private:
  friend class mojo::internal::MessageFragment<WebUISourceRegistration_Data>;

  WebUISourceRegistration_Data();
  ~WebUISourceRegistration_Data() = delete;
};
static_assert(sizeof(WebUISourceRegistration_Data) == 24,
              "Bad sizeof(WebUISourceRegistration_Data)");
// Used by WebUISourceRegistration::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct WebUISourceRegistration_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  WebUISourceRegistration_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~WebUISourceRegistration_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<WebUISourceRegistration_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    WebUISourceRegistration_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  WebUIOsRegistration_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  double time;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> registration_url;
  mojo::internal::Pointer<::url::mojom::internal::Origin_Data> top_level_origin;
  uint8_t is_debug_key_allowed : 1;
  uint8_t debug_reporting : 1;
  uint8_t pad4_[3];
  int32_t type;
  int32_t result;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<WebUIOsRegistration_Data>;

  WebUIOsRegistration_Data();
  ~WebUIOsRegistration_Data() = delete;
};
static_assert(sizeof(WebUIOsRegistration_Data) == 48,
              "Bad sizeof(WebUIOsRegistration_Data)");
// Used by WebUIOsRegistration::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct WebUIOsRegistration_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  WebUIOsRegistration_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~WebUIOsRegistration_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<WebUIOsRegistration_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    WebUIOsRegistration_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // attribution_internals::mojom

#endif  // CONTENT_BROWSER_ATTRIBUTION_REPORTING_ATTRIBUTION_INTERNALS_MOJOM_SHARED_INTERNAL_H_