// device/gamepad/public/mojom/gamepad.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "device/gamepad/public/mojom/gamepad.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "device/gamepad/public/mojom/gamepad.mojom-params-data.h"
#include "device/gamepad/public/mojom/gamepad.mojom-shared-message-ids.h"

#include "device/gamepad/public/mojom/gamepad.mojom-blink-import-headers.h"
#include "device/gamepad/public/mojom/gamepad.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace device::mojom::blink {
GamepadQuaternion::GamepadQuaternion()
    : x(),
      y(),
      z(),
      w() {}

GamepadQuaternion::GamepadQuaternion(
    float x_in,
    float y_in,
    float z_in,
    float w_in)
    : x(std::move(x_in)),
      y(std::move(y_in)),
      z(std::move(z_in)),
      w(std::move(w_in)) {}

GamepadQuaternion::~GamepadQuaternion() = default;

void GamepadQuaternion::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "x"), this->x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "y"), this->y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "z"), this->z,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "w"), this->w,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GamepadQuaternion::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GamepadVector::GamepadVector()
    : x(),
      y(),
      z() {}

GamepadVector::GamepadVector(
    float x_in,
    float y_in,
    float z_in)
    : x(std::move(x_in)),
      y(std::move(y_in)),
      z(std::move(z_in)) {}

GamepadVector::~GamepadVector() = default;

void GamepadVector::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "x"), this->x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "y"), this->y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "z"), this->z,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GamepadVector::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GamepadButton::GamepadButton()
    : pressed(),
      touched(),
      value() {}

GamepadButton::GamepadButton(
    bool pressed_in,
    bool touched_in,
    double value_in)
    : pressed(std::move(pressed_in)),
      touched(std::move(touched_in)),
      value(std::move(value_in)) {}

GamepadButton::~GamepadButton() = default;

void GamepadButton::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pressed"), this->pressed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "touched"), this->touched,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GamepadButton::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GamepadTouch::GamepadTouch()
    : touch_id(),
      surface_id(),
      x(),
      y(),
      surface_height(),
      surface_width(),
      has_surface_dimensions() {}

GamepadTouch::GamepadTouch(
    uint32_t touch_id_in,
    uint8_t surface_id_in,
    double x_in,
    double y_in,
    uint32_t surface_height_in,
    uint32_t surface_width_in,
    bool has_surface_dimensions_in)
    : touch_id(std::move(touch_id_in)),
      surface_id(std::move(surface_id_in)),
      x(std::move(x_in)),
      y(std::move(y_in)),
      surface_height(std::move(surface_height_in)),
      surface_width(std::move(surface_width_in)),
      has_surface_dimensions(std::move(has_surface_dimensions_in)) {}

GamepadTouch::~GamepadTouch() = default;

void GamepadTouch::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "touch_id"), this->touch_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "surface_id"), this->surface_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "x"), this->x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "y"), this->y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "surface_height"), this->surface_height,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "surface_width"), this->surface_width,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_surface_dimensions"), this->has_surface_dimensions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GamepadTouch::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GamepadPose::GamepadPose()
    : orientation(),
      position(),
      angular_velocity(),
      linear_velocity(),
      angular_acceleration(),
      linear_acceleration() {}

GamepadPose::GamepadPose(
    const ::device::GamepadQuaternion& orientation_in,
    const ::device::GamepadVector& position_in,
    const ::device::GamepadVector& angular_velocity_in,
    const ::device::GamepadVector& linear_velocity_in,
    const ::device::GamepadVector& angular_acceleration_in,
    const ::device::GamepadVector& linear_acceleration_in)
    : orientation(std::move(orientation_in)),
      position(std::move(position_in)),
      angular_velocity(std::move(angular_velocity_in)),
      linear_velocity(std::move(linear_velocity_in)),
      angular_acceleration(std::move(angular_acceleration_in)),
      linear_acceleration(std::move(linear_acceleration_in)) {}

GamepadPose::~GamepadPose() = default;

void GamepadPose::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "orientation"), this->orientation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::device::GamepadQuaternion&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "position"), this->position,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::device::GamepadVector&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "angular_velocity"), this->angular_velocity,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::device::GamepadVector&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "linear_velocity"), this->linear_velocity,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::device::GamepadVector&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "angular_acceleration"), this->angular_acceleration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::device::GamepadVector&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "linear_acceleration"), this->linear_acceleration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::device::GamepadVector&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GamepadPose::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GamepadHapticActuator::GamepadHapticActuator()
    : type() {}

GamepadHapticActuator::GamepadHapticActuator(
    ::device::GamepadHapticActuatorType type_in)
    : type(std::move(type_in)) {}

GamepadHapticActuator::~GamepadHapticActuator() = default;

void GamepadHapticActuator::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::device::GamepadHapticActuatorType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GamepadHapticActuator::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Gamepad::Gamepad()
    : connected(),
      id(),
      timestamp(),
      axes(),
      buttons(),
      vibration_actuator(),
      mapping(),
      pose(),
      hand(),
      touch_events(),
      display_id() {}

Gamepad::Gamepad(
    bool connected_in,
    ::blink::Vector<uint16_t> id_in,
    int64_t timestamp_in,
    ::blink::Vector<double> axes_in,
    ::blink::Vector<::device::GamepadButton> buttons_in,
    const ::device::GamepadHapticActuator& vibration_actuator_in,
    ::device::GamepadMapping mapping_in,
    const ::device::GamepadPose& pose_in,
    ::device::GamepadHand hand_in,
    ::blink::Vector<::device::GamepadTouch> touch_events_in,
    uint32_t display_id_in)
    : connected(std::move(connected_in)),
      id(std::move(id_in)),
      timestamp(std::move(timestamp_in)),
      axes(std::move(axes_in)),
      buttons(std::move(buttons_in)),
      vibration_actuator(std::move(vibration_actuator_in)),
      mapping(std::move(mapping_in)),
      pose(std::move(pose_in)),
      hand(std::move(hand_in)),
      touch_events(std::move(touch_events_in)),
      display_id(std::move(display_id_in)) {}

Gamepad::~Gamepad() = default;

void Gamepad::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "connected"), this->connected,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<uint16_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timestamp"), this->timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "axes"), this->axes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<double>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "buttons"), this->buttons,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::device::GamepadButton>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "vibration_actuator"), this->vibration_actuator,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::device::GamepadHapticActuator&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mapping"), this->mapping,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::device::GamepadMapping>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pose"), this->pose,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::device::GamepadPose&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hand"), this->hand,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::device::GamepadHand>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "touch_events"), this->touch_events,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::device::GamepadTouch>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_id"), this->display_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Gamepad::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GamepadEffectParameters::GamepadEffectParameters()
    : duration(),
      start_delay(),
      strong_magnitude(),
      weak_magnitude(),
      left_trigger(),
      right_trigger() {}

GamepadEffectParameters::GamepadEffectParameters(
    double duration_in,
    double start_delay_in,
    double strong_magnitude_in,
    double weak_magnitude_in,
    double left_trigger_in,
    double right_trigger_in)
    : duration(std::move(duration_in)),
      start_delay(std::move(start_delay_in)),
      strong_magnitude(std::move(strong_magnitude_in)),
      weak_magnitude(std::move(weak_magnitude_in)),
      left_trigger(std::move(left_trigger_in)),
      right_trigger(std::move(right_trigger_in)) {}

GamepadEffectParameters::~GamepadEffectParameters() = default;
size_t GamepadEffectParameters::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->duration);
  seed = mojo::internal::WTFHash(seed, this->start_delay);
  seed = mojo::internal::WTFHash(seed, this->strong_magnitude);
  seed = mojo::internal::WTFHash(seed, this->weak_magnitude);
  seed = mojo::internal::WTFHash(seed, this->left_trigger);
  seed = mojo::internal::WTFHash(seed, this->right_trigger);
  return seed;
}

void GamepadEffectParameters::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "duration"), this->duration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "start_delay"), this->start_delay,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "strong_magnitude"), this->strong_magnitude,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "weak_magnitude"), this->weak_magnitude,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "left_trigger"), this->left_trigger,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "right_trigger"), this->right_trigger,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GamepadEffectParameters::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

GamepadObserver::IPCStableHashFunction GamepadObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::GamepadObserver>(message.name())) {
    case messages::GamepadObserver::kGamepadConnected: {
      return &GamepadObserver::GamepadConnected_Sym::IPCStableHash;
    }
    case messages::GamepadObserver::kGamepadDisconnected: {
      return &GamepadObserver::GamepadDisconnected_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* GamepadObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::GamepadObserver>(message.name())) {
      case messages::GamepadObserver::kGamepadConnected:
            return "Receive device::mojom::GamepadObserver::GamepadConnected";
      case messages::GamepadObserver::kGamepadDisconnected:
            return "Receive device::mojom::GamepadObserver::GamepadDisconnected";
    }
  } else {
    switch (static_cast<messages::GamepadObserver>(message.name())) {
      case messages::GamepadObserver::kGamepadConnected:
            return "Receive reply device::mojom::GamepadObserver::GamepadConnected";
      case messages::GamepadObserver::kGamepadDisconnected:
            return "Receive reply device::mojom::GamepadObserver::GamepadDisconnected";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t GamepadObserver::GamepadConnected_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x96e1bafc;  // IPCStableHash for device::mojom::GamepadObserver::GamepadConnected
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GamepadObserver::GamepadDisconnected_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xde4b8cef;  // IPCStableHash for device::mojom::GamepadObserver::GamepadDisconnected
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

GamepadObserverProxy::GamepadObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void GamepadObserverProxy::GamepadConnected(
    uint32_t in_index, const ::device::Gamepad& in_gamepad) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::GamepadObserver::GamepadConnected", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index"), in_index,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gamepad"), in_gamepad,
                        "<value of type const ::device::Gamepad&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GamepadObserver::kGamepadConnected), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::GamepadObserver_GamepadConnected_Params_Data> params(
          message);
  params.Allocate();

  params->index = in_index;
  mojo::internal::MessageFragment<
      typename decltype(params->gamepad)::BaseType> gamepad_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::GamepadDataView>(
    in_gamepad,
    gamepad_fragment);

  params->gamepad.Set(
      gamepad_fragment.is_null() ? nullptr : gamepad_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->gamepad.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null gamepad in GamepadObserver.GamepadConnected request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GamepadObserver::Name_);
  message.set_method_name("GamepadConnected");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GamepadObserverProxy::GamepadDisconnected(
    uint32_t in_index, const ::device::Gamepad& in_gamepad) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::GamepadObserver::GamepadDisconnected", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index"), in_index,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gamepad"), in_gamepad,
                        "<value of type const ::device::Gamepad&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GamepadObserver::kGamepadDisconnected), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::GamepadObserver_GamepadDisconnected_Params_Data> params(
          message);
  params.Allocate();

  params->index = in_index;
  mojo::internal::MessageFragment<
      typename decltype(params->gamepad)::BaseType> gamepad_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::GamepadDataView>(
    in_gamepad,
    gamepad_fragment);

  params->gamepad.Set(
      gamepad_fragment.is_null() ? nullptr : gamepad_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->gamepad.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null gamepad in GamepadObserver.GamepadDisconnected request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GamepadObserver::Name_);
  message.set_method_name("GamepadDisconnected");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool GamepadObserverStubDispatch::Accept(
    GamepadObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::GamepadObserver>(message->header()->name)) {
    case messages::GamepadObserver::kGamepadConnected: {
      DCHECK(message->is_serialized());
      internal::GamepadObserver_GamepadConnected_Params_Data* params =
          reinterpret_cast<internal::GamepadObserver_GamepadConnected_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GamepadObserver.0
      bool success = true;
      uint32_t p_index{};
      ::device::Gamepad p_gamepad{};
      GamepadObserver_GamepadConnected_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_index = input_data_view.index();
      if (success && !input_data_view.ReadGamepad(&p_gamepad))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GamepadObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GamepadConnected(        
        std::move(p_index), 
        std::move(p_gamepad));
      return true;
    }
    case messages::GamepadObserver::kGamepadDisconnected: {
      DCHECK(message->is_serialized());
      internal::GamepadObserver_GamepadDisconnected_Params_Data* params =
          reinterpret_cast<internal::GamepadObserver_GamepadDisconnected_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GamepadObserver.1
      bool success = true;
      uint32_t p_index{};
      ::device::Gamepad p_gamepad{};
      GamepadObserver_GamepadDisconnected_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_index = input_data_view.index();
      if (success && !input_data_view.ReadGamepad(&p_gamepad))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GamepadObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GamepadDisconnected(        
        std::move(p_index), 
        std::move(p_gamepad));
      return true;
    }
  }
  return false;
}

// static
bool GamepadObserverStubDispatch::AcceptWithResponder(
    GamepadObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::GamepadObserver>(message->header()->name)) {
    case messages::GamepadObserver::kGamepadConnected: {
      break;
    }
    case messages::GamepadObserver::kGamepadDisconnected: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kGamepadObserverValidationInfo[] = {
    {base::to_underlying(messages::GamepadObserver::kGamepadConnected),
     { &internal::GamepadObserver_GamepadConnected_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::GamepadObserver::kGamepadDisconnected),
     { &internal::GamepadObserver_GamepadDisconnected_Params_Data::Validate,
      nullptr /* no response */}},
};

bool GamepadObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::device::mojom::blink::GamepadObserver::Name_,
    kGamepadObserverValidationInfo);
}

// The declaration includes the definition on other builds.

GamepadMonitor::IPCStableHashFunction GamepadMonitor::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::GamepadMonitor>(message.name())) {
    case messages::GamepadMonitor::kGamepadStartPolling: {
      return &GamepadMonitor::GamepadStartPolling_Sym::IPCStableHash;
    }
    case messages::GamepadMonitor::kGamepadStopPolling: {
      return &GamepadMonitor::GamepadStopPolling_Sym::IPCStableHash;
    }
    case messages::GamepadMonitor::kSetObserver: {
      return &GamepadMonitor::SetObserver_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* GamepadMonitor::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::GamepadMonitor>(message.name())) {
      case messages::GamepadMonitor::kGamepadStartPolling:
            return "Receive device::mojom::GamepadMonitor::GamepadStartPolling";
      case messages::GamepadMonitor::kGamepadStopPolling:
            return "Receive device::mojom::GamepadMonitor::GamepadStopPolling";
      case messages::GamepadMonitor::kSetObserver:
            return "Receive device::mojom::GamepadMonitor::SetObserver";
    }
  } else {
    switch (static_cast<messages::GamepadMonitor>(message.name())) {
      case messages::GamepadMonitor::kGamepadStartPolling:
            return "Receive reply device::mojom::GamepadMonitor::GamepadStartPolling";
      case messages::GamepadMonitor::kGamepadStopPolling:
            return "Receive reply device::mojom::GamepadMonitor::GamepadStopPolling";
      case messages::GamepadMonitor::kSetObserver:
            return "Receive reply device::mojom::GamepadMonitor::SetObserver";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t GamepadMonitor::GamepadStartPolling_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5cdab8d5;  // IPCStableHash for device::mojom::GamepadMonitor::GamepadStartPolling
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GamepadMonitor::GamepadStopPolling_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4a2e59d5;  // IPCStableHash for device::mojom::GamepadMonitor::GamepadStopPolling
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GamepadMonitor::SetObserver_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5159a4e0;  // IPCStableHash for device::mojom::GamepadMonitor::SetObserver
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool GamepadMonitor::GamepadStartPolling(::base::ReadOnlySharedMemoryRegion* out_memory_region) {
  NOTREACHED();
}
bool GamepadMonitor::GamepadStopPolling() {
  NOTREACHED();
}
class GamepadMonitor_GamepadStartPolling_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  GamepadMonitor_GamepadStartPolling_HandleSyncResponse(
      bool* result, ::base::ReadOnlySharedMemoryRegion* out_memory_region)
      : result_(result), out_memory_region_(out_memory_region) {
    DCHECK(!*result_);
  }

  GamepadMonitor_GamepadStartPolling_HandleSyncResponse(const GamepadMonitor_GamepadStartPolling_HandleSyncResponse&) = delete;
  GamepadMonitor_GamepadStartPolling_HandleSyncResponse& operator=(const GamepadMonitor_GamepadStartPolling_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::ReadOnlySharedMemoryRegion* out_memory_region_;};

class GamepadMonitor_GamepadStartPolling_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GamepadMonitor_GamepadStartPolling_ForwardToCallback(
      GamepadMonitor::GamepadStartPollingCallback callback
      ) : callback_(std::move(callback)) {
  }

  GamepadMonitor_GamepadStartPolling_ForwardToCallback(const GamepadMonitor_GamepadStartPolling_ForwardToCallback&) = delete;
  GamepadMonitor_GamepadStartPolling_ForwardToCallback& operator=(const GamepadMonitor_GamepadStartPolling_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  GamepadMonitor::GamepadStartPollingCallback callback_;
};
class GamepadMonitor_GamepadStopPolling_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  GamepadMonitor_GamepadStopPolling_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }

  GamepadMonitor_GamepadStopPolling_HandleSyncResponse(const GamepadMonitor_GamepadStopPolling_HandleSyncResponse&) = delete;
  GamepadMonitor_GamepadStopPolling_HandleSyncResponse& operator=(const GamepadMonitor_GamepadStopPolling_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;};

class GamepadMonitor_GamepadStopPolling_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GamepadMonitor_GamepadStopPolling_ForwardToCallback(
      GamepadMonitor::GamepadStopPollingCallback callback
      ) : callback_(std::move(callback)) {
  }

  GamepadMonitor_GamepadStopPolling_ForwardToCallback(const GamepadMonitor_GamepadStopPolling_ForwardToCallback&) = delete;
  GamepadMonitor_GamepadStopPolling_ForwardToCallback& operator=(const GamepadMonitor_GamepadStopPolling_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  GamepadMonitor::GamepadStopPollingCallback callback_;
};

GamepadMonitorProxy::GamepadMonitorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool GamepadMonitorProxy::GamepadStartPolling(
    ::base::ReadOnlySharedMemoryRegion* out_param_memory_region) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call device::mojom::GamepadMonitor::GamepadStartPolling (sync)");
#else
  TRACE_EVENT0("mojom", "GamepadMonitor::GamepadStartPolling");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GamepadMonitor::kGamepadStartPolling), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::GamepadMonitor_GamepadStartPolling_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GamepadMonitor::Name_);
  message.set_method_name("GamepadStartPolling");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GamepadMonitor_GamepadStartPolling_HandleSyncResponse(
          &result, out_param_memory_region));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "GamepadMonitor::GamepadStartPolling", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("memory_region"), out_param_memory_region,
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
   });
#endif
  return result;
}

void GamepadMonitorProxy::GamepadStartPolling(
    GamepadStartPollingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::GamepadMonitor::GamepadStartPolling");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GamepadMonitor::kGamepadStartPolling), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::GamepadMonitor_GamepadStartPolling_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GamepadMonitor::Name_);
  message.set_method_name("GamepadStartPolling");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GamepadMonitor_GamepadStartPolling_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool GamepadMonitorProxy::GamepadStopPolling(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call device::mojom::GamepadMonitor::GamepadStopPolling (sync)");
#else
  TRACE_EVENT0("mojom", "GamepadMonitor::GamepadStopPolling");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GamepadMonitor::kGamepadStopPolling), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::GamepadMonitor_GamepadStopPolling_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GamepadMonitor::Name_);
  message.set_method_name("GamepadStopPolling");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GamepadMonitor_GamepadStopPolling_HandleSyncResponse(
          &result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "GamepadMonitor::GamepadStopPolling");
#endif
  return result;
}

void GamepadMonitorProxy::GamepadStopPolling(
    GamepadStopPollingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::GamepadMonitor::GamepadStopPolling");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GamepadMonitor::kGamepadStopPolling), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::GamepadMonitor_GamepadStopPolling_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GamepadMonitor::Name_);
  message.set_method_name("GamepadStopPolling");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GamepadMonitor_GamepadStopPolling_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void GamepadMonitorProxy::SetObserver(
    ::mojo::PendingRemote<GamepadObserver> in_gamepad_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::GamepadMonitor::SetObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gamepad_observer"), in_gamepad_observer,
                        "<value of type ::mojo::PendingRemote<GamepadObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GamepadMonitor::kSetObserver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::GamepadMonitor_SetObserver_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::GamepadObserverInterfaceBase>>(
    in_gamepad_observer,
    &params->gamepad_observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->gamepad_observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid gamepad_observer in GamepadMonitor.SetObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GamepadMonitor::Name_);
  message.set_method_name("SetObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class GamepadMonitor_GamepadStartPolling_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static GamepadMonitor::GamepadStartPollingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<GamepadMonitor_GamepadStartPolling_ProxyToResponder> proxy(
        new GamepadMonitor_GamepadStartPolling_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&GamepadMonitor_GamepadStartPolling_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GamepadMonitor_GamepadStartPolling_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  GamepadMonitor_GamepadStartPolling_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GamepadMonitor::GamepadStartPollingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::ReadOnlySharedMemoryRegion in_memory_region);
};

bool GamepadMonitor_GamepadStartPolling_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GamepadMonitor_GamepadStartPolling_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GamepadMonitor_GamepadStartPolling_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for GamepadMonitor.0
  bool success = true;
  ::base::ReadOnlySharedMemoryRegion p_memory_region{};
  GamepadMonitor_GamepadStartPolling_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadMemoryRegion(&p_memory_region))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GamepadMonitor::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_memory_region));
  }
  return true;
}

void GamepadMonitor_GamepadStartPolling_ProxyToResponder::Run(
    ::base::ReadOnlySharedMemoryRegion in_memory_region) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::GamepadMonitor::GamepadStartPolling", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("memory_region"), in_memory_region,
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GamepadMonitor::kGamepadStartPolling), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::GamepadMonitor_GamepadStartPolling_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->memory_region)::BaseType> memory_region_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
    in_memory_region,
    memory_region_fragment);

  params->memory_region.Set(
      memory_region_fragment.is_null() ? nullptr : memory_region_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->memory_region.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null memory_region in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GamepadMonitor::Name_);
  message.set_method_name("GamepadStartPolling");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool GamepadMonitor_GamepadStartPolling_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GamepadMonitor_GamepadStartPolling_ResponseParams_Data* params =
      reinterpret_cast<internal::GamepadMonitor_GamepadStartPolling_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for GamepadMonitor.0
  bool success = true;
  ::base::ReadOnlySharedMemoryRegion p_memory_region{};
  GamepadMonitor_GamepadStartPolling_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadMemoryRegion(&p_memory_region))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GamepadMonitor::Name_, 0, true);
    return false;
  }
  *out_memory_region_ = std::move(p_memory_region);
  *result_ = true;
  return true;
}
class GamepadMonitor_GamepadStopPolling_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static GamepadMonitor::GamepadStopPollingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<GamepadMonitor_GamepadStopPolling_ProxyToResponder> proxy(
        new GamepadMonitor_GamepadStopPolling_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&GamepadMonitor_GamepadStopPolling_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GamepadMonitor_GamepadStopPolling_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  GamepadMonitor_GamepadStopPolling_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GamepadMonitor::GamepadStopPollingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool GamepadMonitor_GamepadStopPolling_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GamepadMonitor_GamepadStopPolling_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GamepadMonitor_GamepadStopPolling_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for GamepadMonitor.1
  bool success = true;
  GamepadMonitor_GamepadStopPolling_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GamepadMonitor::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void GamepadMonitor_GamepadStopPolling_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply device::mojom::GamepadMonitor::GamepadStopPolling");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GamepadMonitor::kGamepadStopPolling), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::GamepadMonitor_GamepadStopPolling_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GamepadMonitor::Name_);
  message.set_method_name("GamepadStopPolling");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool GamepadMonitor_GamepadStopPolling_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GamepadMonitor_GamepadStopPolling_ResponseParams_Data* params =
      reinterpret_cast<internal::GamepadMonitor_GamepadStopPolling_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for GamepadMonitor.1
  bool success = true;
  GamepadMonitor_GamepadStopPolling_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GamepadMonitor::Name_, 1, true);
    return false;
  }
  *result_ = true;
  return true;
}

// static
bool GamepadMonitorStubDispatch::Accept(
    GamepadMonitor* impl,
    mojo::Message* message) {
  switch (static_cast<messages::GamepadMonitor>(message->header()->name)) {
    case messages::GamepadMonitor::kGamepadStartPolling: {
      break;
    }
    case messages::GamepadMonitor::kGamepadStopPolling: {
      break;
    }
    case messages::GamepadMonitor::kSetObserver: {
      DCHECK(message->is_serialized());
      internal::GamepadMonitor_SetObserver_Params_Data* params =
          reinterpret_cast<internal::GamepadMonitor_SetObserver_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GamepadMonitor.2
      bool success = true;
      ::mojo::PendingRemote<GamepadObserver> p_gamepad_observer{};
      GamepadMonitor_SetObserver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_gamepad_observer =
            input_data_view.TakeGamepadObserver<decltype(p_gamepad_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GamepadMonitor::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetObserver(        
        std::move(p_gamepad_observer));
      return true;
    }
  }
  return false;
}

// static
bool GamepadMonitorStubDispatch::AcceptWithResponder(
    GamepadMonitor* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::GamepadMonitor>(message->header()->name)) {
    case messages::GamepadMonitor::kGamepadStartPolling: {
      internal::GamepadMonitor_GamepadStartPolling_Params_Data* params =
          reinterpret_cast<
              internal::GamepadMonitor_GamepadStartPolling_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for GamepadMonitor.0
      bool success = true;
      GamepadMonitor_GamepadStartPolling_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GamepadMonitor::Name_, 0, false);
        return false;
      }
      auto callback =
          GamepadMonitor_GamepadStartPolling_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GamepadStartPolling(std::move(callback));
      return true;
    }
    case messages::GamepadMonitor::kGamepadStopPolling: {
      internal::GamepadMonitor_GamepadStopPolling_Params_Data* params =
          reinterpret_cast<
              internal::GamepadMonitor_GamepadStopPolling_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for GamepadMonitor.1
      bool success = true;
      GamepadMonitor_GamepadStopPolling_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GamepadMonitor::Name_, 1, false);
        return false;
      }
      auto callback =
          GamepadMonitor_GamepadStopPolling_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GamepadStopPolling(std::move(callback));
      return true;
    }
    case messages::GamepadMonitor::kSetObserver: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kGamepadMonitorValidationInfo[] = {
    {base::to_underlying(messages::GamepadMonitor::kGamepadStartPolling),
     { &internal::GamepadMonitor_GamepadStartPolling_Params_Data::Validate,
      &internal::GamepadMonitor_GamepadStartPolling_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::GamepadMonitor::kGamepadStopPolling),
     { &internal::GamepadMonitor_GamepadStopPolling_Params_Data::Validate,
      &internal::GamepadMonitor_GamepadStopPolling_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::GamepadMonitor::kSetObserver),
     { &internal::GamepadMonitor_SetObserver_Params_Data::Validate,
      nullptr /* no response */}},
};

bool GamepadMonitorRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::device::mojom::blink::GamepadMonitor::Name_,
    kGamepadMonitorValidationInfo);
}

bool GamepadMonitorResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::device::mojom::blink::GamepadMonitor::Name_,
    kGamepadMonitorValidationInfo);

}
// The declaration includes the definition on other builds.

GamepadHapticsManager::IPCStableHashFunction GamepadHapticsManager::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::GamepadHapticsManager>(message.name())) {
    case messages::GamepadHapticsManager::kPlayVibrationEffectOnce: {
      return &GamepadHapticsManager::PlayVibrationEffectOnce_Sym::IPCStableHash;
    }
    case messages::GamepadHapticsManager::kResetVibrationActuator: {
      return &GamepadHapticsManager::ResetVibrationActuator_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* GamepadHapticsManager::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::GamepadHapticsManager>(message.name())) {
      case messages::GamepadHapticsManager::kPlayVibrationEffectOnce:
            return "Receive device::mojom::GamepadHapticsManager::PlayVibrationEffectOnce";
      case messages::GamepadHapticsManager::kResetVibrationActuator:
            return "Receive device::mojom::GamepadHapticsManager::ResetVibrationActuator";
    }
  } else {
    switch (static_cast<messages::GamepadHapticsManager>(message.name())) {
      case messages::GamepadHapticsManager::kPlayVibrationEffectOnce:
            return "Receive reply device::mojom::GamepadHapticsManager::PlayVibrationEffectOnce";
      case messages::GamepadHapticsManager::kResetVibrationActuator:
            return "Receive reply device::mojom::GamepadHapticsManager::ResetVibrationActuator";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t GamepadHapticsManager::PlayVibrationEffectOnce_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf5049fcb;  // IPCStableHash for device::mojom::GamepadHapticsManager::PlayVibrationEffectOnce
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GamepadHapticsManager::ResetVibrationActuator_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd5e6182d;  // IPCStableHash for device::mojom::GamepadHapticsManager::ResetVibrationActuator
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class GamepadHapticsManager_PlayVibrationEffectOnce_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GamepadHapticsManager_PlayVibrationEffectOnce_ForwardToCallback(
      GamepadHapticsManager::PlayVibrationEffectOnceCallback callback
      ) : callback_(std::move(callback)) {
  }

  GamepadHapticsManager_PlayVibrationEffectOnce_ForwardToCallback(const GamepadHapticsManager_PlayVibrationEffectOnce_ForwardToCallback&) = delete;
  GamepadHapticsManager_PlayVibrationEffectOnce_ForwardToCallback& operator=(const GamepadHapticsManager_PlayVibrationEffectOnce_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  GamepadHapticsManager::PlayVibrationEffectOnceCallback callback_;
};

class GamepadHapticsManager_ResetVibrationActuator_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GamepadHapticsManager_ResetVibrationActuator_ForwardToCallback(
      GamepadHapticsManager::ResetVibrationActuatorCallback callback
      ) : callback_(std::move(callback)) {
  }

  GamepadHapticsManager_ResetVibrationActuator_ForwardToCallback(const GamepadHapticsManager_ResetVibrationActuator_ForwardToCallback&) = delete;
  GamepadHapticsManager_ResetVibrationActuator_ForwardToCallback& operator=(const GamepadHapticsManager_ResetVibrationActuator_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  GamepadHapticsManager::ResetVibrationActuatorCallback callback_;
};

GamepadHapticsManagerProxy::GamepadHapticsManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void GamepadHapticsManagerProxy::PlayVibrationEffectOnce(
    uint32_t in_pad_index, GamepadHapticEffectType in_type, GamepadEffectParametersPtr in_params, PlayVibrationEffectOnceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::GamepadHapticsManager::PlayVibrationEffectOnce", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pad_index"), in_pad_index,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type GamepadHapticEffectType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type GamepadEffectParametersPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GamepadHapticsManager::kPlayVibrationEffectOnce), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::GamepadHapticsManager_PlayVibrationEffectOnce_Params_Data> params(
          message);
  params.Allocate();

  params->pad_index = in_pad_index;

  
  mojo::internal::Serialize<::device::mojom::GamepadHapticEffectType>(
    in_type,
    &params->type);
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::GamepadEffectParametersDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in GamepadHapticsManager.PlayVibrationEffectOnce request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GamepadHapticsManager::Name_);
  message.set_method_name("PlayVibrationEffectOnce");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GamepadHapticsManager_PlayVibrationEffectOnce_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void GamepadHapticsManagerProxy::ResetVibrationActuator(
    uint32_t in_pad_index, ResetVibrationActuatorCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::GamepadHapticsManager::ResetVibrationActuator", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pad_index"), in_pad_index,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GamepadHapticsManager::kResetVibrationActuator), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::GamepadHapticsManager_ResetVibrationActuator_Params_Data> params(
          message);
  params.Allocate();

  params->pad_index = in_pad_index;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GamepadHapticsManager::Name_);
  message.set_method_name("ResetVibrationActuator");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GamepadHapticsManager_ResetVibrationActuator_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class GamepadHapticsManager_PlayVibrationEffectOnce_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static GamepadHapticsManager::PlayVibrationEffectOnceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<GamepadHapticsManager_PlayVibrationEffectOnce_ProxyToResponder> proxy(
        new GamepadHapticsManager_PlayVibrationEffectOnce_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&GamepadHapticsManager_PlayVibrationEffectOnce_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GamepadHapticsManager_PlayVibrationEffectOnce_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  GamepadHapticsManager_PlayVibrationEffectOnce_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GamepadHapticsManager::PlayVibrationEffectOnceCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      GamepadHapticsResult in_result);
};

bool GamepadHapticsManager_PlayVibrationEffectOnce_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GamepadHapticsManager_PlayVibrationEffectOnce_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GamepadHapticsManager_PlayVibrationEffectOnce_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for GamepadHapticsManager.0
  bool success = true;
  GamepadHapticsResult p_result{};
  GamepadHapticsManager_PlayVibrationEffectOnce_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GamepadHapticsManager::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void GamepadHapticsManager_PlayVibrationEffectOnce_ProxyToResponder::Run(
    GamepadHapticsResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::GamepadHapticsManager::PlayVibrationEffectOnce", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type GamepadHapticsResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GamepadHapticsManager::kPlayVibrationEffectOnce), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::GamepadHapticsManager_PlayVibrationEffectOnce_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::device::mojom::GamepadHapticsResult>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GamepadHapticsManager::Name_);
  message.set_method_name("PlayVibrationEffectOnce");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class GamepadHapticsManager_ResetVibrationActuator_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static GamepadHapticsManager::ResetVibrationActuatorCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<GamepadHapticsManager_ResetVibrationActuator_ProxyToResponder> proxy(
        new GamepadHapticsManager_ResetVibrationActuator_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&GamepadHapticsManager_ResetVibrationActuator_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GamepadHapticsManager_ResetVibrationActuator_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  GamepadHapticsManager_ResetVibrationActuator_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GamepadHapticsManager::ResetVibrationActuatorCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      GamepadHapticsResult in_result);
};

bool GamepadHapticsManager_ResetVibrationActuator_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GamepadHapticsManager_ResetVibrationActuator_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GamepadHapticsManager_ResetVibrationActuator_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for GamepadHapticsManager.1
  bool success = true;
  GamepadHapticsResult p_result{};
  GamepadHapticsManager_ResetVibrationActuator_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GamepadHapticsManager::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void GamepadHapticsManager_ResetVibrationActuator_ProxyToResponder::Run(
    GamepadHapticsResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::GamepadHapticsManager::ResetVibrationActuator", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type GamepadHapticsResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GamepadHapticsManager::kResetVibrationActuator), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::GamepadHapticsManager_ResetVibrationActuator_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::device::mojom::GamepadHapticsResult>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GamepadHapticsManager::Name_);
  message.set_method_name("ResetVibrationActuator");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool GamepadHapticsManagerStubDispatch::Accept(
    GamepadHapticsManager* impl,
    mojo::Message* message) {
  switch (static_cast<messages::GamepadHapticsManager>(message->header()->name)) {
    case messages::GamepadHapticsManager::kPlayVibrationEffectOnce: {
      break;
    }
    case messages::GamepadHapticsManager::kResetVibrationActuator: {
      break;
    }
  }
  return false;
}

// static
bool GamepadHapticsManagerStubDispatch::AcceptWithResponder(
    GamepadHapticsManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::GamepadHapticsManager>(message->header()->name)) {
    case messages::GamepadHapticsManager::kPlayVibrationEffectOnce: {
      internal::GamepadHapticsManager_PlayVibrationEffectOnce_Params_Data* params =
          reinterpret_cast<
              internal::GamepadHapticsManager_PlayVibrationEffectOnce_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for GamepadHapticsManager.0
      bool success = true;
      uint32_t p_pad_index{};
      GamepadHapticEffectType p_type{};
      GamepadEffectParametersPtr p_params{};
      GamepadHapticsManager_PlayVibrationEffectOnce_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_pad_index = input_data_view.pad_index();
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GamepadHapticsManager::Name_, 0, false);
        return false;
      }
      auto callback =
          GamepadHapticsManager_PlayVibrationEffectOnce_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PlayVibrationEffectOnce(        
        std::move(p_pad_index), 
        std::move(p_type), 
        std::move(p_params), std::move(callback));
      return true;
    }
    case messages::GamepadHapticsManager::kResetVibrationActuator: {
      internal::GamepadHapticsManager_ResetVibrationActuator_Params_Data* params =
          reinterpret_cast<
              internal::GamepadHapticsManager_ResetVibrationActuator_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for GamepadHapticsManager.1
      bool success = true;
      uint32_t p_pad_index{};
      GamepadHapticsManager_ResetVibrationActuator_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_pad_index = input_data_view.pad_index();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GamepadHapticsManager::Name_, 1, false);
        return false;
      }
      auto callback =
          GamepadHapticsManager_ResetVibrationActuator_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResetVibrationActuator(        
        std::move(p_pad_index), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kGamepadHapticsManagerValidationInfo[] = {
    {base::to_underlying(messages::GamepadHapticsManager::kPlayVibrationEffectOnce),
     { &internal::GamepadHapticsManager_PlayVibrationEffectOnce_Params_Data::Validate,
      &internal::GamepadHapticsManager_PlayVibrationEffectOnce_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::GamepadHapticsManager::kResetVibrationActuator),
     { &internal::GamepadHapticsManager_ResetVibrationActuator_Params_Data::Validate,
      &internal::GamepadHapticsManager_ResetVibrationActuator_ResponseParams_Data::Validate}},
};

bool GamepadHapticsManagerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::device::mojom::blink::GamepadHapticsManager::Name_,
    kGamepadHapticsManagerValidationInfo);
}

bool GamepadHapticsManagerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::device::mojom::blink::GamepadHapticsManager::Name_,
    kGamepadHapticsManagerValidationInfo);

}


}  // device::mojom::blink


namespace mojo {


// static
bool StructTraits<::device::mojom::blink::GamepadQuaternion::DataView, ::device::mojom::blink::GamepadQuaternionPtr>::Read(
    ::device::mojom::blink::GamepadQuaternion::DataView input,
    ::device::mojom::blink::GamepadQuaternionPtr* output) {
  bool success = true;
  ::device::mojom::blink::GamepadQuaternionPtr result(::device::mojom::blink::GamepadQuaternion::New());
  
      if (success)
        result->x = input.x();
      if (success)
        result->y = input.y();
      if (success)
        result->z = input.z();
      if (success)
        result->w = input.w();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::GamepadVector::DataView, ::device::mojom::blink::GamepadVectorPtr>::Read(
    ::device::mojom::blink::GamepadVector::DataView input,
    ::device::mojom::blink::GamepadVectorPtr* output) {
  bool success = true;
  ::device::mojom::blink::GamepadVectorPtr result(::device::mojom::blink::GamepadVector::New());
  
      if (success)
        result->x = input.x();
      if (success)
        result->y = input.y();
      if (success)
        result->z = input.z();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::GamepadButton::DataView, ::device::mojom::blink::GamepadButtonPtr>::Read(
    ::device::mojom::blink::GamepadButton::DataView input,
    ::device::mojom::blink::GamepadButtonPtr* output) {
  bool success = true;
  ::device::mojom::blink::GamepadButtonPtr result(::device::mojom::blink::GamepadButton::New());
  
      if (success)
        result->pressed = input.pressed();
      if (success)
        result->touched = input.touched();
      if (success)
        result->value = input.value();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::GamepadTouch::DataView, ::device::mojom::blink::GamepadTouchPtr>::Read(
    ::device::mojom::blink::GamepadTouch::DataView input,
    ::device::mojom::blink::GamepadTouchPtr* output) {
  bool success = true;
  ::device::mojom::blink::GamepadTouchPtr result(::device::mojom::blink::GamepadTouch::New());
  
      if (success)
        result->touch_id = input.touch_id();
      if (success)
        result->surface_id = input.surface_id();
      if (success)
        result->x = input.x();
      if (success)
        result->y = input.y();
      if (success)
        result->surface_height = input.surface_height();
      if (success)
        result->surface_width = input.surface_width();
      if (success)
        result->has_surface_dimensions = input.has_surface_dimensions();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::GamepadPose::DataView, ::device::mojom::blink::GamepadPosePtr>::Read(
    ::device::mojom::blink::GamepadPose::DataView input,
    ::device::mojom::blink::GamepadPosePtr* output) {
  bool success = true;
  ::device::mojom::blink::GamepadPosePtr result(::device::mojom::blink::GamepadPose::New());
  
      if (success && !input.ReadOrientation(&result->orientation))
        success = false;
      if (success && !input.ReadPosition(&result->position))
        success = false;
      if (success && !input.ReadAngularVelocity(&result->angular_velocity))
        success = false;
      if (success && !input.ReadLinearVelocity(&result->linear_velocity))
        success = false;
      if (success && !input.ReadAngularAcceleration(&result->angular_acceleration))
        success = false;
      if (success && !input.ReadLinearAcceleration(&result->linear_acceleration))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::GamepadHapticActuator::DataView, ::device::mojom::blink::GamepadHapticActuatorPtr>::Read(
    ::device::mojom::blink::GamepadHapticActuator::DataView input,
    ::device::mojom::blink::GamepadHapticActuatorPtr* output) {
  bool success = true;
  ::device::mojom::blink::GamepadHapticActuatorPtr result(::device::mojom::blink::GamepadHapticActuator::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::Gamepad::DataView, ::device::mojom::blink::GamepadPtr>::Read(
    ::device::mojom::blink::Gamepad::DataView input,
    ::device::mojom::blink::GamepadPtr* output) {
  bool success = true;
  ::device::mojom::blink::GamepadPtr result(::device::mojom::blink::Gamepad::New());
  
      if (success)
        result->connected = input.connected();
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success)
        result->timestamp = input.timestamp();
      if (success && !input.ReadAxes(&result->axes))
        success = false;
      if (success && !input.ReadButtons(&result->buttons))
        success = false;
      if (success && !input.ReadVibrationActuator(&result->vibration_actuator))
        success = false;
      if (success && !input.ReadMapping(&result->mapping))
        success = false;
      if (success && !input.ReadPose(&result->pose))
        success = false;
      if (success && !input.ReadHand(&result->hand))
        success = false;
      if (success && !input.ReadTouchEvents(&result->touch_events))
        success = false;
      if (success)
        result->display_id = input.display_id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::GamepadEffectParameters::DataView, ::device::mojom::blink::GamepadEffectParametersPtr>::Read(
    ::device::mojom::blink::GamepadEffectParameters::DataView input,
    ::device::mojom::blink::GamepadEffectParametersPtr* output) {
  bool success = true;
  ::device::mojom::blink::GamepadEffectParametersPtr result(::device::mojom::blink::GamepadEffectParameters::New());
  
      if (success)
        result->duration = input.duration();
      if (success)
        result->start_delay = input.start_delay();
      if (success)
        result->strong_magnitude = input.strong_magnitude();
      if (success)
        result->weak_magnitude = input.weak_magnitude();
      if (success)
        result->left_trigger = input.left_trigger();
      if (success)
        result->right_trigger = input.right_trigger();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace device::mojom::blink {


void GamepadObserverInterceptorForTesting::GamepadConnected(uint32_t index, const ::device::Gamepad& gamepad) {
  GetForwardingInterface()->GamepadConnected(
    std::move(index)
    , 
    std::move(gamepad)
    );
}
void GamepadObserverInterceptorForTesting::GamepadDisconnected(uint32_t index, const ::device::Gamepad& gamepad) {
  GetForwardingInterface()->GamepadDisconnected(
    std::move(index)
    , 
    std::move(gamepad)
    );
}
GamepadObserverAsyncWaiter::GamepadObserverAsyncWaiter(
    GamepadObserver* proxy) : proxy_(proxy) {}

GamepadObserverAsyncWaiter::~GamepadObserverAsyncWaiter() = default;





void GamepadMonitorInterceptorForTesting::GamepadStartPolling(GamepadStartPollingCallback callback) {
  GetForwardingInterface()->GamepadStartPolling(std::move(callback));
}
void GamepadMonitorInterceptorForTesting::GamepadStopPolling(GamepadStopPollingCallback callback) {
  GetForwardingInterface()->GamepadStopPolling(std::move(callback));
}
void GamepadMonitorInterceptorForTesting::SetObserver(::mojo::PendingRemote<GamepadObserver> gamepad_observer) {
  GetForwardingInterface()->SetObserver(
    std::move(gamepad_observer)
    );
}
GamepadMonitorAsyncWaiter::GamepadMonitorAsyncWaiter(
    GamepadMonitor* proxy) : proxy_(proxy) {}

GamepadMonitorAsyncWaiter::~GamepadMonitorAsyncWaiter() = default;


void GamepadMonitorAsyncWaiter::GamepadStartPolling(
    ::base::ReadOnlySharedMemoryRegion* out_memory_region) {
  base::RunLoop loop;
  proxy_->GamepadStartPolling(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::ReadOnlySharedMemoryRegion* out_memory_region
,
             ::base::ReadOnlySharedMemoryRegion memory_region) {*out_memory_region = std::move(memory_region);
            loop->Quit();
          },
          &loop,
          out_memory_region));
  loop.Run();
}

::base::ReadOnlySharedMemoryRegion GamepadMonitorAsyncWaiter::GamepadStartPolling(
    ) {
  ::base::ReadOnlySharedMemoryRegion async_wait_result;
  GamepadStartPolling(&async_wait_result);
  return async_wait_result;
}

void GamepadMonitorAsyncWaiter::GamepadStopPolling(
    ) {
  base::RunLoop loop;
  proxy_->GamepadStopPolling(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}






void GamepadHapticsManagerInterceptorForTesting::PlayVibrationEffectOnce(uint32_t pad_index, GamepadHapticEffectType type, GamepadEffectParametersPtr params, PlayVibrationEffectOnceCallback callback) {
  GetForwardingInterface()->PlayVibrationEffectOnce(
    std::move(pad_index)
    , 
    std::move(type)
    , 
    std::move(params)
    , std::move(callback));
}
void GamepadHapticsManagerInterceptorForTesting::ResetVibrationActuator(uint32_t pad_index, ResetVibrationActuatorCallback callback) {
  GetForwardingInterface()->ResetVibrationActuator(
    std::move(pad_index)
    , std::move(callback));
}
GamepadHapticsManagerAsyncWaiter::GamepadHapticsManagerAsyncWaiter(
    GamepadHapticsManager* proxy) : proxy_(proxy) {}

GamepadHapticsManagerAsyncWaiter::~GamepadHapticsManagerAsyncWaiter() = default;


void GamepadHapticsManagerAsyncWaiter::PlayVibrationEffectOnce(
    uint32_t pad_index, GamepadHapticEffectType type, GamepadEffectParametersPtr params, GamepadHapticsResult* out_result) {
  base::RunLoop loop;
  proxy_->PlayVibrationEffectOnce(
      std::move(pad_index),
      std::move(type),
      std::move(params),
      base::BindOnce(
          [](base::RunLoop* loop,
             GamepadHapticsResult* out_result
,
             GamepadHapticsResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

GamepadHapticsResult GamepadHapticsManagerAsyncWaiter::PlayVibrationEffectOnce(
    uint32_t pad_index, GamepadHapticEffectType type, GamepadEffectParametersPtr params) {
  GamepadHapticsResult async_wait_result;
  PlayVibrationEffectOnce(std::move(pad_index),std::move(type),std::move(params),&async_wait_result);
  return async_wait_result;
}

void GamepadHapticsManagerAsyncWaiter::ResetVibrationActuator(
    uint32_t pad_index, GamepadHapticsResult* out_result) {
  base::RunLoop loop;
  proxy_->ResetVibrationActuator(
      std::move(pad_index),
      base::BindOnce(
          [](base::RunLoop* loop,
             GamepadHapticsResult* out_result
,
             GamepadHapticsResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

GamepadHapticsResult GamepadHapticsManagerAsyncWaiter::ResetVibrationActuator(
    uint32_t pad_index) {
  GamepadHapticsResult async_wait_result;
  ResetVibrationActuator(std::move(pad_index),&async_wait_result);
  return async_wait_result;
}






}  // device::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif