// device/vr/public/mojom/xr_session.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "device/vr/public/mojom/xr_session.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "device/vr/public/mojom/xr_session.mojom-params-data.h"
namespace device {
namespace mojom {

NOINLINE static const char* RequestSessionErrorToStringHelper(RequestSessionError value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RequestSessionError::EXISTING_IMMERSIVE_SESSION:
      return "EXISTING_IMMERSIVE_SESSION";
    case RequestSessionError::INVALID_CLIENT:
      return "INVALID_CLIENT";
    case RequestSessionError::USER_DENIED_CONSENT:
      return "USER_DENIED_CONSENT";
    case RequestSessionError::NO_RUNTIME_FOUND:
      return "NO_RUNTIME_FOUND";
    case RequestSessionError::UNKNOWN_RUNTIME_ERROR:
      return "UNKNOWN_RUNTIME_ERROR";
    case RequestSessionError::RUNTIME_INSTALL_FAILURE:
      return "RUNTIME_INSTALL_FAILURE";
    case RequestSessionError::RUNTIMES_CHANGED:
      return "RUNTIMES_CHANGED";
    case RequestSessionError::FULLSCREEN_ERROR:
      return "FULLSCREEN_ERROR";
    case RequestSessionError::UNKNOWN_FAILURE:
      return "UNKNOWN_FAILURE";
    default:
      return nullptr;
  }
}

std::string RequestSessionErrorToString(RequestSessionError value) {
  const char *str = RequestSessionErrorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RequestSessionError value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RequestSessionError value) {
  return os << RequestSessionErrorToString(value);
}

NOINLINE static const char* XRSessionFeatureToStringHelper(XRSessionFeature value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case XRSessionFeature::REF_SPACE_VIEWER:
      return "REF_SPACE_VIEWER";
    case XRSessionFeature::REF_SPACE_LOCAL:
      return "REF_SPACE_LOCAL";
    case XRSessionFeature::REF_SPACE_LOCAL_FLOOR:
      return "REF_SPACE_LOCAL_FLOOR";
    case XRSessionFeature::REF_SPACE_BOUNDED_FLOOR:
      return "REF_SPACE_BOUNDED_FLOOR";
    case XRSessionFeature::REF_SPACE_UNBOUNDED:
      return "REF_SPACE_UNBOUNDED";
    case XRSessionFeature::DOM_OVERLAY:
      return "DOM_OVERLAY";
    case XRSessionFeature::HIT_TEST:
      return "HIT_TEST";
    case XRSessionFeature::LIGHT_ESTIMATION:
      return "LIGHT_ESTIMATION";
    case XRSessionFeature::ANCHORS:
      return "ANCHORS";
    case XRSessionFeature::CAMERA_ACCESS:
      return "CAMERA_ACCESS";
    case XRSessionFeature::PLANE_DETECTION:
      return "PLANE_DETECTION";
    case XRSessionFeature::DEPTH:
      return "DEPTH";
    case XRSessionFeature::IMAGE_TRACKING:
      return "IMAGE_TRACKING";
    case XRSessionFeature::HAND_INPUT:
      return "HAND_INPUT";
    case XRSessionFeature::SECONDARY_VIEWS:
      return "SECONDARY_VIEWS";
    case XRSessionFeature::LAYERS:
      return "LAYERS";
    case XRSessionFeature::FRONT_FACING:
      return "FRONT_FACING";
    case XRSessionFeature::WEBGPU:
      return "WEBGPU";
    default:
      return nullptr;
  }
}

std::string XRSessionFeatureToString(XRSessionFeature value) {
  const char *str = XRSessionFeatureToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown XRSessionFeature value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, XRSessionFeature value) {
  return os << XRSessionFeatureToString(value);
}

NOINLINE static const char* XRSessionModeToStringHelper(XRSessionMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case XRSessionMode::kInline:
      return "kInline";
    case XRSessionMode::kImmersiveVr:
      return "kImmersiveVr";
    case XRSessionMode::kImmersiveAr:
      return "kImmersiveAr";
    default:
      return nullptr;
  }
}

std::string XRSessionModeToString(XRSessionMode value) {
  const char *str = XRSessionModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown XRSessionMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, XRSessionMode value) {
  return os << XRSessionModeToString(value);
}

NOINLINE static const char* XRDepthUsageToStringHelper(XRDepthUsage value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case XRDepthUsage::kCPUOptimized:
      return "kCPUOptimized";
    case XRDepthUsage::kGPUOptimized:
      return "kGPUOptimized";
    default:
      return nullptr;
  }
}

std::string XRDepthUsageToString(XRDepthUsage value) {
  const char *str = XRDepthUsageToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown XRDepthUsage value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, XRDepthUsage value) {
  return os << XRDepthUsageToString(value);
}

NOINLINE static const char* XRDepthDataFormatToStringHelper(XRDepthDataFormat value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case XRDepthDataFormat::kLuminanceAlpha:
      return "kLuminanceAlpha";
    case XRDepthDataFormat::kFloat32:
      return "kFloat32";
    case XRDepthDataFormat::kUnsignedShort:
      return "kUnsignedShort";
    default:
      return nullptr;
  }
}

std::string XRDepthDataFormatToString(XRDepthDataFormat value) {
  const char *str = XRDepthDataFormatToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown XRDepthDataFormat value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, XRDepthDataFormat value) {
  return os << XRDepthDataFormatToString(value);
}

NOINLINE static const char* XRDepthTypeToStringHelper(XRDepthType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case XRDepthType::kRaw:
      return "kRaw";
    case XRDepthType::kSmooth:
      return "kSmooth";
    default:
      return nullptr;
  }
}

std::string XRDepthTypeToString(XRDepthType value) {
  const char *str = XRDepthTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown XRDepthType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, XRDepthType value) {
  return os << XRDepthTypeToString(value);
}

namespace internal {


// static
bool XRTrackedImage_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRTrackedImage_Data* object =
      static_cast<const XRTrackedImage_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bitmap, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bitmap, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->size_in_pixels, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->size_in_pixels, validation_context))
    return false;

  return true;
}

XRTrackedImage_Data::XRTrackedImage_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRDepthOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRDepthOptions_Data* object =
      static_cast<const XRDepthOptions_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->usage_preferences, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& usage_preferences_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::device::mojom::internal::XRDepthUsage_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->usage_preferences, validation_context,
                                         &usage_preferences_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data_format_preferences, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& data_format_preferences_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::device::mojom::internal::XRDepthDataFormat_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->data_format_preferences, validation_context,
                                         &data_format_preferences_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->depth_type_request, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& depth_type_request_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::device::mojom::internal::XRDepthType_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->depth_type_request, validation_context,
                                         &depth_type_request_validate_params)) {
    return false;
  }

  return true;
}

XRDepthOptions_Data::XRDepthOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRSessionOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRSessionOptions_Data* object =
      static_cast<const XRSessionOptions_Data*>(data);


  if (!::device::mojom::internal::XRSessionMode_Data
        ::Validate(object->mode, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->required_features, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& required_features_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::device::mojom::internal::XRSessionFeature_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->required_features, validation_context,
                                         &required_features_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->optional_features, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& optional_features_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::device::mojom::internal::XRSessionFeature_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->optional_features, validation_context,
                                         &optional_features_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tracked_images, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& tracked_images_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->tracked_images, validation_context,
                                         &tracked_images_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->depth_options, validation_context))
    return false;

  return true;
}

XRSessionOptions_Data::XRSessionOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XrFrameStatistics_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XrFrameStatistics_Data* object =
      static_cast<const XrFrameStatistics_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->duration, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->duration, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_data_time, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_data_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->page_animation_frame_time, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->page_animation_frame_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->submit_frame_time, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->submit_frame_time, validation_context))
    return false;

  return true;
}

XrFrameStatistics_Data::XrFrameStatistics_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XrLogMessage_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XrLogMessage_Data* object =
      static_cast<const XrLogMessage_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

XrLogMessage_Data::XrLogMessage_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace device

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::RequestSessionError>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::RequestSessionError value) {
  return std::move(context).WriteString(::device::mojom::RequestSessionErrorToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::XRSessionFeature>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::XRSessionFeature value) {
  return std::move(context).WriteString(::device::mojom::XRSessionFeatureToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::XRSessionMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::XRSessionMode value) {
  return std::move(context).WriteString(::device::mojom::XRSessionModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::XRDepthUsage>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::XRDepthUsage value) {
  return std::move(context).WriteString(::device::mojom::XRDepthUsageToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::XRDepthDataFormat>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::XRDepthDataFormat value) {
  return std::move(context).WriteString(::device::mojom::XRDepthDataFormatToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::XRDepthType>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::XRDepthType value) {
  return std::move(context).WriteString(::device::mojom::XRDepthTypeToString(value));
}

} // namespace perfetto