// extensions/common/mojom/permission_set.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_PERMISSION_SET_MOJOM_SHARED_H_
#define EXTENSIONS_COMMON_MOJOM_PERMISSION_SET_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "extensions/common/mojom/permission_set.mojom-shared-internal.h"
#include "extensions/common/mojom/api_permission_id.mojom-shared.h"
#include "extensions/common/mojom/url_pattern_set.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"




#include "extensions/common/mojom/permission_set.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::extensions::mojom::APIPermissionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::APIPermissionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::APIPermission_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::extensions::mojom::APIPermissionID>(
      Traits::id(input),
      &fragment->id);

    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<decltype(fragment->value)>
        value_fragment(fragment.message());
    value_fragment.Claim(&fragment->value);
    
    mojo::internal::Serialize<::mojo_base::mojom::ValueDataView>(
      in_value,
      value_fragment,
      true);
  }

  static bool Deserialize(::extensions::mojom::internal::APIPermission_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::extensions::mojom::APIPermissionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::extensions::mojom::APIPermissionSetDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::APIPermissionSetDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::APIPermissionSet_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::permission_map(input)) in_permission_map = Traits::permission_map(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->permission_map)::BaseType>
        permission_map_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& permission_map_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::extensions::mojom::internal::APIPermissionID_Data::Validate>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<::extensions::mojom::APIPermissionID, ::extensions::mojom::APIPermissionDataView>>(
      in_permission_map,
      permission_map_fragment,
      &permission_map_validate_params);

    fragment->permission_map.Set(
        permission_map_fragment.is_null() ? nullptr : permission_map_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->permission_map.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null permission_map in APIPermissionSet struct");
  }

  static bool Deserialize(::extensions::mojom::internal::APIPermissionSet_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::extensions::mojom::APIPermissionSetDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::extensions::mojom::ManifestPermissionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::ManifestPermissionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::ManifestPermission_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in ManifestPermission struct");

    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<decltype(fragment->value)>
        value_fragment(fragment.message());
    value_fragment.Claim(&fragment->value);
    
    mojo::internal::Serialize<::mojo_base::mojom::ValueDataView>(
      in_value,
      value_fragment,
      true);
  }

  static bool Deserialize(::extensions::mojom::internal::ManifestPermission_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::extensions::mojom::ManifestPermissionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::extensions::mojom::ManifestPermissionSetDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::ManifestPermissionSetDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::ManifestPermissionSet_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::permission_map(input)) in_permission_map = Traits::permission_map(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->permission_map)::BaseType>
        permission_map_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& permission_map_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::extensions::mojom::ManifestPermissionDataView>>(
      in_permission_map,
      permission_map_fragment,
      &permission_map_validate_params);

    fragment->permission_map.Set(
        permission_map_fragment.is_null() ? nullptr : permission_map_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->permission_map.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null permission_map in ManifestPermissionSet struct");
  }

  static bool Deserialize(::extensions::mojom::internal::ManifestPermissionSet_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::extensions::mojom::ManifestPermissionSetDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::extensions::mojom::PermissionSetDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::PermissionSetDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::PermissionSet_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::apis(input)) in_apis = Traits::apis(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->apis)::BaseType> apis_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::extensions::mojom::APIPermissionSetDataView>(
      in_apis,
      apis_fragment);

    fragment->apis.Set(
        apis_fragment.is_null() ? nullptr : apis_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->apis.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null apis in PermissionSet struct");

    decltype(Traits::manifest_permissions(input)) in_manifest_permissions = Traits::manifest_permissions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->manifest_permissions)::BaseType> manifest_permissions_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::extensions::mojom::ManifestPermissionSetDataView>(
      in_manifest_permissions,
      manifest_permissions_fragment);

    fragment->manifest_permissions.Set(
        manifest_permissions_fragment.is_null() ? nullptr : manifest_permissions_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->manifest_permissions.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null manifest_permissions in PermissionSet struct");

    decltype(Traits::hosts(input)) in_hosts = Traits::hosts(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->hosts)::BaseType> hosts_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::extensions::mojom::URLPatternSetDataView>(
      in_hosts,
      hosts_fragment);

    fragment->hosts.Set(
        hosts_fragment.is_null() ? nullptr : hosts_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->hosts.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null hosts in PermissionSet struct");

    decltype(Traits::user_script_hosts(input)) in_user_script_hosts = Traits::user_script_hosts(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->user_script_hosts)::BaseType> user_script_hosts_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::extensions::mojom::URLPatternSetDataView>(
      in_user_script_hosts,
      user_script_hosts_fragment);

    fragment->user_script_hosts.Set(
        user_script_hosts_fragment.is_null() ? nullptr : user_script_hosts_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->user_script_hosts.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null user_script_hosts in PermissionSet struct");
  }

  static bool Deserialize(::extensions::mojom::internal::PermissionSet_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::extensions::mojom::PermissionSetDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace extensions::mojom {

inline void APIPermissionDataView::GetValueDataView(
    ::mojo_base::mojom::ValueDataView* output) {
  auto pointer = &data_->value;
  *output = ::mojo_base::mojom::ValueDataView(pointer, message_);
}


inline void APIPermissionSetDataView::GetPermissionMapDataView(
    mojo::MapDataView<::extensions::mojom::APIPermissionID, APIPermissionDataView>* output) {
  auto pointer = data_->permission_map.Get();
  *output = mojo::MapDataView<::extensions::mojom::APIPermissionID, APIPermissionDataView>(pointer, message_);
}


inline void ManifestPermissionDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ManifestPermissionDataView::GetValueDataView(
    ::mojo_base::mojom::ValueDataView* output) {
  auto pointer = &data_->value;
  *output = ::mojo_base::mojom::ValueDataView(pointer, message_);
}


inline void ManifestPermissionSetDataView::GetPermissionMapDataView(
    mojo::MapDataView<mojo::StringDataView, ManifestPermissionDataView>* output) {
  auto pointer = data_->permission_map.Get();
  *output = mojo::MapDataView<mojo::StringDataView, ManifestPermissionDataView>(pointer, message_);
}


inline void PermissionSetDataView::GetApisDataView(
    APIPermissionSetDataView* output) {
  auto pointer = data_->apis.Get();
  *output = APIPermissionSetDataView(pointer, message_);
}
inline void PermissionSetDataView::GetManifestPermissionsDataView(
    ManifestPermissionSetDataView* output) {
  auto pointer = data_->manifest_permissions.Get();
  *output = ManifestPermissionSetDataView(pointer, message_);
}
inline void PermissionSetDataView::GetHostsDataView(
    ::extensions::mojom::URLPatternSetDataView* output) {
  auto pointer = data_->hosts.Get();
  *output = ::extensions::mojom::URLPatternSetDataView(pointer, message_);
}
inline void PermissionSetDataView::GetUserScriptHostsDataView(
    ::extensions::mojom::URLPatternSetDataView* output) {
  auto pointer = data_->user_script_hosts.Get();
  *output = ::extensions::mojom::URLPatternSetDataView(pointer, message_);
}



}  // extensions::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // EXTENSIONS_COMMON_MOJOM_PERMISSION_SET_MOJOM_SHARED_H_