// gpu/ipc/common/gpu_channel.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_GPU_CHANNEL_MOJOM_H_
#define GPU_IPC_COMMON_GPU_CHANNEL_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "gpu/ipc/common/gpu_channel.mojom-features.h"  // IWYU pragma: export
#include "gpu/ipc/common/gpu_channel.mojom-shared.h"  // IWYU pragma: export
#include "gpu/ipc/common/gpu_channel.mojom-forward.h"  // IWYU pragma: export
#include "gpu/ipc/common/capabilities.mojom.h"
#include "gpu/ipc/common/context_result.mojom.h"
#include "gpu/ipc/common/mailbox.mojom.h"
#include "gpu/ipc/common/shared_image_metadata.mojom.h"
#include "gpu/ipc/common/shared_image_pool_id.mojom.h"
#include "gpu/ipc/common/shared_image_pool_client_interface.mojom-forward.h"
#include "gpu/ipc/common/surface_handle.mojom-forward.h"
#include "gpu/ipc/common/sync_token.mojom.h"
#include "gpu/ipc/common/vulkan_ycbcr_info.mojom-forward.h"
#include "mojo/public/mojom/base/shared_memory.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "services/viz/public/mojom/compositing/shared_image_format.mojom.h"
#include "skia/public/mojom/image_info.mojom-forward.h"
#include "skia/public/mojom/surface_origin.mojom-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/mojom/buffer_types.mojom.h"
#include "ui/gfx/mojom/color_space.mojom.h"
#include "ui/gfx/mojom/gpu_fence_handle.mojom.h"
#include "ui/gfx/mojom/native_handle_types.mojom-forward.h"
#include "ui/gfx/mojom/presentation_feedback.mojom-forward.h"
#include "ui/gl/mojom/gpu_preference.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "gpu/ipc/common/command_buffer_mojom_traits.h"
#include "gpu/ipc/common/context_creation_attribs_mojom_traits.h"
#include "gpu/ipc/common/gpu_param_traits_macros.h"
#include "gpu/ipc/common/scheduling_priority_mojom_traits.h"
#include "gpu/gpu_export.h"




namespace gpu::mojom {

class GpuChannelProxy;

template <typename ImplRefTraits>
class GpuChannelStub;

class GpuChannelRequestValidator;
class GpuChannelResponseValidator;


class GPU_EXPORT GpuChannel
    : public GpuChannelInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "gpu.mojom.GpuChannel";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    209717126, 
    465930639, 
    1146887016, 
    1244758200, 
    1546211848, 
    1778928123, 
    2009110536, 
    2041296909
  };
  static constexpr bool HasUninterruptableMethods_ = true;

  using Base_ = GpuChannelInterfaceBase;
  using Proxy_ = GpuChannelProxy;

  template <typename ImplRefTraits>
  using Stub_ = GpuChannelStub<ImplRefTraits>;

  using RequestValidator_ = GpuChannelRequestValidator;
  using ResponseValidator_ = GpuChannelResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCrashForTestingMinVersion = 0,
    kTerminateForTestingMinVersion = 0,
    kGetChannelTokenMinVersion = 0,
    kFlushMinVersion = 0,
    kGetSharedMemoryForFlushIdMinVersion = 0,
    kCreateCommandBufferMinVersion = 0,
    kDestroyCommandBufferMinVersion = 0,
    kScheduleImageDecodeMinVersion = 0,
    kFlushDeferredRequestsMinVersion = 0,
    kCreateGpuMemoryBufferMinVersion = 0,
    kWaitForTokenInRangeMinVersion = 0,
    kWaitForGetOffsetInRangeMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CrashForTesting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TerminateForTesting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetChannelToken_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Flush_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetSharedMemoryForFlushId_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateCommandBuffer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DestroyCommandBuffer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ScheduleImageDecode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FlushDeferredRequests_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateGpuMemoryBuffer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WaitForTokenInRange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WaitForGetOffsetInRange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~GpuChannel() = default;

  virtual void CrashForTesting() = 0;

  virtual void TerminateForTesting() = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetChannelToken(::base::UnguessableToken* out_token);
  using GetChannelTokenCallback = base::OnceCallback<void(const ::base::UnguessableToken&)>;
  using GetChannelTokenMojoCallback = base::OnceCallback<void(const ::base::UnguessableToken&)>;

  virtual void GetChannelToken(GetChannelTokenCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool Flush();
  using FlushCallback = base::OnceCallback<void()>;
  using FlushMojoCallback = base::OnceCallback<void()>;

  virtual void Flush(FlushCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetSharedMemoryForFlushId(::base::ReadOnlySharedMemoryRegion* out_version_buffer);
  using GetSharedMemoryForFlushIdCallback = base::OnceCallback<void(::base::ReadOnlySharedMemoryRegion)>;
  using GetSharedMemoryForFlushIdMojoCallback = base::OnceCallback<void(::base::ReadOnlySharedMemoryRegion)>;

  virtual void GetSharedMemoryForFlushId(GetSharedMemoryForFlushIdCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool CreateCommandBuffer(CreateCommandBufferParamsPtr params, int32_t routing_id, ::base::UnsafeSharedMemoryRegion shared_state, ::mojo::PendingAssociatedReceiver<CommandBuffer> receiver, ::mojo::PendingAssociatedRemote<CommandBufferClient> client, ::gpu::ContextResult* out_result, ::gpu::Capabilities* out_capabilties, ::gpu::GLCapabilities* out_gl_capabilities);
  using CreateCommandBufferCallback = base::OnceCallback<void(::gpu::ContextResult, const ::gpu::Capabilities&, const ::gpu::GLCapabilities&)>;
  using CreateCommandBufferMojoCallback = base::OnceCallback<void(::gpu::ContextResult, const ::gpu::Capabilities&, const ::gpu::GLCapabilities&)>;

  virtual void CreateCommandBuffer(CreateCommandBufferParamsPtr params, int32_t routing_id, ::base::UnsafeSharedMemoryRegion shared_state, ::mojo::PendingAssociatedReceiver<CommandBuffer> receiver, ::mojo::PendingAssociatedRemote<CommandBufferClient> client, CreateCommandBufferCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool DestroyCommandBuffer(int32_t routing_id);
  using DestroyCommandBufferCallback = base::OnceCallback<void()>;
  using DestroyCommandBufferMojoCallback = base::OnceCallback<void()>;

  virtual void DestroyCommandBuffer(int32_t routing_id, DestroyCommandBufferCallback callback) = 0;

  virtual void ScheduleImageDecode(ScheduleImageDecodeParamsPtr params, uint64_t decode_release_count) = 0;

  virtual void FlushDeferredRequests(std::vector<DeferredRequestPtr> requests, uint32_t flushed_deferred_message_id) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool CreateGpuMemoryBuffer(const ::gfx::Size& size, const ::viz::SharedImageFormat& format, ::gfx::BufferUsage buffer_usage, ::gfx::GpuMemoryBufferHandle* out_buffer_handle);
  using CreateGpuMemoryBufferCallback = base::OnceCallback<void(::gfx::GpuMemoryBufferHandle)>;
  using CreateGpuMemoryBufferMojoCallback = base::OnceCallback<void(::gfx::GpuMemoryBufferHandle)>;

  virtual void CreateGpuMemoryBuffer(const ::gfx::Size& size, const ::viz::SharedImageFormat& format, ::gfx::BufferUsage buffer_usage, CreateGpuMemoryBufferCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool WaitForTokenInRange(int32_t routing_id, int32_t start, int32_t end, ::gpu::CommandBuffer::State* out_state);
  using WaitForTokenInRangeCallback = base::OnceCallback<void(const ::gpu::CommandBuffer::State&)>;
  using WaitForTokenInRangeMojoCallback = base::OnceCallback<void(const ::gpu::CommandBuffer::State&)>;

  virtual void WaitForTokenInRange(int32_t routing_id, int32_t start, int32_t end, WaitForTokenInRangeCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool WaitForGetOffsetInRange(int32_t routing_id, uint32_t set_get_buffer_count, int32_t start, int32_t end, ::gpu::CommandBuffer::State* out_state);
  using WaitForGetOffsetInRangeCallback = base::OnceCallback<void(const ::gpu::CommandBuffer::State&)>;
  using WaitForGetOffsetInRangeMojoCallback = base::OnceCallback<void(const ::gpu::CommandBuffer::State&)>;

  virtual void WaitForGetOffsetInRange(int32_t routing_id, uint32_t set_get_buffer_count, int32_t start, int32_t end, WaitForGetOffsetInRangeCallback callback) = 0;
};

class CommandBufferProxy;

template <typename ImplRefTraits>
class CommandBufferStub;

class CommandBufferRequestValidator;
class CommandBufferResponseValidator;


class GPU_EXPORT CommandBuffer
    : public CommandBufferInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "gpu.mojom.CommandBuffer";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CommandBufferInterfaceBase;
  using Proxy_ = CommandBufferProxy;

  template <typename ImplRefTraits>
  using Stub_ = CommandBufferStub<ImplRefTraits>;

  using RequestValidator_ = CommandBufferRequestValidator;
  using ResponseValidator_ = CommandBufferResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetGetBufferMinVersion = 0,
    kRegisterTransferBufferMinVersion = 0,
    kCreateGpuFenceFromHandleMinVersion = 0,
    kGetGpuFenceHandleMinVersion = 0,
    kSignalSyncTokenMinVersion = 0,
    kSignalQueryMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetGetBuffer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RegisterTransferBuffer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateGpuFenceFromHandle_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetGpuFenceHandle_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SignalSyncToken_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SignalQuery_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CommandBuffer() = default;

  virtual void SetGetBuffer(int32_t shm_id) = 0;

  virtual void RegisterTransferBuffer(int32_t id, ::base::UnsafeSharedMemoryRegion buffer) = 0;

  virtual void CreateGpuFenceFromHandle(uint32_t gpu_fence_id, ::gfx::GpuFenceHandle fence_handle) = 0;

  using GetGpuFenceHandleCallback = base::OnceCallback<void(::gfx::GpuFenceHandle)>;
  using GetGpuFenceHandleMojoCallback = base::OnceCallback<void(::gfx::GpuFenceHandle)>;

  virtual void GetGpuFenceHandle(uint32_t id, GetGpuFenceHandleCallback callback) = 0;

  virtual void SignalSyncToken(const ::gpu::SyncToken& sync_token, uint32_t signal_id) = 0;

  virtual void SignalQuery(uint32_t query, uint32_t signal_id) = 0;
};

class CommandBufferClientProxy;

template <typename ImplRefTraits>
class CommandBufferClientStub;

class CommandBufferClientRequestValidator;


class GPU_EXPORT CommandBufferClient
    : public CommandBufferClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "gpu.mojom.CommandBufferClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CommandBufferClientInterfaceBase;
  using Proxy_ = CommandBufferClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = CommandBufferClientStub<ImplRefTraits>;

  using RequestValidator_ = CommandBufferClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnConsoleMessageMinVersion = 0,
    kOnGpuSwitchedMinVersion = 0,
    kOnDestroyedMinVersion = 0,
    kOnReturnDataMinVersion = 0,
    kOnSignalAckMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnConsoleMessage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnGpuSwitched_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnDestroyed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnReturnData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnSignalAck_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CommandBufferClient() = default;

  virtual void OnConsoleMessage(const std::string& message) = 0;

  virtual void OnGpuSwitched(::gl::GpuPreference active_gpu_heuristic) = 0;

  virtual void OnDestroyed(::gpu::error::ContextLostReason reason, ::gpu::error::Error error) = 0;

  virtual void OnReturnData(const std::vector<uint8_t>& data) = 0;

  virtual void OnSignalAck(uint32_t signal_id, const ::gpu::CommandBuffer::State& state) = 0;
};



class GPU_EXPORT GpuChannelProxy
    : public GpuChannel {
 public:
  using InterfaceType = GpuChannel;

  explicit GpuChannelProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CrashForTesting() final;
  
  void TerminateForTesting() final;
  
  bool GetChannelToken(::base::UnguessableToken* out_token) final;
  
  void GetChannelToken(GetChannelTokenCallback callback) final;
  
  bool Flush() final;
  
  void Flush(FlushCallback callback) final;
  
  bool GetSharedMemoryForFlushId(::base::ReadOnlySharedMemoryRegion* out_version_buffer) final;
  
  void GetSharedMemoryForFlushId(GetSharedMemoryForFlushIdCallback callback) final;
  
  bool CreateCommandBuffer(CreateCommandBufferParamsPtr params, int32_t routing_id, ::base::UnsafeSharedMemoryRegion shared_state, ::mojo::PendingAssociatedReceiver<CommandBuffer> receiver, ::mojo::PendingAssociatedRemote<CommandBufferClient> client, ::gpu::ContextResult* out_result, ::gpu::Capabilities* out_capabilties, ::gpu::GLCapabilities* out_gl_capabilities) final;
  
  void CreateCommandBuffer(CreateCommandBufferParamsPtr params, int32_t routing_id, ::base::UnsafeSharedMemoryRegion shared_state, ::mojo::PendingAssociatedReceiver<CommandBuffer> receiver, ::mojo::PendingAssociatedRemote<CommandBufferClient> client, CreateCommandBufferCallback callback) final;
  
  bool DestroyCommandBuffer(int32_t routing_id) final;
  
  void DestroyCommandBuffer(int32_t routing_id, DestroyCommandBufferCallback callback) final;
  
  void ScheduleImageDecode(ScheduleImageDecodeParamsPtr params, uint64_t decode_release_count) final;
  
  void FlushDeferredRequests(std::vector<DeferredRequestPtr> requests, uint32_t flushed_deferred_message_id) final;
  
  bool CreateGpuMemoryBuffer(const ::gfx::Size& size, const ::viz::SharedImageFormat& format, ::gfx::BufferUsage buffer_usage, ::gfx::GpuMemoryBufferHandle* out_buffer_handle) final;
  
  void CreateGpuMemoryBuffer(const ::gfx::Size& size, const ::viz::SharedImageFormat& format, ::gfx::BufferUsage buffer_usage, CreateGpuMemoryBufferCallback callback) final;
  
  bool WaitForTokenInRange(int32_t routing_id, int32_t start, int32_t end, ::gpu::CommandBuffer::State* out_state) final;
  
  void WaitForTokenInRange(int32_t routing_id, int32_t start, int32_t end, WaitForTokenInRangeCallback callback) final;
  
  bool WaitForGetOffsetInRange(int32_t routing_id, uint32_t set_get_buffer_count, int32_t start, int32_t end, ::gpu::CommandBuffer::State* out_state) final;
  
  void WaitForGetOffsetInRange(int32_t routing_id, uint32_t set_get_buffer_count, int32_t start, int32_t end, WaitForGetOffsetInRangeCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class GPU_EXPORT CommandBufferProxy
    : public CommandBuffer {
 public:
  using InterfaceType = CommandBuffer;

  explicit CommandBufferProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetGetBuffer(int32_t shm_id) final;
  
  void RegisterTransferBuffer(int32_t id, ::base::UnsafeSharedMemoryRegion buffer) final;
  
  void CreateGpuFenceFromHandle(uint32_t gpu_fence_id, ::gfx::GpuFenceHandle fence_handle) final;
  
  void GetGpuFenceHandle(uint32_t id, GetGpuFenceHandleCallback callback) final;
  
  void SignalSyncToken(const ::gpu::SyncToken& sync_token, uint32_t signal_id) final;
  
  void SignalQuery(uint32_t query, uint32_t signal_id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class GPU_EXPORT CommandBufferClientProxy
    : public CommandBufferClient {
 public:
  using InterfaceType = CommandBufferClient;

  explicit CommandBufferClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnConsoleMessage(const std::string& message) final;
  
  void OnGpuSwitched(::gl::GpuPreference active_gpu_heuristic) final;
  
  void OnDestroyed(::gpu::error::ContextLostReason reason, ::gpu::error::Error error) final;
  
  void OnReturnData(const std::vector<uint8_t>& data) final;
  
  void OnSignalAck(uint32_t signal_id, const ::gpu::CommandBuffer::State& state) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class GPU_EXPORT GpuChannelStubDispatch {
 public:
  static bool Accept(GpuChannel* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      GpuChannel* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<GpuChannel>>
class GpuChannelStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  GpuChannelStub() = default;
  ~GpuChannelStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GpuChannelStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GpuChannelStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class GPU_EXPORT CommandBufferStubDispatch {
 public:
  static bool Accept(CommandBuffer* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CommandBuffer* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CommandBuffer>>
class CommandBufferStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CommandBufferStub() = default;
  ~CommandBufferStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CommandBufferStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CommandBufferStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class GPU_EXPORT CommandBufferClientStubDispatch {
 public:
  static bool Accept(CommandBufferClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CommandBufferClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CommandBufferClient>>
class CommandBufferClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CommandBufferClientStub() = default;
  ~CommandBufferClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CommandBufferClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CommandBufferClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class GPU_EXPORT GpuChannelRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class GPU_EXPORT CommandBufferRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class GPU_EXPORT CommandBufferClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class GPU_EXPORT GpuChannelResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class GPU_EXPORT CommandBufferResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






















class GPU_EXPORT DeferredRequestParams {
 public:
  using DataView = DeferredRequestParamsDataView;
  using Data_ = internal::DeferredRequestParams_Data;
  using Tag = Data_::DeferredRequestParams_Tag;

  template <typename... Args>
  static DeferredRequestParamsPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |command_buffer_request|.
  static DeferredRequestParamsPtr NewCommandBufferRequest(
      DeferredCommandBufferRequestPtr value);
  // Construct an instance holding |shared_image_request|.
  static DeferredRequestParamsPtr NewSharedImageRequest(
      DeferredSharedImageRequestPtr value);

  template <typename U>
  static DeferredRequestParamsPtr From(const U& u) {
    return mojo::TypeConverter<DeferredRequestParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DeferredRequestParams>::Convert(*this);
  }
  ~DeferredRequestParams();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  DeferredRequestParams(const DeferredRequestParams& other) = delete;
  DeferredRequestParams& operator=(const DeferredRequestParams& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = DeferredRequestParamsPtr>
  DeferredRequestParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, DeferredRequestParams>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, DeferredRequestParams>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_command_buffer_request() const { return tag_ == Tag::kCommandBufferRequest; }
  const DeferredCommandBufferRequestPtr& get_command_buffer_request() const {
    CHECK(tag_ == Tag::kCommandBufferRequest);
    return data_.command_buffer_request;
  }
  DeferredCommandBufferRequestPtr& get_command_buffer_request() {
    CHECK(tag_ == Tag::kCommandBufferRequest);
    return data_.command_buffer_request;
  }
  void set_command_buffer_request(DeferredCommandBufferRequestPtr command_buffer_request);

  bool is_shared_image_request() const { return tag_ == Tag::kSharedImageRequest; }
  const DeferredSharedImageRequestPtr& get_shared_image_request() const {
    CHECK(tag_ == Tag::kSharedImageRequest);
    return data_.shared_image_request;
  }
  DeferredSharedImageRequestPtr& get_shared_image_request() {
    CHECK(tag_ == Tag::kSharedImageRequest);
    return data_.shared_image_request;
  }
  void set_shared_image_request(DeferredSharedImageRequestPtr shared_image_request);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DeferredRequestParams::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<DeferredRequestParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kCommandBufferRequest)>,
        DeferredCommandBufferRequestPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSharedImageRequest)>,
        DeferredSharedImageRequestPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    DeferredCommandBufferRequestPtr command_buffer_request;
    DeferredSharedImageRequestPtr shared_image_request;
  };

  DeferredRequestParams(
      std::in_place_index_t<static_cast<size_t>(Tag::kCommandBufferRequest)>,
      DeferredCommandBufferRequestPtr value);
  DeferredRequestParams(
      std::in_place_index_t<static_cast<size_t>(Tag::kSharedImageRequest)>,
      DeferredSharedImageRequestPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class GPU_EXPORT DeferredCommandBufferRequestParams {
 public:
  using DataView = DeferredCommandBufferRequestParamsDataView;
  using Data_ = internal::DeferredCommandBufferRequestParams_Data;
  using Tag = Data_::DeferredCommandBufferRequestParams_Tag;

  template <typename... Args>
  static DeferredCommandBufferRequestParamsPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |async_flush|.
  static DeferredCommandBufferRequestParamsPtr NewAsyncFlush(
      AsyncFlushParamsPtr value);
  // Construct an instance holding |destroy_transfer_buffer|.
  static DeferredCommandBufferRequestParamsPtr NewDestroyTransferBuffer(
      int32_t value);

  template <typename U>
  static DeferredCommandBufferRequestParamsPtr From(const U& u) {
    return mojo::TypeConverter<DeferredCommandBufferRequestParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DeferredCommandBufferRequestParams>::Convert(*this);
  }
  ~DeferredCommandBufferRequestParams();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  DeferredCommandBufferRequestParams(const DeferredCommandBufferRequestParams& other) = delete;
  DeferredCommandBufferRequestParams& operator=(const DeferredCommandBufferRequestParams& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = DeferredCommandBufferRequestParamsPtr>
  DeferredCommandBufferRequestParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, DeferredCommandBufferRequestParams>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, DeferredCommandBufferRequestParams>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_async_flush() const { return tag_ == Tag::kAsyncFlush; }
  const AsyncFlushParamsPtr& get_async_flush() const {
    CHECK(tag_ == Tag::kAsyncFlush);
    return data_.async_flush;
  }
  AsyncFlushParamsPtr& get_async_flush() {
    CHECK(tag_ == Tag::kAsyncFlush);
    return data_.async_flush;
  }
  void set_async_flush(AsyncFlushParamsPtr async_flush);

  bool is_destroy_transfer_buffer() const { return tag_ == Tag::kDestroyTransferBuffer; }
  int32_t get_destroy_transfer_buffer() const {
    CHECK(tag_ == Tag::kDestroyTransferBuffer);
    return data_.destroy_transfer_buffer;
  }
  void set_destroy_transfer_buffer(int32_t destroy_transfer_buffer);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DeferredCommandBufferRequestParams::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<DeferredCommandBufferRequestParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kAsyncFlush)>,
        AsyncFlushParamsPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kDestroyTransferBuffer)>,
        int32_t value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    AsyncFlushParamsPtr async_flush;
    int32_t destroy_transfer_buffer;
  };

  DeferredCommandBufferRequestParams(
      std::in_place_index_t<static_cast<size_t>(Tag::kAsyncFlush)>,
      AsyncFlushParamsPtr value);
  DeferredCommandBufferRequestParams(
      std::in_place_index_t<static_cast<size_t>(Tag::kDestroyTransferBuffer)>,
      int32_t value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class GPU_EXPORT DeferredSharedImageRequest {
 public:
  using DataView = DeferredSharedImageRequestDataView;
  using Data_ = internal::DeferredSharedImageRequest_Data;
  using Tag = Data_::DeferredSharedImageRequest_Tag;

  template <typename... Args>
  static DeferredSharedImageRequestPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |nop|.
  static DeferredSharedImageRequestPtr NewNop(
      uint8_t value);
  // Construct an instance holding |create_shared_image|.
  static DeferredSharedImageRequestPtr NewCreateSharedImage(
      CreateSharedImageParamsPtr value);
  // Construct an instance holding |create_shared_image_with_data|.
  static DeferredSharedImageRequestPtr NewCreateSharedImageWithData(
      CreateSharedImageWithDataParamsPtr value);
  // Construct an instance holding |create_shared_image_with_buffer|.
  static DeferredSharedImageRequestPtr NewCreateSharedImageWithBuffer(
      CreateSharedImageWithBufferParamsPtr value);
  // Construct an instance holding |register_upload_buffer|.
  static DeferredSharedImageRequestPtr NewRegisterUploadBuffer(
      ::base::ReadOnlySharedMemoryRegion value);
  // Construct an instance holding |update_shared_image|.
  static DeferredSharedImageRequestPtr NewUpdateSharedImage(
      UpdateSharedImageParamsPtr value);
  // Construct an instance holding |copy_to_gpu_memory_buffer|.
  static DeferredSharedImageRequestPtr NewCopyToGpuMemoryBuffer(
      CopyToGpuMemoryBufferParamsPtr value);
  // Construct an instance holding |destroy_shared_image|.
  static DeferredSharedImageRequestPtr NewDestroySharedImage(
      const ::gpu::Mailbox& value);
  // Construct an instance holding |add_reference_to_shared_image|.
  static DeferredSharedImageRequestPtr NewAddReferenceToSharedImage(
      AddReferenceToSharedImageParamsPtr value);
  // Construct an instance holding |create_shared_image_pool|.
  static DeferredSharedImageRequestPtr NewCreateSharedImagePool(
      CreateSharedImagePoolParamsPtr value);
  // Construct an instance holding |destroy_shared_image_pool|.
  static DeferredSharedImageRequestPtr NewDestroySharedImagePool(
      DestroySharedImagePoolParamsPtr value);

  template <typename U>
  static DeferredSharedImageRequestPtr From(const U& u) {
    return mojo::TypeConverter<DeferredSharedImageRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DeferredSharedImageRequest>::Convert(*this);
  }
  ~DeferredSharedImageRequest();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  DeferredSharedImageRequest(const DeferredSharedImageRequest& other) = delete;
  DeferredSharedImageRequest& operator=(const DeferredSharedImageRequest& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = DeferredSharedImageRequestPtr>
  DeferredSharedImageRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, DeferredSharedImageRequest>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, DeferredSharedImageRequest>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_nop() const { return tag_ == Tag::kNop; }
  uint8_t get_nop() const {
    CHECK(tag_ == Tag::kNop);
    return data_.nop;
  }
  void set_nop(uint8_t nop);

  bool is_create_shared_image() const { return tag_ == Tag::kCreateSharedImage; }
  const CreateSharedImageParamsPtr& get_create_shared_image() const {
    CHECK(tag_ == Tag::kCreateSharedImage);
    return data_.create_shared_image;
  }
  CreateSharedImageParamsPtr& get_create_shared_image() {
    CHECK(tag_ == Tag::kCreateSharedImage);
    return data_.create_shared_image;
  }
  void set_create_shared_image(CreateSharedImageParamsPtr create_shared_image);

  bool is_create_shared_image_with_data() const { return tag_ == Tag::kCreateSharedImageWithData; }
  const CreateSharedImageWithDataParamsPtr& get_create_shared_image_with_data() const {
    CHECK(tag_ == Tag::kCreateSharedImageWithData);
    return data_.create_shared_image_with_data;
  }
  CreateSharedImageWithDataParamsPtr& get_create_shared_image_with_data() {
    CHECK(tag_ == Tag::kCreateSharedImageWithData);
    return data_.create_shared_image_with_data;
  }
  void set_create_shared_image_with_data(CreateSharedImageWithDataParamsPtr create_shared_image_with_data);

  bool is_create_shared_image_with_buffer() const { return tag_ == Tag::kCreateSharedImageWithBuffer; }
  const CreateSharedImageWithBufferParamsPtr& get_create_shared_image_with_buffer() const {
    CHECK(tag_ == Tag::kCreateSharedImageWithBuffer);
    return data_.create_shared_image_with_buffer;
  }
  CreateSharedImageWithBufferParamsPtr& get_create_shared_image_with_buffer() {
    CHECK(tag_ == Tag::kCreateSharedImageWithBuffer);
    return data_.create_shared_image_with_buffer;
  }
  void set_create_shared_image_with_buffer(CreateSharedImageWithBufferParamsPtr create_shared_image_with_buffer);

  bool is_register_upload_buffer() const { return tag_ == Tag::kRegisterUploadBuffer; }
  const ::base::ReadOnlySharedMemoryRegion& get_register_upload_buffer() const {
    CHECK(tag_ == Tag::kRegisterUploadBuffer);
    return data_.register_upload_buffer;
  }
  ::base::ReadOnlySharedMemoryRegion& get_register_upload_buffer() {
    CHECK(tag_ == Tag::kRegisterUploadBuffer);
    return data_.register_upload_buffer;
  }
  void set_register_upload_buffer(::base::ReadOnlySharedMemoryRegion register_upload_buffer);

  bool is_update_shared_image() const { return tag_ == Tag::kUpdateSharedImage; }
  const UpdateSharedImageParamsPtr& get_update_shared_image() const {
    CHECK(tag_ == Tag::kUpdateSharedImage);
    return data_.update_shared_image;
  }
  UpdateSharedImageParamsPtr& get_update_shared_image() {
    CHECK(tag_ == Tag::kUpdateSharedImage);
    return data_.update_shared_image;
  }
  void set_update_shared_image(UpdateSharedImageParamsPtr update_shared_image);

  bool is_copy_to_gpu_memory_buffer() const { return tag_ == Tag::kCopyToGpuMemoryBuffer; }
  const CopyToGpuMemoryBufferParamsPtr& get_copy_to_gpu_memory_buffer() const {
    CHECK(tag_ == Tag::kCopyToGpuMemoryBuffer);
    return data_.copy_to_gpu_memory_buffer;
  }
  CopyToGpuMemoryBufferParamsPtr& get_copy_to_gpu_memory_buffer() {
    CHECK(tag_ == Tag::kCopyToGpuMemoryBuffer);
    return data_.copy_to_gpu_memory_buffer;
  }
  void set_copy_to_gpu_memory_buffer(CopyToGpuMemoryBufferParamsPtr copy_to_gpu_memory_buffer);

  bool is_destroy_shared_image() const { return tag_ == Tag::kDestroySharedImage; }
  const ::gpu::Mailbox& get_destroy_shared_image() const {
    CHECK(tag_ == Tag::kDestroySharedImage);
    return data_.destroy_shared_image;
  }
  ::gpu::Mailbox& get_destroy_shared_image() {
    CHECK(tag_ == Tag::kDestroySharedImage);
    return data_.destroy_shared_image;
  }
  void set_destroy_shared_image(const ::gpu::Mailbox& destroy_shared_image);

  bool is_add_reference_to_shared_image() const { return tag_ == Tag::kAddReferenceToSharedImage; }
  const AddReferenceToSharedImageParamsPtr& get_add_reference_to_shared_image() const {
    CHECK(tag_ == Tag::kAddReferenceToSharedImage);
    return data_.add_reference_to_shared_image;
  }
  AddReferenceToSharedImageParamsPtr& get_add_reference_to_shared_image() {
    CHECK(tag_ == Tag::kAddReferenceToSharedImage);
    return data_.add_reference_to_shared_image;
  }
  void set_add_reference_to_shared_image(AddReferenceToSharedImageParamsPtr add_reference_to_shared_image);

  bool is_create_shared_image_pool() const { return tag_ == Tag::kCreateSharedImagePool; }
  const CreateSharedImagePoolParamsPtr& get_create_shared_image_pool() const {
    CHECK(tag_ == Tag::kCreateSharedImagePool);
    return data_.create_shared_image_pool;
  }
  CreateSharedImagePoolParamsPtr& get_create_shared_image_pool() {
    CHECK(tag_ == Tag::kCreateSharedImagePool);
    return data_.create_shared_image_pool;
  }
  void set_create_shared_image_pool(CreateSharedImagePoolParamsPtr create_shared_image_pool);

  bool is_destroy_shared_image_pool() const { return tag_ == Tag::kDestroySharedImagePool; }
  const DestroySharedImagePoolParamsPtr& get_destroy_shared_image_pool() const {
    CHECK(tag_ == Tag::kDestroySharedImagePool);
    return data_.destroy_shared_image_pool;
  }
  DestroySharedImagePoolParamsPtr& get_destroy_shared_image_pool() {
    CHECK(tag_ == Tag::kDestroySharedImagePool);
    return data_.destroy_shared_image_pool;
  }
  void set_destroy_shared_image_pool(DestroySharedImagePoolParamsPtr destroy_shared_image_pool);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DeferredSharedImageRequest::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<DeferredSharedImageRequest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kNop)>,
        uint8_t value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kCreateSharedImage)>,
        CreateSharedImageParamsPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kCreateSharedImageWithData)>,
        CreateSharedImageWithDataParamsPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kCreateSharedImageWithBuffer)>,
        CreateSharedImageWithBufferParamsPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kRegisterUploadBuffer)>,
        ::base::ReadOnlySharedMemoryRegion value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kUpdateSharedImage)>,
        UpdateSharedImageParamsPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kCopyToGpuMemoryBuffer)>,
        CopyToGpuMemoryBufferParamsPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kDestroySharedImage)>,
        const ::gpu::Mailbox& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kAddReferenceToSharedImage)>,
        AddReferenceToSharedImageParamsPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kCreateSharedImagePool)>,
        CreateSharedImagePoolParamsPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kDestroySharedImagePool)>,
        DestroySharedImagePoolParamsPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    uint8_t nop;
    CreateSharedImageParamsPtr create_shared_image;
    CreateSharedImageWithDataParamsPtr create_shared_image_with_data;
    CreateSharedImageWithBufferParamsPtr create_shared_image_with_buffer;
    ::base::ReadOnlySharedMemoryRegion register_upload_buffer;
    UpdateSharedImageParamsPtr update_shared_image;
    CopyToGpuMemoryBufferParamsPtr copy_to_gpu_memory_buffer;
    ::gpu::Mailbox destroy_shared_image;
    AddReferenceToSharedImageParamsPtr add_reference_to_shared_image;
    CreateSharedImagePoolParamsPtr create_shared_image_pool;
    DestroySharedImagePoolParamsPtr destroy_shared_image_pool;
  };

  DeferredSharedImageRequest(
      std::in_place_index_t<static_cast<size_t>(Tag::kNop)>,
      uint8_t value);
  DeferredSharedImageRequest(
      std::in_place_index_t<static_cast<size_t>(Tag::kCreateSharedImage)>,
      CreateSharedImageParamsPtr value);
  DeferredSharedImageRequest(
      std::in_place_index_t<static_cast<size_t>(Tag::kCreateSharedImageWithData)>,
      CreateSharedImageWithDataParamsPtr value);
  DeferredSharedImageRequest(
      std::in_place_index_t<static_cast<size_t>(Tag::kCreateSharedImageWithBuffer)>,
      CreateSharedImageWithBufferParamsPtr value);
  DeferredSharedImageRequest(
      std::in_place_index_t<static_cast<size_t>(Tag::kRegisterUploadBuffer)>,
      ::base::ReadOnlySharedMemoryRegion value);
  DeferredSharedImageRequest(
      std::in_place_index_t<static_cast<size_t>(Tag::kUpdateSharedImage)>,
      UpdateSharedImageParamsPtr value);
  DeferredSharedImageRequest(
      std::in_place_index_t<static_cast<size_t>(Tag::kCopyToGpuMemoryBuffer)>,
      CopyToGpuMemoryBufferParamsPtr value);
  DeferredSharedImageRequest(
      std::in_place_index_t<static_cast<size_t>(Tag::kDestroySharedImage)>,
      const ::gpu::Mailbox& value);
  DeferredSharedImageRequest(
      std::in_place_index_t<static_cast<size_t>(Tag::kAddReferenceToSharedImage)>,
      AddReferenceToSharedImageParamsPtr value);
  DeferredSharedImageRequest(
      std::in_place_index_t<static_cast<size_t>(Tag::kCreateSharedImagePool)>,
      CreateSharedImagePoolParamsPtr value);
  DeferredSharedImageRequest(
      std::in_place_index_t<static_cast<size_t>(Tag::kDestroySharedImagePool)>,
      DestroySharedImagePoolParamsPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class GPU_EXPORT ContextCreationAttribs {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ContextCreationAttribs, T>::value>;
  using DataView = ContextCreationAttribsDataView;
  using Data_ = internal::ContextCreationAttribs_Data;

  template <typename... Args>
  static ContextCreationAttribsPtr New(Args&&... args) {
    return ContextCreationAttribsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ContextCreationAttribsPtr From(const U& u) {
    return mojo::TypeConverter<ContextCreationAttribsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ContextCreationAttribs>::Convert(*this);
  }


  ContextCreationAttribs();

  ContextCreationAttribs(
      ::gl::GpuPreference gpu_preference,
      bool fail_if_major_perf_caveat,
      bool lose_context_when_out_of_memory,
      bool enable_gles2_interface,
      bool enable_grcontext,
      bool enable_raster_interface,
      bool enable_gpu_rasterization,
      ::gpu::ContextType context_type);


  ~ContextCreationAttribs();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ContextCreationAttribsPtr>
  ContextCreationAttribsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ContextCreationAttribs::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ContextCreationAttribs::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ContextCreationAttribs::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ContextCreationAttribs::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ContextCreationAttribs::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ContextCreationAttribs::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ContextCreationAttribs_UnserializedMessageContext<
            UserType, ContextCreationAttribs::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ContextCreationAttribs::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ContextCreationAttribs::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ContextCreationAttribs_UnserializedMessageContext<
            UserType, ContextCreationAttribs::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ContextCreationAttribs::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gl::GpuPreference gpu_preference;
  
  bool fail_if_major_perf_caveat;
  
  bool lose_context_when_out_of_memory;
  
  bool enable_gles2_interface;
  
  bool enable_grcontext;
  
  bool enable_raster_interface;
  
  bool enable_gpu_rasterization;
  
  ::gpu::ContextType context_type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ContextCreationAttribs::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ContextCreationAttribs::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ContextCreationAttribs::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ContextCreationAttribs::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class GPU_EXPORT CreateCommandBufferParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CreateCommandBufferParams, T>::value>;
  using DataView = CreateCommandBufferParamsDataView;
  using Data_ = internal::CreateCommandBufferParams_Data;

  template <typename... Args>
  static CreateCommandBufferParamsPtr New(Args&&... args) {
    return CreateCommandBufferParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CreateCommandBufferParamsPtr From(const U& u) {
    return mojo::TypeConverter<CreateCommandBufferParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CreateCommandBufferParams>::Convert(*this);
  }


  CreateCommandBufferParams();

  CreateCommandBufferParams(
      int32_t share_group_id,
      int32_t stream_id,
      ::gpu::SchedulingPriority stream_priority,
      const ::gpu::ContextCreationAttribs& attribs,
      const ::GURL& active_url,
      const std::string& label);


  ~CreateCommandBufferParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CreateCommandBufferParamsPtr>
  CreateCommandBufferParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CreateCommandBufferParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CreateCommandBufferParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CreateCommandBufferParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CreateCommandBufferParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CreateCommandBufferParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CreateCommandBufferParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CreateCommandBufferParams_UnserializedMessageContext<
            UserType, CreateCommandBufferParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CreateCommandBufferParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CreateCommandBufferParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CreateCommandBufferParams_UnserializedMessageContext<
            UserType, CreateCommandBufferParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CreateCommandBufferParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t share_group_id;
  
  int32_t stream_id;
  
  ::gpu::SchedulingPriority stream_priority;
  
  ::gpu::ContextCreationAttribs attribs;
  
  ::GURL active_url;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CreateCommandBufferParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CreateCommandBufferParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CreateCommandBufferParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CreateCommandBufferParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class GPU_EXPORT CommandBufferState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CommandBufferState, T>::value>;
  using DataView = CommandBufferStateDataView;
  using Data_ = internal::CommandBufferState_Data;

  template <typename... Args>
  static CommandBufferStatePtr New(Args&&... args) {
    return CommandBufferStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CommandBufferStatePtr From(const U& u) {
    return mojo::TypeConverter<CommandBufferStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CommandBufferState>::Convert(*this);
  }


  CommandBufferState();

  CommandBufferState(
      int32_t get_offset,
      int32_t token,
      uint64_t release_count,
      ::gpu::error::Error error,
      ::gpu::error::ContextLostReason context_lost_reason,
      uint32_t generation,
      uint32_t set_get_buffer_count);


  ~CommandBufferState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CommandBufferStatePtr>
  CommandBufferStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CommandBufferState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CommandBufferState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CommandBufferState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CommandBufferState::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CommandBufferState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CommandBufferState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CommandBufferState_UnserializedMessageContext<
            UserType, CommandBufferState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CommandBufferState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CommandBufferState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CommandBufferState_UnserializedMessageContext<
            UserType, CommandBufferState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CommandBufferState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t get_offset;
  
  int32_t token;
  
  uint64_t release_count;
  
  ::gpu::error::Error error;
  
  ::gpu::error::ContextLostReason context_lost_reason;
  
  uint32_t generation;
  
  uint32_t set_get_buffer_count;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CommandBufferState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CommandBufferState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CommandBufferState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CommandBufferState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class GPU_EXPORT ScheduleImageDecodeParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ScheduleImageDecodeParams, T>::value>;
  using DataView = ScheduleImageDecodeParamsDataView;
  using Data_ = internal::ScheduleImageDecodeParams_Data;

  template <typename... Args>
  static ScheduleImageDecodeParamsPtr New(Args&&... args) {
    return ScheduleImageDecodeParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ScheduleImageDecodeParamsPtr From(const U& u) {
    return mojo::TypeConverter<ScheduleImageDecodeParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ScheduleImageDecodeParams>::Convert(*this);
  }


  ScheduleImageDecodeParams();

  ScheduleImageDecodeParams(
      std::vector<uint8_t> encoded_data,
      const ::gfx::Size& output_size,
      int32_t raster_decoder_route_id,
      uint32_t transfer_cache_entry_id,
      int32_t discardable_handle_shm_id,
      uint32_t discardable_handle_shm_offset,
      uint64_t discardable_handle_release_count,
      const ::gfx::ColorSpace& target_color_space,
      bool needs_mips);


  ~ScheduleImageDecodeParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ScheduleImageDecodeParamsPtr>
  ScheduleImageDecodeParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ScheduleImageDecodeParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ScheduleImageDecodeParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ScheduleImageDecodeParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScheduleImageDecodeParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScheduleImageDecodeParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ScheduleImageDecodeParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ScheduleImageDecodeParams_UnserializedMessageContext<
            UserType, ScheduleImageDecodeParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ScheduleImageDecodeParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ScheduleImageDecodeParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ScheduleImageDecodeParams_UnserializedMessageContext<
            UserType, ScheduleImageDecodeParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ScheduleImageDecodeParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<uint8_t> encoded_data;
  
  ::gfx::Size output_size;
  
  int32_t raster_decoder_route_id;
  
  uint32_t transfer_cache_entry_id;
  
  int32_t discardable_handle_shm_id;
  
  uint32_t discardable_handle_shm_offset;
  
  uint64_t discardable_handle_release_count;
  
  ::gfx::ColorSpace target_color_space;
  
  bool needs_mips;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ScheduleImageDecodeParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ScheduleImageDecodeParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ScheduleImageDecodeParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ScheduleImageDecodeParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class GPU_EXPORT DeferredRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DeferredRequest, T>::value>;
  using DataView = DeferredRequestDataView;
  using Data_ = internal::DeferredRequest_Data;

  template <typename... Args>
  static DeferredRequestPtr New(Args&&... args) {
    return DeferredRequestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DeferredRequestPtr From(const U& u) {
    return mojo::TypeConverter<DeferredRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DeferredRequest>::Convert(*this);
  }


  DeferredRequest();

  DeferredRequest(
      DeferredRequestParamsPtr params,
      std::vector<::gpu::SyncToken> sync_token_fences,
      uint64_t release_count);

DeferredRequest(const DeferredRequest&) = delete;
DeferredRequest& operator=(const DeferredRequest&) = delete;

  ~DeferredRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DeferredRequestPtr>
  DeferredRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DeferredRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DeferredRequest::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DeferredRequest::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DeferredRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DeferredRequest_UnserializedMessageContext<
            UserType, DeferredRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DeferredRequest::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DeferredRequest::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DeferredRequest_UnserializedMessageContext<
            UserType, DeferredRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DeferredRequest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  DeferredRequestParamsPtr params;
  
  std::vector<::gpu::SyncToken> sync_token_fences;
  
  uint64_t release_count;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DeferredRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DeferredRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DeferredRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DeferredRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class GPU_EXPORT DeferredCommandBufferRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DeferredCommandBufferRequest, T>::value>;
  using DataView = DeferredCommandBufferRequestDataView;
  using Data_ = internal::DeferredCommandBufferRequest_Data;

  template <typename... Args>
  static DeferredCommandBufferRequestPtr New(Args&&... args) {
    return DeferredCommandBufferRequestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DeferredCommandBufferRequestPtr From(const U& u) {
    return mojo::TypeConverter<DeferredCommandBufferRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DeferredCommandBufferRequest>::Convert(*this);
  }


  DeferredCommandBufferRequest();

  DeferredCommandBufferRequest(
      int32_t routing_id,
      DeferredCommandBufferRequestParamsPtr params);

DeferredCommandBufferRequest(const DeferredCommandBufferRequest&) = delete;
DeferredCommandBufferRequest& operator=(const DeferredCommandBufferRequest&) = delete;

  ~DeferredCommandBufferRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DeferredCommandBufferRequestPtr>
  DeferredCommandBufferRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DeferredCommandBufferRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DeferredCommandBufferRequest::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DeferredCommandBufferRequest::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DeferredCommandBufferRequest::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DeferredCommandBufferRequest::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DeferredCommandBufferRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DeferredCommandBufferRequest_UnserializedMessageContext<
            UserType, DeferredCommandBufferRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DeferredCommandBufferRequest::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DeferredCommandBufferRequest::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DeferredCommandBufferRequest_UnserializedMessageContext<
            UserType, DeferredCommandBufferRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DeferredCommandBufferRequest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t routing_id;
  
  DeferredCommandBufferRequestParamsPtr params;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DeferredCommandBufferRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DeferredCommandBufferRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DeferredCommandBufferRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DeferredCommandBufferRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class GPU_EXPORT AsyncFlushParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AsyncFlushParams, T>::value>;
  using DataView = AsyncFlushParamsDataView;
  using Data_ = internal::AsyncFlushParams_Data;

  template <typename... Args>
  static AsyncFlushParamsPtr New(Args&&... args) {
    return AsyncFlushParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AsyncFlushParamsPtr From(const U& u) {
    return mojo::TypeConverter<AsyncFlushParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AsyncFlushParams>::Convert(*this);
  }


  AsyncFlushParams();

  AsyncFlushParams(
      int32_t put_offset,
      uint32_t flush_id,
      std::vector<::gpu::SyncToken> sync_token_fences);


  ~AsyncFlushParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AsyncFlushParamsPtr>
  AsyncFlushParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AsyncFlushParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AsyncFlushParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AsyncFlushParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AsyncFlushParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AsyncFlushParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AsyncFlushParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AsyncFlushParams_UnserializedMessageContext<
            UserType, AsyncFlushParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AsyncFlushParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AsyncFlushParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AsyncFlushParams_UnserializedMessageContext<
            UserType, AsyncFlushParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AsyncFlushParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t put_offset;
  
  uint32_t flush_id;
  
  std::vector<::gpu::SyncToken> sync_token_fences;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AsyncFlushParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AsyncFlushParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AsyncFlushParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AsyncFlushParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class GPU_EXPORT SharedImageInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SharedImageInfo, T>::value>;
  using DataView = SharedImageInfoDataView;
  using Data_ = internal::SharedImageInfo_Data;

  template <typename... Args>
  static SharedImageInfoPtr New(Args&&... args) {
    return SharedImageInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SharedImageInfoPtr From(const U& u) {
    return mojo::TypeConverter<SharedImageInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SharedImageInfo>::Convert(*this);
  }


  SharedImageInfo();

  SharedImageInfo(
      const ::gpu::SharedImageMetadata& meta,
      const std::string& debug_label);


  ~SharedImageInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SharedImageInfoPtr>
  SharedImageInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SharedImageInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SharedImageInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SharedImageInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedImageInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedImageInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SharedImageInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SharedImageInfo_UnserializedMessageContext<
            UserType, SharedImageInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SharedImageInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SharedImageInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SharedImageInfo_UnserializedMessageContext<
            UserType, SharedImageInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SharedImageInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gpu::SharedImageMetadata meta;
  
  std::string debug_label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SharedImageInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SharedImageInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SharedImageInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SharedImageInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class GPU_EXPORT CreateSharedImageParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CreateSharedImageParams, T>::value>;
  using DataView = CreateSharedImageParamsDataView;
  using Data_ = internal::CreateSharedImageParams_Data;

  template <typename... Args>
  static CreateSharedImageParamsPtr New(Args&&... args) {
    return CreateSharedImageParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CreateSharedImageParamsPtr From(const U& u) {
    return mojo::TypeConverter<CreateSharedImageParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CreateSharedImageParams>::Convert(*this);
  }


  CreateSharedImageParams();

  CreateSharedImageParams(
      const ::gpu::Mailbox& mailbox,
      SharedImageInfoPtr si_info,
      const std::optional<::gpu::SharedImagePoolId>& pool_id);

CreateSharedImageParams(const CreateSharedImageParams&) = delete;
CreateSharedImageParams& operator=(const CreateSharedImageParams&) = delete;

  ~CreateSharedImageParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CreateSharedImageParamsPtr>
  CreateSharedImageParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CreateSharedImageParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CreateSharedImageParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CreateSharedImageParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CreateSharedImageParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CreateSharedImageParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CreateSharedImageParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CreateSharedImageParams_UnserializedMessageContext<
            UserType, CreateSharedImageParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CreateSharedImageParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CreateSharedImageParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CreateSharedImageParams_UnserializedMessageContext<
            UserType, CreateSharedImageParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CreateSharedImageParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gpu::Mailbox mailbox;
  
  SharedImageInfoPtr si_info;
  
  std::optional<::gpu::SharedImagePoolId> pool_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CreateSharedImageParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CreateSharedImageParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CreateSharedImageParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CreateSharedImageParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class GPU_EXPORT CreateSharedImageWithDataParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CreateSharedImageWithDataParams, T>::value>;
  using DataView = CreateSharedImageWithDataParamsDataView;
  using Data_ = internal::CreateSharedImageWithDataParams_Data;

  template <typename... Args>
  static CreateSharedImageWithDataParamsPtr New(Args&&... args) {
    return CreateSharedImageWithDataParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CreateSharedImageWithDataParamsPtr From(const U& u) {
    return mojo::TypeConverter<CreateSharedImageWithDataParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CreateSharedImageWithDataParams>::Convert(*this);
  }


  CreateSharedImageWithDataParams();

  CreateSharedImageWithDataParams(
      const ::gpu::Mailbox& mailbox,
      SharedImageInfoPtr si_info,
      uint32_t pixel_data_offset,
      uint32_t pixel_data_size,
      bool done_with_shm);

CreateSharedImageWithDataParams(const CreateSharedImageWithDataParams&) = delete;
CreateSharedImageWithDataParams& operator=(const CreateSharedImageWithDataParams&) = delete;

  ~CreateSharedImageWithDataParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CreateSharedImageWithDataParamsPtr>
  CreateSharedImageWithDataParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CreateSharedImageWithDataParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CreateSharedImageWithDataParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CreateSharedImageWithDataParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CreateSharedImageWithDataParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CreateSharedImageWithDataParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CreateSharedImageWithDataParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CreateSharedImageWithDataParams_UnserializedMessageContext<
            UserType, CreateSharedImageWithDataParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CreateSharedImageWithDataParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CreateSharedImageWithDataParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CreateSharedImageWithDataParams_UnserializedMessageContext<
            UserType, CreateSharedImageWithDataParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CreateSharedImageWithDataParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gpu::Mailbox mailbox;
  
  SharedImageInfoPtr si_info;
  
  uint32_t pixel_data_offset;
  
  uint32_t pixel_data_size;
  
  bool done_with_shm;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CreateSharedImageWithDataParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CreateSharedImageWithDataParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CreateSharedImageWithDataParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CreateSharedImageWithDataParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class GPU_EXPORT CreateSharedImageWithBufferParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CreateSharedImageWithBufferParams, T>::value>;
  using DataView = CreateSharedImageWithBufferParamsDataView;
  using Data_ = internal::CreateSharedImageWithBufferParams_Data;

  template <typename... Args>
  static CreateSharedImageWithBufferParamsPtr New(Args&&... args) {
    return CreateSharedImageWithBufferParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CreateSharedImageWithBufferParamsPtr From(const U& u) {
    return mojo::TypeConverter<CreateSharedImageWithBufferParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CreateSharedImageWithBufferParams>::Convert(*this);
  }


  CreateSharedImageWithBufferParams();

  CreateSharedImageWithBufferParams(
      const ::gpu::Mailbox& mailbox,
      SharedImageInfoPtr si_info,
      ::gfx::GpuMemoryBufferHandle buffer_handle,
      const std::optional<::gpu::SharedImagePoolId>& pool_id);

CreateSharedImageWithBufferParams(const CreateSharedImageWithBufferParams&) = delete;
CreateSharedImageWithBufferParams& operator=(const CreateSharedImageWithBufferParams&) = delete;

  ~CreateSharedImageWithBufferParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CreateSharedImageWithBufferParamsPtr>
  CreateSharedImageWithBufferParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CreateSharedImageWithBufferParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CreateSharedImageWithBufferParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CreateSharedImageWithBufferParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CreateSharedImageWithBufferParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CreateSharedImageWithBufferParams_UnserializedMessageContext<
            UserType, CreateSharedImageWithBufferParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CreateSharedImageWithBufferParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CreateSharedImageWithBufferParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CreateSharedImageWithBufferParams_UnserializedMessageContext<
            UserType, CreateSharedImageWithBufferParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CreateSharedImageWithBufferParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gpu::Mailbox mailbox;
  
  SharedImageInfoPtr si_info;
  
  ::gfx::GpuMemoryBufferHandle buffer_handle;
  
  std::optional<::gpu::SharedImagePoolId> pool_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CreateSharedImageWithBufferParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CreateSharedImageWithBufferParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CreateSharedImageWithBufferParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CreateSharedImageWithBufferParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class GPU_EXPORT UpdateSharedImageParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UpdateSharedImageParams, T>::value>;
  using DataView = UpdateSharedImageParamsDataView;
  using Data_ = internal::UpdateSharedImageParams_Data;

  template <typename... Args>
  static UpdateSharedImageParamsPtr New(Args&&... args) {
    return UpdateSharedImageParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UpdateSharedImageParamsPtr From(const U& u) {
    return mojo::TypeConverter<UpdateSharedImageParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UpdateSharedImageParams>::Convert(*this);
  }


  UpdateSharedImageParams();

  UpdateSharedImageParams(
      const ::gpu::Mailbox& mailbox,
      ::gfx::GpuFenceHandle in_fence_handle);

UpdateSharedImageParams(const UpdateSharedImageParams&) = delete;
UpdateSharedImageParams& operator=(const UpdateSharedImageParams&) = delete;

  ~UpdateSharedImageParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UpdateSharedImageParamsPtr>
  UpdateSharedImageParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UpdateSharedImageParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UpdateSharedImageParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UpdateSharedImageParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UpdateSharedImageParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UpdateSharedImageParams_UnserializedMessageContext<
            UserType, UpdateSharedImageParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UpdateSharedImageParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UpdateSharedImageParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UpdateSharedImageParams_UnserializedMessageContext<
            UserType, UpdateSharedImageParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UpdateSharedImageParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gpu::Mailbox mailbox;
  
  ::gfx::GpuFenceHandle in_fence_handle;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UpdateSharedImageParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UpdateSharedImageParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UpdateSharedImageParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UpdateSharedImageParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class GPU_EXPORT AddReferenceToSharedImageParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AddReferenceToSharedImageParams, T>::value>;
  using DataView = AddReferenceToSharedImageParamsDataView;
  using Data_ = internal::AddReferenceToSharedImageParams_Data;

  template <typename... Args>
  static AddReferenceToSharedImageParamsPtr New(Args&&... args) {
    return AddReferenceToSharedImageParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AddReferenceToSharedImageParamsPtr From(const U& u) {
    return mojo::TypeConverter<AddReferenceToSharedImageParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AddReferenceToSharedImageParams>::Convert(*this);
  }


  AddReferenceToSharedImageParams();

  explicit AddReferenceToSharedImageParams(
      const ::gpu::Mailbox& mailbox);


  ~AddReferenceToSharedImageParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AddReferenceToSharedImageParamsPtr>
  AddReferenceToSharedImageParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AddReferenceToSharedImageParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AddReferenceToSharedImageParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AddReferenceToSharedImageParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AddReferenceToSharedImageParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AddReferenceToSharedImageParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AddReferenceToSharedImageParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AddReferenceToSharedImageParams_UnserializedMessageContext<
            UserType, AddReferenceToSharedImageParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AddReferenceToSharedImageParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AddReferenceToSharedImageParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AddReferenceToSharedImageParams_UnserializedMessageContext<
            UserType, AddReferenceToSharedImageParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AddReferenceToSharedImageParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gpu::Mailbox mailbox;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AddReferenceToSharedImageParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AddReferenceToSharedImageParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AddReferenceToSharedImageParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AddReferenceToSharedImageParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class GPU_EXPORT CopyToGpuMemoryBufferParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CopyToGpuMemoryBufferParams, T>::value>;
  using DataView = CopyToGpuMemoryBufferParamsDataView;
  using Data_ = internal::CopyToGpuMemoryBufferParams_Data;

  template <typename... Args>
  static CopyToGpuMemoryBufferParamsPtr New(Args&&... args) {
    return CopyToGpuMemoryBufferParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CopyToGpuMemoryBufferParamsPtr From(const U& u) {
    return mojo::TypeConverter<CopyToGpuMemoryBufferParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CopyToGpuMemoryBufferParams>::Convert(*this);
  }


  CopyToGpuMemoryBufferParams();

  explicit CopyToGpuMemoryBufferParams(
      const ::gpu::Mailbox& mailbox);


  ~CopyToGpuMemoryBufferParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CopyToGpuMemoryBufferParamsPtr>
  CopyToGpuMemoryBufferParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CopyToGpuMemoryBufferParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CopyToGpuMemoryBufferParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CopyToGpuMemoryBufferParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CopyToGpuMemoryBufferParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CopyToGpuMemoryBufferParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CopyToGpuMemoryBufferParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CopyToGpuMemoryBufferParams_UnserializedMessageContext<
            UserType, CopyToGpuMemoryBufferParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CopyToGpuMemoryBufferParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CopyToGpuMemoryBufferParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CopyToGpuMemoryBufferParams_UnserializedMessageContext<
            UserType, CopyToGpuMemoryBufferParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CopyToGpuMemoryBufferParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gpu::Mailbox mailbox;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CopyToGpuMemoryBufferParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CopyToGpuMemoryBufferParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CopyToGpuMemoryBufferParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CopyToGpuMemoryBufferParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class GPU_EXPORT CreateSharedImagePoolParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CreateSharedImagePoolParams, T>::value>;
  using DataView = CreateSharedImagePoolParamsDataView;
  using Data_ = internal::CreateSharedImagePoolParams_Data;

  template <typename... Args>
  static CreateSharedImagePoolParamsPtr New(Args&&... args) {
    return CreateSharedImagePoolParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CreateSharedImagePoolParamsPtr From(const U& u) {
    return mojo::TypeConverter<CreateSharedImagePoolParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CreateSharedImagePoolParams>::Convert(*this);
  }


  CreateSharedImagePoolParams();

  CreateSharedImagePoolParams(
      const ::gpu::SharedImagePoolId& pool_id,
      ::mojo::PendingRemote<::gpu::mojom::SharedImagePoolClientInterface> client_remote);

CreateSharedImagePoolParams(const CreateSharedImagePoolParams&) = delete;
CreateSharedImagePoolParams& operator=(const CreateSharedImagePoolParams&) = delete;

  ~CreateSharedImagePoolParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CreateSharedImagePoolParamsPtr>
  CreateSharedImagePoolParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CreateSharedImagePoolParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CreateSharedImagePoolParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CreateSharedImagePoolParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CreateSharedImagePoolParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CreateSharedImagePoolParams_UnserializedMessageContext<
            UserType, CreateSharedImagePoolParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CreateSharedImagePoolParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CreateSharedImagePoolParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CreateSharedImagePoolParams_UnserializedMessageContext<
            UserType, CreateSharedImagePoolParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CreateSharedImagePoolParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gpu::SharedImagePoolId pool_id;
  
  ::mojo::PendingRemote<::gpu::mojom::SharedImagePoolClientInterface> client_remote;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CreateSharedImagePoolParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CreateSharedImagePoolParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CreateSharedImagePoolParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CreateSharedImagePoolParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class GPU_EXPORT DestroySharedImagePoolParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DestroySharedImagePoolParams, T>::value>;
  using DataView = DestroySharedImagePoolParamsDataView;
  using Data_ = internal::DestroySharedImagePoolParams_Data;

  template <typename... Args>
  static DestroySharedImagePoolParamsPtr New(Args&&... args) {
    return DestroySharedImagePoolParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DestroySharedImagePoolParamsPtr From(const U& u) {
    return mojo::TypeConverter<DestroySharedImagePoolParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DestroySharedImagePoolParams>::Convert(*this);
  }


  DestroySharedImagePoolParams();

  explicit DestroySharedImagePoolParams(
      const ::gpu::SharedImagePoolId& pool_id);


  ~DestroySharedImagePoolParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DestroySharedImagePoolParamsPtr>
  DestroySharedImagePoolParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DestroySharedImagePoolParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DestroySharedImagePoolParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DestroySharedImagePoolParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DestroySharedImagePoolParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DestroySharedImagePoolParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DestroySharedImagePoolParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DestroySharedImagePoolParams_UnserializedMessageContext<
            UserType, DestroySharedImagePoolParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DestroySharedImagePoolParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DestroySharedImagePoolParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DestroySharedImagePoolParams_UnserializedMessageContext<
            UserType, DestroySharedImagePoolParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DestroySharedImagePoolParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gpu::SharedImagePoolId pool_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DestroySharedImagePoolParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DestroySharedImagePoolParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DestroySharedImagePoolParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DestroySharedImagePoolParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
DeferredRequestParamsPtr DeferredRequestParams::Clone() const {
  switch (tag_) {
    case Tag::kCommandBufferRequest:
      return NewCommandBufferRequest(
          mojo::Clone(data_.command_buffer_request));
    case Tag::kSharedImageRequest:
      return NewSharedImageRequest(
          mojo::Clone(data_.shared_image_request));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, DeferredRequestParams>::value>::type*>
bool DeferredRequestParams::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kCommandBufferRequest:
      return mojo::Equals(data_.command_buffer_request, other.data_.command_buffer_request);
    case Tag::kSharedImageRequest:
      return mojo::Equals(data_.shared_image_request, other.data_.shared_image_request);
  }

  return false;
}
template <typename UnionPtrType>
DeferredCommandBufferRequestParamsPtr DeferredCommandBufferRequestParams::Clone() const {
  switch (tag_) {
    case Tag::kAsyncFlush:
      return NewAsyncFlush(
          mojo::Clone(data_.async_flush));
    case Tag::kDestroyTransferBuffer:
      return NewDestroyTransferBuffer(
          mojo::Clone(data_.destroy_transfer_buffer));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, DeferredCommandBufferRequestParams>::value>::type*>
bool DeferredCommandBufferRequestParams::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kAsyncFlush:
      return mojo::Equals(data_.async_flush, other.data_.async_flush);
    case Tag::kDestroyTransferBuffer:
      return mojo::Equals(data_.destroy_transfer_buffer, other.data_.destroy_transfer_buffer);
  }

  return false;
}
template <typename UnionPtrType>
DeferredSharedImageRequestPtr DeferredSharedImageRequest::Clone() const {
  switch (tag_) {
    case Tag::kNop:
      return NewNop(
          mojo::Clone(data_.nop));
    case Tag::kCreateSharedImage:
      return NewCreateSharedImage(
          mojo::Clone(data_.create_shared_image));
    case Tag::kCreateSharedImageWithData:
      return NewCreateSharedImageWithData(
          mojo::Clone(data_.create_shared_image_with_data));
    case Tag::kCreateSharedImageWithBuffer:
      return NewCreateSharedImageWithBuffer(
          mojo::Clone(data_.create_shared_image_with_buffer));
    case Tag::kRegisterUploadBuffer:
      return NewRegisterUploadBuffer(
          mojo::Clone(data_.register_upload_buffer));
    case Tag::kUpdateSharedImage:
      return NewUpdateSharedImage(
          mojo::Clone(data_.update_shared_image));
    case Tag::kCopyToGpuMemoryBuffer:
      return NewCopyToGpuMemoryBuffer(
          mojo::Clone(data_.copy_to_gpu_memory_buffer));
    case Tag::kDestroySharedImage:
      return NewDestroySharedImage(
          mojo::Clone(data_.destroy_shared_image));
    case Tag::kAddReferenceToSharedImage:
      return NewAddReferenceToSharedImage(
          mojo::Clone(data_.add_reference_to_shared_image));
    case Tag::kCreateSharedImagePool:
      return NewCreateSharedImagePool(
          mojo::Clone(data_.create_shared_image_pool));
    case Tag::kDestroySharedImagePool:
      return NewDestroySharedImagePool(
          mojo::Clone(data_.destroy_shared_image_pool));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, DeferredSharedImageRequest>::value>::type*>
bool DeferredSharedImageRequest::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kNop:
      return mojo::Equals(data_.nop, other.data_.nop);
    case Tag::kCreateSharedImage:
      return mojo::Equals(data_.create_shared_image, other.data_.create_shared_image);
    case Tag::kCreateSharedImageWithData:
      return mojo::Equals(data_.create_shared_image_with_data, other.data_.create_shared_image_with_data);
    case Tag::kCreateSharedImageWithBuffer:
      return mojo::Equals(data_.create_shared_image_with_buffer, other.data_.create_shared_image_with_buffer);
    case Tag::kRegisterUploadBuffer:
      return mojo::Equals(data_.register_upload_buffer, other.data_.register_upload_buffer);
    case Tag::kUpdateSharedImage:
      return mojo::Equals(data_.update_shared_image, other.data_.update_shared_image);
    case Tag::kCopyToGpuMemoryBuffer:
      return mojo::Equals(data_.copy_to_gpu_memory_buffer, other.data_.copy_to_gpu_memory_buffer);
    case Tag::kDestroySharedImage:
      return mojo::Equals(data_.destroy_shared_image, other.data_.destroy_shared_image);
    case Tag::kAddReferenceToSharedImage:
      return mojo::Equals(data_.add_reference_to_shared_image, other.data_.add_reference_to_shared_image);
    case Tag::kCreateSharedImagePool:
      return mojo::Equals(data_.create_shared_image_pool, other.data_.create_shared_image_pool);
    case Tag::kDestroySharedImagePool:
      return mojo::Equals(data_.destroy_shared_image_pool, other.data_.destroy_shared_image_pool);
  }

  return false;
}
template <typename StructPtrType>
ContextCreationAttribsPtr ContextCreationAttribs::Clone() const {
  return New(
      mojo::Clone(gpu_preference),
      mojo::Clone(fail_if_major_perf_caveat),
      mojo::Clone(lose_context_when_out_of_memory),
      mojo::Clone(enable_gles2_interface),
      mojo::Clone(enable_grcontext),
      mojo::Clone(enable_raster_interface),
      mojo::Clone(enable_gpu_rasterization),
      mojo::Clone(context_type)
  );
}

template <typename T, ContextCreationAttribs::EnableIfSame<T>*>
bool ContextCreationAttribs::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->gpu_preference, other_struct.gpu_preference))
    return false;
  if (!mojo::Equals(this->fail_if_major_perf_caveat, other_struct.fail_if_major_perf_caveat))
    return false;
  if (!mojo::Equals(this->lose_context_when_out_of_memory, other_struct.lose_context_when_out_of_memory))
    return false;
  if (!mojo::Equals(this->enable_gles2_interface, other_struct.enable_gles2_interface))
    return false;
  if (!mojo::Equals(this->enable_grcontext, other_struct.enable_grcontext))
    return false;
  if (!mojo::Equals(this->enable_raster_interface, other_struct.enable_raster_interface))
    return false;
  if (!mojo::Equals(this->enable_gpu_rasterization, other_struct.enable_gpu_rasterization))
    return false;
  if (!mojo::Equals(this->context_type, other_struct.context_type))
    return false;
  return true;
}

template <typename T, ContextCreationAttribs::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.gpu_preference < rhs.gpu_preference)
    return true;
  if (rhs.gpu_preference < lhs.gpu_preference)
    return false;
  if (lhs.fail_if_major_perf_caveat < rhs.fail_if_major_perf_caveat)
    return true;
  if (rhs.fail_if_major_perf_caveat < lhs.fail_if_major_perf_caveat)
    return false;
  if (lhs.lose_context_when_out_of_memory < rhs.lose_context_when_out_of_memory)
    return true;
  if (rhs.lose_context_when_out_of_memory < lhs.lose_context_when_out_of_memory)
    return false;
  if (lhs.enable_gles2_interface < rhs.enable_gles2_interface)
    return true;
  if (rhs.enable_gles2_interface < lhs.enable_gles2_interface)
    return false;
  if (lhs.enable_grcontext < rhs.enable_grcontext)
    return true;
  if (rhs.enable_grcontext < lhs.enable_grcontext)
    return false;
  if (lhs.enable_raster_interface < rhs.enable_raster_interface)
    return true;
  if (rhs.enable_raster_interface < lhs.enable_raster_interface)
    return false;
  if (lhs.enable_gpu_rasterization < rhs.enable_gpu_rasterization)
    return true;
  if (rhs.enable_gpu_rasterization < lhs.enable_gpu_rasterization)
    return false;
  if (lhs.context_type < rhs.context_type)
    return true;
  if (rhs.context_type < lhs.context_type)
    return false;
  return false;
}
template <typename StructPtrType>
CreateCommandBufferParamsPtr CreateCommandBufferParams::Clone() const {
  return New(
      mojo::Clone(share_group_id),
      mojo::Clone(stream_id),
      mojo::Clone(stream_priority),
      mojo::Clone(attribs),
      mojo::Clone(active_url),
      mojo::Clone(label)
  );
}

template <typename T, CreateCommandBufferParams::EnableIfSame<T>*>
bool CreateCommandBufferParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->share_group_id, other_struct.share_group_id))
    return false;
  if (!mojo::Equals(this->stream_id, other_struct.stream_id))
    return false;
  if (!mojo::Equals(this->stream_priority, other_struct.stream_priority))
    return false;
  if (!mojo::Equals(this->attribs, other_struct.attribs))
    return false;
  if (!mojo::Equals(this->active_url, other_struct.active_url))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, CreateCommandBufferParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.share_group_id < rhs.share_group_id)
    return true;
  if (rhs.share_group_id < lhs.share_group_id)
    return false;
  if (lhs.stream_id < rhs.stream_id)
    return true;
  if (rhs.stream_id < lhs.stream_id)
    return false;
  if (lhs.stream_priority < rhs.stream_priority)
    return true;
  if (rhs.stream_priority < lhs.stream_priority)
    return false;
  if (lhs.attribs < rhs.attribs)
    return true;
  if (rhs.attribs < lhs.attribs)
    return false;
  if (lhs.active_url < rhs.active_url)
    return true;
  if (rhs.active_url < lhs.active_url)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
CommandBufferStatePtr CommandBufferState::Clone() const {
  return New(
      mojo::Clone(get_offset),
      mojo::Clone(token),
      mojo::Clone(release_count),
      mojo::Clone(error),
      mojo::Clone(context_lost_reason),
      mojo::Clone(generation),
      mojo::Clone(set_get_buffer_count)
  );
}

template <typename T, CommandBufferState::EnableIfSame<T>*>
bool CommandBufferState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->get_offset, other_struct.get_offset))
    return false;
  if (!mojo::Equals(this->token, other_struct.token))
    return false;
  if (!mojo::Equals(this->release_count, other_struct.release_count))
    return false;
  if (!mojo::Equals(this->error, other_struct.error))
    return false;
  if (!mojo::Equals(this->context_lost_reason, other_struct.context_lost_reason))
    return false;
  if (!mojo::Equals(this->generation, other_struct.generation))
    return false;
  if (!mojo::Equals(this->set_get_buffer_count, other_struct.set_get_buffer_count))
    return false;
  return true;
}

template <typename T, CommandBufferState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.get_offset < rhs.get_offset)
    return true;
  if (rhs.get_offset < lhs.get_offset)
    return false;
  if (lhs.token < rhs.token)
    return true;
  if (rhs.token < lhs.token)
    return false;
  if (lhs.release_count < rhs.release_count)
    return true;
  if (rhs.release_count < lhs.release_count)
    return false;
  if (lhs.error < rhs.error)
    return true;
  if (rhs.error < lhs.error)
    return false;
  if (lhs.context_lost_reason < rhs.context_lost_reason)
    return true;
  if (rhs.context_lost_reason < lhs.context_lost_reason)
    return false;
  if (lhs.generation < rhs.generation)
    return true;
  if (rhs.generation < lhs.generation)
    return false;
  if (lhs.set_get_buffer_count < rhs.set_get_buffer_count)
    return true;
  if (rhs.set_get_buffer_count < lhs.set_get_buffer_count)
    return false;
  return false;
}
template <typename StructPtrType>
ScheduleImageDecodeParamsPtr ScheduleImageDecodeParams::Clone() const {
  return New(
      mojo::Clone(encoded_data),
      mojo::Clone(output_size),
      mojo::Clone(raster_decoder_route_id),
      mojo::Clone(transfer_cache_entry_id),
      mojo::Clone(discardable_handle_shm_id),
      mojo::Clone(discardable_handle_shm_offset),
      mojo::Clone(discardable_handle_release_count),
      mojo::Clone(target_color_space),
      mojo::Clone(needs_mips)
  );
}

template <typename T, ScheduleImageDecodeParams::EnableIfSame<T>*>
bool ScheduleImageDecodeParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->encoded_data, other_struct.encoded_data))
    return false;
  if (!mojo::Equals(this->output_size, other_struct.output_size))
    return false;
  if (!mojo::Equals(this->raster_decoder_route_id, other_struct.raster_decoder_route_id))
    return false;
  if (!mojo::Equals(this->transfer_cache_entry_id, other_struct.transfer_cache_entry_id))
    return false;
  if (!mojo::Equals(this->discardable_handle_shm_id, other_struct.discardable_handle_shm_id))
    return false;
  if (!mojo::Equals(this->discardable_handle_shm_offset, other_struct.discardable_handle_shm_offset))
    return false;
  if (!mojo::Equals(this->discardable_handle_release_count, other_struct.discardable_handle_release_count))
    return false;
  if (!mojo::Equals(this->target_color_space, other_struct.target_color_space))
    return false;
  if (!mojo::Equals(this->needs_mips, other_struct.needs_mips))
    return false;
  return true;
}

template <typename T, ScheduleImageDecodeParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.encoded_data < rhs.encoded_data)
    return true;
  if (rhs.encoded_data < lhs.encoded_data)
    return false;
  if (lhs.output_size < rhs.output_size)
    return true;
  if (rhs.output_size < lhs.output_size)
    return false;
  if (lhs.raster_decoder_route_id < rhs.raster_decoder_route_id)
    return true;
  if (rhs.raster_decoder_route_id < lhs.raster_decoder_route_id)
    return false;
  if (lhs.transfer_cache_entry_id < rhs.transfer_cache_entry_id)
    return true;
  if (rhs.transfer_cache_entry_id < lhs.transfer_cache_entry_id)
    return false;
  if (lhs.discardable_handle_shm_id < rhs.discardable_handle_shm_id)
    return true;
  if (rhs.discardable_handle_shm_id < lhs.discardable_handle_shm_id)
    return false;
  if (lhs.discardable_handle_shm_offset < rhs.discardable_handle_shm_offset)
    return true;
  if (rhs.discardable_handle_shm_offset < lhs.discardable_handle_shm_offset)
    return false;
  if (lhs.discardable_handle_release_count < rhs.discardable_handle_release_count)
    return true;
  if (rhs.discardable_handle_release_count < lhs.discardable_handle_release_count)
    return false;
  if (lhs.target_color_space < rhs.target_color_space)
    return true;
  if (rhs.target_color_space < lhs.target_color_space)
    return false;
  if (lhs.needs_mips < rhs.needs_mips)
    return true;
  if (rhs.needs_mips < lhs.needs_mips)
    return false;
  return false;
}
template <typename StructPtrType>
DeferredRequestPtr DeferredRequest::Clone() const {
  return New(
      mojo::Clone(params),
      mojo::Clone(sync_token_fences),
      mojo::Clone(release_count)
  );
}

template <typename T, DeferredRequest::EnableIfSame<T>*>
bool DeferredRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->params, other_struct.params))
    return false;
  if (!mojo::Equals(this->sync_token_fences, other_struct.sync_token_fences))
    return false;
  if (!mojo::Equals(this->release_count, other_struct.release_count))
    return false;
  return true;
}

template <typename T, DeferredRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.params < rhs.params)
    return true;
  if (rhs.params < lhs.params)
    return false;
  if (lhs.sync_token_fences < rhs.sync_token_fences)
    return true;
  if (rhs.sync_token_fences < lhs.sync_token_fences)
    return false;
  if (lhs.release_count < rhs.release_count)
    return true;
  if (rhs.release_count < lhs.release_count)
    return false;
  return false;
}
template <typename StructPtrType>
DeferredCommandBufferRequestPtr DeferredCommandBufferRequest::Clone() const {
  return New(
      mojo::Clone(routing_id),
      mojo::Clone(params)
  );
}

template <typename T, DeferredCommandBufferRequest::EnableIfSame<T>*>
bool DeferredCommandBufferRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->routing_id, other_struct.routing_id))
    return false;
  if (!mojo::Equals(this->params, other_struct.params))
    return false;
  return true;
}

template <typename T, DeferredCommandBufferRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.routing_id < rhs.routing_id)
    return true;
  if (rhs.routing_id < lhs.routing_id)
    return false;
  if (lhs.params < rhs.params)
    return true;
  if (rhs.params < lhs.params)
    return false;
  return false;
}
template <typename StructPtrType>
AsyncFlushParamsPtr AsyncFlushParams::Clone() const {
  return New(
      mojo::Clone(put_offset),
      mojo::Clone(flush_id),
      mojo::Clone(sync_token_fences)
  );
}

template <typename T, AsyncFlushParams::EnableIfSame<T>*>
bool AsyncFlushParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->put_offset, other_struct.put_offset))
    return false;
  if (!mojo::Equals(this->flush_id, other_struct.flush_id))
    return false;
  if (!mojo::Equals(this->sync_token_fences, other_struct.sync_token_fences))
    return false;
  return true;
}

template <typename T, AsyncFlushParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.put_offset < rhs.put_offset)
    return true;
  if (rhs.put_offset < lhs.put_offset)
    return false;
  if (lhs.flush_id < rhs.flush_id)
    return true;
  if (rhs.flush_id < lhs.flush_id)
    return false;
  if (lhs.sync_token_fences < rhs.sync_token_fences)
    return true;
  if (rhs.sync_token_fences < lhs.sync_token_fences)
    return false;
  return false;
}
template <typename StructPtrType>
SharedImageInfoPtr SharedImageInfo::Clone() const {
  return New(
      mojo::Clone(meta),
      mojo::Clone(debug_label)
  );
}

template <typename T, SharedImageInfo::EnableIfSame<T>*>
bool SharedImageInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->meta, other_struct.meta))
    return false;
  if (!mojo::Equals(this->debug_label, other_struct.debug_label))
    return false;
  return true;
}

template <typename T, SharedImageInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.meta < rhs.meta)
    return true;
  if (rhs.meta < lhs.meta)
    return false;
  if (lhs.debug_label < rhs.debug_label)
    return true;
  if (rhs.debug_label < lhs.debug_label)
    return false;
  return false;
}
template <typename StructPtrType>
CreateSharedImageParamsPtr CreateSharedImageParams::Clone() const {
  return New(
      mojo::Clone(mailbox),
      mojo::Clone(si_info),
      mojo::Clone(pool_id)
  );
}

template <typename T, CreateSharedImageParams::EnableIfSame<T>*>
bool CreateSharedImageParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mailbox, other_struct.mailbox))
    return false;
  if (!mojo::Equals(this->si_info, other_struct.si_info))
    return false;
  if (!mojo::Equals(this->pool_id, other_struct.pool_id))
    return false;
  return true;
}

template <typename T, CreateSharedImageParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.mailbox < rhs.mailbox)
    return true;
  if (rhs.mailbox < lhs.mailbox)
    return false;
  if (lhs.si_info < rhs.si_info)
    return true;
  if (rhs.si_info < lhs.si_info)
    return false;
  if (lhs.pool_id < rhs.pool_id)
    return true;
  if (rhs.pool_id < lhs.pool_id)
    return false;
  return false;
}
template <typename StructPtrType>
CreateSharedImageWithDataParamsPtr CreateSharedImageWithDataParams::Clone() const {
  return New(
      mojo::Clone(mailbox),
      mojo::Clone(si_info),
      mojo::Clone(pixel_data_offset),
      mojo::Clone(pixel_data_size),
      mojo::Clone(done_with_shm)
  );
}

template <typename T, CreateSharedImageWithDataParams::EnableIfSame<T>*>
bool CreateSharedImageWithDataParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mailbox, other_struct.mailbox))
    return false;
  if (!mojo::Equals(this->si_info, other_struct.si_info))
    return false;
  if (!mojo::Equals(this->pixel_data_offset, other_struct.pixel_data_offset))
    return false;
  if (!mojo::Equals(this->pixel_data_size, other_struct.pixel_data_size))
    return false;
  if (!mojo::Equals(this->done_with_shm, other_struct.done_with_shm))
    return false;
  return true;
}

template <typename T, CreateSharedImageWithDataParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.mailbox < rhs.mailbox)
    return true;
  if (rhs.mailbox < lhs.mailbox)
    return false;
  if (lhs.si_info < rhs.si_info)
    return true;
  if (rhs.si_info < lhs.si_info)
    return false;
  if (lhs.pixel_data_offset < rhs.pixel_data_offset)
    return true;
  if (rhs.pixel_data_offset < lhs.pixel_data_offset)
    return false;
  if (lhs.pixel_data_size < rhs.pixel_data_size)
    return true;
  if (rhs.pixel_data_size < lhs.pixel_data_size)
    return false;
  if (lhs.done_with_shm < rhs.done_with_shm)
    return true;
  if (rhs.done_with_shm < lhs.done_with_shm)
    return false;
  return false;
}
template <typename StructPtrType>
CreateSharedImageWithBufferParamsPtr CreateSharedImageWithBufferParams::Clone() const {
  return New(
      mojo::Clone(mailbox),
      mojo::Clone(si_info),
      mojo::Clone(buffer_handle),
      mojo::Clone(pool_id)
  );
}

template <typename T, CreateSharedImageWithBufferParams::EnableIfSame<T>*>
bool CreateSharedImageWithBufferParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mailbox, other_struct.mailbox))
    return false;
  if (!mojo::Equals(this->si_info, other_struct.si_info))
    return false;
  if (!mojo::Equals(this->buffer_handle, other_struct.buffer_handle))
    return false;
  if (!mojo::Equals(this->pool_id, other_struct.pool_id))
    return false;
  return true;
}

template <typename T, CreateSharedImageWithBufferParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.mailbox < rhs.mailbox)
    return true;
  if (rhs.mailbox < lhs.mailbox)
    return false;
  if (lhs.si_info < rhs.si_info)
    return true;
  if (rhs.si_info < lhs.si_info)
    return false;
  if (lhs.buffer_handle < rhs.buffer_handle)
    return true;
  if (rhs.buffer_handle < lhs.buffer_handle)
    return false;
  if (lhs.pool_id < rhs.pool_id)
    return true;
  if (rhs.pool_id < lhs.pool_id)
    return false;
  return false;
}
template <typename StructPtrType>
UpdateSharedImageParamsPtr UpdateSharedImageParams::Clone() const {
  return New(
      mojo::Clone(mailbox),
      mojo::Clone(in_fence_handle)
  );
}

template <typename T, UpdateSharedImageParams::EnableIfSame<T>*>
bool UpdateSharedImageParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mailbox, other_struct.mailbox))
    return false;
  if (!mojo::Equals(this->in_fence_handle, other_struct.in_fence_handle))
    return false;
  return true;
}

template <typename T, UpdateSharedImageParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.mailbox < rhs.mailbox)
    return true;
  if (rhs.mailbox < lhs.mailbox)
    return false;
  if (lhs.in_fence_handle < rhs.in_fence_handle)
    return true;
  if (rhs.in_fence_handle < lhs.in_fence_handle)
    return false;
  return false;
}
template <typename StructPtrType>
AddReferenceToSharedImageParamsPtr AddReferenceToSharedImageParams::Clone() const {
  return New(
      mojo::Clone(mailbox)
  );
}

template <typename T, AddReferenceToSharedImageParams::EnableIfSame<T>*>
bool AddReferenceToSharedImageParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mailbox, other_struct.mailbox))
    return false;
  return true;
}

template <typename T, AddReferenceToSharedImageParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.mailbox < rhs.mailbox)
    return true;
  if (rhs.mailbox < lhs.mailbox)
    return false;
  return false;
}
template <typename StructPtrType>
CopyToGpuMemoryBufferParamsPtr CopyToGpuMemoryBufferParams::Clone() const {
  return New(
      mojo::Clone(mailbox)
  );
}

template <typename T, CopyToGpuMemoryBufferParams::EnableIfSame<T>*>
bool CopyToGpuMemoryBufferParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mailbox, other_struct.mailbox))
    return false;
  return true;
}

template <typename T, CopyToGpuMemoryBufferParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.mailbox < rhs.mailbox)
    return true;
  if (rhs.mailbox < lhs.mailbox)
    return false;
  return false;
}
template <typename StructPtrType>
CreateSharedImagePoolParamsPtr CreateSharedImagePoolParams::Clone() const {
  return New(
      mojo::Clone(pool_id),
      mojo::Clone(client_remote)
  );
}

template <typename T, CreateSharedImagePoolParams::EnableIfSame<T>*>
bool CreateSharedImagePoolParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->pool_id, other_struct.pool_id))
    return false;
  if (!mojo::Equals(this->client_remote, other_struct.client_remote))
    return false;
  return true;
}

template <typename T, CreateSharedImagePoolParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.pool_id < rhs.pool_id)
    return true;
  if (rhs.pool_id < lhs.pool_id)
    return false;
  if (lhs.client_remote < rhs.client_remote)
    return true;
  if (rhs.client_remote < lhs.client_remote)
    return false;
  return false;
}
template <typename StructPtrType>
DestroySharedImagePoolParamsPtr DestroySharedImagePoolParams::Clone() const {
  return New(
      mojo::Clone(pool_id)
  );
}

template <typename T, DestroySharedImagePoolParams::EnableIfSame<T>*>
bool DestroySharedImagePoolParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->pool_id, other_struct.pool_id))
    return false;
  return true;
}

template <typename T, DestroySharedImagePoolParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.pool_id < rhs.pool_id)
    return true;
  if (rhs.pool_id < lhs.pool_id)
    return false;
  return false;
}


}  // gpu::mojom

namespace mojo {


template <>
struct GPU_EXPORT StructTraits<::gpu::mojom::ContextCreationAttribs::DataView,
                                         ::gpu::mojom::ContextCreationAttribsPtr> {
  static bool IsNull(const ::gpu::mojom::ContextCreationAttribsPtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::ContextCreationAttribsPtr* output) { output->reset(); }

  static decltype(::gpu::mojom::ContextCreationAttribs::gpu_preference) gpu_preference(
      const ::gpu::mojom::ContextCreationAttribsPtr& input) {
    return input->gpu_preference;
  }

  static decltype(::gpu::mojom::ContextCreationAttribs::fail_if_major_perf_caveat) fail_if_major_perf_caveat(
      const ::gpu::mojom::ContextCreationAttribsPtr& input) {
    return input->fail_if_major_perf_caveat;
  }

  static decltype(::gpu::mojom::ContextCreationAttribs::lose_context_when_out_of_memory) lose_context_when_out_of_memory(
      const ::gpu::mojom::ContextCreationAttribsPtr& input) {
    return input->lose_context_when_out_of_memory;
  }

  static decltype(::gpu::mojom::ContextCreationAttribs::enable_gles2_interface) enable_gles2_interface(
      const ::gpu::mojom::ContextCreationAttribsPtr& input) {
    return input->enable_gles2_interface;
  }

  static decltype(::gpu::mojom::ContextCreationAttribs::enable_grcontext) enable_grcontext(
      const ::gpu::mojom::ContextCreationAttribsPtr& input) {
    return input->enable_grcontext;
  }

  static decltype(::gpu::mojom::ContextCreationAttribs::enable_raster_interface) enable_raster_interface(
      const ::gpu::mojom::ContextCreationAttribsPtr& input) {
    return input->enable_raster_interface;
  }

  static decltype(::gpu::mojom::ContextCreationAttribs::enable_gpu_rasterization) enable_gpu_rasterization(
      const ::gpu::mojom::ContextCreationAttribsPtr& input) {
    return input->enable_gpu_rasterization;
  }

  static decltype(::gpu::mojom::ContextCreationAttribs::context_type) context_type(
      const ::gpu::mojom::ContextCreationAttribsPtr& input) {
    return input->context_type;
  }

  static bool Read(::gpu::mojom::ContextCreationAttribs::DataView input, ::gpu::mojom::ContextCreationAttribsPtr* output);
};


template <>
struct GPU_EXPORT StructTraits<::gpu::mojom::CreateCommandBufferParams::DataView,
                                         ::gpu::mojom::CreateCommandBufferParamsPtr> {
  static bool IsNull(const ::gpu::mojom::CreateCommandBufferParamsPtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::CreateCommandBufferParamsPtr* output) { output->reset(); }

  static decltype(::gpu::mojom::CreateCommandBufferParams::share_group_id) share_group_id(
      const ::gpu::mojom::CreateCommandBufferParamsPtr& input) {
    return input->share_group_id;
  }

  static decltype(::gpu::mojom::CreateCommandBufferParams::stream_id) stream_id(
      const ::gpu::mojom::CreateCommandBufferParamsPtr& input) {
    return input->stream_id;
  }

  static decltype(::gpu::mojom::CreateCommandBufferParams::stream_priority) stream_priority(
      const ::gpu::mojom::CreateCommandBufferParamsPtr& input) {
    return input->stream_priority;
  }

  static const decltype(::gpu::mojom::CreateCommandBufferParams::attribs)& attribs(
      const ::gpu::mojom::CreateCommandBufferParamsPtr& input) {
    return input->attribs;
  }

  static const decltype(::gpu::mojom::CreateCommandBufferParams::active_url)& active_url(
      const ::gpu::mojom::CreateCommandBufferParamsPtr& input) {
    return input->active_url;
  }

  static const decltype(::gpu::mojom::CreateCommandBufferParams::label)& label(
      const ::gpu::mojom::CreateCommandBufferParamsPtr& input) {
    return input->label;
  }

  static bool Read(::gpu::mojom::CreateCommandBufferParams::DataView input, ::gpu::mojom::CreateCommandBufferParamsPtr* output);
};


template <>
struct GPU_EXPORT StructTraits<::gpu::mojom::CommandBufferState::DataView,
                                         ::gpu::mojom::CommandBufferStatePtr> {
  static bool IsNull(const ::gpu::mojom::CommandBufferStatePtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::CommandBufferStatePtr* output) { output->reset(); }

  static decltype(::gpu::mojom::CommandBufferState::get_offset) get_offset(
      const ::gpu::mojom::CommandBufferStatePtr& input) {
    return input->get_offset;
  }

  static decltype(::gpu::mojom::CommandBufferState::token) token(
      const ::gpu::mojom::CommandBufferStatePtr& input) {
    return input->token;
  }

  static decltype(::gpu::mojom::CommandBufferState::release_count) release_count(
      const ::gpu::mojom::CommandBufferStatePtr& input) {
    return input->release_count;
  }

  static decltype(::gpu::mojom::CommandBufferState::error) error(
      const ::gpu::mojom::CommandBufferStatePtr& input) {
    return input->error;
  }

  static decltype(::gpu::mojom::CommandBufferState::context_lost_reason) context_lost_reason(
      const ::gpu::mojom::CommandBufferStatePtr& input) {
    return input->context_lost_reason;
  }

  static decltype(::gpu::mojom::CommandBufferState::generation) generation(
      const ::gpu::mojom::CommandBufferStatePtr& input) {
    return input->generation;
  }

  static decltype(::gpu::mojom::CommandBufferState::set_get_buffer_count) set_get_buffer_count(
      const ::gpu::mojom::CommandBufferStatePtr& input) {
    return input->set_get_buffer_count;
  }

  static bool Read(::gpu::mojom::CommandBufferState::DataView input, ::gpu::mojom::CommandBufferStatePtr* output);
};


template <>
struct GPU_EXPORT StructTraits<::gpu::mojom::ScheduleImageDecodeParams::DataView,
                                         ::gpu::mojom::ScheduleImageDecodeParamsPtr> {
  static bool IsNull(const ::gpu::mojom::ScheduleImageDecodeParamsPtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::ScheduleImageDecodeParamsPtr* output) { output->reset(); }

  static const decltype(::gpu::mojom::ScheduleImageDecodeParams::encoded_data)& encoded_data(
      const ::gpu::mojom::ScheduleImageDecodeParamsPtr& input) {
    return input->encoded_data;
  }

  static const decltype(::gpu::mojom::ScheduleImageDecodeParams::output_size)& output_size(
      const ::gpu::mojom::ScheduleImageDecodeParamsPtr& input) {
    return input->output_size;
  }

  static decltype(::gpu::mojom::ScheduleImageDecodeParams::raster_decoder_route_id) raster_decoder_route_id(
      const ::gpu::mojom::ScheduleImageDecodeParamsPtr& input) {
    return input->raster_decoder_route_id;
  }

  static decltype(::gpu::mojom::ScheduleImageDecodeParams::transfer_cache_entry_id) transfer_cache_entry_id(
      const ::gpu::mojom::ScheduleImageDecodeParamsPtr& input) {
    return input->transfer_cache_entry_id;
  }

  static decltype(::gpu::mojom::ScheduleImageDecodeParams::discardable_handle_shm_id) discardable_handle_shm_id(
      const ::gpu::mojom::ScheduleImageDecodeParamsPtr& input) {
    return input->discardable_handle_shm_id;
  }

  static decltype(::gpu::mojom::ScheduleImageDecodeParams::discardable_handle_shm_offset) discardable_handle_shm_offset(
      const ::gpu::mojom::ScheduleImageDecodeParamsPtr& input) {
    return input->discardable_handle_shm_offset;
  }

  static decltype(::gpu::mojom::ScheduleImageDecodeParams::discardable_handle_release_count) discardable_handle_release_count(
      const ::gpu::mojom::ScheduleImageDecodeParamsPtr& input) {
    return input->discardable_handle_release_count;
  }

  static const decltype(::gpu::mojom::ScheduleImageDecodeParams::target_color_space)& target_color_space(
      const ::gpu::mojom::ScheduleImageDecodeParamsPtr& input) {
    return input->target_color_space;
  }

  static decltype(::gpu::mojom::ScheduleImageDecodeParams::needs_mips) needs_mips(
      const ::gpu::mojom::ScheduleImageDecodeParamsPtr& input) {
    return input->needs_mips;
  }

  static bool Read(::gpu::mojom::ScheduleImageDecodeParams::DataView input, ::gpu::mojom::ScheduleImageDecodeParamsPtr* output);
};


template <>
struct GPU_EXPORT StructTraits<::gpu::mojom::DeferredRequest::DataView,
                                         ::gpu::mojom::DeferredRequestPtr> {
  static bool IsNull(const ::gpu::mojom::DeferredRequestPtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::DeferredRequestPtr* output) { output->reset(); }

  static  decltype(::gpu::mojom::DeferredRequest::params)& params(
       ::gpu::mojom::DeferredRequestPtr& input) {
    return input->params;
  }

  static const decltype(::gpu::mojom::DeferredRequest::sync_token_fences)& sync_token_fences(
      const ::gpu::mojom::DeferredRequestPtr& input) {
    return input->sync_token_fences;
  }

  static decltype(::gpu::mojom::DeferredRequest::release_count) release_count(
      const ::gpu::mojom::DeferredRequestPtr& input) {
    return input->release_count;
  }

  static bool Read(::gpu::mojom::DeferredRequest::DataView input, ::gpu::mojom::DeferredRequestPtr* output);
};


template <>
struct GPU_EXPORT StructTraits<::gpu::mojom::DeferredCommandBufferRequest::DataView,
                                         ::gpu::mojom::DeferredCommandBufferRequestPtr> {
  static bool IsNull(const ::gpu::mojom::DeferredCommandBufferRequestPtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::DeferredCommandBufferRequestPtr* output) { output->reset(); }

  static decltype(::gpu::mojom::DeferredCommandBufferRequest::routing_id) routing_id(
      const ::gpu::mojom::DeferredCommandBufferRequestPtr& input) {
    return input->routing_id;
  }

  static const decltype(::gpu::mojom::DeferredCommandBufferRequest::params)& params(
      const ::gpu::mojom::DeferredCommandBufferRequestPtr& input) {
    return input->params;
  }

  static bool Read(::gpu::mojom::DeferredCommandBufferRequest::DataView input, ::gpu::mojom::DeferredCommandBufferRequestPtr* output);
};


template <>
struct GPU_EXPORT StructTraits<::gpu::mojom::AsyncFlushParams::DataView,
                                         ::gpu::mojom::AsyncFlushParamsPtr> {
  static bool IsNull(const ::gpu::mojom::AsyncFlushParamsPtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::AsyncFlushParamsPtr* output) { output->reset(); }

  static decltype(::gpu::mojom::AsyncFlushParams::put_offset) put_offset(
      const ::gpu::mojom::AsyncFlushParamsPtr& input) {
    return input->put_offset;
  }

  static decltype(::gpu::mojom::AsyncFlushParams::flush_id) flush_id(
      const ::gpu::mojom::AsyncFlushParamsPtr& input) {
    return input->flush_id;
  }

  static const decltype(::gpu::mojom::AsyncFlushParams::sync_token_fences)& sync_token_fences(
      const ::gpu::mojom::AsyncFlushParamsPtr& input) {
    return input->sync_token_fences;
  }

  static bool Read(::gpu::mojom::AsyncFlushParams::DataView input, ::gpu::mojom::AsyncFlushParamsPtr* output);
};


template <>
struct GPU_EXPORT StructTraits<::gpu::mojom::SharedImageInfo::DataView,
                                         ::gpu::mojom::SharedImageInfoPtr> {
  static bool IsNull(const ::gpu::mojom::SharedImageInfoPtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::SharedImageInfoPtr* output) { output->reset(); }

  static const decltype(::gpu::mojom::SharedImageInfo::meta)& meta(
      const ::gpu::mojom::SharedImageInfoPtr& input) {
    return input->meta;
  }

  static const decltype(::gpu::mojom::SharedImageInfo::debug_label)& debug_label(
      const ::gpu::mojom::SharedImageInfoPtr& input) {
    return input->debug_label;
  }

  static bool Read(::gpu::mojom::SharedImageInfo::DataView input, ::gpu::mojom::SharedImageInfoPtr* output);
};


template <>
struct GPU_EXPORT StructTraits<::gpu::mojom::CreateSharedImageParams::DataView,
                                         ::gpu::mojom::CreateSharedImageParamsPtr> {
  static bool IsNull(const ::gpu::mojom::CreateSharedImageParamsPtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::CreateSharedImageParamsPtr* output) { output->reset(); }

  static const decltype(::gpu::mojom::CreateSharedImageParams::mailbox)& mailbox(
      const ::gpu::mojom::CreateSharedImageParamsPtr& input) {
    return input->mailbox;
  }

  static const decltype(::gpu::mojom::CreateSharedImageParams::si_info)& si_info(
      const ::gpu::mojom::CreateSharedImageParamsPtr& input) {
    return input->si_info;
  }

  static const decltype(::gpu::mojom::CreateSharedImageParams::pool_id)& pool_id(
      const ::gpu::mojom::CreateSharedImageParamsPtr& input) {
    return input->pool_id;
  }

  static bool Read(::gpu::mojom::CreateSharedImageParams::DataView input, ::gpu::mojom::CreateSharedImageParamsPtr* output);
};


template <>
struct GPU_EXPORT StructTraits<::gpu::mojom::CreateSharedImageWithDataParams::DataView,
                                         ::gpu::mojom::CreateSharedImageWithDataParamsPtr> {
  static bool IsNull(const ::gpu::mojom::CreateSharedImageWithDataParamsPtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::CreateSharedImageWithDataParamsPtr* output) { output->reset(); }

  static const decltype(::gpu::mojom::CreateSharedImageWithDataParams::mailbox)& mailbox(
      const ::gpu::mojom::CreateSharedImageWithDataParamsPtr& input) {
    return input->mailbox;
  }

  static const decltype(::gpu::mojom::CreateSharedImageWithDataParams::si_info)& si_info(
      const ::gpu::mojom::CreateSharedImageWithDataParamsPtr& input) {
    return input->si_info;
  }

  static decltype(::gpu::mojom::CreateSharedImageWithDataParams::pixel_data_offset) pixel_data_offset(
      const ::gpu::mojom::CreateSharedImageWithDataParamsPtr& input) {
    return input->pixel_data_offset;
  }

  static decltype(::gpu::mojom::CreateSharedImageWithDataParams::pixel_data_size) pixel_data_size(
      const ::gpu::mojom::CreateSharedImageWithDataParamsPtr& input) {
    return input->pixel_data_size;
  }

  static decltype(::gpu::mojom::CreateSharedImageWithDataParams::done_with_shm) done_with_shm(
      const ::gpu::mojom::CreateSharedImageWithDataParamsPtr& input) {
    return input->done_with_shm;
  }

  static bool Read(::gpu::mojom::CreateSharedImageWithDataParams::DataView input, ::gpu::mojom::CreateSharedImageWithDataParamsPtr* output);
};


template <>
struct GPU_EXPORT StructTraits<::gpu::mojom::CreateSharedImageWithBufferParams::DataView,
                                         ::gpu::mojom::CreateSharedImageWithBufferParamsPtr> {
  static bool IsNull(const ::gpu::mojom::CreateSharedImageWithBufferParamsPtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::CreateSharedImageWithBufferParamsPtr* output) { output->reset(); }

  static const decltype(::gpu::mojom::CreateSharedImageWithBufferParams::mailbox)& mailbox(
      const ::gpu::mojom::CreateSharedImageWithBufferParamsPtr& input) {
    return input->mailbox;
  }

  static const decltype(::gpu::mojom::CreateSharedImageWithBufferParams::si_info)& si_info(
      const ::gpu::mojom::CreateSharedImageWithBufferParamsPtr& input) {
    return input->si_info;
  }

  static  decltype(::gpu::mojom::CreateSharedImageWithBufferParams::buffer_handle)& buffer_handle(
       ::gpu::mojom::CreateSharedImageWithBufferParamsPtr& input) {
    return input->buffer_handle;
  }

  static const decltype(::gpu::mojom::CreateSharedImageWithBufferParams::pool_id)& pool_id(
      const ::gpu::mojom::CreateSharedImageWithBufferParamsPtr& input) {
    return input->pool_id;
  }

  static bool Read(::gpu::mojom::CreateSharedImageWithBufferParams::DataView input, ::gpu::mojom::CreateSharedImageWithBufferParamsPtr* output);
};


template <>
struct GPU_EXPORT StructTraits<::gpu::mojom::UpdateSharedImageParams::DataView,
                                         ::gpu::mojom::UpdateSharedImageParamsPtr> {
  static bool IsNull(const ::gpu::mojom::UpdateSharedImageParamsPtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::UpdateSharedImageParamsPtr* output) { output->reset(); }

  static const decltype(::gpu::mojom::UpdateSharedImageParams::mailbox)& mailbox(
      const ::gpu::mojom::UpdateSharedImageParamsPtr& input) {
    return input->mailbox;
  }

  static  decltype(::gpu::mojom::UpdateSharedImageParams::in_fence_handle)& in_fence_handle(
       ::gpu::mojom::UpdateSharedImageParamsPtr& input) {
    return input->in_fence_handle;
  }

  static bool Read(::gpu::mojom::UpdateSharedImageParams::DataView input, ::gpu::mojom::UpdateSharedImageParamsPtr* output);
};


template <>
struct GPU_EXPORT StructTraits<::gpu::mojom::AddReferenceToSharedImageParams::DataView,
                                         ::gpu::mojom::AddReferenceToSharedImageParamsPtr> {
  static bool IsNull(const ::gpu::mojom::AddReferenceToSharedImageParamsPtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::AddReferenceToSharedImageParamsPtr* output) { output->reset(); }

  static const decltype(::gpu::mojom::AddReferenceToSharedImageParams::mailbox)& mailbox(
      const ::gpu::mojom::AddReferenceToSharedImageParamsPtr& input) {
    return input->mailbox;
  }

  static bool Read(::gpu::mojom::AddReferenceToSharedImageParams::DataView input, ::gpu::mojom::AddReferenceToSharedImageParamsPtr* output);
};


template <>
struct GPU_EXPORT StructTraits<::gpu::mojom::CopyToGpuMemoryBufferParams::DataView,
                                         ::gpu::mojom::CopyToGpuMemoryBufferParamsPtr> {
  static bool IsNull(const ::gpu::mojom::CopyToGpuMemoryBufferParamsPtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::CopyToGpuMemoryBufferParamsPtr* output) { output->reset(); }

  static const decltype(::gpu::mojom::CopyToGpuMemoryBufferParams::mailbox)& mailbox(
      const ::gpu::mojom::CopyToGpuMemoryBufferParamsPtr& input) {
    return input->mailbox;
  }

  static bool Read(::gpu::mojom::CopyToGpuMemoryBufferParams::DataView input, ::gpu::mojom::CopyToGpuMemoryBufferParamsPtr* output);
};


template <>
struct GPU_EXPORT StructTraits<::gpu::mojom::CreateSharedImagePoolParams::DataView,
                                         ::gpu::mojom::CreateSharedImagePoolParamsPtr> {
  static bool IsNull(const ::gpu::mojom::CreateSharedImagePoolParamsPtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::CreateSharedImagePoolParamsPtr* output) { output->reset(); }

  static const decltype(::gpu::mojom::CreateSharedImagePoolParams::pool_id)& pool_id(
      const ::gpu::mojom::CreateSharedImagePoolParamsPtr& input) {
    return input->pool_id;
  }

  static  decltype(::gpu::mojom::CreateSharedImagePoolParams::client_remote)& client_remote(
       ::gpu::mojom::CreateSharedImagePoolParamsPtr& input) {
    return input->client_remote;
  }

  static bool Read(::gpu::mojom::CreateSharedImagePoolParams::DataView input, ::gpu::mojom::CreateSharedImagePoolParamsPtr* output);
};


template <>
struct GPU_EXPORT StructTraits<::gpu::mojom::DestroySharedImagePoolParams::DataView,
                                         ::gpu::mojom::DestroySharedImagePoolParamsPtr> {
  static bool IsNull(const ::gpu::mojom::DestroySharedImagePoolParamsPtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::DestroySharedImagePoolParamsPtr* output) { output->reset(); }

  static const decltype(::gpu::mojom::DestroySharedImagePoolParams::pool_id)& pool_id(
      const ::gpu::mojom::DestroySharedImagePoolParamsPtr& input) {
    return input->pool_id;
  }

  static bool Read(::gpu::mojom::DestroySharedImagePoolParams::DataView input, ::gpu::mojom::DestroySharedImagePoolParamsPtr* output);
};


template <>
struct GPU_EXPORT UnionTraits<::gpu::mojom::DeferredRequestParams::DataView,
                                        ::gpu::mojom::DeferredRequestParamsPtr> {
  static bool IsNull(const ::gpu::mojom::DeferredRequestParamsPtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::DeferredRequestParamsPtr* output) { output->reset(); }

  static ::gpu::mojom::DeferredRequestParams::Tag GetTag(const ::gpu::mojom::DeferredRequestParamsPtr& input) {
    return input->which();
  }

  static const ::gpu::mojom::DeferredCommandBufferRequestPtr& command_buffer_request(const ::gpu::mojom::DeferredRequestParamsPtr& input) {
    return input->get_command_buffer_request();
  }

  static  ::gpu::mojom::DeferredSharedImageRequestPtr& shared_image_request( ::gpu::mojom::DeferredRequestParamsPtr& input) {
    return input->get_shared_image_request();
  }

  static bool Read(::gpu::mojom::DeferredRequestParams::DataView input, ::gpu::mojom::DeferredRequestParamsPtr* output);
};


template <>
struct GPU_EXPORT UnionTraits<::gpu::mojom::DeferredCommandBufferRequestParams::DataView,
                                        ::gpu::mojom::DeferredCommandBufferRequestParamsPtr> {
  static bool IsNull(const ::gpu::mojom::DeferredCommandBufferRequestParamsPtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::DeferredCommandBufferRequestParamsPtr* output) { output->reset(); }

  static ::gpu::mojom::DeferredCommandBufferRequestParams::Tag GetTag(const ::gpu::mojom::DeferredCommandBufferRequestParamsPtr& input) {
    return input->which();
  }

  static const ::gpu::mojom::AsyncFlushParamsPtr& async_flush(const ::gpu::mojom::DeferredCommandBufferRequestParamsPtr& input) {
    return input->get_async_flush();
  }

  static  int32_t destroy_transfer_buffer(const ::gpu::mojom::DeferredCommandBufferRequestParamsPtr& input) {
    return input->get_destroy_transfer_buffer();
  }

  static bool Read(::gpu::mojom::DeferredCommandBufferRequestParams::DataView input, ::gpu::mojom::DeferredCommandBufferRequestParamsPtr* output);
};


template <>
struct GPU_EXPORT UnionTraits<::gpu::mojom::DeferredSharedImageRequest::DataView,
                                        ::gpu::mojom::DeferredSharedImageRequestPtr> {
  static bool IsNull(const ::gpu::mojom::DeferredSharedImageRequestPtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::DeferredSharedImageRequestPtr* output) { output->reset(); }

  static ::gpu::mojom::DeferredSharedImageRequest::Tag GetTag(const ::gpu::mojom::DeferredSharedImageRequestPtr& input) {
    return input->which();
  }

  static  uint8_t nop(const ::gpu::mojom::DeferredSharedImageRequestPtr& input) {
    return input->get_nop();
  }

  static const ::gpu::mojom::CreateSharedImageParamsPtr& create_shared_image(const ::gpu::mojom::DeferredSharedImageRequestPtr& input) {
    return input->get_create_shared_image();
  }

  static const ::gpu::mojom::CreateSharedImageWithDataParamsPtr& create_shared_image_with_data(const ::gpu::mojom::DeferredSharedImageRequestPtr& input) {
    return input->get_create_shared_image_with_data();
  }

  static  ::gpu::mojom::CreateSharedImageWithBufferParamsPtr& create_shared_image_with_buffer( ::gpu::mojom::DeferredSharedImageRequestPtr& input) {
    return input->get_create_shared_image_with_buffer();
  }

  static  ::base::ReadOnlySharedMemoryRegion& register_upload_buffer( ::gpu::mojom::DeferredSharedImageRequestPtr& input) {
    return input->get_register_upload_buffer();
  }

  static  ::gpu::mojom::UpdateSharedImageParamsPtr& update_shared_image( ::gpu::mojom::DeferredSharedImageRequestPtr& input) {
    return input->get_update_shared_image();
  }

  static const ::gpu::mojom::CopyToGpuMemoryBufferParamsPtr& copy_to_gpu_memory_buffer(const ::gpu::mojom::DeferredSharedImageRequestPtr& input) {
    return input->get_copy_to_gpu_memory_buffer();
  }

  static const ::gpu::Mailbox& destroy_shared_image(const ::gpu::mojom::DeferredSharedImageRequestPtr& input) {
    return input->get_destroy_shared_image();
  }

  static const ::gpu::mojom::AddReferenceToSharedImageParamsPtr& add_reference_to_shared_image(const ::gpu::mojom::DeferredSharedImageRequestPtr& input) {
    return input->get_add_reference_to_shared_image();
  }

  static  ::gpu::mojom::CreateSharedImagePoolParamsPtr& create_shared_image_pool( ::gpu::mojom::DeferredSharedImageRequestPtr& input) {
    return input->get_create_shared_image_pool();
  }

  static const ::gpu::mojom::DestroySharedImagePoolParamsPtr& destroy_shared_image_pool(const ::gpu::mojom::DeferredSharedImageRequestPtr& input) {
    return input->get_destroy_shared_image_pool();
  }

  static bool Read(::gpu::mojom::DeferredSharedImageRequest::DataView input, ::gpu::mojom::DeferredSharedImageRequestPtr* output);
};

}  // namespace mojo

#endif  // GPU_IPC_COMMON_GPU_CHANNEL_MOJOM_H_