// media/capture/mojom/video_capture_types.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_TYPES_MOJOM_BLINK_H_
#define MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_TYPES_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/capture/mojom/video_capture_types.mojom-features.h"  // IWYU pragma: export
#include "media/capture/mojom/video_capture_types.mojom-shared.h"  // IWYU pragma: export
#include "media/capture/mojom/video_capture_types.mojom-blink-forward.h"  // IWYU pragma: export
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "media/capture/mojom/video_capture_types_mojom_traits.h"
#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace media::mojom::blink {





class BLINK_PLATFORM_EXPORT VideoCaptureControlSupport {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoCaptureControlSupport, T>::value>;
  using DataView = VideoCaptureControlSupportDataView;
  using Data_ = internal::VideoCaptureControlSupport_Data;

  template <typename... Args>
  static VideoCaptureControlSupportPtr New(Args&&... args) {
    return VideoCaptureControlSupportPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoCaptureControlSupportPtr From(const U& u) {
    return mojo::TypeConverter<VideoCaptureControlSupportPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoCaptureControlSupport>::Convert(*this);
  }


  VideoCaptureControlSupport();

  VideoCaptureControlSupport(
      bool pan,
      bool tilt,
      bool zoom);


  ~VideoCaptureControlSupport();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoCaptureControlSupportPtr>
  VideoCaptureControlSupportPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoCaptureControlSupport::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VideoCaptureControlSupport::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VideoCaptureControlSupport::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoCaptureControlSupport::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoCaptureControlSupport::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoCaptureControlSupport::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoCaptureControlSupport_UnserializedMessageContext<
            UserType, VideoCaptureControlSupport::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VideoCaptureControlSupport::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VideoCaptureControlSupport::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoCaptureControlSupport_UnserializedMessageContext<
            UserType, VideoCaptureControlSupport::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoCaptureControlSupport::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool pan;
  
  bool tilt;
  
  bool zoom;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoCaptureControlSupport::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoCaptureControlSupport::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoCaptureControlSupport::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoCaptureControlSupport::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}














class BLINK_PLATFORM_EXPORT VideoCaptureFormat {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoCaptureFormat, T>::value>;
  using DataView = VideoCaptureFormatDataView;
  using Data_ = internal::VideoCaptureFormat_Data;

  template <typename... Args>
  static VideoCaptureFormatPtr New(Args&&... args) {
    return VideoCaptureFormatPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoCaptureFormatPtr From(const U& u) {
    return mojo::TypeConverter<VideoCaptureFormatPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoCaptureFormat>::Convert(*this);
  }


  VideoCaptureFormat();

  VideoCaptureFormat(
      const ::gfx::Size& frame_size,
      float frame_rate,
      ::media::VideoPixelFormat pixel_format);


  ~VideoCaptureFormat();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoCaptureFormatPtr>
  VideoCaptureFormatPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoCaptureFormat::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VideoCaptureFormat::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VideoCaptureFormat::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoCaptureFormat::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoCaptureFormat::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoCaptureFormat::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoCaptureFormat_UnserializedMessageContext<
            UserType, VideoCaptureFormat::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VideoCaptureFormat::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VideoCaptureFormat::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoCaptureFormat_UnserializedMessageContext<
            UserType, VideoCaptureFormat::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoCaptureFormat::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::Size frame_size;
  
  float frame_rate;
  
  ::media::VideoPixelFormat pixel_format;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoCaptureFormat::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoCaptureFormat::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoCaptureFormat::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoCaptureFormat::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT VideoCaptureParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoCaptureParams, T>::value>;
  using DataView = VideoCaptureParamsDataView;
  using Data_ = internal::VideoCaptureParams_Data;

  template <typename... Args>
  static VideoCaptureParamsPtr New(Args&&... args) {
    return VideoCaptureParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoCaptureParamsPtr From(const U& u) {
    return mojo::TypeConverter<VideoCaptureParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoCaptureParams>::Convert(*this);
  }


  VideoCaptureParams();

  VideoCaptureParams(
      const ::media::VideoCaptureFormat& requested_format,
      ::media::VideoCaptureBufferType buffer_type,
      ::media::ResolutionChangePolicy resolution_change_policy,
      ::media::PowerLineFrequency power_line_frequency,
      bool enable_face_detection);

  VideoCaptureParams(
      const ::media::VideoCaptureFormat& requested_format,
      ::media::VideoCaptureBufferType buffer_type,
      ::media::ResolutionChangePolicy resolution_change_policy,
      ::media::PowerLineFrequency power_line_frequency,
      bool enable_face_detection,
      bool is_high_dpi_enabled);


  ~VideoCaptureParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoCaptureParamsPtr>
  VideoCaptureParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoCaptureParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VideoCaptureParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VideoCaptureParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoCaptureParams::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoCaptureParams::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoCaptureParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoCaptureParams_UnserializedMessageContext<
            UserType, VideoCaptureParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VideoCaptureParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VideoCaptureParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoCaptureParams_UnserializedMessageContext<
            UserType, VideoCaptureParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoCaptureParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::media::VideoCaptureFormat requested_format;
  
  ::media::VideoCaptureBufferType buffer_type;
  
  ::media::ResolutionChangePolicy resolution_change_policy;
  
  ::media::PowerLineFrequency power_line_frequency;
  
  bool enable_face_detection;
  
  bool is_high_dpi_enabled;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoCaptureParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoCaptureParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoCaptureParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoCaptureParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT VideoCaptureFeedback {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoCaptureFeedback, T>::value>;
  using DataView = VideoCaptureFeedbackDataView;
  using Data_ = internal::VideoCaptureFeedback_Data;

  template <typename... Args>
  static VideoCaptureFeedbackPtr New(Args&&... args) {
    return VideoCaptureFeedbackPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoCaptureFeedbackPtr From(const U& u) {
    return mojo::TypeConverter<VideoCaptureFeedbackPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoCaptureFeedback>::Convert(*this);
  }


  VideoCaptureFeedback();

  VideoCaptureFeedback(
      double resource_utilization,
      float max_framerate_fps,
      int32_t max_pixels,
      bool require_mapped_frame);

  VideoCaptureFeedback(
      double resource_utilization,
      float max_framerate_fps,
      int32_t max_pixels,
      bool require_mapped_frame,
      std::optional<::blink::Vector<::gfx::Size>> DEPRECATED_mapped_sizes);

  VideoCaptureFeedback(
      double resource_utilization,
      float max_framerate_fps,
      int32_t max_pixels,
      bool require_mapped_frame,
      std::optional<::blink::Vector<::gfx::Size>> DEPRECATED_mapped_sizes,
      int32_t frame_id,
      bool has_frame_id);


  ~VideoCaptureFeedback();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoCaptureFeedbackPtr>
  VideoCaptureFeedbackPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoCaptureFeedback::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VideoCaptureFeedback::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VideoCaptureFeedback::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoCaptureFeedback::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoCaptureFeedback::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoCaptureFeedback::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoCaptureFeedback_UnserializedMessageContext<
            UserType, VideoCaptureFeedback::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VideoCaptureFeedback::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VideoCaptureFeedback::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoCaptureFeedback_UnserializedMessageContext<
            UserType, VideoCaptureFeedback::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoCaptureFeedback::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  double resource_utilization;
  
  float max_framerate_fps;
  
  int32_t max_pixels;
  
  bool require_mapped_frame;
  
  std::optional<::blink::Vector<::gfx::Size>> DEPRECATED_mapped_sizes;
  
  int32_t frame_id;
  
  bool has_frame_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoCaptureFeedback::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoCaptureFeedback::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoCaptureFeedback::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoCaptureFeedback::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT PlaneStrides {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PlaneStrides, T>::value>;
  using DataView = PlaneStridesDataView;
  using Data_ = internal::PlaneStrides_Data;

  template <typename... Args>
  static PlaneStridesPtr New(Args&&... args) {
    return PlaneStridesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PlaneStridesPtr From(const U& u) {
    return mojo::TypeConverter<PlaneStridesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PlaneStrides>::Convert(*this);
  }


  PlaneStrides();

  explicit PlaneStrides(
      ::blink::Vector<uint32_t> stride_by_plane);


  ~PlaneStrides();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PlaneStridesPtr>
  PlaneStridesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PlaneStrides::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PlaneStrides::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PlaneStrides::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PlaneStrides::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PlaneStrides::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PlaneStrides::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PlaneStrides_UnserializedMessageContext<
            UserType, PlaneStrides::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PlaneStrides::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PlaneStrides::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PlaneStrides_UnserializedMessageContext<
            UserType, PlaneStrides::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PlaneStrides::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<uint32_t> stride_by_plane;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PlaneStrides::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PlaneStrides::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PlaneStrides::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PlaneStrides::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT VideoCaptureDeviceDescriptor {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoCaptureDeviceDescriptor, T>::value>;
  using DataView = VideoCaptureDeviceDescriptorDataView;
  using Data_ = internal::VideoCaptureDeviceDescriptor_Data;

  template <typename... Args>
  static VideoCaptureDeviceDescriptorPtr New(Args&&... args) {
    return VideoCaptureDeviceDescriptorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoCaptureDeviceDescriptorPtr From(const U& u) {
    return mojo::TypeConverter<VideoCaptureDeviceDescriptorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoCaptureDeviceDescriptor>::Convert(*this);
  }


  VideoCaptureDeviceDescriptor();

  VideoCaptureDeviceDescriptor(
      const ::blink::String& display_name,
      const ::blink::String& device_id,
      const ::blink::String& model_id,
      ::media::VideoFacingMode facing_mode,
      VideoCaptureApi capture_api,
      const ::media::VideoCaptureControlSupport& control_support,
      VideoCaptureTransportType transport_type);

  VideoCaptureDeviceDescriptor(
      const ::blink::String& display_name,
      const ::blink::String& device_id,
      const ::blink::String& model_id,
      ::media::VideoFacingMode facing_mode,
      VideoCaptureApi capture_api,
      const ::media::VideoCaptureControlSupport& control_support,
      VideoCaptureTransportType transport_type,
      std::optional<CameraAvailability> availability);


  ~VideoCaptureDeviceDescriptor();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoCaptureDeviceDescriptorPtr>
  VideoCaptureDeviceDescriptorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoCaptureDeviceDescriptor::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VideoCaptureDeviceDescriptor::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VideoCaptureDeviceDescriptor::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoCaptureDeviceDescriptor::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoCaptureDeviceDescriptor::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoCaptureDeviceDescriptor::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoCaptureDeviceDescriptor_UnserializedMessageContext<
            UserType, VideoCaptureDeviceDescriptor::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VideoCaptureDeviceDescriptor::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VideoCaptureDeviceDescriptor::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoCaptureDeviceDescriptor_UnserializedMessageContext<
            UserType, VideoCaptureDeviceDescriptor::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoCaptureDeviceDescriptor::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String display_name;
  
  ::blink::String device_id;
  
  ::blink::String model_id;
  
  ::media::VideoFacingMode facing_mode;
  
  VideoCaptureApi capture_api;
  
  ::media::VideoCaptureControlSupport control_support;
  
  VideoCaptureTransportType transport_type;
  
  std::optional<CameraAvailability> availability;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoCaptureDeviceDescriptor::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoCaptureDeviceDescriptor::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoCaptureDeviceDescriptor::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoCaptureDeviceDescriptor::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT VideoCaptureDeviceInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoCaptureDeviceInfo, T>::value>;
  using DataView = VideoCaptureDeviceInfoDataView;
  using Data_ = internal::VideoCaptureDeviceInfo_Data;

  template <typename... Args>
  static VideoCaptureDeviceInfoPtr New(Args&&... args) {
    return VideoCaptureDeviceInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoCaptureDeviceInfoPtr From(const U& u) {
    return mojo::TypeConverter<VideoCaptureDeviceInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoCaptureDeviceInfo>::Convert(*this);
  }


  VideoCaptureDeviceInfo();

  VideoCaptureDeviceInfo(
      const ::media::VideoCaptureDeviceDescriptor& descriptor,
      ::blink::Vector<::media::VideoCaptureFormat> supported_formats);


  ~VideoCaptureDeviceInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoCaptureDeviceInfoPtr>
  VideoCaptureDeviceInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoCaptureDeviceInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VideoCaptureDeviceInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VideoCaptureDeviceInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoCaptureDeviceInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoCaptureDeviceInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoCaptureDeviceInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoCaptureDeviceInfo_UnserializedMessageContext<
            UserType, VideoCaptureDeviceInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VideoCaptureDeviceInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VideoCaptureDeviceInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoCaptureDeviceInfo_UnserializedMessageContext<
            UserType, VideoCaptureDeviceInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoCaptureDeviceInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::media::VideoCaptureDeviceDescriptor descriptor;
  
  ::blink::Vector<::media::VideoCaptureFormat> supported_formats;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoCaptureDeviceInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoCaptureDeviceInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoCaptureDeviceInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoCaptureDeviceInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
VideoCaptureControlSupportPtr VideoCaptureControlSupport::Clone() const {
  return New(
      mojo::Clone(pan),
      mojo::Clone(tilt),
      mojo::Clone(zoom)
  );
}

template <typename T, VideoCaptureControlSupport::EnableIfSame<T>*>
bool VideoCaptureControlSupport::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->pan, other_struct.pan))
    return false;
  if (!mojo::Equals(this->tilt, other_struct.tilt))
    return false;
  if (!mojo::Equals(this->zoom, other_struct.zoom))
    return false;
  return true;
}

template <typename T, VideoCaptureControlSupport::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.pan < rhs.pan)
    return true;
  if (rhs.pan < lhs.pan)
    return false;
  if (lhs.tilt < rhs.tilt)
    return true;
  if (rhs.tilt < lhs.tilt)
    return false;
  if (lhs.zoom < rhs.zoom)
    return true;
  if (rhs.zoom < lhs.zoom)
    return false;
  return false;
}
template <typename StructPtrType>
VideoCaptureFormatPtr VideoCaptureFormat::Clone() const {
  return New(
      mojo::Clone(frame_size),
      mojo::Clone(frame_rate),
      mojo::Clone(pixel_format)
  );
}

template <typename T, VideoCaptureFormat::EnableIfSame<T>*>
bool VideoCaptureFormat::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->frame_size, other_struct.frame_size))
    return false;
  if (!mojo::Equals(this->frame_rate, other_struct.frame_rate))
    return false;
  if (!mojo::Equals(this->pixel_format, other_struct.pixel_format))
    return false;
  return true;
}

template <typename T, VideoCaptureFormat::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.frame_size < rhs.frame_size)
    return true;
  if (rhs.frame_size < lhs.frame_size)
    return false;
  if (lhs.frame_rate < rhs.frame_rate)
    return true;
  if (rhs.frame_rate < lhs.frame_rate)
    return false;
  if (lhs.pixel_format < rhs.pixel_format)
    return true;
  if (rhs.pixel_format < lhs.pixel_format)
    return false;
  return false;
}
template <typename StructPtrType>
VideoCaptureParamsPtr VideoCaptureParams::Clone() const {
  return New(
      mojo::Clone(requested_format),
      mojo::Clone(buffer_type),
      mojo::Clone(resolution_change_policy),
      mojo::Clone(power_line_frequency),
      mojo::Clone(enable_face_detection),
      mojo::Clone(is_high_dpi_enabled)
  );
}

template <typename T, VideoCaptureParams::EnableIfSame<T>*>
bool VideoCaptureParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->requested_format, other_struct.requested_format))
    return false;
  if (!mojo::Equals(this->buffer_type, other_struct.buffer_type))
    return false;
  if (!mojo::Equals(this->resolution_change_policy, other_struct.resolution_change_policy))
    return false;
  if (!mojo::Equals(this->power_line_frequency, other_struct.power_line_frequency))
    return false;
  if (!mojo::Equals(this->enable_face_detection, other_struct.enable_face_detection))
    return false;
  if (!mojo::Equals(this->is_high_dpi_enabled, other_struct.is_high_dpi_enabled))
    return false;
  return true;
}

template <typename T, VideoCaptureParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.requested_format < rhs.requested_format)
    return true;
  if (rhs.requested_format < lhs.requested_format)
    return false;
  if (lhs.buffer_type < rhs.buffer_type)
    return true;
  if (rhs.buffer_type < lhs.buffer_type)
    return false;
  if (lhs.resolution_change_policy < rhs.resolution_change_policy)
    return true;
  if (rhs.resolution_change_policy < lhs.resolution_change_policy)
    return false;
  if (lhs.power_line_frequency < rhs.power_line_frequency)
    return true;
  if (rhs.power_line_frequency < lhs.power_line_frequency)
    return false;
  if (lhs.enable_face_detection < rhs.enable_face_detection)
    return true;
  if (rhs.enable_face_detection < lhs.enable_face_detection)
    return false;
  if (lhs.is_high_dpi_enabled < rhs.is_high_dpi_enabled)
    return true;
  if (rhs.is_high_dpi_enabled < lhs.is_high_dpi_enabled)
    return false;
  return false;
}
template <typename StructPtrType>
VideoCaptureFeedbackPtr VideoCaptureFeedback::Clone() const {
  return New(
      mojo::Clone(resource_utilization),
      mojo::Clone(max_framerate_fps),
      mojo::Clone(max_pixels),
      mojo::Clone(require_mapped_frame),
      mojo::Clone(DEPRECATED_mapped_sizes),
      mojo::Clone(frame_id),
      mojo::Clone(has_frame_id)
  );
}

template <typename T, VideoCaptureFeedback::EnableIfSame<T>*>
bool VideoCaptureFeedback::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->resource_utilization, other_struct.resource_utilization))
    return false;
  if (!mojo::Equals(this->max_framerate_fps, other_struct.max_framerate_fps))
    return false;
  if (!mojo::Equals(this->max_pixels, other_struct.max_pixels))
    return false;
  if (!mojo::Equals(this->require_mapped_frame, other_struct.require_mapped_frame))
    return false;
  if (!mojo::Equals(this->DEPRECATED_mapped_sizes, other_struct.DEPRECATED_mapped_sizes))
    return false;
  if (!mojo::Equals(this->frame_id, other_struct.frame_id))
    return false;
  if (!mojo::Equals(this->has_frame_id, other_struct.has_frame_id))
    return false;
  return true;
}

template <typename T, VideoCaptureFeedback::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.resource_utilization < rhs.resource_utilization)
    return true;
  if (rhs.resource_utilization < lhs.resource_utilization)
    return false;
  if (lhs.max_framerate_fps < rhs.max_framerate_fps)
    return true;
  if (rhs.max_framerate_fps < lhs.max_framerate_fps)
    return false;
  if (lhs.max_pixels < rhs.max_pixels)
    return true;
  if (rhs.max_pixels < lhs.max_pixels)
    return false;
  if (lhs.require_mapped_frame < rhs.require_mapped_frame)
    return true;
  if (rhs.require_mapped_frame < lhs.require_mapped_frame)
    return false;
  if (lhs.DEPRECATED_mapped_sizes < rhs.DEPRECATED_mapped_sizes)
    return true;
  if (rhs.DEPRECATED_mapped_sizes < lhs.DEPRECATED_mapped_sizes)
    return false;
  if (lhs.frame_id < rhs.frame_id)
    return true;
  if (rhs.frame_id < lhs.frame_id)
    return false;
  if (lhs.has_frame_id < rhs.has_frame_id)
    return true;
  if (rhs.has_frame_id < lhs.has_frame_id)
    return false;
  return false;
}
template <typename StructPtrType>
PlaneStridesPtr PlaneStrides::Clone() const {
  return New(
      mojo::Clone(stride_by_plane)
  );
}

template <typename T, PlaneStrides::EnableIfSame<T>*>
bool PlaneStrides::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->stride_by_plane, other_struct.stride_by_plane))
    return false;
  return true;
}

template <typename T, PlaneStrides::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.stride_by_plane < rhs.stride_by_plane)
    return true;
  if (rhs.stride_by_plane < lhs.stride_by_plane)
    return false;
  return false;
}
template <typename StructPtrType>
VideoCaptureDeviceDescriptorPtr VideoCaptureDeviceDescriptor::Clone() const {
  return New(
      mojo::Clone(display_name),
      mojo::Clone(device_id),
      mojo::Clone(model_id),
      mojo::Clone(facing_mode),
      mojo::Clone(capture_api),
      mojo::Clone(control_support),
      mojo::Clone(transport_type),
      mojo::Clone(availability)
  );
}

template <typename T, VideoCaptureDeviceDescriptor::EnableIfSame<T>*>
bool VideoCaptureDeviceDescriptor::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->display_name, other_struct.display_name))
    return false;
  if (!mojo::Equals(this->device_id, other_struct.device_id))
    return false;
  if (!mojo::Equals(this->model_id, other_struct.model_id))
    return false;
  if (!mojo::Equals(this->facing_mode, other_struct.facing_mode))
    return false;
  if (!mojo::Equals(this->capture_api, other_struct.capture_api))
    return false;
  if (!mojo::Equals(this->control_support, other_struct.control_support))
    return false;
  if (!mojo::Equals(this->transport_type, other_struct.transport_type))
    return false;
  if (!mojo::Equals(this->availability, other_struct.availability))
    return false;
  return true;
}

template <typename T, VideoCaptureDeviceDescriptor::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.display_name < rhs.display_name)
    return true;
  if (rhs.display_name < lhs.display_name)
    return false;
  if (lhs.device_id < rhs.device_id)
    return true;
  if (rhs.device_id < lhs.device_id)
    return false;
  if (lhs.model_id < rhs.model_id)
    return true;
  if (rhs.model_id < lhs.model_id)
    return false;
  if (lhs.facing_mode < rhs.facing_mode)
    return true;
  if (rhs.facing_mode < lhs.facing_mode)
    return false;
  if (lhs.capture_api < rhs.capture_api)
    return true;
  if (rhs.capture_api < lhs.capture_api)
    return false;
  if (lhs.control_support < rhs.control_support)
    return true;
  if (rhs.control_support < lhs.control_support)
    return false;
  if (lhs.transport_type < rhs.transport_type)
    return true;
  if (rhs.transport_type < lhs.transport_type)
    return false;
  if (lhs.availability < rhs.availability)
    return true;
  if (rhs.availability < lhs.availability)
    return false;
  return false;
}
template <typename StructPtrType>
VideoCaptureDeviceInfoPtr VideoCaptureDeviceInfo::Clone() const {
  return New(
      mojo::Clone(descriptor),
      mojo::Clone(supported_formats)
  );
}

template <typename T, VideoCaptureDeviceInfo::EnableIfSame<T>*>
bool VideoCaptureDeviceInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->descriptor, other_struct.descriptor))
    return false;
  if (!mojo::Equals(this->supported_formats, other_struct.supported_formats))
    return false;
  return true;
}

template <typename T, VideoCaptureDeviceInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.descriptor < rhs.descriptor)
    return true;
  if (rhs.descriptor < lhs.descriptor)
    return false;
  if (lhs.supported_formats < rhs.supported_formats)
    return true;
  if (rhs.supported_formats < lhs.supported_formats)
    return false;
  return false;
}


}  // media::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::VideoCaptureControlSupport::DataView,
                                         ::media::mojom::blink::VideoCaptureControlSupportPtr> {
  static bool IsNull(const ::media::mojom::blink::VideoCaptureControlSupportPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::VideoCaptureControlSupportPtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::VideoCaptureControlSupport::pan) pan(
      const ::media::mojom::blink::VideoCaptureControlSupportPtr& input) {
    return input->pan;
  }

  static decltype(::media::mojom::blink::VideoCaptureControlSupport::tilt) tilt(
      const ::media::mojom::blink::VideoCaptureControlSupportPtr& input) {
    return input->tilt;
  }

  static decltype(::media::mojom::blink::VideoCaptureControlSupport::zoom) zoom(
      const ::media::mojom::blink::VideoCaptureControlSupportPtr& input) {
    return input->zoom;
  }

  static bool Read(::media::mojom::blink::VideoCaptureControlSupport::DataView input, ::media::mojom::blink::VideoCaptureControlSupportPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::VideoCaptureFormat::DataView,
                                         ::media::mojom::blink::VideoCaptureFormatPtr> {
  static bool IsNull(const ::media::mojom::blink::VideoCaptureFormatPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::VideoCaptureFormatPtr* output) { output->reset(); }

  static const decltype(::media::mojom::blink::VideoCaptureFormat::frame_size)& frame_size(
      const ::media::mojom::blink::VideoCaptureFormatPtr& input) {
    return input->frame_size;
  }

  static decltype(::media::mojom::blink::VideoCaptureFormat::frame_rate) frame_rate(
      const ::media::mojom::blink::VideoCaptureFormatPtr& input) {
    return input->frame_rate;
  }

  static decltype(::media::mojom::blink::VideoCaptureFormat::pixel_format) pixel_format(
      const ::media::mojom::blink::VideoCaptureFormatPtr& input) {
    return input->pixel_format;
  }

  static bool Read(::media::mojom::blink::VideoCaptureFormat::DataView input, ::media::mojom::blink::VideoCaptureFormatPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::VideoCaptureParams::DataView,
                                         ::media::mojom::blink::VideoCaptureParamsPtr> {
  static bool IsNull(const ::media::mojom::blink::VideoCaptureParamsPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::VideoCaptureParamsPtr* output) { output->reset(); }

  static const decltype(::media::mojom::blink::VideoCaptureParams::requested_format)& requested_format(
      const ::media::mojom::blink::VideoCaptureParamsPtr& input) {
    return input->requested_format;
  }

  static decltype(::media::mojom::blink::VideoCaptureParams::buffer_type) buffer_type(
      const ::media::mojom::blink::VideoCaptureParamsPtr& input) {
    return input->buffer_type;
  }

  static decltype(::media::mojom::blink::VideoCaptureParams::resolution_change_policy) resolution_change_policy(
      const ::media::mojom::blink::VideoCaptureParamsPtr& input) {
    return input->resolution_change_policy;
  }

  static decltype(::media::mojom::blink::VideoCaptureParams::power_line_frequency) power_line_frequency(
      const ::media::mojom::blink::VideoCaptureParamsPtr& input) {
    return input->power_line_frequency;
  }

  static decltype(::media::mojom::blink::VideoCaptureParams::enable_face_detection) enable_face_detection(
      const ::media::mojom::blink::VideoCaptureParamsPtr& input) {
    return input->enable_face_detection;
  }

  static decltype(::media::mojom::blink::VideoCaptureParams::is_high_dpi_enabled) is_high_dpi_enabled(
      const ::media::mojom::blink::VideoCaptureParamsPtr& input) {
    return input->is_high_dpi_enabled;
  }

  static bool Read(::media::mojom::blink::VideoCaptureParams::DataView input, ::media::mojom::blink::VideoCaptureParamsPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::VideoCaptureFeedback::DataView,
                                         ::media::mojom::blink::VideoCaptureFeedbackPtr> {
  static bool IsNull(const ::media::mojom::blink::VideoCaptureFeedbackPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::VideoCaptureFeedbackPtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::VideoCaptureFeedback::resource_utilization) resource_utilization(
      const ::media::mojom::blink::VideoCaptureFeedbackPtr& input) {
    return input->resource_utilization;
  }

  static decltype(::media::mojom::blink::VideoCaptureFeedback::max_framerate_fps) max_framerate_fps(
      const ::media::mojom::blink::VideoCaptureFeedbackPtr& input) {
    return input->max_framerate_fps;
  }

  static decltype(::media::mojom::blink::VideoCaptureFeedback::max_pixels) max_pixels(
      const ::media::mojom::blink::VideoCaptureFeedbackPtr& input) {
    return input->max_pixels;
  }

  static decltype(::media::mojom::blink::VideoCaptureFeedback::require_mapped_frame) require_mapped_frame(
      const ::media::mojom::blink::VideoCaptureFeedbackPtr& input) {
    return input->require_mapped_frame;
  }

  static const decltype(::media::mojom::blink::VideoCaptureFeedback::DEPRECATED_mapped_sizes)& DEPRECATED_mapped_sizes(
      const ::media::mojom::blink::VideoCaptureFeedbackPtr& input) {
    return input->DEPRECATED_mapped_sizes;
  }

  static decltype(::media::mojom::blink::VideoCaptureFeedback::frame_id) frame_id(
      const ::media::mojom::blink::VideoCaptureFeedbackPtr& input) {
    return input->frame_id;
  }

  static decltype(::media::mojom::blink::VideoCaptureFeedback::has_frame_id) has_frame_id(
      const ::media::mojom::blink::VideoCaptureFeedbackPtr& input) {
    return input->has_frame_id;
  }

  static bool Read(::media::mojom::blink::VideoCaptureFeedback::DataView input, ::media::mojom::blink::VideoCaptureFeedbackPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::PlaneStrides::DataView,
                                         ::media::mojom::blink::PlaneStridesPtr> {
  static bool IsNull(const ::media::mojom::blink::PlaneStridesPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::PlaneStridesPtr* output) { output->reset(); }

  static const decltype(::media::mojom::blink::PlaneStrides::stride_by_plane)& stride_by_plane(
      const ::media::mojom::blink::PlaneStridesPtr& input) {
    return input->stride_by_plane;
  }

  static bool Read(::media::mojom::blink::PlaneStrides::DataView input, ::media::mojom::blink::PlaneStridesPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::VideoCaptureDeviceDescriptor::DataView,
                                         ::media::mojom::blink::VideoCaptureDeviceDescriptorPtr> {
  static bool IsNull(const ::media::mojom::blink::VideoCaptureDeviceDescriptorPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::VideoCaptureDeviceDescriptorPtr* output) { output->reset(); }

  static const decltype(::media::mojom::blink::VideoCaptureDeviceDescriptor::display_name)& display_name(
      const ::media::mojom::blink::VideoCaptureDeviceDescriptorPtr& input) {
    return input->display_name;
  }

  static const decltype(::media::mojom::blink::VideoCaptureDeviceDescriptor::device_id)& device_id(
      const ::media::mojom::blink::VideoCaptureDeviceDescriptorPtr& input) {
    return input->device_id;
  }

  static const decltype(::media::mojom::blink::VideoCaptureDeviceDescriptor::model_id)& model_id(
      const ::media::mojom::blink::VideoCaptureDeviceDescriptorPtr& input) {
    return input->model_id;
  }

  static decltype(::media::mojom::blink::VideoCaptureDeviceDescriptor::facing_mode) facing_mode(
      const ::media::mojom::blink::VideoCaptureDeviceDescriptorPtr& input) {
    return input->facing_mode;
  }

  static decltype(::media::mojom::blink::VideoCaptureDeviceDescriptor::capture_api) capture_api(
      const ::media::mojom::blink::VideoCaptureDeviceDescriptorPtr& input) {
    return input->capture_api;
  }

  static const decltype(::media::mojom::blink::VideoCaptureDeviceDescriptor::control_support)& control_support(
      const ::media::mojom::blink::VideoCaptureDeviceDescriptorPtr& input) {
    return input->control_support;
  }

  static decltype(::media::mojom::blink::VideoCaptureDeviceDescriptor::transport_type) transport_type(
      const ::media::mojom::blink::VideoCaptureDeviceDescriptorPtr& input) {
    return input->transport_type;
  }

  static decltype(::media::mojom::blink::VideoCaptureDeviceDescriptor::availability) availability(
      const ::media::mojom::blink::VideoCaptureDeviceDescriptorPtr& input) {
    return input->availability;
  }

  static bool Read(::media::mojom::blink::VideoCaptureDeviceDescriptor::DataView input, ::media::mojom::blink::VideoCaptureDeviceDescriptorPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::VideoCaptureDeviceInfo::DataView,
                                         ::media::mojom::blink::VideoCaptureDeviceInfoPtr> {
  static bool IsNull(const ::media::mojom::blink::VideoCaptureDeviceInfoPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::VideoCaptureDeviceInfoPtr* output) { output->reset(); }

  static const decltype(::media::mojom::blink::VideoCaptureDeviceInfo::descriptor)& descriptor(
      const ::media::mojom::blink::VideoCaptureDeviceInfoPtr& input) {
    return input->descriptor;
  }

  static const decltype(::media::mojom::blink::VideoCaptureDeviceInfo::supported_formats)& supported_formats(
      const ::media::mojom::blink::VideoCaptureDeviceInfoPtr& input) {
    return input->supported_formats;
  }

  static bool Read(::media::mojom::blink::VideoCaptureDeviceInfo::DataView input, ::media::mojom::blink::VideoCaptureDeviceInfoPtr* output);
};

}  // namespace mojo

#endif  // MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_TYPES_MOJOM_BLINK_H_