// media/mojo/mojom/speech_recognition.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_MOJOM_BLINK_H_
#define MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/speech_recognition.mojom-features.h"  // IWYU pragma: export
#include "media/mojo/mojom/speech_recognition.mojom-shared.h"  // IWYU pragma: export
#include "media/mojo/mojom/speech_recognition.mojom-blink-forward.h"  // IWYU pragma: export
#include "media/mojo/mojom/audio_data.mojom-blink-forward.h"
#include "media/mojo/mojom/speech_recognition_audio_forwarder.mojom-blink-forward.h"
#include "media/mojo/mojom/speech_recognition_recognition_context.mojom-blink.h"
#include "media/mojo/mojom/speech_recognizer.mojom-blink-forward.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-blink-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace media::mojom::blink {

class SpeechRecognitionContextProxy;

template <typename ImplRefTraits>
class SpeechRecognitionContextStub;

class SpeechRecognitionContextRequestValidator;
class SpeechRecognitionContextResponseValidator;


class SpeechRecognitionContext
    : public SpeechRecognitionContextInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.SpeechRecognitionContext";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 6;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SpeechRecognitionContextInterfaceBase;
  using Proxy_ = SpeechRecognitionContextProxy;

  template <typename ImplRefTraits>
  using Stub_ = SpeechRecognitionContextStub<ImplRefTraits>;

  using RequestValidator_ = SpeechRecognitionContextRequestValidator;
  using ResponseValidator_ = SpeechRecognitionContextResponseValidator;
  enum MethodMinVersions : uint32_t {
    kBindRecognizerMinVersion = 0,
    kBindWebSpeechRecognizerMinVersion = 6,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct BindRecognizer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindWebSpeechRecognizer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SpeechRecognitionContext() = default;

  using BindRecognizerCallback = base::OnceCallback<void(bool)>;
  using BindRecognizerMojoCallback = base::OnceCallback<void(bool)>;

  virtual void BindRecognizer(::mojo::PendingReceiver<SpeechRecognitionRecognizer> receiver, ::mojo::PendingRemote<SpeechRecognitionRecognizerClient> client, SpeechRecognitionOptionsPtr options, BindRecognizerCallback callback) = 0;

  virtual void BindWebSpeechRecognizer(::mojo::PendingReceiver<::media::mojom::blink::SpeechRecognitionSession> session_receiver, ::mojo::PendingRemote<::media::mojom::blink::SpeechRecognitionSessionClient> session_client, ::mojo::PendingReceiver<::media::mojom::blink::SpeechRecognitionAudioForwarder> audio_forwarder, int32_t channel_count, int32_t sample_rate, SpeechRecognitionOptionsPtr options, bool continuous) = 0;
};

class SpeechRecognitionRecognizerProxy;

template <typename ImplRefTraits>
class SpeechRecognitionRecognizerStub;

class SpeechRecognitionRecognizerRequestValidator;


class SpeechRecognitionRecognizer
    : public SpeechRecognitionRecognizerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.SpeechRecognitionRecognizer";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 10;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SpeechRecognitionRecognizerInterfaceBase;
  using Proxy_ = SpeechRecognitionRecognizerProxy;

  template <typename ImplRefTraits>
  using Stub_ = SpeechRecognitionRecognizerStub<ImplRefTraits>;

  using RequestValidator_ = SpeechRecognitionRecognizerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSendAudioToSpeechRecognitionServiceMinVersion = 0,
    kMarkDoneMinVersion = 0,
    kOnLanguageChangedMinVersion = 0,
    kOnMaskOffensiveWordsChangedMinVersion = 2,
    kUpdateRecognitionContextMinVersion = 8,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SendAudioToSpeechRecognitionService_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MarkDone_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnLanguageChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnMaskOffensiveWordsChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateRecognitionContext_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SpeechRecognitionRecognizer() = default;

  virtual void SendAudioToSpeechRecognitionService(::media::mojom::blink::AudioDataS16Ptr buffer, std::optional<::base::TimeDelta> media_start_pts) = 0;

  virtual void MarkDone() = 0;

  virtual void OnLanguageChanged(const ::blink::String& language) = 0;

  virtual void OnMaskOffensiveWordsChanged(bool mask_offensive_words) = 0;

  virtual void UpdateRecognitionContext(::media::mojom::blink::SpeechRecognitionRecognitionContextPtr recognition_context) = 0;
};

class SpeechRecognitionRecognizerClientProxy;

template <typename ImplRefTraits>
class SpeechRecognitionRecognizerClientStub;

class SpeechRecognitionRecognizerClientRequestValidator;
class SpeechRecognitionRecognizerClientResponseValidator;


class SpeechRecognitionRecognizerClient
    : public SpeechRecognitionRecognizerClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.SpeechRecognitionRecognizerClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SpeechRecognitionRecognizerClientInterfaceBase;
  using Proxy_ = SpeechRecognitionRecognizerClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = SpeechRecognitionRecognizerClientStub<ImplRefTraits>;

  using RequestValidator_ = SpeechRecognitionRecognizerClientRequestValidator;
  using ResponseValidator_ = SpeechRecognitionRecognizerClientResponseValidator;
  enum MethodMinVersions : uint32_t {
    kOnSpeechRecognitionRecognitionEventMinVersion = 0,
    kOnSpeechRecognitionStoppedMinVersion = 0,
    kOnSpeechRecognitionErrorMinVersion = 0,
    kOnLanguageIdentificationEventMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnSpeechRecognitionRecognitionEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnSpeechRecognitionStopped_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnSpeechRecognitionError_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnLanguageIdentificationEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SpeechRecognitionRecognizerClient() = default;

  using OnSpeechRecognitionRecognitionEventCallback = base::OnceCallback<void(bool)>;
  using OnSpeechRecognitionRecognitionEventMojoCallback = base::OnceCallback<void(bool)>;

  virtual void OnSpeechRecognitionRecognitionEvent(SpeechRecognitionResultPtr result, OnSpeechRecognitionRecognitionEventCallback callback) = 0;

  virtual void OnSpeechRecognitionStopped() = 0;

  virtual void OnSpeechRecognitionError() = 0;

  virtual void OnLanguageIdentificationEvent(LanguageIdentificationEventPtr event) = 0;
};

class SpeechRecognitionBrowserObserverProxy;

template <typename ImplRefTraits>
class SpeechRecognitionBrowserObserverStub;

class SpeechRecognitionBrowserObserverRequestValidator;


class SpeechRecognitionBrowserObserver
    : public SpeechRecognitionBrowserObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.SpeechRecognitionBrowserObserver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 2;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SpeechRecognitionBrowserObserverInterfaceBase;
  using Proxy_ = SpeechRecognitionBrowserObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = SpeechRecognitionBrowserObserverStub<ImplRefTraits>;

  using RequestValidator_ = SpeechRecognitionBrowserObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSpeechRecognitionAvailabilityChangedMinVersion = 0,
    kSpeechRecognitionLanguageChangedMinVersion = 0,
    kSpeechRecognitionMaskOffensiveWordsChangedMinVersion = 2,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SpeechRecognitionAvailabilityChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SpeechRecognitionLanguageChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SpeechRecognitionMaskOffensiveWordsChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SpeechRecognitionBrowserObserver() = default;

  virtual void SpeechRecognitionAvailabilityChanged(bool is_speech_recognition_available) = 0;

  virtual void SpeechRecognitionLanguageChanged(const ::blink::String& language) = 0;

  virtual void SpeechRecognitionMaskOffensiveWordsChanged(bool mask_offensive_words) = 0;
};

class SpeechRecognitionSurfaceProxy;

template <typename ImplRefTraits>
class SpeechRecognitionSurfaceStub;

class SpeechRecognitionSurfaceRequestValidator;
class SpeechRecognitionSurfaceResponseValidator;


class SpeechRecognitionSurface
    : public SpeechRecognitionSurfaceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.SpeechRecognitionSurface";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SpeechRecognitionSurfaceInterfaceBase;
  using Proxy_ = SpeechRecognitionSurfaceProxy;

  template <typename ImplRefTraits>
  using Stub_ = SpeechRecognitionSurfaceStub<ImplRefTraits>;

  using RequestValidator_ = SpeechRecognitionSurfaceRequestValidator;
  using ResponseValidator_ = SpeechRecognitionSurfaceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kActivateMinVersion = 0,
    kGetBoundsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Activate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetBounds_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SpeechRecognitionSurface() = default;

  virtual void Activate() = 0;

  using GetBoundsCallback = base::OnceCallback<void(const std::optional<::gfx::Rect>&)>;
  using GetBoundsMojoCallback = base::OnceCallback<void(const std::optional<::gfx::Rect>&)>;

  virtual void GetBounds(GetBoundsCallback callback) = 0;
};

class SpeechRecognitionSurfaceClientProxy;

template <typename ImplRefTraits>
class SpeechRecognitionSurfaceClientStub;

class SpeechRecognitionSurfaceClientRequestValidator;


class SpeechRecognitionSurfaceClient
    : public SpeechRecognitionSurfaceClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.SpeechRecognitionSurfaceClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SpeechRecognitionSurfaceClientInterfaceBase;
  using Proxy_ = SpeechRecognitionSurfaceClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = SpeechRecognitionSurfaceClientStub<ImplRefTraits>;

  using RequestValidator_ = SpeechRecognitionSurfaceClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnSessionEndedMinVersion = 0,
    kOnFullscreenToggledMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnSessionEnded_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnFullscreenToggled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SpeechRecognitionSurfaceClient() = default;

  virtual void OnSessionEnded() = 0;

  virtual void OnFullscreenToggled() = 0;
};

class SpeechRecognitionClientBrowserInterfaceProxy;

template <typename ImplRefTraits>
class SpeechRecognitionClientBrowserInterfaceStub;

class SpeechRecognitionClientBrowserInterfaceRequestValidator;


class SpeechRecognitionClientBrowserInterface
    : public SpeechRecognitionClientBrowserInterfaceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.SpeechRecognitionClientBrowserInterface";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 1;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SpeechRecognitionClientBrowserInterfaceInterfaceBase;
  using Proxy_ = SpeechRecognitionClientBrowserInterfaceProxy;

  template <typename ImplRefTraits>
  using Stub_ = SpeechRecognitionClientBrowserInterfaceStub<ImplRefTraits>;

  using RequestValidator_ = SpeechRecognitionClientBrowserInterfaceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kBindSpeechRecognitionBrowserObserverMinVersion = 0,
    kREMOVED_1MinVersion = 1,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct BindSpeechRecognitionBrowserObserver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct REMOVED_1_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SpeechRecognitionClientBrowserInterface() = default;

  virtual void BindSpeechRecognitionBrowserObserver(::mojo::PendingRemote<SpeechRecognitionBrowserObserver> observer) = 0;

  virtual void REMOVED_1() = 0;
};



class  SpeechRecognitionContextProxy
    : public SpeechRecognitionContext {
 public:
  using InterfaceType = SpeechRecognitionContext;

  explicit SpeechRecognitionContextProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BindRecognizer(::mojo::PendingReceiver<SpeechRecognitionRecognizer> receiver, ::mojo::PendingRemote<SpeechRecognitionRecognizerClient> client, SpeechRecognitionOptionsPtr options, BindRecognizerCallback callback) final;
  
  void BindWebSpeechRecognizer(::mojo::PendingReceiver<::media::mojom::blink::SpeechRecognitionSession> session_receiver, ::mojo::PendingRemote<::media::mojom::blink::SpeechRecognitionSessionClient> session_client, ::mojo::PendingReceiver<::media::mojom::blink::SpeechRecognitionAudioForwarder> audio_forwarder, int32_t channel_count, int32_t sample_rate, SpeechRecognitionOptionsPtr options, bool continuous) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  SpeechRecognitionRecognizerProxy
    : public SpeechRecognitionRecognizer {
 public:
  using InterfaceType = SpeechRecognitionRecognizer;

  explicit SpeechRecognitionRecognizerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SendAudioToSpeechRecognitionService(::media::mojom::blink::AudioDataS16Ptr buffer, std::optional<::base::TimeDelta> media_start_pts) final;
  
  void MarkDone() final;
  
  void OnLanguageChanged(const ::blink::String& language) final;
  
  void OnMaskOffensiveWordsChanged(bool mask_offensive_words) final;
  
  void UpdateRecognitionContext(::media::mojom::blink::SpeechRecognitionRecognitionContextPtr recognition_context) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  SpeechRecognitionRecognizerClientProxy
    : public SpeechRecognitionRecognizerClient {
 public:
  using InterfaceType = SpeechRecognitionRecognizerClient;

  explicit SpeechRecognitionRecognizerClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnSpeechRecognitionRecognitionEvent(SpeechRecognitionResultPtr result, OnSpeechRecognitionRecognitionEventCallback callback) final;
  
  void OnSpeechRecognitionStopped() final;
  
  void OnSpeechRecognitionError() final;
  
  void OnLanguageIdentificationEvent(LanguageIdentificationEventPtr event) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  SpeechRecognitionBrowserObserverProxy
    : public SpeechRecognitionBrowserObserver {
 public:
  using InterfaceType = SpeechRecognitionBrowserObserver;

  explicit SpeechRecognitionBrowserObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SpeechRecognitionAvailabilityChanged(bool is_speech_recognition_available) final;
  
  void SpeechRecognitionLanguageChanged(const ::blink::String& language) final;
  
  void SpeechRecognitionMaskOffensiveWordsChanged(bool mask_offensive_words) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  SpeechRecognitionSurfaceProxy
    : public SpeechRecognitionSurface {
 public:
  using InterfaceType = SpeechRecognitionSurface;

  explicit SpeechRecognitionSurfaceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Activate() final;
  
  void GetBounds(GetBoundsCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  SpeechRecognitionSurfaceClientProxy
    : public SpeechRecognitionSurfaceClient {
 public:
  using InterfaceType = SpeechRecognitionSurfaceClient;

  explicit SpeechRecognitionSurfaceClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnSessionEnded() final;
  
  void OnFullscreenToggled() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  SpeechRecognitionClientBrowserInterfaceProxy
    : public SpeechRecognitionClientBrowserInterface {
 public:
  using InterfaceType = SpeechRecognitionClientBrowserInterface;

  explicit SpeechRecognitionClientBrowserInterfaceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BindSpeechRecognitionBrowserObserver(::mojo::PendingRemote<SpeechRecognitionBrowserObserver> observer) final;
  
  void REMOVED_1() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  SpeechRecognitionContextStubDispatch {
 public:
  static bool Accept(SpeechRecognitionContext* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SpeechRecognitionContext* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SpeechRecognitionContext>>
class SpeechRecognitionContextStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SpeechRecognitionContextStub() = default;
  ~SpeechRecognitionContextStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechRecognitionContextStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechRecognitionContextStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SpeechRecognitionRecognizerStubDispatch {
 public:
  static bool Accept(SpeechRecognitionRecognizer* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SpeechRecognitionRecognizer* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SpeechRecognitionRecognizer>>
class SpeechRecognitionRecognizerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SpeechRecognitionRecognizerStub() = default;
  ~SpeechRecognitionRecognizerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechRecognitionRecognizerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechRecognitionRecognizerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SpeechRecognitionRecognizerClientStubDispatch {
 public:
  static bool Accept(SpeechRecognitionRecognizerClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SpeechRecognitionRecognizerClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SpeechRecognitionRecognizerClient>>
class SpeechRecognitionRecognizerClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SpeechRecognitionRecognizerClientStub() = default;
  ~SpeechRecognitionRecognizerClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechRecognitionRecognizerClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechRecognitionRecognizerClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SpeechRecognitionBrowserObserverStubDispatch {
 public:
  static bool Accept(SpeechRecognitionBrowserObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SpeechRecognitionBrowserObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SpeechRecognitionBrowserObserver>>
class SpeechRecognitionBrowserObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SpeechRecognitionBrowserObserverStub() = default;
  ~SpeechRecognitionBrowserObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechRecognitionBrowserObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechRecognitionBrowserObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SpeechRecognitionSurfaceStubDispatch {
 public:
  static bool Accept(SpeechRecognitionSurface* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SpeechRecognitionSurface* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SpeechRecognitionSurface>>
class SpeechRecognitionSurfaceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SpeechRecognitionSurfaceStub() = default;
  ~SpeechRecognitionSurfaceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechRecognitionSurfaceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechRecognitionSurfaceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SpeechRecognitionSurfaceClientStubDispatch {
 public:
  static bool Accept(SpeechRecognitionSurfaceClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SpeechRecognitionSurfaceClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SpeechRecognitionSurfaceClient>>
class SpeechRecognitionSurfaceClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SpeechRecognitionSurfaceClientStub() = default;
  ~SpeechRecognitionSurfaceClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechRecognitionSurfaceClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechRecognitionSurfaceClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SpeechRecognitionClientBrowserInterfaceStubDispatch {
 public:
  static bool Accept(SpeechRecognitionClientBrowserInterface* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SpeechRecognitionClientBrowserInterface* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SpeechRecognitionClientBrowserInterface>>
class SpeechRecognitionClientBrowserInterfaceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SpeechRecognitionClientBrowserInterfaceStub() = default;
  ~SpeechRecognitionClientBrowserInterfaceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechRecognitionClientBrowserInterfaceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechRecognitionClientBrowserInterfaceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SpeechRecognitionContextRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SpeechRecognitionRecognizerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SpeechRecognitionRecognizerClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SpeechRecognitionBrowserObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SpeechRecognitionSurfaceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SpeechRecognitionSurfaceClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SpeechRecognitionClientBrowserInterfaceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SpeechRecognitionContextResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SpeechRecognitionRecognizerClientResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SpeechRecognitionSurfaceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class  LanguageIdentificationEvent {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LanguageIdentificationEvent, T>::value>;
  using DataView = LanguageIdentificationEventDataView;
  using Data_ = internal::LanguageIdentificationEvent_Data;

  template <typename... Args>
  static LanguageIdentificationEventPtr New(Args&&... args) {
    return LanguageIdentificationEventPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LanguageIdentificationEventPtr From(const U& u) {
    return mojo::TypeConverter<LanguageIdentificationEventPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LanguageIdentificationEvent>::Convert(*this);
  }


  LanguageIdentificationEvent();

  LanguageIdentificationEvent(
      const ::blink::String& language,
      ConfidenceLevel confidence_level);

  LanguageIdentificationEvent(
      const ::blink::String& language,
      ConfidenceLevel confidence_level,
      std::optional<AsrSwitchResult> asr_switch_result);


  ~LanguageIdentificationEvent();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LanguageIdentificationEventPtr>
  LanguageIdentificationEventPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LanguageIdentificationEvent::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LanguageIdentificationEvent::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LanguageIdentificationEvent::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LanguageIdentificationEvent::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LanguageIdentificationEvent::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LanguageIdentificationEvent::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LanguageIdentificationEvent_UnserializedMessageContext<
            UserType, LanguageIdentificationEvent::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LanguageIdentificationEvent::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LanguageIdentificationEvent::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LanguageIdentificationEvent_UnserializedMessageContext<
            UserType, LanguageIdentificationEvent::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LanguageIdentificationEvent::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String language;
  
  ConfidenceLevel confidence_level;
  
  std::optional<AsrSwitchResult> asr_switch_result;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LanguageIdentificationEvent::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LanguageIdentificationEvent::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LanguageIdentificationEvent::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LanguageIdentificationEvent::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class  HypothesisParts {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HypothesisParts, T>::value>;
  using DataView = HypothesisPartsDataView;
  using Data_ = internal::HypothesisParts_Data;

  template <typename... Args>
  static HypothesisPartsPtr New(Args&&... args) {
    return HypothesisPartsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HypothesisPartsPtr From(const U& u) {
    return mojo::TypeConverter<HypothesisPartsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HypothesisParts>::Convert(*this);
  }


  HypothesisParts();

  HypothesisParts(
      ::blink::Vector<::blink::String> text,
      ::base::TimeDelta hypothesis_part_offset);


  ~HypothesisParts();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HypothesisPartsPtr>
  HypothesisPartsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HypothesisParts::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HypothesisParts::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HypothesisParts::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HypothesisParts::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HypothesisParts::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HypothesisParts::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HypothesisParts_UnserializedMessageContext<
            UserType, HypothesisParts::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HypothesisParts::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HypothesisParts::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HypothesisParts_UnserializedMessageContext<
            UserType, HypothesisParts::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HypothesisParts::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<::blink::String> text;
  
  ::base::TimeDelta hypothesis_part_offset;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HypothesisParts::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HypothesisParts::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HypothesisParts::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HypothesisParts::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  MediaTimestampRange {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MediaTimestampRange, T>::value>;
  using DataView = MediaTimestampRangeDataView;
  using Data_ = internal::MediaTimestampRange_Data;

  template <typename... Args>
  static MediaTimestampRangePtr New(Args&&... args) {
    return MediaTimestampRangePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MediaTimestampRangePtr From(const U& u) {
    return mojo::TypeConverter<MediaTimestampRangePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MediaTimestampRange>::Convert(*this);
  }


  MediaTimestampRange();

  MediaTimestampRange(
      ::base::TimeDelta start,
      ::base::TimeDelta end);


  ~MediaTimestampRange();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MediaTimestampRangePtr>
  MediaTimestampRangePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MediaTimestampRange::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MediaTimestampRange::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MediaTimestampRange::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MediaTimestampRange::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MediaTimestampRange::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MediaTimestampRange::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MediaTimestampRange_UnserializedMessageContext<
            UserType, MediaTimestampRange::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MediaTimestampRange::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MediaTimestampRange::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MediaTimestampRange_UnserializedMessageContext<
            UserType, MediaTimestampRange::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MediaTimestampRange::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::TimeDelta start;
  
  ::base::TimeDelta end;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MediaTimestampRange::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MediaTimestampRange::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MediaTimestampRange::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MediaTimestampRange::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  TimingInformation {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TimingInformation, T>::value>;
  using DataView = TimingInformationDataView;
  using Data_ = internal::TimingInformation_Data;

  template <typename... Args>
  static TimingInformationPtr New(Args&&... args) {
    return TimingInformationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TimingInformationPtr From(const U& u) {
    return mojo::TypeConverter<TimingInformationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TimingInformation>::Convert(*this);
  }


  TimingInformation();

  TimingInformation(
      ::base::TimeDelta audio_start_time,
      ::base::TimeDelta audio_end_time,
      std::optional<::blink::Vector<HypothesisPartsPtr>> hypothesis_parts);

  TimingInformation(
      ::base::TimeDelta audio_start_time,
      ::base::TimeDelta audio_end_time,
      std::optional<::blink::Vector<HypothesisPartsPtr>> hypothesis_parts,
      std::optional<::blink::Vector<MediaTimestampRangePtr>> originating_media_timestamps);

TimingInformation(const TimingInformation&) = delete;
TimingInformation& operator=(const TimingInformation&) = delete;

  ~TimingInformation();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TimingInformationPtr>
  TimingInformationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TimingInformation::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TimingInformation::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TimingInformation::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TimingInformation::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TimingInformation::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TimingInformation::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TimingInformation_UnserializedMessageContext<
            UserType, TimingInformation::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TimingInformation::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TimingInformation::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TimingInformation_UnserializedMessageContext<
            UserType, TimingInformation::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TimingInformation::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::TimeDelta audio_start_time;
  
  ::base::TimeDelta audio_end_time;
  
  std::optional<::blink::Vector<HypothesisPartsPtr>> hypothesis_parts;
  
  std::optional<::blink::Vector<MediaTimestampRangePtr>> originating_media_timestamps;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TimingInformation::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TimingInformation::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TimingInformation::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TimingInformation::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SpeechRecognitionResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SpeechRecognitionResult, T>::value>;
  using DataView = SpeechRecognitionResultDataView;
  using Data_ = internal::SpeechRecognitionResult_Data;

  template <typename... Args>
  static SpeechRecognitionResultPtr New(Args&&... args) {
    return SpeechRecognitionResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SpeechRecognitionResultPtr From(const U& u) {
    return mojo::TypeConverter<SpeechRecognitionResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SpeechRecognitionResult>::Convert(*this);
  }


  SpeechRecognitionResult();

  SpeechRecognitionResult(
      const ::blink::String& transcription,
      bool is_final,
      TimingInformationPtr timing_information);

SpeechRecognitionResult(const SpeechRecognitionResult&) = delete;
SpeechRecognitionResult& operator=(const SpeechRecognitionResult&) = delete;

  ~SpeechRecognitionResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SpeechRecognitionResultPtr>
  SpeechRecognitionResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SpeechRecognitionResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SpeechRecognitionResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SpeechRecognitionResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SpeechRecognitionResult::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SpeechRecognitionResult::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SpeechRecognitionResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SpeechRecognitionResult_UnserializedMessageContext<
            UserType, SpeechRecognitionResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SpeechRecognitionResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SpeechRecognitionResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SpeechRecognitionResult_UnserializedMessageContext<
            UserType, SpeechRecognitionResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SpeechRecognitionResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String transcription;
  
  bool is_final;
  
  TimingInformationPtr timing_information;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SpeechRecognitionResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SpeechRecognitionResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SpeechRecognitionResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SpeechRecognitionResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  SpeechRecognitionOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SpeechRecognitionOptions, T>::value>;
  using DataView = SpeechRecognitionOptionsDataView;
  using Data_ = internal::SpeechRecognitionOptions_Data;

  template <typename... Args>
  static SpeechRecognitionOptionsPtr New(Args&&... args) {
    return SpeechRecognitionOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SpeechRecognitionOptionsPtr From(const U& u) {
    return mojo::TypeConverter<SpeechRecognitionOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SpeechRecognitionOptions>::Convert(*this);
  }


  SpeechRecognitionOptions();

  SpeechRecognitionOptions(
      SpeechRecognitionMode recognition_mode,
      bool enable_formatting,
      const ::blink::String& language);

  SpeechRecognitionOptions(
      SpeechRecognitionMode recognition_mode,
      bool enable_formatting,
      const ::blink::String& language,
      bool is_server_based,
      RecognizerClientType recognizer_client_type);

  SpeechRecognitionOptions(
      SpeechRecognitionMode recognition_mode,
      bool enable_formatting,
      const ::blink::String& language,
      bool is_server_based,
      RecognizerClientType recognizer_client_type,
      bool skip_continuously_empty_audio);

  SpeechRecognitionOptions(
      SpeechRecognitionMode recognition_mode,
      bool enable_formatting,
      const ::blink::String& language,
      bool is_server_based,
      RecognizerClientType recognizer_client_type,
      bool skip_continuously_empty_audio,
      const ::blink::String& experiment_recognizer_routing_key);

  SpeechRecognitionOptions(
      SpeechRecognitionMode recognition_mode,
      bool enable_formatting,
      const ::blink::String& language,
      bool is_server_based,
      RecognizerClientType recognizer_client_type,
      bool skip_continuously_empty_audio,
      const ::blink::String& experiment_recognizer_routing_key,
      int32_t channel_count,
      int32_t sample_rate);

  SpeechRecognitionOptions(
      SpeechRecognitionMode recognition_mode,
      bool enable_formatting,
      const ::blink::String& language,
      bool is_server_based,
      RecognizerClientType recognizer_client_type,
      bool skip_continuously_empty_audio,
      const ::blink::String& experiment_recognizer_routing_key,
      int32_t channel_count,
      int32_t sample_rate,
      ::media::mojom::blink::SpeechRecognitionRecognitionContextPtr recognition_context);

SpeechRecognitionOptions(const SpeechRecognitionOptions&) = delete;
SpeechRecognitionOptions& operator=(const SpeechRecognitionOptions&) = delete;

  ~SpeechRecognitionOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SpeechRecognitionOptionsPtr>
  SpeechRecognitionOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SpeechRecognitionOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SpeechRecognitionOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SpeechRecognitionOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SpeechRecognitionOptions::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SpeechRecognitionOptions::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SpeechRecognitionOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SpeechRecognitionOptions_UnserializedMessageContext<
            UserType, SpeechRecognitionOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SpeechRecognitionOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SpeechRecognitionOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SpeechRecognitionOptions_UnserializedMessageContext<
            UserType, SpeechRecognitionOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SpeechRecognitionOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  SpeechRecognitionMode recognition_mode;
  
  bool enable_formatting;
  
  ::blink::String language;
  
  bool is_server_based;
  
  RecognizerClientType recognizer_client_type;
  
  bool skip_continuously_empty_audio;
  
  ::blink::String experiment_recognizer_routing_key;
  
  int32_t channel_count;
  
  int32_t sample_rate;
  
  ::media::mojom::blink::SpeechRecognitionRecognitionContextPtr recognition_context;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SpeechRecognitionOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SpeechRecognitionOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SpeechRecognitionOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SpeechRecognitionOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
HypothesisPartsPtr HypothesisParts::Clone() const {
  return New(
      mojo::Clone(text),
      mojo::Clone(hypothesis_part_offset)
  );
}

template <typename T, HypothesisParts::EnableIfSame<T>*>
bool HypothesisParts::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->text, other_struct.text))
    return false;
  if (!mojo::Equals(this->hypothesis_part_offset, other_struct.hypothesis_part_offset))
    return false;
  return true;
}

template <typename T, HypothesisParts::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.text < rhs.text)
    return true;
  if (rhs.text < lhs.text)
    return false;
  if (lhs.hypothesis_part_offset < rhs.hypothesis_part_offset)
    return true;
  if (rhs.hypothesis_part_offset < lhs.hypothesis_part_offset)
    return false;
  return false;
}
template <typename StructPtrType>
MediaTimestampRangePtr MediaTimestampRange::Clone() const {
  return New(
      mojo::Clone(start),
      mojo::Clone(end)
  );
}

template <typename T, MediaTimestampRange::EnableIfSame<T>*>
bool MediaTimestampRange::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->start, other_struct.start))
    return false;
  if (!mojo::Equals(this->end, other_struct.end))
    return false;
  return true;
}

template <typename T, MediaTimestampRange::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.start < rhs.start)
    return true;
  if (rhs.start < lhs.start)
    return false;
  if (lhs.end < rhs.end)
    return true;
  if (rhs.end < lhs.end)
    return false;
  return false;
}
template <typename StructPtrType>
TimingInformationPtr TimingInformation::Clone() const {
  return New(
      mojo::Clone(audio_start_time),
      mojo::Clone(audio_end_time),
      mojo::Clone(hypothesis_parts),
      mojo::Clone(originating_media_timestamps)
  );
}

template <typename T, TimingInformation::EnableIfSame<T>*>
bool TimingInformation::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->audio_start_time, other_struct.audio_start_time))
    return false;
  if (!mojo::Equals(this->audio_end_time, other_struct.audio_end_time))
    return false;
  if (!mojo::Equals(this->hypothesis_parts, other_struct.hypothesis_parts))
    return false;
  if (!mojo::Equals(this->originating_media_timestamps, other_struct.originating_media_timestamps))
    return false;
  return true;
}

template <typename T, TimingInformation::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.audio_start_time < rhs.audio_start_time)
    return true;
  if (rhs.audio_start_time < lhs.audio_start_time)
    return false;
  if (lhs.audio_end_time < rhs.audio_end_time)
    return true;
  if (rhs.audio_end_time < lhs.audio_end_time)
    return false;
  if (lhs.hypothesis_parts < rhs.hypothesis_parts)
    return true;
  if (rhs.hypothesis_parts < lhs.hypothesis_parts)
    return false;
  if (lhs.originating_media_timestamps < rhs.originating_media_timestamps)
    return true;
  if (rhs.originating_media_timestamps < lhs.originating_media_timestamps)
    return false;
  return false;
}
template <typename StructPtrType>
SpeechRecognitionResultPtr SpeechRecognitionResult::Clone() const {
  return New(
      mojo::Clone(transcription),
      mojo::Clone(is_final),
      mojo::Clone(timing_information)
  );
}

template <typename T, SpeechRecognitionResult::EnableIfSame<T>*>
bool SpeechRecognitionResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->transcription, other_struct.transcription))
    return false;
  if (!mojo::Equals(this->is_final, other_struct.is_final))
    return false;
  if (!mojo::Equals(this->timing_information, other_struct.timing_information))
    return false;
  return true;
}

template <typename T, SpeechRecognitionResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.transcription < rhs.transcription)
    return true;
  if (rhs.transcription < lhs.transcription)
    return false;
  if (lhs.is_final < rhs.is_final)
    return true;
  if (rhs.is_final < lhs.is_final)
    return false;
  if (lhs.timing_information < rhs.timing_information)
    return true;
  if (rhs.timing_information < lhs.timing_information)
    return false;
  return false;
}
template <typename StructPtrType>
LanguageIdentificationEventPtr LanguageIdentificationEvent::Clone() const {
  return New(
      mojo::Clone(language),
      mojo::Clone(confidence_level),
      mojo::Clone(asr_switch_result)
  );
}

template <typename T, LanguageIdentificationEvent::EnableIfSame<T>*>
bool LanguageIdentificationEvent::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->language, other_struct.language))
    return false;
  if (!mojo::Equals(this->confidence_level, other_struct.confidence_level))
    return false;
  if (!mojo::Equals(this->asr_switch_result, other_struct.asr_switch_result))
    return false;
  return true;
}

template <typename T, LanguageIdentificationEvent::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.language < rhs.language)
    return true;
  if (rhs.language < lhs.language)
    return false;
  if (lhs.confidence_level < rhs.confidence_level)
    return true;
  if (rhs.confidence_level < lhs.confidence_level)
    return false;
  if (lhs.asr_switch_result < rhs.asr_switch_result)
    return true;
  if (rhs.asr_switch_result < lhs.asr_switch_result)
    return false;
  return false;
}
template <typename StructPtrType>
SpeechRecognitionOptionsPtr SpeechRecognitionOptions::Clone() const {
  return New(
      mojo::Clone(recognition_mode),
      mojo::Clone(enable_formatting),
      mojo::Clone(language),
      mojo::Clone(is_server_based),
      mojo::Clone(recognizer_client_type),
      mojo::Clone(skip_continuously_empty_audio),
      mojo::Clone(experiment_recognizer_routing_key),
      mojo::Clone(channel_count),
      mojo::Clone(sample_rate),
      mojo::Clone(recognition_context)
  );
}

template <typename T, SpeechRecognitionOptions::EnableIfSame<T>*>
bool SpeechRecognitionOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->recognition_mode, other_struct.recognition_mode))
    return false;
  if (!mojo::Equals(this->enable_formatting, other_struct.enable_formatting))
    return false;
  if (!mojo::Equals(this->language, other_struct.language))
    return false;
  if (!mojo::Equals(this->is_server_based, other_struct.is_server_based))
    return false;
  if (!mojo::Equals(this->recognizer_client_type, other_struct.recognizer_client_type))
    return false;
  if (!mojo::Equals(this->skip_continuously_empty_audio, other_struct.skip_continuously_empty_audio))
    return false;
  if (!mojo::Equals(this->experiment_recognizer_routing_key, other_struct.experiment_recognizer_routing_key))
    return false;
  if (!mojo::Equals(this->channel_count, other_struct.channel_count))
    return false;
  if (!mojo::Equals(this->sample_rate, other_struct.sample_rate))
    return false;
  if (!mojo::Equals(this->recognition_context, other_struct.recognition_context))
    return false;
  return true;
}

template <typename T, SpeechRecognitionOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.recognition_mode < rhs.recognition_mode)
    return true;
  if (rhs.recognition_mode < lhs.recognition_mode)
    return false;
  if (lhs.enable_formatting < rhs.enable_formatting)
    return true;
  if (rhs.enable_formatting < lhs.enable_formatting)
    return false;
  if (lhs.language < rhs.language)
    return true;
  if (rhs.language < lhs.language)
    return false;
  if (lhs.is_server_based < rhs.is_server_based)
    return true;
  if (rhs.is_server_based < lhs.is_server_based)
    return false;
  if (lhs.recognizer_client_type < rhs.recognizer_client_type)
    return true;
  if (rhs.recognizer_client_type < lhs.recognizer_client_type)
    return false;
  if (lhs.skip_continuously_empty_audio < rhs.skip_continuously_empty_audio)
    return true;
  if (rhs.skip_continuously_empty_audio < lhs.skip_continuously_empty_audio)
    return false;
  if (lhs.experiment_recognizer_routing_key < rhs.experiment_recognizer_routing_key)
    return true;
  if (rhs.experiment_recognizer_routing_key < lhs.experiment_recognizer_routing_key)
    return false;
  if (lhs.channel_count < rhs.channel_count)
    return true;
  if (rhs.channel_count < lhs.channel_count)
    return false;
  if (lhs.sample_rate < rhs.sample_rate)
    return true;
  if (rhs.sample_rate < lhs.sample_rate)
    return false;
  if (lhs.recognition_context < rhs.recognition_context)
    return true;
  if (rhs.recognition_context < lhs.recognition_context)
    return false;
  return false;
}


}  // media::mojom::blink

namespace mojo {


template <>
struct  StructTraits<::media::mojom::blink::HypothesisParts::DataView,
                                         ::media::mojom::blink::HypothesisPartsPtr> {
  static bool IsNull(const ::media::mojom::blink::HypothesisPartsPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::HypothesisPartsPtr* output) { output->reset(); }

  static const decltype(::media::mojom::blink::HypothesisParts::text)& text(
      const ::media::mojom::blink::HypothesisPartsPtr& input) {
    return input->text;
  }

  static const decltype(::media::mojom::blink::HypothesisParts::hypothesis_part_offset)& hypothesis_part_offset(
      const ::media::mojom::blink::HypothesisPartsPtr& input) {
    return input->hypothesis_part_offset;
  }

  static bool Read(::media::mojom::blink::HypothesisParts::DataView input, ::media::mojom::blink::HypothesisPartsPtr* output);
};


template <>
struct  StructTraits<::media::mojom::blink::MediaTimestampRange::DataView,
                                         ::media::mojom::blink::MediaTimestampRangePtr> {
  static bool IsNull(const ::media::mojom::blink::MediaTimestampRangePtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::MediaTimestampRangePtr* output) { output->reset(); }

  static const decltype(::media::mojom::blink::MediaTimestampRange::start)& start(
      const ::media::mojom::blink::MediaTimestampRangePtr& input) {
    return input->start;
  }

  static const decltype(::media::mojom::blink::MediaTimestampRange::end)& end(
      const ::media::mojom::blink::MediaTimestampRangePtr& input) {
    return input->end;
  }

  static bool Read(::media::mojom::blink::MediaTimestampRange::DataView input, ::media::mojom::blink::MediaTimestampRangePtr* output);
};


template <>
struct  StructTraits<::media::mojom::blink::TimingInformation::DataView,
                                         ::media::mojom::blink::TimingInformationPtr> {
  static bool IsNull(const ::media::mojom::blink::TimingInformationPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::TimingInformationPtr* output) { output->reset(); }

  static const decltype(::media::mojom::blink::TimingInformation::audio_start_time)& audio_start_time(
      const ::media::mojom::blink::TimingInformationPtr& input) {
    return input->audio_start_time;
  }

  static const decltype(::media::mojom::blink::TimingInformation::audio_end_time)& audio_end_time(
      const ::media::mojom::blink::TimingInformationPtr& input) {
    return input->audio_end_time;
  }

  static const decltype(::media::mojom::blink::TimingInformation::hypothesis_parts)& hypothesis_parts(
      const ::media::mojom::blink::TimingInformationPtr& input) {
    return input->hypothesis_parts;
  }

  static const decltype(::media::mojom::blink::TimingInformation::originating_media_timestamps)& originating_media_timestamps(
      const ::media::mojom::blink::TimingInformationPtr& input) {
    return input->originating_media_timestamps;
  }

  static bool Read(::media::mojom::blink::TimingInformation::DataView input, ::media::mojom::blink::TimingInformationPtr* output);
};


template <>
struct  StructTraits<::media::mojom::blink::SpeechRecognitionResult::DataView,
                                         ::media::mojom::blink::SpeechRecognitionResultPtr> {
  static bool IsNull(const ::media::mojom::blink::SpeechRecognitionResultPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::SpeechRecognitionResultPtr* output) { output->reset(); }

  static const decltype(::media::mojom::blink::SpeechRecognitionResult::transcription)& transcription(
      const ::media::mojom::blink::SpeechRecognitionResultPtr& input) {
    return input->transcription;
  }

  static decltype(::media::mojom::blink::SpeechRecognitionResult::is_final) is_final(
      const ::media::mojom::blink::SpeechRecognitionResultPtr& input) {
    return input->is_final;
  }

  static const decltype(::media::mojom::blink::SpeechRecognitionResult::timing_information)& timing_information(
      const ::media::mojom::blink::SpeechRecognitionResultPtr& input) {
    return input->timing_information;
  }

  static bool Read(::media::mojom::blink::SpeechRecognitionResult::DataView input, ::media::mojom::blink::SpeechRecognitionResultPtr* output);
};


template <>
struct  StructTraits<::media::mojom::blink::LanguageIdentificationEvent::DataView,
                                         ::media::mojom::blink::LanguageIdentificationEventPtr> {
  static bool IsNull(const ::media::mojom::blink::LanguageIdentificationEventPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::LanguageIdentificationEventPtr* output) { output->reset(); }

  static const decltype(::media::mojom::blink::LanguageIdentificationEvent::language)& language(
      const ::media::mojom::blink::LanguageIdentificationEventPtr& input) {
    return input->language;
  }

  static decltype(::media::mojom::blink::LanguageIdentificationEvent::confidence_level) confidence_level(
      const ::media::mojom::blink::LanguageIdentificationEventPtr& input) {
    return input->confidence_level;
  }

  static decltype(::media::mojom::blink::LanguageIdentificationEvent::asr_switch_result) asr_switch_result(
      const ::media::mojom::blink::LanguageIdentificationEventPtr& input) {
    return input->asr_switch_result;
  }

  static bool Read(::media::mojom::blink::LanguageIdentificationEvent::DataView input, ::media::mojom::blink::LanguageIdentificationEventPtr* output);
};


template <>
struct  StructTraits<::media::mojom::blink::SpeechRecognitionOptions::DataView,
                                         ::media::mojom::blink::SpeechRecognitionOptionsPtr> {
  static bool IsNull(const ::media::mojom::blink::SpeechRecognitionOptionsPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::SpeechRecognitionOptionsPtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::SpeechRecognitionOptions::recognition_mode) recognition_mode(
      const ::media::mojom::blink::SpeechRecognitionOptionsPtr& input) {
    return input->recognition_mode;
  }

  static decltype(::media::mojom::blink::SpeechRecognitionOptions::enable_formatting) enable_formatting(
      const ::media::mojom::blink::SpeechRecognitionOptionsPtr& input) {
    return input->enable_formatting;
  }

  static const decltype(::media::mojom::blink::SpeechRecognitionOptions::language)& language(
      const ::media::mojom::blink::SpeechRecognitionOptionsPtr& input) {
    return input->language;
  }

  static decltype(::media::mojom::blink::SpeechRecognitionOptions::is_server_based) is_server_based(
      const ::media::mojom::blink::SpeechRecognitionOptionsPtr& input) {
    return input->is_server_based;
  }

  static decltype(::media::mojom::blink::SpeechRecognitionOptions::recognizer_client_type) recognizer_client_type(
      const ::media::mojom::blink::SpeechRecognitionOptionsPtr& input) {
    return input->recognizer_client_type;
  }

  static decltype(::media::mojom::blink::SpeechRecognitionOptions::skip_continuously_empty_audio) skip_continuously_empty_audio(
      const ::media::mojom::blink::SpeechRecognitionOptionsPtr& input) {
    return input->skip_continuously_empty_audio;
  }

  static const decltype(::media::mojom::blink::SpeechRecognitionOptions::experiment_recognizer_routing_key)& experiment_recognizer_routing_key(
      const ::media::mojom::blink::SpeechRecognitionOptionsPtr& input) {
    return input->experiment_recognizer_routing_key;
  }

  static decltype(::media::mojom::blink::SpeechRecognitionOptions::channel_count) channel_count(
      const ::media::mojom::blink::SpeechRecognitionOptionsPtr& input) {
    return input->channel_count;
  }

  static decltype(::media::mojom::blink::SpeechRecognitionOptions::sample_rate) sample_rate(
      const ::media::mojom::blink::SpeechRecognitionOptionsPtr& input) {
    return input->sample_rate;
  }

  static const decltype(::media::mojom::blink::SpeechRecognitionOptions::recognition_context)& recognition_context(
      const ::media::mojom::blink::SpeechRecognitionOptionsPtr& input) {
    return input->recognition_context;
  }

  static bool Read(::media::mojom::blink::SpeechRecognitionOptions::DataView input, ::media::mojom::blink::SpeechRecognitionOptionsPtr* output);
};

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_MOJOM_BLINK_H_