// qtwebengine/common/renderer_configuration.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "qtwebengine/common/renderer_configuration.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "qtwebengine/common/renderer_configuration.mojom-params-data.h"
#include "qtwebengine/common/renderer_configuration.mojom-shared-message-ids.h"

#include "qtwebengine/common/renderer_configuration.mojom-import-headers.h"
#include "qtwebengine/common/renderer_configuration.mojom-test-utils.h"


namespace qtwebengine::mojom {
// The declaration includes the definition on other builds.

RendererConfiguration::IPCStableHashFunction RendererConfiguration::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::RendererConfiguration>(message.name())) {
    case messages::RendererConfiguration::kSetInitialConfiguration: {
      return &RendererConfiguration::SetInitialConfiguration_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* RendererConfiguration::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::RendererConfiguration>(message.name())) {
      case messages::RendererConfiguration::kSetInitialConfiguration:
            return "Receive qtwebengine::mojom::RendererConfiguration::SetInitialConfiguration";
    }
  } else {
    switch (static_cast<messages::RendererConfiguration>(message.name())) {
      case messages::RendererConfiguration::kSetInitialConfiguration:
            return "Receive reply qtwebengine::mojom::RendererConfiguration::SetInitialConfiguration";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t RendererConfiguration::SetInitialConfiguration_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xeb03857d;  // IPCStableHash for qtwebengine::mojom::RendererConfiguration::SetInitialConfiguration
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

RendererConfigurationProxy::RendererConfigurationProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RendererConfigurationProxy::SetInitialConfiguration(
    bool in_is_incognito_process) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send qtwebengine::mojom::RendererConfiguration::SetInitialConfiguration", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_incognito_process"), in_is_incognito_process,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RendererConfiguration::kSetInitialConfiguration), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::qtwebengine::mojom::internal::RendererConfiguration_SetInitialConfiguration_Params_Data> params(
          message);
  params.Allocate();

  params->is_incognito_process = in_is_incognito_process;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererConfiguration::Name_);
  message.set_method_name("SetInitialConfiguration");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool RendererConfigurationStubDispatch::Accept(
    RendererConfiguration* impl,
    mojo::Message* message) {
  switch (static_cast<messages::RendererConfiguration>(message->header()->name)) {
    case messages::RendererConfiguration::kSetInitialConfiguration: {
      DCHECK(message->is_serialized());
      internal::RendererConfiguration_SetInitialConfiguration_Params_Data* params =
          reinterpret_cast<internal::RendererConfiguration_SetInitialConfiguration_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RendererConfiguration.0
      bool success = true;
      bool p_is_incognito_process{};
      RendererConfiguration_SetInitialConfiguration_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_incognito_process = input_data_view.is_incognito_process();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererConfiguration::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetInitialConfiguration(        
        std::move(p_is_incognito_process));
      return true;
    }
  }
  return false;
}

// static
bool RendererConfigurationStubDispatch::AcceptWithResponder(
    RendererConfiguration* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::RendererConfiguration>(message->header()->name)) {
    case messages::RendererConfiguration::kSetInitialConfiguration: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kRendererConfigurationValidationInfo[] = {
    {base::to_underlying(messages::RendererConfiguration::kSetInitialConfiguration),
     { &internal::RendererConfiguration_SetInitialConfiguration_Params_Data::Validate,
      nullptr /* no response */}},
};

bool RendererConfigurationRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::qtwebengine::mojom::RendererConfiguration::Name_,
    kRendererConfigurationValidationInfo);
}



}  // qtwebengine::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace qtwebengine::mojom {


void RendererConfigurationInterceptorForTesting::SetInitialConfiguration(bool is_incognito_process) {
  GetForwardingInterface()->SetInitialConfiguration(
    std::move(is_incognito_process)
    );
}
RendererConfigurationAsyncWaiter::RendererConfigurationAsyncWaiter(
    RendererConfiguration* proxy) : proxy_(proxy) {}

RendererConfigurationAsyncWaiter::~RendererConfigurationAsyncWaiter() = default;







}  // qtwebengine::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif