// services/device/public/mojom/fingerprint.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_FINGERPRINT_MOJOM_DATA_VIEW_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_FINGERPRINT_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/device/public/mojom/fingerprint.mojom-shared-internal.h"


namespace device::mojom {
class FingerprintMessageDataView;


}  // device::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::device::mojom::FingerprintMessageDataView> {
  using Data = ::device::mojom::internal::FingerprintMessage_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace device::mojom {


enum class ScanResult : int32_t {
  
  SUCCESS = 0,
  
  PARTIAL = 1,
  
  INSUFFICIENT = 2,
  
  SENSOR_DIRTY = 3,
  
  TOO_SLOW = 4,
  
  TOO_FAST = 5,
  
  IMMOBILE = 6,
  
  NO_MATCH = 7,
  kMinValue = 0,
  kMaxValue = 7,
};

 std::ostream& operator<<(std::ostream& os, ScanResult value);
inline bool IsKnownEnumValue(ScanResult value) {
  return internal::ScanResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FingerprintError : int32_t {
  
  UNKNOWN = 0,
  
  HW_UNAVAILABLE = 1,
  
  UNABLE_TO_PROCESS = 2,
  
  TIMEOUT = 3,
  
  NO_SPACE = 4,
  
  CANCELED = 5,
  
  UNABLE_TO_REMOVE = 6,
  
  LOCKOUT = 7,
  
  NO_TEMPLATES = 8,
  kMinValue = 0,
  kMaxValue = 8,
};

 std::ostream& operator<<(std::ostream& os, FingerprintError value);
inline bool IsKnownEnumValue(FingerprintError value) {
  return internal::FingerprintError_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class BiometricType : int32_t {
  
  UNKNOWN = 0,
  
  FINGERPRINT = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, BiometricType value);
inline bool IsKnownEnumValue(BiometricType value) {
  return internal::BiometricType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class BiometricsManagerStatus : int32_t {
  
  UNKNOWN = 0,
  
  INITIALIZED = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, BiometricsManagerStatus value);
inline bool IsKnownEnumValue(BiometricsManagerStatus value) {
  return internal::BiometricsManagerStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class FingerprintObserverInterfaceBase {};

using FingerprintObserverPtrDataView =
    mojo::InterfacePtrDataView<FingerprintObserverInterfaceBase>;
using FingerprintObserverRequestDataView =
    mojo::InterfaceRequestDataView<FingerprintObserverInterfaceBase>;
using FingerprintObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FingerprintObserverInterfaceBase>;
using FingerprintObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FingerprintObserverInterfaceBase>;
class FingerprintInterfaceBase {};

using FingerprintPtrDataView =
    mojo::InterfacePtrDataView<FingerprintInterfaceBase>;
using FingerprintRequestDataView =
    mojo::InterfaceRequestDataView<FingerprintInterfaceBase>;
using FingerprintAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FingerprintInterfaceBase>;
using FingerprintAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FingerprintInterfaceBase>;


class FingerprintMessageDataView {
 public:
  using Tag = internal::FingerprintMessage_Data::FingerprintMessage_Tag;

  FingerprintMessageDataView() = default;

  FingerprintMessageDataView(
      internal::FingerprintMessage_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_fingerprint_error() const { return data_->tag == Tag::kFingerprintError; }
  template <typename UserType>
  [[nodiscard]] bool ReadFingerprintError(UserType* output) const {
    CHECK(is_fingerprint_error());
    return mojo::internal::Deserialize<::device::mojom::FingerprintError>(
        data_->data.f_fingerprint_error, output);
  }
  FingerprintError fingerprint_error() const {
    CHECK(is_fingerprint_error());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::FingerprintError>(data_->data.f_fingerprint_error));
  }
  bool is_scan_result() const { return data_->tag == Tag::kScanResult; }
  template <typename UserType>
  [[nodiscard]] bool ReadScanResult(UserType* output) const {
    CHECK(is_scan_result());
    return mojo::internal::Deserialize<::device::mojom::ScanResult>(
        data_->data.f_scan_result, output);
  }
  ScanResult scan_result() const {
    CHECK(is_scan_result());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::ScanResult>(data_->data.f_scan_result));
  }

 private:
  internal::FingerprintMessage_Data* data_ = nullptr;
};



}  // device::mojom

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_FINGERPRINT_MOJOM_DATA_VIEW_H_