// services/device/public/mojom/usb_device.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_USB_DEVICE_MOJOM_BLINK_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_USB_DEVICE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/device/public/mojom/usb_device.mojom-features.h"  // IWYU pragma: export
#include "services/device/public/mojom/usb_device.mojom-shared.h"  // IWYU pragma: export
#include "services/device/public/mojom/usb_device.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/read_only_buffer.mojom-blink.h"
#include "mojo/public/mojom/base/string16.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace device::mojom::blink {

class UsbDeviceProxy;

template <typename ImplRefTraits>
class UsbDeviceStub;

class UsbDeviceRequestValidator;
class UsbDeviceResponseValidator;


class BLINK_PLATFORM_EXPORT UsbDevice
    : public UsbDeviceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.UsbDevice";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = UsbDeviceInterfaceBase;
  using Proxy_ = UsbDeviceProxy;

  template <typename ImplRefTraits>
  using Stub_ = UsbDeviceStub<ImplRefTraits>;

  using RequestValidator_ = UsbDeviceRequestValidator;
  using ResponseValidator_ = UsbDeviceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kOpenMinVersion = 0,
    kCloseMinVersion = 0,
    kSetConfigurationMinVersion = 0,
    kClaimInterfaceMinVersion = 0,
    kReleaseInterfaceMinVersion = 0,
    kSetInterfaceAlternateSettingMinVersion = 0,
    kResetMinVersion = 0,
    kClearHaltMinVersion = 0,
    kControlTransferInMinVersion = 0,
    kControlTransferOutMinVersion = 0,
    kGenericTransferInMinVersion = 0,
    kGenericTransferOutMinVersion = 0,
    kIsochronousTransferInMinVersion = 0,
    kIsochronousTransferOutMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Open_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Close_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetConfiguration_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClaimInterface_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReleaseInterface_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetInterfaceAlternateSetting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Reset_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearHalt_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ControlTransferIn_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ControlTransferOut_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GenericTransferIn_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GenericTransferOut_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IsochronousTransferIn_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IsochronousTransferOut_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~UsbDevice() = default;

  using OpenCallback = base::OnceCallback<void(UsbOpenDeviceResultPtr)>;
  using OpenMojoCallback = base::OnceCallback<void(UsbOpenDeviceResultPtr)>;

  virtual void Open(OpenCallback callback) = 0;

  using CloseCallback = base::OnceCallback<void()>;
  using CloseMojoCallback = base::OnceCallback<void()>;

  virtual void Close(CloseCallback callback) = 0;

  using SetConfigurationCallback = base::OnceCallback<void(bool)>;
  using SetConfigurationMojoCallback = base::OnceCallback<void(bool)>;

  virtual void SetConfiguration(uint8_t value, SetConfigurationCallback callback) = 0;

  using ClaimInterfaceCallback = base::OnceCallback<void(UsbClaimInterfaceResult)>;
  using ClaimInterfaceMojoCallback = base::OnceCallback<void(UsbClaimInterfaceResult)>;

  virtual void ClaimInterface(uint8_t interface_number, ClaimInterfaceCallback callback) = 0;

  using ReleaseInterfaceCallback = base::OnceCallback<void(bool)>;
  using ReleaseInterfaceMojoCallback = base::OnceCallback<void(bool)>;

  virtual void ReleaseInterface(uint8_t interface_number, ReleaseInterfaceCallback callback) = 0;

  using SetInterfaceAlternateSettingCallback = base::OnceCallback<void(bool)>;
  using SetInterfaceAlternateSettingMojoCallback = base::OnceCallback<void(bool)>;

  virtual void SetInterfaceAlternateSetting(uint8_t interface_number, uint8_t alternate_setting, SetInterfaceAlternateSettingCallback callback) = 0;

  using ResetCallback = base::OnceCallback<void(bool)>;
  using ResetMojoCallback = base::OnceCallback<void(bool)>;

  virtual void Reset(ResetCallback callback) = 0;

  using ClearHaltCallback = base::OnceCallback<void(bool)>;
  using ClearHaltMojoCallback = base::OnceCallback<void(bool)>;

  virtual void ClearHalt(UsbTransferDirection direction, uint8_t endpoint_number, ClearHaltCallback callback) = 0;

  using ControlTransferInCallback = base::OnceCallback<void(UsbTransferStatus, ::base::span<const ::uint8_t>)>;
  using ControlTransferInMojoCallback = base::OnceCallback<void(UsbTransferStatus, ::base::span<const ::uint8_t>)>;

  virtual void ControlTransferIn(UsbControlTransferParamsPtr params, uint32_t length, uint32_t timeout, ControlTransferInCallback callback) = 0;

  using ControlTransferOutCallback = base::OnceCallback<void(UsbTransferStatus)>;
  using ControlTransferOutMojoCallback = base::OnceCallback<void(UsbTransferStatus)>;

  virtual void ControlTransferOut(UsbControlTransferParamsPtr params, ::base::span<const ::uint8_t> data, uint32_t timeout, ControlTransferOutCallback callback) = 0;

  using GenericTransferInCallback = base::OnceCallback<void(UsbTransferStatus, ::base::span<const ::uint8_t>)>;
  using GenericTransferInMojoCallback = base::OnceCallback<void(UsbTransferStatus, ::base::span<const ::uint8_t>)>;

  virtual void GenericTransferIn(uint8_t endpoint_number, uint32_t length, uint32_t timeout, GenericTransferInCallback callback) = 0;

  using GenericTransferOutCallback = base::OnceCallback<void(UsbTransferStatus)>;
  using GenericTransferOutMojoCallback = base::OnceCallback<void(UsbTransferStatus)>;

  virtual void GenericTransferOut(uint8_t endpoint_number, ::base::span<const ::uint8_t> data, uint32_t timeout, GenericTransferOutCallback callback) = 0;

  using IsochronousTransferInCallback = base::OnceCallback<void(::base::span<const ::uint8_t>, ::blink::Vector<UsbIsochronousPacketPtr>)>;
  using IsochronousTransferInMojoCallback = base::OnceCallback<void(::base::span<const ::uint8_t>, ::blink::Vector<UsbIsochronousPacketPtr>)>;

  virtual void IsochronousTransferIn(uint8_t endpoint_number, const ::blink::Vector<uint32_t>& packet_lengths, uint32_t timeout, IsochronousTransferInCallback callback) = 0;

  using IsochronousTransferOutCallback = base::OnceCallback<void(::blink::Vector<UsbIsochronousPacketPtr>)>;
  using IsochronousTransferOutMojoCallback = base::OnceCallback<void(::blink::Vector<UsbIsochronousPacketPtr>)>;

  virtual void IsochronousTransferOut(uint8_t endpoint_number, ::base::span<const ::uint8_t> data, const ::blink::Vector<uint32_t>& packet_lengths, uint32_t timeout, IsochronousTransferOutCallback callback) = 0;
};

class UsbDeviceClientProxy;

template <typename ImplRefTraits>
class UsbDeviceClientStub;

class UsbDeviceClientRequestValidator;


class BLINK_PLATFORM_EXPORT UsbDeviceClient
    : public UsbDeviceClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.UsbDeviceClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = UsbDeviceClientInterfaceBase;
  using Proxy_ = UsbDeviceClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = UsbDeviceClientStub<ImplRefTraits>;

  using RequestValidator_ = UsbDeviceClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnDeviceOpenedMinVersion = 0,
    kOnDeviceClosedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnDeviceOpened_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnDeviceClosed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~UsbDeviceClient() = default;

  virtual void OnDeviceOpened() = 0;

  virtual void OnDeviceClosed() = 0;
};



class BLINK_PLATFORM_EXPORT UsbDeviceProxy
    : public UsbDevice {
 public:
  using InterfaceType = UsbDevice;

  explicit UsbDeviceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Open(OpenCallback callback) final;
  
  void Close(CloseCallback callback) final;
  
  void SetConfiguration(uint8_t value, SetConfigurationCallback callback) final;
  
  void ClaimInterface(uint8_t interface_number, ClaimInterfaceCallback callback) final;
  
  void ReleaseInterface(uint8_t interface_number, ReleaseInterfaceCallback callback) final;
  
  void SetInterfaceAlternateSetting(uint8_t interface_number, uint8_t alternate_setting, SetInterfaceAlternateSettingCallback callback) final;
  
  void Reset(ResetCallback callback) final;
  
  void ClearHalt(UsbTransferDirection direction, uint8_t endpoint_number, ClearHaltCallback callback) final;
  
  void ControlTransferIn(UsbControlTransferParamsPtr params, uint32_t length, uint32_t timeout, ControlTransferInCallback callback) final;
  
  void ControlTransferOut(UsbControlTransferParamsPtr params, ::base::span<const ::uint8_t> data, uint32_t timeout, ControlTransferOutCallback callback) final;
  
  void GenericTransferIn(uint8_t endpoint_number, uint32_t length, uint32_t timeout, GenericTransferInCallback callback) final;
  
  void GenericTransferOut(uint8_t endpoint_number, ::base::span<const ::uint8_t> data, uint32_t timeout, GenericTransferOutCallback callback) final;
  
  void IsochronousTransferIn(uint8_t endpoint_number, const ::blink::Vector<uint32_t>& packet_lengths, uint32_t timeout, IsochronousTransferInCallback callback) final;
  
  void IsochronousTransferOut(uint8_t endpoint_number, ::base::span<const ::uint8_t> data, const ::blink::Vector<uint32_t>& packet_lengths, uint32_t timeout, IsochronousTransferOutCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT UsbDeviceClientProxy
    : public UsbDeviceClient {
 public:
  using InterfaceType = UsbDeviceClient;

  explicit UsbDeviceClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnDeviceOpened() final;
  
  void OnDeviceClosed() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT UsbDeviceStubDispatch {
 public:
  static bool Accept(UsbDevice* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      UsbDevice* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<UsbDevice>>
class UsbDeviceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  UsbDeviceStub() = default;
  ~UsbDeviceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UsbDeviceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UsbDeviceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT UsbDeviceClientStubDispatch {
 public:
  static bool Accept(UsbDeviceClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      UsbDeviceClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<UsbDeviceClient>>
class UsbDeviceClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  UsbDeviceClientStub() = default;
  ~UsbDeviceClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UsbDeviceClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UsbDeviceClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT UsbDeviceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT UsbDeviceClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT UsbDeviceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};











class BLINK_PLATFORM_EXPORT UsbIsochronousPacket {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UsbIsochronousPacket, T>::value>;
  using DataView = UsbIsochronousPacketDataView;
  using Data_ = internal::UsbIsochronousPacket_Data;

  template <typename... Args>
  static UsbIsochronousPacketPtr New(Args&&... args) {
    return UsbIsochronousPacketPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UsbIsochronousPacketPtr From(const U& u) {
    return mojo::TypeConverter<UsbIsochronousPacketPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UsbIsochronousPacket>::Convert(*this);
  }


  UsbIsochronousPacket();

  UsbIsochronousPacket(
      uint32_t length,
      uint32_t transferred_length,
      UsbTransferStatus status);


  ~UsbIsochronousPacket();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UsbIsochronousPacketPtr>
  UsbIsochronousPacketPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UsbIsochronousPacket::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UsbIsochronousPacket::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UsbIsochronousPacket::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UsbIsochronousPacket::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UsbIsochronousPacket::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UsbIsochronousPacket::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UsbIsochronousPacket_UnserializedMessageContext<
            UserType, UsbIsochronousPacket::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UsbIsochronousPacket::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UsbIsochronousPacket::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UsbIsochronousPacket_UnserializedMessageContext<
            UserType, UsbIsochronousPacket::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UsbIsochronousPacket::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t length;
  
  uint32_t transferred_length;
  
  UsbTransferStatus status;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UsbIsochronousPacket::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UsbIsochronousPacket::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UsbIsochronousPacket::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UsbIsochronousPacket::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT UsbOpenDeviceResult {
 public:
  using DataView = UsbOpenDeviceResultDataView;
  using Data_ = internal::UsbOpenDeviceResult_Data;
  using Tag = Data_::UsbOpenDeviceResult_Tag;

  template <typename... Args>
  static UsbOpenDeviceResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |success|.
  static UsbOpenDeviceResultPtr NewSuccess(
      UsbOpenDeviceSuccess value);
  // Construct an instance holding |error|.
  static UsbOpenDeviceResultPtr NewError(
      UsbOpenDeviceError value);

  template <typename U>
  static UsbOpenDeviceResultPtr From(const U& u) {
    return mojo::TypeConverter<UsbOpenDeviceResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UsbOpenDeviceResult>::Convert(*this);
  }
  ~UsbOpenDeviceResult();


  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = UsbOpenDeviceResultPtr>
  UsbOpenDeviceResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, UsbOpenDeviceResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, UsbOpenDeviceResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }

  bool is_success() const { return tag_ == Tag::kSuccess; }
  UsbOpenDeviceSuccess get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  void set_success(UsbOpenDeviceSuccess success);

  bool is_error() const { return tag_ == Tag::kError; }
  UsbOpenDeviceError get_error() const {
    CHECK(tag_ == Tag::kError);
    return data_.error;
  }
  void set_error(UsbOpenDeviceError error);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UsbOpenDeviceResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<UsbOpenDeviceResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
        UsbOpenDeviceSuccess value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
        UsbOpenDeviceError value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    UsbOpenDeviceSuccess success;
    UsbOpenDeviceError error;
  };

  UsbOpenDeviceResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
      UsbOpenDeviceSuccess value);
  UsbOpenDeviceResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
      UsbOpenDeviceError value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class BLINK_PLATFORM_EXPORT UsbEndpointInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UsbEndpointInfo, T>::value>;
  using DataView = UsbEndpointInfoDataView;
  using Data_ = internal::UsbEndpointInfo_Data;

  template <typename... Args>
  static UsbEndpointInfoPtr New(Args&&... args) {
    return UsbEndpointInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UsbEndpointInfoPtr From(const U& u) {
    return mojo::TypeConverter<UsbEndpointInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UsbEndpointInfo>::Convert(*this);
  }


  UsbEndpointInfo();

  UsbEndpointInfo(
      uint8_t endpoint_number,
      UsbTransferDirection direction,
      UsbTransferType type,
      uint32_t packet_size,
      UsbSynchronizationType synchronization_type,
      UsbUsageType usage_type,
      uint8_t polling_interval,
      ::blink::Vector<uint8_t> extra_data);


  ~UsbEndpointInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UsbEndpointInfoPtr>
  UsbEndpointInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UsbEndpointInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UsbEndpointInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UsbEndpointInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UsbEndpointInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UsbEndpointInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UsbEndpointInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UsbEndpointInfo_UnserializedMessageContext<
            UserType, UsbEndpointInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UsbEndpointInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UsbEndpointInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UsbEndpointInfo_UnserializedMessageContext<
            UserType, UsbEndpointInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UsbEndpointInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint8_t endpoint_number;
  
  UsbTransferDirection direction;
  
  UsbTransferType type;
  
  uint32_t packet_size;
  
  UsbSynchronizationType synchronization_type;
  
  UsbUsageType usage_type;
  
  uint8_t polling_interval;
  
  ::blink::Vector<uint8_t> extra_data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UsbEndpointInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UsbEndpointInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UsbEndpointInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UsbEndpointInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT UsbAlternateInterfaceInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UsbAlternateInterfaceInfo, T>::value>;
  using DataView = UsbAlternateInterfaceInfoDataView;
  using Data_ = internal::UsbAlternateInterfaceInfo_Data;

  template <typename... Args>
  static UsbAlternateInterfaceInfoPtr New(Args&&... args) {
    return UsbAlternateInterfaceInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UsbAlternateInterfaceInfoPtr From(const U& u) {
    return mojo::TypeConverter<UsbAlternateInterfaceInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UsbAlternateInterfaceInfo>::Convert(*this);
  }


  UsbAlternateInterfaceInfo();

  UsbAlternateInterfaceInfo(
      uint8_t alternate_setting,
      uint8_t class_code,
      uint8_t subclass_code,
      uint8_t protocol_code,
      const ::blink::String& interface_name,
      ::blink::Vector<UsbEndpointInfoPtr> endpoints,
      ::blink::Vector<uint8_t> extra_data);

UsbAlternateInterfaceInfo(const UsbAlternateInterfaceInfo&) = delete;
UsbAlternateInterfaceInfo& operator=(const UsbAlternateInterfaceInfo&) = delete;

  ~UsbAlternateInterfaceInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UsbAlternateInterfaceInfoPtr>
  UsbAlternateInterfaceInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UsbAlternateInterfaceInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UsbAlternateInterfaceInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UsbAlternateInterfaceInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UsbAlternateInterfaceInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UsbAlternateInterfaceInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UsbAlternateInterfaceInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UsbAlternateInterfaceInfo_UnserializedMessageContext<
            UserType, UsbAlternateInterfaceInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UsbAlternateInterfaceInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UsbAlternateInterfaceInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UsbAlternateInterfaceInfo_UnserializedMessageContext<
            UserType, UsbAlternateInterfaceInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UsbAlternateInterfaceInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint8_t alternate_setting;
  
  uint8_t class_code;
  
  uint8_t subclass_code;
  
  uint8_t protocol_code;
  
  ::blink::String interface_name;
  
  ::blink::Vector<UsbEndpointInfoPtr> endpoints;
  
  ::blink::Vector<uint8_t> extra_data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UsbAlternateInterfaceInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UsbAlternateInterfaceInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UsbAlternateInterfaceInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UsbAlternateInterfaceInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT UsbInterfaceInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UsbInterfaceInfo, T>::value>;
  using DataView = UsbInterfaceInfoDataView;
  using Data_ = internal::UsbInterfaceInfo_Data;

  template <typename... Args>
  static UsbInterfaceInfoPtr New(Args&&... args) {
    return UsbInterfaceInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UsbInterfaceInfoPtr From(const U& u) {
    return mojo::TypeConverter<UsbInterfaceInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UsbInterfaceInfo>::Convert(*this);
  }


  UsbInterfaceInfo();

  UsbInterfaceInfo(
      uint8_t interface_number,
      uint8_t first_interface,
      ::blink::Vector<UsbAlternateInterfaceInfoPtr> alternates);

UsbInterfaceInfo(const UsbInterfaceInfo&) = delete;
UsbInterfaceInfo& operator=(const UsbInterfaceInfo&) = delete;

  ~UsbInterfaceInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UsbInterfaceInfoPtr>
  UsbInterfaceInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UsbInterfaceInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UsbInterfaceInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UsbInterfaceInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UsbInterfaceInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UsbInterfaceInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UsbInterfaceInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UsbInterfaceInfo_UnserializedMessageContext<
            UserType, UsbInterfaceInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UsbInterfaceInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UsbInterfaceInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UsbInterfaceInfo_UnserializedMessageContext<
            UserType, UsbInterfaceInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UsbInterfaceInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint8_t interface_number;
  
  uint8_t first_interface;
  
  ::blink::Vector<UsbAlternateInterfaceInfoPtr> alternates;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UsbInterfaceInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UsbInterfaceInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UsbInterfaceInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UsbInterfaceInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT UsbConfigurationInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UsbConfigurationInfo, T>::value>;
  using DataView = UsbConfigurationInfoDataView;
  using Data_ = internal::UsbConfigurationInfo_Data;

  template <typename... Args>
  static UsbConfigurationInfoPtr New(Args&&... args) {
    return UsbConfigurationInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UsbConfigurationInfoPtr From(const U& u) {
    return mojo::TypeConverter<UsbConfigurationInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UsbConfigurationInfo>::Convert(*this);
  }


  UsbConfigurationInfo();

  UsbConfigurationInfo(
      uint8_t configuration_value,
      const ::blink::String& configuration_name,
      bool self_powered,
      bool remote_wakeup,
      uint8_t maximum_power,
      ::blink::Vector<UsbInterfaceInfoPtr> interfaces,
      ::blink::Vector<uint8_t> extra_data);

UsbConfigurationInfo(const UsbConfigurationInfo&) = delete;
UsbConfigurationInfo& operator=(const UsbConfigurationInfo&) = delete;

  ~UsbConfigurationInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UsbConfigurationInfoPtr>
  UsbConfigurationInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UsbConfigurationInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UsbConfigurationInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UsbConfigurationInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UsbConfigurationInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UsbConfigurationInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UsbConfigurationInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UsbConfigurationInfo_UnserializedMessageContext<
            UserType, UsbConfigurationInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UsbConfigurationInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UsbConfigurationInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UsbConfigurationInfo_UnserializedMessageContext<
            UserType, UsbConfigurationInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UsbConfigurationInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint8_t configuration_value;
  
  ::blink::String configuration_name;
  
  bool self_powered;
  
  bool remote_wakeup;
  
  uint8_t maximum_power;
  
  ::blink::Vector<UsbInterfaceInfoPtr> interfaces;
  
  ::blink::Vector<uint8_t> extra_data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UsbConfigurationInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UsbConfigurationInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UsbConfigurationInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UsbConfigurationInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT UsbDeviceInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UsbDeviceInfo, T>::value>;
  using DataView = UsbDeviceInfoDataView;
  using Data_ = internal::UsbDeviceInfo_Data;

  template <typename... Args>
  static UsbDeviceInfoPtr New(Args&&... args) {
    return UsbDeviceInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UsbDeviceInfoPtr From(const U& u) {
    return mojo::TypeConverter<UsbDeviceInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UsbDeviceInfo>::Convert(*this);
  }


  UsbDeviceInfo();

  UsbDeviceInfo(
      const ::blink::String& guid,
      uint8_t usb_version_major,
      uint8_t usb_version_minor,
      uint8_t usb_version_subminor,
      uint8_t class_code,
      uint8_t subclass_code,
      uint8_t protocol_code,
      uint32_t bus_number,
      uint32_t port_number,
      uint16_t vendor_id,
      uint16_t product_id,
      uint8_t device_version_major,
      uint8_t device_version_minor,
      uint8_t device_version_subminor,
      const ::blink::String& manufacturer_name,
      const ::blink::String& product_name,
      const ::blink::String& serial_number,
      const std::optional<::blink::KURL>& webusb_landing_page,
      uint8_t active_configuration,
      ::blink::Vector<UsbConfigurationInfoPtr> configurations);

UsbDeviceInfo(const UsbDeviceInfo&) = delete;
UsbDeviceInfo& operator=(const UsbDeviceInfo&) = delete;

  ~UsbDeviceInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UsbDeviceInfoPtr>
  UsbDeviceInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UsbDeviceInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UsbDeviceInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UsbDeviceInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UsbDeviceInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UsbDeviceInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UsbDeviceInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UsbDeviceInfo_UnserializedMessageContext<
            UserType, UsbDeviceInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UsbDeviceInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UsbDeviceInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UsbDeviceInfo_UnserializedMessageContext<
            UserType, UsbDeviceInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UsbDeviceInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String guid;
  
  uint8_t usb_version_major;
  
  uint8_t usb_version_minor;
  
  uint8_t usb_version_subminor;
  
  uint8_t class_code;
  
  uint8_t subclass_code;
  
  uint8_t protocol_code;
  
  uint32_t bus_number;
  
  uint32_t port_number;
  
  uint16_t vendor_id;
  
  uint16_t product_id;
  
  uint8_t device_version_major;
  
  uint8_t device_version_minor;
  
  uint8_t device_version_subminor;
  
  ::blink::String manufacturer_name;
  
  ::blink::String product_name;
  
  ::blink::String serial_number;
  
  std::optional<::blink::KURL> webusb_landing_page;
  
  uint8_t active_configuration;
  
  ::blink::Vector<UsbConfigurationInfoPtr> configurations;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UsbDeviceInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UsbDeviceInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UsbDeviceInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UsbDeviceInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT UsbControlTransferParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UsbControlTransferParams, T>::value>;
  using DataView = UsbControlTransferParamsDataView;
  using Data_ = internal::UsbControlTransferParams_Data;
  
  static constexpr char kSecurityKeyAOAModel[] = "12eba9f901039b36";

  template <typename... Args>
  static UsbControlTransferParamsPtr New(Args&&... args) {
    return UsbControlTransferParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UsbControlTransferParamsPtr From(const U& u) {
    return mojo::TypeConverter<UsbControlTransferParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UsbControlTransferParams>::Convert(*this);
  }


  UsbControlTransferParams();

  UsbControlTransferParams(
      UsbControlTransferType type,
      UsbControlTransferRecipient recipient,
      uint8_t request,
      uint16_t value,
      uint16_t index);


  ~UsbControlTransferParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UsbControlTransferParamsPtr>
  UsbControlTransferParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UsbControlTransferParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UsbControlTransferParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UsbControlTransferParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UsbControlTransferParams::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UsbControlTransferParams::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UsbControlTransferParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UsbControlTransferParams_UnserializedMessageContext<
            UserType, UsbControlTransferParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UsbControlTransferParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UsbControlTransferParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UsbControlTransferParams_UnserializedMessageContext<
            UserType, UsbControlTransferParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UsbControlTransferParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  UsbControlTransferType type;
  
  UsbControlTransferRecipient recipient;
  
  uint8_t request;
  
  uint16_t value;
  
  uint16_t index;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UsbControlTransferParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UsbControlTransferParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UsbControlTransferParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UsbControlTransferParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename UnionPtrType>
UsbOpenDeviceResultPtr UsbOpenDeviceResult::Clone() const {
  switch (tag_) {
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(data_.success));
    case Tag::kError:
      return NewError(
          mojo::Clone(data_.error));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, UsbOpenDeviceResult>::value>::type*>
bool UsbOpenDeviceResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSuccess:
      return mojo::Equals(data_.success, other.data_.success);
    case Tag::kError:
      return mojo::Equals(data_.error, other.data_.error);
  }

  return false;
}
template <typename StructPtrType>
UsbEndpointInfoPtr UsbEndpointInfo::Clone() const {
  return New(
      mojo::Clone(endpoint_number),
      mojo::Clone(direction),
      mojo::Clone(type),
      mojo::Clone(packet_size),
      mojo::Clone(synchronization_type),
      mojo::Clone(usage_type),
      mojo::Clone(polling_interval),
      mojo::Clone(extra_data)
  );
}

template <typename T, UsbEndpointInfo::EnableIfSame<T>*>
bool UsbEndpointInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->endpoint_number, other_struct.endpoint_number))
    return false;
  if (!mojo::Equals(this->direction, other_struct.direction))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->packet_size, other_struct.packet_size))
    return false;
  if (!mojo::Equals(this->synchronization_type, other_struct.synchronization_type))
    return false;
  if (!mojo::Equals(this->usage_type, other_struct.usage_type))
    return false;
  if (!mojo::Equals(this->polling_interval, other_struct.polling_interval))
    return false;
  if (!mojo::Equals(this->extra_data, other_struct.extra_data))
    return false;
  return true;
}

template <typename T, UsbEndpointInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.endpoint_number < rhs.endpoint_number)
    return true;
  if (rhs.endpoint_number < lhs.endpoint_number)
    return false;
  if (lhs.direction < rhs.direction)
    return true;
  if (rhs.direction < lhs.direction)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.packet_size < rhs.packet_size)
    return true;
  if (rhs.packet_size < lhs.packet_size)
    return false;
  if (lhs.synchronization_type < rhs.synchronization_type)
    return true;
  if (rhs.synchronization_type < lhs.synchronization_type)
    return false;
  if (lhs.usage_type < rhs.usage_type)
    return true;
  if (rhs.usage_type < lhs.usage_type)
    return false;
  if (lhs.polling_interval < rhs.polling_interval)
    return true;
  if (rhs.polling_interval < lhs.polling_interval)
    return false;
  if (lhs.extra_data < rhs.extra_data)
    return true;
  if (rhs.extra_data < lhs.extra_data)
    return false;
  return false;
}
template <typename StructPtrType>
UsbAlternateInterfaceInfoPtr UsbAlternateInterfaceInfo::Clone() const {
  return New(
      mojo::Clone(alternate_setting),
      mojo::Clone(class_code),
      mojo::Clone(subclass_code),
      mojo::Clone(protocol_code),
      mojo::Clone(interface_name),
      mojo::Clone(endpoints),
      mojo::Clone(extra_data)
  );
}

template <typename T, UsbAlternateInterfaceInfo::EnableIfSame<T>*>
bool UsbAlternateInterfaceInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->alternate_setting, other_struct.alternate_setting))
    return false;
  if (!mojo::Equals(this->class_code, other_struct.class_code))
    return false;
  if (!mojo::Equals(this->subclass_code, other_struct.subclass_code))
    return false;
  if (!mojo::Equals(this->protocol_code, other_struct.protocol_code))
    return false;
  if (!mojo::Equals(this->interface_name, other_struct.interface_name))
    return false;
  if (!mojo::Equals(this->endpoints, other_struct.endpoints))
    return false;
  if (!mojo::Equals(this->extra_data, other_struct.extra_data))
    return false;
  return true;
}

template <typename T, UsbAlternateInterfaceInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.alternate_setting < rhs.alternate_setting)
    return true;
  if (rhs.alternate_setting < lhs.alternate_setting)
    return false;
  if (lhs.class_code < rhs.class_code)
    return true;
  if (rhs.class_code < lhs.class_code)
    return false;
  if (lhs.subclass_code < rhs.subclass_code)
    return true;
  if (rhs.subclass_code < lhs.subclass_code)
    return false;
  if (lhs.protocol_code < rhs.protocol_code)
    return true;
  if (rhs.protocol_code < lhs.protocol_code)
    return false;
  if (lhs.interface_name < rhs.interface_name)
    return true;
  if (rhs.interface_name < lhs.interface_name)
    return false;
  if (lhs.endpoints < rhs.endpoints)
    return true;
  if (rhs.endpoints < lhs.endpoints)
    return false;
  if (lhs.extra_data < rhs.extra_data)
    return true;
  if (rhs.extra_data < lhs.extra_data)
    return false;
  return false;
}
template <typename StructPtrType>
UsbInterfaceInfoPtr UsbInterfaceInfo::Clone() const {
  return New(
      mojo::Clone(interface_number),
      mojo::Clone(first_interface),
      mojo::Clone(alternates)
  );
}

template <typename T, UsbInterfaceInfo::EnableIfSame<T>*>
bool UsbInterfaceInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->interface_number, other_struct.interface_number))
    return false;
  if (!mojo::Equals(this->first_interface, other_struct.first_interface))
    return false;
  if (!mojo::Equals(this->alternates, other_struct.alternates))
    return false;
  return true;
}

template <typename T, UsbInterfaceInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.interface_number < rhs.interface_number)
    return true;
  if (rhs.interface_number < lhs.interface_number)
    return false;
  if (lhs.first_interface < rhs.first_interface)
    return true;
  if (rhs.first_interface < lhs.first_interface)
    return false;
  if (lhs.alternates < rhs.alternates)
    return true;
  if (rhs.alternates < lhs.alternates)
    return false;
  return false;
}
template <typename StructPtrType>
UsbConfigurationInfoPtr UsbConfigurationInfo::Clone() const {
  return New(
      mojo::Clone(configuration_value),
      mojo::Clone(configuration_name),
      mojo::Clone(self_powered),
      mojo::Clone(remote_wakeup),
      mojo::Clone(maximum_power),
      mojo::Clone(interfaces),
      mojo::Clone(extra_data)
  );
}

template <typename T, UsbConfigurationInfo::EnableIfSame<T>*>
bool UsbConfigurationInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->configuration_value, other_struct.configuration_value))
    return false;
  if (!mojo::Equals(this->configuration_name, other_struct.configuration_name))
    return false;
  if (!mojo::Equals(this->self_powered, other_struct.self_powered))
    return false;
  if (!mojo::Equals(this->remote_wakeup, other_struct.remote_wakeup))
    return false;
  if (!mojo::Equals(this->maximum_power, other_struct.maximum_power))
    return false;
  if (!mojo::Equals(this->interfaces, other_struct.interfaces))
    return false;
  if (!mojo::Equals(this->extra_data, other_struct.extra_data))
    return false;
  return true;
}

template <typename T, UsbConfigurationInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.configuration_value < rhs.configuration_value)
    return true;
  if (rhs.configuration_value < lhs.configuration_value)
    return false;
  if (lhs.configuration_name < rhs.configuration_name)
    return true;
  if (rhs.configuration_name < lhs.configuration_name)
    return false;
  if (lhs.self_powered < rhs.self_powered)
    return true;
  if (rhs.self_powered < lhs.self_powered)
    return false;
  if (lhs.remote_wakeup < rhs.remote_wakeup)
    return true;
  if (rhs.remote_wakeup < lhs.remote_wakeup)
    return false;
  if (lhs.maximum_power < rhs.maximum_power)
    return true;
  if (rhs.maximum_power < lhs.maximum_power)
    return false;
  if (lhs.interfaces < rhs.interfaces)
    return true;
  if (rhs.interfaces < lhs.interfaces)
    return false;
  if (lhs.extra_data < rhs.extra_data)
    return true;
  if (rhs.extra_data < lhs.extra_data)
    return false;
  return false;
}
template <typename StructPtrType>
UsbDeviceInfoPtr UsbDeviceInfo::Clone() const {
  return New(
      mojo::Clone(guid),
      mojo::Clone(usb_version_major),
      mojo::Clone(usb_version_minor),
      mojo::Clone(usb_version_subminor),
      mojo::Clone(class_code),
      mojo::Clone(subclass_code),
      mojo::Clone(protocol_code),
      mojo::Clone(bus_number),
      mojo::Clone(port_number),
      mojo::Clone(vendor_id),
      mojo::Clone(product_id),
      mojo::Clone(device_version_major),
      mojo::Clone(device_version_minor),
      mojo::Clone(device_version_subminor),
      mojo::Clone(manufacturer_name),
      mojo::Clone(product_name),
      mojo::Clone(serial_number),
      mojo::Clone(webusb_landing_page),
      mojo::Clone(active_configuration),
      mojo::Clone(configurations)
  );
}

template <typename T, UsbDeviceInfo::EnableIfSame<T>*>
bool UsbDeviceInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->guid, other_struct.guid))
    return false;
  if (!mojo::Equals(this->usb_version_major, other_struct.usb_version_major))
    return false;
  if (!mojo::Equals(this->usb_version_minor, other_struct.usb_version_minor))
    return false;
  if (!mojo::Equals(this->usb_version_subminor, other_struct.usb_version_subminor))
    return false;
  if (!mojo::Equals(this->class_code, other_struct.class_code))
    return false;
  if (!mojo::Equals(this->subclass_code, other_struct.subclass_code))
    return false;
  if (!mojo::Equals(this->protocol_code, other_struct.protocol_code))
    return false;
  if (!mojo::Equals(this->bus_number, other_struct.bus_number))
    return false;
  if (!mojo::Equals(this->port_number, other_struct.port_number))
    return false;
  if (!mojo::Equals(this->vendor_id, other_struct.vendor_id))
    return false;
  if (!mojo::Equals(this->product_id, other_struct.product_id))
    return false;
  if (!mojo::Equals(this->device_version_major, other_struct.device_version_major))
    return false;
  if (!mojo::Equals(this->device_version_minor, other_struct.device_version_minor))
    return false;
  if (!mojo::Equals(this->device_version_subminor, other_struct.device_version_subminor))
    return false;
  if (!mojo::Equals(this->manufacturer_name, other_struct.manufacturer_name))
    return false;
  if (!mojo::Equals(this->product_name, other_struct.product_name))
    return false;
  if (!mojo::Equals(this->serial_number, other_struct.serial_number))
    return false;
  if (!mojo::Equals(this->webusb_landing_page, other_struct.webusb_landing_page))
    return false;
  if (!mojo::Equals(this->active_configuration, other_struct.active_configuration))
    return false;
  if (!mojo::Equals(this->configurations, other_struct.configurations))
    return false;
  return true;
}

template <typename T, UsbDeviceInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.guid < rhs.guid)
    return true;
  if (rhs.guid < lhs.guid)
    return false;
  if (lhs.usb_version_major < rhs.usb_version_major)
    return true;
  if (rhs.usb_version_major < lhs.usb_version_major)
    return false;
  if (lhs.usb_version_minor < rhs.usb_version_minor)
    return true;
  if (rhs.usb_version_minor < lhs.usb_version_minor)
    return false;
  if (lhs.usb_version_subminor < rhs.usb_version_subminor)
    return true;
  if (rhs.usb_version_subminor < lhs.usb_version_subminor)
    return false;
  if (lhs.class_code < rhs.class_code)
    return true;
  if (rhs.class_code < lhs.class_code)
    return false;
  if (lhs.subclass_code < rhs.subclass_code)
    return true;
  if (rhs.subclass_code < lhs.subclass_code)
    return false;
  if (lhs.protocol_code < rhs.protocol_code)
    return true;
  if (rhs.protocol_code < lhs.protocol_code)
    return false;
  if (lhs.bus_number < rhs.bus_number)
    return true;
  if (rhs.bus_number < lhs.bus_number)
    return false;
  if (lhs.port_number < rhs.port_number)
    return true;
  if (rhs.port_number < lhs.port_number)
    return false;
  if (lhs.vendor_id < rhs.vendor_id)
    return true;
  if (rhs.vendor_id < lhs.vendor_id)
    return false;
  if (lhs.product_id < rhs.product_id)
    return true;
  if (rhs.product_id < lhs.product_id)
    return false;
  if (lhs.device_version_major < rhs.device_version_major)
    return true;
  if (rhs.device_version_major < lhs.device_version_major)
    return false;
  if (lhs.device_version_minor < rhs.device_version_minor)
    return true;
  if (rhs.device_version_minor < lhs.device_version_minor)
    return false;
  if (lhs.device_version_subminor < rhs.device_version_subminor)
    return true;
  if (rhs.device_version_subminor < lhs.device_version_subminor)
    return false;
  if (lhs.manufacturer_name < rhs.manufacturer_name)
    return true;
  if (rhs.manufacturer_name < lhs.manufacturer_name)
    return false;
  if (lhs.product_name < rhs.product_name)
    return true;
  if (rhs.product_name < lhs.product_name)
    return false;
  if (lhs.serial_number < rhs.serial_number)
    return true;
  if (rhs.serial_number < lhs.serial_number)
    return false;
  if (lhs.webusb_landing_page < rhs.webusb_landing_page)
    return true;
  if (rhs.webusb_landing_page < lhs.webusb_landing_page)
    return false;
  if (lhs.active_configuration < rhs.active_configuration)
    return true;
  if (rhs.active_configuration < lhs.active_configuration)
    return false;
  if (lhs.configurations < rhs.configurations)
    return true;
  if (rhs.configurations < lhs.configurations)
    return false;
  return false;
}
template <typename StructPtrType>
UsbControlTransferParamsPtr UsbControlTransferParams::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(recipient),
      mojo::Clone(request),
      mojo::Clone(value),
      mojo::Clone(index)
  );
}

template <typename T, UsbControlTransferParams::EnableIfSame<T>*>
bool UsbControlTransferParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->recipient, other_struct.recipient))
    return false;
  if (!mojo::Equals(this->request, other_struct.request))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  if (!mojo::Equals(this->index, other_struct.index))
    return false;
  return true;
}

template <typename T, UsbControlTransferParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.recipient < rhs.recipient)
    return true;
  if (rhs.recipient < lhs.recipient)
    return false;
  if (lhs.request < rhs.request)
    return true;
  if (rhs.request < lhs.request)
    return false;
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  if (lhs.index < rhs.index)
    return true;
  if (rhs.index < lhs.index)
    return false;
  return false;
}
template <typename StructPtrType>
UsbIsochronousPacketPtr UsbIsochronousPacket::Clone() const {
  return New(
      mojo::Clone(length),
      mojo::Clone(transferred_length),
      mojo::Clone(status)
  );
}

template <typename T, UsbIsochronousPacket::EnableIfSame<T>*>
bool UsbIsochronousPacket::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->length, other_struct.length))
    return false;
  if (!mojo::Equals(this->transferred_length, other_struct.transferred_length))
    return false;
  if (!mojo::Equals(this->status, other_struct.status))
    return false;
  return true;
}

template <typename T, UsbIsochronousPacket::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.length < rhs.length)
    return true;
  if (rhs.length < lhs.length)
    return false;
  if (lhs.transferred_length < rhs.transferred_length)
    return true;
  if (rhs.transferred_length < lhs.transferred_length)
    return false;
  if (lhs.status < rhs.status)
    return true;
  if (rhs.status < lhs.status)
    return false;
  return false;
}


}  // device::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::device::mojom::blink::UsbEndpointInfo::DataView,
                                         ::device::mojom::blink::UsbEndpointInfoPtr> {
  static bool IsNull(const ::device::mojom::blink::UsbEndpointInfoPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::UsbEndpointInfoPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::UsbEndpointInfo::endpoint_number) endpoint_number(
      const ::device::mojom::blink::UsbEndpointInfoPtr& input) {
    return input->endpoint_number;
  }

  static decltype(::device::mojom::blink::UsbEndpointInfo::direction) direction(
      const ::device::mojom::blink::UsbEndpointInfoPtr& input) {
    return input->direction;
  }

  static decltype(::device::mojom::blink::UsbEndpointInfo::type) type(
      const ::device::mojom::blink::UsbEndpointInfoPtr& input) {
    return input->type;
  }

  static decltype(::device::mojom::blink::UsbEndpointInfo::packet_size) packet_size(
      const ::device::mojom::blink::UsbEndpointInfoPtr& input) {
    return input->packet_size;
  }

  static decltype(::device::mojom::blink::UsbEndpointInfo::synchronization_type) synchronization_type(
      const ::device::mojom::blink::UsbEndpointInfoPtr& input) {
    return input->synchronization_type;
  }

  static decltype(::device::mojom::blink::UsbEndpointInfo::usage_type) usage_type(
      const ::device::mojom::blink::UsbEndpointInfoPtr& input) {
    return input->usage_type;
  }

  static decltype(::device::mojom::blink::UsbEndpointInfo::polling_interval) polling_interval(
      const ::device::mojom::blink::UsbEndpointInfoPtr& input) {
    return input->polling_interval;
  }

  static const decltype(::device::mojom::blink::UsbEndpointInfo::extra_data)& extra_data(
      const ::device::mojom::blink::UsbEndpointInfoPtr& input) {
    return input->extra_data;
  }

  static bool Read(::device::mojom::blink::UsbEndpointInfo::DataView input, ::device::mojom::blink::UsbEndpointInfoPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::device::mojom::blink::UsbAlternateInterfaceInfo::DataView,
                                         ::device::mojom::blink::UsbAlternateInterfaceInfoPtr> {
  static bool IsNull(const ::device::mojom::blink::UsbAlternateInterfaceInfoPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::UsbAlternateInterfaceInfoPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::UsbAlternateInterfaceInfo::alternate_setting) alternate_setting(
      const ::device::mojom::blink::UsbAlternateInterfaceInfoPtr& input) {
    return input->alternate_setting;
  }

  static decltype(::device::mojom::blink::UsbAlternateInterfaceInfo::class_code) class_code(
      const ::device::mojom::blink::UsbAlternateInterfaceInfoPtr& input) {
    return input->class_code;
  }

  static decltype(::device::mojom::blink::UsbAlternateInterfaceInfo::subclass_code) subclass_code(
      const ::device::mojom::blink::UsbAlternateInterfaceInfoPtr& input) {
    return input->subclass_code;
  }

  static decltype(::device::mojom::blink::UsbAlternateInterfaceInfo::protocol_code) protocol_code(
      const ::device::mojom::blink::UsbAlternateInterfaceInfoPtr& input) {
    return input->protocol_code;
  }

  static const decltype(::device::mojom::blink::UsbAlternateInterfaceInfo::interface_name)& interface_name(
      const ::device::mojom::blink::UsbAlternateInterfaceInfoPtr& input) {
    return input->interface_name;
  }

  static const decltype(::device::mojom::blink::UsbAlternateInterfaceInfo::endpoints)& endpoints(
      const ::device::mojom::blink::UsbAlternateInterfaceInfoPtr& input) {
    return input->endpoints;
  }

  static const decltype(::device::mojom::blink::UsbAlternateInterfaceInfo::extra_data)& extra_data(
      const ::device::mojom::blink::UsbAlternateInterfaceInfoPtr& input) {
    return input->extra_data;
  }

  static bool Read(::device::mojom::blink::UsbAlternateInterfaceInfo::DataView input, ::device::mojom::blink::UsbAlternateInterfaceInfoPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::device::mojom::blink::UsbInterfaceInfo::DataView,
                                         ::device::mojom::blink::UsbInterfaceInfoPtr> {
  static bool IsNull(const ::device::mojom::blink::UsbInterfaceInfoPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::UsbInterfaceInfoPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::UsbInterfaceInfo::interface_number) interface_number(
      const ::device::mojom::blink::UsbInterfaceInfoPtr& input) {
    return input->interface_number;
  }

  static decltype(::device::mojom::blink::UsbInterfaceInfo::first_interface) first_interface(
      const ::device::mojom::blink::UsbInterfaceInfoPtr& input) {
    return input->first_interface;
  }

  static const decltype(::device::mojom::blink::UsbInterfaceInfo::alternates)& alternates(
      const ::device::mojom::blink::UsbInterfaceInfoPtr& input) {
    return input->alternates;
  }

  static bool Read(::device::mojom::blink::UsbInterfaceInfo::DataView input, ::device::mojom::blink::UsbInterfaceInfoPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::device::mojom::blink::UsbConfigurationInfo::DataView,
                                         ::device::mojom::blink::UsbConfigurationInfoPtr> {
  static bool IsNull(const ::device::mojom::blink::UsbConfigurationInfoPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::UsbConfigurationInfoPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::UsbConfigurationInfo::configuration_value) configuration_value(
      const ::device::mojom::blink::UsbConfigurationInfoPtr& input) {
    return input->configuration_value;
  }

  static const decltype(::device::mojom::blink::UsbConfigurationInfo::configuration_name)& configuration_name(
      const ::device::mojom::blink::UsbConfigurationInfoPtr& input) {
    return input->configuration_name;
  }

  static decltype(::device::mojom::blink::UsbConfigurationInfo::self_powered) self_powered(
      const ::device::mojom::blink::UsbConfigurationInfoPtr& input) {
    return input->self_powered;
  }

  static decltype(::device::mojom::blink::UsbConfigurationInfo::remote_wakeup) remote_wakeup(
      const ::device::mojom::blink::UsbConfigurationInfoPtr& input) {
    return input->remote_wakeup;
  }

  static decltype(::device::mojom::blink::UsbConfigurationInfo::maximum_power) maximum_power(
      const ::device::mojom::blink::UsbConfigurationInfoPtr& input) {
    return input->maximum_power;
  }

  static const decltype(::device::mojom::blink::UsbConfigurationInfo::interfaces)& interfaces(
      const ::device::mojom::blink::UsbConfigurationInfoPtr& input) {
    return input->interfaces;
  }

  static const decltype(::device::mojom::blink::UsbConfigurationInfo::extra_data)& extra_data(
      const ::device::mojom::blink::UsbConfigurationInfoPtr& input) {
    return input->extra_data;
  }

  static bool Read(::device::mojom::blink::UsbConfigurationInfo::DataView input, ::device::mojom::blink::UsbConfigurationInfoPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::device::mojom::blink::UsbDeviceInfo::DataView,
                                         ::device::mojom::blink::UsbDeviceInfoPtr> {
  static bool IsNull(const ::device::mojom::blink::UsbDeviceInfoPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::UsbDeviceInfoPtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::UsbDeviceInfo::guid)& guid(
      const ::device::mojom::blink::UsbDeviceInfoPtr& input) {
    return input->guid;
  }

  static decltype(::device::mojom::blink::UsbDeviceInfo::usb_version_major) usb_version_major(
      const ::device::mojom::blink::UsbDeviceInfoPtr& input) {
    return input->usb_version_major;
  }

  static decltype(::device::mojom::blink::UsbDeviceInfo::usb_version_minor) usb_version_minor(
      const ::device::mojom::blink::UsbDeviceInfoPtr& input) {
    return input->usb_version_minor;
  }

  static decltype(::device::mojom::blink::UsbDeviceInfo::usb_version_subminor) usb_version_subminor(
      const ::device::mojom::blink::UsbDeviceInfoPtr& input) {
    return input->usb_version_subminor;
  }

  static decltype(::device::mojom::blink::UsbDeviceInfo::class_code) class_code(
      const ::device::mojom::blink::UsbDeviceInfoPtr& input) {
    return input->class_code;
  }

  static decltype(::device::mojom::blink::UsbDeviceInfo::subclass_code) subclass_code(
      const ::device::mojom::blink::UsbDeviceInfoPtr& input) {
    return input->subclass_code;
  }

  static decltype(::device::mojom::blink::UsbDeviceInfo::protocol_code) protocol_code(
      const ::device::mojom::blink::UsbDeviceInfoPtr& input) {
    return input->protocol_code;
  }

  static decltype(::device::mojom::blink::UsbDeviceInfo::bus_number) bus_number(
      const ::device::mojom::blink::UsbDeviceInfoPtr& input) {
    return input->bus_number;
  }

  static decltype(::device::mojom::blink::UsbDeviceInfo::port_number) port_number(
      const ::device::mojom::blink::UsbDeviceInfoPtr& input) {
    return input->port_number;
  }

  static decltype(::device::mojom::blink::UsbDeviceInfo::vendor_id) vendor_id(
      const ::device::mojom::blink::UsbDeviceInfoPtr& input) {
    return input->vendor_id;
  }

  static decltype(::device::mojom::blink::UsbDeviceInfo::product_id) product_id(
      const ::device::mojom::blink::UsbDeviceInfoPtr& input) {
    return input->product_id;
  }

  static decltype(::device::mojom::blink::UsbDeviceInfo::device_version_major) device_version_major(
      const ::device::mojom::blink::UsbDeviceInfoPtr& input) {
    return input->device_version_major;
  }

  static decltype(::device::mojom::blink::UsbDeviceInfo::device_version_minor) device_version_minor(
      const ::device::mojom::blink::UsbDeviceInfoPtr& input) {
    return input->device_version_minor;
  }

  static decltype(::device::mojom::blink::UsbDeviceInfo::device_version_subminor) device_version_subminor(
      const ::device::mojom::blink::UsbDeviceInfoPtr& input) {
    return input->device_version_subminor;
  }

  static const decltype(::device::mojom::blink::UsbDeviceInfo::manufacturer_name)& manufacturer_name(
      const ::device::mojom::blink::UsbDeviceInfoPtr& input) {
    return input->manufacturer_name;
  }

  static const decltype(::device::mojom::blink::UsbDeviceInfo::product_name)& product_name(
      const ::device::mojom::blink::UsbDeviceInfoPtr& input) {
    return input->product_name;
  }

  static const decltype(::device::mojom::blink::UsbDeviceInfo::serial_number)& serial_number(
      const ::device::mojom::blink::UsbDeviceInfoPtr& input) {
    return input->serial_number;
  }

  static const decltype(::device::mojom::blink::UsbDeviceInfo::webusb_landing_page)& webusb_landing_page(
      const ::device::mojom::blink::UsbDeviceInfoPtr& input) {
    return input->webusb_landing_page;
  }

  static decltype(::device::mojom::blink::UsbDeviceInfo::active_configuration) active_configuration(
      const ::device::mojom::blink::UsbDeviceInfoPtr& input) {
    return input->active_configuration;
  }

  static const decltype(::device::mojom::blink::UsbDeviceInfo::configurations)& configurations(
      const ::device::mojom::blink::UsbDeviceInfoPtr& input) {
    return input->configurations;
  }

  static bool Read(::device::mojom::blink::UsbDeviceInfo::DataView input, ::device::mojom::blink::UsbDeviceInfoPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::device::mojom::blink::UsbControlTransferParams::DataView,
                                         ::device::mojom::blink::UsbControlTransferParamsPtr> {
  static bool IsNull(const ::device::mojom::blink::UsbControlTransferParamsPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::UsbControlTransferParamsPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::UsbControlTransferParams::type) type(
      const ::device::mojom::blink::UsbControlTransferParamsPtr& input) {
    return input->type;
  }

  static decltype(::device::mojom::blink::UsbControlTransferParams::recipient) recipient(
      const ::device::mojom::blink::UsbControlTransferParamsPtr& input) {
    return input->recipient;
  }

  static decltype(::device::mojom::blink::UsbControlTransferParams::request) request(
      const ::device::mojom::blink::UsbControlTransferParamsPtr& input) {
    return input->request;
  }

  static decltype(::device::mojom::blink::UsbControlTransferParams::value) value(
      const ::device::mojom::blink::UsbControlTransferParamsPtr& input) {
    return input->value;
  }

  static decltype(::device::mojom::blink::UsbControlTransferParams::index) index(
      const ::device::mojom::blink::UsbControlTransferParamsPtr& input) {
    return input->index;
  }

  static bool Read(::device::mojom::blink::UsbControlTransferParams::DataView input, ::device::mojom::blink::UsbControlTransferParamsPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::device::mojom::blink::UsbIsochronousPacket::DataView,
                                         ::device::mojom::blink::UsbIsochronousPacketPtr> {
  static bool IsNull(const ::device::mojom::blink::UsbIsochronousPacketPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::UsbIsochronousPacketPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::UsbIsochronousPacket::length) length(
      const ::device::mojom::blink::UsbIsochronousPacketPtr& input) {
    return input->length;
  }

  static decltype(::device::mojom::blink::UsbIsochronousPacket::transferred_length) transferred_length(
      const ::device::mojom::blink::UsbIsochronousPacketPtr& input) {
    return input->transferred_length;
  }

  static decltype(::device::mojom::blink::UsbIsochronousPacket::status) status(
      const ::device::mojom::blink::UsbIsochronousPacketPtr& input) {
    return input->status;
  }

  static bool Read(::device::mojom::blink::UsbIsochronousPacket::DataView input, ::device::mojom::blink::UsbIsochronousPacketPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT UnionTraits<::device::mojom::blink::UsbOpenDeviceResult::DataView,
                                        ::device::mojom::blink::UsbOpenDeviceResultPtr> {
  static bool IsNull(const ::device::mojom::blink::UsbOpenDeviceResultPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::UsbOpenDeviceResultPtr* output) { output->reset(); }

  static ::device::mojom::blink::UsbOpenDeviceResult::Tag GetTag(const ::device::mojom::blink::UsbOpenDeviceResultPtr& input) {
    return input->which();
  }

  static  ::device::mojom::blink::UsbOpenDeviceSuccess success(const ::device::mojom::blink::UsbOpenDeviceResultPtr& input) {
    return input->get_success();
  }

  static  ::device::mojom::blink::UsbOpenDeviceError error(const ::device::mojom::blink::UsbOpenDeviceResultPtr& input) {
    return input->get_error();
  }

  static bool Read(::device::mojom::blink::UsbOpenDeviceResult::DataView input, ::device::mojom::blink::UsbOpenDeviceResultPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_USB_DEVICE_MOJOM_BLINK_H_