// services/device/public/mojom/usb_manager.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_USB_MANAGER_MOJOM_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_USB_MANAGER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/device/public/mojom/usb_manager.mojom-features.h"  // IWYU pragma: export
#include "services/device/public/mojom/usb_manager.mojom-shared.h"  // IWYU pragma: export
#include "services/device/public/mojom/usb_manager.mojom-forward.h"  // IWYU pragma: export
#include "services/device/public/mojom/usb_device.mojom-forward.h"
#include "services/device/public/mojom/usb_enumeration_options.mojom-forward.h"
#include "services/device/public/mojom/usb_manager_client.mojom-forward.h"
#include "mojo/public/mojom/base/file.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace device::mojom {

class UsbDeviceManagerProxy;

template <typename ImplRefTraits>
class UsbDeviceManagerStub;

class UsbDeviceManagerRequestValidator;
class UsbDeviceManagerResponseValidator;


class UsbDeviceManager
    : public UsbDeviceManagerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.UsbDeviceManager";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = UsbDeviceManagerInterfaceBase;
  using Proxy_ = UsbDeviceManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = UsbDeviceManagerStub<ImplRefTraits>;

  using RequestValidator_ = UsbDeviceManagerRequestValidator;
  using ResponseValidator_ = UsbDeviceManagerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kEnumerateDevicesAndSetClientMinVersion = 0,
    kGetDevicesMinVersion = 0,
    kGetDeviceMinVersion = 0,
    kGetSecurityKeyDeviceMinVersion = 0,
    kSetClientMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct EnumerateDevicesAndSetClient_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetDevices_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetDevice_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetSecurityKeyDevice_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetClient_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~UsbDeviceManager() = default;

  using EnumerateDevicesAndSetClientCallback = base::OnceCallback<void(std::vector<::device::mojom::UsbDeviceInfoPtr>)>;
  using EnumerateDevicesAndSetClientMojoCallback = base::OnceCallback<void(std::vector<::device::mojom::UsbDeviceInfoPtr>)>;

  virtual void EnumerateDevicesAndSetClient(::mojo::PendingAssociatedRemote<::device::mojom::UsbDeviceManagerClient> client, EnumerateDevicesAndSetClientCallback callback) = 0;

  using GetDevicesCallback = base::OnceCallback<void(std::vector<::device::mojom::UsbDeviceInfoPtr>)>;
  using GetDevicesMojoCallback = base::OnceCallback<void(std::vector<::device::mojom::UsbDeviceInfoPtr>)>;

  virtual void GetDevices(::device::mojom::UsbEnumerationOptionsPtr options, GetDevicesCallback callback) = 0;

  virtual void GetDevice(const std::string& guid, const std::vector<uint8_t>& blocked_interface_classes, ::mojo::PendingReceiver<::device::mojom::UsbDevice> device_receiver, ::mojo::PendingRemote<::device::mojom::UsbDeviceClient> device_client) = 0;

  virtual void GetSecurityKeyDevice(const std::string& guid, ::mojo::PendingReceiver<::device::mojom::UsbDevice> device_receiver, ::mojo::PendingRemote<::device::mojom::UsbDeviceClient> device_client) = 0;

  virtual void SetClient(::mojo::PendingAssociatedRemote<::device::mojom::UsbDeviceManagerClient> client) = 0;
};



class  UsbDeviceManagerProxy
    : public UsbDeviceManager {
 public:
  using InterfaceType = UsbDeviceManager;

  explicit UsbDeviceManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void EnumerateDevicesAndSetClient(::mojo::PendingAssociatedRemote<::device::mojom::UsbDeviceManagerClient> client, EnumerateDevicesAndSetClientCallback callback) final;
  
  void GetDevices(::device::mojom::UsbEnumerationOptionsPtr options, GetDevicesCallback callback) final;
  
  void GetDevice(const std::string& guid, const std::vector<uint8_t>& blocked_interface_classes, ::mojo::PendingReceiver<::device::mojom::UsbDevice> device_receiver, ::mojo::PendingRemote<::device::mojom::UsbDeviceClient> device_client) final;
  
  void GetSecurityKeyDevice(const std::string& guid, ::mojo::PendingReceiver<::device::mojom::UsbDevice> device_receiver, ::mojo::PendingRemote<::device::mojom::UsbDeviceClient> device_client) final;
  
  void SetClient(::mojo::PendingAssociatedRemote<::device::mojom::UsbDeviceManagerClient> client) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  UsbDeviceManagerStubDispatch {
 public:
  static bool Accept(UsbDeviceManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      UsbDeviceManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<UsbDeviceManager>>
class UsbDeviceManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  UsbDeviceManagerStub() = default;
  ~UsbDeviceManagerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UsbDeviceManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UsbDeviceManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  UsbDeviceManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  UsbDeviceManagerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // device::mojom

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_USB_MANAGER_MOJOM_H_