// services/image_annotation/public/mojom/image_annotation.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_IMAGE_ANNOTATION_PUBLIC_MOJOM_IMAGE_ANNOTATION_MOJOM_DATA_VIEW_H_
#define SERVICES_IMAGE_ANNOTATION_PUBLIC_MOJOM_IMAGE_ANNOTATION_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/image_annotation/public/mojom/image_annotation.mojom-shared-internal.h"


namespace image_annotation::mojom {
class AnnotationDataView;

class AnnotateImageResultDataView;


}  // image_annotation::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::image_annotation::mojom::AnnotationDataView> {
  using Data = ::image_annotation::mojom::internal::Annotation_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::image_annotation::mojom::AnnotateImageResultDataView> {
  using Data = ::image_annotation::mojom::internal::AnnotateImageResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace image_annotation::mojom {


enum class AnnotateImageError : int32_t {
  
  kCanceled = 0,
  
  kFailure = 1,
  
  kAdult = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, AnnotateImageError value);
inline bool IsKnownEnumValue(AnnotateImageError value) {
  return internal::AnnotateImageError_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AnnotationType : int32_t {
  
  kOcr = 1,
  
  kLabel = 2,
  
  kCaption = 3,
  
  kIcon = 4,
  kMinValue = 1,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, AnnotationType value);
inline bool IsKnownEnumValue(AnnotationType value) {
  return internal::AnnotationType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class ImageProcessorInterfaceBase {};

using ImageProcessorPtrDataView =
    mojo::InterfacePtrDataView<ImageProcessorInterfaceBase>;
using ImageProcessorRequestDataView =
    mojo::InterfaceRequestDataView<ImageProcessorInterfaceBase>;
using ImageProcessorAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ImageProcessorInterfaceBase>;
using ImageProcessorAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ImageProcessorInterfaceBase>;
class AnnotatorInterfaceBase {};

using AnnotatorPtrDataView =
    mojo::InterfacePtrDataView<AnnotatorInterfaceBase>;
using AnnotatorRequestDataView =
    mojo::InterfaceRequestDataView<AnnotatorInterfaceBase>;
using AnnotatorAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AnnotatorInterfaceBase>;
using AnnotatorAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AnnotatorInterfaceBase>;
class ImageAnnotationServiceInterfaceBase {};

using ImageAnnotationServicePtrDataView =
    mojo::InterfacePtrDataView<ImageAnnotationServiceInterfaceBase>;
using ImageAnnotationServiceRequestDataView =
    mojo::InterfaceRequestDataView<ImageAnnotationServiceInterfaceBase>;
using ImageAnnotationServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ImageAnnotationServiceInterfaceBase>;
using ImageAnnotationServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ImageAnnotationServiceInterfaceBase>;


class AnnotationDataView {
 public:
  AnnotationDataView() = default;

  AnnotationDataView(
      internal::Annotation_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::image_annotation::mojom::AnnotationType>(
        data_value, output);
  }
  AnnotationType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::image_annotation::mojom::AnnotationType>(data_->type));
  }
  double score() const {
    return data_->score;
  }
  inline void GetTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadText(UserType* output) {
    
    auto* pointer = data_->text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Annotation_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AnnotateImageResultDataView {
 public:
  using Tag = internal::AnnotateImageResult_Data::AnnotateImageResult_Tag;

  AnnotateImageResultDataView() = default;

  AnnotateImageResultDataView(
      internal::AnnotateImageResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_error_code() const { return data_->tag == Tag::kErrorCode; }
  template <typename UserType>
  [[nodiscard]] bool ReadErrorCode(UserType* output) const {
    CHECK(is_error_code());
    return mojo::internal::Deserialize<::image_annotation::mojom::AnnotateImageError>(
        data_->data.f_error_code, output);
  }
  AnnotateImageError error_code() const {
    CHECK(is_error_code());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::image_annotation::mojom::AnnotateImageError>(data_->data.f_error_code));
  }
  bool is_annotations() const { return data_->tag == Tag::kAnnotations; }
  inline void GetAnnotationsDataView(
      mojo::ArrayDataView<AnnotationDataView>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadAnnotations(UserType* output) const {
    
    CHECK(is_annotations());
    return mojo::internal::Deserialize<mojo::ArrayDataView<::image_annotation::mojom::AnnotationDataView>>(
        data_->data.f_annotations.Get(), output, message_);
  }

 private:
  internal::AnnotateImageResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // image_annotation::mojom

#endif  // SERVICES_IMAGE_ANNOTATION_PUBLIC_MOJOM_IMAGE_ANNOTATION_MOJOM_DATA_VIEW_H_