// services/network/public/mojom/cert_verifier_service_updater.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/cert_verifier_service_updater.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/cert_verifier_service_updater.mojom-params-data.h"
namespace cert_verifier {
namespace mojom {

namespace internal {


// static
bool CIDR_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CIDR_Data* object =
      static_cast<const CIDR_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ip, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->ip, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mask, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->mask, validation_context))
    return false;

  return true;
}

CIDR_Data::CIDR_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertWithConstraints_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertWithConstraints_Data* object =
      static_cast<const CertWithConstraints_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->certificate, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& certificate_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->certificate, validation_context,
                                         &certificate_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->permitted_dns_names, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& permitted_dns_names_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->permitted_dns_names, validation_context,
                                         &permitted_dns_names_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->permitted_cidrs, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& permitted_cidrs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->permitted_cidrs, validation_context,
                                         &permitted_cidrs_validate_params)) {
    return false;
  }

  return true;
}

CertWithConstraints_Data::CertWithConstraints_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AdditionalCertificates_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AdditionalCertificates_Data* object =
      static_cast<const AdditionalCertificates_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->all_certificates, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& all_certificates_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->all_certificates, validation_context,
                                         &all_certificates_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->trust_anchors, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& trust_anchors_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->trust_anchors, validation_context,
                                         &trust_anchors_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->trust_anchors_with_enforced_constraints, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& trust_anchors_with_enforced_constraints_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->trust_anchors_with_enforced_constraints, validation_context,
                                         &trust_anchors_with_enforced_constraints_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->trust_anchors_with_additional_constraints, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& trust_anchors_with_additional_constraints_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->trust_anchors_with_additional_constraints, validation_context,
                                         &trust_anchors_with_additional_constraints_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->trust_anchors_and_leafs, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& trust_anchors_and_leafs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->trust_anchors_and_leafs, validation_context,
                                         &trust_anchors_and_leafs_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->trust_leafs, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& trust_leafs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->trust_leafs, validation_context,
                                         &trust_leafs_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->distrusted_spkis, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& distrusted_spkis_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->distrusted_spkis, validation_context,
                                         &distrusted_spkis_validate_params)) {
    return false;
  }

  return true;
}

AdditionalCertificates_Data::AdditionalCertificates_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertVerifierServiceUpdater_UpdateAdditionalCertificates_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertVerifierServiceUpdater_UpdateAdditionalCertificates_Params_Data* object =
      static_cast<const CertVerifierServiceUpdater_UpdateAdditionalCertificates_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->certificates, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->certificates, validation_context))
    return false;

  return true;
}

CertVerifierServiceUpdater_UpdateAdditionalCertificates_Params_Data::CertVerifierServiceUpdater_UpdateAdditionalCertificates_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_Params_Data* object =
      static_cast<const CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_Params_Data*>(data);

  return true;
}

CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_Params_Data::CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ResponseParams_Data* object =
      static_cast<const CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ResponseParams_Data*>(data);

  return true;
}

CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ResponseParams_Data::CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertVerifierServiceUpdater_SetCTPolicy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertVerifierServiceUpdater_SetCTPolicy_Params_Data* object =
      static_cast<const CertVerifierServiceUpdater_SetCTPolicy_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ct_policy, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->ct_policy, validation_context))
    return false;

  return true;
}

CertVerifierServiceUpdater_SetCTPolicy_Params_Data::CertVerifierServiceUpdater_SetCTPolicy_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace cert_verifier