// services/network/public/mojom/cross_origin_embedder_policy.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CROSS_ORIGIN_EMBEDDER_POLICY_MOJOM_PARAMS_DATA_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CROSS_ORIGIN_EMBEDDER_POLICY_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace network::mojom {
namespace internal {
class  CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> blocked_url;
  int32_t destination;
  uint8_t report_only : 1;
  uint8_t padfinal_[3];

 private:
  friend class mojo::internal::MessageFragment<CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params_Data>;

  CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params_Data();
  ~CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params_Data() = delete;
};
static_assert(sizeof(CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params_Data) == 24,
              "Bad sizeof(CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params_Data)");
class  CrossOriginEmbedderPolicyReporter_Clone_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data receiver;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<CrossOriginEmbedderPolicyReporter_Clone_Params_Data>;

  CrossOriginEmbedderPolicyReporter_Clone_Params_Data();
  ~CrossOriginEmbedderPolicyReporter_Clone_Params_Data() = delete;
};
static_assert(sizeof(CrossOriginEmbedderPolicyReporter_Clone_Params_Data) == 16,
              "Bad sizeof(CrossOriginEmbedderPolicyReporter_Clone_Params_Data)");

}  // namespace internal


class CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_ParamsDataView {
 public:
  CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_ParamsDataView() = default;

  CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_ParamsDataView(
      internal::CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBlockedUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBlockedUrl(UserType* output) {
    
    auto* pointer = data_->blocked_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDestination(UserType* output) const {
    auto data_value = data_->destination;
    return mojo::internal::Deserialize<::network::mojom::RequestDestination>(
        data_value, output);
  }
  ::network::mojom::RequestDestination destination() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::RequestDestination>(data_->destination));
  }
  bool report_only() const {
    return data_->report_only;
  }
 private:
  internal::CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CrossOriginEmbedderPolicyReporter_Clone_ParamsDataView {
 public:
  CrossOriginEmbedderPolicyReporter_Clone_ParamsDataView() = default;

  CrossOriginEmbedderPolicyReporter_Clone_ParamsDataView(
      internal::CrossOriginEmbedderPolicyReporter_Clone_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::network::mojom::CrossOriginEmbedderPolicyReporterInterfaceBase>>(
            &data_->receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::CrossOriginEmbedderPolicyReporter_Clone_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_ParamsDataView::GetBlockedUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->blocked_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}





}  // network::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CROSS_ORIGIN_EMBEDDER_POLICY_MOJOM_PARAMS_DATA_H_