// services/network/public/mojom/net_log.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NET_LOG_MOJOM_PARAMS_DATA_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NET_LOG_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace network::mojom {
namespace internal {
class  NetLogExporter_Start_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::File_Data> destination;
  mojo::internal::Pointer<::mojo_base::mojom::internal::DictionaryValue_Data> extra_constants;
  int32_t capture_mode;
  uint8_t pad2_[4];
  uint64_t max_file_size;

 private:
  friend class mojo::internal::MessageFragment<NetLogExporter_Start_Params_Data>;

  NetLogExporter_Start_Params_Data();
  ~NetLogExporter_Start_Params_Data() = delete;
};
static_assert(sizeof(NetLogExporter_Start_Params_Data) == 40,
              "Bad sizeof(NetLogExporter_Start_Params_Data)");
class  NetLogExporter_Start_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t net_error;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<NetLogExporter_Start_ResponseParams_Data>;

  NetLogExporter_Start_ResponseParams_Data();
  ~NetLogExporter_Start_ResponseParams_Data() = delete;
};
static_assert(sizeof(NetLogExporter_Start_ResponseParams_Data) == 16,
              "Bad sizeof(NetLogExporter_Start_ResponseParams_Data)");
class  NetLogExporter_Stop_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::DictionaryValue_Data> polled_values;

 private:
  friend class mojo::internal::MessageFragment<NetLogExporter_Stop_Params_Data>;

  NetLogExporter_Stop_Params_Data();
  ~NetLogExporter_Stop_Params_Data() = delete;
};
static_assert(sizeof(NetLogExporter_Stop_Params_Data) == 16,
              "Bad sizeof(NetLogExporter_Stop_Params_Data)");
class  NetLogExporter_Stop_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t net_error;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<NetLogExporter_Stop_ResponseParams_Data>;

  NetLogExporter_Stop_ResponseParams_Data();
  ~NetLogExporter_Stop_ResponseParams_Data() = delete;
};
static_assert(sizeof(NetLogExporter_Stop_ResponseParams_Data) == 16,
              "Bad sizeof(NetLogExporter_Stop_ResponseParams_Data)");
class  NetLogProxySource_UpdateCaptureModes_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t modes;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<NetLogProxySource_UpdateCaptureModes_Params_Data>;

  NetLogProxySource_UpdateCaptureModes_Params_Data();
  ~NetLogProxySource_UpdateCaptureModes_Params_Data() = delete;
};
static_assert(sizeof(NetLogProxySource_UpdateCaptureModes_Params_Data) == 16,
              "Bad sizeof(NetLogProxySource_UpdateCaptureModes_Params_Data)");
class  NetLogProxySink_AddEntry_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t type;
  int32_t phase;
  mojo::internal::Pointer<::network::mojom::internal::NetLogSource_Data> net_log_source;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeTicks_Data> time;
  mojo::internal::Pointer<::mojo_base::mojom::internal::DictionaryValue_Data> params;

 private:
  friend class mojo::internal::MessageFragment<NetLogProxySink_AddEntry_Params_Data>;

  NetLogProxySink_AddEntry_Params_Data();
  ~NetLogProxySink_AddEntry_Params_Data() = delete;
};
static_assert(sizeof(NetLogProxySink_AddEntry_Params_Data) == 40,
              "Bad sizeof(NetLogProxySink_AddEntry_Params_Data)");

}  // namespace internal


class NetLogExporter_Start_ParamsDataView {
 public:
  NetLogExporter_Start_ParamsDataView() = default;

  NetLogExporter_Start_ParamsDataView(
      internal::NetLogExporter_Start_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDestinationDataView(
      ::mojo_base::mojom::FileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDestination(UserType* output) {
    
    auto* pointer = data_->destination.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FileDataView>(
        pointer, output, message_);
  }
  inline void GetExtraConstantsDataView(
      ::mojo_base::mojom::DictionaryValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExtraConstants(UserType* output) {
    
    auto* pointer = data_->extra_constants.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::DictionaryValueDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCaptureMode(UserType* output) const {
    auto data_value = data_->capture_mode;
    return mojo::internal::Deserialize<::network::mojom::NetLogCaptureMode>(
        data_value, output);
  }
  NetLogCaptureMode capture_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::NetLogCaptureMode>(data_->capture_mode));
  }
  uint64_t max_file_size() const {
    return data_->max_file_size;
  }
 private:
  internal::NetLogExporter_Start_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetLogExporter_Start_ResponseParamsDataView {
 public:
  NetLogExporter_Start_ResponseParamsDataView() = default;

  NetLogExporter_Start_ResponseParamsDataView(
      internal::NetLogExporter_Start_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t net_error() const {
    return data_->net_error;
  }
 private:
  internal::NetLogExporter_Start_ResponseParams_Data* data_ = nullptr;
};


class NetLogExporter_Stop_ParamsDataView {
 public:
  NetLogExporter_Stop_ParamsDataView() = default;

  NetLogExporter_Stop_ParamsDataView(
      internal::NetLogExporter_Stop_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPolledValuesDataView(
      ::mojo_base::mojom::DictionaryValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPolledValues(UserType* output) {
    
    auto* pointer = data_->polled_values.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::DictionaryValueDataView>(
        pointer, output, message_);
  }
 private:
  internal::NetLogExporter_Stop_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetLogExporter_Stop_ResponseParamsDataView {
 public:
  NetLogExporter_Stop_ResponseParamsDataView() = default;

  NetLogExporter_Stop_ResponseParamsDataView(
      internal::NetLogExporter_Stop_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t net_error() const {
    return data_->net_error;
  }
 private:
  internal::NetLogExporter_Stop_ResponseParams_Data* data_ = nullptr;
};


class NetLogProxySource_UpdateCaptureModes_ParamsDataView {
 public:
  NetLogProxySource_UpdateCaptureModes_ParamsDataView() = default;

  NetLogProxySource_UpdateCaptureModes_ParamsDataView(
      internal::NetLogProxySource_UpdateCaptureModes_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint8_t modes() const {
    return data_->modes;
  }
 private:
  internal::NetLogProxySource_UpdateCaptureModes_Params_Data* data_ = nullptr;
};


class NetLogProxySink_AddEntry_ParamsDataView {
 public:
  NetLogProxySink_AddEntry_ParamsDataView() = default;

  NetLogProxySink_AddEntry_ParamsDataView(
      internal::NetLogProxySink_AddEntry_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t type() const {
    return data_->type;
  }
  inline void GetNetLogSourceDataView(
      ::network::mojom::NetLogSourceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNetLogSource(UserType* output) {
    
    auto* pointer = data_->net_log_source.Get();
    return mojo::internal::Deserialize<::network::mojom::NetLogSourceDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPhase(UserType* output) const {
    auto data_value = data_->phase;
    return mojo::internal::Deserialize<::network::mojom::NetLogEventPhase>(
        data_value, output);
  }
  NetLogEventPhase phase() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::NetLogEventPhase>(data_->phase));
  }
  inline void GetTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTime(UserType* output) {
    
    auto* pointer = data_->time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetParamsDataView(
      ::mojo_base::mojom::DictionaryValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::DictionaryValueDataView>(
        pointer, output, message_);
  }
 private:
  internal::NetLogProxySink_AddEntry_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void NetLogExporter_Start_ParamsDataView::GetDestinationDataView(
    ::mojo_base::mojom::FileDataView* output) {
  auto pointer = data_->destination.Get();
  *output = ::mojo_base::mojom::FileDataView(pointer, message_);
}
inline void NetLogExporter_Start_ParamsDataView::GetExtraConstantsDataView(
    ::mojo_base::mojom::DictionaryValueDataView* output) {
  auto pointer = data_->extra_constants.Get();
  *output = ::mojo_base::mojom::DictionaryValueDataView(pointer, message_);
}




inline void NetLogExporter_Stop_ParamsDataView::GetPolledValuesDataView(
    ::mojo_base::mojom::DictionaryValueDataView* output) {
  auto pointer = data_->polled_values.Get();
  *output = ::mojo_base::mojom::DictionaryValueDataView(pointer, message_);
}






inline void NetLogProxySink_AddEntry_ParamsDataView::GetNetLogSourceDataView(
    ::network::mojom::NetLogSourceDataView* output) {
  auto pointer = data_->net_log_source.Get();
  *output = ::network::mojom::NetLogSourceDataView(pointer, message_);
}
inline void NetLogProxySink_AddEntry_ParamsDataView::GetTimeDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->time.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void NetLogProxySink_AddEntry_ParamsDataView::GetParamsDataView(
    ::mojo_base::mojom::DictionaryValueDataView* output) {
  auto pointer = data_->params.Get();
  *output = ::mojo_base::mojom::DictionaryValueDataView(pointer, message_);
}



}  // network::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NET_LOG_MOJOM_PARAMS_DATA_H_