// services/network/public/mojom/network_param.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_PARAM_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_PARAM_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/network/public/mojom/network_param.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "url/mojom/scheme_host_port.mojom-shared.h"


namespace network::mojom {
class AuthChallengeInfoDataView;

using AuthCredentialsDataView = mojo::native::NativeStructDataView;

using CertVerifyResultDataView = mojo::native::NativeStructDataView;

using HttpResponseHeadersDataView = mojo::native::NativeStructDataView;

class HttpVersionDataView;

class HostPortPairDataView;

class ProxyServerDataView;

class ProxyChainDataView;

class ResolveErrorInfoDataView;

class SSLCertRequestInfoDataView;

using SSLInfoDataView = mojo::native::NativeStructDataView;

using X509CertificateDataView = mojo::native::NativeStructDataView;

class NetLogSourceDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::AuthChallengeInfoDataView> {
  using Data = ::network::mojom::internal::AuthChallengeInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::HttpVersionDataView> {
  using Data = ::network::mojom::internal::HttpVersion_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::HostPortPairDataView> {
  using Data = ::network::mojom::internal::HostPortPair_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::ProxyServerDataView> {
  using Data = ::network::mojom::internal::ProxyServer_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::ProxyChainDataView> {
  using Data = ::network::mojom::internal::ProxyChain_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::ResolveErrorInfoDataView> {
  using Data = ::network::mojom::internal::ResolveErrorInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::SSLCertRequestInfoDataView> {
  using Data = ::network::mojom::internal::SSLCertRequestInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::NetLogSourceDataView> {
  using Data = ::network::mojom::internal::NetLogSource_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class ProxyScheme : int32_t {
  
  kInvalid = 0,
  
  kHttp = 1,
  
  kSocks4 = 2,
  
  kSocks5 = 3,
  
  kHttps = 4,
  
  kQuic = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

 std::ostream& operator<<(std::ostream& os, ProxyScheme value);
inline bool IsKnownEnumValue(ProxyScheme value) {
  return internal::ProxyScheme_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class AuthChallengeInfoDataView {
 public:
  AuthChallengeInfoDataView() = default;

  AuthChallengeInfoDataView(
      internal::AuthChallengeInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool is_proxy() const {
    return data_->is_proxy;
  }
  inline void GetChallengerDataView(
      ::url::mojom::SchemeHostPortDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChallenger(UserType* output) {
    
    auto* pointer = data_->challenger.Get();
    return mojo::internal::Deserialize<::url::mojom::SchemeHostPortDataView>(
        pointer, output, message_);
  }
  inline void GetSchemeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScheme(UserType* output) {
    
    auto* pointer = data_->scheme.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetRealmDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRealm(UserType* output) {
    
    auto* pointer = data_->realm.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetChallengeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChallenge(UserType* output) {
    
    auto* pointer = data_->challenge.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPathDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::AuthChallengeInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class HttpVersionDataView {
 public:
  HttpVersionDataView() = default;

  HttpVersionDataView(
      internal::HttpVersion_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint16_t major_value() const {
    return data_->major_value;
  }
  uint16_t minor_value() const {
    return data_->minor_value;
  }
 private:
  internal::HttpVersion_Data* data_ = nullptr;
};


class HostPortPairDataView {
 public:
  HostPortPairDataView() = default;

  HostPortPairDataView(
      internal::HostPortPair_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetHostDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHost(UserType* output) {
    
    auto* pointer = data_->host.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint16_t port() const {
    return data_->port;
  }
 private:
  internal::HostPortPair_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ProxyServerDataView {
 public:
  ProxyServerDataView() = default;

  ProxyServerDataView(
      internal::ProxyServer_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadScheme(UserType* output) const {
    auto data_value = data_->scheme;
    return mojo::internal::Deserialize<::network::mojom::ProxyScheme>(
        data_value, output);
  }
  ProxyScheme scheme() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ProxyScheme>(data_->scheme));
  }
  inline void GetHostAndPortDataView(
      HostPortPairDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHostAndPort(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::HostPortPairDataView, UserType>(),
    "Attempting to read the optional `host_and_port` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadHostAndPort` instead "
    "of `ReadHostAndPort if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->host_and_port.Get();
    return mojo::internal::Deserialize<::network::mojom::HostPortPairDataView>(
        pointer, output, message_);
  }
 private:
  internal::ProxyServer_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ProxyChainDataView {
 public:
  ProxyChainDataView() = default;

  ProxyChainDataView(
      internal::ProxyChain_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetProxyServersDataView(
      mojo::ArrayDataView<ProxyServerDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProxyServers(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::network::mojom::ProxyServerDataView>, UserType>(),
    "Attempting to read the optional `proxy_servers` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadProxyServers` instead "
    "of `ReadProxyServers if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->proxy_servers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::ProxyServerDataView>>(
        pointer, output, message_);
  }
  int32_t ip_protection_chain_id() const {
    return data_->ip_protection_chain_id;
  }
 private:
  internal::ProxyChain_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ResolveErrorInfoDataView {
 public:
  ResolveErrorInfoDataView() = default;

  ResolveErrorInfoDataView(
      internal::ResolveErrorInfo_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t error() const {
    return data_->error;
  }
  bool is_secure_network_error() const {
    return data_->is_secure_network_error;
  }
 private:
  internal::ResolveErrorInfo_Data* data_ = nullptr;
};


class SSLCertRequestInfoDataView {
 public:
  SSLCertRequestInfoDataView() = default;

  SSLCertRequestInfoDataView(
      internal::SSLCertRequestInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetHostAndPortDataView(
      HostPortPairDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHostAndPort(UserType* output) {
    
    auto* pointer = data_->host_and_port.Get();
    return mojo::internal::Deserialize<::network::mojom::HostPortPairDataView>(
        pointer, output, message_);
  }
  bool is_proxy() const {
    return data_->is_proxy;
  }
  inline void GetCertAuthoritiesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCertAuthorities(UserType* output) {
    
    auto* pointer = data_->cert_authorities.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetSignatureAlgorithmsDataView(
      mojo::ArrayDataView<uint16_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSignatureAlgorithms(UserType* output) {
    
    auto* pointer = data_->signature_algorithms.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint16_t>>(
        pointer, output, message_);
  }
 private:
  internal::SSLCertRequestInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetLogSourceDataView {
 public:
  NetLogSourceDataView() = default;

  NetLogSourceDataView(
      internal::NetLogSource_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t source_type() const {
    return data_->source_type;
  }
  uint32_t source_id() const {
    return data_->source_id;
  }
  inline void GetStartTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStartTime(UserType* output) {
    
    auto* pointer = data_->start_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
 private:
  internal::NetLogSource_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_PARAM_MOJOM_DATA_VIEW_H_