// services/network/public/mojom/network_service_test.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/network_service_test.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/network_service_test.mojom-params-data.h"
#include "services/network/public/mojom/network_service_test.mojom-shared-message-ids.h"

#include "services/network/public/mojom/network_service_test.mojom-import-headers.h"
#include "services/network/public/mojom/network_service_test.mojom-test-utils.h"
#include "net/cert/cert_verify_result.h"


namespace network::mojom {
Rule::Rule()
    : resolver_type(),
      host_pattern(),
      replacement(),
      host_resolver_flags(),
      dns_aliases() {}

Rule::Rule(
    ResolverType resolver_type_in,
    const std::string& host_pattern_in,
    const std::string& replacement_in,
    int32_t host_resolver_flags_in,
    std::vector<std::string> dns_aliases_in)
    : resolver_type(std::move(resolver_type_in)),
      host_pattern(std::move(host_pattern_in)),
      replacement(std::move(replacement_in)),
      host_resolver_flags(std::move(host_resolver_flags_in)),
      dns_aliases(std::move(dns_aliases_in)) {}

Rule::~Rule() = default;

void Rule::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resolver_type"), this->resolver_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ResolverType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "host_pattern"), this->host_pattern,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "replacement"), this->replacement,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "host_resolver_flags"), this->host_resolver_flags,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dns_aliases"), this->dns_aliases,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Rule::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SimpleCacheOpenEntryResult::SimpleCacheOpenEntryResult()
    : error(),
      key(),
      entry() {}

SimpleCacheOpenEntryResult::SimpleCacheOpenEntryResult(
    int32_t error_in,
    const std::string& key_in,
    ::mojo::PendingRemote<SimpleCacheEntry> entry_in)
    : error(std::move(error_in)),
      key(std::move(key_in)),
      entry(std::move(entry_in)) {}

SimpleCacheOpenEntryResult::~SimpleCacheOpenEntryResult() = default;

void SimpleCacheOpenEntryResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "error"), this->error,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key"), this->key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "entry"), this->entry,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<SimpleCacheEntry>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SimpleCacheOpenEntryResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

SimpleCacheEntry::IPCStableHashFunction SimpleCacheEntry::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SimpleCacheEntry>(message.name())) {
    case messages::SimpleCacheEntry::kWriteData: {
      return &SimpleCacheEntry::WriteData_Sym::IPCStableHash;
    }
    case messages::SimpleCacheEntry::kReadData: {
      return &SimpleCacheEntry::ReadData_Sym::IPCStableHash;
    }
    case messages::SimpleCacheEntry::kWriteSparseData: {
      return &SimpleCacheEntry::WriteSparseData_Sym::IPCStableHash;
    }
    case messages::SimpleCacheEntry::kReadSparseData: {
      return &SimpleCacheEntry::ReadSparseData_Sym::IPCStableHash;
    }
    case messages::SimpleCacheEntry::kClose: {
      return &SimpleCacheEntry::Close_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SimpleCacheEntry::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SimpleCacheEntry>(message.name())) {
      case messages::SimpleCacheEntry::kWriteData:
            return "Receive network::mojom::SimpleCacheEntry::WriteData";
      case messages::SimpleCacheEntry::kReadData:
            return "Receive network::mojom::SimpleCacheEntry::ReadData";
      case messages::SimpleCacheEntry::kWriteSparseData:
            return "Receive network::mojom::SimpleCacheEntry::WriteSparseData";
      case messages::SimpleCacheEntry::kReadSparseData:
            return "Receive network::mojom::SimpleCacheEntry::ReadSparseData";
      case messages::SimpleCacheEntry::kClose:
            return "Receive network::mojom::SimpleCacheEntry::Close";
    }
  } else {
    switch (static_cast<messages::SimpleCacheEntry>(message.name())) {
      case messages::SimpleCacheEntry::kWriteData:
            return "Receive reply network::mojom::SimpleCacheEntry::WriteData";
      case messages::SimpleCacheEntry::kReadData:
            return "Receive reply network::mojom::SimpleCacheEntry::ReadData";
      case messages::SimpleCacheEntry::kWriteSparseData:
            return "Receive reply network::mojom::SimpleCacheEntry::WriteSparseData";
      case messages::SimpleCacheEntry::kReadSparseData:
            return "Receive reply network::mojom::SimpleCacheEntry::ReadSparseData";
      case messages::SimpleCacheEntry::kClose:
            return "Receive reply network::mojom::SimpleCacheEntry::Close";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SimpleCacheEntry::WriteData_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0f1624e7;  // IPCStableHash for network::mojom::SimpleCacheEntry::WriteData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SimpleCacheEntry::ReadData_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfbf81fd5;  // IPCStableHash for network::mojom::SimpleCacheEntry::ReadData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SimpleCacheEntry::WriteSparseData_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7d7e9e27;  // IPCStableHash for network::mojom::SimpleCacheEntry::WriteSparseData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SimpleCacheEntry::ReadSparseData_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4448f55a;  // IPCStableHash for network::mojom::SimpleCacheEntry::ReadSparseData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SimpleCacheEntry::Close_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2b42b6e3;  // IPCStableHash for network::mojom::SimpleCacheEntry::Close
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class SimpleCacheEntry_WriteData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SimpleCacheEntry_WriteData_ForwardToCallback(
      SimpleCacheEntry::WriteDataCallback callback
      ) : callback_(std::move(callback)) {
  }

  SimpleCacheEntry_WriteData_ForwardToCallback(const SimpleCacheEntry_WriteData_ForwardToCallback&) = delete;
  SimpleCacheEntry_WriteData_ForwardToCallback& operator=(const SimpleCacheEntry_WriteData_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SimpleCacheEntry::WriteDataCallback callback_;
};

class SimpleCacheEntry_ReadData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SimpleCacheEntry_ReadData_ForwardToCallback(
      SimpleCacheEntry::ReadDataCallback callback
      ) : callback_(std::move(callback)) {
  }

  SimpleCacheEntry_ReadData_ForwardToCallback(const SimpleCacheEntry_ReadData_ForwardToCallback&) = delete;
  SimpleCacheEntry_ReadData_ForwardToCallback& operator=(const SimpleCacheEntry_ReadData_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SimpleCacheEntry::ReadDataCallback callback_;
};

class SimpleCacheEntry_WriteSparseData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SimpleCacheEntry_WriteSparseData_ForwardToCallback(
      SimpleCacheEntry::WriteSparseDataCallback callback
      ) : callback_(std::move(callback)) {
  }

  SimpleCacheEntry_WriteSparseData_ForwardToCallback(const SimpleCacheEntry_WriteSparseData_ForwardToCallback&) = delete;
  SimpleCacheEntry_WriteSparseData_ForwardToCallback& operator=(const SimpleCacheEntry_WriteSparseData_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SimpleCacheEntry::WriteSparseDataCallback callback_;
};

class SimpleCacheEntry_ReadSparseData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SimpleCacheEntry_ReadSparseData_ForwardToCallback(
      SimpleCacheEntry::ReadSparseDataCallback callback
      ) : callback_(std::move(callback)) {
  }

  SimpleCacheEntry_ReadSparseData_ForwardToCallback(const SimpleCacheEntry_ReadSparseData_ForwardToCallback&) = delete;
  SimpleCacheEntry_ReadSparseData_ForwardToCallback& operator=(const SimpleCacheEntry_ReadSparseData_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SimpleCacheEntry::ReadSparseDataCallback callback_;
};

class SimpleCacheEntry_Close_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SimpleCacheEntry_Close_ForwardToCallback(
      SimpleCacheEntry::CloseCallback callback
      ) : callback_(std::move(callback)) {
  }

  SimpleCacheEntry_Close_ForwardToCallback(const SimpleCacheEntry_Close_ForwardToCallback&) = delete;
  SimpleCacheEntry_Close_ForwardToCallback& operator=(const SimpleCacheEntry_Close_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SimpleCacheEntry::CloseCallback callback_;
};

SimpleCacheEntryProxy::SimpleCacheEntryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SimpleCacheEntryProxy::WriteData(
    int32_t in_index, int32_t in_offset, const std::vector<uint8_t>& in_data, bool in_truncate, WriteDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::SimpleCacheEntry::WriteData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index"), in_index,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("offset"), in_offset,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const std::vector<uint8_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("truncate"), in_truncate,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SimpleCacheEntry::kWriteData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::SimpleCacheEntry_WriteData_Params_Data> params(
          message);
  params.Allocate();

  params->index = in_index;

  params->offset = in_offset;
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType>
      data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_data,
    data_fragment,
    &data_validate_params);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in SimpleCacheEntry.WriteData request");

  params->truncate = in_truncate;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SimpleCacheEntry::Name_);
  message.set_method_name("WriteData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SimpleCacheEntry_WriteData_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SimpleCacheEntryProxy::ReadData(
    int32_t in_index, int32_t in_offset, uint32_t in_length, ReadDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::SimpleCacheEntry::ReadData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index"), in_index,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("offset"), in_offset,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("length"), in_length,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SimpleCacheEntry::kReadData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::SimpleCacheEntry_ReadData_Params_Data> params(
          message);
  params.Allocate();

  params->index = in_index;

  params->offset = in_offset;

  params->length = in_length;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SimpleCacheEntry::Name_);
  message.set_method_name("ReadData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SimpleCacheEntry_ReadData_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SimpleCacheEntryProxy::WriteSparseData(
    int32_t in_offset, const std::vector<uint8_t>& in_data, WriteSparseDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::SimpleCacheEntry::WriteSparseData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("offset"), in_offset,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SimpleCacheEntry::kWriteSparseData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::SimpleCacheEntry_WriteSparseData_Params_Data> params(
          message);
  params.Allocate();

  params->offset = in_offset;
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType>
      data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_data,
    data_fragment,
    &data_validate_params);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in SimpleCacheEntry.WriteSparseData request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SimpleCacheEntry::Name_);
  message.set_method_name("WriteSparseData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SimpleCacheEntry_WriteSparseData_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SimpleCacheEntryProxy::ReadSparseData(
    int32_t in_offset, uint32_t in_length, ReadSparseDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::SimpleCacheEntry::ReadSparseData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("offset"), in_offset,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("length"), in_length,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SimpleCacheEntry::kReadSparseData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::SimpleCacheEntry_ReadSparseData_Params_Data> params(
          message);
  params.Allocate();

  params->offset = in_offset;

  params->length = in_length;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SimpleCacheEntry::Name_);
  message.set_method_name("ReadSparseData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SimpleCacheEntry_ReadSparseData_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SimpleCacheEntryProxy::Close(
    CloseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::SimpleCacheEntry::Close");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SimpleCacheEntry::kClose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::SimpleCacheEntry_Close_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SimpleCacheEntry::Name_);
  message.set_method_name("Close");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SimpleCacheEntry_Close_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class SimpleCacheEntry_WriteData_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SimpleCacheEntry::WriteDataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SimpleCacheEntry_WriteData_ProxyToResponder> proxy(
        new SimpleCacheEntry_WriteData_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SimpleCacheEntry_WriteData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SimpleCacheEntry_WriteData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SimpleCacheEntry_WriteData_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SimpleCacheEntry::WriteDataCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_result);
};

bool SimpleCacheEntry_WriteData_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SimpleCacheEntry_WriteData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SimpleCacheEntry_WriteData_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SimpleCacheEntry.0
  bool success = true;
  int32_t p_result{};
  SimpleCacheEntry_WriteData_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SimpleCacheEntry::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void SimpleCacheEntry_WriteData_ProxyToResponder::Run(
    int32_t in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::SimpleCacheEntry::WriteData", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SimpleCacheEntry::kWriteData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::SimpleCacheEntry_WriteData_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SimpleCacheEntry::Name_);
  message.set_method_name("WriteData");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SimpleCacheEntry_ReadData_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SimpleCacheEntry::ReadDataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SimpleCacheEntry_ReadData_ProxyToResponder> proxy(
        new SimpleCacheEntry_ReadData_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SimpleCacheEntry_ReadData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SimpleCacheEntry_ReadData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SimpleCacheEntry_ReadData_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SimpleCacheEntry::ReadDataCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<uint8_t>& in_data, int32_t in_result);
};

bool SimpleCacheEntry_ReadData_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SimpleCacheEntry_ReadData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SimpleCacheEntry_ReadData_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SimpleCacheEntry.1
  bool success = true;
  std::vector<uint8_t> p_data{};
  int32_t p_result{};
  SimpleCacheEntry_ReadData_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SimpleCacheEntry::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_data), 
std::move(p_result));
  }
  return true;
}

void SimpleCacheEntry_ReadData_ProxyToResponder::Run(
    const std::vector<uint8_t>& in_data, int32_t in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::SimpleCacheEntry::ReadData", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const std::vector<uint8_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SimpleCacheEntry::kReadData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::SimpleCacheEntry_ReadData_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType>
      data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_data,
    data_fragment,
    &data_validate_params);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in ");

  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SimpleCacheEntry::Name_);
  message.set_method_name("ReadData");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SimpleCacheEntry_WriteSparseData_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SimpleCacheEntry::WriteSparseDataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SimpleCacheEntry_WriteSparseData_ProxyToResponder> proxy(
        new SimpleCacheEntry_WriteSparseData_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SimpleCacheEntry_WriteSparseData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SimpleCacheEntry_WriteSparseData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SimpleCacheEntry_WriteSparseData_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SimpleCacheEntry::WriteSparseDataCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_result);
};

bool SimpleCacheEntry_WriteSparseData_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SimpleCacheEntry_WriteSparseData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SimpleCacheEntry_WriteSparseData_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SimpleCacheEntry.2
  bool success = true;
  int32_t p_result{};
  SimpleCacheEntry_WriteSparseData_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SimpleCacheEntry::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void SimpleCacheEntry_WriteSparseData_ProxyToResponder::Run(
    int32_t in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::SimpleCacheEntry::WriteSparseData", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SimpleCacheEntry::kWriteSparseData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::SimpleCacheEntry_WriteSparseData_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SimpleCacheEntry::Name_);
  message.set_method_name("WriteSparseData");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SimpleCacheEntry_ReadSparseData_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SimpleCacheEntry::ReadSparseDataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SimpleCacheEntry_ReadSparseData_ProxyToResponder> proxy(
        new SimpleCacheEntry_ReadSparseData_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SimpleCacheEntry_ReadSparseData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SimpleCacheEntry_ReadSparseData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SimpleCacheEntry_ReadSparseData_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SimpleCacheEntry::ReadSparseDataCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<uint8_t>& in_data, int32_t in_result);
};

bool SimpleCacheEntry_ReadSparseData_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SimpleCacheEntry_ReadSparseData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SimpleCacheEntry_ReadSparseData_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SimpleCacheEntry.3
  bool success = true;
  std::vector<uint8_t> p_data{};
  int32_t p_result{};
  SimpleCacheEntry_ReadSparseData_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SimpleCacheEntry::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_data), 
std::move(p_result));
  }
  return true;
}

void SimpleCacheEntry_ReadSparseData_ProxyToResponder::Run(
    const std::vector<uint8_t>& in_data, int32_t in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::SimpleCacheEntry::ReadSparseData", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const std::vector<uint8_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SimpleCacheEntry::kReadSparseData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::SimpleCacheEntry_ReadSparseData_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType>
      data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_data,
    data_fragment,
    &data_validate_params);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in ");

  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SimpleCacheEntry::Name_);
  message.set_method_name("ReadSparseData");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SimpleCacheEntry_Close_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SimpleCacheEntry::CloseCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SimpleCacheEntry_Close_ProxyToResponder> proxy(
        new SimpleCacheEntry_Close_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SimpleCacheEntry_Close_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SimpleCacheEntry_Close_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SimpleCacheEntry_Close_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SimpleCacheEntry::CloseCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool SimpleCacheEntry_Close_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SimpleCacheEntry_Close_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SimpleCacheEntry_Close_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SimpleCacheEntry.4
  bool success = true;
  SimpleCacheEntry_Close_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SimpleCacheEntry::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void SimpleCacheEntry_Close_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::SimpleCacheEntry::Close");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SimpleCacheEntry::kClose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::SimpleCacheEntry_Close_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SimpleCacheEntry::Name_);
  message.set_method_name("Close");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SimpleCacheEntryStubDispatch::Accept(
    SimpleCacheEntry* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SimpleCacheEntry>(message->header()->name)) {
    case messages::SimpleCacheEntry::kWriteData: {
      break;
    }
    case messages::SimpleCacheEntry::kReadData: {
      break;
    }
    case messages::SimpleCacheEntry::kWriteSparseData: {
      break;
    }
    case messages::SimpleCacheEntry::kReadSparseData: {
      break;
    }
    case messages::SimpleCacheEntry::kClose: {
      break;
    }
  }
  return false;
}

// static
bool SimpleCacheEntryStubDispatch::AcceptWithResponder(
    SimpleCacheEntry* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SimpleCacheEntry>(message->header()->name)) {
    case messages::SimpleCacheEntry::kWriteData: {
      internal::SimpleCacheEntry_WriteData_Params_Data* params =
          reinterpret_cast<
              internal::SimpleCacheEntry_WriteData_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SimpleCacheEntry.0
      bool success = true;
      int32_t p_index{};
      int32_t p_offset{};
      std::vector<uint8_t> p_data{};
      bool p_truncate{};
      SimpleCacheEntry_WriteData_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_index = input_data_view.index();
      if (success)
        p_offset = input_data_view.offset();
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (success)
        p_truncate = input_data_view.truncate();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SimpleCacheEntry::Name_, 0, false);
        return false;
      }
      auto callback =
          SimpleCacheEntry_WriteData_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WriteData(        
        std::move(p_index), 
        std::move(p_offset), 
        std::move(p_data), 
        std::move(p_truncate), std::move(callback));
      return true;
    }
    case messages::SimpleCacheEntry::kReadData: {
      internal::SimpleCacheEntry_ReadData_Params_Data* params =
          reinterpret_cast<
              internal::SimpleCacheEntry_ReadData_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SimpleCacheEntry.1
      bool success = true;
      int32_t p_index{};
      int32_t p_offset{};
      uint32_t p_length{};
      SimpleCacheEntry_ReadData_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_index = input_data_view.index();
      if (success)
        p_offset = input_data_view.offset();
      if (success)
        p_length = input_data_view.length();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SimpleCacheEntry::Name_, 1, false);
        return false;
      }
      auto callback =
          SimpleCacheEntry_ReadData_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadData(        
        std::move(p_index), 
        std::move(p_offset), 
        std::move(p_length), std::move(callback));
      return true;
    }
    case messages::SimpleCacheEntry::kWriteSparseData: {
      internal::SimpleCacheEntry_WriteSparseData_Params_Data* params =
          reinterpret_cast<
              internal::SimpleCacheEntry_WriteSparseData_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SimpleCacheEntry.2
      bool success = true;
      int32_t p_offset{};
      std::vector<uint8_t> p_data{};
      SimpleCacheEntry_WriteSparseData_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_offset = input_data_view.offset();
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SimpleCacheEntry::Name_, 2, false);
        return false;
      }
      auto callback =
          SimpleCacheEntry_WriteSparseData_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WriteSparseData(        
        std::move(p_offset), 
        std::move(p_data), std::move(callback));
      return true;
    }
    case messages::SimpleCacheEntry::kReadSparseData: {
      internal::SimpleCacheEntry_ReadSparseData_Params_Data* params =
          reinterpret_cast<
              internal::SimpleCacheEntry_ReadSparseData_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SimpleCacheEntry.3
      bool success = true;
      int32_t p_offset{};
      uint32_t p_length{};
      SimpleCacheEntry_ReadSparseData_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_offset = input_data_view.offset();
      if (success)
        p_length = input_data_view.length();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SimpleCacheEntry::Name_, 3, false);
        return false;
      }
      auto callback =
          SimpleCacheEntry_ReadSparseData_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadSparseData(        
        std::move(p_offset), 
        std::move(p_length), std::move(callback));
      return true;
    }
    case messages::SimpleCacheEntry::kClose: {
      internal::SimpleCacheEntry_Close_Params_Data* params =
          reinterpret_cast<
              internal::SimpleCacheEntry_Close_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SimpleCacheEntry.4
      bool success = true;
      SimpleCacheEntry_Close_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SimpleCacheEntry::Name_, 4, false);
        return false;
      }
      auto callback =
          SimpleCacheEntry_Close_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Close(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSimpleCacheEntryValidationInfo[] = {
    {base::to_underlying(messages::SimpleCacheEntry::kWriteData),
     { &internal::SimpleCacheEntry_WriteData_Params_Data::Validate,
      &internal::SimpleCacheEntry_WriteData_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::SimpleCacheEntry::kReadData),
     { &internal::SimpleCacheEntry_ReadData_Params_Data::Validate,
      &internal::SimpleCacheEntry_ReadData_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::SimpleCacheEntry::kWriteSparseData),
     { &internal::SimpleCacheEntry_WriteSparseData_Params_Data::Validate,
      &internal::SimpleCacheEntry_WriteSparseData_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::SimpleCacheEntry::kReadSparseData),
     { &internal::SimpleCacheEntry_ReadSparseData_Params_Data::Validate,
      &internal::SimpleCacheEntry_ReadSparseData_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::SimpleCacheEntry::kClose),
     { &internal::SimpleCacheEntry_Close_Params_Data::Validate,
      &internal::SimpleCacheEntry_Close_ResponseParams_Data::Validate}},
};

bool SimpleCacheEntryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::network::mojom::SimpleCacheEntry::Name_,
    kSimpleCacheEntryValidationInfo);
}

bool SimpleCacheEntryResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::network::mojom::SimpleCacheEntry::Name_,
    kSimpleCacheEntryValidationInfo);

}
// The declaration includes the definition on other builds.

SimpleCacheEntryEnumerator::IPCStableHashFunction SimpleCacheEntryEnumerator::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SimpleCacheEntryEnumerator>(message.name())) {
    case messages::SimpleCacheEntryEnumerator::kGetNext: {
      return &SimpleCacheEntryEnumerator::GetNext_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SimpleCacheEntryEnumerator::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SimpleCacheEntryEnumerator>(message.name())) {
      case messages::SimpleCacheEntryEnumerator::kGetNext:
            return "Receive network::mojom::SimpleCacheEntryEnumerator::GetNext";
    }
  } else {
    switch (static_cast<messages::SimpleCacheEntryEnumerator>(message.name())) {
      case messages::SimpleCacheEntryEnumerator::kGetNext:
            return "Receive reply network::mojom::SimpleCacheEntryEnumerator::GetNext";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SimpleCacheEntryEnumerator::GetNext_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xde5aca04;  // IPCStableHash for network::mojom::SimpleCacheEntryEnumerator::GetNext
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class SimpleCacheEntryEnumerator_GetNext_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SimpleCacheEntryEnumerator_GetNext_ForwardToCallback(
      SimpleCacheEntryEnumerator::GetNextCallback callback
      ) : callback_(std::move(callback)) {
  }

  SimpleCacheEntryEnumerator_GetNext_ForwardToCallback(const SimpleCacheEntryEnumerator_GetNext_ForwardToCallback&) = delete;
  SimpleCacheEntryEnumerator_GetNext_ForwardToCallback& operator=(const SimpleCacheEntryEnumerator_GetNext_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SimpleCacheEntryEnumerator::GetNextCallback callback_;
};

SimpleCacheEntryEnumeratorProxy::SimpleCacheEntryEnumeratorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SimpleCacheEntryEnumeratorProxy::GetNext(
    GetNextCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::SimpleCacheEntryEnumerator::GetNext");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SimpleCacheEntryEnumerator::kGetNext), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::SimpleCacheEntryEnumerator_GetNext_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SimpleCacheEntryEnumerator::Name_);
  message.set_method_name("GetNext");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SimpleCacheEntryEnumerator_GetNext_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class SimpleCacheEntryEnumerator_GetNext_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SimpleCacheEntryEnumerator::GetNextCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SimpleCacheEntryEnumerator_GetNext_ProxyToResponder> proxy(
        new SimpleCacheEntryEnumerator_GetNext_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SimpleCacheEntryEnumerator_GetNext_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SimpleCacheEntryEnumerator_GetNext_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SimpleCacheEntryEnumerator_GetNext_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SimpleCacheEntryEnumerator::GetNextCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      SimpleCacheOpenEntryResultPtr in_result);
};

bool SimpleCacheEntryEnumerator_GetNext_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SimpleCacheEntryEnumerator_GetNext_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SimpleCacheEntryEnumerator_GetNext_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SimpleCacheEntryEnumerator.0
  bool success = true;
  SimpleCacheOpenEntryResultPtr p_result{};
  SimpleCacheEntryEnumerator_GetNext_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SimpleCacheEntryEnumerator::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void SimpleCacheEntryEnumerator_GetNext_ProxyToResponder::Run(
    SimpleCacheOpenEntryResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::SimpleCacheEntryEnumerator::GetNext", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type SimpleCacheOpenEntryResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SimpleCacheEntryEnumerator::kGetNext), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::SimpleCacheEntryEnumerator_GetNext_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::SimpleCacheOpenEntryResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SimpleCacheEntryEnumerator::Name_);
  message.set_method_name("GetNext");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SimpleCacheEntryEnumeratorStubDispatch::Accept(
    SimpleCacheEntryEnumerator* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SimpleCacheEntryEnumerator>(message->header()->name)) {
    case messages::SimpleCacheEntryEnumerator::kGetNext: {
      break;
    }
  }
  return false;
}

// static
bool SimpleCacheEntryEnumeratorStubDispatch::AcceptWithResponder(
    SimpleCacheEntryEnumerator* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SimpleCacheEntryEnumerator>(message->header()->name)) {
    case messages::SimpleCacheEntryEnumerator::kGetNext: {
      internal::SimpleCacheEntryEnumerator_GetNext_Params_Data* params =
          reinterpret_cast<
              internal::SimpleCacheEntryEnumerator_GetNext_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SimpleCacheEntryEnumerator.0
      bool success = true;
      SimpleCacheEntryEnumerator_GetNext_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SimpleCacheEntryEnumerator::Name_, 0, false);
        return false;
      }
      auto callback =
          SimpleCacheEntryEnumerator_GetNext_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetNext(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSimpleCacheEntryEnumeratorValidationInfo[] = {
    {base::to_underlying(messages::SimpleCacheEntryEnumerator::kGetNext),
     { &internal::SimpleCacheEntryEnumerator_GetNext_Params_Data::Validate,
      &internal::SimpleCacheEntryEnumerator_GetNext_ResponseParams_Data::Validate}},
};

bool SimpleCacheEntryEnumeratorRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::network::mojom::SimpleCacheEntryEnumerator::Name_,
    kSimpleCacheEntryEnumeratorValidationInfo);
}

bool SimpleCacheEntryEnumeratorResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::network::mojom::SimpleCacheEntryEnumerator::Name_,
    kSimpleCacheEntryEnumeratorValidationInfo);

}
// The declaration includes the definition on other builds.

SimpleCache::IPCStableHashFunction SimpleCache::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SimpleCache>(message.name())) {
    case messages::SimpleCache::kCreateEntry: {
      return &SimpleCache::CreateEntry_Sym::IPCStableHash;
    }
    case messages::SimpleCache::kOpenEntry: {
      return &SimpleCache::OpenEntry_Sym::IPCStableHash;
    }
    case messages::SimpleCache::kDoomEntry: {
      return &SimpleCache::DoomEntry_Sym::IPCStableHash;
    }
    case messages::SimpleCache::kDoomAllEntries: {
      return &SimpleCache::DoomAllEntries_Sym::IPCStableHash;
    }
    case messages::SimpleCache::kEnumerateEntries: {
      return &SimpleCache::EnumerateEntries_Sym::IPCStableHash;
    }
    case messages::SimpleCache::kDetach: {
      return &SimpleCache::Detach_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SimpleCache::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SimpleCache>(message.name())) {
      case messages::SimpleCache::kCreateEntry:
            return "Receive network::mojom::SimpleCache::CreateEntry";
      case messages::SimpleCache::kOpenEntry:
            return "Receive network::mojom::SimpleCache::OpenEntry";
      case messages::SimpleCache::kDoomEntry:
            return "Receive network::mojom::SimpleCache::DoomEntry";
      case messages::SimpleCache::kDoomAllEntries:
            return "Receive network::mojom::SimpleCache::DoomAllEntries";
      case messages::SimpleCache::kEnumerateEntries:
            return "Receive network::mojom::SimpleCache::EnumerateEntries";
      case messages::SimpleCache::kDetach:
            return "Receive network::mojom::SimpleCache::Detach";
    }
  } else {
    switch (static_cast<messages::SimpleCache>(message.name())) {
      case messages::SimpleCache::kCreateEntry:
            return "Receive reply network::mojom::SimpleCache::CreateEntry";
      case messages::SimpleCache::kOpenEntry:
            return "Receive reply network::mojom::SimpleCache::OpenEntry";
      case messages::SimpleCache::kDoomEntry:
            return "Receive reply network::mojom::SimpleCache::DoomEntry";
      case messages::SimpleCache::kDoomAllEntries:
            return "Receive reply network::mojom::SimpleCache::DoomAllEntries";
      case messages::SimpleCache::kEnumerateEntries:
            return "Receive reply network::mojom::SimpleCache::EnumerateEntries";
      case messages::SimpleCache::kDetach:
            return "Receive reply network::mojom::SimpleCache::Detach";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SimpleCache::CreateEntry_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x82e9d539;  // IPCStableHash for network::mojom::SimpleCache::CreateEntry
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SimpleCache::OpenEntry_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xea13281c;  // IPCStableHash for network::mojom::SimpleCache::OpenEntry
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SimpleCache::DoomEntry_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc4877aed;  // IPCStableHash for network::mojom::SimpleCache::DoomEntry
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SimpleCache::DoomAllEntries_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc51de406;  // IPCStableHash for network::mojom::SimpleCache::DoomAllEntries
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SimpleCache::EnumerateEntries_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xce2d6c68;  // IPCStableHash for network::mojom::SimpleCache::EnumerateEntries
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SimpleCache::Detach_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5fa48805;  // IPCStableHash for network::mojom::SimpleCache::Detach
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class SimpleCache_CreateEntry_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SimpleCache_CreateEntry_ForwardToCallback(
      SimpleCache::CreateEntryCallback callback
      ) : callback_(std::move(callback)) {
  }

  SimpleCache_CreateEntry_ForwardToCallback(const SimpleCache_CreateEntry_ForwardToCallback&) = delete;
  SimpleCache_CreateEntry_ForwardToCallback& operator=(const SimpleCache_CreateEntry_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SimpleCache::CreateEntryCallback callback_;
};

class SimpleCache_OpenEntry_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SimpleCache_OpenEntry_ForwardToCallback(
      SimpleCache::OpenEntryCallback callback
      ) : callback_(std::move(callback)) {
  }

  SimpleCache_OpenEntry_ForwardToCallback(const SimpleCache_OpenEntry_ForwardToCallback&) = delete;
  SimpleCache_OpenEntry_ForwardToCallback& operator=(const SimpleCache_OpenEntry_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SimpleCache::OpenEntryCallback callback_;
};

class SimpleCache_DoomEntry_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SimpleCache_DoomEntry_ForwardToCallback(
      SimpleCache::DoomEntryCallback callback
      ) : callback_(std::move(callback)) {
  }

  SimpleCache_DoomEntry_ForwardToCallback(const SimpleCache_DoomEntry_ForwardToCallback&) = delete;
  SimpleCache_DoomEntry_ForwardToCallback& operator=(const SimpleCache_DoomEntry_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SimpleCache::DoomEntryCallback callback_;
};

class SimpleCache_DoomAllEntries_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SimpleCache_DoomAllEntries_ForwardToCallback(
      SimpleCache::DoomAllEntriesCallback callback
      ) : callback_(std::move(callback)) {
  }

  SimpleCache_DoomAllEntries_ForwardToCallback(const SimpleCache_DoomAllEntries_ForwardToCallback&) = delete;
  SimpleCache_DoomAllEntries_ForwardToCallback& operator=(const SimpleCache_DoomAllEntries_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SimpleCache::DoomAllEntriesCallback callback_;
};

class SimpleCache_Detach_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SimpleCache_Detach_ForwardToCallback(
      SimpleCache::DetachCallback callback
      ) : callback_(std::move(callback)) {
  }

  SimpleCache_Detach_ForwardToCallback(const SimpleCache_Detach_ForwardToCallback&) = delete;
  SimpleCache_Detach_ForwardToCallback& operator=(const SimpleCache_Detach_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SimpleCache::DetachCallback callback_;
};

SimpleCacheProxy::SimpleCacheProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SimpleCacheProxy::CreateEntry(
    const std::string& in_key, CreateEntryCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::SimpleCache::CreateEntry", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SimpleCache::kCreateEntry), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::SimpleCache_CreateEntry_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType> key_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_key,
    key_fragment);

  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key in SimpleCache.CreateEntry request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SimpleCache::Name_);
  message.set_method_name("CreateEntry");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SimpleCache_CreateEntry_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SimpleCacheProxy::OpenEntry(
    const std::string& in_key, OpenEntryCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::SimpleCache::OpenEntry", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SimpleCache::kOpenEntry), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::SimpleCache_OpenEntry_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType> key_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_key,
    key_fragment);

  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key in SimpleCache.OpenEntry request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SimpleCache::Name_);
  message.set_method_name("OpenEntry");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SimpleCache_OpenEntry_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SimpleCacheProxy::DoomEntry(
    const std::string& in_key, DoomEntryCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::SimpleCache::DoomEntry", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SimpleCache::kDoomEntry), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::SimpleCache_DoomEntry_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType> key_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_key,
    key_fragment);

  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key in SimpleCache.DoomEntry request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SimpleCache::Name_);
  message.set_method_name("DoomEntry");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SimpleCache_DoomEntry_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SimpleCacheProxy::DoomAllEntries(
    DoomAllEntriesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::SimpleCache::DoomAllEntries");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SimpleCache::kDoomAllEntries), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::SimpleCache_DoomAllEntries_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SimpleCache::Name_);
  message.set_method_name("DoomAllEntries");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SimpleCache_DoomAllEntries_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SimpleCacheProxy::EnumerateEntries(
    ::mojo::PendingReceiver<SimpleCacheEntryEnumerator> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::SimpleCache::EnumerateEntries", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<SimpleCacheEntryEnumerator>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SimpleCache::kEnumerateEntries), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::SimpleCache_EnumerateEntries_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::SimpleCacheEntryEnumeratorInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in SimpleCache.EnumerateEntries request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SimpleCache::Name_);
  message.set_method_name("EnumerateEntries");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SimpleCacheProxy::Detach(
    DetachCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::SimpleCache::Detach");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SimpleCache::kDetach), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::SimpleCache_Detach_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SimpleCache::Name_);
  message.set_method_name("Detach");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SimpleCache_Detach_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class SimpleCache_CreateEntry_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SimpleCache::CreateEntryCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SimpleCache_CreateEntry_ProxyToResponder> proxy(
        new SimpleCache_CreateEntry_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SimpleCache_CreateEntry_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SimpleCache_CreateEntry_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SimpleCache_CreateEntry_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SimpleCache::CreateEntryCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PendingRemote<SimpleCacheEntry> in_entry, int32_t in_error);
};

bool SimpleCache_CreateEntry_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SimpleCache_CreateEntry_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SimpleCache_CreateEntry_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SimpleCache.0
  bool success = true;
  ::mojo::PendingRemote<SimpleCacheEntry> p_entry{};
  int32_t p_error{};
  SimpleCache_CreateEntry_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_entry =
        input_data_view.TakeEntry<decltype(p_entry)>();
  }
  if (success)
    p_error = input_data_view.error();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SimpleCache::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_entry), 
std::move(p_error));
  }
  return true;
}

void SimpleCache_CreateEntry_ProxyToResponder::Run(
    ::mojo::PendingRemote<SimpleCacheEntry> in_entry, int32_t in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::SimpleCache::CreateEntry", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("entry"), in_entry,
                        "<value of type ::mojo::PendingRemote<SimpleCacheEntry>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SimpleCache::kCreateEntry), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::SimpleCache_CreateEntry_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::SimpleCacheEntryInterfaceBase>>(
    in_entry,
    &params->entry,
    &params.message());

  params->error = in_error;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SimpleCache::Name_);
  message.set_method_name("CreateEntry");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SimpleCache_OpenEntry_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SimpleCache::OpenEntryCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SimpleCache_OpenEntry_ProxyToResponder> proxy(
        new SimpleCache_OpenEntry_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SimpleCache_OpenEntry_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SimpleCache_OpenEntry_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SimpleCache_OpenEntry_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SimpleCache::OpenEntryCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PendingRemote<SimpleCacheEntry> in_entry, int32_t in_error);
};

bool SimpleCache_OpenEntry_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SimpleCache_OpenEntry_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SimpleCache_OpenEntry_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SimpleCache.1
  bool success = true;
  ::mojo::PendingRemote<SimpleCacheEntry> p_entry{};
  int32_t p_error{};
  SimpleCache_OpenEntry_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_entry =
        input_data_view.TakeEntry<decltype(p_entry)>();
  }
  if (success)
    p_error = input_data_view.error();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SimpleCache::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_entry), 
std::move(p_error));
  }
  return true;
}

void SimpleCache_OpenEntry_ProxyToResponder::Run(
    ::mojo::PendingRemote<SimpleCacheEntry> in_entry, int32_t in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::SimpleCache::OpenEntry", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("entry"), in_entry,
                        "<value of type ::mojo::PendingRemote<SimpleCacheEntry>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SimpleCache::kOpenEntry), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::SimpleCache_OpenEntry_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::SimpleCacheEntryInterfaceBase>>(
    in_entry,
    &params->entry,
    &params.message());

  params->error = in_error;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SimpleCache::Name_);
  message.set_method_name("OpenEntry");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SimpleCache_DoomEntry_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SimpleCache::DoomEntryCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SimpleCache_DoomEntry_ProxyToResponder> proxy(
        new SimpleCache_DoomEntry_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SimpleCache_DoomEntry_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SimpleCache_DoomEntry_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SimpleCache_DoomEntry_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SimpleCache::DoomEntryCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_result);
};

bool SimpleCache_DoomEntry_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SimpleCache_DoomEntry_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SimpleCache_DoomEntry_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SimpleCache.2
  bool success = true;
  int32_t p_result{};
  SimpleCache_DoomEntry_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SimpleCache::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void SimpleCache_DoomEntry_ProxyToResponder::Run(
    int32_t in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::SimpleCache::DoomEntry", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SimpleCache::kDoomEntry), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::SimpleCache_DoomEntry_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SimpleCache::Name_);
  message.set_method_name("DoomEntry");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SimpleCache_DoomAllEntries_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SimpleCache::DoomAllEntriesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SimpleCache_DoomAllEntries_ProxyToResponder> proxy(
        new SimpleCache_DoomAllEntries_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SimpleCache_DoomAllEntries_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SimpleCache_DoomAllEntries_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SimpleCache_DoomAllEntries_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SimpleCache::DoomAllEntriesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_result);
};

bool SimpleCache_DoomAllEntries_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SimpleCache_DoomAllEntries_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SimpleCache_DoomAllEntries_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SimpleCache.3
  bool success = true;
  int32_t p_result{};
  SimpleCache_DoomAllEntries_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SimpleCache::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void SimpleCache_DoomAllEntries_ProxyToResponder::Run(
    int32_t in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::SimpleCache::DoomAllEntries", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SimpleCache::kDoomAllEntries), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::SimpleCache_DoomAllEntries_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SimpleCache::Name_);
  message.set_method_name("DoomAllEntries");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SimpleCache_Detach_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SimpleCache::DetachCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SimpleCache_Detach_ProxyToResponder> proxy(
        new SimpleCache_Detach_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SimpleCache_Detach_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SimpleCache_Detach_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SimpleCache_Detach_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SimpleCache::DetachCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool SimpleCache_Detach_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SimpleCache_Detach_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SimpleCache_Detach_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SimpleCache.5
  bool success = true;
  SimpleCache_Detach_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SimpleCache::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void SimpleCache_Detach_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::SimpleCache::Detach");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SimpleCache::kDetach), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::SimpleCache_Detach_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SimpleCache::Name_);
  message.set_method_name("Detach");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SimpleCacheStubDispatch::Accept(
    SimpleCache* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SimpleCache>(message->header()->name)) {
    case messages::SimpleCache::kCreateEntry: {
      break;
    }
    case messages::SimpleCache::kOpenEntry: {
      break;
    }
    case messages::SimpleCache::kDoomEntry: {
      break;
    }
    case messages::SimpleCache::kDoomAllEntries: {
      break;
    }
    case messages::SimpleCache::kEnumerateEntries: {
      DCHECK(message->is_serialized());
      internal::SimpleCache_EnumerateEntries_Params_Data* params =
          reinterpret_cast<internal::SimpleCache_EnumerateEntries_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SimpleCache.4
      bool success = true;
      ::mojo::PendingReceiver<SimpleCacheEntryEnumerator> p_receiver{};
      SimpleCache_EnumerateEntries_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SimpleCache::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnumerateEntries(        
        std::move(p_receiver));
      return true;
    }
    case messages::SimpleCache::kDetach: {
      break;
    }
  }
  return false;
}

// static
bool SimpleCacheStubDispatch::AcceptWithResponder(
    SimpleCache* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SimpleCache>(message->header()->name)) {
    case messages::SimpleCache::kCreateEntry: {
      internal::SimpleCache_CreateEntry_Params_Data* params =
          reinterpret_cast<
              internal::SimpleCache_CreateEntry_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SimpleCache.0
      bool success = true;
      std::string p_key{};
      SimpleCache_CreateEntry_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SimpleCache::Name_, 0, false);
        return false;
      }
      auto callback =
          SimpleCache_CreateEntry_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateEntry(        
        std::move(p_key), std::move(callback));
      return true;
    }
    case messages::SimpleCache::kOpenEntry: {
      internal::SimpleCache_OpenEntry_Params_Data* params =
          reinterpret_cast<
              internal::SimpleCache_OpenEntry_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SimpleCache.1
      bool success = true;
      std::string p_key{};
      SimpleCache_OpenEntry_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SimpleCache::Name_, 1, false);
        return false;
      }
      auto callback =
          SimpleCache_OpenEntry_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenEntry(        
        std::move(p_key), std::move(callback));
      return true;
    }
    case messages::SimpleCache::kDoomEntry: {
      internal::SimpleCache_DoomEntry_Params_Data* params =
          reinterpret_cast<
              internal::SimpleCache_DoomEntry_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SimpleCache.2
      bool success = true;
      std::string p_key{};
      SimpleCache_DoomEntry_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SimpleCache::Name_, 2, false);
        return false;
      }
      auto callback =
          SimpleCache_DoomEntry_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DoomEntry(        
        std::move(p_key), std::move(callback));
      return true;
    }
    case messages::SimpleCache::kDoomAllEntries: {
      internal::SimpleCache_DoomAllEntries_Params_Data* params =
          reinterpret_cast<
              internal::SimpleCache_DoomAllEntries_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SimpleCache.3
      bool success = true;
      SimpleCache_DoomAllEntries_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SimpleCache::Name_, 3, false);
        return false;
      }
      auto callback =
          SimpleCache_DoomAllEntries_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DoomAllEntries(std::move(callback));
      return true;
    }
    case messages::SimpleCache::kEnumerateEntries: {
      break;
    }
    case messages::SimpleCache::kDetach: {
      internal::SimpleCache_Detach_Params_Data* params =
          reinterpret_cast<
              internal::SimpleCache_Detach_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SimpleCache.5
      bool success = true;
      SimpleCache_Detach_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SimpleCache::Name_, 5, false);
        return false;
      }
      auto callback =
          SimpleCache_Detach_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Detach(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSimpleCacheValidationInfo[] = {
    {base::to_underlying(messages::SimpleCache::kCreateEntry),
     { &internal::SimpleCache_CreateEntry_Params_Data::Validate,
      &internal::SimpleCache_CreateEntry_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::SimpleCache::kOpenEntry),
     { &internal::SimpleCache_OpenEntry_Params_Data::Validate,
      &internal::SimpleCache_OpenEntry_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::SimpleCache::kDoomEntry),
     { &internal::SimpleCache_DoomEntry_Params_Data::Validate,
      &internal::SimpleCache_DoomEntry_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::SimpleCache::kDoomAllEntries),
     { &internal::SimpleCache_DoomAllEntries_Params_Data::Validate,
      &internal::SimpleCache_DoomAllEntries_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::SimpleCache::kEnumerateEntries),
     { &internal::SimpleCache_EnumerateEntries_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::SimpleCache::kDetach),
     { &internal::SimpleCache_Detach_Params_Data::Validate,
      &internal::SimpleCache_Detach_ResponseParams_Data::Validate}},
};

bool SimpleCacheRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::network::mojom::SimpleCache::Name_,
    kSimpleCacheValidationInfo);
}

bool SimpleCacheResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::network::mojom::SimpleCache::Name_,
    kSimpleCacheValidationInfo);

}
// The declaration includes the definition on other builds.

NetworkServiceTest::IPCStableHashFunction NetworkServiceTest::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::NetworkServiceTest>(message.name())) {
    case messages::NetworkServiceTest::kAddRules: {
      return &NetworkServiceTest::AddRules_Sym::IPCStableHash;
    }
    case messages::NetworkServiceTest::kSimulateNetworkChange: {
      return &NetworkServiceTest::SimulateNetworkChange_Sym::IPCStableHash;
    }
    case messages::NetworkServiceTest::kSimulateNetworkQualityChange: {
      return &NetworkServiceTest::SimulateNetworkQualityChange_Sym::IPCStableHash;
    }
    case messages::NetworkServiceTest::kForceNetworkQualityEstimatorReportWifiAsSlow2G: {
      return &NetworkServiceTest::ForceNetworkQualityEstimatorReportWifiAsSlow2G_Sym::IPCStableHash;
    }
    case messages::NetworkServiceTest::kSimulateCrash: {
      return &NetworkServiceTest::SimulateCrash_Sym::IPCStableHash;
    }
    case messages::NetworkServiceTest::kMockCertVerifierSetDefaultResult: {
      return &NetworkServiceTest::MockCertVerifierSetDefaultResult_Sym::IPCStableHash;
    }
    case messages::NetworkServiceTest::kMockCertVerifierAddResultForCertAndHost: {
      return &NetworkServiceTest::MockCertVerifierAddResultForCertAndHost_Sym::IPCStableHash;
    }
    case messages::NetworkServiceTest::kSetTransportSecurityStateSource: {
      return &NetworkServiceTest::SetTransportSecurityStateSource_Sym::IPCStableHash;
    }
    case messages::NetworkServiceTest::kSetAllowNetworkAccessToHostResolutions: {
      return &NetworkServiceTest::SetAllowNetworkAccessToHostResolutions_Sym::IPCStableHash;
    }
    case messages::NetworkServiceTest::kReplaceSystemDnsConfig: {
      return &NetworkServiceTest::ReplaceSystemDnsConfig_Sym::IPCStableHash;
    }
    case messages::NetworkServiceTest::kSetTestDohConfig: {
      return &NetworkServiceTest::SetTestDohConfig_Sym::IPCStableHash;
    }
    case messages::NetworkServiceTest::kCrashOnResolveHost: {
      return &NetworkServiceTest::CrashOnResolveHost_Sym::IPCStableHash;
    }
    case messages::NetworkServiceTest::kCrashOnGetCookieList: {
      return &NetworkServiceTest::CrashOnGetCookieList_Sym::IPCStableHash;
    }
    case messages::NetworkServiceTest::kGetLatestMemoryPressureLevel: {
      return &NetworkServiceTest::GetLatestMemoryPressureLevel_Sym::IPCStableHash;
    }
    case messages::NetworkServiceTest::kGetPeerToPeerConnectionsCountChange: {
      return &NetworkServiceTest::GetPeerToPeerConnectionsCountChange_Sym::IPCStableHash;
    }
    case messages::NetworkServiceTest::kGetEnvironmentVariableValue: {
      return &NetworkServiceTest::GetEnvironmentVariableValue_Sym::IPCStableHash;
    }
    case messages::NetworkServiceTest::kLog: {
      return &NetworkServiceTest::Log_Sym::IPCStableHash;
    }
    case messages::NetworkServiceTest::kActivateFieldTrial: {
      return &NetworkServiceTest::ActivateFieldTrial_Sym::IPCStableHash;
    }
    case messages::NetworkServiceTest::kSetSCTAuditingRetryDelay: {
      return &NetworkServiceTest::SetSCTAuditingRetryDelay_Sym::IPCStableHash;
    }
    case messages::NetworkServiceTest::kOpenFile: {
      return &NetworkServiceTest::OpenFile_Sym::IPCStableHash;
    }
    case messages::NetworkServiceTest::kEnumerateFiles: {
      return &NetworkServiceTest::EnumerateFiles_Sym::IPCStableHash;
    }
    case messages::NetworkServiceTest::kCreateSimpleCache: {
      return &NetworkServiceTest::CreateSimpleCache_Sym::IPCStableHash;
    }
    case messages::NetworkServiceTest::kMakeRequestToServer: {
      return &NetworkServiceTest::MakeRequestToServer_Sym::IPCStableHash;
    }
    case messages::NetworkServiceTest::kResolveOwnHostnameWithSystemDns: {
      return &NetworkServiceTest::ResolveOwnHostnameWithSystemDns_Sym::IPCStableHash;
    }
    case messages::NetworkServiceTest::kSetIPv6ProbeResult: {
      return &NetworkServiceTest::SetIPv6ProbeResult_Sym::IPCStableHash;
    }
    case messages::NetworkServiceTest::kGetAddressMapCacheLinux: {
      return &NetworkServiceTest::GetAddressMapCacheLinux_Sym::IPCStableHash;
    }
    case messages::NetworkServiceTest::kAllowsGSSAPILibraryLoad: {
      return &NetworkServiceTest::AllowsGSSAPILibraryLoad_Sym::IPCStableHash;
    }
    case messages::NetworkServiceTest::kIsHappyEyeballsV3Enabled: {
      return &NetworkServiceTest::IsHappyEyeballsV3Enabled_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* NetworkServiceTest::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::NetworkServiceTest>(message.name())) {
      case messages::NetworkServiceTest::kAddRules:
            return "Receive network::mojom::NetworkServiceTest::AddRules";
      case messages::NetworkServiceTest::kSimulateNetworkChange:
            return "Receive network::mojom::NetworkServiceTest::SimulateNetworkChange";
      case messages::NetworkServiceTest::kSimulateNetworkQualityChange:
            return "Receive network::mojom::NetworkServiceTest::SimulateNetworkQualityChange";
      case messages::NetworkServiceTest::kForceNetworkQualityEstimatorReportWifiAsSlow2G:
            return "Receive network::mojom::NetworkServiceTest::ForceNetworkQualityEstimatorReportWifiAsSlow2G";
      case messages::NetworkServiceTest::kSimulateCrash:
            return "Receive network::mojom::NetworkServiceTest::SimulateCrash";
      case messages::NetworkServiceTest::kMockCertVerifierSetDefaultResult:
            return "Receive network::mojom::NetworkServiceTest::MockCertVerifierSetDefaultResult";
      case messages::NetworkServiceTest::kMockCertVerifierAddResultForCertAndHost:
            return "Receive network::mojom::NetworkServiceTest::MockCertVerifierAddResultForCertAndHost";
      case messages::NetworkServiceTest::kSetTransportSecurityStateSource:
            return "Receive network::mojom::NetworkServiceTest::SetTransportSecurityStateSource";
      case messages::NetworkServiceTest::kSetAllowNetworkAccessToHostResolutions:
            return "Receive network::mojom::NetworkServiceTest::SetAllowNetworkAccessToHostResolutions";
      case messages::NetworkServiceTest::kReplaceSystemDnsConfig:
            return "Receive network::mojom::NetworkServiceTest::ReplaceSystemDnsConfig";
      case messages::NetworkServiceTest::kSetTestDohConfig:
            return "Receive network::mojom::NetworkServiceTest::SetTestDohConfig";
      case messages::NetworkServiceTest::kCrashOnResolveHost:
            return "Receive network::mojom::NetworkServiceTest::CrashOnResolveHost";
      case messages::NetworkServiceTest::kCrashOnGetCookieList:
            return "Receive network::mojom::NetworkServiceTest::CrashOnGetCookieList";
      case messages::NetworkServiceTest::kGetLatestMemoryPressureLevel:
            return "Receive network::mojom::NetworkServiceTest::GetLatestMemoryPressureLevel";
      case messages::NetworkServiceTest::kGetPeerToPeerConnectionsCountChange:
            return "Receive network::mojom::NetworkServiceTest::GetPeerToPeerConnectionsCountChange";
      case messages::NetworkServiceTest::kGetEnvironmentVariableValue:
            return "Receive network::mojom::NetworkServiceTest::GetEnvironmentVariableValue";
      case messages::NetworkServiceTest::kLog:
            return "Receive network::mojom::NetworkServiceTest::Log";
      case messages::NetworkServiceTest::kActivateFieldTrial:
            return "Receive network::mojom::NetworkServiceTest::ActivateFieldTrial";
      case messages::NetworkServiceTest::kSetSCTAuditingRetryDelay:
            return "Receive network::mojom::NetworkServiceTest::SetSCTAuditingRetryDelay";
      case messages::NetworkServiceTest::kOpenFile:
            return "Receive network::mojom::NetworkServiceTest::OpenFile";
      case messages::NetworkServiceTest::kEnumerateFiles:
            return "Receive network::mojom::NetworkServiceTest::EnumerateFiles";
      case messages::NetworkServiceTest::kCreateSimpleCache:
            return "Receive network::mojom::NetworkServiceTest::CreateSimpleCache";
      case messages::NetworkServiceTest::kMakeRequestToServer:
            return "Receive network::mojom::NetworkServiceTest::MakeRequestToServer";
      case messages::NetworkServiceTest::kResolveOwnHostnameWithSystemDns:
            return "Receive network::mojom::NetworkServiceTest::ResolveOwnHostnameWithSystemDns";
      case messages::NetworkServiceTest::kSetIPv6ProbeResult:
            return "Receive network::mojom::NetworkServiceTest::SetIPv6ProbeResult";
      case messages::NetworkServiceTest::kGetAddressMapCacheLinux:
            return "Receive network::mojom::NetworkServiceTest::GetAddressMapCacheLinux";
      case messages::NetworkServiceTest::kAllowsGSSAPILibraryLoad:
            return "Receive network::mojom::NetworkServiceTest::AllowsGSSAPILibraryLoad";
      case messages::NetworkServiceTest::kIsHappyEyeballsV3Enabled:
            return "Receive network::mojom::NetworkServiceTest::IsHappyEyeballsV3Enabled";
    }
  } else {
    switch (static_cast<messages::NetworkServiceTest>(message.name())) {
      case messages::NetworkServiceTest::kAddRules:
            return "Receive reply network::mojom::NetworkServiceTest::AddRules";
      case messages::NetworkServiceTest::kSimulateNetworkChange:
            return "Receive reply network::mojom::NetworkServiceTest::SimulateNetworkChange";
      case messages::NetworkServiceTest::kSimulateNetworkQualityChange:
            return "Receive reply network::mojom::NetworkServiceTest::SimulateNetworkQualityChange";
      case messages::NetworkServiceTest::kForceNetworkQualityEstimatorReportWifiAsSlow2G:
            return "Receive reply network::mojom::NetworkServiceTest::ForceNetworkQualityEstimatorReportWifiAsSlow2G";
      case messages::NetworkServiceTest::kSimulateCrash:
            return "Receive reply network::mojom::NetworkServiceTest::SimulateCrash";
      case messages::NetworkServiceTest::kMockCertVerifierSetDefaultResult:
            return "Receive reply network::mojom::NetworkServiceTest::MockCertVerifierSetDefaultResult";
      case messages::NetworkServiceTest::kMockCertVerifierAddResultForCertAndHost:
            return "Receive reply network::mojom::NetworkServiceTest::MockCertVerifierAddResultForCertAndHost";
      case messages::NetworkServiceTest::kSetTransportSecurityStateSource:
            return "Receive reply network::mojom::NetworkServiceTest::SetTransportSecurityStateSource";
      case messages::NetworkServiceTest::kSetAllowNetworkAccessToHostResolutions:
            return "Receive reply network::mojom::NetworkServiceTest::SetAllowNetworkAccessToHostResolutions";
      case messages::NetworkServiceTest::kReplaceSystemDnsConfig:
            return "Receive reply network::mojom::NetworkServiceTest::ReplaceSystemDnsConfig";
      case messages::NetworkServiceTest::kSetTestDohConfig:
            return "Receive reply network::mojom::NetworkServiceTest::SetTestDohConfig";
      case messages::NetworkServiceTest::kCrashOnResolveHost:
            return "Receive reply network::mojom::NetworkServiceTest::CrashOnResolveHost";
      case messages::NetworkServiceTest::kCrashOnGetCookieList:
            return "Receive reply network::mojom::NetworkServiceTest::CrashOnGetCookieList";
      case messages::NetworkServiceTest::kGetLatestMemoryPressureLevel:
            return "Receive reply network::mojom::NetworkServiceTest::GetLatestMemoryPressureLevel";
      case messages::NetworkServiceTest::kGetPeerToPeerConnectionsCountChange:
            return "Receive reply network::mojom::NetworkServiceTest::GetPeerToPeerConnectionsCountChange";
      case messages::NetworkServiceTest::kGetEnvironmentVariableValue:
            return "Receive reply network::mojom::NetworkServiceTest::GetEnvironmentVariableValue";
      case messages::NetworkServiceTest::kLog:
            return "Receive reply network::mojom::NetworkServiceTest::Log";
      case messages::NetworkServiceTest::kActivateFieldTrial:
            return "Receive reply network::mojom::NetworkServiceTest::ActivateFieldTrial";
      case messages::NetworkServiceTest::kSetSCTAuditingRetryDelay:
            return "Receive reply network::mojom::NetworkServiceTest::SetSCTAuditingRetryDelay";
      case messages::NetworkServiceTest::kOpenFile:
            return "Receive reply network::mojom::NetworkServiceTest::OpenFile";
      case messages::NetworkServiceTest::kEnumerateFiles:
            return "Receive reply network::mojom::NetworkServiceTest::EnumerateFiles";
      case messages::NetworkServiceTest::kCreateSimpleCache:
            return "Receive reply network::mojom::NetworkServiceTest::CreateSimpleCache";
      case messages::NetworkServiceTest::kMakeRequestToServer:
            return "Receive reply network::mojom::NetworkServiceTest::MakeRequestToServer";
      case messages::NetworkServiceTest::kResolveOwnHostnameWithSystemDns:
            return "Receive reply network::mojom::NetworkServiceTest::ResolveOwnHostnameWithSystemDns";
      case messages::NetworkServiceTest::kSetIPv6ProbeResult:
            return "Receive reply network::mojom::NetworkServiceTest::SetIPv6ProbeResult";
      case messages::NetworkServiceTest::kGetAddressMapCacheLinux:
            return "Receive reply network::mojom::NetworkServiceTest::GetAddressMapCacheLinux";
      case messages::NetworkServiceTest::kAllowsGSSAPILibraryLoad:
            return "Receive reply network::mojom::NetworkServiceTest::AllowsGSSAPILibraryLoad";
      case messages::NetworkServiceTest::kIsHappyEyeballsV3Enabled:
            return "Receive reply network::mojom::NetworkServiceTest::IsHappyEyeballsV3Enabled";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t NetworkServiceTest::AddRules_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfc44b839;  // IPCStableHash for network::mojom::NetworkServiceTest::AddRules
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkServiceTest::SimulateNetworkChange_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa1141226;  // IPCStableHash for network::mojom::NetworkServiceTest::SimulateNetworkChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkServiceTest::SimulateNetworkQualityChange_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4302a5bb;  // IPCStableHash for network::mojom::NetworkServiceTest::SimulateNetworkQualityChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkServiceTest::ForceNetworkQualityEstimatorReportWifiAsSlow2G_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x81e6301f;  // IPCStableHash for network::mojom::NetworkServiceTest::ForceNetworkQualityEstimatorReportWifiAsSlow2G
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkServiceTest::SimulateCrash_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6702649f;  // IPCStableHash for network::mojom::NetworkServiceTest::SimulateCrash
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkServiceTest::MockCertVerifierSetDefaultResult_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe0b4df41;  // IPCStableHash for network::mojom::NetworkServiceTest::MockCertVerifierSetDefaultResult
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkServiceTest::MockCertVerifierAddResultForCertAndHost_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xffa68f7e;  // IPCStableHash for network::mojom::NetworkServiceTest::MockCertVerifierAddResultForCertAndHost
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkServiceTest::SetTransportSecurityStateSource_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x505a1ee9;  // IPCStableHash for network::mojom::NetworkServiceTest::SetTransportSecurityStateSource
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkServiceTest::SetAllowNetworkAccessToHostResolutions_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0593277c;  // IPCStableHash for network::mojom::NetworkServiceTest::SetAllowNetworkAccessToHostResolutions
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkServiceTest::ReplaceSystemDnsConfig_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb7359034;  // IPCStableHash for network::mojom::NetworkServiceTest::ReplaceSystemDnsConfig
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkServiceTest::SetTestDohConfig_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9c666679;  // IPCStableHash for network::mojom::NetworkServiceTest::SetTestDohConfig
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkServiceTest::CrashOnResolveHost_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x05bf23a0;  // IPCStableHash for network::mojom::NetworkServiceTest::CrashOnResolveHost
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkServiceTest::CrashOnGetCookieList_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5599a2b7;  // IPCStableHash for network::mojom::NetworkServiceTest::CrashOnGetCookieList
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkServiceTest::GetLatestMemoryPressureLevel_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7708a57f;  // IPCStableHash for network::mojom::NetworkServiceTest::GetLatestMemoryPressureLevel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkServiceTest::GetPeerToPeerConnectionsCountChange_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xeca5c4cc;  // IPCStableHash for network::mojom::NetworkServiceTest::GetPeerToPeerConnectionsCountChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkServiceTest::GetEnvironmentVariableValue_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc1d0a0dc;  // IPCStableHash for network::mojom::NetworkServiceTest::GetEnvironmentVariableValue
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkServiceTest::Log_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb2524b2b;  // IPCStableHash for network::mojom::NetworkServiceTest::Log
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkServiceTest::ActivateFieldTrial_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x91cb52bb;  // IPCStableHash for network::mojom::NetworkServiceTest::ActivateFieldTrial
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkServiceTest::SetSCTAuditingRetryDelay_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x01fe40b3;  // IPCStableHash for network::mojom::NetworkServiceTest::SetSCTAuditingRetryDelay
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkServiceTest::OpenFile_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd064e073;  // IPCStableHash for network::mojom::NetworkServiceTest::OpenFile
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkServiceTest::EnumerateFiles_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4aeed9f6;  // IPCStableHash for network::mojom::NetworkServiceTest::EnumerateFiles
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkServiceTest::CreateSimpleCache_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6b82a599;  // IPCStableHash for network::mojom::NetworkServiceTest::CreateSimpleCache
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkServiceTest::MakeRequestToServer_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd0f8408e;  // IPCStableHash for network::mojom::NetworkServiceTest::MakeRequestToServer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkServiceTest::ResolveOwnHostnameWithSystemDns_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa13fde1e;  // IPCStableHash for network::mojom::NetworkServiceTest::ResolveOwnHostnameWithSystemDns
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkServiceTest::SetIPv6ProbeResult_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x457f0b6a;  // IPCStableHash for network::mojom::NetworkServiceTest::SetIPv6ProbeResult
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkServiceTest::GetAddressMapCacheLinux_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x999e1940;  // IPCStableHash for network::mojom::NetworkServiceTest::GetAddressMapCacheLinux
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkServiceTest::AllowsGSSAPILibraryLoad_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd91477e0;  // IPCStableHash for network::mojom::NetworkServiceTest::AllowsGSSAPILibraryLoad
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkServiceTest::IsHappyEyeballsV3Enabled_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x500ae668;  // IPCStableHash for network::mojom::NetworkServiceTest::IsHappyEyeballsV3Enabled
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool NetworkServiceTest::AddRules(std::vector<RulePtr> rules) {
  NOTREACHED();
}
bool NetworkServiceTest::MockCertVerifierSetDefaultResult(int32_t default_result) {
  NOTREACHED();
}
bool NetworkServiceTest::MockCertVerifierAddResultForCertAndHost(const ::scoped_refptr<::net::X509Certificate>& cert, const std::string& host_pattern, const ::net::CertVerifyResult& verify_result, int32_t rv) {
  NOTREACHED();
}
bool NetworkServiceTest::SetTransportSecurityStateSource(uint16_t reporting_port) {
  NOTREACHED();
}
bool NetworkServiceTest::SetAllowNetworkAccessToHostResolutions() {
  NOTREACHED();
}
bool NetworkServiceTest::ReplaceSystemDnsConfig() {
  NOTREACHED();
}
bool NetworkServiceTest::SetTestDohConfig(::net::SecureDnsMode secure_dns_mode, const ::net::DnsOverHttpsConfig& doh_config) {
  NOTREACHED();
}
bool NetworkServiceTest::GetLatestMemoryPressureLevel(::base::MemoryPressureListener::MemoryPressureLevel* out_memory_pressure_level) {
  NOTREACHED();
}
bool NetworkServiceTest::GetPeerToPeerConnectionsCountChange(uint32_t* out_connection_count) {
  NOTREACHED();
}
bool NetworkServiceTest::GetEnvironmentVariableValue(const std::string& name, std::string* out_value) {
  NOTREACHED();
}
bool NetworkServiceTest::Log(const std::string& message) {
  NOTREACHED();
}
bool NetworkServiceTest::SetSCTAuditingRetryDelay(std::optional<::base::TimeDelta> delay) {
  NOTREACHED();
}
bool NetworkServiceTest::GetAddressMapCacheLinux(::net::AddressMapOwnerLinux::AddressMap* out_addr_map, ::std::unordered_set<int>* out_links) {
  NOTREACHED();
}
bool NetworkServiceTest::AllowsGSSAPILibraryLoad(bool* out_allow_gssapi_library_load) {
  NOTREACHED();
}
class NetworkServiceTest_AddRules_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_AddRules_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }

  NetworkServiceTest_AddRules_HandleSyncResponse(const NetworkServiceTest_AddRules_HandleSyncResponse&) = delete;
  NetworkServiceTest_AddRules_HandleSyncResponse& operator=(const NetworkServiceTest_AddRules_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;};

class NetworkServiceTest_AddRules_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_AddRules_ForwardToCallback(
      NetworkServiceTest::AddRulesCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkServiceTest_AddRules_ForwardToCallback(const NetworkServiceTest_AddRules_ForwardToCallback&) = delete;
  NetworkServiceTest_AddRules_ForwardToCallback& operator=(const NetworkServiceTest_AddRules_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkServiceTest::AddRulesCallback callback_;
};

class NetworkServiceTest_SimulateNetworkChange_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_SimulateNetworkChange_ForwardToCallback(
      NetworkServiceTest::SimulateNetworkChangeCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkServiceTest_SimulateNetworkChange_ForwardToCallback(const NetworkServiceTest_SimulateNetworkChange_ForwardToCallback&) = delete;
  NetworkServiceTest_SimulateNetworkChange_ForwardToCallback& operator=(const NetworkServiceTest_SimulateNetworkChange_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkServiceTest::SimulateNetworkChangeCallback callback_;
};

class NetworkServiceTest_SimulateNetworkQualityChange_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_SimulateNetworkQualityChange_ForwardToCallback(
      NetworkServiceTest::SimulateNetworkQualityChangeCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkServiceTest_SimulateNetworkQualityChange_ForwardToCallback(const NetworkServiceTest_SimulateNetworkQualityChange_ForwardToCallback&) = delete;
  NetworkServiceTest_SimulateNetworkQualityChange_ForwardToCallback& operator=(const NetworkServiceTest_SimulateNetworkQualityChange_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkServiceTest::SimulateNetworkQualityChangeCallback callback_;
};

class NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ForwardToCallback(
      NetworkServiceTest::ForceNetworkQualityEstimatorReportWifiAsSlow2GCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ForwardToCallback(const NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ForwardToCallback&) = delete;
  NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ForwardToCallback& operator=(const NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkServiceTest::ForceNetworkQualityEstimatorReportWifiAsSlow2GCallback callback_;
};
class NetworkServiceTest_MockCertVerifierSetDefaultResult_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_MockCertVerifierSetDefaultResult_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }

  NetworkServiceTest_MockCertVerifierSetDefaultResult_HandleSyncResponse(const NetworkServiceTest_MockCertVerifierSetDefaultResult_HandleSyncResponse&) = delete;
  NetworkServiceTest_MockCertVerifierSetDefaultResult_HandleSyncResponse& operator=(const NetworkServiceTest_MockCertVerifierSetDefaultResult_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;};

class NetworkServiceTest_MockCertVerifierSetDefaultResult_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_MockCertVerifierSetDefaultResult_ForwardToCallback(
      NetworkServiceTest::MockCertVerifierSetDefaultResultCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkServiceTest_MockCertVerifierSetDefaultResult_ForwardToCallback(const NetworkServiceTest_MockCertVerifierSetDefaultResult_ForwardToCallback&) = delete;
  NetworkServiceTest_MockCertVerifierSetDefaultResult_ForwardToCallback& operator=(const NetworkServiceTest_MockCertVerifierSetDefaultResult_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkServiceTest::MockCertVerifierSetDefaultResultCallback callback_;
};
class NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }

  NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_HandleSyncResponse(const NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_HandleSyncResponse&) = delete;
  NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_HandleSyncResponse& operator=(const NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;};

class NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ForwardToCallback(
      NetworkServiceTest::MockCertVerifierAddResultForCertAndHostCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ForwardToCallback(const NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ForwardToCallback&) = delete;
  NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ForwardToCallback& operator=(const NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkServiceTest::MockCertVerifierAddResultForCertAndHostCallback callback_;
};
class NetworkServiceTest_SetTransportSecurityStateSource_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_SetTransportSecurityStateSource_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }

  NetworkServiceTest_SetTransportSecurityStateSource_HandleSyncResponse(const NetworkServiceTest_SetTransportSecurityStateSource_HandleSyncResponse&) = delete;
  NetworkServiceTest_SetTransportSecurityStateSource_HandleSyncResponse& operator=(const NetworkServiceTest_SetTransportSecurityStateSource_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;};

class NetworkServiceTest_SetTransportSecurityStateSource_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_SetTransportSecurityStateSource_ForwardToCallback(
      NetworkServiceTest::SetTransportSecurityStateSourceCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkServiceTest_SetTransportSecurityStateSource_ForwardToCallback(const NetworkServiceTest_SetTransportSecurityStateSource_ForwardToCallback&) = delete;
  NetworkServiceTest_SetTransportSecurityStateSource_ForwardToCallback& operator=(const NetworkServiceTest_SetTransportSecurityStateSource_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkServiceTest::SetTransportSecurityStateSourceCallback callback_;
};
class NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }

  NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_HandleSyncResponse(const NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_HandleSyncResponse&) = delete;
  NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_HandleSyncResponse& operator=(const NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;};

class NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ForwardToCallback(
      NetworkServiceTest::SetAllowNetworkAccessToHostResolutionsCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ForwardToCallback(const NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ForwardToCallback&) = delete;
  NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ForwardToCallback& operator=(const NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkServiceTest::SetAllowNetworkAccessToHostResolutionsCallback callback_;
};
class NetworkServiceTest_ReplaceSystemDnsConfig_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_ReplaceSystemDnsConfig_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }

  NetworkServiceTest_ReplaceSystemDnsConfig_HandleSyncResponse(const NetworkServiceTest_ReplaceSystemDnsConfig_HandleSyncResponse&) = delete;
  NetworkServiceTest_ReplaceSystemDnsConfig_HandleSyncResponse& operator=(const NetworkServiceTest_ReplaceSystemDnsConfig_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;};

class NetworkServiceTest_ReplaceSystemDnsConfig_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_ReplaceSystemDnsConfig_ForwardToCallback(
      NetworkServiceTest::ReplaceSystemDnsConfigCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkServiceTest_ReplaceSystemDnsConfig_ForwardToCallback(const NetworkServiceTest_ReplaceSystemDnsConfig_ForwardToCallback&) = delete;
  NetworkServiceTest_ReplaceSystemDnsConfig_ForwardToCallback& operator=(const NetworkServiceTest_ReplaceSystemDnsConfig_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkServiceTest::ReplaceSystemDnsConfigCallback callback_;
};
class NetworkServiceTest_SetTestDohConfig_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_SetTestDohConfig_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }

  NetworkServiceTest_SetTestDohConfig_HandleSyncResponse(const NetworkServiceTest_SetTestDohConfig_HandleSyncResponse&) = delete;
  NetworkServiceTest_SetTestDohConfig_HandleSyncResponse& operator=(const NetworkServiceTest_SetTestDohConfig_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;};

class NetworkServiceTest_SetTestDohConfig_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_SetTestDohConfig_ForwardToCallback(
      NetworkServiceTest::SetTestDohConfigCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkServiceTest_SetTestDohConfig_ForwardToCallback(const NetworkServiceTest_SetTestDohConfig_ForwardToCallback&) = delete;
  NetworkServiceTest_SetTestDohConfig_ForwardToCallback& operator=(const NetworkServiceTest_SetTestDohConfig_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkServiceTest::SetTestDohConfigCallback callback_;
};
class NetworkServiceTest_GetLatestMemoryPressureLevel_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_GetLatestMemoryPressureLevel_HandleSyncResponse(
      bool* result, ::base::MemoryPressureListener::MemoryPressureLevel* out_memory_pressure_level)
      : result_(result), out_memory_pressure_level_(out_memory_pressure_level) {
    DCHECK(!*result_);
  }

  NetworkServiceTest_GetLatestMemoryPressureLevel_HandleSyncResponse(const NetworkServiceTest_GetLatestMemoryPressureLevel_HandleSyncResponse&) = delete;
  NetworkServiceTest_GetLatestMemoryPressureLevel_HandleSyncResponse& operator=(const NetworkServiceTest_GetLatestMemoryPressureLevel_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::MemoryPressureListener::MemoryPressureLevel* out_memory_pressure_level_;};

class NetworkServiceTest_GetLatestMemoryPressureLevel_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_GetLatestMemoryPressureLevel_ForwardToCallback(
      NetworkServiceTest::GetLatestMemoryPressureLevelCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkServiceTest_GetLatestMemoryPressureLevel_ForwardToCallback(const NetworkServiceTest_GetLatestMemoryPressureLevel_ForwardToCallback&) = delete;
  NetworkServiceTest_GetLatestMemoryPressureLevel_ForwardToCallback& operator=(const NetworkServiceTest_GetLatestMemoryPressureLevel_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkServiceTest::GetLatestMemoryPressureLevelCallback callback_;
};
class NetworkServiceTest_GetPeerToPeerConnectionsCountChange_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_GetPeerToPeerConnectionsCountChange_HandleSyncResponse(
      bool* result, uint32_t* out_connection_count)
      : result_(result), out_connection_count_(out_connection_count) {
    DCHECK(!*result_);
  }

  NetworkServiceTest_GetPeerToPeerConnectionsCountChange_HandleSyncResponse(const NetworkServiceTest_GetPeerToPeerConnectionsCountChange_HandleSyncResponse&) = delete;
  NetworkServiceTest_GetPeerToPeerConnectionsCountChange_HandleSyncResponse& operator=(const NetworkServiceTest_GetPeerToPeerConnectionsCountChange_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  uint32_t* out_connection_count_;};

class NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ForwardToCallback(
      NetworkServiceTest::GetPeerToPeerConnectionsCountChangeCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ForwardToCallback(const NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ForwardToCallback&) = delete;
  NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ForwardToCallback& operator=(const NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkServiceTest::GetPeerToPeerConnectionsCountChangeCallback callback_;
};
class NetworkServiceTest_GetEnvironmentVariableValue_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_GetEnvironmentVariableValue_HandleSyncResponse(
      bool* result, std::string* out_value)
      : result_(result), out_value_(out_value) {
    DCHECK(!*result_);
  }

  NetworkServiceTest_GetEnvironmentVariableValue_HandleSyncResponse(const NetworkServiceTest_GetEnvironmentVariableValue_HandleSyncResponse&) = delete;
  NetworkServiceTest_GetEnvironmentVariableValue_HandleSyncResponse& operator=(const NetworkServiceTest_GetEnvironmentVariableValue_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  std::string* out_value_;};

class NetworkServiceTest_GetEnvironmentVariableValue_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_GetEnvironmentVariableValue_ForwardToCallback(
      NetworkServiceTest::GetEnvironmentVariableValueCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkServiceTest_GetEnvironmentVariableValue_ForwardToCallback(const NetworkServiceTest_GetEnvironmentVariableValue_ForwardToCallback&) = delete;
  NetworkServiceTest_GetEnvironmentVariableValue_ForwardToCallback& operator=(const NetworkServiceTest_GetEnvironmentVariableValue_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkServiceTest::GetEnvironmentVariableValueCallback callback_;
};
class NetworkServiceTest_Log_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_Log_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }

  NetworkServiceTest_Log_HandleSyncResponse(const NetworkServiceTest_Log_HandleSyncResponse&) = delete;
  NetworkServiceTest_Log_HandleSyncResponse& operator=(const NetworkServiceTest_Log_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;};

class NetworkServiceTest_Log_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_Log_ForwardToCallback(
      NetworkServiceTest::LogCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkServiceTest_Log_ForwardToCallback(const NetworkServiceTest_Log_ForwardToCallback&) = delete;
  NetworkServiceTest_Log_ForwardToCallback& operator=(const NetworkServiceTest_Log_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkServiceTest::LogCallback callback_;
};
class NetworkServiceTest_SetSCTAuditingRetryDelay_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_SetSCTAuditingRetryDelay_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }

  NetworkServiceTest_SetSCTAuditingRetryDelay_HandleSyncResponse(const NetworkServiceTest_SetSCTAuditingRetryDelay_HandleSyncResponse&) = delete;
  NetworkServiceTest_SetSCTAuditingRetryDelay_HandleSyncResponse& operator=(const NetworkServiceTest_SetSCTAuditingRetryDelay_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;};

class NetworkServiceTest_SetSCTAuditingRetryDelay_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_SetSCTAuditingRetryDelay_ForwardToCallback(
      NetworkServiceTest::SetSCTAuditingRetryDelayCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkServiceTest_SetSCTAuditingRetryDelay_ForwardToCallback(const NetworkServiceTest_SetSCTAuditingRetryDelay_ForwardToCallback&) = delete;
  NetworkServiceTest_SetSCTAuditingRetryDelay_ForwardToCallback& operator=(const NetworkServiceTest_SetSCTAuditingRetryDelay_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkServiceTest::SetSCTAuditingRetryDelayCallback callback_;
};

class NetworkServiceTest_OpenFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_OpenFile_ForwardToCallback(
      NetworkServiceTest::OpenFileCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkServiceTest_OpenFile_ForwardToCallback(const NetworkServiceTest_OpenFile_ForwardToCallback&) = delete;
  NetworkServiceTest_OpenFile_ForwardToCallback& operator=(const NetworkServiceTest_OpenFile_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkServiceTest::OpenFileCallback callback_;
};

class NetworkServiceTest_EnumerateFiles_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_EnumerateFiles_ForwardToCallback(
      NetworkServiceTest::EnumerateFilesCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkServiceTest_EnumerateFiles_ForwardToCallback(const NetworkServiceTest_EnumerateFiles_ForwardToCallback&) = delete;
  NetworkServiceTest_EnumerateFiles_ForwardToCallback& operator=(const NetworkServiceTest_EnumerateFiles_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkServiceTest::EnumerateFilesCallback callback_;
};

class NetworkServiceTest_CreateSimpleCache_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_CreateSimpleCache_ForwardToCallback(
      NetworkServiceTest::CreateSimpleCacheCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkServiceTest_CreateSimpleCache_ForwardToCallback(const NetworkServiceTest_CreateSimpleCache_ForwardToCallback&) = delete;
  NetworkServiceTest_CreateSimpleCache_ForwardToCallback& operator=(const NetworkServiceTest_CreateSimpleCache_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkServiceTest::CreateSimpleCacheCallback callback_;
};

class NetworkServiceTest_MakeRequestToServer_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_MakeRequestToServer_ForwardToCallback(
      NetworkServiceTest::MakeRequestToServerCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkServiceTest_MakeRequestToServer_ForwardToCallback(const NetworkServiceTest_MakeRequestToServer_ForwardToCallback&) = delete;
  NetworkServiceTest_MakeRequestToServer_ForwardToCallback& operator=(const NetworkServiceTest_MakeRequestToServer_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkServiceTest::MakeRequestToServerCallback callback_;
};

class NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ForwardToCallback(
      NetworkServiceTest::ResolveOwnHostnameWithSystemDnsCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ForwardToCallback(const NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ForwardToCallback&) = delete;
  NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ForwardToCallback& operator=(const NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkServiceTest::ResolveOwnHostnameWithSystemDnsCallback callback_;
};

class NetworkServiceTest_SetIPv6ProbeResult_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_SetIPv6ProbeResult_ForwardToCallback(
      NetworkServiceTest::SetIPv6ProbeResultCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkServiceTest_SetIPv6ProbeResult_ForwardToCallback(const NetworkServiceTest_SetIPv6ProbeResult_ForwardToCallback&) = delete;
  NetworkServiceTest_SetIPv6ProbeResult_ForwardToCallback& operator=(const NetworkServiceTest_SetIPv6ProbeResult_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkServiceTest::SetIPv6ProbeResultCallback callback_;
};
class NetworkServiceTest_GetAddressMapCacheLinux_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_GetAddressMapCacheLinux_HandleSyncResponse(
      bool* result, ::net::AddressMapOwnerLinux::AddressMap* out_addr_map, ::std::unordered_set<int>* out_links)
      : result_(result), out_addr_map_(out_addr_map), out_links_(out_links) {
    DCHECK(!*result_);
  }

  NetworkServiceTest_GetAddressMapCacheLinux_HandleSyncResponse(const NetworkServiceTest_GetAddressMapCacheLinux_HandleSyncResponse&) = delete;
  NetworkServiceTest_GetAddressMapCacheLinux_HandleSyncResponse& operator=(const NetworkServiceTest_GetAddressMapCacheLinux_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::net::AddressMapOwnerLinux::AddressMap* out_addr_map_;
  ::std::unordered_set<int>* out_links_;};

class NetworkServiceTest_GetAddressMapCacheLinux_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_GetAddressMapCacheLinux_ForwardToCallback(
      NetworkServiceTest::GetAddressMapCacheLinuxCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkServiceTest_GetAddressMapCacheLinux_ForwardToCallback(const NetworkServiceTest_GetAddressMapCacheLinux_ForwardToCallback&) = delete;
  NetworkServiceTest_GetAddressMapCacheLinux_ForwardToCallback& operator=(const NetworkServiceTest_GetAddressMapCacheLinux_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkServiceTest::GetAddressMapCacheLinuxCallback callback_;
};
class NetworkServiceTest_AllowsGSSAPILibraryLoad_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_AllowsGSSAPILibraryLoad_HandleSyncResponse(
      bool* result, bool* out_allow_gssapi_library_load)
      : result_(result), out_allow_gssapi_library_load_(out_allow_gssapi_library_load) {
    DCHECK(!*result_);
  }

  NetworkServiceTest_AllowsGSSAPILibraryLoad_HandleSyncResponse(const NetworkServiceTest_AllowsGSSAPILibraryLoad_HandleSyncResponse&) = delete;
  NetworkServiceTest_AllowsGSSAPILibraryLoad_HandleSyncResponse& operator=(const NetworkServiceTest_AllowsGSSAPILibraryLoad_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_allow_gssapi_library_load_;};

class NetworkServiceTest_AllowsGSSAPILibraryLoad_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_AllowsGSSAPILibraryLoad_ForwardToCallback(
      NetworkServiceTest::AllowsGSSAPILibraryLoadCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkServiceTest_AllowsGSSAPILibraryLoad_ForwardToCallback(const NetworkServiceTest_AllowsGSSAPILibraryLoad_ForwardToCallback&) = delete;
  NetworkServiceTest_AllowsGSSAPILibraryLoad_ForwardToCallback& operator=(const NetworkServiceTest_AllowsGSSAPILibraryLoad_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkServiceTest::AllowsGSSAPILibraryLoadCallback callback_;
};

class NetworkServiceTest_IsHappyEyeballsV3Enabled_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkServiceTest_IsHappyEyeballsV3Enabled_ForwardToCallback(
      NetworkServiceTest::IsHappyEyeballsV3EnabledCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkServiceTest_IsHappyEyeballsV3Enabled_ForwardToCallback(const NetworkServiceTest_IsHappyEyeballsV3Enabled_ForwardToCallback&) = delete;
  NetworkServiceTest_IsHappyEyeballsV3Enabled_ForwardToCallback& operator=(const NetworkServiceTest_IsHappyEyeballsV3Enabled_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkServiceTest::IsHappyEyeballsV3EnabledCallback callback_;
};

NetworkServiceTestProxy::NetworkServiceTestProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool NetworkServiceTestProxy::AddRules(
    std::vector<RulePtr> param_rules) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call network::mojom::NetworkServiceTest::AddRules (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rules"), param_rules,
                        "<value of type std::vector<RulePtr>>");
   });
#else
  TRACE_EVENT0("mojom", "NetworkServiceTest::AddRules");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kAddRules), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_AddRules_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->rules)::BaseType>
      rules_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& rules_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::RuleDataView>>(
    param_rules,
    rules_fragment,
    &rules_validate_params);

  params->rules.Set(
      rules_fragment.is_null() ? nullptr : rules_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->rules.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null rules in NetworkServiceTest.AddRules request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("AddRules");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_AddRules_HandleSyncResponse(
          &result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "NetworkServiceTest::AddRules");
#endif
  return result;
}

void NetworkServiceTestProxy::AddRules(
    std::vector<RulePtr> in_rules, AddRulesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkServiceTest::AddRules", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rules"), in_rules,
                        "<value of type std::vector<RulePtr>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kAddRules), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_AddRules_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->rules)::BaseType>
      rules_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& rules_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::RuleDataView>>(
    in_rules,
    rules_fragment,
    &rules_validate_params);

  params->rules.Set(
      rules_fragment.is_null() ? nullptr : rules_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->rules.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null rules in NetworkServiceTest.AddRules request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("AddRules");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_AddRules_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkServiceTestProxy::SimulateNetworkChange(
    ::network::mojom::ConnectionType in_type, SimulateNetworkChangeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkServiceTest::SimulateNetworkChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type ::network::mojom::ConnectionType>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kSimulateNetworkChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_SimulateNetworkChange_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::network::mojom::ConnectionType>(
    in_type,
    &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("SimulateNetworkChange");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_SimulateNetworkChange_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkServiceTestProxy::SimulateNetworkQualityChange(
    ::net::EffectiveConnectionType in_type, SimulateNetworkQualityChangeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkServiceTest::SimulateNetworkQualityChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type ::net::EffectiveConnectionType>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kSimulateNetworkQualityChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_SimulateNetworkQualityChange_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::network::mojom::EffectiveConnectionType>(
    in_type,
    &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("SimulateNetworkQualityChange");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_SimulateNetworkQualityChange_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkServiceTestProxy::ForceNetworkQualityEstimatorReportWifiAsSlow2G(
    ForceNetworkQualityEstimatorReportWifiAsSlow2GCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::NetworkServiceTest::ForceNetworkQualityEstimatorReportWifiAsSlow2G");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kForceNetworkQualityEstimatorReportWifiAsSlow2G), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("ForceNetworkQualityEstimatorReportWifiAsSlow2G");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkServiceTestProxy::SimulateCrash(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::NetworkServiceTest::SimulateCrash");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kSimulateCrash), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_SimulateCrash_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("SimulateCrash");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
bool NetworkServiceTestProxy::MockCertVerifierSetDefaultResult(
    int32_t param_default_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call network::mojom::NetworkServiceTest::MockCertVerifierSetDefaultResult (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("default_result"), param_default_result,
                        "<value of type int32_t>");
   });
#else
  TRACE_EVENT0("mojom", "NetworkServiceTest::MockCertVerifierSetDefaultResult");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kMockCertVerifierSetDefaultResult), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_MockCertVerifierSetDefaultResult_Params_Data> params(
          message);
  params.Allocate();

  params->default_result = param_default_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("MockCertVerifierSetDefaultResult");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_MockCertVerifierSetDefaultResult_HandleSyncResponse(
          &result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "NetworkServiceTest::MockCertVerifierSetDefaultResult");
#endif
  return result;
}

void NetworkServiceTestProxy::MockCertVerifierSetDefaultResult(
    int32_t in_default_result, MockCertVerifierSetDefaultResultCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkServiceTest::MockCertVerifierSetDefaultResult", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("default_result"), in_default_result,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kMockCertVerifierSetDefaultResult), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_MockCertVerifierSetDefaultResult_Params_Data> params(
          message);
  params.Allocate();

  params->default_result = in_default_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("MockCertVerifierSetDefaultResult");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_MockCertVerifierSetDefaultResult_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool NetworkServiceTestProxy::MockCertVerifierAddResultForCertAndHost(
    const ::scoped_refptr<::net::X509Certificate>& param_cert, const std::string& param_host_pattern, const ::net::CertVerifyResult& param_verify_result, int32_t param_rv) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call network::mojom::NetworkServiceTest::MockCertVerifierAddResultForCertAndHost (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cert"), param_cert,
                        "<value of type const ::scoped_refptr<::net::X509Certificate>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host_pattern"), param_host_pattern,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("verify_result"), param_verify_result,
                        "<value of type const ::net::CertVerifyResult&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rv"), param_rv,
                        "<value of type int32_t>");
   });
#else
  TRACE_EVENT0("mojom", "NetworkServiceTest::MockCertVerifierAddResultForCertAndHost");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kMockCertVerifierAddResultForCertAndHost), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->cert)::BaseType> cert_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::X509CertificateDataView>(
    param_cert,
    cert_fragment);

  params->cert.Set(
      cert_fragment.is_null() ? nullptr : cert_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cert.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cert in NetworkServiceTest.MockCertVerifierAddResultForCertAndHost request");
  mojo::internal::MessageFragment<
      typename decltype(params->host_pattern)::BaseType> host_pattern_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    param_host_pattern,
    host_pattern_fragment);

  params->host_pattern.Set(
      host_pattern_fragment.is_null() ? nullptr : host_pattern_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->host_pattern.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null host_pattern in NetworkServiceTest.MockCertVerifierAddResultForCertAndHost request");
  mojo::internal::MessageFragment<
      typename decltype(params->verify_result)::BaseType> verify_result_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::CertVerifyResultDataView>(
    param_verify_result,
    verify_result_fragment);

  params->verify_result.Set(
      verify_result_fragment.is_null() ? nullptr : verify_result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->verify_result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null verify_result in NetworkServiceTest.MockCertVerifierAddResultForCertAndHost request");

  params->rv = param_rv;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("MockCertVerifierAddResultForCertAndHost");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_HandleSyncResponse(
          &result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "NetworkServiceTest::MockCertVerifierAddResultForCertAndHost");
#endif
  return result;
}

void NetworkServiceTestProxy::MockCertVerifierAddResultForCertAndHost(
    const ::scoped_refptr<::net::X509Certificate>& in_cert, const std::string& in_host_pattern, const ::net::CertVerifyResult& in_verify_result, int32_t in_rv, MockCertVerifierAddResultForCertAndHostCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkServiceTest::MockCertVerifierAddResultForCertAndHost", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cert"), in_cert,
                        "<value of type const ::scoped_refptr<::net::X509Certificate>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host_pattern"), in_host_pattern,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("verify_result"), in_verify_result,
                        "<value of type const ::net::CertVerifyResult&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rv"), in_rv,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kMockCertVerifierAddResultForCertAndHost), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->cert)::BaseType> cert_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::X509CertificateDataView>(
    in_cert,
    cert_fragment);

  params->cert.Set(
      cert_fragment.is_null() ? nullptr : cert_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cert.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cert in NetworkServiceTest.MockCertVerifierAddResultForCertAndHost request");
  mojo::internal::MessageFragment<
      typename decltype(params->host_pattern)::BaseType> host_pattern_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_host_pattern,
    host_pattern_fragment);

  params->host_pattern.Set(
      host_pattern_fragment.is_null() ? nullptr : host_pattern_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->host_pattern.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null host_pattern in NetworkServiceTest.MockCertVerifierAddResultForCertAndHost request");
  mojo::internal::MessageFragment<
      typename decltype(params->verify_result)::BaseType> verify_result_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::CertVerifyResultDataView>(
    in_verify_result,
    verify_result_fragment);

  params->verify_result.Set(
      verify_result_fragment.is_null() ? nullptr : verify_result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->verify_result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null verify_result in NetworkServiceTest.MockCertVerifierAddResultForCertAndHost request");

  params->rv = in_rv;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("MockCertVerifierAddResultForCertAndHost");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool NetworkServiceTestProxy::SetTransportSecurityStateSource(
    uint16_t param_reporting_port) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call network::mojom::NetworkServiceTest::SetTransportSecurityStateSource (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reporting_port"), param_reporting_port,
                        "<value of type uint16_t>");
   });
#else
  TRACE_EVENT0("mojom", "NetworkServiceTest::SetTransportSecurityStateSource");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kSetTransportSecurityStateSource), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_SetTransportSecurityStateSource_Params_Data> params(
          message);
  params.Allocate();

  params->reporting_port = param_reporting_port;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("SetTransportSecurityStateSource");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_SetTransportSecurityStateSource_HandleSyncResponse(
          &result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "NetworkServiceTest::SetTransportSecurityStateSource");
#endif
  return result;
}

void NetworkServiceTestProxy::SetTransportSecurityStateSource(
    uint16_t in_reporting_port, SetTransportSecurityStateSourceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkServiceTest::SetTransportSecurityStateSource", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reporting_port"), in_reporting_port,
                        "<value of type uint16_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kSetTransportSecurityStateSource), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_SetTransportSecurityStateSource_Params_Data> params(
          message);
  params.Allocate();

  params->reporting_port = in_reporting_port;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("SetTransportSecurityStateSource");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_SetTransportSecurityStateSource_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool NetworkServiceTestProxy::SetAllowNetworkAccessToHostResolutions(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call network::mojom::NetworkServiceTest::SetAllowNetworkAccessToHostResolutions (sync)");
#else
  TRACE_EVENT0("mojom", "NetworkServiceTest::SetAllowNetworkAccessToHostResolutions");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kSetAllowNetworkAccessToHostResolutions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("SetAllowNetworkAccessToHostResolutions");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_HandleSyncResponse(
          &result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "NetworkServiceTest::SetAllowNetworkAccessToHostResolutions");
#endif
  return result;
}

void NetworkServiceTestProxy::SetAllowNetworkAccessToHostResolutions(
    SetAllowNetworkAccessToHostResolutionsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::NetworkServiceTest::SetAllowNetworkAccessToHostResolutions");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kSetAllowNetworkAccessToHostResolutions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("SetAllowNetworkAccessToHostResolutions");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool NetworkServiceTestProxy::ReplaceSystemDnsConfig(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call network::mojom::NetworkServiceTest::ReplaceSystemDnsConfig (sync)");
#else
  TRACE_EVENT0("mojom", "NetworkServiceTest::ReplaceSystemDnsConfig");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kReplaceSystemDnsConfig), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_ReplaceSystemDnsConfig_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("ReplaceSystemDnsConfig");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_ReplaceSystemDnsConfig_HandleSyncResponse(
          &result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "NetworkServiceTest::ReplaceSystemDnsConfig");
#endif
  return result;
}

void NetworkServiceTestProxy::ReplaceSystemDnsConfig(
    ReplaceSystemDnsConfigCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::NetworkServiceTest::ReplaceSystemDnsConfig");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kReplaceSystemDnsConfig), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_ReplaceSystemDnsConfig_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("ReplaceSystemDnsConfig");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_ReplaceSystemDnsConfig_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool NetworkServiceTestProxy::SetTestDohConfig(
    ::net::SecureDnsMode param_secure_dns_mode, const ::net::DnsOverHttpsConfig& param_doh_config) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call network::mojom::NetworkServiceTest::SetTestDohConfig (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("secure_dns_mode"), param_secure_dns_mode,
                        "<value of type ::net::SecureDnsMode>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("doh_config"), param_doh_config,
                        "<value of type const ::net::DnsOverHttpsConfig&>");
   });
#else
  TRACE_EVENT0("mojom", "NetworkServiceTest::SetTestDohConfig");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kSetTestDohConfig), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_SetTestDohConfig_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::network::mojom::SecureDnsMode>(
    param_secure_dns_mode,
    &params->secure_dns_mode);
  mojo::internal::MessageFragment<
      typename decltype(params->doh_config)::BaseType> doh_config_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::DnsOverHttpsConfigDataView>(
    param_doh_config,
    doh_config_fragment);

  params->doh_config.Set(
      doh_config_fragment.is_null() ? nullptr : doh_config_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->doh_config.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null doh_config in NetworkServiceTest.SetTestDohConfig request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("SetTestDohConfig");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_SetTestDohConfig_HandleSyncResponse(
          &result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "NetworkServiceTest::SetTestDohConfig");
#endif
  return result;
}

void NetworkServiceTestProxy::SetTestDohConfig(
    ::net::SecureDnsMode in_secure_dns_mode, const ::net::DnsOverHttpsConfig& in_doh_config, SetTestDohConfigCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkServiceTest::SetTestDohConfig", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("secure_dns_mode"), in_secure_dns_mode,
                        "<value of type ::net::SecureDnsMode>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("doh_config"), in_doh_config,
                        "<value of type const ::net::DnsOverHttpsConfig&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kSetTestDohConfig), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_SetTestDohConfig_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::network::mojom::SecureDnsMode>(
    in_secure_dns_mode,
    &params->secure_dns_mode);
  mojo::internal::MessageFragment<
      typename decltype(params->doh_config)::BaseType> doh_config_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::DnsOverHttpsConfigDataView>(
    in_doh_config,
    doh_config_fragment);

  params->doh_config.Set(
      doh_config_fragment.is_null() ? nullptr : doh_config_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->doh_config.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null doh_config in NetworkServiceTest.SetTestDohConfig request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("SetTestDohConfig");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_SetTestDohConfig_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkServiceTestProxy::CrashOnResolveHost(
    const std::string& in_host) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkServiceTest::CrashOnResolveHost", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host"), in_host,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kCrashOnResolveHost), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_CrashOnResolveHost_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->host)::BaseType> host_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_host,
    host_fragment);

  params->host.Set(
      host_fragment.is_null() ? nullptr : host_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->host.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null host in NetworkServiceTest.CrashOnResolveHost request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("CrashOnResolveHost");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkServiceTestProxy::CrashOnGetCookieList(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::NetworkServiceTest::CrashOnGetCookieList");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kCrashOnGetCookieList), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_CrashOnGetCookieList_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("CrashOnGetCookieList");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
bool NetworkServiceTestProxy::GetLatestMemoryPressureLevel(
    ::base::MemoryPressureListener::MemoryPressureLevel* out_param_memory_pressure_level) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call network::mojom::NetworkServiceTest::GetLatestMemoryPressureLevel (sync)");
#else
  TRACE_EVENT0("mojom", "NetworkServiceTest::GetLatestMemoryPressureLevel");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kGetLatestMemoryPressureLevel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_GetLatestMemoryPressureLevel_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("GetLatestMemoryPressureLevel");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_GetLatestMemoryPressureLevel_HandleSyncResponse(
          &result, out_param_memory_pressure_level));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "NetworkServiceTest::GetLatestMemoryPressureLevel", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("memory_pressure_level"), out_param_memory_pressure_level,
                        "<value of type ::base::MemoryPressureListener::MemoryPressureLevel>");
   });
#endif
  return result;
}

void NetworkServiceTestProxy::GetLatestMemoryPressureLevel(
    GetLatestMemoryPressureLevelCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::NetworkServiceTest::GetLatestMemoryPressureLevel");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kGetLatestMemoryPressureLevel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_GetLatestMemoryPressureLevel_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("GetLatestMemoryPressureLevel");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_GetLatestMemoryPressureLevel_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool NetworkServiceTestProxy::GetPeerToPeerConnectionsCountChange(
    uint32_t* out_param_connection_count) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call network::mojom::NetworkServiceTest::GetPeerToPeerConnectionsCountChange (sync)");
#else
  TRACE_EVENT0("mojom", "NetworkServiceTest::GetPeerToPeerConnectionsCountChange");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kGetPeerToPeerConnectionsCountChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_GetPeerToPeerConnectionsCountChange_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("GetPeerToPeerConnectionsCountChange");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_GetPeerToPeerConnectionsCountChange_HandleSyncResponse(
          &result, out_param_connection_count));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "NetworkServiceTest::GetPeerToPeerConnectionsCountChange", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("connection_count"), out_param_connection_count,
                        "<value of type uint32_t>");
   });
#endif
  return result;
}

void NetworkServiceTestProxy::GetPeerToPeerConnectionsCountChange(
    GetPeerToPeerConnectionsCountChangeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::NetworkServiceTest::GetPeerToPeerConnectionsCountChange");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kGetPeerToPeerConnectionsCountChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_GetPeerToPeerConnectionsCountChange_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("GetPeerToPeerConnectionsCountChange");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool NetworkServiceTestProxy::GetEnvironmentVariableValue(
    const std::string& param_name, std::string* out_param_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call network::mojom::NetworkServiceTest::GetEnvironmentVariableValue (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), param_name,
                        "<value of type const std::string&>");
   });
#else
  TRACE_EVENT0("mojom", "NetworkServiceTest::GetEnvironmentVariableValue");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kGetEnvironmentVariableValue), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_GetEnvironmentVariableValue_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    param_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in NetworkServiceTest.GetEnvironmentVariableValue request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("GetEnvironmentVariableValue");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_GetEnvironmentVariableValue_HandleSyncResponse(
          &result, out_param_value));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "NetworkServiceTest::GetEnvironmentVariableValue", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), out_param_value,
                        "<value of type const std::string&>");
   });
#endif
  return result;
}

void NetworkServiceTestProxy::GetEnvironmentVariableValue(
    const std::string& in_name, GetEnvironmentVariableValueCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkServiceTest::GetEnvironmentVariableValue", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kGetEnvironmentVariableValue), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_GetEnvironmentVariableValue_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in NetworkServiceTest.GetEnvironmentVariableValue request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("GetEnvironmentVariableValue");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_GetEnvironmentVariableValue_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool NetworkServiceTestProxy::Log(
    const std::string& param_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call network::mojom::NetworkServiceTest::Log (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), param_message,
                        "<value of type const std::string&>");
   });
#else
  TRACE_EVENT0("mojom", "NetworkServiceTest::Log");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kLog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_Log_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    param_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in NetworkServiceTest.Log request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("Log");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_Log_HandleSyncResponse(
          &result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "NetworkServiceTest::Log");
#endif
  return result;
}

void NetworkServiceTestProxy::Log(
    const std::string& in_message, LogCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkServiceTest::Log", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kLog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_Log_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in NetworkServiceTest.Log request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("Log");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_Log_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkServiceTestProxy::ActivateFieldTrial(
    const std::string& in_field_trial_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkServiceTest::ActivateFieldTrial", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("field_trial_name"), in_field_trial_name,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kActivateFieldTrial), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_ActivateFieldTrial_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->field_trial_name)::BaseType> field_trial_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_field_trial_name,
    field_trial_name_fragment);

  params->field_trial_name.Set(
      field_trial_name_fragment.is_null() ? nullptr : field_trial_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->field_trial_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null field_trial_name in NetworkServiceTest.ActivateFieldTrial request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("ActivateFieldTrial");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
bool NetworkServiceTestProxy::SetSCTAuditingRetryDelay(
    std::optional<::base::TimeDelta> param_delay) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call network::mojom::NetworkServiceTest::SetSCTAuditingRetryDelay (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("delay"), param_delay,
                        "<value of type std::optional<::base::TimeDelta>>");
   });
#else
  TRACE_EVENT0("mojom", "NetworkServiceTest::SetSCTAuditingRetryDelay");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kSetSCTAuditingRetryDelay), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_SetSCTAuditingRetryDelay_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->delay)::BaseType> delay_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    param_delay,
    delay_fragment);

  params->delay.Set(
      delay_fragment.is_null() ? nullptr : delay_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("SetSCTAuditingRetryDelay");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_SetSCTAuditingRetryDelay_HandleSyncResponse(
          &result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "NetworkServiceTest::SetSCTAuditingRetryDelay");
#endif
  return result;
}

void NetworkServiceTestProxy::SetSCTAuditingRetryDelay(
    std::optional<::base::TimeDelta> in_delay, SetSCTAuditingRetryDelayCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkServiceTest::SetSCTAuditingRetryDelay", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("delay"), in_delay,
                        "<value of type std::optional<::base::TimeDelta>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kSetSCTAuditingRetryDelay), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_SetSCTAuditingRetryDelay_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->delay)::BaseType> delay_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_delay,
    delay_fragment);

  params->delay.Set(
      delay_fragment.is_null() ? nullptr : delay_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("SetSCTAuditingRetryDelay");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_SetSCTAuditingRetryDelay_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkServiceTestProxy::OpenFile(
    const ::base::FilePath& in_path, OpenFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkServiceTest::OpenFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kOpenFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_OpenFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    in_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in NetworkServiceTest.OpenFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("OpenFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_OpenFile_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkServiceTestProxy::EnumerateFiles(
    const ::base::FilePath& in_path, ::mojo::PendingRemote<::network::mojom::HttpCacheBackendFileOperationsFactory> in_factory, EnumerateFilesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkServiceTest::EnumerateFiles", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("factory"), in_factory,
                        "<value of type ::mojo::PendingRemote<::network::mojom::HttpCacheBackendFileOperationsFactory>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kEnumerateFiles), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_EnumerateFiles_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    in_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in NetworkServiceTest.EnumerateFiles request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::HttpCacheBackendFileOperationsFactoryInterfaceBase>>(
    in_factory,
    &params->factory,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->factory)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid factory in NetworkServiceTest.EnumerateFiles request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("EnumerateFiles");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_EnumerateFiles_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkServiceTestProxy::CreateSimpleCache(
    ::mojo::PendingRemote<::network::mojom::HttpCacheBackendFileOperationsFactory> in_factory, const ::base::FilePath& in_path, bool in_reset, CreateSimpleCacheCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkServiceTest::CreateSimpleCache", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("factory"), in_factory,
                        "<value of type ::mojo::PendingRemote<::network::mojom::HttpCacheBackendFileOperationsFactory>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reset"), in_reset,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kCreateSimpleCache), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_CreateSimpleCache_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::HttpCacheBackendFileOperationsFactoryInterfaceBase>>(
    in_factory,
    &params->factory,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->factory)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid factory in NetworkServiceTest.CreateSimpleCache request");
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    in_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in NetworkServiceTest.CreateSimpleCache request");

  params->reset = in_reset;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("CreateSimpleCache");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_CreateSimpleCache_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkServiceTestProxy::MakeRequestToServer(
    ::network::TransferableSocket in_s, const ::net::IPEndPoint& in_endpoint, MakeRequestToServerCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkServiceTest::MakeRequestToServer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("s"), in_s,
                        "<value of type ::network::TransferableSocket>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("endpoint"), in_endpoint,
                        "<value of type const ::net::IPEndPoint&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kMakeRequestToServer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_MakeRequestToServer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->s)::BaseType> s_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::TransferableSocketDataView>(
    in_s,
    s_fragment);

  params->s.Set(
      s_fragment.is_null() ? nullptr : s_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->s.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null s in NetworkServiceTest.MakeRequestToServer request");
  mojo::internal::MessageFragment<
      typename decltype(params->endpoint)::BaseType> endpoint_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
    in_endpoint,
    endpoint_fragment);

  params->endpoint.Set(
      endpoint_fragment.is_null() ? nullptr : endpoint_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->endpoint.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null endpoint in NetworkServiceTest.MakeRequestToServer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("MakeRequestToServer");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_MakeRequestToServer_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkServiceTestProxy::ResolveOwnHostnameWithSystemDns(
    ResolveOwnHostnameWithSystemDnsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::NetworkServiceTest::ResolveOwnHostnameWithSystemDns");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kResolveOwnHostnameWithSystemDns), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_ResolveOwnHostnameWithSystemDns_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("ResolveOwnHostnameWithSystemDns");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkServiceTestProxy::SetIPv6ProbeResult(
    bool in_success, SetIPv6ProbeResultCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkServiceTest::SetIPv6ProbeResult", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kSetIPv6ProbeResult), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_SetIPv6ProbeResult_Params_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("SetIPv6ProbeResult");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_SetIPv6ProbeResult_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool NetworkServiceTestProxy::GetAddressMapCacheLinux(
    ::net::AddressMapOwnerLinux::AddressMap* out_param_addr_map, ::std::unordered_set<int>* out_param_links) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call network::mojom::NetworkServiceTest::GetAddressMapCacheLinux (sync)");
#else
  TRACE_EVENT0("mojom", "NetworkServiceTest::GetAddressMapCacheLinux");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kGetAddressMapCacheLinux), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_GetAddressMapCacheLinux_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("GetAddressMapCacheLinux");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_GetAddressMapCacheLinux_HandleSyncResponse(
          &result, out_param_addr_map, out_param_links));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "NetworkServiceTest::GetAddressMapCacheLinux", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("addr_map"), out_param_addr_map,
                        "<value of type const ::net::AddressMapOwnerLinux::AddressMap&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("links"), out_param_links,
                        "<value of type const ::std::unordered_set<int>&>");
   });
#endif
  return result;
}

void NetworkServiceTestProxy::GetAddressMapCacheLinux(
    GetAddressMapCacheLinuxCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::NetworkServiceTest::GetAddressMapCacheLinux");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kGetAddressMapCacheLinux), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_GetAddressMapCacheLinux_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("GetAddressMapCacheLinux");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_GetAddressMapCacheLinux_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool NetworkServiceTestProxy::AllowsGSSAPILibraryLoad(
    bool* out_param_allow_gssapi_library_load) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call network::mojom::NetworkServiceTest::AllowsGSSAPILibraryLoad (sync)");
#else
  TRACE_EVENT0("mojom", "NetworkServiceTest::AllowsGSSAPILibraryLoad");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kAllowsGSSAPILibraryLoad), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_AllowsGSSAPILibraryLoad_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("AllowsGSSAPILibraryLoad");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_AllowsGSSAPILibraryLoad_HandleSyncResponse(
          &result, out_param_allow_gssapi_library_load));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "NetworkServiceTest::AllowsGSSAPILibraryLoad", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("allow_gssapi_library_load"), out_param_allow_gssapi_library_load,
                        "<value of type bool>");
   });
#endif
  return result;
}

void NetworkServiceTestProxy::AllowsGSSAPILibraryLoad(
    AllowsGSSAPILibraryLoadCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::NetworkServiceTest::AllowsGSSAPILibraryLoad");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kAllowsGSSAPILibraryLoad), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_AllowsGSSAPILibraryLoad_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("AllowsGSSAPILibraryLoad");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_AllowsGSSAPILibraryLoad_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkServiceTestProxy::IsHappyEyeballsV3Enabled(
    IsHappyEyeballsV3EnabledCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::NetworkServiceTest::IsHappyEyeballsV3Enabled");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kIsHappyEyeballsV3Enabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_IsHappyEyeballsV3Enabled_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("IsHappyEyeballsV3Enabled");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceTest_IsHappyEyeballsV3Enabled_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class NetworkServiceTest_AddRules_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkServiceTest::AddRulesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkServiceTest_AddRules_ProxyToResponder> proxy(
        new NetworkServiceTest_AddRules_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkServiceTest_AddRules_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkServiceTest_AddRules_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkServiceTest_AddRules_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkServiceTest::AddRulesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkServiceTest_AddRules_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_AddRules_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkServiceTest_AddRules_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkServiceTest.0
  bool success = true;
  NetworkServiceTest_AddRules_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetworkServiceTest_AddRules_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkServiceTest::AddRules");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kAddRules), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_AddRules_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("AddRules");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NetworkServiceTest_AddRules_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_AddRules_ResponseParams_Data* params =
      reinterpret_cast<internal::NetworkServiceTest_AddRules_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for NetworkServiceTest.0
  bool success = true;
  NetworkServiceTest_AddRules_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 0, true);
    return false;
  }
  *result_ = true;
  return true;
}
class NetworkServiceTest_SimulateNetworkChange_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkServiceTest::SimulateNetworkChangeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkServiceTest_SimulateNetworkChange_ProxyToResponder> proxy(
        new NetworkServiceTest_SimulateNetworkChange_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkServiceTest_SimulateNetworkChange_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkServiceTest_SimulateNetworkChange_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkServiceTest_SimulateNetworkChange_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkServiceTest::SimulateNetworkChangeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkServiceTest_SimulateNetworkChange_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_SimulateNetworkChange_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkServiceTest_SimulateNetworkChange_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkServiceTest.1
  bool success = true;
  NetworkServiceTest_SimulateNetworkChange_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetworkServiceTest_SimulateNetworkChange_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkServiceTest::SimulateNetworkChange");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kSimulateNetworkChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_SimulateNetworkChange_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("SimulateNetworkChange");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkServiceTest_SimulateNetworkQualityChange_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkServiceTest::SimulateNetworkQualityChangeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkServiceTest_SimulateNetworkQualityChange_ProxyToResponder> proxy(
        new NetworkServiceTest_SimulateNetworkQualityChange_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkServiceTest_SimulateNetworkQualityChange_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkServiceTest_SimulateNetworkQualityChange_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkServiceTest_SimulateNetworkQualityChange_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkServiceTest::SimulateNetworkQualityChangeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkServiceTest_SimulateNetworkQualityChange_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_SimulateNetworkQualityChange_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkServiceTest_SimulateNetworkQualityChange_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkServiceTest.2
  bool success = true;
  NetworkServiceTest_SimulateNetworkQualityChange_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetworkServiceTest_SimulateNetworkQualityChange_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkServiceTest::SimulateNetworkQualityChange");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kSimulateNetworkQualityChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_SimulateNetworkQualityChange_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("SimulateNetworkQualityChange");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkServiceTest::ForceNetworkQualityEstimatorReportWifiAsSlow2GCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ProxyToResponder> proxy(
        new NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkServiceTest::ForceNetworkQualityEstimatorReportWifiAsSlow2GCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkServiceTest.3
  bool success = true;
  NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkServiceTest::ForceNetworkQualityEstimatorReportWifiAsSlow2G");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kForceNetworkQualityEstimatorReportWifiAsSlow2G), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("ForceNetworkQualityEstimatorReportWifiAsSlow2G");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkServiceTest_MockCertVerifierSetDefaultResult_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkServiceTest::MockCertVerifierSetDefaultResultCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkServiceTest_MockCertVerifierSetDefaultResult_ProxyToResponder> proxy(
        new NetworkServiceTest_MockCertVerifierSetDefaultResult_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkServiceTest_MockCertVerifierSetDefaultResult_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkServiceTest_MockCertVerifierSetDefaultResult_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkServiceTest_MockCertVerifierSetDefaultResult_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkServiceTest::MockCertVerifierSetDefaultResultCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkServiceTest_MockCertVerifierSetDefaultResult_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkServiceTest.5
  bool success = true;
  NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetworkServiceTest_MockCertVerifierSetDefaultResult_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkServiceTest::MockCertVerifierSetDefaultResult");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kMockCertVerifierSetDefaultResult), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("MockCertVerifierSetDefaultResult");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NetworkServiceTest_MockCertVerifierSetDefaultResult_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParams_Data* params =
      reinterpret_cast<internal::NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for NetworkServiceTest.5
  bool success = true;
  NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 5, true);
    return false;
  }
  *result_ = true;
  return true;
}
class NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkServiceTest::MockCertVerifierAddResultForCertAndHostCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ProxyToResponder> proxy(
        new NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkServiceTest::MockCertVerifierAddResultForCertAndHostCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkServiceTest.6
  bool success = true;
  NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkServiceTest::MockCertVerifierAddResultForCertAndHost");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kMockCertVerifierAddResultForCertAndHost), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("MockCertVerifierAddResultForCertAndHost");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParams_Data* params =
      reinterpret_cast<internal::NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for NetworkServiceTest.6
  bool success = true;
  NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 6, true);
    return false;
  }
  *result_ = true;
  return true;
}
class NetworkServiceTest_SetTransportSecurityStateSource_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkServiceTest::SetTransportSecurityStateSourceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkServiceTest_SetTransportSecurityStateSource_ProxyToResponder> proxy(
        new NetworkServiceTest_SetTransportSecurityStateSource_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkServiceTest_SetTransportSecurityStateSource_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkServiceTest_SetTransportSecurityStateSource_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkServiceTest_SetTransportSecurityStateSource_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkServiceTest::SetTransportSecurityStateSourceCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkServiceTest_SetTransportSecurityStateSource_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_SetTransportSecurityStateSource_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkServiceTest_SetTransportSecurityStateSource_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkServiceTest.7
  bool success = true;
  NetworkServiceTest_SetTransportSecurityStateSource_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetworkServiceTest_SetTransportSecurityStateSource_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkServiceTest::SetTransportSecurityStateSource");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kSetTransportSecurityStateSource), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_SetTransportSecurityStateSource_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("SetTransportSecurityStateSource");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NetworkServiceTest_SetTransportSecurityStateSource_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_SetTransportSecurityStateSource_ResponseParams_Data* params =
      reinterpret_cast<internal::NetworkServiceTest_SetTransportSecurityStateSource_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for NetworkServiceTest.7
  bool success = true;
  NetworkServiceTest_SetTransportSecurityStateSource_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 7, true);
    return false;
  }
  *result_ = true;
  return true;
}
class NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkServiceTest::SetAllowNetworkAccessToHostResolutionsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ProxyToResponder> proxy(
        new NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkServiceTest::SetAllowNetworkAccessToHostResolutionsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkServiceTest.8
  bool success = true;
  NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkServiceTest::SetAllowNetworkAccessToHostResolutions");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kSetAllowNetworkAccessToHostResolutions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("SetAllowNetworkAccessToHostResolutions");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParams_Data* params =
      reinterpret_cast<internal::NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for NetworkServiceTest.8
  bool success = true;
  NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 8, true);
    return false;
  }
  *result_ = true;
  return true;
}
class NetworkServiceTest_ReplaceSystemDnsConfig_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkServiceTest::ReplaceSystemDnsConfigCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkServiceTest_ReplaceSystemDnsConfig_ProxyToResponder> proxy(
        new NetworkServiceTest_ReplaceSystemDnsConfig_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkServiceTest_ReplaceSystemDnsConfig_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkServiceTest_ReplaceSystemDnsConfig_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkServiceTest_ReplaceSystemDnsConfig_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkServiceTest::ReplaceSystemDnsConfigCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkServiceTest_ReplaceSystemDnsConfig_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkServiceTest.9
  bool success = true;
  NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetworkServiceTest_ReplaceSystemDnsConfig_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkServiceTest::ReplaceSystemDnsConfig");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kReplaceSystemDnsConfig), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("ReplaceSystemDnsConfig");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NetworkServiceTest_ReplaceSystemDnsConfig_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParams_Data* params =
      reinterpret_cast<internal::NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for NetworkServiceTest.9
  bool success = true;
  NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 9, true);
    return false;
  }
  *result_ = true;
  return true;
}
class NetworkServiceTest_SetTestDohConfig_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkServiceTest::SetTestDohConfigCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkServiceTest_SetTestDohConfig_ProxyToResponder> proxy(
        new NetworkServiceTest_SetTestDohConfig_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkServiceTest_SetTestDohConfig_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkServiceTest_SetTestDohConfig_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkServiceTest_SetTestDohConfig_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkServiceTest::SetTestDohConfigCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkServiceTest_SetTestDohConfig_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_SetTestDohConfig_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkServiceTest_SetTestDohConfig_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkServiceTest.10
  bool success = true;
  NetworkServiceTest_SetTestDohConfig_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetworkServiceTest_SetTestDohConfig_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkServiceTest::SetTestDohConfig");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kSetTestDohConfig), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_SetTestDohConfig_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("SetTestDohConfig");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NetworkServiceTest_SetTestDohConfig_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_SetTestDohConfig_ResponseParams_Data* params =
      reinterpret_cast<internal::NetworkServiceTest_SetTestDohConfig_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for NetworkServiceTest.10
  bool success = true;
  NetworkServiceTest_SetTestDohConfig_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 10, true);
    return false;
  }
  *result_ = true;
  return true;
}
class NetworkServiceTest_GetLatestMemoryPressureLevel_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkServiceTest::GetLatestMemoryPressureLevelCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkServiceTest_GetLatestMemoryPressureLevel_ProxyToResponder> proxy(
        new NetworkServiceTest_GetLatestMemoryPressureLevel_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkServiceTest_GetLatestMemoryPressureLevel_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkServiceTest_GetLatestMemoryPressureLevel_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkServiceTest_GetLatestMemoryPressureLevel_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkServiceTest::GetLatestMemoryPressureLevelCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::MemoryPressureListener::MemoryPressureLevel in_memory_pressure_level);
};

bool NetworkServiceTest_GetLatestMemoryPressureLevel_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkServiceTest.13
  bool success = true;
  ::base::MemoryPressureListener::MemoryPressureLevel p_memory_pressure_level{};
  NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadMemoryPressureLevel(&p_memory_pressure_level))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 13, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_memory_pressure_level));
  }
  return true;
}

void NetworkServiceTest_GetLatestMemoryPressureLevel_ProxyToResponder::Run(
    ::base::MemoryPressureListener::MemoryPressureLevel in_memory_pressure_level) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetworkServiceTest::GetLatestMemoryPressureLevel", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("memory_pressure_level"), in_memory_pressure_level,
                        "<value of type ::base::MemoryPressureListener::MemoryPressureLevel>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kGetLatestMemoryPressureLevel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::mojo_base::mojom::MemoryPressureLevel>(
    in_memory_pressure_level,
    &params->memory_pressure_level);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("GetLatestMemoryPressureLevel");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NetworkServiceTest_GetLatestMemoryPressureLevel_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams_Data* params =
      reinterpret_cast<internal::NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for NetworkServiceTest.13
  bool success = true;
  ::base::MemoryPressureListener::MemoryPressureLevel p_memory_pressure_level{};
  NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadMemoryPressureLevel(&p_memory_pressure_level))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 13, true);
    return false;
  }
  *out_memory_pressure_level_ = std::move(p_memory_pressure_level);
  *result_ = true;
  return true;
}
class NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkServiceTest::GetPeerToPeerConnectionsCountChangeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ProxyToResponder> proxy(
        new NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkServiceTest::GetPeerToPeerConnectionsCountChangeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      uint32_t in_connection_count);
};

bool NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkServiceTest.14
  bool success = true;
  uint32_t p_connection_count{};
  NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_connection_count = input_data_view.connection_count();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 14, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_connection_count));
  }
  return true;
}

void NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ProxyToResponder::Run(
    uint32_t in_connection_count) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetworkServiceTest::GetPeerToPeerConnectionsCountChange", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("connection_count"), in_connection_count,
                        "<value of type uint32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kGetPeerToPeerConnectionsCountChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->connection_count = in_connection_count;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("GetPeerToPeerConnectionsCountChange");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NetworkServiceTest_GetPeerToPeerConnectionsCountChange_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParams_Data* params =
      reinterpret_cast<internal::NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for NetworkServiceTest.14
  bool success = true;
  uint32_t p_connection_count{};
  NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_connection_count = input_data_view.connection_count();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 14, true);
    return false;
  }
  *out_connection_count_ = std::move(p_connection_count);
  *result_ = true;
  return true;
}
class NetworkServiceTest_GetEnvironmentVariableValue_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkServiceTest::GetEnvironmentVariableValueCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkServiceTest_GetEnvironmentVariableValue_ProxyToResponder> proxy(
        new NetworkServiceTest_GetEnvironmentVariableValue_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkServiceTest_GetEnvironmentVariableValue_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkServiceTest_GetEnvironmentVariableValue_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkServiceTest_GetEnvironmentVariableValue_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkServiceTest::GetEnvironmentVariableValueCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_value);
};

bool NetworkServiceTest_GetEnvironmentVariableValue_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkServiceTest.15
  bool success = true;
  std::string p_value{};
  NetworkServiceTest_GetEnvironmentVariableValue_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadValue(&p_value))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 15, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_value));
  }
  return true;
}

void NetworkServiceTest_GetEnvironmentVariableValue_ProxyToResponder::Run(
    const std::string& in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetworkServiceTest::GetEnvironmentVariableValue", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type const std::string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kGetEnvironmentVariableValue), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->value)::BaseType> value_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_value,
    value_fragment);

  params->value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->value.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null value in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("GetEnvironmentVariableValue");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NetworkServiceTest_GetEnvironmentVariableValue_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams_Data* params =
      reinterpret_cast<internal::NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for NetworkServiceTest.15
  bool success = true;
  std::string p_value{};
  NetworkServiceTest_GetEnvironmentVariableValue_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadValue(&p_value))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 15, true);
    return false;
  }
  *out_value_ = std::move(p_value);
  *result_ = true;
  return true;
}
class NetworkServiceTest_Log_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkServiceTest::LogCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkServiceTest_Log_ProxyToResponder> proxy(
        new NetworkServiceTest_Log_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkServiceTest_Log_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkServiceTest_Log_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkServiceTest_Log_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkServiceTest::LogCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkServiceTest_Log_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_Log_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkServiceTest_Log_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkServiceTest.16
  bool success = true;
  NetworkServiceTest_Log_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 16, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetworkServiceTest_Log_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkServiceTest::Log");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kLog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_Log_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("Log");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NetworkServiceTest_Log_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_Log_ResponseParams_Data* params =
      reinterpret_cast<internal::NetworkServiceTest_Log_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for NetworkServiceTest.16
  bool success = true;
  NetworkServiceTest_Log_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 16, true);
    return false;
  }
  *result_ = true;
  return true;
}
class NetworkServiceTest_SetSCTAuditingRetryDelay_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkServiceTest::SetSCTAuditingRetryDelayCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkServiceTest_SetSCTAuditingRetryDelay_ProxyToResponder> proxy(
        new NetworkServiceTest_SetSCTAuditingRetryDelay_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkServiceTest_SetSCTAuditingRetryDelay_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkServiceTest_SetSCTAuditingRetryDelay_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkServiceTest_SetSCTAuditingRetryDelay_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkServiceTest::SetSCTAuditingRetryDelayCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkServiceTest_SetSCTAuditingRetryDelay_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkServiceTest.18
  bool success = true;
  NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 18, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetworkServiceTest_SetSCTAuditingRetryDelay_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkServiceTest::SetSCTAuditingRetryDelay");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kSetSCTAuditingRetryDelay), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("SetSCTAuditingRetryDelay");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NetworkServiceTest_SetSCTAuditingRetryDelay_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParams_Data* params =
      reinterpret_cast<internal::NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for NetworkServiceTest.18
  bool success = true;
  NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 18, true);
    return false;
  }
  *result_ = true;
  return true;
}
class NetworkServiceTest_OpenFile_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkServiceTest::OpenFileCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkServiceTest_OpenFile_ProxyToResponder> proxy(
        new NetworkServiceTest_OpenFile_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkServiceTest_OpenFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkServiceTest_OpenFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkServiceTest_OpenFile_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkServiceTest::OpenFileCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_result);
};

bool NetworkServiceTest_OpenFile_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_OpenFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkServiceTest_OpenFile_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkServiceTest.19
  bool success = true;
  bool p_result{};
  NetworkServiceTest_OpenFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 19, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void NetworkServiceTest_OpenFile_ProxyToResponder::Run(
    bool in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetworkServiceTest::OpenFile", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kOpenFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_OpenFile_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("OpenFile");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkServiceTest_EnumerateFiles_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkServiceTest::EnumerateFilesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkServiceTest_EnumerateFiles_ProxyToResponder> proxy(
        new NetworkServiceTest_EnumerateFiles_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkServiceTest_EnumerateFiles_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkServiceTest_EnumerateFiles_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkServiceTest_EnumerateFiles_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkServiceTest::EnumerateFilesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<::disk_cache::BackendFileOperations::FileEnumerationEntry>& in_entries, bool in_error);
};

bool NetworkServiceTest_EnumerateFiles_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_EnumerateFiles_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkServiceTest_EnumerateFiles_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkServiceTest.20
  bool success = true;
  std::vector<::disk_cache::BackendFileOperations::FileEnumerationEntry> p_entries{};
  bool p_error{};
  NetworkServiceTest_EnumerateFiles_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadEntries(&p_entries))
    success = false;
  if (success)
    p_error = input_data_view.error();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 20, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_entries), 
std::move(p_error));
  }
  return true;
}

void NetworkServiceTest_EnumerateFiles_ProxyToResponder::Run(
    const std::vector<::disk_cache::BackendFileOperations::FileEnumerationEntry>& in_entries, bool in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetworkServiceTest::EnumerateFiles", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("entries"), in_entries,
                        "<value of type const std::vector<::disk_cache::BackendFileOperations::FileEnumerationEntry>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kEnumerateFiles), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_EnumerateFiles_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->entries)::BaseType>
      entries_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& entries_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::FileEnumerationEntryDataView>>(
    in_entries,
    entries_fragment,
    &entries_validate_params);

  params->entries.Set(
      entries_fragment.is_null() ? nullptr : entries_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->entries.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null entries in ");

  params->error = in_error;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("EnumerateFiles");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkServiceTest_CreateSimpleCache_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkServiceTest::CreateSimpleCacheCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkServiceTest_CreateSimpleCache_ProxyToResponder> proxy(
        new NetworkServiceTest_CreateSimpleCache_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkServiceTest_CreateSimpleCache_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkServiceTest_CreateSimpleCache_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkServiceTest_CreateSimpleCache_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkServiceTest::CreateSimpleCacheCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PendingRemote<SimpleCache> in_backend);
};

bool NetworkServiceTest_CreateSimpleCache_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_CreateSimpleCache_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkServiceTest_CreateSimpleCache_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkServiceTest.21
  bool success = true;
  ::mojo::PendingRemote<SimpleCache> p_backend{};
  NetworkServiceTest_CreateSimpleCache_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_backend =
        input_data_view.TakeBackend<decltype(p_backend)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 21, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_backend));
  }
  return true;
}

void NetworkServiceTest_CreateSimpleCache_ProxyToResponder::Run(
    ::mojo::PendingRemote<SimpleCache> in_backend) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetworkServiceTest::CreateSimpleCache", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("backend"), in_backend,
                        "<value of type ::mojo::PendingRemote<SimpleCache>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kCreateSimpleCache), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_CreateSimpleCache_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::SimpleCacheInterfaceBase>>(
    in_backend,
    &params->backend,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("CreateSimpleCache");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkServiceTest_MakeRequestToServer_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkServiceTest::MakeRequestToServerCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkServiceTest_MakeRequestToServer_ProxyToResponder> proxy(
        new NetworkServiceTest_MakeRequestToServer_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkServiceTest_MakeRequestToServer_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkServiceTest_MakeRequestToServer_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkServiceTest_MakeRequestToServer_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkServiceTest::MakeRequestToServerCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_result);
};

bool NetworkServiceTest_MakeRequestToServer_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_MakeRequestToServer_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkServiceTest_MakeRequestToServer_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkServiceTest.22
  bool success = true;
  bool p_result{};
  NetworkServiceTest_MakeRequestToServer_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 22, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void NetworkServiceTest_MakeRequestToServer_ProxyToResponder::Run(
    bool in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetworkServiceTest::MakeRequestToServer", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kMakeRequestToServer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_MakeRequestToServer_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("MakeRequestToServer");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkServiceTest::ResolveOwnHostnameWithSystemDnsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ProxyToResponder> proxy(
        new NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkServiceTest::ResolveOwnHostnameWithSystemDnsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::net::AddressList& in_addr_list, int32_t in_os_error, int32_t in_net_error);
};

bool NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkServiceTest.23
  bool success = true;
  ::net::AddressList p_addr_list{};
  int32_t p_os_error{};
  int32_t p_net_error{};
  NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadAddrList(&p_addr_list))
    success = false;
  if (success)
    p_os_error = input_data_view.os_error();
  if (success)
    p_net_error = input_data_view.net_error();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 23, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_addr_list), 
std::move(p_os_error), 
std::move(p_net_error));
  }
  return true;
}

void NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ProxyToResponder::Run(
    const ::net::AddressList& in_addr_list, int32_t in_os_error, int32_t in_net_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetworkServiceTest::ResolveOwnHostnameWithSystemDns", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("addr_list"), in_addr_list,
                        "<value of type const ::net::AddressList&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("os_error"), in_os_error,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("net_error"), in_net_error,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kResolveOwnHostnameWithSystemDns), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->addr_list)::BaseType> addr_list_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::AddressListDataView>(
    in_addr_list,
    addr_list_fragment);

  params->addr_list.Set(
      addr_list_fragment.is_null() ? nullptr : addr_list_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->addr_list.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null addr_list in ");

  params->os_error = in_os_error;

  params->net_error = in_net_error;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("ResolveOwnHostnameWithSystemDns");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkServiceTest_SetIPv6ProbeResult_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkServiceTest::SetIPv6ProbeResultCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkServiceTest_SetIPv6ProbeResult_ProxyToResponder> proxy(
        new NetworkServiceTest_SetIPv6ProbeResult_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkServiceTest_SetIPv6ProbeResult_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkServiceTest_SetIPv6ProbeResult_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkServiceTest_SetIPv6ProbeResult_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkServiceTest::SetIPv6ProbeResultCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkServiceTest_SetIPv6ProbeResult_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_SetIPv6ProbeResult_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkServiceTest_SetIPv6ProbeResult_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkServiceTest.24
  bool success = true;
  NetworkServiceTest_SetIPv6ProbeResult_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 24, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetworkServiceTest_SetIPv6ProbeResult_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkServiceTest::SetIPv6ProbeResult");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kSetIPv6ProbeResult), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_SetIPv6ProbeResult_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("SetIPv6ProbeResult");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkServiceTest_GetAddressMapCacheLinux_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkServiceTest::GetAddressMapCacheLinuxCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkServiceTest_GetAddressMapCacheLinux_ProxyToResponder> proxy(
        new NetworkServiceTest_GetAddressMapCacheLinux_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkServiceTest_GetAddressMapCacheLinux_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkServiceTest_GetAddressMapCacheLinux_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkServiceTest_GetAddressMapCacheLinux_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkServiceTest::GetAddressMapCacheLinuxCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::net::AddressMapOwnerLinux::AddressMap& in_addr_map, const ::std::unordered_set<int>& in_links);
};

bool NetworkServiceTest_GetAddressMapCacheLinux_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_GetAddressMapCacheLinux_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkServiceTest_GetAddressMapCacheLinux_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkServiceTest.25
  bool success = true;
  ::net::AddressMapOwnerLinux::AddressMap p_addr_map{};
  ::std::unordered_set<int> p_links{};
  NetworkServiceTest_GetAddressMapCacheLinux_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadAddrMap(&p_addr_map))
    success = false;
  if (success && !input_data_view.ReadLinks(&p_links))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 25, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_addr_map), 
std::move(p_links));
  }
  return true;
}

void NetworkServiceTest_GetAddressMapCacheLinux_ProxyToResponder::Run(
    const ::net::AddressMapOwnerLinux::AddressMap& in_addr_map, const ::std::unordered_set<int>& in_links) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetworkServiceTest::GetAddressMapCacheLinux", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("addr_map"), in_addr_map,
                        "<value of type const ::net::AddressMapOwnerLinux::AddressMap&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("links"), in_links,
                        "<value of type const ::std::unordered_set<int>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kGetAddressMapCacheLinux), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_GetAddressMapCacheLinux_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->addr_map)::BaseType> addr_map_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::AddressMapDataView>(
    in_addr_map,
    addr_map_fragment);

  params->addr_map.Set(
      addr_map_fragment.is_null() ? nullptr : addr_map_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->addr_map.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null addr_map in ");
  mojo::internal::MessageFragment<
      typename decltype(params->links)::BaseType> links_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::OnlineLinksDataView>(
    in_links,
    links_fragment);

  params->links.Set(
      links_fragment.is_null() ? nullptr : links_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->links.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null links in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("GetAddressMapCacheLinux");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NetworkServiceTest_GetAddressMapCacheLinux_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_GetAddressMapCacheLinux_ResponseParams_Data* params =
      reinterpret_cast<internal::NetworkServiceTest_GetAddressMapCacheLinux_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for NetworkServiceTest.25
  bool success = true;
  ::net::AddressMapOwnerLinux::AddressMap p_addr_map{};
  ::std::unordered_set<int> p_links{};
  NetworkServiceTest_GetAddressMapCacheLinux_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadAddrMap(&p_addr_map))
    success = false;
  if (success && !input_data_view.ReadLinks(&p_links))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 25, true);
    return false;
  }
  *out_addr_map_ = std::move(p_addr_map);
  *out_links_ = std::move(p_links);
  *result_ = true;
  return true;
}
class NetworkServiceTest_AllowsGSSAPILibraryLoad_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkServiceTest::AllowsGSSAPILibraryLoadCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkServiceTest_AllowsGSSAPILibraryLoad_ProxyToResponder> proxy(
        new NetworkServiceTest_AllowsGSSAPILibraryLoad_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkServiceTest_AllowsGSSAPILibraryLoad_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkServiceTest_AllowsGSSAPILibraryLoad_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkServiceTest_AllowsGSSAPILibraryLoad_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkServiceTest::AllowsGSSAPILibraryLoadCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_allow_gssapi_library_load);
};

bool NetworkServiceTest_AllowsGSSAPILibraryLoad_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkServiceTest.26
  bool success = true;
  bool p_allow_gssapi_library_load{};
  NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_allow_gssapi_library_load = input_data_view.allow_gssapi_library_load();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 26, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_allow_gssapi_library_load));
  }
  return true;
}

void NetworkServiceTest_AllowsGSSAPILibraryLoad_ProxyToResponder::Run(
    bool in_allow_gssapi_library_load) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetworkServiceTest::AllowsGSSAPILibraryLoad", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("allow_gssapi_library_load"), in_allow_gssapi_library_load,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kAllowsGSSAPILibraryLoad), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->allow_gssapi_library_load = in_allow_gssapi_library_load;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("AllowsGSSAPILibraryLoad");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NetworkServiceTest_AllowsGSSAPILibraryLoad_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParams_Data* params =
      reinterpret_cast<internal::NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for NetworkServiceTest.26
  bool success = true;
  bool p_allow_gssapi_library_load{};
  NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_allow_gssapi_library_load = input_data_view.allow_gssapi_library_load();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 26, true);
    return false;
  }
  *out_allow_gssapi_library_load_ = std::move(p_allow_gssapi_library_load);
  *result_ = true;
  return true;
}
class NetworkServiceTest_IsHappyEyeballsV3Enabled_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkServiceTest::IsHappyEyeballsV3EnabledCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkServiceTest_IsHappyEyeballsV3Enabled_ProxyToResponder> proxy(
        new NetworkServiceTest_IsHappyEyeballsV3Enabled_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkServiceTest_IsHappyEyeballsV3Enabled_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkServiceTest_IsHappyEyeballsV3Enabled_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkServiceTest_IsHappyEyeballsV3Enabled_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkServiceTest::IsHappyEyeballsV3EnabledCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_is_happy_eyeballs_v3_enabled);
};

bool NetworkServiceTest_IsHappyEyeballsV3Enabled_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkServiceTest_IsHappyEyeballsV3Enabled_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkServiceTest_IsHappyEyeballsV3Enabled_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkServiceTest.27
  bool success = true;
  bool p_is_happy_eyeballs_v3_enabled{};
  NetworkServiceTest_IsHappyEyeballsV3Enabled_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_is_happy_eyeballs_v3_enabled = input_data_view.is_happy_eyeballs_v3_enabled();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceTest::Name_, 27, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_is_happy_eyeballs_v3_enabled));
  }
  return true;
}

void NetworkServiceTest_IsHappyEyeballsV3Enabled_ProxyToResponder::Run(
    bool in_is_happy_eyeballs_v3_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetworkServiceTest::IsHappyEyeballsV3Enabled", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_happy_eyeballs_v3_enabled"), in_is_happy_eyeballs_v3_enabled,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkServiceTest::kIsHappyEyeballsV3Enabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceTest_IsHappyEyeballsV3Enabled_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->is_happy_eyeballs_v3_enabled = in_is_happy_eyeballs_v3_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceTest::Name_);
  message.set_method_name("IsHappyEyeballsV3Enabled");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool NetworkServiceTestStubDispatch::Accept(
    NetworkServiceTest* impl,
    mojo::Message* message) {
  switch (static_cast<messages::NetworkServiceTest>(message->header()->name)) {
    case messages::NetworkServiceTest::kAddRules: {
      break;
    }
    case messages::NetworkServiceTest::kSimulateNetworkChange: {
      break;
    }
    case messages::NetworkServiceTest::kSimulateNetworkQualityChange: {
      break;
    }
    case messages::NetworkServiceTest::kForceNetworkQualityEstimatorReportWifiAsSlow2G: {
      break;
    }
    case messages::NetworkServiceTest::kSimulateCrash: {
      DCHECK(message->is_serialized());
      internal::NetworkServiceTest_SimulateCrash_Params_Data* params =
          reinterpret_cast<internal::NetworkServiceTest_SimulateCrash_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkServiceTest.4
      bool success = true;
      NetworkServiceTest_SimulateCrash_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SimulateCrash(        );
      return true;
    }
    case messages::NetworkServiceTest::kMockCertVerifierSetDefaultResult: {
      break;
    }
    case messages::NetworkServiceTest::kMockCertVerifierAddResultForCertAndHost: {
      break;
    }
    case messages::NetworkServiceTest::kSetTransportSecurityStateSource: {
      break;
    }
    case messages::NetworkServiceTest::kSetAllowNetworkAccessToHostResolutions: {
      break;
    }
    case messages::NetworkServiceTest::kReplaceSystemDnsConfig: {
      break;
    }
    case messages::NetworkServiceTest::kSetTestDohConfig: {
      break;
    }
    case messages::NetworkServiceTest::kCrashOnResolveHost: {
      DCHECK(message->is_serialized());
      internal::NetworkServiceTest_CrashOnResolveHost_Params_Data* params =
          reinterpret_cast<internal::NetworkServiceTest_CrashOnResolveHost_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkServiceTest.11
      bool success = true;
      std::string p_host{};
      NetworkServiceTest_CrashOnResolveHost_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHost(&p_host))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CrashOnResolveHost(        
        std::move(p_host));
      return true;
    }
    case messages::NetworkServiceTest::kCrashOnGetCookieList: {
      DCHECK(message->is_serialized());
      internal::NetworkServiceTest_CrashOnGetCookieList_Params_Data* params =
          reinterpret_cast<internal::NetworkServiceTest_CrashOnGetCookieList_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkServiceTest.12
      bool success = true;
      NetworkServiceTest_CrashOnGetCookieList_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CrashOnGetCookieList(        );
      return true;
    }
    case messages::NetworkServiceTest::kGetLatestMemoryPressureLevel: {
      break;
    }
    case messages::NetworkServiceTest::kGetPeerToPeerConnectionsCountChange: {
      break;
    }
    case messages::NetworkServiceTest::kGetEnvironmentVariableValue: {
      break;
    }
    case messages::NetworkServiceTest::kLog: {
      break;
    }
    case messages::NetworkServiceTest::kActivateFieldTrial: {
      DCHECK(message->is_serialized());
      internal::NetworkServiceTest_ActivateFieldTrial_Params_Data* params =
          reinterpret_cast<internal::NetworkServiceTest_ActivateFieldTrial_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkServiceTest.17
      bool success = true;
      std::string p_field_trial_name{};
      NetworkServiceTest_ActivateFieldTrial_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFieldTrialName(&p_field_trial_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ActivateFieldTrial(        
        std::move(p_field_trial_name));
      return true;
    }
    case messages::NetworkServiceTest::kSetSCTAuditingRetryDelay: {
      break;
    }
    case messages::NetworkServiceTest::kOpenFile: {
      break;
    }
    case messages::NetworkServiceTest::kEnumerateFiles: {
      break;
    }
    case messages::NetworkServiceTest::kCreateSimpleCache: {
      break;
    }
    case messages::NetworkServiceTest::kMakeRequestToServer: {
      break;
    }
    case messages::NetworkServiceTest::kResolveOwnHostnameWithSystemDns: {
      break;
    }
    case messages::NetworkServiceTest::kSetIPv6ProbeResult: {
      break;
    }
    case messages::NetworkServiceTest::kGetAddressMapCacheLinux: {
      break;
    }
    case messages::NetworkServiceTest::kAllowsGSSAPILibraryLoad: {
      break;
    }
    case messages::NetworkServiceTest::kIsHappyEyeballsV3Enabled: {
      break;
    }
  }
  return false;
}

// static
bool NetworkServiceTestStubDispatch::AcceptWithResponder(
    NetworkServiceTest* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::NetworkServiceTest>(message->header()->name)) {
    case messages::NetworkServiceTest::kAddRules: {
      internal::NetworkServiceTest_AddRules_Params_Data* params =
          reinterpret_cast<
              internal::NetworkServiceTest_AddRules_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkServiceTest.0
      bool success = true;
      std::vector<RulePtr> p_rules{};
      NetworkServiceTest_AddRules_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRules(&p_rules))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 0, false);
        return false;
      }
      auto callback =
          NetworkServiceTest_AddRules_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddRules(        
        std::move(p_rules), std::move(callback));
      return true;
    }
    case messages::NetworkServiceTest::kSimulateNetworkChange: {
      internal::NetworkServiceTest_SimulateNetworkChange_Params_Data* params =
          reinterpret_cast<
              internal::NetworkServiceTest_SimulateNetworkChange_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkServiceTest.1
      bool success = true;
      ::network::mojom::ConnectionType p_type{};
      NetworkServiceTest_SimulateNetworkChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 1, false);
        return false;
      }
      auto callback =
          NetworkServiceTest_SimulateNetworkChange_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SimulateNetworkChange(        
        std::move(p_type), std::move(callback));
      return true;
    }
    case messages::NetworkServiceTest::kSimulateNetworkQualityChange: {
      internal::NetworkServiceTest_SimulateNetworkQualityChange_Params_Data* params =
          reinterpret_cast<
              internal::NetworkServiceTest_SimulateNetworkQualityChange_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkServiceTest.2
      bool success = true;
      ::net::EffectiveConnectionType p_type{};
      NetworkServiceTest_SimulateNetworkQualityChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 2, false);
        return false;
      }
      auto callback =
          NetworkServiceTest_SimulateNetworkQualityChange_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SimulateNetworkQualityChange(        
        std::move(p_type), std::move(callback));
      return true;
    }
    case messages::NetworkServiceTest::kForceNetworkQualityEstimatorReportWifiAsSlow2G: {
      internal::NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_Params_Data* params =
          reinterpret_cast<
              internal::NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkServiceTest.3
      bool success = true;
      NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 3, false);
        return false;
      }
      auto callback =
          NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ForceNetworkQualityEstimatorReportWifiAsSlow2G(std::move(callback));
      return true;
    }
    case messages::NetworkServiceTest::kSimulateCrash: {
      break;
    }
    case messages::NetworkServiceTest::kMockCertVerifierSetDefaultResult: {
      internal::NetworkServiceTest_MockCertVerifierSetDefaultResult_Params_Data* params =
          reinterpret_cast<
              internal::NetworkServiceTest_MockCertVerifierSetDefaultResult_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkServiceTest.5
      bool success = true;
      int32_t p_default_result{};
      NetworkServiceTest_MockCertVerifierSetDefaultResult_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_default_result = input_data_view.default_result();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 5, false);
        return false;
      }
      auto callback =
          NetworkServiceTest_MockCertVerifierSetDefaultResult_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MockCertVerifierSetDefaultResult(        
        std::move(p_default_result), std::move(callback));
      return true;
    }
    case messages::NetworkServiceTest::kMockCertVerifierAddResultForCertAndHost: {
      internal::NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params_Data* params =
          reinterpret_cast<
              internal::NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkServiceTest.6
      bool success = true;
      ::scoped_refptr<::net::X509Certificate> p_cert{};
      std::string p_host_pattern{};
      ::net::CertVerifyResult p_verify_result{};
      int32_t p_rv{};
      NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCert(&p_cert))
        success = false;
      if (success && !input_data_view.ReadHostPattern(&p_host_pattern))
        success = false;
      if (success && !input_data_view.ReadVerifyResult(&p_verify_result))
        success = false;
      if (success)
        p_rv = input_data_view.rv();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 6, false);
        return false;
      }
      auto callback =
          NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MockCertVerifierAddResultForCertAndHost(        
        std::move(p_cert), 
        std::move(p_host_pattern), 
        std::move(p_verify_result), 
        std::move(p_rv), std::move(callback));
      return true;
    }
    case messages::NetworkServiceTest::kSetTransportSecurityStateSource: {
      internal::NetworkServiceTest_SetTransportSecurityStateSource_Params_Data* params =
          reinterpret_cast<
              internal::NetworkServiceTest_SetTransportSecurityStateSource_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkServiceTest.7
      bool success = true;
      uint16_t p_reporting_port{};
      NetworkServiceTest_SetTransportSecurityStateSource_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_reporting_port = input_data_view.reporting_port();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 7, false);
        return false;
      }
      auto callback =
          NetworkServiceTest_SetTransportSecurityStateSource_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTransportSecurityStateSource(        
        std::move(p_reporting_port), std::move(callback));
      return true;
    }
    case messages::NetworkServiceTest::kSetAllowNetworkAccessToHostResolutions: {
      internal::NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Params_Data* params =
          reinterpret_cast<
              internal::NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkServiceTest.8
      bool success = true;
      NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 8, false);
        return false;
      }
      auto callback =
          NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetAllowNetworkAccessToHostResolutions(std::move(callback));
      return true;
    }
    case messages::NetworkServiceTest::kReplaceSystemDnsConfig: {
      internal::NetworkServiceTest_ReplaceSystemDnsConfig_Params_Data* params =
          reinterpret_cast<
              internal::NetworkServiceTest_ReplaceSystemDnsConfig_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkServiceTest.9
      bool success = true;
      NetworkServiceTest_ReplaceSystemDnsConfig_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 9, false);
        return false;
      }
      auto callback =
          NetworkServiceTest_ReplaceSystemDnsConfig_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReplaceSystemDnsConfig(std::move(callback));
      return true;
    }
    case messages::NetworkServiceTest::kSetTestDohConfig: {
      internal::NetworkServiceTest_SetTestDohConfig_Params_Data* params =
          reinterpret_cast<
              internal::NetworkServiceTest_SetTestDohConfig_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkServiceTest.10
      bool success = true;
      ::net::SecureDnsMode p_secure_dns_mode{};
      ::net::DnsOverHttpsConfig p_doh_config{};
      NetworkServiceTest_SetTestDohConfig_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSecureDnsMode(&p_secure_dns_mode))
        success = false;
      if (success && !input_data_view.ReadDohConfig(&p_doh_config))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 10, false);
        return false;
      }
      auto callback =
          NetworkServiceTest_SetTestDohConfig_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTestDohConfig(        
        std::move(p_secure_dns_mode), 
        std::move(p_doh_config), std::move(callback));
      return true;
    }
    case messages::NetworkServiceTest::kCrashOnResolveHost: {
      break;
    }
    case messages::NetworkServiceTest::kCrashOnGetCookieList: {
      break;
    }
    case messages::NetworkServiceTest::kGetLatestMemoryPressureLevel: {
      internal::NetworkServiceTest_GetLatestMemoryPressureLevel_Params_Data* params =
          reinterpret_cast<
              internal::NetworkServiceTest_GetLatestMemoryPressureLevel_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkServiceTest.13
      bool success = true;
      NetworkServiceTest_GetLatestMemoryPressureLevel_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 13, false);
        return false;
      }
      auto callback =
          NetworkServiceTest_GetLatestMemoryPressureLevel_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetLatestMemoryPressureLevel(std::move(callback));
      return true;
    }
    case messages::NetworkServiceTest::kGetPeerToPeerConnectionsCountChange: {
      internal::NetworkServiceTest_GetPeerToPeerConnectionsCountChange_Params_Data* params =
          reinterpret_cast<
              internal::NetworkServiceTest_GetPeerToPeerConnectionsCountChange_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkServiceTest.14
      bool success = true;
      NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 14, false);
        return false;
      }
      auto callback =
          NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPeerToPeerConnectionsCountChange(std::move(callback));
      return true;
    }
    case messages::NetworkServiceTest::kGetEnvironmentVariableValue: {
      internal::NetworkServiceTest_GetEnvironmentVariableValue_Params_Data* params =
          reinterpret_cast<
              internal::NetworkServiceTest_GetEnvironmentVariableValue_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkServiceTest.15
      bool success = true;
      std::string p_name{};
      NetworkServiceTest_GetEnvironmentVariableValue_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 15, false);
        return false;
      }
      auto callback =
          NetworkServiceTest_GetEnvironmentVariableValue_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetEnvironmentVariableValue(        
        std::move(p_name), std::move(callback));
      return true;
    }
    case messages::NetworkServiceTest::kLog: {
      internal::NetworkServiceTest_Log_Params_Data* params =
          reinterpret_cast<
              internal::NetworkServiceTest_Log_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkServiceTest.16
      bool success = true;
      std::string p_message{};
      NetworkServiceTest_Log_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 16, false);
        return false;
      }
      auto callback =
          NetworkServiceTest_Log_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Log(        
        std::move(p_message), std::move(callback));
      return true;
    }
    case messages::NetworkServiceTest::kActivateFieldTrial: {
      break;
    }
    case messages::NetworkServiceTest::kSetSCTAuditingRetryDelay: {
      internal::NetworkServiceTest_SetSCTAuditingRetryDelay_Params_Data* params =
          reinterpret_cast<
              internal::NetworkServiceTest_SetSCTAuditingRetryDelay_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkServiceTest.18
      bool success = true;
      std::optional<::base::TimeDelta> p_delay{};
      NetworkServiceTest_SetSCTAuditingRetryDelay_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDelay(&p_delay))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 18, false);
        return false;
      }
      auto callback =
          NetworkServiceTest_SetSCTAuditingRetryDelay_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSCTAuditingRetryDelay(        
        std::move(p_delay), std::move(callback));
      return true;
    }
    case messages::NetworkServiceTest::kOpenFile: {
      internal::NetworkServiceTest_OpenFile_Params_Data* params =
          reinterpret_cast<
              internal::NetworkServiceTest_OpenFile_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkServiceTest.19
      bool success = true;
      ::base::FilePath p_path{};
      NetworkServiceTest_OpenFile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 19, false);
        return false;
      }
      auto callback =
          NetworkServiceTest_OpenFile_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenFile(        
        std::move(p_path), std::move(callback));
      return true;
    }
    case messages::NetworkServiceTest::kEnumerateFiles: {
      internal::NetworkServiceTest_EnumerateFiles_Params_Data* params =
          reinterpret_cast<
              internal::NetworkServiceTest_EnumerateFiles_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkServiceTest.20
      bool success = true;
      ::base::FilePath p_path{};
      ::mojo::PendingRemote<::network::mojom::HttpCacheBackendFileOperationsFactory> p_factory{};
      NetworkServiceTest_EnumerateFiles_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (success) {
        p_factory =
            input_data_view.TakeFactory<decltype(p_factory)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 20, false);
        return false;
      }
      auto callback =
          NetworkServiceTest_EnumerateFiles_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnumerateFiles(        
        std::move(p_path), 
        std::move(p_factory), std::move(callback));
      return true;
    }
    case messages::NetworkServiceTest::kCreateSimpleCache: {
      internal::NetworkServiceTest_CreateSimpleCache_Params_Data* params =
          reinterpret_cast<
              internal::NetworkServiceTest_CreateSimpleCache_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkServiceTest.21
      bool success = true;
      ::mojo::PendingRemote<::network::mojom::HttpCacheBackendFileOperationsFactory> p_factory{};
      ::base::FilePath p_path{};
      bool p_reset{};
      NetworkServiceTest_CreateSimpleCache_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_factory =
            input_data_view.TakeFactory<decltype(p_factory)>();
      }
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (success)
        p_reset = input_data_view.reset();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 21, false);
        return false;
      }
      auto callback =
          NetworkServiceTest_CreateSimpleCache_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateSimpleCache(        
        std::move(p_factory), 
        std::move(p_path), 
        std::move(p_reset), std::move(callback));
      return true;
    }
    case messages::NetworkServiceTest::kMakeRequestToServer: {
      internal::NetworkServiceTest_MakeRequestToServer_Params_Data* params =
          reinterpret_cast<
              internal::NetworkServiceTest_MakeRequestToServer_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkServiceTest.22
      bool success = true;
      ::network::TransferableSocket p_s{};
      ::net::IPEndPoint p_endpoint{};
      NetworkServiceTest_MakeRequestToServer_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadS(&p_s))
        success = false;
      if (success && !input_data_view.ReadEndpoint(&p_endpoint))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 22, false);
        return false;
      }
      auto callback =
          NetworkServiceTest_MakeRequestToServer_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MakeRequestToServer(        
        std::move(p_s), 
        std::move(p_endpoint), std::move(callback));
      return true;
    }
    case messages::NetworkServiceTest::kResolveOwnHostnameWithSystemDns: {
      internal::NetworkServiceTest_ResolveOwnHostnameWithSystemDns_Params_Data* params =
          reinterpret_cast<
              internal::NetworkServiceTest_ResolveOwnHostnameWithSystemDns_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkServiceTest.23
      bool success = true;
      NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 23, false);
        return false;
      }
      auto callback =
          NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResolveOwnHostnameWithSystemDns(std::move(callback));
      return true;
    }
    case messages::NetworkServiceTest::kSetIPv6ProbeResult: {
      internal::NetworkServiceTest_SetIPv6ProbeResult_Params_Data* params =
          reinterpret_cast<
              internal::NetworkServiceTest_SetIPv6ProbeResult_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkServiceTest.24
      bool success = true;
      bool p_success{};
      NetworkServiceTest_SetIPv6ProbeResult_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_success = input_data_view.success();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 24, false);
        return false;
      }
      auto callback =
          NetworkServiceTest_SetIPv6ProbeResult_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetIPv6ProbeResult(        
        std::move(p_success), std::move(callback));
      return true;
    }
    case messages::NetworkServiceTest::kGetAddressMapCacheLinux: {
      internal::NetworkServiceTest_GetAddressMapCacheLinux_Params_Data* params =
          reinterpret_cast<
              internal::NetworkServiceTest_GetAddressMapCacheLinux_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkServiceTest.25
      bool success = true;
      NetworkServiceTest_GetAddressMapCacheLinux_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 25, false);
        return false;
      }
      auto callback =
          NetworkServiceTest_GetAddressMapCacheLinux_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAddressMapCacheLinux(std::move(callback));
      return true;
    }
    case messages::NetworkServiceTest::kAllowsGSSAPILibraryLoad: {
      internal::NetworkServiceTest_AllowsGSSAPILibraryLoad_Params_Data* params =
          reinterpret_cast<
              internal::NetworkServiceTest_AllowsGSSAPILibraryLoad_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkServiceTest.26
      bool success = true;
      NetworkServiceTest_AllowsGSSAPILibraryLoad_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 26, false);
        return false;
      }
      auto callback =
          NetworkServiceTest_AllowsGSSAPILibraryLoad_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AllowsGSSAPILibraryLoad(std::move(callback));
      return true;
    }
    case messages::NetworkServiceTest::kIsHappyEyeballsV3Enabled: {
      internal::NetworkServiceTest_IsHappyEyeballsV3Enabled_Params_Data* params =
          reinterpret_cast<
              internal::NetworkServiceTest_IsHappyEyeballsV3Enabled_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkServiceTest.27
      bool success = true;
      NetworkServiceTest_IsHappyEyeballsV3Enabled_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceTest::Name_, 27, false);
        return false;
      }
      auto callback =
          NetworkServiceTest_IsHappyEyeballsV3Enabled_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsHappyEyeballsV3Enabled(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kNetworkServiceTestValidationInfo[] = {
    {base::to_underlying(messages::NetworkServiceTest::kAddRules),
     { &internal::NetworkServiceTest_AddRules_Params_Data::Validate,
      &internal::NetworkServiceTest_AddRules_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkServiceTest::kSimulateNetworkChange),
     { &internal::NetworkServiceTest_SimulateNetworkChange_Params_Data::Validate,
      &internal::NetworkServiceTest_SimulateNetworkChange_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkServiceTest::kSimulateNetworkQualityChange),
     { &internal::NetworkServiceTest_SimulateNetworkQualityChange_Params_Data::Validate,
      &internal::NetworkServiceTest_SimulateNetworkQualityChange_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkServiceTest::kForceNetworkQualityEstimatorReportWifiAsSlow2G),
     { &internal::NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_Params_Data::Validate,
      &internal::NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkServiceTest::kSimulateCrash),
     { &internal::NetworkServiceTest_SimulateCrash_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkServiceTest::kMockCertVerifierSetDefaultResult),
     { &internal::NetworkServiceTest_MockCertVerifierSetDefaultResult_Params_Data::Validate,
      &internal::NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkServiceTest::kMockCertVerifierAddResultForCertAndHost),
     { &internal::NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params_Data::Validate,
      &internal::NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkServiceTest::kSetTransportSecurityStateSource),
     { &internal::NetworkServiceTest_SetTransportSecurityStateSource_Params_Data::Validate,
      &internal::NetworkServiceTest_SetTransportSecurityStateSource_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkServiceTest::kSetAllowNetworkAccessToHostResolutions),
     { &internal::NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Params_Data::Validate,
      &internal::NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkServiceTest::kReplaceSystemDnsConfig),
     { &internal::NetworkServiceTest_ReplaceSystemDnsConfig_Params_Data::Validate,
      &internal::NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkServiceTest::kSetTestDohConfig),
     { &internal::NetworkServiceTest_SetTestDohConfig_Params_Data::Validate,
      &internal::NetworkServiceTest_SetTestDohConfig_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkServiceTest::kCrashOnResolveHost),
     { &internal::NetworkServiceTest_CrashOnResolveHost_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkServiceTest::kCrashOnGetCookieList),
     { &internal::NetworkServiceTest_CrashOnGetCookieList_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkServiceTest::kGetLatestMemoryPressureLevel),
     { &internal::NetworkServiceTest_GetLatestMemoryPressureLevel_Params_Data::Validate,
      &internal::NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkServiceTest::kGetPeerToPeerConnectionsCountChange),
     { &internal::NetworkServiceTest_GetPeerToPeerConnectionsCountChange_Params_Data::Validate,
      &internal::NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkServiceTest::kGetEnvironmentVariableValue),
     { &internal::NetworkServiceTest_GetEnvironmentVariableValue_Params_Data::Validate,
      &internal::NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkServiceTest::kLog),
     { &internal::NetworkServiceTest_Log_Params_Data::Validate,
      &internal::NetworkServiceTest_Log_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkServiceTest::kActivateFieldTrial),
     { &internal::NetworkServiceTest_ActivateFieldTrial_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkServiceTest::kSetSCTAuditingRetryDelay),
     { &internal::NetworkServiceTest_SetSCTAuditingRetryDelay_Params_Data::Validate,
      &internal::NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkServiceTest::kOpenFile),
     { &internal::NetworkServiceTest_OpenFile_Params_Data::Validate,
      &internal::NetworkServiceTest_OpenFile_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkServiceTest::kEnumerateFiles),
     { &internal::NetworkServiceTest_EnumerateFiles_Params_Data::Validate,
      &internal::NetworkServiceTest_EnumerateFiles_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkServiceTest::kCreateSimpleCache),
     { &internal::NetworkServiceTest_CreateSimpleCache_Params_Data::Validate,
      &internal::NetworkServiceTest_CreateSimpleCache_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkServiceTest::kMakeRequestToServer),
     { &internal::NetworkServiceTest_MakeRequestToServer_Params_Data::Validate,
      &internal::NetworkServiceTest_MakeRequestToServer_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkServiceTest::kResolveOwnHostnameWithSystemDns),
     { &internal::NetworkServiceTest_ResolveOwnHostnameWithSystemDns_Params_Data::Validate,
      &internal::NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkServiceTest::kSetIPv6ProbeResult),
     { &internal::NetworkServiceTest_SetIPv6ProbeResult_Params_Data::Validate,
      &internal::NetworkServiceTest_SetIPv6ProbeResult_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkServiceTest::kGetAddressMapCacheLinux),
     { &internal::NetworkServiceTest_GetAddressMapCacheLinux_Params_Data::Validate,
      &internal::NetworkServiceTest_GetAddressMapCacheLinux_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkServiceTest::kAllowsGSSAPILibraryLoad),
     { &internal::NetworkServiceTest_AllowsGSSAPILibraryLoad_Params_Data::Validate,
      &internal::NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkServiceTest::kIsHappyEyeballsV3Enabled),
     { &internal::NetworkServiceTest_IsHappyEyeballsV3Enabled_Params_Data::Validate,
      &internal::NetworkServiceTest_IsHappyEyeballsV3Enabled_ResponseParams_Data::Validate}},
};

bool NetworkServiceTestRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::network::mojom::NetworkServiceTest::Name_,
    kNetworkServiceTestValidationInfo);
}

bool NetworkServiceTestResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::network::mojom::NetworkServiceTest::Name_,
    kNetworkServiceTestValidationInfo);

}


}  // network::mojom


namespace mojo {


// static
bool StructTraits<::network::mojom::Rule::DataView, ::network::mojom::RulePtr>::Read(
    ::network::mojom::Rule::DataView input,
    ::network::mojom::RulePtr* output) {
  bool success = true;
  ::network::mojom::RulePtr result(::network::mojom::Rule::New());
  
      if (success && !input.ReadResolverType(&result->resolver_type))
        success = false;
      if (success && !input.ReadHostPattern(&result->host_pattern))
        success = false;
      if (success && !input.ReadReplacement(&result->replacement))
        success = false;
      if (success)
        result->host_resolver_flags = input.host_resolver_flags();
      if (success && !input.ReadDnsAliases(&result->dns_aliases))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::SimpleCacheOpenEntryResult::DataView, ::network::mojom::SimpleCacheOpenEntryResultPtr>::Read(
    ::network::mojom::SimpleCacheOpenEntryResult::DataView input,
    ::network::mojom::SimpleCacheOpenEntryResultPtr* output) {
  bool success = true;
  ::network::mojom::SimpleCacheOpenEntryResultPtr result(::network::mojom::SimpleCacheOpenEntryResult::New());
  
      if (success)
        result->error = input.error();
      if (success && !input.ReadKey(&result->key))
        success = false;
      if (success) {
        result->entry =
            input.TakeEntry<decltype(result->entry)>();
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom {


void SimpleCacheEntryInterceptorForTesting::WriteData(int32_t index, int32_t offset, const std::vector<uint8_t>& data, bool truncate, WriteDataCallback callback) {
  GetForwardingInterface()->WriteData(
    std::move(index)
    , 
    std::move(offset)
    , 
    std::move(data)
    , 
    std::move(truncate)
    , std::move(callback));
}
void SimpleCacheEntryInterceptorForTesting::ReadData(int32_t index, int32_t offset, uint32_t length, ReadDataCallback callback) {
  GetForwardingInterface()->ReadData(
    std::move(index)
    , 
    std::move(offset)
    , 
    std::move(length)
    , std::move(callback));
}
void SimpleCacheEntryInterceptorForTesting::WriteSparseData(int32_t offset, const std::vector<uint8_t>& data, WriteSparseDataCallback callback) {
  GetForwardingInterface()->WriteSparseData(
    std::move(offset)
    , 
    std::move(data)
    , std::move(callback));
}
void SimpleCacheEntryInterceptorForTesting::ReadSparseData(int32_t offset, uint32_t length, ReadSparseDataCallback callback) {
  GetForwardingInterface()->ReadSparseData(
    std::move(offset)
    , 
    std::move(length)
    , std::move(callback));
}
void SimpleCacheEntryInterceptorForTesting::Close(CloseCallback callback) {
  GetForwardingInterface()->Close(std::move(callback));
}
SimpleCacheEntryAsyncWaiter::SimpleCacheEntryAsyncWaiter(
    SimpleCacheEntry* proxy) : proxy_(proxy) {}

SimpleCacheEntryAsyncWaiter::~SimpleCacheEntryAsyncWaiter() = default;


void SimpleCacheEntryAsyncWaiter::WriteData(
    int32_t index, int32_t offset, const std::vector<uint8_t>& data, bool truncate, int32_t* out_result) {
  base::RunLoop loop;
  proxy_->WriteData(
      std::move(index),
      std::move(offset),
      std::move(data),
      std::move(truncate),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_result
,
             int32_t result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

int32_t SimpleCacheEntryAsyncWaiter::WriteData(
    int32_t index, int32_t offset, const std::vector<uint8_t>& data, bool truncate) {
  int32_t async_wait_result;
  WriteData(std::move(index),std::move(offset),std::move(data),std::move(truncate),&async_wait_result);
  return async_wait_result;
}

void SimpleCacheEntryAsyncWaiter::ReadData(
    int32_t index, int32_t offset, uint32_t length, std::vector<uint8_t>* out_data, int32_t* out_result) {
  base::RunLoop loop;
  proxy_->ReadData(
      std::move(index),
      std::move(offset),
      std::move(length),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<uint8_t>* out_data
,
             int32_t* out_result
,
             const std::vector<uint8_t>& data,
             int32_t result) {*out_data = std::move(data);*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_data,
          out_result));
  loop.Run();
}



void SimpleCacheEntryAsyncWaiter::WriteSparseData(
    int32_t offset, const std::vector<uint8_t>& data, int32_t* out_result) {
  base::RunLoop loop;
  proxy_->WriteSparseData(
      std::move(offset),
      std::move(data),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_result
,
             int32_t result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

int32_t SimpleCacheEntryAsyncWaiter::WriteSparseData(
    int32_t offset, const std::vector<uint8_t>& data) {
  int32_t async_wait_result;
  WriteSparseData(std::move(offset),std::move(data),&async_wait_result);
  return async_wait_result;
}

void SimpleCacheEntryAsyncWaiter::ReadSparseData(
    int32_t offset, uint32_t length, std::vector<uint8_t>* out_data, int32_t* out_result) {
  base::RunLoop loop;
  proxy_->ReadSparseData(
      std::move(offset),
      std::move(length),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<uint8_t>* out_data
,
             int32_t* out_result
,
             const std::vector<uint8_t>& data,
             int32_t result) {*out_data = std::move(data);*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_data,
          out_result));
  loop.Run();
}



void SimpleCacheEntryAsyncWaiter::Close(
    ) {
  base::RunLoop loop;
  proxy_->Close(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}






void SimpleCacheEntryEnumeratorInterceptorForTesting::GetNext(GetNextCallback callback) {
  GetForwardingInterface()->GetNext(std::move(callback));
}
SimpleCacheEntryEnumeratorAsyncWaiter::SimpleCacheEntryEnumeratorAsyncWaiter(
    SimpleCacheEntryEnumerator* proxy) : proxy_(proxy) {}

SimpleCacheEntryEnumeratorAsyncWaiter::~SimpleCacheEntryEnumeratorAsyncWaiter() = default;


void SimpleCacheEntryEnumeratorAsyncWaiter::GetNext(
    SimpleCacheOpenEntryResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->GetNext(
      base::BindOnce(
          [](base::RunLoop* loop,
             SimpleCacheOpenEntryResultPtr* out_result
,
             SimpleCacheOpenEntryResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

SimpleCacheOpenEntryResultPtr SimpleCacheEntryEnumeratorAsyncWaiter::GetNext(
    ) {
  SimpleCacheOpenEntryResultPtr async_wait_result;
  GetNext(&async_wait_result);
  return async_wait_result;
}




void SimpleCacheInterceptorForTesting::CreateEntry(const std::string& key, CreateEntryCallback callback) {
  GetForwardingInterface()->CreateEntry(
    std::move(key)
    , std::move(callback));
}
void SimpleCacheInterceptorForTesting::OpenEntry(const std::string& key, OpenEntryCallback callback) {
  GetForwardingInterface()->OpenEntry(
    std::move(key)
    , std::move(callback));
}
void SimpleCacheInterceptorForTesting::DoomEntry(const std::string& key, DoomEntryCallback callback) {
  GetForwardingInterface()->DoomEntry(
    std::move(key)
    , std::move(callback));
}
void SimpleCacheInterceptorForTesting::DoomAllEntries(DoomAllEntriesCallback callback) {
  GetForwardingInterface()->DoomAllEntries(std::move(callback));
}
void SimpleCacheInterceptorForTesting::EnumerateEntries(::mojo::PendingReceiver<SimpleCacheEntryEnumerator> receiver) {
  GetForwardingInterface()->EnumerateEntries(
    std::move(receiver)
    );
}
void SimpleCacheInterceptorForTesting::Detach(DetachCallback callback) {
  GetForwardingInterface()->Detach(std::move(callback));
}
SimpleCacheAsyncWaiter::SimpleCacheAsyncWaiter(
    SimpleCache* proxy) : proxy_(proxy) {}

SimpleCacheAsyncWaiter::~SimpleCacheAsyncWaiter() = default;


void SimpleCacheAsyncWaiter::CreateEntry(
    const std::string& key, ::mojo::PendingRemote<SimpleCacheEntry>* out_entry, int32_t* out_error) {
  base::RunLoop loop;
  proxy_->CreateEntry(
      std::move(key),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::PendingRemote<SimpleCacheEntry>* out_entry
,
             int32_t* out_error
,
             ::mojo::PendingRemote<SimpleCacheEntry> entry,
             int32_t error) {*out_entry = std::move(entry);*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_entry,
          out_error));
  loop.Run();
}



void SimpleCacheAsyncWaiter::OpenEntry(
    const std::string& key, ::mojo::PendingRemote<SimpleCacheEntry>* out_entry, int32_t* out_error) {
  base::RunLoop loop;
  proxy_->OpenEntry(
      std::move(key),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::PendingRemote<SimpleCacheEntry>* out_entry
,
             int32_t* out_error
,
             ::mojo::PendingRemote<SimpleCacheEntry> entry,
             int32_t error) {*out_entry = std::move(entry);*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_entry,
          out_error));
  loop.Run();
}



void SimpleCacheAsyncWaiter::DoomEntry(
    const std::string& key, int32_t* out_result) {
  base::RunLoop loop;
  proxy_->DoomEntry(
      std::move(key),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_result
,
             int32_t result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

int32_t SimpleCacheAsyncWaiter::DoomEntry(
    const std::string& key) {
  int32_t async_wait_result;
  DoomEntry(std::move(key),&async_wait_result);
  return async_wait_result;
}

void SimpleCacheAsyncWaiter::DoomAllEntries(
    int32_t* out_result) {
  base::RunLoop loop;
  proxy_->DoomAllEntries(
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_result
,
             int32_t result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

int32_t SimpleCacheAsyncWaiter::DoomAllEntries(
    ) {
  int32_t async_wait_result;
  DoomAllEntries(&async_wait_result);
  return async_wait_result;
}

void SimpleCacheAsyncWaiter::Detach(
    ) {
  base::RunLoop loop;
  proxy_->Detach(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}






void NetworkServiceTestInterceptorForTesting::AddRules(std::vector<RulePtr> rules, AddRulesCallback callback) {
  GetForwardingInterface()->AddRules(
    std::move(rules)
    , std::move(callback));
}
void NetworkServiceTestInterceptorForTesting::SimulateNetworkChange(::network::mojom::ConnectionType type, SimulateNetworkChangeCallback callback) {
  GetForwardingInterface()->SimulateNetworkChange(
    std::move(type)
    , std::move(callback));
}
void NetworkServiceTestInterceptorForTesting::SimulateNetworkQualityChange(::net::EffectiveConnectionType type, SimulateNetworkQualityChangeCallback callback) {
  GetForwardingInterface()->SimulateNetworkQualityChange(
    std::move(type)
    , std::move(callback));
}
void NetworkServiceTestInterceptorForTesting::ForceNetworkQualityEstimatorReportWifiAsSlow2G(ForceNetworkQualityEstimatorReportWifiAsSlow2GCallback callback) {
  GetForwardingInterface()->ForceNetworkQualityEstimatorReportWifiAsSlow2G(std::move(callback));
}
void NetworkServiceTestInterceptorForTesting::SimulateCrash() {
  GetForwardingInterface()->SimulateCrash();
}
void NetworkServiceTestInterceptorForTesting::MockCertVerifierSetDefaultResult(int32_t default_result, MockCertVerifierSetDefaultResultCallback callback) {
  GetForwardingInterface()->MockCertVerifierSetDefaultResult(
    std::move(default_result)
    , std::move(callback));
}
void NetworkServiceTestInterceptorForTesting::MockCertVerifierAddResultForCertAndHost(const ::scoped_refptr<::net::X509Certificate>& cert, const std::string& host_pattern, const ::net::CertVerifyResult& verify_result, int32_t rv, MockCertVerifierAddResultForCertAndHostCallback callback) {
  GetForwardingInterface()->MockCertVerifierAddResultForCertAndHost(
    std::move(cert)
    , 
    std::move(host_pattern)
    , 
    std::move(verify_result)
    , 
    std::move(rv)
    , std::move(callback));
}
void NetworkServiceTestInterceptorForTesting::SetTransportSecurityStateSource(uint16_t reporting_port, SetTransportSecurityStateSourceCallback callback) {
  GetForwardingInterface()->SetTransportSecurityStateSource(
    std::move(reporting_port)
    , std::move(callback));
}
void NetworkServiceTestInterceptorForTesting::SetAllowNetworkAccessToHostResolutions(SetAllowNetworkAccessToHostResolutionsCallback callback) {
  GetForwardingInterface()->SetAllowNetworkAccessToHostResolutions(std::move(callback));
}
void NetworkServiceTestInterceptorForTesting::ReplaceSystemDnsConfig(ReplaceSystemDnsConfigCallback callback) {
  GetForwardingInterface()->ReplaceSystemDnsConfig(std::move(callback));
}
void NetworkServiceTestInterceptorForTesting::SetTestDohConfig(::net::SecureDnsMode secure_dns_mode, const ::net::DnsOverHttpsConfig& doh_config, SetTestDohConfigCallback callback) {
  GetForwardingInterface()->SetTestDohConfig(
    std::move(secure_dns_mode)
    , 
    std::move(doh_config)
    , std::move(callback));
}
void NetworkServiceTestInterceptorForTesting::CrashOnResolveHost(const std::string& host) {
  GetForwardingInterface()->CrashOnResolveHost(
    std::move(host)
    );
}
void NetworkServiceTestInterceptorForTesting::CrashOnGetCookieList() {
  GetForwardingInterface()->CrashOnGetCookieList();
}
void NetworkServiceTestInterceptorForTesting::GetLatestMemoryPressureLevel(GetLatestMemoryPressureLevelCallback callback) {
  GetForwardingInterface()->GetLatestMemoryPressureLevel(std::move(callback));
}
void NetworkServiceTestInterceptorForTesting::GetPeerToPeerConnectionsCountChange(GetPeerToPeerConnectionsCountChangeCallback callback) {
  GetForwardingInterface()->GetPeerToPeerConnectionsCountChange(std::move(callback));
}
void NetworkServiceTestInterceptorForTesting::GetEnvironmentVariableValue(const std::string& name, GetEnvironmentVariableValueCallback callback) {
  GetForwardingInterface()->GetEnvironmentVariableValue(
    std::move(name)
    , std::move(callback));
}
void NetworkServiceTestInterceptorForTesting::Log(const std::string& message, LogCallback callback) {
  GetForwardingInterface()->Log(
    std::move(message)
    , std::move(callback));
}
void NetworkServiceTestInterceptorForTesting::ActivateFieldTrial(const std::string& field_trial_name) {
  GetForwardingInterface()->ActivateFieldTrial(
    std::move(field_trial_name)
    );
}
void NetworkServiceTestInterceptorForTesting::SetSCTAuditingRetryDelay(std::optional<::base::TimeDelta> delay, SetSCTAuditingRetryDelayCallback callback) {
  GetForwardingInterface()->SetSCTAuditingRetryDelay(
    std::move(delay)
    , std::move(callback));
}
void NetworkServiceTestInterceptorForTesting::OpenFile(const ::base::FilePath& path, OpenFileCallback callback) {
  GetForwardingInterface()->OpenFile(
    std::move(path)
    , std::move(callback));
}
void NetworkServiceTestInterceptorForTesting::EnumerateFiles(const ::base::FilePath& path, ::mojo::PendingRemote<::network::mojom::HttpCacheBackendFileOperationsFactory> factory, EnumerateFilesCallback callback) {
  GetForwardingInterface()->EnumerateFiles(
    std::move(path)
    , 
    std::move(factory)
    , std::move(callback));
}
void NetworkServiceTestInterceptorForTesting::CreateSimpleCache(::mojo::PendingRemote<::network::mojom::HttpCacheBackendFileOperationsFactory> factory, const ::base::FilePath& path, bool reset, CreateSimpleCacheCallback callback) {
  GetForwardingInterface()->CreateSimpleCache(
    std::move(factory)
    , 
    std::move(path)
    , 
    std::move(reset)
    , std::move(callback));
}
void NetworkServiceTestInterceptorForTesting::MakeRequestToServer(::network::TransferableSocket s, const ::net::IPEndPoint& endpoint, MakeRequestToServerCallback callback) {
  GetForwardingInterface()->MakeRequestToServer(
    std::move(s)
    , 
    std::move(endpoint)
    , std::move(callback));
}
void NetworkServiceTestInterceptorForTesting::ResolveOwnHostnameWithSystemDns(ResolveOwnHostnameWithSystemDnsCallback callback) {
  GetForwardingInterface()->ResolveOwnHostnameWithSystemDns(std::move(callback));
}
void NetworkServiceTestInterceptorForTesting::SetIPv6ProbeResult(bool success, SetIPv6ProbeResultCallback callback) {
  GetForwardingInterface()->SetIPv6ProbeResult(
    std::move(success)
    , std::move(callback));
}
void NetworkServiceTestInterceptorForTesting::GetAddressMapCacheLinux(GetAddressMapCacheLinuxCallback callback) {
  GetForwardingInterface()->GetAddressMapCacheLinux(std::move(callback));
}
void NetworkServiceTestInterceptorForTesting::AllowsGSSAPILibraryLoad(AllowsGSSAPILibraryLoadCallback callback) {
  GetForwardingInterface()->AllowsGSSAPILibraryLoad(std::move(callback));
}
void NetworkServiceTestInterceptorForTesting::IsHappyEyeballsV3Enabled(IsHappyEyeballsV3EnabledCallback callback) {
  GetForwardingInterface()->IsHappyEyeballsV3Enabled(std::move(callback));
}
NetworkServiceTestAsyncWaiter::NetworkServiceTestAsyncWaiter(
    NetworkServiceTest* proxy) : proxy_(proxy) {}

NetworkServiceTestAsyncWaiter::~NetworkServiceTestAsyncWaiter() = default;


void NetworkServiceTestAsyncWaiter::AddRules(
    std::vector<RulePtr> rules) {
  base::RunLoop loop;
  proxy_->AddRules(
      std::move(rules),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void NetworkServiceTestAsyncWaiter::SimulateNetworkChange(
    ::network::mojom::ConnectionType type) {
  base::RunLoop loop;
  proxy_->SimulateNetworkChange(
      std::move(type),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void NetworkServiceTestAsyncWaiter::SimulateNetworkQualityChange(
    ::net::EffectiveConnectionType type) {
  base::RunLoop loop;
  proxy_->SimulateNetworkQualityChange(
      std::move(type),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void NetworkServiceTestAsyncWaiter::ForceNetworkQualityEstimatorReportWifiAsSlow2G(
    ) {
  base::RunLoop loop;
  proxy_->ForceNetworkQualityEstimatorReportWifiAsSlow2G(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void NetworkServiceTestAsyncWaiter::MockCertVerifierSetDefaultResult(
    int32_t default_result) {
  base::RunLoop loop;
  proxy_->MockCertVerifierSetDefaultResult(
      std::move(default_result),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void NetworkServiceTestAsyncWaiter::MockCertVerifierAddResultForCertAndHost(
    const ::scoped_refptr<::net::X509Certificate>& cert, const std::string& host_pattern, const ::net::CertVerifyResult& verify_result, int32_t rv) {
  base::RunLoop loop;
  proxy_->MockCertVerifierAddResultForCertAndHost(
      std::move(cert),
      std::move(host_pattern),
      std::move(verify_result),
      std::move(rv),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void NetworkServiceTestAsyncWaiter::SetTransportSecurityStateSource(
    uint16_t reporting_port) {
  base::RunLoop loop;
  proxy_->SetTransportSecurityStateSource(
      std::move(reporting_port),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void NetworkServiceTestAsyncWaiter::SetAllowNetworkAccessToHostResolutions(
    ) {
  base::RunLoop loop;
  proxy_->SetAllowNetworkAccessToHostResolutions(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void NetworkServiceTestAsyncWaiter::ReplaceSystemDnsConfig(
    ) {
  base::RunLoop loop;
  proxy_->ReplaceSystemDnsConfig(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void NetworkServiceTestAsyncWaiter::SetTestDohConfig(
    ::net::SecureDnsMode secure_dns_mode, const ::net::DnsOverHttpsConfig& doh_config) {
  base::RunLoop loop;
  proxy_->SetTestDohConfig(
      std::move(secure_dns_mode),
      std::move(doh_config),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void NetworkServiceTestAsyncWaiter::GetLatestMemoryPressureLevel(
    ::base::MemoryPressureListener::MemoryPressureLevel* out_memory_pressure_level) {
  base::RunLoop loop;
  proxy_->GetLatestMemoryPressureLevel(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::MemoryPressureListener::MemoryPressureLevel* out_memory_pressure_level
,
             ::base::MemoryPressureListener::MemoryPressureLevel memory_pressure_level) {*out_memory_pressure_level = std::move(memory_pressure_level);
            loop->Quit();
          },
          &loop,
          out_memory_pressure_level));
  loop.Run();
}

::base::MemoryPressureListener::MemoryPressureLevel NetworkServiceTestAsyncWaiter::GetLatestMemoryPressureLevel(
    ) {
  ::base::MemoryPressureListener::MemoryPressureLevel async_wait_result;
  GetLatestMemoryPressureLevel(&async_wait_result);
  return async_wait_result;
}

void NetworkServiceTestAsyncWaiter::GetPeerToPeerConnectionsCountChange(
    uint32_t* out_connection_count) {
  base::RunLoop loop;
  proxy_->GetPeerToPeerConnectionsCountChange(
      base::BindOnce(
          [](base::RunLoop* loop,
             uint32_t* out_connection_count
,
             uint32_t connection_count) {*out_connection_count = std::move(connection_count);
            loop->Quit();
          },
          &loop,
          out_connection_count));
  loop.Run();
}

uint32_t NetworkServiceTestAsyncWaiter::GetPeerToPeerConnectionsCountChange(
    ) {
  uint32_t async_wait_result;
  GetPeerToPeerConnectionsCountChange(&async_wait_result);
  return async_wait_result;
}

void NetworkServiceTestAsyncWaiter::GetEnvironmentVariableValue(
    const std::string& name, std::string* out_value) {
  base::RunLoop loop;
  proxy_->GetEnvironmentVariableValue(
      std::move(name),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::string* out_value
,
             const std::string& value) {*out_value = std::move(value);
            loop->Quit();
          },
          &loop,
          out_value));
  loop.Run();
}

std::string NetworkServiceTestAsyncWaiter::GetEnvironmentVariableValue(
    const std::string& name) {
  std::string async_wait_result;
  GetEnvironmentVariableValue(std::move(name),&async_wait_result);
  return async_wait_result;
}

void NetworkServiceTestAsyncWaiter::Log(
    const std::string& message) {
  base::RunLoop loop;
  proxy_->Log(
      std::move(message),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void NetworkServiceTestAsyncWaiter::SetSCTAuditingRetryDelay(
    std::optional<::base::TimeDelta> delay) {
  base::RunLoop loop;
  proxy_->SetSCTAuditingRetryDelay(
      std::move(delay),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void NetworkServiceTestAsyncWaiter::OpenFile(
    const ::base::FilePath& path, bool* out_result) {
  base::RunLoop loop;
  proxy_->OpenFile(
      std::move(path),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_result
,
             bool result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

bool NetworkServiceTestAsyncWaiter::OpenFile(
    const ::base::FilePath& path) {
  bool async_wait_result;
  OpenFile(std::move(path),&async_wait_result);
  return async_wait_result;
}

void NetworkServiceTestAsyncWaiter::EnumerateFiles(
    const ::base::FilePath& path, ::mojo::PendingRemote<::network::mojom::HttpCacheBackendFileOperationsFactory> factory, std::vector<::disk_cache::BackendFileOperations::FileEnumerationEntry>* out_entries, bool* out_error) {
  base::RunLoop loop;
  proxy_->EnumerateFiles(
      std::move(path),
      std::move(factory),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::disk_cache::BackendFileOperations::FileEnumerationEntry>* out_entries
,
             bool* out_error
,
             const std::vector<::disk_cache::BackendFileOperations::FileEnumerationEntry>& entries,
             bool error) {*out_entries = std::move(entries);*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_entries,
          out_error));
  loop.Run();
}



void NetworkServiceTestAsyncWaiter::CreateSimpleCache(
    ::mojo::PendingRemote<::network::mojom::HttpCacheBackendFileOperationsFactory> factory, const ::base::FilePath& path, bool reset, ::mojo::PendingRemote<SimpleCache>* out_backend) {
  base::RunLoop loop;
  proxy_->CreateSimpleCache(
      std::move(factory),
      std::move(path),
      std::move(reset),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::PendingRemote<SimpleCache>* out_backend
,
             ::mojo::PendingRemote<SimpleCache> backend) {*out_backend = std::move(backend);
            loop->Quit();
          },
          &loop,
          out_backend));
  loop.Run();
}

::mojo::PendingRemote<SimpleCache> NetworkServiceTestAsyncWaiter::CreateSimpleCache(
    ::mojo::PendingRemote<::network::mojom::HttpCacheBackendFileOperationsFactory> factory, const ::base::FilePath& path, bool reset) {
  ::mojo::PendingRemote<SimpleCache> async_wait_result;
  CreateSimpleCache(std::move(factory),std::move(path),std::move(reset),&async_wait_result);
  return async_wait_result;
}

void NetworkServiceTestAsyncWaiter::MakeRequestToServer(
    ::network::TransferableSocket s, const ::net::IPEndPoint& endpoint, bool* out_result) {
  base::RunLoop loop;
  proxy_->MakeRequestToServer(
      std::move(s),
      std::move(endpoint),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_result
,
             bool result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

bool NetworkServiceTestAsyncWaiter::MakeRequestToServer(
    ::network::TransferableSocket s, const ::net::IPEndPoint& endpoint) {
  bool async_wait_result;
  MakeRequestToServer(std::move(s),std::move(endpoint),&async_wait_result);
  return async_wait_result;
}

void NetworkServiceTestAsyncWaiter::ResolveOwnHostnameWithSystemDns(
    ::net::AddressList* out_addr_list, int32_t* out_os_error, int32_t* out_net_error) {
  base::RunLoop loop;
  proxy_->ResolveOwnHostnameWithSystemDns(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::net::AddressList* out_addr_list
,
             int32_t* out_os_error
,
             int32_t* out_net_error
,
             const ::net::AddressList& addr_list,
             int32_t os_error,
             int32_t net_error) {*out_addr_list = std::move(addr_list);*out_os_error = std::move(os_error);*out_net_error = std::move(net_error);
            loop->Quit();
          },
          &loop,
          out_addr_list,
          out_os_error,
          out_net_error));
  loop.Run();
}



void NetworkServiceTestAsyncWaiter::SetIPv6ProbeResult(
    bool success) {
  base::RunLoop loop;
  proxy_->SetIPv6ProbeResult(
      std::move(success),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void NetworkServiceTestAsyncWaiter::GetAddressMapCacheLinux(
    ::net::AddressMapOwnerLinux::AddressMap* out_addr_map, ::std::unordered_set<int>* out_links) {
  base::RunLoop loop;
  proxy_->GetAddressMapCacheLinux(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::net::AddressMapOwnerLinux::AddressMap* out_addr_map
,
             ::std::unordered_set<int>* out_links
,
             const ::net::AddressMapOwnerLinux::AddressMap& addr_map,
             const ::std::unordered_set<int>& links) {*out_addr_map = std::move(addr_map);*out_links = std::move(links);
            loop->Quit();
          },
          &loop,
          out_addr_map,
          out_links));
  loop.Run();
}



void NetworkServiceTestAsyncWaiter::AllowsGSSAPILibraryLoad(
    bool* out_allow_gssapi_library_load) {
  base::RunLoop loop;
  proxy_->AllowsGSSAPILibraryLoad(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_allow_gssapi_library_load
,
             bool allow_gssapi_library_load) {*out_allow_gssapi_library_load = std::move(allow_gssapi_library_load);
            loop->Quit();
          },
          &loop,
          out_allow_gssapi_library_load));
  loop.Run();
}

bool NetworkServiceTestAsyncWaiter::AllowsGSSAPILibraryLoad(
    ) {
  bool async_wait_result;
  AllowsGSSAPILibraryLoad(&async_wait_result);
  return async_wait_result;
}

void NetworkServiceTestAsyncWaiter::IsHappyEyeballsV3Enabled(
    bool* out_is_happy_eyeballs_v3_enabled) {
  base::RunLoop loop;
  proxy_->IsHappyEyeballsV3Enabled(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_is_happy_eyeballs_v3_enabled
,
             bool is_happy_eyeballs_v3_enabled) {*out_is_happy_eyeballs_v3_enabled = std::move(is_happy_eyeballs_v3_enabled);
            loop->Quit();
          },
          &loop,
          out_is_happy_eyeballs_v3_enabled));
  loop.Run();
}

bool NetworkServiceTestAsyncWaiter::IsHappyEyeballsV3Enabled(
    ) {
  bool async_wait_result;
  IsHappyEyeballsV3Enabled(&async_wait_result);
  return async_wait_result;
}






}  // network::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif