// services/network/public/mojom/socket_broker.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_SOCKET_BROKER_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_SOCKET_BROKER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/socket_broker.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/socket_broker.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/socket_broker.mojom-blink-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/address_family.mojom-blink.h"
#include "services/network/public/mojom/transferable_socket.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace network::mojom::blink {

class SocketBrokerProxy;

template <typename ImplRefTraits>
class SocketBrokerStub;

class SocketBrokerRequestValidator;
class SocketBrokerResponseValidator;


class BLINK_PLATFORM_EXPORT SocketBroker
    : public SocketBrokerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.SocketBroker";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SocketBrokerInterfaceBase;
  using Proxy_ = SocketBrokerProxy;

  template <typename ImplRefTraits>
  using Stub_ = SocketBrokerStub<ImplRefTraits>;

  using RequestValidator_ = SocketBrokerRequestValidator;
  using ResponseValidator_ = SocketBrokerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateTcpSocketMinVersion = 0,
    kCreateUdpSocketMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateTcpSocket_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateUdpSocket_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SocketBroker() = default;

  using CreateTcpSocketCallback = base::OnceCallback<void(::network::mojom::blink::TransferableSocketPtr, int32_t)>;
  using CreateTcpSocketMojoCallback = base::OnceCallback<void(::network::mojom::blink::TransferableSocketPtr, int32_t)>;

  virtual void CreateTcpSocket(::net::AddressFamily address_family, CreateTcpSocketCallback callback) = 0;

  using CreateUdpSocketCallback = base::OnceCallback<void(::network::mojom::blink::TransferableSocketPtr, int32_t)>;
  using CreateUdpSocketMojoCallback = base::OnceCallback<void(::network::mojom::blink::TransferableSocketPtr, int32_t)>;

  virtual void CreateUdpSocket(::net::AddressFamily address_family, CreateUdpSocketCallback callback) = 0;
};



class BLINK_PLATFORM_EXPORT SocketBrokerProxy
    : public SocketBroker {
 public:
  using InterfaceType = SocketBroker;

  explicit SocketBrokerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateTcpSocket(::net::AddressFamily address_family, CreateTcpSocketCallback callback) final;
  
  void CreateUdpSocket(::net::AddressFamily address_family, CreateUdpSocketCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT SocketBrokerStubDispatch {
 public:
  static bool Accept(SocketBroker* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SocketBroker* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SocketBroker>>
class SocketBrokerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SocketBrokerStub() = default;
  ~SocketBrokerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SocketBrokerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SocketBrokerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT SocketBrokerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT SocketBrokerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // network::mojom::blink

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_SOCKET_BROKER_MOJOM_BLINK_H_