// services/network/public/mojom/ssl_config.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/ssl_config.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/ssl_config.mojom-params-data.h"
#include "services/network/public/mojom/ssl_config.mojom-shared-message-ids.h"

#include "services/network/public/mojom/ssl_config.mojom-import-headers.h"
#include "services/network/public/mojom/ssl_config.mojom-test-utils.h"


namespace network::mojom {
SSLConfig::SSLConfig()
    : rev_checking_enabled(false),
      rev_checking_required_local_anchors(false),
      sha1_local_anchors_enabled(false),
      version_min(SSLVersion::kTLS12),
      version_max(SSLVersion::kTLS13),
      disabled_cipher_suites(),
      client_cert_pooling_policy(),
      post_quantum_key_agreement_enabled(true),
      ech_enabled(true),
      trust_anchor_ids() {}

SSLConfig::SSLConfig(
    bool rev_checking_enabled_in,
    bool rev_checking_required_local_anchors_in,
    bool sha1_local_anchors_enabled_in,
    SSLVersion version_min_in,
    SSLVersion version_max_in,
    std::vector<uint16_t> disabled_cipher_suites_in,
    std::vector<std::string> client_cert_pooling_policy_in,
    bool post_quantum_key_agreement_enabled_in,
    bool ech_enabled_in,
    std::vector<std::vector<uint8_t>> trust_anchor_ids_in)
    : rev_checking_enabled(std::move(rev_checking_enabled_in)),
      rev_checking_required_local_anchors(std::move(rev_checking_required_local_anchors_in)),
      sha1_local_anchors_enabled(std::move(sha1_local_anchors_enabled_in)),
      version_min(std::move(version_min_in)),
      version_max(std::move(version_max_in)),
      disabled_cipher_suites(std::move(disabled_cipher_suites_in)),
      client_cert_pooling_policy(std::move(client_cert_pooling_policy_in)),
      post_quantum_key_agreement_enabled(std::move(post_quantum_key_agreement_enabled_in)),
      ech_enabled(std::move(ech_enabled_in)),
      trust_anchor_ids(std::move(trust_anchor_ids_in)) {}

SSLConfig::~SSLConfig() = default;

void SSLConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rev_checking_enabled"), this->rev_checking_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rev_checking_required_local_anchors"), this->rev_checking_required_local_anchors,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sha1_local_anchors_enabled"), this->sha1_local_anchors_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version_min"), this->version_min,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SSLVersion>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version_max"), this->version_max,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SSLVersion>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disabled_cipher_suites"), this->disabled_cipher_suites,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint16_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client_cert_pooling_policy"), this->client_cert_pooling_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "post_quantum_key_agreement_enabled"), this->post_quantum_key_agreement_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ech_enabled"), this->ech_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trust_anchor_ids"), this->trust_anchor_ids,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SSLConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

SSLConfigClient::IPCStableHashFunction SSLConfigClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SSLConfigClient>(message.name())) {
    case messages::SSLConfigClient::kOnSSLConfigUpdated: {
      return &SSLConfigClient::OnSSLConfigUpdated_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SSLConfigClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SSLConfigClient>(message.name())) {
      case messages::SSLConfigClient::kOnSSLConfigUpdated:
            return "Receive network::mojom::SSLConfigClient::OnSSLConfigUpdated";
    }
  } else {
    switch (static_cast<messages::SSLConfigClient>(message.name())) {
      case messages::SSLConfigClient::kOnSSLConfigUpdated:
            return "Receive reply network::mojom::SSLConfigClient::OnSSLConfigUpdated";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SSLConfigClient::OnSSLConfigUpdated_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x704ad004;  // IPCStableHash for network::mojom::SSLConfigClient::OnSSLConfigUpdated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SSLConfigClientProxy::SSLConfigClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SSLConfigClientProxy::OnSSLConfigUpdated(
    SSLConfigPtr in_ssl_config) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::SSLConfigClient::OnSSLConfigUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ssl_config"), in_ssl_config,
                        "<value of type SSLConfigPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SSLConfigClient::kOnSSLConfigUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::SSLConfigClient_OnSSLConfigUpdated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->ssl_config)::BaseType> ssl_config_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::SSLConfigDataView>(
    in_ssl_config,
    ssl_config_fragment);

  params->ssl_config.Set(
      ssl_config_fragment.is_null() ? nullptr : ssl_config_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->ssl_config.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null ssl_config in SSLConfigClient.OnSSLConfigUpdated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SSLConfigClient::Name_);
  message.set_method_name("OnSSLConfigUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SSLConfigClientStubDispatch::Accept(
    SSLConfigClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SSLConfigClient>(message->header()->name)) {
    case messages::SSLConfigClient::kOnSSLConfigUpdated: {
      DCHECK(message->is_serialized());
      internal::SSLConfigClient_OnSSLConfigUpdated_Params_Data* params =
          reinterpret_cast<internal::SSLConfigClient_OnSSLConfigUpdated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SSLConfigClient.0
      bool success = true;
      SSLConfigPtr p_ssl_config{};
      SSLConfigClient_OnSSLConfigUpdated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSslConfig(&p_ssl_config))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SSLConfigClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSSLConfigUpdated(        
        std::move(p_ssl_config));
      return true;
    }
  }
  return false;
}

// static
bool SSLConfigClientStubDispatch::AcceptWithResponder(
    SSLConfigClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SSLConfigClient>(message->header()->name)) {
    case messages::SSLConfigClient::kOnSSLConfigUpdated: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSSLConfigClientValidationInfo[] = {
    {base::to_underlying(messages::SSLConfigClient::kOnSSLConfigUpdated),
     { &internal::SSLConfigClient_OnSSLConfigUpdated_Params_Data::Validate,
      nullptr /* no response */}},
};

bool SSLConfigClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::network::mojom::SSLConfigClient::Name_,
    kSSLConfigClientValidationInfo);
}



}  // network::mojom


namespace mojo {


// static
bool StructTraits<::network::mojom::SSLConfig::DataView, ::network::mojom::SSLConfigPtr>::Read(
    ::network::mojom::SSLConfig::DataView input,
    ::network::mojom::SSLConfigPtr* output) {
  bool success = true;
  ::network::mojom::SSLConfigPtr result(::network::mojom::SSLConfig::New());
  
      if (success)
        result->rev_checking_enabled = input.rev_checking_enabled();
      if (success)
        result->rev_checking_required_local_anchors = input.rev_checking_required_local_anchors();
      if (success)
        result->sha1_local_anchors_enabled = input.sha1_local_anchors_enabled();
      if (success && !input.ReadVersionMin(&result->version_min))
        success = false;
      if (success && !input.ReadVersionMax(&result->version_max))
        success = false;
      if (success && !input.ReadDisabledCipherSuites(&result->disabled_cipher_suites))
        success = false;
      if (success && !input.ReadClientCertPoolingPolicy(&result->client_cert_pooling_policy))
        success = false;
      if (success)
        result->post_quantum_key_agreement_enabled = input.post_quantum_key_agreement_enabled();
      if (success)
        result->ech_enabled = input.ech_enabled();
      if (success && !input.ReadTrustAnchorIds(&result->trust_anchor_ids))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom {


void SSLConfigClientInterceptorForTesting::OnSSLConfigUpdated(SSLConfigPtr ssl_config) {
  GetForwardingInterface()->OnSSLConfigUpdated(
    std::move(ssl_config)
    );
}
SSLConfigClientAsyncWaiter::SSLConfigClientAsyncWaiter(
    SSLConfigClient* proxy) : proxy_(proxy) {}

SSLConfigClientAsyncWaiter::~SSLConfigClientAsyncWaiter() = default;







}  // network::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif