// services/network/public/mojom/web_transport.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/web_transport.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/web_transport.mojom-params-data.h"
#include "services/network/public/mojom/web_transport.mojom-shared-message-ids.h"

#include "services/network/public/mojom/web_transport.mojom-blink-import-headers.h"
#include "services/network/public/mojom/web_transport.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace network::mojom::blink {
WebTransportError::WebTransportError()
    : net_error(0),
      quic_error(0),
      details(),
      safe_to_report_details(false) {}

WebTransportError::WebTransportError(
    int32_t net_error_in,
    int32_t quic_error_in,
    const ::blink::String& details_in,
    bool safe_to_report_details_in)
    : net_error(std::move(net_error_in)),
      quic_error(std::move(quic_error_in)),
      details(std::move(details_in)),
      safe_to_report_details(std::move(safe_to_report_details_in)) {}

WebTransportError::~WebTransportError() = default;
size_t WebTransportError::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->net_error);
  seed = mojo::internal::WTFHash(seed, this->quic_error);
  seed = mojo::internal::WTFHash(seed, this->details);
  seed = mojo::internal::WTFHash(seed, this->safe_to_report_details);
  return seed;
}

void WebTransportError::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "net_error"), this->net_error,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "quic_error"), this->quic_error,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "details"), this->details,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "safe_to_report_details"), this->safe_to_report_details,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebTransportError::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebTransportCertificateFingerprint::WebTransportCertificateFingerprint()
    : algorithm(),
      fingerprint() {}

WebTransportCertificateFingerprint::WebTransportCertificateFingerprint(
    const ::blink::String& algorithm_in,
    const ::blink::String& fingerprint_in)
    : algorithm(std::move(algorithm_in)),
      fingerprint(std::move(fingerprint_in)) {}

WebTransportCertificateFingerprint::~WebTransportCertificateFingerprint() = default;
size_t WebTransportCertificateFingerprint::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->algorithm);
  seed = mojo::internal::WTFHash(seed, this->fingerprint);
  return seed;
}

void WebTransportCertificateFingerprint::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "algorithm"), this->algorithm,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fingerprint"), this->fingerprint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebTransportCertificateFingerprint::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebTransportCloseInfo::WebTransportCloseInfo()
    : code(),
      reason() {}

WebTransportCloseInfo::WebTransportCloseInfo(
    uint32_t code_in,
    const ::blink::String& reason_in)
    : code(std::move(code_in)),
      reason(std::move(reason_in)) {}

WebTransportCloseInfo::~WebTransportCloseInfo() = default;
size_t WebTransportCloseInfo::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->code);
  seed = mojo::internal::WTFHash(seed, this->reason);
  return seed;
}

void WebTransportCloseInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "code"), this->code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reason"), this->reason,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebTransportCloseInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebTransportStats::WebTransportStats()
    : timestamp(),
      min_rtt(),
      smoothed_rtt(),
      rtt_variation(),
      estimated_send_rate_bps(),
      datagrams_expired_outgoing(),
      datagrams_lost_outgoing() {}

WebTransportStats::WebTransportStats(
    ::base::Time timestamp_in,
    ::base::TimeDelta min_rtt_in,
    ::base::TimeDelta smoothed_rtt_in,
    ::base::TimeDelta rtt_variation_in,
    uint64_t estimated_send_rate_bps_in,
    uint64_t datagrams_expired_outgoing_in,
    uint64_t datagrams_lost_outgoing_in)
    : timestamp(std::move(timestamp_in)),
      min_rtt(std::move(min_rtt_in)),
      smoothed_rtt(std::move(smoothed_rtt_in)),
      rtt_variation(std::move(rtt_variation_in)),
      estimated_send_rate_bps(std::move(estimated_send_rate_bps_in)),
      datagrams_expired_outgoing(std::move(datagrams_expired_outgoing_in)),
      datagrams_lost_outgoing(std::move(datagrams_lost_outgoing_in)) {}

WebTransportStats::~WebTransportStats() = default;

void WebTransportStats::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timestamp"), this->timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "min_rtt"), this->min_rtt,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "smoothed_rtt"), this->smoothed_rtt,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rtt_variation"), this->rtt_variation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "estimated_send_rate_bps"), this->estimated_send_rate_bps,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "datagrams_expired_outgoing"), this->datagrams_expired_outgoing,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "datagrams_lost_outgoing"), this->datagrams_lost_outgoing,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebTransportStats::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

WebTransport::IPCStableHashFunction WebTransport::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebTransport>(message.name())) {
    case messages::WebTransport::kSendDatagram: {
      return &WebTransport::SendDatagram_Sym::IPCStableHash;
    }
    case messages::WebTransport::kCreateStream: {
      return &WebTransport::CreateStream_Sym::IPCStableHash;
    }
    case messages::WebTransport::kAcceptBidirectionalStream: {
      return &WebTransport::AcceptBidirectionalStream_Sym::IPCStableHash;
    }
    case messages::WebTransport::kAcceptUnidirectionalStream: {
      return &WebTransport::AcceptUnidirectionalStream_Sym::IPCStableHash;
    }
    case messages::WebTransport::kSendFin: {
      return &WebTransport::SendFin_Sym::IPCStableHash;
    }
    case messages::WebTransport::kAbortStream: {
      return &WebTransport::AbortStream_Sym::IPCStableHash;
    }
    case messages::WebTransport::kStopSending: {
      return &WebTransport::StopSending_Sym::IPCStableHash;
    }
    case messages::WebTransport::kSetOutgoingDatagramExpirationDuration: {
      return &WebTransport::SetOutgoingDatagramExpirationDuration_Sym::IPCStableHash;
    }
    case messages::WebTransport::kGetStats: {
      return &WebTransport::GetStats_Sym::IPCStableHash;
    }
    case messages::WebTransport::kClose: {
      return &WebTransport::Close_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebTransport::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebTransport>(message.name())) {
      case messages::WebTransport::kSendDatagram:
            return "Receive network::mojom::WebTransport::SendDatagram";
      case messages::WebTransport::kCreateStream:
            return "Receive network::mojom::WebTransport::CreateStream";
      case messages::WebTransport::kAcceptBidirectionalStream:
            return "Receive network::mojom::WebTransport::AcceptBidirectionalStream";
      case messages::WebTransport::kAcceptUnidirectionalStream:
            return "Receive network::mojom::WebTransport::AcceptUnidirectionalStream";
      case messages::WebTransport::kSendFin:
            return "Receive network::mojom::WebTransport::SendFin";
      case messages::WebTransport::kAbortStream:
            return "Receive network::mojom::WebTransport::AbortStream";
      case messages::WebTransport::kStopSending:
            return "Receive network::mojom::WebTransport::StopSending";
      case messages::WebTransport::kSetOutgoingDatagramExpirationDuration:
            return "Receive network::mojom::WebTransport::SetOutgoingDatagramExpirationDuration";
      case messages::WebTransport::kGetStats:
            return "Receive network::mojom::WebTransport::GetStats";
      case messages::WebTransport::kClose:
            return "Receive network::mojom::WebTransport::Close";
    }
  } else {
    switch (static_cast<messages::WebTransport>(message.name())) {
      case messages::WebTransport::kSendDatagram:
            return "Receive reply network::mojom::WebTransport::SendDatagram";
      case messages::WebTransport::kCreateStream:
            return "Receive reply network::mojom::WebTransport::CreateStream";
      case messages::WebTransport::kAcceptBidirectionalStream:
            return "Receive reply network::mojom::WebTransport::AcceptBidirectionalStream";
      case messages::WebTransport::kAcceptUnidirectionalStream:
            return "Receive reply network::mojom::WebTransport::AcceptUnidirectionalStream";
      case messages::WebTransport::kSendFin:
            return "Receive reply network::mojom::WebTransport::SendFin";
      case messages::WebTransport::kAbortStream:
            return "Receive reply network::mojom::WebTransport::AbortStream";
      case messages::WebTransport::kStopSending:
            return "Receive reply network::mojom::WebTransport::StopSending";
      case messages::WebTransport::kSetOutgoingDatagramExpirationDuration:
            return "Receive reply network::mojom::WebTransport::SetOutgoingDatagramExpirationDuration";
      case messages::WebTransport::kGetStats:
            return "Receive reply network::mojom::WebTransport::GetStats";
      case messages::WebTransport::kClose:
            return "Receive reply network::mojom::WebTransport::Close";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebTransport::SendDatagram_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xedac0d48;  // IPCStableHash for network::mojom::WebTransport::SendDatagram
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebTransport::CreateStream_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x98584000;  // IPCStableHash for network::mojom::WebTransport::CreateStream
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebTransport::AcceptBidirectionalStream_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb4a9a32f;  // IPCStableHash for network::mojom::WebTransport::AcceptBidirectionalStream
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebTransport::AcceptUnidirectionalStream_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbf97d60c;  // IPCStableHash for network::mojom::WebTransport::AcceptUnidirectionalStream
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebTransport::SendFin_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1826a705;  // IPCStableHash for network::mojom::WebTransport::SendFin
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebTransport::AbortStream_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe07b6b6a;  // IPCStableHash for network::mojom::WebTransport::AbortStream
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebTransport::StopSending_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x014a4d9a;  // IPCStableHash for network::mojom::WebTransport::StopSending
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebTransport::SetOutgoingDatagramExpirationDuration_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc9cad962;  // IPCStableHash for network::mojom::WebTransport::SetOutgoingDatagramExpirationDuration
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebTransport::GetStats_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe70400ca;  // IPCStableHash for network::mojom::WebTransport::GetStats
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebTransport::Close_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb69a542d;  // IPCStableHash for network::mojom::WebTransport::Close
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class WebTransport_SendDatagram_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebTransport_SendDatagram_ForwardToCallback(
      WebTransport::SendDatagramCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebTransport_SendDatagram_ForwardToCallback(const WebTransport_SendDatagram_ForwardToCallback&) = delete;
  WebTransport_SendDatagram_ForwardToCallback& operator=(const WebTransport_SendDatagram_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebTransport::SendDatagramCallback callback_;
};

class WebTransport_CreateStream_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebTransport_CreateStream_ForwardToCallback(
      WebTransport::CreateStreamCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebTransport_CreateStream_ForwardToCallback(const WebTransport_CreateStream_ForwardToCallback&) = delete;
  WebTransport_CreateStream_ForwardToCallback& operator=(const WebTransport_CreateStream_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebTransport::CreateStreamCallback callback_;
};

class WebTransport_AcceptBidirectionalStream_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebTransport_AcceptBidirectionalStream_ForwardToCallback(
      WebTransport::AcceptBidirectionalStreamCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebTransport_AcceptBidirectionalStream_ForwardToCallback(const WebTransport_AcceptBidirectionalStream_ForwardToCallback&) = delete;
  WebTransport_AcceptBidirectionalStream_ForwardToCallback& operator=(const WebTransport_AcceptBidirectionalStream_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebTransport::AcceptBidirectionalStreamCallback callback_;
};

class WebTransport_AcceptUnidirectionalStream_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebTransport_AcceptUnidirectionalStream_ForwardToCallback(
      WebTransport::AcceptUnidirectionalStreamCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebTransport_AcceptUnidirectionalStream_ForwardToCallback(const WebTransport_AcceptUnidirectionalStream_ForwardToCallback&) = delete;
  WebTransport_AcceptUnidirectionalStream_ForwardToCallback& operator=(const WebTransport_AcceptUnidirectionalStream_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebTransport::AcceptUnidirectionalStreamCallback callback_;
};

class WebTransport_GetStats_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebTransport_GetStats_ForwardToCallback(
      WebTransport::GetStatsCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebTransport_GetStats_ForwardToCallback(const WebTransport_GetStats_ForwardToCallback&) = delete;
  WebTransport_GetStats_ForwardToCallback& operator=(const WebTransport_GetStats_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebTransport::GetStatsCallback callback_;
};

WebTransportProxy::WebTransportProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebTransportProxy::SendDatagram(
    ::base::span<const ::uint8_t> in_data, SendDatagramCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::WebTransport::SendDatagram", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type ::base::span<const ::uint8_t>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebTransport::kSendDatagram), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebTransport_SendDatagram_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyBufferDataView>(
    in_data,
    data_fragment);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in WebTransport.SendDatagram request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebTransport::Name_);
  message.set_method_name("SendDatagram");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebTransport_SendDatagram_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebTransportProxy::CreateStream(
    ::mojo::ScopedDataPipeConsumerHandle in_readable, ::mojo::ScopedDataPipeProducerHandle in_writable, CreateStreamCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::WebTransport::CreateStream", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("readable"), in_readable,
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("writable"), in_writable,
                        "<value of type ::mojo::ScopedDataPipeProducerHandle>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebTransport::kCreateStream), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebTransport_CreateStream_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
    in_readable,
    &params->readable,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->readable)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid readable in WebTransport.CreateStream request");

  
  mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle>(
    in_writable,
    &params->writable,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebTransport::Name_);
  message.set_method_name("CreateStream");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebTransport_CreateStream_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebTransportProxy::AcceptBidirectionalStream(
    AcceptBidirectionalStreamCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::WebTransport::AcceptBidirectionalStream");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebTransport::kAcceptBidirectionalStream), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebTransport_AcceptBidirectionalStream_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebTransport::Name_);
  message.set_method_name("AcceptBidirectionalStream");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebTransport_AcceptBidirectionalStream_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebTransportProxy::AcceptUnidirectionalStream(
    AcceptUnidirectionalStreamCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::WebTransport::AcceptUnidirectionalStream");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebTransport::kAcceptUnidirectionalStream), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebTransport_AcceptUnidirectionalStream_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebTransport::Name_);
  message.set_method_name("AcceptUnidirectionalStream");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebTransport_AcceptUnidirectionalStream_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebTransportProxy::SendFin(
    uint32_t in_stream_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::WebTransport::SendFin", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_id"), in_stream_id,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebTransport::kSendFin), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebTransport_SendFin_Params_Data> params(
          message);
  params.Allocate();

  params->stream_id = in_stream_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebTransport::Name_);
  message.set_method_name("SendFin");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebTransportProxy::AbortStream(
    uint32_t in_stream_id, uint8_t in_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::WebTransport::AbortStream", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_id"), in_stream_id,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("code"), in_code,
                        "<value of type uint8_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebTransport::kAbortStream), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebTransport_AbortStream_Params_Data> params(
          message);
  params.Allocate();

  params->stream_id = in_stream_id;

  params->code = in_code;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebTransport::Name_);
  message.set_method_name("AbortStream");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebTransportProxy::StopSending(
    uint32_t in_stream_id, uint8_t in_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::WebTransport::StopSending", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_id"), in_stream_id,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("code"), in_code,
                        "<value of type uint8_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebTransport::kStopSending), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebTransport_StopSending_Params_Data> params(
          message);
  params.Allocate();

  params->stream_id = in_stream_id;

  params->code = in_code;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebTransport::Name_);
  message.set_method_name("StopSending");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebTransportProxy::SetOutgoingDatagramExpirationDuration(
    ::base::TimeDelta in_duration) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::WebTransport::SetOutgoingDatagramExpirationDuration", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("duration"), in_duration,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebTransport::kSetOutgoingDatagramExpirationDuration), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebTransport_SetOutgoingDatagramExpirationDuration_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->duration)::BaseType> duration_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_duration,
    duration_fragment);

  params->duration.Set(
      duration_fragment.is_null() ? nullptr : duration_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->duration.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null duration in WebTransport.SetOutgoingDatagramExpirationDuration request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebTransport::Name_);
  message.set_method_name("SetOutgoingDatagramExpirationDuration");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebTransportProxy::GetStats(
    GetStatsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::WebTransport::GetStats");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebTransport::kGetStats), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebTransport_GetStats_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebTransport::Name_);
  message.set_method_name("GetStats");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebTransport_GetStats_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebTransportProxy::Close(
    WebTransportCloseInfoPtr in_close_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::WebTransport::Close", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("close_info"), in_close_info,
                        "<value of type WebTransportCloseInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebTransport::kClose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebTransport_Close_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->close_info)::BaseType> close_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::WebTransportCloseInfoDataView>(
    in_close_info,
    close_info_fragment);

  params->close_info.Set(
      close_info_fragment.is_null() ? nullptr : close_info_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebTransport::Name_);
  message.set_method_name("Close");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class WebTransport_SendDatagram_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebTransport::SendDatagramCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebTransport_SendDatagram_ProxyToResponder> proxy(
        new WebTransport_SendDatagram_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebTransport_SendDatagram_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebTransport_SendDatagram_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebTransport_SendDatagram_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "WebTransport::SendDatagramCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_result);
};

bool WebTransport_SendDatagram_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebTransport_SendDatagram_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebTransport_SendDatagram_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebTransport.0
  bool success = true;
  bool p_result{};
  WebTransport_SendDatagram_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebTransport::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void WebTransport_SendDatagram_ProxyToResponder::Run(
    bool in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::WebTransport::SendDatagram", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebTransport::kSendDatagram), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebTransport_SendDatagram_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebTransport::Name_);
  message.set_method_name("SendDatagram");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebTransport_CreateStream_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebTransport::CreateStreamCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebTransport_CreateStream_ProxyToResponder> proxy(
        new WebTransport_CreateStream_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebTransport_CreateStream_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebTransport_CreateStream_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebTransport_CreateStream_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "WebTransport::CreateStreamCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_succeeded, uint32_t in_stream_id);
};

bool WebTransport_CreateStream_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebTransport_CreateStream_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebTransport_CreateStream_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebTransport.1
  bool success = true;
  bool p_succeeded{};
  uint32_t p_stream_id{};
  WebTransport_CreateStream_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_succeeded = input_data_view.succeeded();
  if (success)
    p_stream_id = input_data_view.stream_id();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebTransport::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_succeeded), 
std::move(p_stream_id));
  }
  return true;
}

void WebTransport_CreateStream_ProxyToResponder::Run(
    bool in_succeeded, uint32_t in_stream_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::WebTransport::CreateStream", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("succeeded"), in_succeeded,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_id"), in_stream_id,
                        "<value of type uint32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebTransport::kCreateStream), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebTransport_CreateStream_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->succeeded = in_succeeded;

  params->stream_id = in_stream_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebTransport::Name_);
  message.set_method_name("CreateStream");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebTransport_AcceptBidirectionalStream_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebTransport::AcceptBidirectionalStreamCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebTransport_AcceptBidirectionalStream_ProxyToResponder> proxy(
        new WebTransport_AcceptBidirectionalStream_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebTransport_AcceptBidirectionalStream_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebTransport_AcceptBidirectionalStream_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebTransport_AcceptBidirectionalStream_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "WebTransport::AcceptBidirectionalStreamCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      uint32_t in_stream_id, ::mojo::ScopedDataPipeConsumerHandle in_readable, ::mojo::ScopedDataPipeProducerHandle in_writable);
};

bool WebTransport_AcceptBidirectionalStream_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebTransport_AcceptBidirectionalStream_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebTransport_AcceptBidirectionalStream_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebTransport.2
  bool success = true;
  uint32_t p_stream_id{};
  ::mojo::ScopedDataPipeConsumerHandle p_readable{};
  ::mojo::ScopedDataPipeProducerHandle p_writable{};
  WebTransport_AcceptBidirectionalStream_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_stream_id = input_data_view.stream_id();
  if (success)
    p_readable = input_data_view.TakeReadable();
  if (success)
    p_writable = input_data_view.TakeWritable();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebTransport::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_stream_id), 
std::move(p_readable), 
std::move(p_writable));
  }
  return true;
}

void WebTransport_AcceptBidirectionalStream_ProxyToResponder::Run(
    uint32_t in_stream_id, ::mojo::ScopedDataPipeConsumerHandle in_readable, ::mojo::ScopedDataPipeProducerHandle in_writable) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::WebTransport::AcceptBidirectionalStream", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_id"), in_stream_id,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("readable"), in_readable,
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("writable"), in_writable,
                        "<value of type ::mojo::ScopedDataPipeProducerHandle>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebTransport::kAcceptBidirectionalStream), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebTransport_AcceptBidirectionalStream_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->stream_id = in_stream_id;

  
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
    in_readable,
    &params->readable,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->readable)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid readable in ");

  
  mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle>(
    in_writable,
    &params->writable,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->writable)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid writable in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebTransport::Name_);
  message.set_method_name("AcceptBidirectionalStream");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebTransport_AcceptUnidirectionalStream_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebTransport::AcceptUnidirectionalStreamCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebTransport_AcceptUnidirectionalStream_ProxyToResponder> proxy(
        new WebTransport_AcceptUnidirectionalStream_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebTransport_AcceptUnidirectionalStream_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebTransport_AcceptUnidirectionalStream_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebTransport_AcceptUnidirectionalStream_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "WebTransport::AcceptUnidirectionalStreamCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      uint32_t in_stream_id, ::mojo::ScopedDataPipeConsumerHandle in_readable);
};

bool WebTransport_AcceptUnidirectionalStream_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebTransport_AcceptUnidirectionalStream_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebTransport_AcceptUnidirectionalStream_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebTransport.3
  bool success = true;
  uint32_t p_stream_id{};
  ::mojo::ScopedDataPipeConsumerHandle p_readable{};
  WebTransport_AcceptUnidirectionalStream_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_stream_id = input_data_view.stream_id();
  if (success)
    p_readable = input_data_view.TakeReadable();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebTransport::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_stream_id), 
std::move(p_readable));
  }
  return true;
}

void WebTransport_AcceptUnidirectionalStream_ProxyToResponder::Run(
    uint32_t in_stream_id, ::mojo::ScopedDataPipeConsumerHandle in_readable) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::WebTransport::AcceptUnidirectionalStream", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_id"), in_stream_id,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("readable"), in_readable,
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebTransport::kAcceptUnidirectionalStream), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebTransport_AcceptUnidirectionalStream_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->stream_id = in_stream_id;

  
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
    in_readable,
    &params->readable,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->readable)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid readable in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebTransport::Name_);
  message.set_method_name("AcceptUnidirectionalStream");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebTransport_GetStats_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebTransport::GetStatsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebTransport_GetStats_ProxyToResponder> proxy(
        new WebTransport_GetStats_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebTransport_GetStats_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebTransport_GetStats_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebTransport_GetStats_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "WebTransport::GetStatsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      WebTransportStatsPtr in_stats);
};

bool WebTransport_GetStats_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebTransport_GetStats_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebTransport_GetStats_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebTransport.8
  bool success = true;
  WebTransportStatsPtr p_stats{};
  WebTransport_GetStats_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStats(&p_stats))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebTransport::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_stats));
  }
  return true;
}

void WebTransport_GetStats_ProxyToResponder::Run(
    WebTransportStatsPtr in_stats) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::WebTransport::GetStats", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stats"), in_stats,
                        "<value of type WebTransportStatsPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebTransport::kGetStats), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebTransport_GetStats_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->stats)::BaseType> stats_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::WebTransportStatsDataView>(
    in_stats,
    stats_fragment);

  params->stats.Set(
      stats_fragment.is_null() ? nullptr : stats_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebTransport::Name_);
  message.set_method_name("GetStats");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WebTransportStubDispatch::Accept(
    WebTransport* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebTransport>(message->header()->name)) {
    case messages::WebTransport::kSendDatagram: {
      break;
    }
    case messages::WebTransport::kCreateStream: {
      break;
    }
    case messages::WebTransport::kAcceptBidirectionalStream: {
      break;
    }
    case messages::WebTransport::kAcceptUnidirectionalStream: {
      break;
    }
    case messages::WebTransport::kSendFin: {
      DCHECK(message->is_serialized());
      internal::WebTransport_SendFin_Params_Data* params =
          reinterpret_cast<internal::WebTransport_SendFin_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebTransport.4
      bool success = true;
      uint32_t p_stream_id{};
      WebTransport_SendFin_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_stream_id = input_data_view.stream_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebTransport::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendFin(        
        std::move(p_stream_id));
      return true;
    }
    case messages::WebTransport::kAbortStream: {
      DCHECK(message->is_serialized());
      internal::WebTransport_AbortStream_Params_Data* params =
          reinterpret_cast<internal::WebTransport_AbortStream_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebTransport.5
      bool success = true;
      uint32_t p_stream_id{};
      uint8_t p_code{};
      WebTransport_AbortStream_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_stream_id = input_data_view.stream_id();
      if (success)
        p_code = input_data_view.code();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebTransport::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AbortStream(        
        std::move(p_stream_id), 
        std::move(p_code));
      return true;
    }
    case messages::WebTransport::kStopSending: {
      DCHECK(message->is_serialized());
      internal::WebTransport_StopSending_Params_Data* params =
          reinterpret_cast<internal::WebTransport_StopSending_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebTransport.6
      bool success = true;
      uint32_t p_stream_id{};
      uint8_t p_code{};
      WebTransport_StopSending_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_stream_id = input_data_view.stream_id();
      if (success)
        p_code = input_data_view.code();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebTransport::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StopSending(        
        std::move(p_stream_id), 
        std::move(p_code));
      return true;
    }
    case messages::WebTransport::kSetOutgoingDatagramExpirationDuration: {
      DCHECK(message->is_serialized());
      internal::WebTransport_SetOutgoingDatagramExpirationDuration_Params_Data* params =
          reinterpret_cast<internal::WebTransport_SetOutgoingDatagramExpirationDuration_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebTransport.7
      bool success = true;
      ::base::TimeDelta p_duration{};
      WebTransport_SetOutgoingDatagramExpirationDuration_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDuration(&p_duration))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebTransport::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetOutgoingDatagramExpirationDuration(        
        std::move(p_duration));
      return true;
    }
    case messages::WebTransport::kGetStats: {
      break;
    }
    case messages::WebTransport::kClose: {
      DCHECK(message->is_serialized());
      internal::WebTransport_Close_Params_Data* params =
          reinterpret_cast<internal::WebTransport_Close_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebTransport.9
      bool success = true;
      WebTransportCloseInfoPtr p_close_info{};
      WebTransport_Close_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCloseInfo(&p_close_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebTransport::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Close(        
        std::move(p_close_info));
      return true;
    }
  }
  return false;
}

// static
bool WebTransportStubDispatch::AcceptWithResponder(
    WebTransport* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebTransport>(message->header()->name)) {
    case messages::WebTransport::kSendDatagram: {
      internal::WebTransport_SendDatagram_Params_Data* params =
          reinterpret_cast<
              internal::WebTransport_SendDatagram_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebTransport.0
      bool success = true;
      ::base::span<const ::uint8_t> p_data{};
      WebTransport_SendDatagram_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebTransport::Name_, 0, false);
        return false;
      }
      auto callback =
          WebTransport_SendDatagram_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendDatagram(        
        std::move(p_data), std::move(callback));
      return true;
    }
    case messages::WebTransport::kCreateStream: {
      internal::WebTransport_CreateStream_Params_Data* params =
          reinterpret_cast<
              internal::WebTransport_CreateStream_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebTransport.1
      bool success = true;
      ::mojo::ScopedDataPipeConsumerHandle p_readable{};
      ::mojo::ScopedDataPipeProducerHandle p_writable{};
      WebTransport_CreateStream_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_readable = input_data_view.TakeReadable();
      if (success)
        p_writable = input_data_view.TakeWritable();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebTransport::Name_, 1, false);
        return false;
      }
      auto callback =
          WebTransport_CreateStream_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateStream(        
        std::move(p_readable), 
        std::move(p_writable), std::move(callback));
      return true;
    }
    case messages::WebTransport::kAcceptBidirectionalStream: {
      internal::WebTransport_AcceptBidirectionalStream_Params_Data* params =
          reinterpret_cast<
              internal::WebTransport_AcceptBidirectionalStream_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebTransport.2
      bool success = true;
      WebTransport_AcceptBidirectionalStream_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebTransport::Name_, 2, false);
        return false;
      }
      auto callback =
          WebTransport_AcceptBidirectionalStream_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AcceptBidirectionalStream(std::move(callback));
      return true;
    }
    case messages::WebTransport::kAcceptUnidirectionalStream: {
      internal::WebTransport_AcceptUnidirectionalStream_Params_Data* params =
          reinterpret_cast<
              internal::WebTransport_AcceptUnidirectionalStream_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebTransport.3
      bool success = true;
      WebTransport_AcceptUnidirectionalStream_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebTransport::Name_, 3, false);
        return false;
      }
      auto callback =
          WebTransport_AcceptUnidirectionalStream_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AcceptUnidirectionalStream(std::move(callback));
      return true;
    }
    case messages::WebTransport::kSendFin: {
      break;
    }
    case messages::WebTransport::kAbortStream: {
      break;
    }
    case messages::WebTransport::kStopSending: {
      break;
    }
    case messages::WebTransport::kSetOutgoingDatagramExpirationDuration: {
      break;
    }
    case messages::WebTransport::kGetStats: {
      internal::WebTransport_GetStats_Params_Data* params =
          reinterpret_cast<
              internal::WebTransport_GetStats_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebTransport.8
      bool success = true;
      WebTransport_GetStats_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebTransport::Name_, 8, false);
        return false;
      }
      auto callback =
          WebTransport_GetStats_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetStats(std::move(callback));
      return true;
    }
    case messages::WebTransport::kClose: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kWebTransportValidationInfo[] = {
    {base::to_underlying(messages::WebTransport::kSendDatagram),
     { &internal::WebTransport_SendDatagram_Params_Data::Validate,
      &internal::WebTransport_SendDatagram_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::WebTransport::kCreateStream),
     { &internal::WebTransport_CreateStream_Params_Data::Validate,
      &internal::WebTransport_CreateStream_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::WebTransport::kAcceptBidirectionalStream),
     { &internal::WebTransport_AcceptBidirectionalStream_Params_Data::Validate,
      &internal::WebTransport_AcceptBidirectionalStream_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::WebTransport::kAcceptUnidirectionalStream),
     { &internal::WebTransport_AcceptUnidirectionalStream_Params_Data::Validate,
      &internal::WebTransport_AcceptUnidirectionalStream_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::WebTransport::kSendFin),
     { &internal::WebTransport_SendFin_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::WebTransport::kAbortStream),
     { &internal::WebTransport_AbortStream_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::WebTransport::kStopSending),
     { &internal::WebTransport_StopSending_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::WebTransport::kSetOutgoingDatagramExpirationDuration),
     { &internal::WebTransport_SetOutgoingDatagramExpirationDuration_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::WebTransport::kGetStats),
     { &internal::WebTransport_GetStats_Params_Data::Validate,
      &internal::WebTransport_GetStats_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::WebTransport::kClose),
     { &internal::WebTransport_Close_Params_Data::Validate,
      nullptr /* no response */}},
};

bool WebTransportRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::network::mojom::blink::WebTransport::Name_,
    kWebTransportValidationInfo);
}

bool WebTransportResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::network::mojom::blink::WebTransport::Name_,
    kWebTransportValidationInfo);

}
// The declaration includes the definition on other builds.

WebTransportClient::IPCStableHashFunction WebTransportClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebTransportClient>(message.name())) {
    case messages::WebTransportClient::kOnDatagramReceived: {
      return &WebTransportClient::OnDatagramReceived_Sym::IPCStableHash;
    }
    case messages::WebTransportClient::kOnIncomingStreamClosed: {
      return &WebTransportClient::OnIncomingStreamClosed_Sym::IPCStableHash;
    }
    case messages::WebTransportClient::kOnOutgoingStreamClosed: {
      return &WebTransportClient::OnOutgoingStreamClosed_Sym::IPCStableHash;
    }
    case messages::WebTransportClient::kOnReceivedStopSending: {
      return &WebTransportClient::OnReceivedStopSending_Sym::IPCStableHash;
    }
    case messages::WebTransportClient::kOnReceivedResetStream: {
      return &WebTransportClient::OnReceivedResetStream_Sym::IPCStableHash;
    }
    case messages::WebTransportClient::kOnClosed: {
      return &WebTransportClient::OnClosed_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebTransportClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebTransportClient>(message.name())) {
      case messages::WebTransportClient::kOnDatagramReceived:
            return "Receive network::mojom::WebTransportClient::OnDatagramReceived";
      case messages::WebTransportClient::kOnIncomingStreamClosed:
            return "Receive network::mojom::WebTransportClient::OnIncomingStreamClosed";
      case messages::WebTransportClient::kOnOutgoingStreamClosed:
            return "Receive network::mojom::WebTransportClient::OnOutgoingStreamClosed";
      case messages::WebTransportClient::kOnReceivedStopSending:
            return "Receive network::mojom::WebTransportClient::OnReceivedStopSending";
      case messages::WebTransportClient::kOnReceivedResetStream:
            return "Receive network::mojom::WebTransportClient::OnReceivedResetStream";
      case messages::WebTransportClient::kOnClosed:
            return "Receive network::mojom::WebTransportClient::OnClosed";
    }
  } else {
    switch (static_cast<messages::WebTransportClient>(message.name())) {
      case messages::WebTransportClient::kOnDatagramReceived:
            return "Receive reply network::mojom::WebTransportClient::OnDatagramReceived";
      case messages::WebTransportClient::kOnIncomingStreamClosed:
            return "Receive reply network::mojom::WebTransportClient::OnIncomingStreamClosed";
      case messages::WebTransportClient::kOnOutgoingStreamClosed:
            return "Receive reply network::mojom::WebTransportClient::OnOutgoingStreamClosed";
      case messages::WebTransportClient::kOnReceivedStopSending:
            return "Receive reply network::mojom::WebTransportClient::OnReceivedStopSending";
      case messages::WebTransportClient::kOnReceivedResetStream:
            return "Receive reply network::mojom::WebTransportClient::OnReceivedResetStream";
      case messages::WebTransportClient::kOnClosed:
            return "Receive reply network::mojom::WebTransportClient::OnClosed";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebTransportClient::OnDatagramReceived_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xea365310;  // IPCStableHash for network::mojom::WebTransportClient::OnDatagramReceived
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebTransportClient::OnIncomingStreamClosed_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8f9a2a4b;  // IPCStableHash for network::mojom::WebTransportClient::OnIncomingStreamClosed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebTransportClient::OnOutgoingStreamClosed_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe1fa1883;  // IPCStableHash for network::mojom::WebTransportClient::OnOutgoingStreamClosed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebTransportClient::OnReceivedStopSending_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2cdd1a69;  // IPCStableHash for network::mojom::WebTransportClient::OnReceivedStopSending
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebTransportClient::OnReceivedResetStream_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x260bd14a;  // IPCStableHash for network::mojom::WebTransportClient::OnReceivedResetStream
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebTransportClient::OnClosed_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf1ae695b;  // IPCStableHash for network::mojom::WebTransportClient::OnClosed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

WebTransportClientProxy::WebTransportClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebTransportClientProxy::OnDatagramReceived(
    ::base::span<const ::uint8_t> in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::WebTransportClient::OnDatagramReceived", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type ::base::span<const ::uint8_t>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebTransportClient::kOnDatagramReceived), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebTransportClient_OnDatagramReceived_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyBufferDataView>(
    in_data,
    data_fragment);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in WebTransportClient.OnDatagramReceived request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebTransportClient::Name_);
  message.set_method_name("OnDatagramReceived");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebTransportClientProxy::OnIncomingStreamClosed(
    uint32_t in_stream_id, bool in_fin_received) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::WebTransportClient::OnIncomingStreamClosed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_id"), in_stream_id,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("fin_received"), in_fin_received,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebTransportClient::kOnIncomingStreamClosed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebTransportClient_OnIncomingStreamClosed_Params_Data> params(
          message);
  params.Allocate();

  params->stream_id = in_stream_id;

  params->fin_received = in_fin_received;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebTransportClient::Name_);
  message.set_method_name("OnIncomingStreamClosed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebTransportClientProxy::OnOutgoingStreamClosed(
    uint32_t in_stream_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::WebTransportClient::OnOutgoingStreamClosed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_id"), in_stream_id,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebTransportClient::kOnOutgoingStreamClosed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebTransportClient_OnOutgoingStreamClosed_Params_Data> params(
          message);
  params.Allocate();

  params->stream_id = in_stream_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebTransportClient::Name_);
  message.set_method_name("OnOutgoingStreamClosed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebTransportClientProxy::OnReceivedStopSending(
    uint32_t in_stream_id, uint32_t in_stream_error_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::WebTransportClient::OnReceivedStopSending", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_id"), in_stream_id,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_error_code"), in_stream_error_code,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebTransportClient::kOnReceivedStopSending), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebTransportClient_OnReceivedStopSending_Params_Data> params(
          message);
  params.Allocate();

  params->stream_id = in_stream_id;

  params->stream_error_code = in_stream_error_code;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebTransportClient::Name_);
  message.set_method_name("OnReceivedStopSending");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebTransportClientProxy::OnReceivedResetStream(
    uint32_t in_stream_id, uint32_t in_stream_error_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::WebTransportClient::OnReceivedResetStream", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_id"), in_stream_id,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_error_code"), in_stream_error_code,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebTransportClient::kOnReceivedResetStream), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebTransportClient_OnReceivedResetStream_Params_Data> params(
          message);
  params.Allocate();

  params->stream_id = in_stream_id;

  params->stream_error_code = in_stream_error_code;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebTransportClient::Name_);
  message.set_method_name("OnReceivedResetStream");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebTransportClientProxy::OnClosed(
    WebTransportCloseInfoPtr in_close_info, WebTransportStatsPtr in_final_stats) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::WebTransportClient::OnClosed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("close_info"), in_close_info,
                        "<value of type WebTransportCloseInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("final_stats"), in_final_stats,
                        "<value of type WebTransportStatsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebTransportClient::kOnClosed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebTransportClient_OnClosed_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->close_info)::BaseType> close_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::WebTransportCloseInfoDataView>(
    in_close_info,
    close_info_fragment);

  params->close_info.Set(
      close_info_fragment.is_null() ? nullptr : close_info_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->final_stats)::BaseType> final_stats_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::WebTransportStatsDataView>(
    in_final_stats,
    final_stats_fragment);

  params->final_stats.Set(
      final_stats_fragment.is_null() ? nullptr : final_stats_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->final_stats.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null final_stats in WebTransportClient.OnClosed request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebTransportClient::Name_);
  message.set_method_name("OnClosed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool WebTransportClientStubDispatch::Accept(
    WebTransportClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebTransportClient>(message->header()->name)) {
    case messages::WebTransportClient::kOnDatagramReceived: {
      DCHECK(message->is_serialized());
      internal::WebTransportClient_OnDatagramReceived_Params_Data* params =
          reinterpret_cast<internal::WebTransportClient_OnDatagramReceived_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebTransportClient.0
      bool success = true;
      ::base::span<const ::uint8_t> p_data{};
      WebTransportClient_OnDatagramReceived_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebTransportClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDatagramReceived(        
        std::move(p_data));
      return true;
    }
    case messages::WebTransportClient::kOnIncomingStreamClosed: {
      DCHECK(message->is_serialized());
      internal::WebTransportClient_OnIncomingStreamClosed_Params_Data* params =
          reinterpret_cast<internal::WebTransportClient_OnIncomingStreamClosed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebTransportClient.1
      bool success = true;
      uint32_t p_stream_id{};
      bool p_fin_received{};
      WebTransportClient_OnIncomingStreamClosed_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_stream_id = input_data_view.stream_id();
      if (success)
        p_fin_received = input_data_view.fin_received();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebTransportClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnIncomingStreamClosed(        
        std::move(p_stream_id), 
        std::move(p_fin_received));
      return true;
    }
    case messages::WebTransportClient::kOnOutgoingStreamClosed: {
      DCHECK(message->is_serialized());
      internal::WebTransportClient_OnOutgoingStreamClosed_Params_Data* params =
          reinterpret_cast<internal::WebTransportClient_OnOutgoingStreamClosed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebTransportClient.2
      bool success = true;
      uint32_t p_stream_id{};
      WebTransportClient_OnOutgoingStreamClosed_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_stream_id = input_data_view.stream_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebTransportClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnOutgoingStreamClosed(        
        std::move(p_stream_id));
      return true;
    }
    case messages::WebTransportClient::kOnReceivedStopSending: {
      DCHECK(message->is_serialized());
      internal::WebTransportClient_OnReceivedStopSending_Params_Data* params =
          reinterpret_cast<internal::WebTransportClient_OnReceivedStopSending_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebTransportClient.3
      bool success = true;
      uint32_t p_stream_id{};
      uint32_t p_stream_error_code{};
      WebTransportClient_OnReceivedStopSending_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_stream_id = input_data_view.stream_id();
      if (success)
        p_stream_error_code = input_data_view.stream_error_code();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebTransportClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReceivedStopSending(        
        std::move(p_stream_id), 
        std::move(p_stream_error_code));
      return true;
    }
    case messages::WebTransportClient::kOnReceivedResetStream: {
      DCHECK(message->is_serialized());
      internal::WebTransportClient_OnReceivedResetStream_Params_Data* params =
          reinterpret_cast<internal::WebTransportClient_OnReceivedResetStream_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebTransportClient.4
      bool success = true;
      uint32_t p_stream_id{};
      uint32_t p_stream_error_code{};
      WebTransportClient_OnReceivedResetStream_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_stream_id = input_data_view.stream_id();
      if (success)
        p_stream_error_code = input_data_view.stream_error_code();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebTransportClient::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReceivedResetStream(        
        std::move(p_stream_id), 
        std::move(p_stream_error_code));
      return true;
    }
    case messages::WebTransportClient::kOnClosed: {
      DCHECK(message->is_serialized());
      internal::WebTransportClient_OnClosed_Params_Data* params =
          reinterpret_cast<internal::WebTransportClient_OnClosed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebTransportClient.5
      bool success = true;
      WebTransportCloseInfoPtr p_close_info{};
      WebTransportStatsPtr p_final_stats{};
      WebTransportClient_OnClosed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCloseInfo(&p_close_info))
        success = false;
      if (success && !input_data_view.ReadFinalStats(&p_final_stats))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebTransportClient::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnClosed(        
        std::move(p_close_info), 
        std::move(p_final_stats));
      return true;
    }
  }
  return false;
}

// static
bool WebTransportClientStubDispatch::AcceptWithResponder(
    WebTransportClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebTransportClient>(message->header()->name)) {
    case messages::WebTransportClient::kOnDatagramReceived: {
      break;
    }
    case messages::WebTransportClient::kOnIncomingStreamClosed: {
      break;
    }
    case messages::WebTransportClient::kOnOutgoingStreamClosed: {
      break;
    }
    case messages::WebTransportClient::kOnReceivedStopSending: {
      break;
    }
    case messages::WebTransportClient::kOnReceivedResetStream: {
      break;
    }
    case messages::WebTransportClient::kOnClosed: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kWebTransportClientValidationInfo[] = {
    {base::to_underlying(messages::WebTransportClient::kOnDatagramReceived),
     { &internal::WebTransportClient_OnDatagramReceived_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::WebTransportClient::kOnIncomingStreamClosed),
     { &internal::WebTransportClient_OnIncomingStreamClosed_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::WebTransportClient::kOnOutgoingStreamClosed),
     { &internal::WebTransportClient_OnOutgoingStreamClosed_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::WebTransportClient::kOnReceivedStopSending),
     { &internal::WebTransportClient_OnReceivedStopSending_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::WebTransportClient::kOnReceivedResetStream),
     { &internal::WebTransportClient_OnReceivedResetStream_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::WebTransportClient::kOnClosed),
     { &internal::WebTransportClient_OnClosed_Params_Data::Validate,
      nullptr /* no response */}},
};

bool WebTransportClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::network::mojom::blink::WebTransportClient::Name_,
    kWebTransportClientValidationInfo);
}

// The declaration includes the definition on other builds.

WebTransportHandshakeClient::IPCStableHashFunction WebTransportHandshakeClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebTransportHandshakeClient>(message.name())) {
    case messages::WebTransportHandshakeClient::kOnBeforeConnect: {
      return &WebTransportHandshakeClient::OnBeforeConnect_Sym::IPCStableHash;
    }
    case messages::WebTransportHandshakeClient::kOnConnectionEstablished: {
      return &WebTransportHandshakeClient::OnConnectionEstablished_Sym::IPCStableHash;
    }
    case messages::WebTransportHandshakeClient::kOnHandshakeFailed: {
      return &WebTransportHandshakeClient::OnHandshakeFailed_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebTransportHandshakeClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebTransportHandshakeClient>(message.name())) {
      case messages::WebTransportHandshakeClient::kOnBeforeConnect:
            return "Receive network::mojom::WebTransportHandshakeClient::OnBeforeConnect";
      case messages::WebTransportHandshakeClient::kOnConnectionEstablished:
            return "Receive network::mojom::WebTransportHandshakeClient::OnConnectionEstablished";
      case messages::WebTransportHandshakeClient::kOnHandshakeFailed:
            return "Receive network::mojom::WebTransportHandshakeClient::OnHandshakeFailed";
    }
  } else {
    switch (static_cast<messages::WebTransportHandshakeClient>(message.name())) {
      case messages::WebTransportHandshakeClient::kOnBeforeConnect:
            return "Receive reply network::mojom::WebTransportHandshakeClient::OnBeforeConnect";
      case messages::WebTransportHandshakeClient::kOnConnectionEstablished:
            return "Receive reply network::mojom::WebTransportHandshakeClient::OnConnectionEstablished";
      case messages::WebTransportHandshakeClient::kOnHandshakeFailed:
            return "Receive reply network::mojom::WebTransportHandshakeClient::OnHandshakeFailed";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebTransportHandshakeClient::OnBeforeConnect_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x43dd2b55;  // IPCStableHash for network::mojom::WebTransportHandshakeClient::OnBeforeConnect
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebTransportHandshakeClient::OnConnectionEstablished_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9f651164;  // IPCStableHash for network::mojom::WebTransportHandshakeClient::OnConnectionEstablished
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebTransportHandshakeClient::OnHandshakeFailed_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9756dcef;  // IPCStableHash for network::mojom::WebTransportHandshakeClient::OnHandshakeFailed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

WebTransportHandshakeClientProxy::WebTransportHandshakeClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebTransportHandshakeClientProxy::OnBeforeConnect(
    const ::net::IPEndPoint& in_server_address) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::WebTransportHandshakeClient::OnBeforeConnect", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("server_address"), in_server_address,
                        "<value of type const ::net::IPEndPoint&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebTransportHandshakeClient::kOnBeforeConnect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebTransportHandshakeClient_OnBeforeConnect_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->server_address)::BaseType> server_address_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
    in_server_address,
    server_address_fragment);

  params->server_address.Set(
      server_address_fragment.is_null() ? nullptr : server_address_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->server_address.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null server_address in WebTransportHandshakeClient.OnBeforeConnect request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebTransportHandshakeClient::Name_);
  message.set_method_name("OnBeforeConnect");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebTransportHandshakeClientProxy::OnConnectionEstablished(
    ::mojo::PendingRemote<WebTransport> in_transport, ::mojo::PendingReceiver<WebTransportClient> in_client, ::network::mojom::blink::HttpResponseHeadersPtr in_response_headers, const ::blink::String& in_selected_application_protocol, WebTransportStatsPtr in_initial_stats) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::WebTransportHandshakeClient::OnConnectionEstablished", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("transport"), in_transport,
                        "<value of type ::mojo::PendingRemote<WebTransport>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingReceiver<WebTransportClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response_headers"), in_response_headers,
                        "<value of type ::network::mojom::blink::HttpResponseHeadersPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("selected_application_protocol"), in_selected_application_protocol,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("initial_stats"), in_initial_stats,
                        "<value of type WebTransportStatsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebTransportHandshakeClient::kOnConnectionEstablished), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebTransportHandshakeClient_OnConnectionEstablished_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::WebTransportInterfaceBase>>(
    in_transport,
    &params->transport,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->transport)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid transport in WebTransportHandshakeClient.OnConnectionEstablished request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::WebTransportClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in WebTransportHandshakeClient.OnConnectionEstablished request");
  mojo::internal::MessageFragment<
      typename decltype(params->response_headers)::BaseType> response_headers_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::HttpResponseHeadersDataView>(
    in_response_headers,
    response_headers_fragment);

  params->response_headers.Set(
      response_headers_fragment.is_null() ? nullptr : response_headers_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->response_headers.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null response_headers in WebTransportHandshakeClient.OnConnectionEstablished request");
  mojo::internal::MessageFragment<
      typename decltype(params->selected_application_protocol)::BaseType> selected_application_protocol_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_selected_application_protocol,
    selected_application_protocol_fragment);

  params->selected_application_protocol.Set(
      selected_application_protocol_fragment.is_null() ? nullptr : selected_application_protocol_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->initial_stats)::BaseType> initial_stats_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::WebTransportStatsDataView>(
    in_initial_stats,
    initial_stats_fragment);

  params->initial_stats.Set(
      initial_stats_fragment.is_null() ? nullptr : initial_stats_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->initial_stats.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null initial_stats in WebTransportHandshakeClient.OnConnectionEstablished request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebTransportHandshakeClient::Name_);
  message.set_method_name("OnConnectionEstablished");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebTransportHandshakeClientProxy::OnHandshakeFailed(
    WebTransportErrorPtr in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::WebTransportHandshakeClient::OnHandshakeFailed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type WebTransportErrorPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebTransportHandshakeClient::kOnHandshakeFailed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebTransportHandshakeClient_OnHandshakeFailed_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::WebTransportErrorDataView>(
    in_error,
    error_fragment);

  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebTransportHandshakeClient::Name_);
  message.set_method_name("OnHandshakeFailed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool WebTransportHandshakeClientStubDispatch::Accept(
    WebTransportHandshakeClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebTransportHandshakeClient>(message->header()->name)) {
    case messages::WebTransportHandshakeClient::kOnBeforeConnect: {
      DCHECK(message->is_serialized());
      internal::WebTransportHandshakeClient_OnBeforeConnect_Params_Data* params =
          reinterpret_cast<internal::WebTransportHandshakeClient_OnBeforeConnect_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebTransportHandshakeClient.0
      bool success = true;
      ::net::IPEndPoint p_server_address{};
      WebTransportHandshakeClient_OnBeforeConnect_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadServerAddress(&p_server_address))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebTransportHandshakeClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBeforeConnect(        
        std::move(p_server_address));
      return true;
    }
    case messages::WebTransportHandshakeClient::kOnConnectionEstablished: {
      DCHECK(message->is_serialized());
      internal::WebTransportHandshakeClient_OnConnectionEstablished_Params_Data* params =
          reinterpret_cast<internal::WebTransportHandshakeClient_OnConnectionEstablished_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebTransportHandshakeClient.1
      bool success = true;
      ::mojo::PendingRemote<WebTransport> p_transport{};
      ::mojo::PendingReceiver<WebTransportClient> p_client{};
      ::network::mojom::blink::HttpResponseHeadersPtr p_response_headers{};
      ::blink::String p_selected_application_protocol{};
      WebTransportStatsPtr p_initial_stats{};
      WebTransportHandshakeClient_OnConnectionEstablished_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_transport =
            input_data_view.TakeTransport<decltype(p_transport)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success && !input_data_view.ReadResponseHeaders(&p_response_headers))
        success = false;
      if (success && !input_data_view.ReadSelectedApplicationProtocol(&p_selected_application_protocol))
        success = false;
      if (success && !input_data_view.ReadInitialStats(&p_initial_stats))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebTransportHandshakeClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnConnectionEstablished(        
        std::move(p_transport), 
        std::move(p_client), 
        std::move(p_response_headers), 
        std::move(p_selected_application_protocol), 
        std::move(p_initial_stats));
      return true;
    }
    case messages::WebTransportHandshakeClient::kOnHandshakeFailed: {
      DCHECK(message->is_serialized());
      internal::WebTransportHandshakeClient_OnHandshakeFailed_Params_Data* params =
          reinterpret_cast<internal::WebTransportHandshakeClient_OnHandshakeFailed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebTransportHandshakeClient.2
      bool success = true;
      WebTransportErrorPtr p_error{};
      WebTransportHandshakeClient_OnHandshakeFailed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadError(&p_error))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebTransportHandshakeClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnHandshakeFailed(        
        std::move(p_error));
      return true;
    }
  }
  return false;
}

// static
bool WebTransportHandshakeClientStubDispatch::AcceptWithResponder(
    WebTransportHandshakeClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebTransportHandshakeClient>(message->header()->name)) {
    case messages::WebTransportHandshakeClient::kOnBeforeConnect: {
      break;
    }
    case messages::WebTransportHandshakeClient::kOnConnectionEstablished: {
      break;
    }
    case messages::WebTransportHandshakeClient::kOnHandshakeFailed: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kWebTransportHandshakeClientValidationInfo[] = {
    {base::to_underlying(messages::WebTransportHandshakeClient::kOnBeforeConnect),
     { &internal::WebTransportHandshakeClient_OnBeforeConnect_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::WebTransportHandshakeClient::kOnConnectionEstablished),
     { &internal::WebTransportHandshakeClient_OnConnectionEstablished_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::WebTransportHandshakeClient::kOnHandshakeFailed),
     { &internal::WebTransportHandshakeClient_OnHandshakeFailed_Params_Data::Validate,
      nullptr /* no response */}},
};

bool WebTransportHandshakeClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::network::mojom::blink::WebTransportHandshakeClient::Name_,
    kWebTransportHandshakeClientValidationInfo);
}



}  // network::mojom::blink


namespace mojo {


// static
bool StructTraits<::network::mojom::blink::WebTransportError::DataView, ::network::mojom::blink::WebTransportErrorPtr>::Read(
    ::network::mojom::blink::WebTransportError::DataView input,
    ::network::mojom::blink::WebTransportErrorPtr* output) {
  bool success = true;
  ::network::mojom::blink::WebTransportErrorPtr result(::network::mojom::blink::WebTransportError::New());
  
      if (success)
        result->net_error = input.net_error();
      if (success)
        result->quic_error = input.quic_error();
      if (success && !input.ReadDetails(&result->details))
        success = false;
      if (success)
        result->safe_to_report_details = input.safe_to_report_details();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::WebTransportCertificateFingerprint::DataView, ::network::mojom::blink::WebTransportCertificateFingerprintPtr>::Read(
    ::network::mojom::blink::WebTransportCertificateFingerprint::DataView input,
    ::network::mojom::blink::WebTransportCertificateFingerprintPtr* output) {
  bool success = true;
  ::network::mojom::blink::WebTransportCertificateFingerprintPtr result(::network::mojom::blink::WebTransportCertificateFingerprint::New());
  
      if (success && !input.ReadAlgorithm(&result->algorithm))
        success = false;
      if (success && !input.ReadFingerprint(&result->fingerprint))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::WebTransportCloseInfo::DataView, ::network::mojom::blink::WebTransportCloseInfoPtr>::Read(
    ::network::mojom::blink::WebTransportCloseInfo::DataView input,
    ::network::mojom::blink::WebTransportCloseInfoPtr* output) {
  bool success = true;
  ::network::mojom::blink::WebTransportCloseInfoPtr result(::network::mojom::blink::WebTransportCloseInfo::New());
  
      if (success)
        result->code = input.code();
      if (success && !input.ReadReason(&result->reason))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::WebTransportStats::DataView, ::network::mojom::blink::WebTransportStatsPtr>::Read(
    ::network::mojom::blink::WebTransportStats::DataView input,
    ::network::mojom::blink::WebTransportStatsPtr* output) {
  bool success = true;
  ::network::mojom::blink::WebTransportStatsPtr result(::network::mojom::blink::WebTransportStats::New());
  
      if (success && !input.ReadTimestamp(&result->timestamp))
        success = false;
      if (success && !input.ReadMinRtt(&result->min_rtt))
        success = false;
      if (success && !input.ReadSmoothedRtt(&result->smoothed_rtt))
        success = false;
      if (success && !input.ReadRttVariation(&result->rtt_variation))
        success = false;
      if (success)
        result->estimated_send_rate_bps = input.estimated_send_rate_bps();
      if (success)
        result->datagrams_expired_outgoing = input.datagrams_expired_outgoing();
      if (success)
        result->datagrams_lost_outgoing = input.datagrams_lost_outgoing();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom::blink {


void WebTransportInterceptorForTesting::SendDatagram(::base::span<const ::uint8_t> data, SendDatagramCallback callback) {
  GetForwardingInterface()->SendDatagram(
    std::move(data)
    , std::move(callback));
}
void WebTransportInterceptorForTesting::CreateStream(::mojo::ScopedDataPipeConsumerHandle readable, ::mojo::ScopedDataPipeProducerHandle writable, CreateStreamCallback callback) {
  GetForwardingInterface()->CreateStream(
    std::move(readable)
    , 
    std::move(writable)
    , std::move(callback));
}
void WebTransportInterceptorForTesting::AcceptBidirectionalStream(AcceptBidirectionalStreamCallback callback) {
  GetForwardingInterface()->AcceptBidirectionalStream(std::move(callback));
}
void WebTransportInterceptorForTesting::AcceptUnidirectionalStream(AcceptUnidirectionalStreamCallback callback) {
  GetForwardingInterface()->AcceptUnidirectionalStream(std::move(callback));
}
void WebTransportInterceptorForTesting::SendFin(uint32_t stream_id) {
  GetForwardingInterface()->SendFin(
    std::move(stream_id)
    );
}
void WebTransportInterceptorForTesting::AbortStream(uint32_t stream_id, uint8_t code) {
  GetForwardingInterface()->AbortStream(
    std::move(stream_id)
    , 
    std::move(code)
    );
}
void WebTransportInterceptorForTesting::StopSending(uint32_t stream_id, uint8_t code) {
  GetForwardingInterface()->StopSending(
    std::move(stream_id)
    , 
    std::move(code)
    );
}
void WebTransportInterceptorForTesting::SetOutgoingDatagramExpirationDuration(::base::TimeDelta duration) {
  GetForwardingInterface()->SetOutgoingDatagramExpirationDuration(
    std::move(duration)
    );
}
void WebTransportInterceptorForTesting::GetStats(GetStatsCallback callback) {
  GetForwardingInterface()->GetStats(std::move(callback));
}
void WebTransportInterceptorForTesting::Close(WebTransportCloseInfoPtr close_info) {
  GetForwardingInterface()->Close(
    std::move(close_info)
    );
}
WebTransportAsyncWaiter::WebTransportAsyncWaiter(
    WebTransport* proxy) : proxy_(proxy) {}

WebTransportAsyncWaiter::~WebTransportAsyncWaiter() = default;


void WebTransportAsyncWaiter::SendDatagram(
    ::base::span<const ::uint8_t> data, bool* out_result) {
  base::RunLoop loop;
  proxy_->SendDatagram(
      std::move(data),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_result
,
             bool result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

bool WebTransportAsyncWaiter::SendDatagram(
    ::base::span<const ::uint8_t> data) {
  bool async_wait_result;
  SendDatagram(std::move(data),&async_wait_result);
  return async_wait_result;
}

void WebTransportAsyncWaiter::CreateStream(
    ::mojo::ScopedDataPipeConsumerHandle readable, ::mojo::ScopedDataPipeProducerHandle writable, bool* out_succeeded, uint32_t* out_stream_id) {
  base::RunLoop loop;
  proxy_->CreateStream(
      std::move(readable),
      std::move(writable),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_succeeded
,
             uint32_t* out_stream_id
,
             bool succeeded,
             uint32_t stream_id) {*out_succeeded = std::move(succeeded);*out_stream_id = std::move(stream_id);
            loop->Quit();
          },
          &loop,
          out_succeeded,
          out_stream_id));
  loop.Run();
}



void WebTransportAsyncWaiter::AcceptBidirectionalStream(
    uint32_t* out_stream_id, ::mojo::ScopedDataPipeConsumerHandle* out_readable, ::mojo::ScopedDataPipeProducerHandle* out_writable) {
  base::RunLoop loop;
  proxy_->AcceptBidirectionalStream(
      base::BindOnce(
          [](base::RunLoop* loop,
             uint32_t* out_stream_id
,
             ::mojo::ScopedDataPipeConsumerHandle* out_readable
,
             ::mojo::ScopedDataPipeProducerHandle* out_writable
,
             uint32_t stream_id,
             ::mojo::ScopedDataPipeConsumerHandle readable,
             ::mojo::ScopedDataPipeProducerHandle writable) {*out_stream_id = std::move(stream_id);*out_readable = std::move(readable);*out_writable = std::move(writable);
            loop->Quit();
          },
          &loop,
          out_stream_id,
          out_readable,
          out_writable));
  loop.Run();
}



void WebTransportAsyncWaiter::AcceptUnidirectionalStream(
    uint32_t* out_stream_id, ::mojo::ScopedDataPipeConsumerHandle* out_readable) {
  base::RunLoop loop;
  proxy_->AcceptUnidirectionalStream(
      base::BindOnce(
          [](base::RunLoop* loop,
             uint32_t* out_stream_id
,
             ::mojo::ScopedDataPipeConsumerHandle* out_readable
,
             uint32_t stream_id,
             ::mojo::ScopedDataPipeConsumerHandle readable) {*out_stream_id = std::move(stream_id);*out_readable = std::move(readable);
            loop->Quit();
          },
          &loop,
          out_stream_id,
          out_readable));
  loop.Run();
}



void WebTransportAsyncWaiter::GetStats(
    WebTransportStatsPtr* out_stats) {
  base::RunLoop loop;
  proxy_->GetStats(
      base::BindOnce(
          [](base::RunLoop* loop,
             WebTransportStatsPtr* out_stats
,
             WebTransportStatsPtr stats) {*out_stats = std::move(stats);
            loop->Quit();
          },
          &loop,
          out_stats));
  loop.Run();
}

WebTransportStatsPtr WebTransportAsyncWaiter::GetStats(
    ) {
  WebTransportStatsPtr async_wait_result;
  GetStats(&async_wait_result);
  return async_wait_result;
}




void WebTransportClientInterceptorForTesting::OnDatagramReceived(::base::span<const ::uint8_t> data) {
  GetForwardingInterface()->OnDatagramReceived(
    std::move(data)
    );
}
void WebTransportClientInterceptorForTesting::OnIncomingStreamClosed(uint32_t stream_id, bool fin_received) {
  GetForwardingInterface()->OnIncomingStreamClosed(
    std::move(stream_id)
    , 
    std::move(fin_received)
    );
}
void WebTransportClientInterceptorForTesting::OnOutgoingStreamClosed(uint32_t stream_id) {
  GetForwardingInterface()->OnOutgoingStreamClosed(
    std::move(stream_id)
    );
}
void WebTransportClientInterceptorForTesting::OnReceivedStopSending(uint32_t stream_id, uint32_t stream_error_code) {
  GetForwardingInterface()->OnReceivedStopSending(
    std::move(stream_id)
    , 
    std::move(stream_error_code)
    );
}
void WebTransportClientInterceptorForTesting::OnReceivedResetStream(uint32_t stream_id, uint32_t stream_error_code) {
  GetForwardingInterface()->OnReceivedResetStream(
    std::move(stream_id)
    , 
    std::move(stream_error_code)
    );
}
void WebTransportClientInterceptorForTesting::OnClosed(WebTransportCloseInfoPtr close_info, WebTransportStatsPtr final_stats) {
  GetForwardingInterface()->OnClosed(
    std::move(close_info)
    , 
    std::move(final_stats)
    );
}
WebTransportClientAsyncWaiter::WebTransportClientAsyncWaiter(
    WebTransportClient* proxy) : proxy_(proxy) {}

WebTransportClientAsyncWaiter::~WebTransportClientAsyncWaiter() = default;





void WebTransportHandshakeClientInterceptorForTesting::OnBeforeConnect(const ::net::IPEndPoint& server_address) {
  GetForwardingInterface()->OnBeforeConnect(
    std::move(server_address)
    );
}
void WebTransportHandshakeClientInterceptorForTesting::OnConnectionEstablished(::mojo::PendingRemote<WebTransport> transport, ::mojo::PendingReceiver<WebTransportClient> client, ::network::mojom::blink::HttpResponseHeadersPtr response_headers, const ::blink::String& selected_application_protocol, WebTransportStatsPtr initial_stats) {
  GetForwardingInterface()->OnConnectionEstablished(
    std::move(transport)
    , 
    std::move(client)
    , 
    std::move(response_headers)
    , 
    std::move(selected_application_protocol)
    , 
    std::move(initial_stats)
    );
}
void WebTransportHandshakeClientInterceptorForTesting::OnHandshakeFailed(WebTransportErrorPtr error) {
  GetForwardingInterface()->OnHandshakeFailed(
    std::move(error)
    );
}
WebTransportHandshakeClientAsyncWaiter::WebTransportHandshakeClientAsyncWaiter(
    WebTransportHandshakeClient* proxy) : proxy_(proxy) {}

WebTransportHandshakeClientAsyncWaiter::~WebTransportHandshakeClientAsyncWaiter() = default;







}  // network::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif