// services/tracing/public/mojom/perfetto_service.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_TRACING_PUBLIC_MOJOM_PERFETTO_SERVICE_MOJOM_DATA_VIEW_H_
#define SERVICES_TRACING_PUBLIC_MOJOM_PERFETTO_SERVICE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/tracing/public/mojom/perfetto_service.mojom-shared-internal.h"
#include "mojo/public/mojom/base/byte_string.mojom-shared.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/mojom/base/token.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"


namespace tracing::mojom {
class ChunksToMoveDataView;

class ChunkPatchDataView;

class ChunksToPatchDataView;

class CommitDataRequestDataView;

class ChromeConfigDataView;

class ConsoleConfigDataView;

class InterceptorConfigDataView;

class DataSourceConfigDataView;

class DataSourceRegistrationDataView;

class BufferConfigDataView;

class DataSourceDataView;

class PerfettoBuiltinDataSourceDataView;

class IncrementalStateConfigDataView;

class TraceConfigDataView;



}  // tracing::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::tracing::mojom::ChunksToMoveDataView> {
  using Data = ::tracing::mojom::internal::ChunksToMove_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tracing::mojom::ChunkPatchDataView> {
  using Data = ::tracing::mojom::internal::ChunkPatch_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tracing::mojom::ChunksToPatchDataView> {
  using Data = ::tracing::mojom::internal::ChunksToPatch_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tracing::mojom::CommitDataRequestDataView> {
  using Data = ::tracing::mojom::internal::CommitDataRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tracing::mojom::ChromeConfigDataView> {
  using Data = ::tracing::mojom::internal::ChromeConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tracing::mojom::ConsoleConfigDataView> {
  using Data = ::tracing::mojom::internal::ConsoleConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tracing::mojom::InterceptorConfigDataView> {
  using Data = ::tracing::mojom::internal::InterceptorConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tracing::mojom::DataSourceConfigDataView> {
  using Data = ::tracing::mojom::internal::DataSourceConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tracing::mojom::DataSourceRegistrationDataView> {
  using Data = ::tracing::mojom::internal::DataSourceRegistration_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tracing::mojom::BufferConfigDataView> {
  using Data = ::tracing::mojom::internal::BufferConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tracing::mojom::DataSourceDataView> {
  using Data = ::tracing::mojom::internal::DataSource_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tracing::mojom::PerfettoBuiltinDataSourceDataView> {
  using Data = ::tracing::mojom::internal::PerfettoBuiltinDataSource_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tracing::mojom::IncrementalStateConfigDataView> {
  using Data = ::tracing::mojom::internal::IncrementalStateConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tracing::mojom::TraceConfigDataView> {
  using Data = ::tracing::mojom::internal::TraceConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace tracing::mojom {


enum class ConsoleOutput : int32_t {
  
  kOutputUnspecified = 0,
  
  kOutputStdOut = 1,
  
  kOutputStdErr = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(TRACING_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, ConsoleOutput value);
inline bool IsKnownEnumValue(ConsoleOutput value) {
  return internal::ConsoleOutput_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class BufferFillPolicy : int32_t {
  
  kUnspecified = 0,
  
  kRingBuffer = 1,
  
  kDiscard = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(TRACING_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, BufferFillPolicy value);
inline bool IsKnownEnumValue(BufferFillPolicy value) {
  return internal::BufferFillPolicy_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TracingClientPriority : int32_t {
  
  kUnknown = 0,
  
  kBackground = 1,
  
  kUserInitiated = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(TRACING_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, TracingClientPriority value);
inline bool IsKnownEnumValue(TracingClientPriority value) {
  return internal::TracingClientPriority_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class ProducerHostInterfaceBase {};

using ProducerHostPtrDataView =
    mojo::InterfacePtrDataView<ProducerHostInterfaceBase>;
using ProducerHostRequestDataView =
    mojo::InterfaceRequestDataView<ProducerHostInterfaceBase>;
using ProducerHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ProducerHostInterfaceBase>;
using ProducerHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ProducerHostInterfaceBase>;
class ProducerClientInterfaceBase {};

using ProducerClientPtrDataView =
    mojo::InterfacePtrDataView<ProducerClientInterfaceBase>;
using ProducerClientRequestDataView =
    mojo::InterfaceRequestDataView<ProducerClientInterfaceBase>;
using ProducerClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ProducerClientInterfaceBase>;
using ProducerClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ProducerClientInterfaceBase>;
class PerfettoServiceInterfaceBase {};

using PerfettoServicePtrDataView =
    mojo::InterfacePtrDataView<PerfettoServiceInterfaceBase>;
using PerfettoServiceRequestDataView =
    mojo::InterfaceRequestDataView<PerfettoServiceInterfaceBase>;
using PerfettoServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PerfettoServiceInterfaceBase>;
using PerfettoServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PerfettoServiceInterfaceBase>;
class ConsumerHostInterfaceBase {};

using ConsumerHostPtrDataView =
    mojo::InterfacePtrDataView<ConsumerHostInterfaceBase>;
using ConsumerHostRequestDataView =
    mojo::InterfaceRequestDataView<ConsumerHostInterfaceBase>;
using ConsumerHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ConsumerHostInterfaceBase>;
using ConsumerHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ConsumerHostInterfaceBase>;
class TracingSessionHostInterfaceBase {};

using TracingSessionHostPtrDataView =
    mojo::InterfacePtrDataView<TracingSessionHostInterfaceBase>;
using TracingSessionHostRequestDataView =
    mojo::InterfaceRequestDataView<TracingSessionHostInterfaceBase>;
using TracingSessionHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<TracingSessionHostInterfaceBase>;
using TracingSessionHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<TracingSessionHostInterfaceBase>;
class TracingSessionClientInterfaceBase {};

using TracingSessionClientPtrDataView =
    mojo::InterfacePtrDataView<TracingSessionClientInterfaceBase>;
using TracingSessionClientRequestDataView =
    mojo::InterfaceRequestDataView<TracingSessionClientInterfaceBase>;
using TracingSessionClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<TracingSessionClientInterfaceBase>;
using TracingSessionClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<TracingSessionClientInterfaceBase>;


class ChunksToMoveDataView {
 public:
  ChunksToMoveDataView() = default;

  ChunksToMoveDataView(
      internal::ChunksToMove_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t page() const {
    return data_->page;
  }
  uint32_t chunk() const {
    return data_->chunk;
  }
  uint32_t target_buffer() const {
    return data_->target_buffer;
  }
 private:
  internal::ChunksToMove_Data* data_ = nullptr;
};


class ChunkPatchDataView {
 public:
  ChunkPatchDataView() = default;

  ChunkPatchDataView(
      internal::ChunkPatch_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t offset() const {
    return data_->offset;
  }
  inline void GetDataDataView(
      ::mojo_base::mojom::ByteStringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteStringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ChunkPatch_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ChunksToPatchDataView {
 public:
  ChunksToPatchDataView() = default;

  ChunksToPatchDataView(
      internal::ChunksToPatch_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t target_buffer() const {
    return data_->target_buffer;
  }
  uint32_t writer_id() const {
    return data_->writer_id;
  }
  uint32_t chunk_id() const {
    return data_->chunk_id;
  }
  inline void GetPatchesDataView(
      mojo::ArrayDataView<ChunkPatchDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPatches(UserType* output) {
    
    auto* pointer = data_->patches.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::tracing::mojom::ChunkPatchDataView>>(
        pointer, output, message_);
  }
  bool has_more_patches() const {
    return data_->has_more_patches;
  }
 private:
  internal::ChunksToPatch_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CommitDataRequestDataView {
 public:
  CommitDataRequestDataView() = default;

  CommitDataRequestDataView(
      internal::CommitDataRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetChunksToMoveDataView(
      mojo::ArrayDataView<ChunksToMoveDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChunksToMove(UserType* output) {
    
    auto* pointer = data_->chunks_to_move.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::tracing::mojom::ChunksToMoveDataView>>(
        pointer, output, message_);
  }
  inline void GetChunksToPatchDataView(
      mojo::ArrayDataView<ChunksToPatchDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChunksToPatch(UserType* output) {
    
    auto* pointer = data_->chunks_to_patch.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::tracing::mojom::ChunksToPatchDataView>>(
        pointer, output, message_);
  }
  uint64_t flush_request_id() const {
    return data_->flush_request_id;
  }
 private:
  internal::CommitDataRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ChromeConfigDataView {
 public:
  ChromeConfigDataView() = default;

  ChromeConfigDataView(
      internal::ChromeConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTraceConfigDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTraceConfig(UserType* output) {
    
    auto* pointer = data_->trace_config.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool privacy_filtering_enabled() const {
    return data_->privacy_filtering_enabled;
  }
  bool convert_to_legacy_json() const {
    return data_->convert_to_legacy_json;
  }
  bool event_package_name_filter_enabled() const {
    return data_->event_package_name_filter_enabled;
  }
 private:
  internal::ChromeConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ConsoleConfigDataView {
 public:
  ConsoleConfigDataView() = default;

  ConsoleConfigDataView(
      internal::ConsoleConfig_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadOutput(UserType* output) const {
    auto data_value = data_->output;
    return mojo::internal::Deserialize<::tracing::mojom::ConsoleOutput>(
        data_value, output);
  }
  ConsoleOutput output() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::tracing::mojom::ConsoleOutput>(data_->output));
  }
  bool enable_colors() const {
    return data_->enable_colors;
  }
 private:
  internal::ConsoleConfig_Data* data_ = nullptr;
};


class InterceptorConfigDataView {
 public:
  InterceptorConfigDataView() = default;

  InterceptorConfigDataView(
      internal::InterceptorConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetConsoleConfigDataView(
      ConsoleConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConsoleConfig(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::tracing::mojom::ConsoleConfigDataView, UserType>(),
    "Attempting to read the optional `console_config` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadConsoleConfig` instead "
    "of `ReadConsoleConfig if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->console_config.Get();
    return mojo::internal::Deserialize<::tracing::mojom::ConsoleConfigDataView>(
        pointer, output, message_);
  }
 private:
  internal::InterceptorConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DataSourceConfigDataView {
 public:
  DataSourceConfigDataView() = default;

  DataSourceConfigDataView(
      internal::DataSourceConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint32_t target_buffer() const {
    return data_->target_buffer;
  }
  uint32_t trace_duration_ms() const {
    return data_->trace_duration_ms;
  }
  uint64_t tracing_session_id() const {
    return data_->tracing_session_id;
  }
  inline void GetChromeConfigDataView(
      ChromeConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChromeConfig(UserType* output) {
    
    auto* pointer = data_->chrome_config.Get();
    return mojo::internal::Deserialize<::tracing::mojom::ChromeConfigDataView>(
        pointer, output, message_);
  }
  inline void GetInterceptorConfigDataView(
      InterceptorConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInterceptorConfig(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::tracing::mojom::InterceptorConfigDataView, UserType>(),
    "Attempting to read the optional `interceptor_config` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInterceptorConfig` instead "
    "of `ReadInterceptorConfig if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->interceptor_config.Get();
    return mojo::internal::Deserialize<::tracing::mojom::InterceptorConfigDataView>(
        pointer, output, message_);
  }
  inline void GetLegacyConfigDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLegacyConfig(UserType* output) {
    
    auto* pointer = data_->legacy_config.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTrackEventConfigRawDataView(
      ::mojo_base::mojom::ByteStringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrackEventConfigRaw(UserType* output) {
    
    auto* pointer = data_->track_event_config_raw.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteStringDataView>(
        pointer, output, message_);
  }
  inline void GetEtwConfigRawDataView(
      ::mojo_base::mojom::ByteStringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEtwConfigRaw(UserType* output) {
    
    auto* pointer = data_->etw_config_raw.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteStringDataView>(
        pointer, output, message_);
  }
  inline void GetSystemMetricsConfigRawDataView(
      ::mojo_base::mojom::ByteStringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSystemMetricsConfigRaw(UserType* output) {
    
    auto* pointer = data_->system_metrics_config_raw.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteStringDataView>(
        pointer, output, message_);
  }
  inline void GetHistogramSamplesConfigRawDataView(
      ::mojo_base::mojom::ByteStringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHistogramSamplesConfigRaw(UserType* output) {
    
    auto* pointer = data_->histogram_samples_config_raw.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteStringDataView>(
        pointer, output, message_);
  }
 private:
  internal::DataSourceConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DataSourceRegistrationDataView {
 public:
  DataSourceRegistrationDataView() = default;

  DataSourceRegistrationDataView(
      internal::DataSourceRegistration_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint64_t id() const {
    return data_->id;
  }
  bool will_notify_on_start() const {
    return data_->will_notify_on_start;
  }
  bool will_notify_on_stop() const {
    return data_->will_notify_on_stop;
  }
  bool handles_incremental_state_clear() const {
    return data_->handles_incremental_state_clear;
  }
 private:
  internal::DataSourceRegistration_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BufferConfigDataView {
 public:
  BufferConfigDataView() = default;

  BufferConfigDataView(
      internal::BufferConfig_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t size_kb() const {
    return data_->size_kb;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFillPolicy(UserType* output) const {
    auto data_value = data_->fill_policy;
    return mojo::internal::Deserialize<::tracing::mojom::BufferFillPolicy>(
        data_value, output);
  }
  BufferFillPolicy fill_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::tracing::mojom::BufferFillPolicy>(data_->fill_policy));
  }
 private:
  internal::BufferConfig_Data* data_ = nullptr;
};


class DataSourceDataView {
 public:
  DataSourceDataView() = default;

  DataSourceDataView(
      internal::DataSource_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetConfigDataView(
      DataSourceConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConfig(UserType* output) {
    
    auto* pointer = data_->config.Get();
    return mojo::internal::Deserialize<::tracing::mojom::DataSourceConfigDataView>(
        pointer, output, message_);
  }
  inline void GetProducerNameFilterDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProducerNameFilter(UserType* output) {
    
    auto* pointer = data_->producer_name_filter.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::DataSource_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PerfettoBuiltinDataSourceDataView {
 public:
  PerfettoBuiltinDataSourceDataView() = default;

  PerfettoBuiltinDataSourceDataView(
      internal::PerfettoBuiltinDataSource_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool disable_clock_snapshotting() const {
    return data_->disable_clock_snapshotting;
  }
  bool disable_trace_config() const {
    return data_->disable_trace_config;
  }
  bool disable_system_info() const {
    return data_->disable_system_info;
  }
  bool disable_service_events() const {
    return data_->disable_service_events;
  }
  int32_t primary_trace_clock_id() const {
    return data_->primary_trace_clock_id;
  }
 private:
  internal::PerfettoBuiltinDataSource_Data* data_ = nullptr;
};


class IncrementalStateConfigDataView {
 public:
  IncrementalStateConfigDataView() = default;

  IncrementalStateConfigDataView(
      internal::IncrementalStateConfig_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t clear_period_ms() const {
    return data_->clear_period_ms;
  }
 private:
  internal::IncrementalStateConfig_Data* data_ = nullptr;
};


class TraceConfigDataView {
 public:
  TraceConfigDataView() = default;

  TraceConfigDataView(
      internal::TraceConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDataSourcesDataView(
      mojo::ArrayDataView<DataSourceDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDataSources(UserType* output) {
    
    auto* pointer = data_->data_sources.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::tracing::mojom::DataSourceDataView>>(
        pointer, output, message_);
  }
  inline void GetPerfettoBuiltinDataSourceDataView(
      PerfettoBuiltinDataSourceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPerfettoBuiltinDataSource(UserType* output) {
    
    auto* pointer = data_->perfetto_builtin_data_source.Get();
    return mojo::internal::Deserialize<::tracing::mojom::PerfettoBuiltinDataSourceDataView>(
        pointer, output, message_);
  }
  inline void GetBuffersDataView(
      mojo::ArrayDataView<BufferConfigDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBuffers(UserType* output) {
    
    auto* pointer = data_->buffers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::tracing::mojom::BufferConfigDataView>>(
        pointer, output, message_);
  }
  inline void GetIncrementalStateConfigDataView(
      IncrementalStateConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIncrementalStateConfig(UserType* output) {
    
    auto* pointer = data_->incremental_state_config.Get();
    return mojo::internal::Deserialize<::tracing::mojom::IncrementalStateConfigDataView>(
        pointer, output, message_);
  }
  uint32_t duration_ms() const {
    return data_->duration_ms;
  }
  bool write_into_file() const {
    return data_->write_into_file;
  }
  inline void GetTraceUuidDataView(
      ::mojo_base::mojom::TokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTraceUuid(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TokenDataView, UserType>(),
    "Attempting to read the optional `trace_uuid` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTraceUuid` instead "
    "of `ReadTraceUuid if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->trace_uuid.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TokenDataView>(
        pointer, output, message_);
  }
  inline void GetUniqueSessionNameDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUniqueSessionName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `unique_session_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUniqueSessionName` instead "
    "of `ReadUniqueSessionName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->unique_session_name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::TraceConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // tracing::mojom

#endif  // SERVICES_TRACING_PUBLIC_MOJOM_PERFETTO_SERVICE_MOJOM_DATA_VIEW_H_