// services/viz/privileged/mojom/compositing/layered_window_updater.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_LAYERED_WINDOW_UPDATER_MOJOM_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_LAYERED_WINDOW_UPDATER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/privileged/mojom/compositing/layered_window_updater.mojom-features.h"  // IWYU pragma: export
#include "services/viz/privileged/mojom/compositing/layered_window_updater.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/privileged/mojom/compositing/layered_window_updater.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/shared_memory.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace viz::mojom {

class LayeredWindowUpdaterProxy;

template <typename ImplRefTraits>
class LayeredWindowUpdaterStub;

class LayeredWindowUpdaterRequestValidator;
class LayeredWindowUpdaterResponseValidator;


class LayeredWindowUpdater
    : public LayeredWindowUpdaterInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "viz.mojom.LayeredWindowUpdater";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = LayeredWindowUpdaterInterfaceBase;
  using Proxy_ = LayeredWindowUpdaterProxy;

  template <typename ImplRefTraits>
  using Stub_ = LayeredWindowUpdaterStub<ImplRefTraits>;

  using RequestValidator_ = LayeredWindowUpdaterRequestValidator;
  using ResponseValidator_ = LayeredWindowUpdaterResponseValidator;
  enum MethodMinVersions : uint32_t {
    kOnAllocatedSharedMemoryMinVersion = 0,
    kDrawMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnAllocatedSharedMemory_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Draw_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~LayeredWindowUpdater() = default;

  virtual void OnAllocatedSharedMemory(const ::gfx::Size& pixel_size, ::base::UnsafeSharedMemoryRegion region) = 0;

  using DrawCallback = base::OnceCallback<void()>;
  using DrawMojoCallback = base::OnceCallback<void()>;

  virtual void Draw(DrawCallback callback) = 0;
};



class  LayeredWindowUpdaterProxy
    : public LayeredWindowUpdater {
 public:
  using InterfaceType = LayeredWindowUpdater;

  explicit LayeredWindowUpdaterProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnAllocatedSharedMemory(const ::gfx::Size& pixel_size, ::base::UnsafeSharedMemoryRegion region) final;
  
  void Draw(DrawCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  LayeredWindowUpdaterStubDispatch {
 public:
  static bool Accept(LayeredWindowUpdater* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      LayeredWindowUpdater* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<LayeredWindowUpdater>>
class LayeredWindowUpdaterStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  LayeredWindowUpdaterStub() = default;
  ~LayeredWindowUpdaterStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LayeredWindowUpdaterStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LayeredWindowUpdaterStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  LayeredWindowUpdaterRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  LayeredWindowUpdaterResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // viz::mojom

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_LAYERED_WINDOW_UPDATER_MOJOM_H_