// third_party/blink/public/mojom/choosers/file_chooser.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CHOOSERS_FILE_CHOOSER_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CHOOSERS_FILE_CHOOSER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/choosers/file_chooser.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/choosers/file_chooser.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/choosers/file_chooser.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class FileChooserProxy;

template <typename ImplRefTraits>
class FileChooserStub;

class FileChooserRequestValidator;
class FileChooserResponseValidator;


class BLINK_COMMON_EXPORT FileChooser
    : public FileChooserInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.FileChooser";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FileChooserInterfaceBase;
  using Proxy_ = FileChooserProxy;

  template <typename ImplRefTraits>
  using Stub_ = FileChooserStub<ImplRefTraits>;

  using RequestValidator_ = FileChooserRequestValidator;
  using ResponseValidator_ = FileChooserResponseValidator;
  enum MethodMinVersions : uint32_t {
    kOpenFileChooserMinVersion = 0,
    kEnumerateChosenDirectoryMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OpenFileChooser_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnumerateChosenDirectory_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FileChooser() = default;

  using OpenFileChooserCallback = base::OnceCallback<void(FileChooserResultPtr)>;
  using OpenFileChooserMojoCallback = base::OnceCallback<void(FileChooserResultPtr)>;

  virtual void OpenFileChooser(FileChooserParamsPtr params, OpenFileChooserCallback callback) = 0;

  using EnumerateChosenDirectoryCallback = base::OnceCallback<void(FileChooserResultPtr)>;
  using EnumerateChosenDirectoryMojoCallback = base::OnceCallback<void(FileChooserResultPtr)>;

  virtual void EnumerateChosenDirectory(const ::base::FilePath& directory_path, EnumerateChosenDirectoryCallback callback) = 0;
};



class BLINK_COMMON_EXPORT FileChooserProxy
    : public FileChooser {
 public:
  using InterfaceType = FileChooser;

  explicit FileChooserProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OpenFileChooser(FileChooserParamsPtr params, OpenFileChooserCallback callback) final;
  
  void EnumerateChosenDirectory(const ::base::FilePath& directory_path, EnumerateChosenDirectoryCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT FileChooserStubDispatch {
 public:
  static bool Accept(FileChooser* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FileChooser* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FileChooser>>
class FileChooserStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FileChooserStub() = default;
  ~FileChooserStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FileChooserStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FileChooserStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT FileChooserRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT FileChooserResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class BLINK_COMMON_EXPORT FileChooserFileInfo {
 public:
  using DataView = FileChooserFileInfoDataView;
  using Data_ = internal::FileChooserFileInfo_Data;
  using Tag = Data_::FileChooserFileInfo_Tag;

  template <typename... Args>
  static FileChooserFileInfoPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |native_file|.
  static FileChooserFileInfoPtr NewNativeFile(
      NativeFileInfoPtr value);
  // Construct an instance holding |file_system|.
  static FileChooserFileInfoPtr NewFileSystem(
      FileSystemFileInfoPtr value);

  template <typename U>
  static FileChooserFileInfoPtr From(const U& u) {
    return mojo::TypeConverter<FileChooserFileInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FileChooserFileInfo>::Convert(*this);
  }
  ~FileChooserFileInfo();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  FileChooserFileInfo(const FileChooserFileInfo& other) = delete;
  FileChooserFileInfo& operator=(const FileChooserFileInfo& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = FileChooserFileInfoPtr>
  FileChooserFileInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, FileChooserFileInfo>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, FileChooserFileInfo>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_native_file() const { return tag_ == Tag::kNativeFile; }
  const NativeFileInfoPtr& get_native_file() const {
    CHECK(tag_ == Tag::kNativeFile);
    return data_.native_file;
  }
  NativeFileInfoPtr& get_native_file() {
    CHECK(tag_ == Tag::kNativeFile);
    return data_.native_file;
  }
  void set_native_file(NativeFileInfoPtr native_file);

  bool is_file_system() const { return tag_ == Tag::kFileSystem; }
  const FileSystemFileInfoPtr& get_file_system() const {
    CHECK(tag_ == Tag::kFileSystem);
    return data_.file_system;
  }
  FileSystemFileInfoPtr& get_file_system() {
    CHECK(tag_ == Tag::kFileSystem);
    return data_.file_system;
  }
  void set_file_system(FileSystemFileInfoPtr file_system);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FileChooserFileInfo::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<FileChooserFileInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kNativeFile)>,
        NativeFileInfoPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFileSystem)>,
        FileSystemFileInfoPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    NativeFileInfoPtr native_file;
    FileSystemFileInfoPtr file_system;
  };

  FileChooserFileInfo(
      std::in_place_index_t<static_cast<size_t>(Tag::kNativeFile)>,
      NativeFileInfoPtr value);
  FileChooserFileInfo(
      std::in_place_index_t<static_cast<size_t>(Tag::kFileSystem)>,
      FileSystemFileInfoPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class BLINK_COMMON_EXPORT FileChooserParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FileChooserParams, T>::value>;
  using DataView = FileChooserParamsDataView;
  using Data_ = internal::FileChooserParams_Data;
  using Mode = FileChooserParams_Mode;

  template <typename... Args>
  static FileChooserParamsPtr New(Args&&... args) {
    return FileChooserParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FileChooserParamsPtr From(const U& u) {
    return mojo::TypeConverter<FileChooserParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FileChooserParams>::Convert(*this);
  }


  FileChooserParams();

  FileChooserParams(
      FileChooserParams::Mode mode,
      const ::std::u16string& title,
      const ::base::FilePath& default_file_name,
      std::vector<::base::FilePath> selected_files,
      std::vector<::std::u16string> accept_types,
      bool need_local_path,
      bool use_media_capture,
      bool open_writable,
      const ::GURL& requestor);


  ~FileChooserParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FileChooserParamsPtr>
  FileChooserParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FileChooserParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FileChooserParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FileChooserParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FileChooserParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FileChooserParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FileChooserParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FileChooserParams_UnserializedMessageContext<
            UserType, FileChooserParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FileChooserParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FileChooserParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FileChooserParams_UnserializedMessageContext<
            UserType, FileChooserParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FileChooserParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  FileChooserParams::Mode mode;
  
  ::std::u16string title;
  
  ::base::FilePath default_file_name;
  
  std::vector<::base::FilePath> selected_files;
  
  std::vector<::std::u16string> accept_types;
  
  bool need_local_path;
  
  bool use_media_capture;
  
  bool open_writable;
  
  ::GURL requestor;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FileChooserParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FileChooserParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FileChooserParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FileChooserParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT NativeFileInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NativeFileInfo, T>::value>;
  using DataView = NativeFileInfoDataView;
  using Data_ = internal::NativeFileInfo_Data;

  template <typename... Args>
  static NativeFileInfoPtr New(Args&&... args) {
    return NativeFileInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NativeFileInfoPtr From(const U& u) {
    return mojo::TypeConverter<NativeFileInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NativeFileInfo>::Convert(*this);
  }


  NativeFileInfo();

  NativeFileInfo(
      const ::base::FilePath& file_path,
      const ::std::u16string& display_name,
      std::vector<::std::u16string> base_subdirs);


  ~NativeFileInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NativeFileInfoPtr>
  NativeFileInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NativeFileInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NativeFileInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NativeFileInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NativeFileInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NativeFileInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NativeFileInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NativeFileInfo_UnserializedMessageContext<
            UserType, NativeFileInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NativeFileInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NativeFileInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NativeFileInfo_UnserializedMessageContext<
            UserType, NativeFileInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NativeFileInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::FilePath file_path;
  
  ::std::u16string display_name;
  
  std::vector<::std::u16string> base_subdirs;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NativeFileInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NativeFileInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NativeFileInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NativeFileInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT FileSystemFileInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FileSystemFileInfo, T>::value>;
  using DataView = FileSystemFileInfoDataView;
  using Data_ = internal::FileSystemFileInfo_Data;

  template <typename... Args>
  static FileSystemFileInfoPtr New(Args&&... args) {
    return FileSystemFileInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FileSystemFileInfoPtr From(const U& u) {
    return mojo::TypeConverter<FileSystemFileInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FileSystemFileInfo>::Convert(*this);
  }


  FileSystemFileInfo();

  FileSystemFileInfo(
      const ::GURL& url,
      ::base::Time modification_time,
      int64_t length);


  ~FileSystemFileInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FileSystemFileInfoPtr>
  FileSystemFileInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FileSystemFileInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FileSystemFileInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FileSystemFileInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FileSystemFileInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FileSystemFileInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FileSystemFileInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FileSystemFileInfo_UnserializedMessageContext<
            UserType, FileSystemFileInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FileSystemFileInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FileSystemFileInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FileSystemFileInfo_UnserializedMessageContext<
            UserType, FileSystemFileInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FileSystemFileInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL url;
  
  ::base::Time modification_time;
  
  int64_t length;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FileSystemFileInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FileSystemFileInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FileSystemFileInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FileSystemFileInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT FileChooserResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FileChooserResult, T>::value>;
  using DataView = FileChooserResultDataView;
  using Data_ = internal::FileChooserResult_Data;

  template <typename... Args>
  static FileChooserResultPtr New(Args&&... args) {
    return FileChooserResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FileChooserResultPtr From(const U& u) {
    return mojo::TypeConverter<FileChooserResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FileChooserResult>::Convert(*this);
  }


  FileChooserResult();

  FileChooserResult(
      std::vector<FileChooserFileInfoPtr> files,
      const ::base::FilePath& base_directory);

FileChooserResult(const FileChooserResult&) = delete;
FileChooserResult& operator=(const FileChooserResult&) = delete;

  ~FileChooserResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FileChooserResultPtr>
  FileChooserResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FileChooserResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FileChooserResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FileChooserResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FileChooserResult::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FileChooserResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FileChooserResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FileChooserResult_UnserializedMessageContext<
            UserType, FileChooserResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FileChooserResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FileChooserResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FileChooserResult_UnserializedMessageContext<
            UserType, FileChooserResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FileChooserResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<FileChooserFileInfoPtr> files;
  
  ::base::FilePath base_directory;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FileChooserResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FileChooserResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FileChooserResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FileChooserResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
FileChooserFileInfoPtr FileChooserFileInfo::Clone() const {
  switch (tag_) {
    case Tag::kNativeFile:
      return NewNativeFile(
          mojo::Clone(data_.native_file));
    case Tag::kFileSystem:
      return NewFileSystem(
          mojo::Clone(data_.file_system));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, FileChooserFileInfo>::value>::type*>
bool FileChooserFileInfo::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kNativeFile:
      return mojo::Equals(data_.native_file, other.data_.native_file);
    case Tag::kFileSystem:
      return mojo::Equals(data_.file_system, other.data_.file_system);
  }

  return false;
}
template <typename StructPtrType>
FileChooserParamsPtr FileChooserParams::Clone() const {
  return New(
      mojo::Clone(mode),
      mojo::Clone(title),
      mojo::Clone(default_file_name),
      mojo::Clone(selected_files),
      mojo::Clone(accept_types),
      mojo::Clone(need_local_path),
      mojo::Clone(use_media_capture),
      mojo::Clone(open_writable),
      mojo::Clone(requestor)
  );
}

template <typename T, FileChooserParams::EnableIfSame<T>*>
bool FileChooserParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mode, other_struct.mode))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->default_file_name, other_struct.default_file_name))
    return false;
  if (!mojo::Equals(this->selected_files, other_struct.selected_files))
    return false;
  if (!mojo::Equals(this->accept_types, other_struct.accept_types))
    return false;
  if (!mojo::Equals(this->need_local_path, other_struct.need_local_path))
    return false;
  if (!mojo::Equals(this->use_media_capture, other_struct.use_media_capture))
    return false;
  if (!mojo::Equals(this->open_writable, other_struct.open_writable))
    return false;
  if (!mojo::Equals(this->requestor, other_struct.requestor))
    return false;
  return true;
}

template <typename T, FileChooserParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.mode < rhs.mode)
    return true;
  if (rhs.mode < lhs.mode)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.default_file_name < rhs.default_file_name)
    return true;
  if (rhs.default_file_name < lhs.default_file_name)
    return false;
  if (lhs.selected_files < rhs.selected_files)
    return true;
  if (rhs.selected_files < lhs.selected_files)
    return false;
  if (lhs.accept_types < rhs.accept_types)
    return true;
  if (rhs.accept_types < lhs.accept_types)
    return false;
  if (lhs.need_local_path < rhs.need_local_path)
    return true;
  if (rhs.need_local_path < lhs.need_local_path)
    return false;
  if (lhs.use_media_capture < rhs.use_media_capture)
    return true;
  if (rhs.use_media_capture < lhs.use_media_capture)
    return false;
  if (lhs.open_writable < rhs.open_writable)
    return true;
  if (rhs.open_writable < lhs.open_writable)
    return false;
  if (lhs.requestor < rhs.requestor)
    return true;
  if (rhs.requestor < lhs.requestor)
    return false;
  return false;
}
template <typename StructPtrType>
NativeFileInfoPtr NativeFileInfo::Clone() const {
  return New(
      mojo::Clone(file_path),
      mojo::Clone(display_name),
      mojo::Clone(base_subdirs)
  );
}

template <typename T, NativeFileInfo::EnableIfSame<T>*>
bool NativeFileInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->file_path, other_struct.file_path))
    return false;
  if (!mojo::Equals(this->display_name, other_struct.display_name))
    return false;
  if (!mojo::Equals(this->base_subdirs, other_struct.base_subdirs))
    return false;
  return true;
}

template <typename T, NativeFileInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.file_path < rhs.file_path)
    return true;
  if (rhs.file_path < lhs.file_path)
    return false;
  if (lhs.display_name < rhs.display_name)
    return true;
  if (rhs.display_name < lhs.display_name)
    return false;
  if (lhs.base_subdirs < rhs.base_subdirs)
    return true;
  if (rhs.base_subdirs < lhs.base_subdirs)
    return false;
  return false;
}
template <typename StructPtrType>
FileSystemFileInfoPtr FileSystemFileInfo::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(modification_time),
      mojo::Clone(length)
  );
}

template <typename T, FileSystemFileInfo::EnableIfSame<T>*>
bool FileSystemFileInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->modification_time, other_struct.modification_time))
    return false;
  if (!mojo::Equals(this->length, other_struct.length))
    return false;
  return true;
}

template <typename T, FileSystemFileInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.modification_time < rhs.modification_time)
    return true;
  if (rhs.modification_time < lhs.modification_time)
    return false;
  if (lhs.length < rhs.length)
    return true;
  if (rhs.length < lhs.length)
    return false;
  return false;
}
template <typename StructPtrType>
FileChooserResultPtr FileChooserResult::Clone() const {
  return New(
      mojo::Clone(files),
      mojo::Clone(base_directory)
  );
}

template <typename T, FileChooserResult::EnableIfSame<T>*>
bool FileChooserResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->files, other_struct.files))
    return false;
  if (!mojo::Equals(this->base_directory, other_struct.base_directory))
    return false;
  return true;
}

template <typename T, FileChooserResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.files < rhs.files)
    return true;
  if (rhs.files < lhs.files)
    return false;
  if (lhs.base_directory < rhs.base_directory)
    return true;
  if (rhs.base_directory < lhs.base_directory)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::FileChooserParams::DataView,
                                         ::blink::mojom::FileChooserParamsPtr> {
  static bool IsNull(const ::blink::mojom::FileChooserParamsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::FileChooserParamsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::FileChooserParams::mode) mode(
      const ::blink::mojom::FileChooserParamsPtr& input) {
    return input->mode;
  }

  static const decltype(::blink::mojom::FileChooserParams::title)& title(
      const ::blink::mojom::FileChooserParamsPtr& input) {
    return input->title;
  }

  static const decltype(::blink::mojom::FileChooserParams::default_file_name)& default_file_name(
      const ::blink::mojom::FileChooserParamsPtr& input) {
    return input->default_file_name;
  }

  static const decltype(::blink::mojom::FileChooserParams::selected_files)& selected_files(
      const ::blink::mojom::FileChooserParamsPtr& input) {
    return input->selected_files;
  }

  static const decltype(::blink::mojom::FileChooserParams::accept_types)& accept_types(
      const ::blink::mojom::FileChooserParamsPtr& input) {
    return input->accept_types;
  }

  static decltype(::blink::mojom::FileChooserParams::need_local_path) need_local_path(
      const ::blink::mojom::FileChooserParamsPtr& input) {
    return input->need_local_path;
  }

  static decltype(::blink::mojom::FileChooserParams::use_media_capture) use_media_capture(
      const ::blink::mojom::FileChooserParamsPtr& input) {
    return input->use_media_capture;
  }

  static decltype(::blink::mojom::FileChooserParams::open_writable) open_writable(
      const ::blink::mojom::FileChooserParamsPtr& input) {
    return input->open_writable;
  }

  static const decltype(::blink::mojom::FileChooserParams::requestor)& requestor(
      const ::blink::mojom::FileChooserParamsPtr& input) {
    return input->requestor;
  }

  static bool Read(::blink::mojom::FileChooserParams::DataView input, ::blink::mojom::FileChooserParamsPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::NativeFileInfo::DataView,
                                         ::blink::mojom::NativeFileInfoPtr> {
  static bool IsNull(const ::blink::mojom::NativeFileInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::NativeFileInfoPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::NativeFileInfo::file_path)& file_path(
      const ::blink::mojom::NativeFileInfoPtr& input) {
    return input->file_path;
  }

  static const decltype(::blink::mojom::NativeFileInfo::display_name)& display_name(
      const ::blink::mojom::NativeFileInfoPtr& input) {
    return input->display_name;
  }

  static const decltype(::blink::mojom::NativeFileInfo::base_subdirs)& base_subdirs(
      const ::blink::mojom::NativeFileInfoPtr& input) {
    return input->base_subdirs;
  }

  static bool Read(::blink::mojom::NativeFileInfo::DataView input, ::blink::mojom::NativeFileInfoPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::FileSystemFileInfo::DataView,
                                         ::blink::mojom::FileSystemFileInfoPtr> {
  static bool IsNull(const ::blink::mojom::FileSystemFileInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::FileSystemFileInfoPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::FileSystemFileInfo::url)& url(
      const ::blink::mojom::FileSystemFileInfoPtr& input) {
    return input->url;
  }

  static const decltype(::blink::mojom::FileSystemFileInfo::modification_time)& modification_time(
      const ::blink::mojom::FileSystemFileInfoPtr& input) {
    return input->modification_time;
  }

  static decltype(::blink::mojom::FileSystemFileInfo::length) length(
      const ::blink::mojom::FileSystemFileInfoPtr& input) {
    return input->length;
  }

  static bool Read(::blink::mojom::FileSystemFileInfo::DataView input, ::blink::mojom::FileSystemFileInfoPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::FileChooserResult::DataView,
                                         ::blink::mojom::FileChooserResultPtr> {
  static bool IsNull(const ::blink::mojom::FileChooserResultPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::FileChooserResultPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::FileChooserResult::files)& files(
      const ::blink::mojom::FileChooserResultPtr& input) {
    return input->files;
  }

  static const decltype(::blink::mojom::FileChooserResult::base_directory)& base_directory(
      const ::blink::mojom::FileChooserResultPtr& input) {
    return input->base_directory;
  }

  static bool Read(::blink::mojom::FileChooserResult::DataView input, ::blink::mojom::FileChooserResultPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::FileChooserFileInfo::DataView,
                                        ::blink::mojom::FileChooserFileInfoPtr> {
  static bool IsNull(const ::blink::mojom::FileChooserFileInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::FileChooserFileInfoPtr* output) { output->reset(); }

  static ::blink::mojom::FileChooserFileInfo::Tag GetTag(const ::blink::mojom::FileChooserFileInfoPtr& input) {
    return input->which();
  }

  static const ::blink::mojom::NativeFileInfoPtr& native_file(const ::blink::mojom::FileChooserFileInfoPtr& input) {
    return input->get_native_file();
  }

  static const ::blink::mojom::FileSystemFileInfoPtr& file_system(const ::blink::mojom::FileChooserFileInfoPtr& input) {
    return input->get_file_system();
  }

  static bool Read(::blink::mojom::FileChooserFileInfo::DataView input, ::blink::mojom::FileChooserFileInfoPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CHOOSERS_FILE_CHOOSER_MOJOM_H_