// third_party/blink/public/mojom/direct_sockets/direct_sockets.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/direct_sockets/direct_sockets.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/direct_sockets/direct_sockets.mojom-params-data.h"
namespace blink {
namespace mojom {

namespace internal {


// static
bool DirectTCPSocketOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DirectTCPSocketOptions_Data* object =
      static_cast<const DirectTCPSocketOptions_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->remote_addr, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->remote_addr, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->keep_alive_options, validation_context))
    return false;


  if (!::network::mojom::internal::DnsQueryType_Data
        ::Validate(object->dns_query_type_$value, validation_context))
    return false;

  return true;
}

DirectTCPSocketOptions_Data::DirectTCPSocketOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DirectConnectedUDPSocketOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DirectConnectedUDPSocketOptions_Data* object =
      static_cast<const DirectConnectedUDPSocketOptions_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->remote_addr, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->remote_addr, validation_context))
    return false;


  if (!::network::mojom::internal::DnsQueryType_Data
        ::Validate(object->dns_query_type_$value, validation_context))
    return false;

  return true;
}

DirectConnectedUDPSocketOptions_Data::DirectConnectedUDPSocketOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DirectBoundUDPSocketOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DirectBoundUDPSocketOptions_Data* object =
      static_cast<const DirectBoundUDPSocketOptions_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->local_addr, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->local_addr, validation_context))
    return false;

  return true;
}

DirectBoundUDPSocketOptions_Data::DirectBoundUDPSocketOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DirectTCPServerSocketOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DirectTCPServerSocketOptions_Data* object =
      static_cast<const DirectTCPServerSocketOptions_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->local_addr, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->local_addr, validation_context))
    return false;

  return true;
}

DirectTCPServerSocketOptions_Data::DirectTCPServerSocketOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DirectSocketsService_OpenTCPSocket_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DirectSocketsService_OpenTCPSocket_Params_Data* object =
      static_cast<const DirectSocketsService_OpenTCPSocket_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

DirectSocketsService_OpenTCPSocket_Params_Data::DirectSocketsService_OpenTCPSocket_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DirectSocketsService_OpenTCPSocket_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DirectSocketsService_OpenTCPSocket_ResponseParams_Data* object =
      static_cast<const DirectSocketsService_OpenTCPSocket_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->local_addr, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->peer_addr, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->receive_stream,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->send_stream,
                                                 validation_context)) {
    return false;
  }

  return true;
}

DirectSocketsService_OpenTCPSocket_ResponseParams_Data::DirectSocketsService_OpenTCPSocket_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DirectSocketsService_OpenConnectedUDPSocket_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DirectSocketsService_OpenConnectedUDPSocket_Params_Data* object =
      static_cast<const DirectSocketsService_OpenConnectedUDPSocket_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->listener,
                                                 validation_context)) {
    return false;
  }

  return true;
}

DirectSocketsService_OpenConnectedUDPSocket_Params_Data::DirectSocketsService_OpenConnectedUDPSocket_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DirectSocketsService_OpenConnectedUDPSocket_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DirectSocketsService_OpenConnectedUDPSocket_ResponseParams_Data* object =
      static_cast<const DirectSocketsService_OpenConnectedUDPSocket_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->local_addr, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->peer_addr, validation_context))
    return false;

  return true;
}

DirectSocketsService_OpenConnectedUDPSocket_ResponseParams_Data::DirectSocketsService_OpenConnectedUDPSocket_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DirectSocketsService_OpenBoundUDPSocket_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DirectSocketsService_OpenBoundUDPSocket_Params_Data* object =
      static_cast<const DirectSocketsService_OpenBoundUDPSocket_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->listener,
                                                 validation_context)) {
    return false;
  }

  return true;
}

DirectSocketsService_OpenBoundUDPSocket_Params_Data::DirectSocketsService_OpenBoundUDPSocket_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DirectSocketsService_OpenBoundUDPSocket_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DirectSocketsService_OpenBoundUDPSocket_ResponseParams_Data* object =
      static_cast<const DirectSocketsService_OpenBoundUDPSocket_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->local_addr, validation_context))
    return false;

  return true;
}

DirectSocketsService_OpenBoundUDPSocket_ResponseParams_Data::DirectSocketsService_OpenBoundUDPSocket_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DirectSocketsService_OpenTCPServerSocket_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DirectSocketsService_OpenTCPServerSocket_Params_Data* object =
      static_cast<const DirectSocketsService_OpenTCPServerSocket_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

DirectSocketsService_OpenTCPServerSocket_Params_Data::DirectSocketsService_OpenTCPServerSocket_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DirectSocketsService_OpenTCPServerSocket_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DirectSocketsService_OpenTCPServerSocket_ResponseParams_Data* object =
      static_cast<const DirectSocketsService_OpenTCPServerSocket_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->local_addr, validation_context))
    return false;

  return true;
}

DirectSocketsService_OpenTCPServerSocket_ResponseParams_Data::DirectSocketsService_OpenTCPServerSocket_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink