// third_party/blink/public/mojom/speech/speech_synthesis.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SPEECH_SPEECH_SYNTHESIS_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SPEECH_SPEECH_SYNTHESIS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/speech/speech_synthesis.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/speech/speech_synthesis.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/speech/speech_synthesis.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class SpeechSynthesisVoiceListObserverProxy;

template <typename ImplRefTraits>
class SpeechSynthesisVoiceListObserverStub;

class SpeechSynthesisVoiceListObserverRequestValidator;


class BLINK_COMMON_EXPORT SpeechSynthesisVoiceListObserver
    : public SpeechSynthesisVoiceListObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.SpeechSynthesisVoiceListObserver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SpeechSynthesisVoiceListObserverInterfaceBase;
  using Proxy_ = SpeechSynthesisVoiceListObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = SpeechSynthesisVoiceListObserverStub<ImplRefTraits>;

  using RequestValidator_ = SpeechSynthesisVoiceListObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnSetVoiceListMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnSetVoiceList_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SpeechSynthesisVoiceListObserver() = default;

  virtual void OnSetVoiceList(std::vector<SpeechSynthesisVoicePtr> voice_list) = 0;
};

class SpeechSynthesisClientProxy;

template <typename ImplRefTraits>
class SpeechSynthesisClientStub;

class SpeechSynthesisClientRequestValidator;


class BLINK_COMMON_EXPORT SpeechSynthesisClient
    : public SpeechSynthesisClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.SpeechSynthesisClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SpeechSynthesisClientInterfaceBase;
  using Proxy_ = SpeechSynthesisClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = SpeechSynthesisClientStub<ImplRefTraits>;

  using RequestValidator_ = SpeechSynthesisClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnStartedSpeakingMinVersion = 0,
    kOnFinishedSpeakingMinVersion = 0,
    kOnPausedSpeakingMinVersion = 0,
    kOnResumedSpeakingMinVersion = 0,
    kOnEncounteredWordBoundaryMinVersion = 0,
    kOnEncounteredSentenceBoundaryMinVersion = 0,
    kOnEncounteredSpeakingErrorMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnStartedSpeaking_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnFinishedSpeaking_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnPausedSpeaking_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnResumedSpeaking_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnEncounteredWordBoundary_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnEncounteredSentenceBoundary_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnEncounteredSpeakingError_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SpeechSynthesisClient() = default;

  virtual void OnStartedSpeaking() = 0;

  virtual void OnFinishedSpeaking(SpeechSynthesisErrorCode error_code) = 0;

  virtual void OnPausedSpeaking() = 0;

  virtual void OnResumedSpeaking() = 0;

  virtual void OnEncounteredWordBoundary(uint32_t char_index, uint32_t char_length) = 0;

  virtual void OnEncounteredSentenceBoundary(uint32_t char_index, uint32_t char_length) = 0;

  virtual void OnEncounteredSpeakingError() = 0;
};

class SpeechSynthesisProxy;

template <typename ImplRefTraits>
class SpeechSynthesisStub;

class SpeechSynthesisRequestValidator;


class BLINK_COMMON_EXPORT SpeechSynthesis
    : public SpeechSynthesisInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.SpeechSynthesis";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SpeechSynthesisInterfaceBase;
  using Proxy_ = SpeechSynthesisProxy;

  template <typename ImplRefTraits>
  using Stub_ = SpeechSynthesisStub<ImplRefTraits>;

  using RequestValidator_ = SpeechSynthesisRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kAddVoiceListObserverMinVersion = 0,
    kSpeakMinVersion = 0,
    kPauseMinVersion = 0,
    kResumeMinVersion = 0,
    kCancelMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct AddVoiceListObserver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Speak_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Pause_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Resume_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Cancel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SpeechSynthesis() = default;

  virtual void AddVoiceListObserver(::mojo::PendingRemote<SpeechSynthesisVoiceListObserver> observer) = 0;

  virtual void Speak(SpeechSynthesisUtterancePtr utterance, ::mojo::PendingRemote<SpeechSynthesisClient> client) = 0;

  virtual void Pause() = 0;

  virtual void Resume() = 0;

  virtual void Cancel() = 0;
};



class BLINK_COMMON_EXPORT SpeechSynthesisVoiceListObserverProxy
    : public SpeechSynthesisVoiceListObserver {
 public:
  using InterfaceType = SpeechSynthesisVoiceListObserver;

  explicit SpeechSynthesisVoiceListObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnSetVoiceList(std::vector<SpeechSynthesisVoicePtr> voice_list) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT SpeechSynthesisClientProxy
    : public SpeechSynthesisClient {
 public:
  using InterfaceType = SpeechSynthesisClient;

  explicit SpeechSynthesisClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnStartedSpeaking() final;
  
  void OnFinishedSpeaking(SpeechSynthesisErrorCode error_code) final;
  
  void OnPausedSpeaking() final;
  
  void OnResumedSpeaking() final;
  
  void OnEncounteredWordBoundary(uint32_t char_index, uint32_t char_length) final;
  
  void OnEncounteredSentenceBoundary(uint32_t char_index, uint32_t char_length) final;
  
  void OnEncounteredSpeakingError() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT SpeechSynthesisProxy
    : public SpeechSynthesis {
 public:
  using InterfaceType = SpeechSynthesis;

  explicit SpeechSynthesisProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AddVoiceListObserver(::mojo::PendingRemote<SpeechSynthesisVoiceListObserver> observer) final;
  
  void Speak(SpeechSynthesisUtterancePtr utterance, ::mojo::PendingRemote<SpeechSynthesisClient> client) final;
  
  void Pause() final;
  
  void Resume() final;
  
  void Cancel() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT SpeechSynthesisVoiceListObserverStubDispatch {
 public:
  static bool Accept(SpeechSynthesisVoiceListObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SpeechSynthesisVoiceListObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SpeechSynthesisVoiceListObserver>>
class SpeechSynthesisVoiceListObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SpeechSynthesisVoiceListObserverStub() = default;
  ~SpeechSynthesisVoiceListObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechSynthesisVoiceListObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechSynthesisVoiceListObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT SpeechSynthesisClientStubDispatch {
 public:
  static bool Accept(SpeechSynthesisClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SpeechSynthesisClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SpeechSynthesisClient>>
class SpeechSynthesisClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SpeechSynthesisClientStub() = default;
  ~SpeechSynthesisClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechSynthesisClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechSynthesisClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT SpeechSynthesisStubDispatch {
 public:
  static bool Accept(SpeechSynthesis* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SpeechSynthesis* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SpeechSynthesis>>
class SpeechSynthesisStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SpeechSynthesisStub() = default;
  ~SpeechSynthesisStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechSynthesisStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechSynthesisStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT SpeechSynthesisVoiceListObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT SpeechSynthesisClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT SpeechSynthesisRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class BLINK_COMMON_EXPORT SpeechSynthesisUtterance {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SpeechSynthesisUtterance, T>::value>;
  using DataView = SpeechSynthesisUtteranceDataView;
  using Data_ = internal::SpeechSynthesisUtterance_Data;

  template <typename... Args>
  static SpeechSynthesisUtterancePtr New(Args&&... args) {
    return SpeechSynthesisUtterancePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SpeechSynthesisUtterancePtr From(const U& u) {
    return mojo::TypeConverter<SpeechSynthesisUtterancePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SpeechSynthesisUtterance>::Convert(*this);
  }


  SpeechSynthesisUtterance();

  SpeechSynthesisUtterance(
      const std::string& text,
      const std::string& lang,
      const std::string& voice,
      double volume,
      double rate,
      double pitch);


  ~SpeechSynthesisUtterance();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SpeechSynthesisUtterancePtr>
  SpeechSynthesisUtterancePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SpeechSynthesisUtterance::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SpeechSynthesisUtterance::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SpeechSynthesisUtterance::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SpeechSynthesisUtterance::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SpeechSynthesisUtterance::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SpeechSynthesisUtterance::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SpeechSynthesisUtterance_UnserializedMessageContext<
            UserType, SpeechSynthesisUtterance::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SpeechSynthesisUtterance::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SpeechSynthesisUtterance::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SpeechSynthesisUtterance_UnserializedMessageContext<
            UserType, SpeechSynthesisUtterance::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SpeechSynthesisUtterance::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string text;
  
  std::string lang;
  
  std::string voice;
  
  double volume;
  
  double rate;
  
  double pitch;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SpeechSynthesisUtterance::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SpeechSynthesisUtterance::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SpeechSynthesisUtterance::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SpeechSynthesisUtterance::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT SpeechSynthesisVoice {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SpeechSynthesisVoice, T>::value>;
  using DataView = SpeechSynthesisVoiceDataView;
  using Data_ = internal::SpeechSynthesisVoice_Data;

  template <typename... Args>
  static SpeechSynthesisVoicePtr New(Args&&... args) {
    return SpeechSynthesisVoicePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SpeechSynthesisVoicePtr From(const U& u) {
    return mojo::TypeConverter<SpeechSynthesisVoicePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SpeechSynthesisVoice>::Convert(*this);
  }


  SpeechSynthesisVoice();

  SpeechSynthesisVoice(
      const std::string& voice_uri,
      const std::string& name,
      const std::string& lang,
      bool is_local_service,
      bool is_default);


  ~SpeechSynthesisVoice();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SpeechSynthesisVoicePtr>
  SpeechSynthesisVoicePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SpeechSynthesisVoice::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SpeechSynthesisVoice::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SpeechSynthesisVoice::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SpeechSynthesisVoice::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SpeechSynthesisVoice::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SpeechSynthesisVoice::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SpeechSynthesisVoice_UnserializedMessageContext<
            UserType, SpeechSynthesisVoice::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SpeechSynthesisVoice::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SpeechSynthesisVoice::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SpeechSynthesisVoice_UnserializedMessageContext<
            UserType, SpeechSynthesisVoice::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SpeechSynthesisVoice::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string voice_uri;
  
  std::string name;
  
  std::string lang;
  
  bool is_local_service;
  
  bool is_default;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SpeechSynthesisVoice::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SpeechSynthesisVoice::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SpeechSynthesisVoice::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SpeechSynthesisVoice::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SpeechSynthesisUtterancePtr SpeechSynthesisUtterance::Clone() const {
  return New(
      mojo::Clone(text),
      mojo::Clone(lang),
      mojo::Clone(voice),
      mojo::Clone(volume),
      mojo::Clone(rate),
      mojo::Clone(pitch)
  );
}

template <typename T, SpeechSynthesisUtterance::EnableIfSame<T>*>
bool SpeechSynthesisUtterance::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->text, other_struct.text))
    return false;
  if (!mojo::Equals(this->lang, other_struct.lang))
    return false;
  if (!mojo::Equals(this->voice, other_struct.voice))
    return false;
  if (!mojo::Equals(this->volume, other_struct.volume))
    return false;
  if (!mojo::Equals(this->rate, other_struct.rate))
    return false;
  if (!mojo::Equals(this->pitch, other_struct.pitch))
    return false;
  return true;
}

template <typename T, SpeechSynthesisUtterance::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.text < rhs.text)
    return true;
  if (rhs.text < lhs.text)
    return false;
  if (lhs.lang < rhs.lang)
    return true;
  if (rhs.lang < lhs.lang)
    return false;
  if (lhs.voice < rhs.voice)
    return true;
  if (rhs.voice < lhs.voice)
    return false;
  if (lhs.volume < rhs.volume)
    return true;
  if (rhs.volume < lhs.volume)
    return false;
  if (lhs.rate < rhs.rate)
    return true;
  if (rhs.rate < lhs.rate)
    return false;
  if (lhs.pitch < rhs.pitch)
    return true;
  if (rhs.pitch < lhs.pitch)
    return false;
  return false;
}
template <typename StructPtrType>
SpeechSynthesisVoicePtr SpeechSynthesisVoice::Clone() const {
  return New(
      mojo::Clone(voice_uri),
      mojo::Clone(name),
      mojo::Clone(lang),
      mojo::Clone(is_local_service),
      mojo::Clone(is_default)
  );
}

template <typename T, SpeechSynthesisVoice::EnableIfSame<T>*>
bool SpeechSynthesisVoice::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->voice_uri, other_struct.voice_uri))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->lang, other_struct.lang))
    return false;
  if (!mojo::Equals(this->is_local_service, other_struct.is_local_service))
    return false;
  if (!mojo::Equals(this->is_default, other_struct.is_default))
    return false;
  return true;
}

template <typename T, SpeechSynthesisVoice::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.voice_uri < rhs.voice_uri)
    return true;
  if (rhs.voice_uri < lhs.voice_uri)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.lang < rhs.lang)
    return true;
  if (rhs.lang < lhs.lang)
    return false;
  if (lhs.is_local_service < rhs.is_local_service)
    return true;
  if (rhs.is_local_service < lhs.is_local_service)
    return false;
  if (lhs.is_default < rhs.is_default)
    return true;
  if (rhs.is_default < lhs.is_default)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::SpeechSynthesisUtterance::DataView,
                                         ::blink::mojom::SpeechSynthesisUtterancePtr> {
  static bool IsNull(const ::blink::mojom::SpeechSynthesisUtterancePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::SpeechSynthesisUtterancePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::SpeechSynthesisUtterance::text)& text(
      const ::blink::mojom::SpeechSynthesisUtterancePtr& input) {
    return input->text;
  }

  static const decltype(::blink::mojom::SpeechSynthesisUtterance::lang)& lang(
      const ::blink::mojom::SpeechSynthesisUtterancePtr& input) {
    return input->lang;
  }

  static const decltype(::blink::mojom::SpeechSynthesisUtterance::voice)& voice(
      const ::blink::mojom::SpeechSynthesisUtterancePtr& input) {
    return input->voice;
  }

  static decltype(::blink::mojom::SpeechSynthesisUtterance::volume) volume(
      const ::blink::mojom::SpeechSynthesisUtterancePtr& input) {
    return input->volume;
  }

  static decltype(::blink::mojom::SpeechSynthesisUtterance::rate) rate(
      const ::blink::mojom::SpeechSynthesisUtterancePtr& input) {
    return input->rate;
  }

  static decltype(::blink::mojom::SpeechSynthesisUtterance::pitch) pitch(
      const ::blink::mojom::SpeechSynthesisUtterancePtr& input) {
    return input->pitch;
  }

  static bool Read(::blink::mojom::SpeechSynthesisUtterance::DataView input, ::blink::mojom::SpeechSynthesisUtterancePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::SpeechSynthesisVoice::DataView,
                                         ::blink::mojom::SpeechSynthesisVoicePtr> {
  static bool IsNull(const ::blink::mojom::SpeechSynthesisVoicePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::SpeechSynthesisVoicePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::SpeechSynthesisVoice::voice_uri)& voice_uri(
      const ::blink::mojom::SpeechSynthesisVoicePtr& input) {
    return input->voice_uri;
  }

  static const decltype(::blink::mojom::SpeechSynthesisVoice::name)& name(
      const ::blink::mojom::SpeechSynthesisVoicePtr& input) {
    return input->name;
  }

  static const decltype(::blink::mojom::SpeechSynthesisVoice::lang)& lang(
      const ::blink::mojom::SpeechSynthesisVoicePtr& input) {
    return input->lang;
  }

  static decltype(::blink::mojom::SpeechSynthesisVoice::is_local_service) is_local_service(
      const ::blink::mojom::SpeechSynthesisVoicePtr& input) {
    return input->is_local_service;
  }

  static decltype(::blink::mojom::SpeechSynthesisVoice::is_default) is_default(
      const ::blink::mojom::SpeechSynthesisVoicePtr& input) {
    return input->is_default;
  }

  static bool Read(::blink::mojom::SpeechSynthesisVoice::DataView input, ::blink::mojom::SpeechSynthesisVoicePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SPEECH_SPEECH_SYNTHESIS_MOJOM_H_