// ui/accessibility/mojom/ax_tree_update.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_TREE_UPDATE_MOJOM_DATA_VIEW_H_
#define UI_ACCESSIBILITY_MOJOM_AX_TREE_UPDATE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "ui/accessibility/mojom/ax_tree_update.mojom-shared-internal.h"
#include "ui/accessibility/ax_enums.mojom-shared.h"
#include "ui/accessibility/mojom/ax_event_intent.mojom-shared.h"
#include "ui/accessibility/mojom/ax_node_data.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_data.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_checks.mojom-shared.h"


namespace ax::mojom {
class AXTreeUpdateDataView;



}  // ax::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::ax::mojom::AXTreeUpdateDataView> {
  using Data = ::ax::mojom::internal::AXTreeUpdate_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace ax::mojom {


class AXTreeUpdateDataView {
 public:
  AXTreeUpdateDataView() = default;

  AXTreeUpdateDataView(
      internal::AXTreeUpdate_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool has_tree_data() const {
    return data_->has_tree_data;
  }
  inline void GetTreeDataDataView(
      ::ax::mojom::AXTreeDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTreeData(UserType* output) {
    
    auto* pointer = data_->tree_data.Get();
    return mojo::internal::Deserialize<::ax::mojom::AXTreeDataDataView>(
        pointer, output, message_);
  }
  int32_t node_id_to_clear() const {
    return data_->node_id_to_clear;
  }
  int32_t root_id() const {
    return data_->root_id;
  }
  inline void GetNodesDataView(
      mojo::ArrayDataView<::ax::mojom::AXNodeDataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNodes(UserType* output) {
    
    auto* pointer = data_->nodes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::ax::mojom::AXNodeDataDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadEventFrom(UserType* output) const {
    auto data_value = data_->event_from;
    return mojo::internal::Deserialize<::ax::mojom::EventFrom>(
        data_value, output);
  }
  ::ax::mojom::EventFrom event_from() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ax::mojom::EventFrom>(data_->event_from));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadEventFromAction(UserType* output) const {
    auto data_value = data_->event_from_action;
    return mojo::internal::Deserialize<::ax::mojom::Action>(
        data_value, output);
  }
  ::ax::mojom::Action event_from_action() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ax::mojom::Action>(data_->event_from_action));
  }
  inline void GetEventIntentsDataView(
      mojo::ArrayDataView<::ax::mojom::EventIntentDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEventIntents(UserType* output) {
    
    auto* pointer = data_->event_intents.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::ax::mojom::EventIntentDataView>>(
        pointer, output, message_);
  }
  inline void GetTreeChecksDataView(
      ::ax::mojom::AXTreeChecksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTreeChecks(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::ax::mojom::AXTreeChecksDataView, UserType>(),
    "Attempting to read the optional `tree_checks` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTreeChecks` instead "
    "of `ReadTreeChecks if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 2
                    ? data_->tree_checks.Get() : nullptr;
    return mojo::internal::Deserialize<::ax::mojom::AXTreeChecksDataView>(
        pointer, output, message_);
  }
 private:
  internal::AXTreeUpdate_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // ax::mojom

#endif  // UI_ACCESSIBILITY_MOJOM_AX_TREE_UPDATE_MOJOM_DATA_VIEW_H_