// ui/base/ime/mojom/virtual_keyboard_types.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/base/ime/mojom/virtual_keyboard_types.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/base/ime/mojom/virtual_keyboard_types.mojom-params-data.h"
namespace ui {
namespace mojom {

NOINLINE static const char* VirtualKeyboardPolicyToStringHelper(VirtualKeyboardPolicy value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case VirtualKeyboardPolicy::AUTO:
      return "AUTO";
    case VirtualKeyboardPolicy::MANUAL:
      return "MANUAL";
    default:
      return nullptr;
  }
}

std::string VirtualKeyboardPolicyToString(VirtualKeyboardPolicy value) {
  const char *str = VirtualKeyboardPolicyToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown VirtualKeyboardPolicy value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, VirtualKeyboardPolicy value) {
  return os << VirtualKeyboardPolicyToString(value);
}

NOINLINE static const char* VirtualKeyboardVisibilityRequestToStringHelper(VirtualKeyboardVisibilityRequest value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case VirtualKeyboardVisibilityRequest::NONE:
      return "NONE";
    case VirtualKeyboardVisibilityRequest::SHOW:
      return "SHOW";
    case VirtualKeyboardVisibilityRequest::HIDE:
      return "HIDE";
    default:
      return nullptr;
  }
}

std::string VirtualKeyboardVisibilityRequestToString(VirtualKeyboardVisibilityRequest value) {
  const char *str = VirtualKeyboardVisibilityRequestToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown VirtualKeyboardVisibilityRequest value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, VirtualKeyboardVisibilityRequest value) {
  return os << VirtualKeyboardVisibilityRequestToString(value);
}

NOINLINE static const char* VirtualKeyboardModeToStringHelper(VirtualKeyboardMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case VirtualKeyboardMode::kUnset:
      return "kUnset";
    case VirtualKeyboardMode::kResizesVisual:
      return "kResizesVisual";
    case VirtualKeyboardMode::kResizesContent:
      return "kResizesContent";
    case VirtualKeyboardMode::kOverlaysContent:
      return "kOverlaysContent";
    default:
      return nullptr;
  }
}

std::string VirtualKeyboardModeToString(VirtualKeyboardMode value) {
  const char *str = VirtualKeyboardModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown VirtualKeyboardMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, VirtualKeyboardMode value) {
  return os << VirtualKeyboardModeToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace ui

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::VirtualKeyboardPolicy>::WriteIntoTrace(
   perfetto::TracedValue context, ::ui::mojom::VirtualKeyboardPolicy value) {
  return std::move(context).WriteString(::ui::mojom::VirtualKeyboardPolicyToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::VirtualKeyboardVisibilityRequest>::WriteIntoTrace(
   perfetto::TracedValue context, ::ui::mojom::VirtualKeyboardVisibilityRequest value) {
  return std::move(context).WriteString(::ui::mojom::VirtualKeyboardVisibilityRequestToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::VirtualKeyboardMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::ui::mojom::VirtualKeyboardMode value) {
  return std::move(context).WriteString(::ui::mojom::VirtualKeyboardModeToString(value));
}

} // namespace perfetto