// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/input/features.h"

#include "base/feature_list.h"
#include "components/input/input_constants.h"

namespace input::features {

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kInputOnViz, "InputOnViz", base::FEATURE_DISABLED_BY_DEFAULT);
BASE_FEATURE(kUseAndroidBufferedInputDispatch,
             "UseAndroidBufferedInputDispatch",
             base::FEATURE_DISABLED_BY_DEFAULT);
#endif

#if BUILDFLAG(IS_ANDROID)
BASE_FEATURE(kLogBubblingTouchscreenGesturesForDebug,
             "LogBubblingTouchscreenGesturesForDebug",
             base::FEATURE_DISABLED_BY_DEFAULT);
#else
BASE_FEATURE(kLogBubblingTouchscreenGesturesForDebug,
             "LogBubblingTouchscreenGesturesForDebug",
             base::FEATURE_ENABLED_BY_DEFAULT);
#endif

// Flag guard for fix for crbug.com/346629231.
BASE_FEATURE(kIgnoreBubblingCollisionIfSourceDevicesMismatch,
             "IgnoreBubblingCollisionIfSourceDevicesMismatch",
             base::FEATURE_ENABLED_BY_DEFAULT);

// Flag guard for fix for crbug.com/346629231.
BASE_FEATURE(kScrollBubblingFix,
             "ScrollBubblingFix",
             base::FEATURE_ENABLED_BY_DEFAULT);

// Flag guard for fix for crbug.com/404464598.
BASE_FEATURE(kUseFirstCoalescedFrameAsFlingGenerationTimestamp,
             "UseFirstCoalescedFrameAsFlingGenerationTimestamp",
             base::FEATURE_ENABLED_BY_DEFAULT);

// Flag guard for renderer hang watcher \ hang monitor.
BASE_FEATURE(kRendererHangWatcher,
             "RendererHangWatcher",
             base::FEATURE_ENABLED_BY_DEFAULT);
BASE_FEATURE_PARAM(
    base::TimeDelta,
    kRendererHangWatcherDelay,
    &kRendererHangWatcher,
    "delay",
    input::kHungRendererDelay  // Default value in input_constants.h
);

}  // namespace input::features
