// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.


#include "media/formats/mp4/fourccs.h"

#include <array>
#include <sstream>
#include <string>

namespace media::mp4 {

std::string FourCCToString(FourCC fourcc) {
  std::array<char, 5> buf;
  buf[0] = (fourcc >> 24) & 0xff;
  buf[1] = (fourcc >> 16) & 0xff;
  buf[2] = (fourcc >> 8) & 0xff;
  buf[3] = (fourcc)&0xff;
  buf[4] = 0;

  // Return hex itself if characters can not be printed. Any character within
  // the "C" locale is considered printable.
  for (int i = 0; i < 4; ++i) {
    if (!(buf[i] > 0x1f && buf[i] < 0x7f)) {
      std::stringstream hex_string;
      hex_string << "0x" << std::hex << fourcc;
      return hex_string.str();
    }
  }

  return std::string(buf.data());
}

}  // namespace media::mp4
