/* game-view.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from game-view.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gsound.h>
#include <graphene-gobject.h>
#include <float.h>
#include <math.h>
#include <gsk/gsk.h>
#include <glib/gi18n-lib.h>
#include <cairo-gobject.h>
#include <pango/pango.h>
#include <pango/pangocairo.h>
#include <gdk/gdk.h>
#include <adwaita.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;
typedef struct _GameViewPrivate GameViewPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;

#define TYPE_TEXT_OVERLAY (text_overlay_get_type ())
#define TEXT_OVERLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEXT_OVERLAY, TextOverlay))
#define TEXT_OVERLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEXT_OVERLAY, TextOverlayClass))
#define IS_TEXT_OVERLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEXT_OVERLAY))
#define IS_TEXT_OVERLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEXT_OVERLAY))
#define TEXT_OVERLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEXT_OVERLAY, TextOverlayClass))

typedef struct _TextOverlay TextOverlay;
typedef struct _TextOverlayClass TextOverlayClass;

#define TYPE_BLOCK (block_get_type ())
#define BLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BLOCK, Block))
#define BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BLOCK, BlockClass))
#define IS_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BLOCK))
#define IS_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BLOCK))
#define BLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BLOCK, BlockClass))

typedef struct _Block Block;
typedef struct _BlockClass BlockClass;

#define TYPE_BLOCK_WIDGET (block_widget_get_type ())
#define BLOCK_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BLOCK_WIDGET, BlockWidget))
#define BLOCK_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BLOCK_WIDGET, BlockWidgetClass))
#define IS_BLOCK_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BLOCK_WIDGET))
#define IS_BLOCK_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BLOCK_WIDGET))
#define BLOCK_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BLOCK_WIDGET, BlockWidgetClass))

typedef struct _BlockWidget BlockWidget;
typedef struct _BlockWidgetClass BlockWidgetClass;
typedef enum  {
	GAME_VIEW_SOUND_CONTEXT_STATE_INITIAL,
	GAME_VIEW_SOUND_CONTEXT_STATE_WORKING,
	GAME_VIEW_SOUND_CONTEXT_STATE_ERRORED
} GameViewSoundContextState;

#define GAME_VIEW_TYPE_SOUND_CONTEXT_STATE (game_view_sound_context_state_get_type ())
enum  {
	GAME_VIEW_0_PROPERTY,
	GAME_VIEW_GAME_PROPERTY,
	GAME_VIEW_THEME_PROPERTY,
	GAME_VIEW_SHOW_SHADOW_PROPERTY,
	GAME_VIEW_MUTE_PROPERTY,
	GAME_VIEW_NUM_PROPERTIES
};
static GParamSpec* game_view_properties[GAME_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _BlockWidgetPrivate BlockWidgetPrivate;
typedef struct _GamePrivate GamePrivate;

#define TYPE_SHAPE (shape_get_type ())
#define SHAPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SHAPE, Shape))
#define SHAPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SHAPE, ShapeClass))
#define IS_SHAPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SHAPE))
#define IS_SHAPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SHAPE))
#define SHAPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SHAPE, ShapeClass))

typedef struct _Shape Shape;
typedef struct _ShapeClass ShapeClass;
typedef struct _ShapePrivate ShapePrivate;
typedef struct _BlockPrivate BlockPrivate;
#define _gsk_transform_unref0(var) ((var == NULL) ? NULL : (var = (gsk_transform_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TextOverlayPrivate TextOverlayPrivate;
enum  {
	TEXT_OVERLAY_0_PROPERTY,
	TEXT_OVERLAY_TEXT_PROPERTY,
	TEXT_OVERLAY_NUM_PROPERTIES
};
static GParamSpec* text_overlay_properties[TEXT_OVERLAY_NUM_PROPERTIES];
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
enum  {
	BLOCK_WIDGET_0_PROPERTY,
	BLOCK_WIDGET_THEME_PROPERTY,
	BLOCK_WIDGET_COLOR_PROPERTY,
	BLOCK_WIDGET_NUM_PROPERTIES
};
static GParamSpec* block_widget_properties[BLOCK_WIDGET_NUM_PROPERTIES];
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))

struct _GameView {
	GtkWidget parent_instance;
	GameViewPrivate * priv;
};

struct _GameViewClass {
	GtkWidgetClass parent_class;
};

struct _GameViewPrivate {
	Game* _game;
	gchar* _theme;
	gboolean _show_shadow;
	TextOverlay* text_overlay;
	GHashTable* blocks;
	GHashTable* shape_blocks;
	GHashTable* shadow_blocks;
	gint n_lines_destroyed;
	gboolean _mute;
	GSoundContext* sound_context;
	GameViewSoundContextState sound_context_state;
};

struct _BlockWidget {
	GtkWidget parent_instance;
	BlockWidgetPrivate * priv;
	Block* block;
};

struct _BlockWidgetClass {
	GtkWidgetClass parent_class;
};

struct _Game {
	GObject parent_instance;
	GamePrivate * priv;
	Shape* shape;
	Shape* next_shape;
	Block** blocks;
	gint blocks_length1;
	gint blocks_length2;
	gint n_lines_destroyed;
	gint score;
	gint difficulty;
	gboolean pick_difficult_blocks;
	gboolean game_over;
};

struct _GameClass {
	GObjectClass parent_class;
};

struct _Shape {
	GObject parent_instance;
	ShapePrivate * priv;
	gint x;
	gint y;
	gint rotation;
	gint type;
	GList* blocks;
};

struct _ShapeClass {
	GObjectClass parent_class;
};

struct _Block {
	GObject parent_instance;
	BlockPrivate * priv;
	gint x;
	gint y;
	gint color;
};

struct _BlockClass {
	GObjectClass parent_class;
};

struct _TextOverlay {
	GtkDrawingArea parent_instance;
	TextOverlayPrivate * priv;
};

struct _TextOverlayClass {
	GtkDrawingAreaClass parent_class;
};

struct _TextOverlayPrivate {
	gchar* _text;
};

struct _BlockWidgetPrivate {
	gchar* _theme;
	gint _color;
	GtkDrawingArea* drawing_area;
	gint animation_size_begin;
};

static gint GameView_private_offset;
static gpointer game_view_parent_class = NULL;
static gint TextOverlay_private_offset;
static gpointer text_overlay_parent_class = NULL;
static gint BlockWidget_private_offset;
static gpointer block_widget_parent_class = NULL;

VALA_EXTERN GType game_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameView, g_object_unref)
VALA_EXTERN GType game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Game, g_object_unref)
VALA_EXTERN GType text_overlay_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TextOverlay, g_object_unref)
VALA_EXTERN GType block_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Block, g_object_unref)
VALA_EXTERN GType block_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BlockWidget, g_object_unref)
static GType game_view_sound_context_state_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
VALA_EXTERN GameView* game_view_new (void);
VALA_EXTERN GameView* game_view_construct (GType object_type);
VALA_EXTERN TextOverlay* text_overlay_new (void);
VALA_EXTERN TextOverlay* text_overlay_construct (GType object_type);
static void _g_object_unref0_ (gpointer var);
static void game_view_real_size_allocate (GtkWidget* base,
                                   gint width,
                                   gint height,
                                   gint baseline);
VALA_EXTERN Game* game_view_get_game (GameView* self);
VALA_EXTERN gint game_get_width (Game* self);
VALA_EXTERN gint game_get_height (Game* self);
VALA_EXTERN GType shape_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Shape, g_object_unref)
VALA_EXTERN gboolean game_view_get_show_shadow (GameView* self);
VALA_EXTERN gint game_get_shadow_y (Game* self);
static void game_view_add_block_widget (GameView* self,
                                 BlockWidget* widget);
static void game_view_clear_blocks (GameView* self);
static void game_view_real_dispose (GObject* base);
static void game_view_shape_added_cb (GameView* self);
VALA_EXTERN const gchar* game_view_get_theme (GameView* self);
VALA_EXTERN BlockWidget* block_widget_new (Block* block,
                               const gchar* theme);
VALA_EXTERN BlockWidget* block_widget_construct (GType object_type,
                                     Block* block,
                                     const gchar* theme);
static void game_view_shape_moved_cb (GameView* self);
static void game_view_play_sound (GameView* self,
                           const gchar* name);
static void game_view_shape_dropped_cb (GameView* self);
static void game_view_shape_rotated_cb (GameView* self);
static void game_view_shape_landed_cb (GameView* self,
                                gint* lines,
                                gint lines_length1,
                                GList* line_blocks);
VALA_EXTERN void block_widget_explode (BlockWidget* self);
static void game_view_pause_changed_cb (GameView* self);
static void game_view_update_message (GameView* self);
static void game_view_game_complete_cb (GameView* self);
VALA_EXTERN gboolean game_get_paused (Game* self);
VALA_EXTERN void text_overlay_set_text (TextOverlay* self,
                            const gchar* value);
static void game_view_init_sound (GameView* self);
static gboolean game_view_get_mute (GameView* self);
static void _game_view_play_sound (const gchar* _name,
                            GSoundContext* sound_context);
VALA_EXTERN void game_view_set_game (GameView* self,
                         Game* value);
static void _game_view_shape_added_cb_game_shape_added (Game* _sender,
                                                 gpointer self);
static void _game_view_shape_moved_cb_game_shape_moved (Game* _sender,
                                                 gpointer self);
static void _game_view_shape_dropped_cb_game_shape_dropped (Game* _sender,
                                                     gpointer self);
static void _game_view_shape_rotated_cb_game_shape_rotated (Game* _sender,
                                                     gpointer self);
static void _game_view_shape_landed_cb_game_shape_landed (Game* _sender,
                                                   gint* lines,
                                                   gint lines_length1,
                                                   GList* line_blocks,
                                                   gpointer self);
static void _game_view_pause_changed_cb_game_pause_changed (Game* _sender,
                                                     gpointer self);
static void _game_view_game_complete_cb_game_complete (Game* _sender,
                                                gpointer self);
VALA_EXTERN void block_widget_set_color (BlockWidget* self,
                             gint value);
VALA_EXTERN void game_view_set_theme (GameView* self,
                          const gchar* value);
VALA_EXTERN void block_widget_set_theme (BlockWidget* self,
                             const gchar* value);
VALA_EXTERN void game_view_set_show_shadow (GameView* self,
                                gboolean value);
static gint game_view_get_cell_size (GameView* self);
VALA_EXTERN void game_view_set_mute (GameView* self,
                         gboolean value);
static void game_view_finalize (GObject * obj);
static GType game_view_get_type_once (void);
static void _vala_game_view_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec);
static void _vala_game_view_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec);
VALA_EXTERN void text_overlay_draw (TextOverlay* self,
                        GtkDrawingArea* area,
                        cairo_t* cr,
                        gint width,
                        gint height);
static void _text_overlay_draw_gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                                    cairo_t* cr,
                                                    gint width,
                                                    gint height,
                                                    gpointer self);
VALA_EXTERN const gchar* text_overlay_get_text (TextOverlay* self);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static void text_overlay_finalize (GObject * obj);
static GType text_overlay_get_type_once (void);
static void _vala_text_overlay_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_text_overlay_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
VALA_EXTERN void block_widget_draw (BlockWidget* self,
                        GtkDrawingArea* area,
                        cairo_t* cr,
                        gint width,
                        gint height);
static void _block_widget_draw_gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                                    cairo_t* cr,
                                                    gint width,
                                                    gint height,
                                                    gpointer self);
static void block_widget_real_size_allocate (GtkWidget* base,
                                      gint width,
                                      gint height,
                                      gint baseline);
static void block_widget_real_snapshot (GtkWidget* base,
                                 GtkSnapshot* snapshot);
VALA_EXTERN const gchar* block_widget_get_theme (BlockWidget* self);
static void block_widget_snapshot_modern (BlockWidget* self,
                                   GtkSnapshot* snapshot);
VALA_EXTERN gint block_widget_get_color (BlockWidget* self);
static void block_widget_explode_animation_cb (BlockWidget* self,
                                        gdouble val);
static void _block_widget_explode_animation_cb_adw_animation_target_func (gdouble value,
                                                                   gpointer self);
static void block_widget_explode_complete_cb (BlockWidget* self,
                                       AdwAnimation* animation);
static void _block_widget_explode_complete_cb_adw_animation_done (AdwAnimation* _sender,
                                                           gpointer self);
static void block_widget_draw_clean (BlockWidget* self,
                              cairo_t* cr,
                              gint width,
                              gint height);
static void block_widget_draw_tango (BlockWidget* self,
                              cairo_t* cr,
                              gint width,
                              gint height,
                              gboolean use_gradients);
static void block_widget_draw_plain (BlockWidget* self,
                              cairo_t* cr,
                              gint width,
                              gint height);
static void block_widget_draw_rounded_rectangle (BlockWidget* self,
                                          cairo_t* cr,
                                          gdouble x,
                                          gdouble y,
                                          gdouble w,
                                          gdouble h,
                                          gdouble r);
static void block_widget_finalize (GObject * obj);
static GType block_widget_get_type_once (void);
static void _vala_block_widget_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_block_widget_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);

static inline gpointer
game_view_get_instance_private (GameView* self)
{
	return G_STRUCT_MEMBER_P (self, GameView_private_offset);
}

static GType
game_view_sound_context_state_get_type_once (void)
{
	static const GEnumValue values[] = {{GAME_VIEW_SOUND_CONTEXT_STATE_INITIAL, "GAME_VIEW_SOUND_CONTEXT_STATE_INITIAL", "initial"}, {GAME_VIEW_SOUND_CONTEXT_STATE_WORKING, "GAME_VIEW_SOUND_CONTEXT_STATE_WORKING", "working"}, {GAME_VIEW_SOUND_CONTEXT_STATE_ERRORED, "GAME_VIEW_SOUND_CONTEXT_STATE_ERRORED", "errored"}, {0, NULL, NULL}};
	GType game_view_sound_context_state_type_id;
	game_view_sound_context_state_type_id = g_enum_register_static ("GameViewSoundContextState", values);
	return game_view_sound_context_state_type_id;
}

static GType
game_view_sound_context_state_get_type (void)
{
	static volatile gsize game_view_sound_context_state_type_id__once = 0;
	if (g_once_init_enter (&game_view_sound_context_state_type_id__once)) {
		GType game_view_sound_context_state_type_id;
		game_view_sound_context_state_type_id = game_view_sound_context_state_get_type_once ();
		g_once_init_leave (&game_view_sound_context_state_type_id__once, game_view_sound_context_state_type_id);
	}
	return game_view_sound_context_state_type_id__once;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

GameView*
game_view_construct (GType object_type)
{
	GameView * self = NULL;
	TextOverlay* _tmp0_;
	TextOverlay* _tmp1_;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	GHashTable* _tmp4_;
	GHashFunc _tmp5_;
	GEqualFunc _tmp6_;
	GHashTable* _tmp7_;
	GHashFunc _tmp8_;
	GEqualFunc _tmp9_;
	GHashTable* _tmp10_;
	self = (GameView*) g_object_new (object_type, NULL);
	_tmp0_ = text_overlay_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->text_overlay);
	self->priv->text_overlay = _tmp0_;
	_tmp1_ = self->priv->text_overlay;
	gtk_widget_set_parent ((GtkWidget*) _tmp1_, (GtkWidget*) self);
	_tmp2_ = g_direct_hash;
	_tmp3_ = g_direct_equal;
	_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, _g_object_unref0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->blocks);
	self->priv->blocks = _tmp4_;
	_tmp5_ = g_direct_hash;
	_tmp6_ = g_direct_equal;
	_tmp7_ = g_hash_table_new_full (_tmp5_, _tmp6_, _g_object_unref0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->shape_blocks);
	self->priv->shape_blocks = _tmp7_;
	_tmp8_ = g_direct_hash;
	_tmp9_ = g_direct_equal;
	_tmp10_ = g_hash_table_new_full (_tmp8_, _tmp9_, _g_object_unref0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->shadow_blocks);
	self->priv->shadow_blocks = _tmp10_;
	return self;
}

GameView*
game_view_new (void)
{
	return game_view_construct (TYPE_GAME_VIEW);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_gsk_transform_ref0 (gpointer self)
{
	return self ? gsk_transform_ref (self) : NULL;
}

static void
game_view_real_size_allocate (GtkWidget* base,
                              gint width,
                              gint height,
                              gint baseline)
{
	GameView * self;
	gint block_width = 0;
	Game* _tmp0_;
	Game* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint block_height = 0;
	Game* _tmp4_;
	Game* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	BlockWidget* block_widget = NULL;
	GtkWidget* _tmp8_;
	BlockWidget* _tmp9_;
	graphene_point_t pos = {0};
	graphene_point_t _tmp61_ = {0};
	GskTransform* transform = NULL;
	GskTransform* _tmp62_;
	graphene_point_t _tmp63_;
	GskTransform* _tmp64_;
	TextOverlay* _tmp65_;
	TextOverlay* _tmp66_;
	GskTransform* _tmp67_;
	self = (GameView*) base;
	_tmp0_ = game_view_get_game (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = game_get_width (_tmp1_);
	_tmp3_ = _tmp2_;
	block_width = width / _tmp3_;
	_tmp4_ = game_view_get_game (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = game_get_height (_tmp5_);
	_tmp7_ = _tmp6_;
	block_height = height / _tmp7_;
	_tmp8_ = gtk_widget_get_first_child ((GtkWidget*) self);
	_tmp9_ = _g_object_ref0 (IS_BLOCK_WIDGET (_tmp8_) ? ((BlockWidget*) _tmp8_) : NULL);
	block_widget = _tmp9_;
	while (TRUE) {
		BlockWidget* _tmp10_;
		graphene_point_t pos = {0};
		gboolean show = FALSE;
		GHashTable* _tmp11_;
		BlockWidget* _tmp12_;
		Block* _tmp13_;
		gconstpointer _tmp14_;
		BlockWidget* _tmp15_;
		BlockWidget* _tmp58_;
		GtkWidget* _tmp59_;
		BlockWidget* _tmp60_;
		_tmp10_ = block_widget;
		if (!(_tmp10_ != NULL)) {
			break;
		}
		memset (&pos, 0, sizeof (graphene_point_t));
		show = TRUE;
		_tmp11_ = self->priv->shape_blocks;
		_tmp12_ = block_widget;
		_tmp13_ = _tmp12_->block;
		_tmp14_ = g_hash_table_lookup (_tmp11_, _tmp13_);
		_tmp15_ = block_widget;
		if (((BlockWidget*) _tmp14_) == _tmp15_) {
			Game* _tmp16_;
			Game* _tmp17_;
			Shape* _tmp18_;
			BlockWidget* _tmp19_;
			Block* _tmp20_;
			Game* _tmp21_;
			Game* _tmp22_;
			Shape* _tmp23_;
			BlockWidget* _tmp24_;
			Block* _tmp25_;
			_tmp16_ = game_view_get_game (self);
			_tmp17_ = _tmp16_;
			_tmp18_ = _tmp17_->shape;
			_tmp19_ = block_widget;
			_tmp20_ = _tmp19_->block;
			pos.x = (gfloat) ((_tmp18_->x + _tmp20_->x) * block_width);
			_tmp21_ = game_view_get_game (self);
			_tmp22_ = _tmp21_;
			_tmp23_ = _tmp22_->shape;
			_tmp24_ = block_widget;
			_tmp25_ = _tmp24_->block;
			pos.y = (gfloat) ((_tmp23_->y + _tmp25_->y) * block_height);
		} else {
			GHashTable* _tmp26_;
			BlockWidget* _tmp27_;
			Block* _tmp28_;
			gconstpointer _tmp29_;
			BlockWidget* _tmp30_;
			_tmp26_ = self->priv->shadow_blocks;
			_tmp27_ = block_widget;
			_tmp28_ = _tmp27_->block;
			_tmp29_ = g_hash_table_lookup (_tmp26_, _tmp28_);
			_tmp30_ = block_widget;
			if (((BlockWidget*) _tmp29_) == _tmp30_) {
				gboolean _tmp31_;
				gboolean _tmp32_;
				_tmp31_ = game_view_get_show_shadow (self);
				_tmp32_ = _tmp31_;
				if (_tmp32_) {
					Game* _tmp33_;
					Game* _tmp34_;
					Shape* _tmp35_;
					BlockWidget* _tmp36_;
					Block* _tmp37_;
					Game* _tmp38_;
					Game* _tmp39_;
					gint _tmp40_;
					gint _tmp41_;
					BlockWidget* _tmp42_;
					Block* _tmp43_;
					_tmp33_ = game_view_get_game (self);
					_tmp34_ = _tmp33_;
					_tmp35_ = _tmp34_->shape;
					_tmp36_ = block_widget;
					_tmp37_ = _tmp36_->block;
					pos.x = (gfloat) ((_tmp35_->x + _tmp37_->x) * block_width);
					_tmp38_ = game_view_get_game (self);
					_tmp39_ = _tmp38_;
					_tmp40_ = game_get_shadow_y (_tmp39_);
					_tmp41_ = _tmp40_;
					_tmp42_ = block_widget;
					_tmp43_ = _tmp42_->block;
					pos.y = (gfloat) ((_tmp41_ + _tmp43_->y) * block_height);
				} else {
					show = FALSE;
				}
			} else {
				BlockWidget* _tmp44_;
				Block* _tmp45_;
				BlockWidget* _tmp46_;
				Block* _tmp47_;
				_tmp44_ = block_widget;
				_tmp45_ = _tmp44_->block;
				pos.x = (gfloat) (_tmp45_->x * block_width);
				_tmp46_ = block_widget;
				_tmp47_ = _tmp46_->block;
				pos.y = (gfloat) (_tmp47_->y * block_height);
			}
		}
		if (show) {
			gint min_width = 0;
			gint min_height = 0;
			gint actual_width = 0;
			gint actual_height = 0;
			BlockWidget* _tmp48_;
			gint _tmp49_ = 0;
			BlockWidget* _tmp50_;
			gint _tmp51_ = 0;
			GskTransform* transform = NULL;
			GskTransform* _tmp52_;
			graphene_point_t _tmp53_;
			GskTransform* _tmp54_;
			BlockWidget* _tmp55_;
			GskTransform* _tmp56_;
			GskTransform* _tmp57_;
			_tmp48_ = block_widget;
			gtk_widget_measure ((GtkWidget*) _tmp48_, GTK_ORIENTATION_VERTICAL, -1, &_tmp49_, NULL, NULL, NULL);
			min_width = _tmp49_;
			actual_width = MAX (min_width, block_width);
			_tmp50_ = block_widget;
			gtk_widget_measure ((GtkWidget*) _tmp50_, GTK_ORIENTATION_HORIZONTAL, actual_width, &_tmp51_, NULL, NULL, NULL);
			min_height = _tmp51_;
			actual_height = MAX (min_height, block_height);
			pos.x = pos.x - ((actual_width - block_width) / 2);
			pos.y = pos.y - ((actual_height - block_height) / 2);
			_tmp52_ = gsk_transform_new ();
			_tmp53_ = pos;
			_tmp54_ = gsk_transform_translate (_tmp52_, &_tmp53_);
			transform = _tmp54_;
			_tmp55_ = block_widget;
			_tmp56_ = transform;
			_tmp57_ = _gsk_transform_ref0 (_tmp56_);
			gtk_widget_allocate ((GtkWidget*) _tmp55_, actual_width, actual_height, -1, _tmp57_);
			_gsk_transform_unref0 (transform);
		}
		_tmp58_ = block_widget;
		_tmp59_ = gtk_widget_get_next_sibling ((GtkWidget*) _tmp58_);
		_tmp60_ = _g_object_ref0 (IS_BLOCK_WIDGET (_tmp59_) ? ((BlockWidget*) _tmp59_) : NULL);
		_g_object_unref0 (block_widget);
		block_widget = _tmp60_;
	}
	memset (&_tmp61_, 0, sizeof (graphene_point_t));
	_tmp61_.x = (gfloat) 0;
	_tmp61_.y = (gfloat) 0;
	pos = _tmp61_;
	_tmp62_ = gsk_transform_new ();
	_tmp63_ = pos;
	_tmp64_ = gsk_transform_translate (_tmp62_, &_tmp63_);
	transform = _tmp64_;
	_tmp65_ = self->priv->text_overlay;
	gtk_widget_measure ((GtkWidget*) _tmp65_, GTK_ORIENTATION_VERTICAL, width, NULL, NULL, NULL, NULL);
	_tmp66_ = self->priv->text_overlay;
	_tmp67_ = _gsk_transform_ref0 (transform);
	gtk_widget_allocate ((GtkWidget*) _tmp66_, width, height, -1, _tmp67_);
	_gsk_transform_unref0 (transform);
	_g_object_unref0 (block_widget);
}

static void
game_view_add_block_widget (GameView* self,
                            BlockWidget* widget)
{
	TextOverlay* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->text_overlay;
	gtk_widget_insert_before ((GtkWidget*) widget, (GtkWidget*) self, (GtkWidget*) _tmp0_);
}

static void
game_view_clear_blocks (GameView* self)
{
	Block* block = NULL;
	BlockWidget* widget = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp0_;
	GHashTable* _tmp7_;
	GHashTable* _tmp14_;
	GHashTable* _tmp21_;
	GHashTable* _tmp22_;
	GHashTable* _tmp23_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->blocks;
	g_hash_table_iter_init (&iter, _tmp0_);
	while (TRUE) {
		gconstpointer _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
		gboolean _tmp3_;
		Block* _tmp4_;
		BlockWidget* _tmp5_;
		BlockWidget* _tmp6_;
		_tmp3_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp1_), (gpointer*) (&_tmp2_));
		_g_object_unref0 (block);
		_tmp4_ = _g_object_ref0 ((Block*) _tmp1_);
		block = _tmp4_;
		_g_object_unref0 (widget);
		_tmp5_ = _g_object_ref0 ((BlockWidget*) _tmp2_);
		widget = _tmp5_;
		if (!_tmp3_) {
			break;
		}
		_tmp6_ = widget;
		gtk_widget_unparent ((GtkWidget*) _tmp6_);
	}
	_tmp7_ = self->priv->shape_blocks;
	g_hash_table_iter_init (&iter, _tmp7_);
	while (TRUE) {
		gconstpointer _tmp8_ = NULL;
		gconstpointer _tmp9_ = NULL;
		gboolean _tmp10_;
		Block* _tmp11_;
		BlockWidget* _tmp12_;
		BlockWidget* _tmp13_;
		_tmp10_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp8_), (gpointer*) (&_tmp9_));
		_g_object_unref0 (block);
		_tmp11_ = _g_object_ref0 ((Block*) _tmp8_);
		block = _tmp11_;
		_g_object_unref0 (widget);
		_tmp12_ = _g_object_ref0 ((BlockWidget*) _tmp9_);
		widget = _tmp12_;
		if (!_tmp10_) {
			break;
		}
		_tmp13_ = widget;
		gtk_widget_unparent ((GtkWidget*) _tmp13_);
	}
	_tmp14_ = self->priv->shadow_blocks;
	g_hash_table_iter_init (&iter, _tmp14_);
	while (TRUE) {
		gconstpointer _tmp15_ = NULL;
		gconstpointer _tmp16_ = NULL;
		gboolean _tmp17_;
		Block* _tmp18_;
		BlockWidget* _tmp19_;
		BlockWidget* _tmp20_;
		_tmp17_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp15_), (gpointer*) (&_tmp16_));
		_g_object_unref0 (block);
		_tmp18_ = _g_object_ref0 ((Block*) _tmp15_);
		block = _tmp18_;
		_g_object_unref0 (widget);
		_tmp19_ = _g_object_ref0 ((BlockWidget*) _tmp16_);
		widget = _tmp19_;
		if (!_tmp17_) {
			break;
		}
		_tmp20_ = widget;
		gtk_widget_unparent ((GtkWidget*) _tmp20_);
	}
	_tmp21_ = self->priv->blocks;
	g_hash_table_remove_all (_tmp21_);
	_tmp22_ = self->priv->shape_blocks;
	g_hash_table_remove_all (_tmp22_);
	_tmp23_ = self->priv->shadow_blocks;
	g_hash_table_remove_all (_tmp23_);
	_g_object_unref0 (widget);
	_g_object_unref0 (block);
}

static void
game_view_real_dispose (GObject* base)
{
	GameView * self;
	TextOverlay* _tmp0_;
	self = (GameView*) base;
	game_view_clear_blocks (self);
	_tmp0_ = self->priv->text_overlay;
	gtk_widget_unparent ((GtkWidget*) _tmp0_);
	G_OBJECT_CLASS (game_view_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
}

static void
game_view_shape_added_cb (GameView* self)
{
	Game* _tmp0_;
	Game* _tmp1_;
	Shape* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = game_view_get_game (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->shape;
	if (_tmp2_ != NULL) {
		Game* _tmp3_;
		Game* _tmp4_;
		Shape* _tmp5_;
		GList* _tmp6_;
		_tmp3_ = game_view_get_game (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = _tmp4_->shape;
		_tmp6_ = _tmp5_->blocks;
		{
			GList* block_collection = NULL;
			GList* block_it = NULL;
			block_collection = _tmp6_;
			for (block_it = block_collection; block_it != NULL; block_it = block_it->next) {
				Block* _tmp7_;
				Block* block = NULL;
				_tmp7_ = _g_object_ref0 ((Block*) block_it->data);
				block = _tmp7_;
				{
					BlockWidget* widget = NULL;
					Block* _tmp8_;
					const gchar* _tmp9_;
					const gchar* _tmp10_;
					BlockWidget* _tmp11_;
					GHashTable* _tmp12_;
					Block* _tmp13_;
					Block* _tmp14_;
					BlockWidget* _tmp15_;
					BlockWidget* _tmp16_;
					BlockWidget* _tmp17_;
					gboolean _tmp18_;
					gboolean _tmp19_;
					_tmp8_ = block;
					_tmp9_ = game_view_get_theme (self);
					_tmp10_ = _tmp9_;
					_tmp11_ = block_widget_new (_tmp8_, _tmp10_);
					g_object_ref_sink (_tmp11_);
					widget = _tmp11_;
					_tmp12_ = self->priv->shape_blocks;
					_tmp13_ = block;
					_tmp14_ = _g_object_ref0 (_tmp13_);
					_tmp15_ = widget;
					_tmp16_ = _g_object_ref0 (_tmp15_);
					g_hash_table_insert (_tmp12_, _tmp14_, _tmp16_);
					_tmp17_ = widget;
					game_view_add_block_widget (self, _tmp17_);
					_tmp18_ = game_view_get_show_shadow (self);
					_tmp19_ = _tmp18_;
					if (_tmp19_) {
						BlockWidget* shadow_widget = NULL;
						Block* _tmp20_;
						const gchar* _tmp21_;
						const gchar* _tmp22_;
						BlockWidget* _tmp23_;
						BlockWidget* _tmp24_;
						GHashTable* _tmp25_;
						Block* _tmp26_;
						Block* _tmp27_;
						BlockWidget* _tmp28_;
						BlockWidget* _tmp29_;
						BlockWidget* _tmp30_;
						_tmp20_ = block;
						_tmp21_ = game_view_get_theme (self);
						_tmp22_ = _tmp21_;
						_tmp23_ = block_widget_new (_tmp20_, _tmp22_);
						g_object_ref_sink (_tmp23_);
						shadow_widget = _tmp23_;
						_tmp24_ = shadow_widget;
						gtk_widget_add_css_class ((GtkWidget*) _tmp24_, "shadow");
						_tmp25_ = self->priv->shadow_blocks;
						_tmp26_ = block;
						_tmp27_ = _g_object_ref0 (_tmp26_);
						_tmp28_ = shadow_widget;
						_tmp29_ = _g_object_ref0 (_tmp28_);
						g_hash_table_insert (_tmp25_, _tmp27_, _tmp29_);
						_tmp30_ = shadow_widget;
						game_view_add_block_widget (self, _tmp30_);
						_g_object_unref0 (shadow_widget);
					}
					_g_object_unref0 (widget);
					_g_object_unref0 (block);
				}
			}
		}
	}
	gtk_widget_queue_allocate ((GtkWidget*) self);
}

static void
game_view_shape_moved_cb (GameView* self)
{
	g_return_if_fail (self != NULL);
	gtk_widget_queue_allocate ((GtkWidget*) self);
	game_view_play_sound (self, "slide");
}

static void
game_view_shape_dropped_cb (GameView* self)
{
	g_return_if_fail (self != NULL);
	gtk_widget_queue_allocate ((GtkWidget*) self);
}

static void
game_view_shape_rotated_cb (GameView* self)
{
	g_return_if_fail (self != NULL);
	gtk_widget_queue_allocate ((GtkWidget*) self);
	game_view_play_sound (self, "turn");
}

static void
game_view_shape_landed_cb (GameView* self,
                           gint* lines,
                           gint lines_length1,
                           GList* line_blocks)
{
	GHashTableIter shape_iter = {0};
	GHashTable* _tmp0_;
	GHashTable* _tmp7_;
	GHashTableIter shadow_iter = {0};
	GHashTable* _tmp8_;
	GHashTable* _tmp15_;
	Game* _tmp16_;
	Game* _tmp17_;
	Shape* _tmp18_;
	GList* _tmp19_;
	g_return_if_fail (self != NULL);
	switch (lines_length1) {
		default:
		{
			game_view_play_sound (self, "land");
			break;
		}
		case 1:
		{
			game_view_play_sound (self, "lines1");
			break;
		}
		case 2:
		{
			game_view_play_sound (self, "lines2");
			break;
		}
		case 3:
		case 4:
		{
			game_view_play_sound (self, "lines3");
			break;
		}
	}
	self->priv->n_lines_destroyed = lines_length1;
	_tmp0_ = self->priv->shape_blocks;
	g_hash_table_iter_init (&shape_iter, _tmp0_);
	while (TRUE) {
		Block* block = NULL;
		BlockWidget* widget = NULL;
		gconstpointer _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
		gboolean _tmp3_;
		Block* _tmp4_;
		BlockWidget* _tmp5_;
		BlockWidget* _tmp6_;
		_tmp3_ = g_hash_table_iter_next (&shape_iter, (gpointer*) (&_tmp1_), (gpointer*) (&_tmp2_));
		_g_object_unref0 (block);
		_tmp4_ = _g_object_ref0 ((Block*) _tmp1_);
		block = _tmp4_;
		_g_object_unref0 (widget);
		_tmp5_ = _g_object_ref0 ((BlockWidget*) _tmp2_);
		widget = _tmp5_;
		if (!_tmp3_) {
			_g_object_unref0 (widget);
			_g_object_unref0 (block);
			break;
		}
		_tmp6_ = widget;
		gtk_widget_unparent ((GtkWidget*) _tmp6_);
		_g_object_unref0 (widget);
		_g_object_unref0 (block);
	}
	_tmp7_ = self->priv->shape_blocks;
	g_hash_table_remove_all (_tmp7_);
	_tmp8_ = self->priv->shadow_blocks;
	g_hash_table_iter_init (&shadow_iter, _tmp8_);
	while (TRUE) {
		Block* block = NULL;
		BlockWidget* widget = NULL;
		gconstpointer _tmp9_ = NULL;
		gconstpointer _tmp10_ = NULL;
		gboolean _tmp11_;
		Block* _tmp12_;
		BlockWidget* _tmp13_;
		BlockWidget* _tmp14_;
		_tmp11_ = g_hash_table_iter_next (&shadow_iter, (gpointer*) (&_tmp9_), (gpointer*) (&_tmp10_));
		_g_object_unref0 (block);
		_tmp12_ = _g_object_ref0 ((Block*) _tmp9_);
		block = _tmp12_;
		_g_object_unref0 (widget);
		_tmp13_ = _g_object_ref0 ((BlockWidget*) _tmp10_);
		widget = _tmp13_;
		if (!_tmp11_) {
			_g_object_unref0 (widget);
			_g_object_unref0 (block);
			break;
		}
		_tmp14_ = widget;
		gtk_widget_unparent ((GtkWidget*) _tmp14_);
		_g_object_unref0 (widget);
		_g_object_unref0 (block);
	}
	_tmp15_ = self->priv->shadow_blocks;
	g_hash_table_remove_all (_tmp15_);
	_tmp16_ = game_view_get_game (self);
	_tmp17_ = _tmp16_;
	_tmp18_ = _tmp17_->shape;
	_tmp19_ = _tmp18_->blocks;
	{
		GList* block_collection = NULL;
		GList* block_it = NULL;
		block_collection = _tmp19_;
		for (block_it = block_collection; block_it != NULL; block_it = block_it->next) {
			Block* _tmp20_;
			Block* block = NULL;
			_tmp20_ = _g_object_ref0 ((Block*) block_it->data);
			block = _tmp20_;
			{
				BlockWidget* widget = NULL;
				Block* _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				BlockWidget* _tmp24_;
				GHashTable* _tmp25_;
				Block* _tmp26_;
				Block* _tmp27_;
				BlockWidget* _tmp28_;
				BlockWidget* _tmp29_;
				BlockWidget* _tmp30_;
				_tmp21_ = block;
				_tmp22_ = game_view_get_theme (self);
				_tmp23_ = _tmp22_;
				_tmp24_ = block_widget_new (_tmp21_, _tmp23_);
				g_object_ref_sink (_tmp24_);
				widget = _tmp24_;
				_tmp25_ = self->priv->blocks;
				_tmp26_ = block;
				_tmp27_ = _g_object_ref0 (_tmp26_);
				_tmp28_ = widget;
				_tmp29_ = _g_object_ref0 (_tmp28_);
				g_hash_table_insert (_tmp25_, _tmp27_, _tmp29_);
				_tmp30_ = widget;
				game_view_add_block_widget (self, _tmp30_);
				_g_object_unref0 (widget);
				_g_object_unref0 (block);
			}
		}
	}
	{
		GList* block_collection = NULL;
		GList* block_it = NULL;
		block_collection = line_blocks;
		for (block_it = block_collection; block_it != NULL; block_it = block_it->next) {
			Block* _tmp31_;
			Block* block = NULL;
			_tmp31_ = _g_object_ref0 ((Block*) block_it->data);
			block = _tmp31_;
			{
				BlockWidget* widget = NULL;
				GHashTable* _tmp32_;
				Block* _tmp33_;
				gconstpointer _tmp34_;
				BlockWidget* _tmp35_;
				BlockWidget* _tmp36_;
				GHashTable* _tmp37_;
				Block* _tmp38_;
				BlockWidget* _tmp39_;
				_tmp32_ = self->priv->blocks;
				_tmp33_ = block;
				_tmp34_ = g_hash_table_lookup (_tmp32_, _tmp33_);
				_tmp35_ = _g_object_ref0 ((BlockWidget*) _tmp34_);
				widget = _tmp35_;
				_tmp36_ = widget;
				game_view_add_block_widget (self, _tmp36_);
				_tmp37_ = self->priv->blocks;
				_tmp38_ = block;
				g_hash_table_remove (_tmp37_, _tmp38_);
				_tmp39_ = widget;
				block_widget_explode (_tmp39_);
				_g_object_unref0 (widget);
				_g_object_unref0 (block);
			}
		}
	}
	gtk_widget_queue_allocate ((GtkWidget*) self);
}

static void
game_view_pause_changed_cb (GameView* self)
{
	g_return_if_fail (self != NULL);
	game_view_update_message (self);
}

static void
game_view_game_complete_cb (GameView* self)
{
	g_return_if_fail (self != NULL);
	game_view_play_sound (self, "gameover");
	game_view_update_message (self);
}

static void
game_view_update_message (GameView* self)
{
	Game* _tmp0_;
	Game* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = game_view_get_game (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = game_get_paused (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		TextOverlay* _tmp4_;
		TextOverlay* _tmp5_;
		_tmp4_ = self->priv->text_overlay;
		text_overlay_set_text (_tmp4_, _ ("Paused"));
		_tmp5_ = self->priv->text_overlay;
		gtk_widget_set_visible ((GtkWidget*) _tmp5_, TRUE);
	} else {
		Game* _tmp6_;
		Game* _tmp7_;
		_tmp6_ = game_view_get_game (self);
		_tmp7_ = _tmp6_;
		if (_tmp7_->game_over) {
			TextOverlay* _tmp8_;
			TextOverlay* _tmp9_;
			_tmp8_ = self->priv->text_overlay;
			text_overlay_set_text (_tmp8_, _ ("Game Over"));
			_tmp9_ = self->priv->text_overlay;
			gtk_widget_set_visible ((GtkWidget*) _tmp9_, TRUE);
		} else {
			TextOverlay* _tmp10_;
			_tmp10_ = self->priv->text_overlay;
			gtk_widget_set_visible ((GtkWidget*) _tmp10_, FALSE);
		}
	}
}

static void
game_view_init_sound (GameView* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GSoundContext* _tmp0_ = NULL;
		GSoundContext* _tmp1_;
		GSoundContext* _tmp2_;
		_tmp1_ = gsound_context_new (NULL, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->sound_context);
		self->priv->sound_context = _tmp2_;
		self->priv->sound_context_state = GAME_VIEW_SOUND_CONTEXT_STATE_WORKING;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("game-view.vala:418: %s", _tmp4_);
		self->priv->sound_context_state = GAME_VIEW_SOUND_CONTEXT_STATE_ERRORED;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
game_view_play_sound (GameView* self,
                      const gchar* name)
{
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->_mute;
	if (!_tmp0_) {
		if (self->priv->sound_context_state == GAME_VIEW_SOUND_CONTEXT_STATE_INITIAL) {
			game_view_init_sound (self);
		}
		if (self->priv->sound_context_state == GAME_VIEW_SOUND_CONTEXT_STATE_WORKING) {
			GSoundContext* _tmp1_;
			_tmp1_ = self->priv->sound_context;
			_game_view_play_sound (name, _tmp1_);
		}
	}
}

static void
_game_view_play_sound (const gchar* _name,
                       GSoundContext* sound_context)
{
	gchar* name = NULL;
	gchar* _tmp0_;
	gchar* path = NULL;
	gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (_name != NULL);
	g_return_if_fail (sound_context != NULL);
	_tmp0_ = g_strconcat (_name, ".ogg", NULL);
	name = _tmp0_;
	_tmp1_ = g_build_filename (SOUND_DIRECTORY, name, NULL);
	path = _tmp1_;
	{
		gsound_context_play_simple (sound_context, NULL, &_inner_error0_, GSOUND_ATTR_MEDIA_NAME, name, GSOUND_ATTR_MEDIA_FILENAME, path, NULL);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("game-view.vala:445: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (path);
		_g_free0 (name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (path);
	_g_free0 (name);
}

Game*
game_view_get_game (GameView* self)
{
	Game* result;
	Game* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_game;
	result = _tmp0_;
	return result;
}

static void
_game_view_shape_added_cb_game_shape_added (Game* _sender,
                                            gpointer self)
{
	game_view_shape_added_cb ((GameView*) self);
}

static void
_game_view_shape_moved_cb_game_shape_moved (Game* _sender,
                                            gpointer self)
{
	game_view_shape_moved_cb ((GameView*) self);
}

static void
_game_view_shape_dropped_cb_game_shape_dropped (Game* _sender,
                                                gpointer self)
{
	game_view_shape_dropped_cb ((GameView*) self);
}

static void
_game_view_shape_rotated_cb_game_shape_rotated (Game* _sender,
                                                gpointer self)
{
	game_view_shape_rotated_cb ((GameView*) self);
}

static void
_game_view_shape_landed_cb_game_shape_landed (Game* _sender,
                                              gint* lines,
                                              gint lines_length1,
                                              GList* line_blocks,
                                              gpointer self)
{
	game_view_shape_landed_cb ((GameView*) self, lines, lines_length1, line_blocks);
}

static void
_game_view_pause_changed_cb_game_pause_changed (Game* _sender,
                                                gpointer self)
{
	game_view_pause_changed_cb ((GameView*) self);
}

static void
_game_view_game_complete_cb_game_complete (Game* _sender,
                                           gpointer self)
{
	game_view_game_complete_cb ((GameView*) self);
}

void
game_view_set_game (GameView* self,
                    Game* value)
{
	Game* _tmp0_;
	Game* _tmp2_;
	Game* _tmp3_;
	Game* _tmp4_;
	Game* _tmp5_;
	Game* _tmp6_;
	Game* _tmp7_;
	Game* _tmp8_;
	Game* _tmp9_;
	Game* _tmp10_;
	Game* _tmp11_;
	Shape* _tmp12_;
	Game* _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	Game* _tmp43_;
	gint _tmp44_;
	gint _tmp45_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_game;
	if (_tmp0_ != NULL) {
		Game* _tmp1_;
		_tmp1_ = self->priv->_game;
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
	}
	_tmp2_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_game);
	self->priv->_game = _tmp2_;
	_tmp3_ = self->priv->_game;
	g_signal_connect_object (_tmp3_, "shape-added", (GCallback) _game_view_shape_added_cb_game_shape_added, self, 0);
	_tmp4_ = self->priv->_game;
	g_signal_connect_object (_tmp4_, "shape-moved", (GCallback) _game_view_shape_moved_cb_game_shape_moved, self, 0);
	_tmp5_ = self->priv->_game;
	g_signal_connect_object (_tmp5_, "shape-dropped", (GCallback) _game_view_shape_dropped_cb_game_shape_dropped, self, 0);
	_tmp6_ = self->priv->_game;
	g_signal_connect_object (_tmp6_, "shape-rotated", (GCallback) _game_view_shape_rotated_cb_game_shape_rotated, self, 0);
	_tmp7_ = self->priv->_game;
	g_signal_connect_object (_tmp7_, "shape-landed", (GCallback) _game_view_shape_landed_cb_game_shape_landed, self, 0);
	_tmp8_ = self->priv->_game;
	g_signal_connect_object (_tmp8_, "pause-changed", (GCallback) _game_view_pause_changed_cb_game_pause_changed, self, 0);
	_tmp9_ = self->priv->_game;
	g_signal_connect_object (_tmp9_, "complete", (GCallback) _game_view_game_complete_cb_game_complete, self, 0);
	game_view_clear_blocks (self);
	_tmp10_ = game_view_get_game (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_->shape;
	if (_tmp12_ != NULL) {
		game_view_shape_added_cb (self);
	}
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp13_ = FALSE;
			_tmp13_ = TRUE;
			while (TRUE) {
				Game* _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
				if (!_tmp13_) {
					gint _tmp14_;
					_tmp14_ = x;
					x = _tmp14_ + 1;
				}
				_tmp13_ = FALSE;
				_tmp15_ = self->priv->_game;
				_tmp16_ = game_get_width (_tmp15_);
				_tmp17_ = _tmp16_;
				if (!(x < _tmp17_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp18_ = FALSE;
						_tmp18_ = TRUE;
						while (TRUE) {
							Game* _tmp20_;
							gint _tmp21_;
							gint _tmp22_;
							Block* block = NULL;
							Game* _tmp23_;
							Block** _tmp24_;
							gint _tmp24__length1;
							gint _tmp24__length2;
							Block* _tmp25_;
							Block* _tmp26_;
							Block* _tmp27_;
							if (!_tmp18_) {
								gint _tmp19_;
								_tmp19_ = y;
								y = _tmp19_ + 1;
							}
							_tmp18_ = FALSE;
							_tmp20_ = self->priv->_game;
							_tmp21_ = game_get_height (_tmp20_);
							_tmp22_ = _tmp21_;
							if (!(y < _tmp22_)) {
								break;
							}
							_tmp23_ = self->priv->_game;
							_tmp24_ = _tmp23_->blocks;
							_tmp24__length1 = _tmp23_->blocks_length1;
							_tmp24__length2 = _tmp23_->blocks_length2;
							_tmp25_ = _tmp24_[(x * _tmp24__length2) + y];
							_tmp26_ = _g_object_ref0 (_tmp25_);
							block = _tmp26_;
							_tmp27_ = block;
							if (_tmp27_ != NULL) {
								BlockWidget* widget = NULL;
								Block* _tmp28_;
								const gchar* _tmp29_;
								const gchar* _tmp30_;
								BlockWidget* _tmp31_;
								BlockWidget* _tmp32_;
								Block* _tmp33_;
								GHashTable* _tmp34_;
								Block* _tmp35_;
								Block* _tmp36_;
								BlockWidget* _tmp37_;
								BlockWidget* _tmp38_;
								BlockWidget* _tmp39_;
								_tmp28_ = block;
								_tmp29_ = game_view_get_theme (self);
								_tmp30_ = _tmp29_;
								_tmp31_ = block_widget_new (_tmp28_, _tmp30_);
								g_object_ref_sink (_tmp31_);
								widget = _tmp31_;
								_tmp32_ = widget;
								_tmp33_ = block;
								block_widget_set_color (_tmp32_, _tmp33_->color);
								_tmp34_ = self->priv->blocks;
								_tmp35_ = block;
								_tmp36_ = _g_object_ref0 (_tmp35_);
								_tmp37_ = widget;
								_tmp38_ = _g_object_ref0 (_tmp37_);
								g_hash_table_insert (_tmp34_, _tmp36_, _tmp38_);
								_tmp39_ = widget;
								game_view_add_block_widget (self, _tmp39_);
								_g_object_unref0 (widget);
							}
							_g_object_unref0 (block);
						}
					}
				}
			}
		}
	}
	_tmp40_ = self->priv->_game;
	_tmp41_ = game_get_width (_tmp40_);
	_tmp42_ = _tmp41_;
	_tmp43_ = self->priv->_game;
	_tmp44_ = game_get_height (_tmp43_);
	_tmp45_ = _tmp44_;
	gtk_widget_set_size_request ((GtkWidget*) self, (_tmp42_ * 190) / _tmp45_, 190);
	game_view_update_message (self);
	g_object_notify_by_pspec ((GObject *) self, game_view_properties[GAME_VIEW_GAME_PROPERTY]);
}

const gchar*
game_view_get_theme (GameView* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_theme;
	result = _tmp0_;
	return result;
}

void
game_view_set_theme (GameView* self,
                     const gchar* value)
{
	const gchar* _tmp0_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	Block* block = NULL;
	BlockWidget* widget = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp6_;
	GHashTable* _tmp13_;
	GHashTable* _tmp20_;
	gchar* _tmp27_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_theme;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = self->priv->_theme;
		_tmp2_ = g_strconcat ("theme-", _tmp1_, NULL);
		_tmp3_ = _tmp2_;
		gtk_widget_remove_css_class ((GtkWidget*) self, _tmp3_);
		_g_free0 (_tmp3_);
	}
	_tmp4_ = g_strconcat ("theme-", value, NULL);
	_tmp5_ = _tmp4_;
	gtk_widget_add_css_class ((GtkWidget*) self, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = self->priv->blocks;
	g_hash_table_iter_init (&iter, _tmp6_);
	while (TRUE) {
		gconstpointer _tmp7_ = NULL;
		gconstpointer _tmp8_ = NULL;
		gboolean _tmp9_;
		Block* _tmp10_;
		BlockWidget* _tmp11_;
		BlockWidget* _tmp12_;
		_tmp9_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp7_), (gpointer*) (&_tmp8_));
		_g_object_unref0 (block);
		_tmp10_ = _g_object_ref0 ((Block*) _tmp7_);
		block = _tmp10_;
		_g_object_unref0 (widget);
		_tmp11_ = _g_object_ref0 ((BlockWidget*) _tmp8_);
		widget = _tmp11_;
		if (!_tmp9_) {
			break;
		}
		_tmp12_ = widget;
		block_widget_set_theme (_tmp12_, value);
	}
	_tmp13_ = self->priv->shape_blocks;
	g_hash_table_iter_init (&iter, _tmp13_);
	while (TRUE) {
		gconstpointer _tmp14_ = NULL;
		gconstpointer _tmp15_ = NULL;
		gboolean _tmp16_;
		Block* _tmp17_;
		BlockWidget* _tmp18_;
		BlockWidget* _tmp19_;
		_tmp16_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp14_), (gpointer*) (&_tmp15_));
		_g_object_unref0 (block);
		_tmp17_ = _g_object_ref0 ((Block*) _tmp14_);
		block = _tmp17_;
		_g_object_unref0 (widget);
		_tmp18_ = _g_object_ref0 ((BlockWidget*) _tmp15_);
		widget = _tmp18_;
		if (!_tmp16_) {
			break;
		}
		_tmp19_ = widget;
		block_widget_set_theme (_tmp19_, value);
	}
	_tmp20_ = self->priv->shadow_blocks;
	g_hash_table_iter_init (&iter, _tmp20_);
	while (TRUE) {
		gconstpointer _tmp21_ = NULL;
		gconstpointer _tmp22_ = NULL;
		gboolean _tmp23_;
		Block* _tmp24_;
		BlockWidget* _tmp25_;
		BlockWidget* _tmp26_;
		_tmp23_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp21_), (gpointer*) (&_tmp22_));
		_g_object_unref0 (block);
		_tmp24_ = _g_object_ref0 ((Block*) _tmp21_);
		block = _tmp24_;
		_g_object_unref0 (widget);
		_tmp25_ = _g_object_ref0 ((BlockWidget*) _tmp22_);
		widget = _tmp25_;
		if (!_tmp23_) {
			break;
		}
		_tmp26_ = widget;
		block_widget_set_theme (_tmp26_, value);
	}
	_tmp27_ = g_strdup (value);
	_g_free0 (self->priv->_theme);
	self->priv->_theme = _tmp27_;
	_g_object_unref0 (widget);
	_g_object_unref0 (block);
	g_object_notify_by_pspec ((GObject *) self, game_view_properties[GAME_VIEW_THEME_PROPERTY]);
}

gboolean
game_view_get_show_shadow (GameView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_shadow;
	return result;
}

void
game_view_set_show_shadow (GameView* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_show_shadow = value;
	gtk_widget_queue_allocate ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, game_view_properties[GAME_VIEW_SHOW_SHADOW_PROPERTY]);
}

static gint
game_view_get_cell_size (GameView* self)
{
	gint result;
	Game* _tmp0_;
	Game* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = game_view_get_game (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		Game* _tmp2_;
		Game* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		Game* _tmp6_;
		Game* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		_tmp2_ = game_view_get_game (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = game_get_width (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = game_view_get_game (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = game_get_height (_tmp7_);
		_tmp9_ = _tmp8_;
		result = MIN (gtk_widget_get_width ((GtkWidget*) self) / _tmp5_, gtk_widget_get_height ((GtkWidget*) self) / _tmp9_);
		return result;
	} else {
		result = 0;
		return result;
	}
}

static gboolean
game_view_get_mute (GameView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_mute;
	return result;
}

void
game_view_set_mute (GameView* self,
                    gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = game_view_get_mute (self);
	if (old_value != value) {
		self->priv->_mute = value;
		g_object_notify_by_pspec ((GObject *) self, game_view_properties[GAME_VIEW_MUTE_PROPERTY]);
	}
}

static void
game_view_class_init (GameViewClass * klass,
                      gpointer klass_data)
{
	game_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GameView_private_offset);
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, gint, gint, gint)) game_view_real_size_allocate;
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) game_view_real_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_game_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_game_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = game_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_GAME_PROPERTY, game_view_properties[GAME_VIEW_GAME_PROPERTY] = g_param_spec_object ("game", "game", "game", TYPE_GAME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_THEME_PROPERTY, game_view_properties[GAME_VIEW_THEME_PROPERTY] = g_param_spec_string ("theme", "theme", "theme", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_SHOW_SHADOW_PROPERTY, game_view_properties[GAME_VIEW_SHOW_SHADOW_PROPERTY] = g_param_spec_boolean ("show-shadow", "show-shadow", "show-shadow", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_MUTE_PROPERTY, game_view_properties[GAME_VIEW_MUTE_PROPERTY] = g_param_spec_boolean ("mute", "mute", "mute", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "game-view");
}

static void
game_view_instance_init (GameView * self,
                         gpointer klass)
{
	self->priv = game_view_get_instance_private (self);
	self->priv->_game = NULL;
	self->priv->_show_shadow = FALSE;
	self->priv->_mute = TRUE;
	self->priv->sound_context_state = GAME_VIEW_SOUND_CONTEXT_STATE_INITIAL;
}

static void
game_view_finalize (GObject * obj)
{
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_VIEW, GameView);
	_g_object_unref0 (self->priv->_game);
	_g_free0 (self->priv->_theme);
	_g_object_unref0 (self->priv->text_overlay);
	_g_hash_table_unref0 (self->priv->blocks);
	_g_hash_table_unref0 (self->priv->shape_blocks);
	_g_hash_table_unref0 (self->priv->shadow_blocks);
	_g_object_unref0 (self->priv->sound_context);
	G_OBJECT_CLASS (game_view_parent_class)->finalize (obj);
}

static GType
game_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameView), 0, (GInstanceInitFunc) game_view_instance_init, NULL };
	GType game_view_type_id;
	game_view_type_id = g_type_register_static (gtk_widget_get_type (), "GameView", &g_define_type_info, 0);
	GameView_private_offset = g_type_add_instance_private (game_view_type_id, sizeof (GameViewPrivate));
	return game_view_type_id;
}

GType
game_view_get_type (void)
{
	static volatile gsize game_view_type_id__once = 0;
	if (g_once_init_enter (&game_view_type_id__once)) {
		GType game_view_type_id;
		game_view_type_id = game_view_get_type_once ();
		g_once_init_leave (&game_view_type_id__once, game_view_type_id);
	}
	return game_view_type_id__once;
}

static void
_vala_game_view_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec)
{
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_VIEW, GameView);
	switch (property_id) {
		case GAME_VIEW_GAME_PROPERTY:
		g_value_set_object (value, game_view_get_game (self));
		break;
		case GAME_VIEW_THEME_PROPERTY:
		g_value_set_string (value, game_view_get_theme (self));
		break;
		case GAME_VIEW_SHOW_SHADOW_PROPERTY:
		g_value_set_boolean (value, game_view_get_show_shadow (self));
		break;
		case GAME_VIEW_MUTE_PROPERTY:
		g_value_set_boolean (value, game_view_get_mute (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_game_view_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec)
{
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_VIEW, GameView);
	switch (property_id) {
		case GAME_VIEW_GAME_PROPERTY:
		game_view_set_game (self, g_value_get_object (value));
		break;
		case GAME_VIEW_THEME_PROPERTY:
		game_view_set_theme (self, g_value_get_string (value));
		break;
		case GAME_VIEW_SHOW_SHADOW_PROPERTY:
		game_view_set_show_shadow (self, g_value_get_boolean (value));
		break;
		case GAME_VIEW_MUTE_PROPERTY:
		game_view_set_mute (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
text_overlay_get_instance_private (TextOverlay* self)
{
	return G_STRUCT_MEMBER_P (self, TextOverlay_private_offset);
}

static void
_text_overlay_draw_gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                               cairo_t* cr,
                                               gint width,
                                               gint height,
                                               gpointer self)
{
	text_overlay_draw ((TextOverlay*) self, drawing_area, cr, width, height);
}

TextOverlay*
text_overlay_construct (GType object_type)
{
	TextOverlay * self = NULL;
	self = (TextOverlay*) g_object_new (object_type, NULL);
	gtk_drawing_area_set_draw_func ((GtkDrawingArea*) self, _text_overlay_draw_gtk_drawing_area_draw_func, g_object_ref (self), g_object_unref);
	return self;
}

TextOverlay*
text_overlay_new (void)
{
	return text_overlay_construct (TYPE_TEXT_OVERLAY);
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

void
text_overlay_draw (TextOverlay* self,
                   GtkDrawingArea* area,
                   cairo_t* cr,
                   gint width,
                   gint height)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint w = 0;
	gint h = 0;
	PangoFontDescription* desc = NULL;
	PangoFontDescription* _tmp2_;
	PangoLayout* layout = NULL;
	PangoLayout* _tmp3_;
	PangoLayout* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	PangoLayout* dummy_layout = NULL;
	PangoLayout* _tmp7_;
	PangoLayout* _tmp8_;
	PangoLayout* _tmp9_;
	PangoFontDescription* _tmp10_;
	gint lw = 0;
	gint lh = 0;
	PangoLayout* _tmp11_;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	PangoFontDescription* _tmp14_;
	PangoLayout* _tmp15_;
	PangoFontDescription* _tmp16_;
	PangoLayout* _tmp17_;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	PangoLayout* _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (area != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = text_overlay_get_text (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	w = gtk_widget_get_width ((GtkWidget*) self);
	h = gtk_widget_get_height ((GtkWidget*) self);
	cairo_translate (cr, (gdouble) (w / 2), (gdouble) (h / 2));
	_tmp2_ = pango_font_description_from_string ("Sans");
	desc = _tmp2_;
	_tmp3_ = pango_cairo_create_layout (cr);
	layout = _tmp3_;
	_tmp4_ = layout;
	_tmp5_ = text_overlay_get_text (self);
	_tmp6_ = _tmp5_;
	pango_layout_set_text (_tmp4_, _tmp6_, -1);
	_tmp7_ = layout;
	_tmp8_ = pango_layout_copy (_tmp7_);
	dummy_layout = _tmp8_;
	_tmp9_ = dummy_layout;
	_tmp10_ = desc;
	pango_layout_set_font_description (_tmp9_, _tmp10_);
	_tmp11_ = dummy_layout;
	pango_layout_get_size (_tmp11_, &_tmp12_, &_tmp13_);
	lw = _tmp12_;
	lh = _tmp13_;
	_tmp14_ = desc;
	pango_font_description_set_absolute_size (_tmp14_, (((((gfloat) lh) / lw) * PANGO_SCALE) * w) * 0.7);
	_tmp15_ = layout;
	_tmp16_ = desc;
	pango_layout_set_font_description (_tmp15_, _tmp16_);
	_tmp17_ = layout;
	pango_layout_get_size (_tmp17_, &_tmp18_, &_tmp19_);
	lw = _tmp18_;
	lh = _tmp19_;
	cairo_move_to (cr, (-(((gdouble) lw) / PANGO_SCALE)) / 2, (-(((gdouble) lh) / PANGO_SCALE)) / 2);
	_tmp20_ = layout;
	pango_cairo_layout_path (cr, _tmp20_);
	cairo_set_source_rgb (cr, 0.333333333333, 0.341176470588, 0.32549019607);
	cairo_set_line_width (cr, width / 100.0);
	cairo_stroke_preserve (cr);
	cairo_set_source_rgb (cr, 1.0, 1.0, 1.0);
	cairo_fill (cr);
	_g_object_unref0 (dummy_layout);
	_g_object_unref0 (layout);
	__vala_PangoFontDescription_free0 (desc);
}

const gchar*
text_overlay_get_text (TextOverlay* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_text;
	result = _tmp0_;
	return result;
}

void
text_overlay_set_text (TextOverlay* self,
                       const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_text);
	self->priv->_text = _tmp0_;
	if (g_strcmp0 (value, _ ("Paused")) == 0) {
		gtk_widget_add_css_class ((GtkWidget*) self, "text-overlay");
	} else {
		gtk_widget_remove_css_class ((GtkWidget*) self, "text-overlay");
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, text_overlay_properties[TEXT_OVERLAY_TEXT_PROPERTY]);
}

static void
text_overlay_class_init (TextOverlayClass * klass,
                         gpointer klass_data)
{
	text_overlay_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TextOverlay_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_text_overlay_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_text_overlay_set_property;
	G_OBJECT_CLASS (klass)->finalize = text_overlay_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TEXT_OVERLAY_TEXT_PROPERTY, text_overlay_properties[TEXT_OVERLAY_TEXT_PROPERTY] = g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
text_overlay_instance_init (TextOverlay * self,
                            gpointer klass)
{
	self->priv = text_overlay_get_instance_private (self);
	self->priv->_text = NULL;
}

static void
text_overlay_finalize (GObject * obj)
{
	TextOverlay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TEXT_OVERLAY, TextOverlay);
	_g_free0 (self->priv->_text);
	G_OBJECT_CLASS (text_overlay_parent_class)->finalize (obj);
}

static GType
text_overlay_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TextOverlayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) text_overlay_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TextOverlay), 0, (GInstanceInitFunc) text_overlay_instance_init, NULL };
	GType text_overlay_type_id;
	text_overlay_type_id = g_type_register_static (gtk_drawing_area_get_type (), "TextOverlay", &g_define_type_info, 0);
	TextOverlay_private_offset = g_type_add_instance_private (text_overlay_type_id, sizeof (TextOverlayPrivate));
	return text_overlay_type_id;
}

GType
text_overlay_get_type (void)
{
	static volatile gsize text_overlay_type_id__once = 0;
	if (g_once_init_enter (&text_overlay_type_id__once)) {
		GType text_overlay_type_id;
		text_overlay_type_id = text_overlay_get_type_once ();
		g_once_init_leave (&text_overlay_type_id__once, text_overlay_type_id);
	}
	return text_overlay_type_id__once;
}

static void
_vala_text_overlay_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	TextOverlay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TEXT_OVERLAY, TextOverlay);
	switch (property_id) {
		case TEXT_OVERLAY_TEXT_PROPERTY:
		g_value_set_string (value, text_overlay_get_text (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_text_overlay_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	TextOverlay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TEXT_OVERLAY, TextOverlay);
	switch (property_id) {
		case TEXT_OVERLAY_TEXT_PROPERTY:
		text_overlay_set_text (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
block_widget_get_instance_private (BlockWidget* self)
{
	return G_STRUCT_MEMBER_P (self, BlockWidget_private_offset);
}

static void
_block_widget_draw_gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                               cairo_t* cr,
                                               gint width,
                                               gint height,
                                               gpointer self)
{
	block_widget_draw ((BlockWidget*) self, drawing_area, cr, width, height);
}

BlockWidget*
block_widget_construct (GType object_type,
                        Block* block,
                        const gchar* theme)
{
	BlockWidget * self = NULL;
	GtkDrawingArea* _tmp0_;
	GtkDrawingArea* _tmp1_;
	GtkDrawingArea* _tmp2_;
	Block* _tmp3_;
	g_return_val_if_fail (block != NULL, NULL);
	self = (BlockWidget*) g_object_new (object_type, NULL);
	_tmp0_ = (GtkDrawingArea*) gtk_drawing_area_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->drawing_area);
	self->priv->drawing_area = _tmp0_;
	_tmp1_ = self->priv->drawing_area;
	gtk_drawing_area_set_draw_func (_tmp1_, _block_widget_draw_gtk_drawing_area_draw_func, g_object_ref (self), g_object_unref);
	_tmp2_ = self->priv->drawing_area;
	gtk_widget_set_parent ((GtkWidget*) _tmp2_, (GtkWidget*) self);
	_tmp3_ = _g_object_ref0 (block);
	_g_object_unref0 (self->block);
	self->block = _tmp3_;
	block_widget_set_color (self, block->color);
	gtk_widget_set_can_target ((GtkWidget*) self, FALSE);
	if (theme != NULL) {
		block_widget_set_theme (self, theme);
	} else {
		block_widget_set_theme (self, "plain");
	}
	return self;
}

BlockWidget*
block_widget_new (Block* block,
                  const gchar* theme)
{
	return block_widget_construct (TYPE_BLOCK_WIDGET, block, theme);
}

static void
block_widget_real_size_allocate (GtkWidget* base,
                                 gint width,
                                 gint height,
                                 gint baseline)
{
	BlockWidget * self;
	GtkDrawingArea* _tmp0_;
	GskTransform* transform = NULL;
	GskTransform* _tmp1_;
	graphene_point_t _tmp2_ = {0};
	GskTransform* _tmp3_;
	GtkDrawingArea* _tmp4_;
	GskTransform* _tmp5_;
	self = (BlockWidget*) base;
	_tmp0_ = self->priv->drawing_area;
	gtk_widget_measure ((GtkWidget*) _tmp0_, GTK_ORIENTATION_HORIZONTAL, width, NULL, NULL, NULL, NULL);
	_tmp1_ = gsk_transform_new ();
	memset (&_tmp2_, 0, sizeof (graphene_point_t));
	_tmp3_ = gsk_transform_translate (_tmp1_, &_tmp2_);
	transform = _tmp3_;
	_tmp4_ = self->priv->drawing_area;
	_tmp5_ = _gsk_transform_ref0 (transform);
	gtk_widget_allocate ((GtkWidget*) _tmp4_, width, height, -1, _tmp5_);
	_gsk_transform_unref0 (transform);
}

static void
block_widget_real_snapshot (GtkWidget* base,
                            GtkSnapshot* snapshot)
{
	BlockWidget * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	self = (BlockWidget*) base;
	g_return_if_fail (snapshot != NULL);
	_tmp0_ = block_widget_get_theme (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("modern")))) {
		switch (0) {
			default:
			{
				block_widget_snapshot_modern (self, snapshot);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				GTK_WIDGET_CLASS (block_widget_parent_class)->snapshot (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), snapshot);
				break;
			}
		}
	}
}

static void
block_widget_snapshot_modern (BlockWidget* self,
                              GtkSnapshot* snapshot)
{
	static const gfloat colors[21] = {0.929411765f, 0.2f, 0.231372549f, 0.341176471f, 0.890196078f, 0.537254902f, 0.384313725f, 0.62745098f, 0.917647059f, 0.964705882f, 0.960784314f, 0.956862745f, 0.97254902f, 0.894117647f, 0.360784314f, 0.752941176f, 0.380392157f, 0.796078431f, 1.0f, 0.639215686f, 0.282352941f};
	gfloat border_width = 0.0F;
	GdkRGBA color = {0};
	gint _tmp0_;
	gint _tmp1_;
	gfloat _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gfloat _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gfloat _tmp8_;
	GdkRGBA _tmp9_ = {0};
	graphene_rect_t rect = {0};
	graphene_point_t _tmp10_ = {0};
	graphene_size_t _tmp11_ = {0};
	graphene_rect_t _tmp12_ = {0};
	GdkRGBA _tmp13_;
	graphene_rect_t _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (snapshot != NULL);
	border_width = 0.05f;
	_tmp0_ = block_widget_get_color (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = colors[_tmp1_ * 3];
	_tmp3_ = block_widget_get_color (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = colors[(_tmp4_ * 3) + 1];
	_tmp6_ = block_widget_get_color (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = colors[(_tmp7_ * 3) + 2];
	memset (&_tmp9_, 0, sizeof (GdkRGBA));
	_tmp9_.red = _tmp2_;
	_tmp9_.green = _tmp5_;
	_tmp9_.blue = _tmp8_;
	_tmp9_.alpha = 1.0f;
	color = _tmp9_;
	memset (&_tmp10_, 0, sizeof (graphene_point_t));
	_tmp10_.x = border_width * gtk_widget_get_width ((GtkWidget*) self);
	_tmp10_.y = border_width * gtk_widget_get_height ((GtkWidget*) self);
	memset (&_tmp11_, 0, sizeof (graphene_size_t));
	_tmp11_.width = (1 - (2 * border_width)) * gtk_widget_get_width ((GtkWidget*) self);
	_tmp11_.height = (1 - (2 * border_width)) * gtk_widget_get_height ((GtkWidget*) self);
	memset (&_tmp12_, 0, sizeof (graphene_rect_t));
	_tmp12_.origin = _tmp10_;
	_tmp12_.size = _tmp11_;
	rect = _tmp12_;
	_tmp13_ = color;
	_tmp14_ = rect;
	gtk_snapshot_append_color (snapshot, &_tmp13_, &_tmp14_);
}

static void
_block_widget_explode_animation_cb_adw_animation_target_func (gdouble value,
                                                              gpointer self)
{
	block_widget_explode_animation_cb ((BlockWidget*) self, value);
}

static void
_block_widget_explode_complete_cb_adw_animation_done (AdwAnimation* _sender,
                                                      gpointer self)
{
	block_widget_explode_complete_cb ((BlockWidget*) self, _sender);
}

void
block_widget_explode (BlockWidget* self)
{
	AdwCallbackAnimationTarget* target = NULL;
	AdwCallbackAnimationTarget* _tmp0_;
	AdwTimedAnimation* animation = NULL;
	AdwAnimationTarget* _tmp1_;
	AdwTimedAnimation* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (AdwCallbackAnimationTarget*) adw_callback_animation_target_new (_block_widget_explode_animation_cb_adw_animation_target_func, g_object_ref (self), g_object_unref);
	target = _tmp0_;
	_tmp1_ = _g_object_ref0 ((AdwAnimationTarget*) target);
	_tmp2_ = (AdwTimedAnimation*) adw_timed_animation_new ((GtkWidget*) self, 0.0, 1.0, (guint) 720, _tmp1_);
	animation = _tmp2_;
	adw_timed_animation_set_easing (animation, ADW_EASE_OUT_QUINT);
	g_signal_connect_object ((AdwAnimation*) animation, "done", (GCallback) _block_widget_explode_complete_cb_adw_animation_done, self, 0);
	self->priv->animation_size_begin = gtk_widget_get_width ((GtkWidget*) self);
	adw_animation_play ((AdwAnimation*) animation);
	_g_object_unref0 (animation);
	_g_object_unref0 (target);
}

static void
block_widget_explode_animation_cb (BlockWidget* self,
                                   gdouble val)
{
	gint size = 0;
	g_return_if_fail (self != NULL);
	gtk_widget_set_opacity ((GtkWidget*) self, 1 - val);
	size = (gint) ((val + 1) * self->priv->animation_size_begin);
	gtk_widget_set_size_request ((GtkWidget*) self, size, size);
}

static void
block_widget_explode_complete_cb (BlockWidget* self,
                                  AdwAnimation* animation)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (animation != NULL);
	gtk_widget_unparent ((GtkWidget*) self);
}

void
block_widget_draw (BlockWidget* self,
                   GtkDrawingArea* area,
                   cairo_t* cr,
                   gint width,
                   gint height)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	static GQuark _tmp3_label2 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (area != NULL);
	g_return_if_fail (cr != NULL);
	cairo_scale (cr, (gdouble) width, (gdouble) height);
	_tmp0_ = block_widget_get_theme (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("clean")))) {
		switch (0) {
			default:
			{
				block_widget_draw_clean (self, cr, width, height);
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("tangoflat")))) {
		switch (0) {
			default:
			{
				block_widget_draw_tango (self, cr, width, height, FALSE);
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label2) ? _tmp3_label2 : (_tmp3_label2 = g_quark_from_static_string ("tangoshaded")))) {
		switch (0) {
			default:
			{
				block_widget_draw_tango (self, cr, width, height, TRUE);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				block_widget_draw_plain (self, cr, width, height);
				break;
			}
		}
	}
}

static void
block_widget_draw_plain (BlockWidget* self,
                         cairo_t* cr,
                         gint width,
                         gint height)
{
	static const gdouble colors[21] = {1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0};
	gint _tmp0_;
	gint _tmp1_;
	gdouble _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gdouble _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gdouble _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = block_widget_get_color (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = colors[_tmp1_ * 3];
	_tmp3_ = block_widget_get_color (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = colors[(_tmp4_ * 3) + 1];
	_tmp6_ = block_widget_get_color (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = colors[(_tmp7_ * 3) + 2];
	cairo_set_source_rgb (cr, _tmp2_, _tmp5_, _tmp8_);
	cairo_paint (cr);
}

static void
block_widget_draw_rounded_rectangle (BlockWidget* self,
                                     cairo_t* cr,
                                     gdouble x,
                                     gdouble y,
                                     gdouble w,
                                     gdouble h,
                                     gdouble r)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	cairo_move_to (cr, x + r, y);
	cairo_line_to (cr, (x + w) - r, y);
	cairo_curve_to (cr, (x + w) - (r / 2), y, x + w, y + (r / 2), x + w, y + r);
	cairo_line_to (cr, x + w, (y + h) - r);
	cairo_curve_to (cr, x + w, (y + h) - (r / 2), (x + w) - (r / 2), y + h, (x + w) - r, y + h);
	cairo_line_to (cr, x + r, y + h);
	cairo_curve_to (cr, x + (r / 2), y + h, x, (y + h) - (r / 2), x, (y + h) - r);
	cairo_line_to (cr, x, y + r);
	cairo_curve_to (cr, x, y + (r / 2), x + (r / 2), y, x + r, y);
}

static void
block_widget_draw_clean (BlockWidget* self,
                         cairo_t* cr,
                         gint width,
                         gint height)
{
	static const gdouble colors[72] = {0.780392156863, 0.247058823529, 0.247058823529, 0.713725490196, 0.192156862745, 0.192156862745, 0.61568627451, 0.164705882353, 0.164705882353, 0.552941176471, 0.788235294118, 0.32549019607, 0.474509803922, 0.713725490196, 0.243137254902, 0.388235294118, 0.596078431373, 0.18431372549, 0.313725490196, 0.450980392157, 0.623529411765, 0.239215686275, 0.345098039216, 0.474509803922, 0.21568627451, 0.313725490196, 0.435294117647, 1.0, 1.0, 1.0, 0.909803921569, 0.909803921569, 0.898039215686, 0.701960784314, 0.701960784314, 0.670588235294, 0.945098039216, 0.878431372549, 0.321568627451, 0.929411764706, 0.839215686275, 0.113725490196, 0.760784313725, 0.682352941176, 0.0274509803922, 0.576470588235, 0.364705882353, 0.607843137255, 0.443137254902, 0.282352941176, 0.46666666666, 0.439215686275, 0.266666666667, 0.46666666666, 0.890196078431, 0.572549019608, 0.258823529412, 0.803921568627, 0.450980392157, 0.101960784314, 0.690196078431, 0.388235294118, 0.0901960784314, 0.392156862745, 0.392156862745, 0.392156862745, 0.262745098039, 0.262745098039, 0.262745098039, 0.21568627451, 0.235294117647, 0.23921568627};
	gint _tmp0_;
	gint _tmp1_;
	gdouble _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gdouble _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gdouble _tmp8_;
	cairo_pattern_t* pat = NULL;
	cairo_pattern_t* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gdouble _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gdouble _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gdouble _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gdouble _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gdouble _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	gdouble _tmp27_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	block_widget_draw_rounded_rectangle (self, cr, 0.05, 0.05, 0.9, 0.9, 0.05);
	_tmp0_ = block_widget_get_color (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = colors[(_tmp1_ * 9) + 6];
	_tmp3_ = block_widget_get_color (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = colors[(_tmp4_ * 9) + 7];
	_tmp6_ = block_widget_get_color (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = colors[(_tmp7_ * 9) + 8];
	cairo_set_source_rgb (cr, _tmp2_, _tmp5_, _tmp8_);
	cairo_set_line_width (cr, 0.1);
	cairo_stroke_preserve (cr);
	_tmp9_ = cairo_pattern_create_linear (0.35, (gdouble) 0, 0.55, 0.9);
	pat = _tmp9_;
	_tmp10_ = block_widget_get_color (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = colors[_tmp11_ * 9];
	_tmp13_ = block_widget_get_color (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = colors[(_tmp14_ * 9) + 1];
	_tmp16_ = block_widget_get_color (self);
	_tmp17_ = _tmp16_;
	_tmp18_ = colors[(_tmp17_ * 9) + 2];
	cairo_pattern_add_color_stop_rgb (pat, 0.0, _tmp12_, _tmp15_, _tmp18_);
	_tmp19_ = block_widget_get_color (self);
	_tmp20_ = _tmp19_;
	_tmp21_ = colors[(_tmp20_ * 9) + 3];
	_tmp22_ = block_widget_get_color (self);
	_tmp23_ = _tmp22_;
	_tmp24_ = colors[(_tmp23_ * 9) + 4];
	_tmp25_ = block_widget_get_color (self);
	_tmp26_ = _tmp25_;
	_tmp27_ = colors[(_tmp26_ * 9) + 5];
	cairo_pattern_add_color_stop_rgb (pat, 1.0, _tmp21_, _tmp24_, _tmp27_);
	cairo_set_source (cr, pat);
	cairo_fill (cr);
	_cairo_pattern_destroy0 (pat);
}

static void
block_widget_draw_tango (BlockWidget* self,
                         cairo_t* cr,
                         gint width,
                         gint height,
                         gboolean use_gradients)
{
	static const gdouble colors[72] = {0.93725490196078431, 0.16078431372549021, 0.16078431372549021, 0.8, 0.0, 0.0, 0.64313725490196083, 0.0, 0.0, 0.54117647058823526, 0.88627450980392153, 0.20392156862745098, 0.45098039215686275, 0.82352941176470584, 0.086274509803921567, 0.30588235294117649, 0.60392156862745094, 0.023529411764705882, 0.44705882352941179, 0.62352941176470589, 0.81176470588235294, 0.20392156862745098, 0.396078431372549, 0.64313725490196083, 0.12549019607843137, 0.29019607843137257, 0.52941176470588236, 0.93333333333333335, 0.93333333333333335, 0.92549019607843142, 0.82745098039215681, 0.84313725490196079, 0.81176470588235294, 0.72941176470588232, 0.74117647058823533, 0.71372549019607845, 0.9882352941176471, 0.9137254901960784, 0.30980392156862746, 0.92941176470588238, 0.83137254901960789, 0.0, 0.7686274509803922, 0.62745098039215685, 0.0, 0.67843137254901964, 0.49803921568627452, 0.6588235294117647, 0.45882352941176469, 0.31372549019607843, 0.4823529411764706, 0.36078431372549019, 0.20784313725490197, 0.4, 0.9882352941176471, 0.68627450980392157, 0.24313725490196078, 0.96078431372549022, 0.47450980392156861, 0.0, 0.80784313725490198, 0.36078431372549019, 0.0, 0.33, 0.34, 0.32, 0.18, 0.2, 0.21, 0.10, 0.12, 0.13};
	gint _tmp31_;
	gint _tmp32_;
	gdouble _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	gdouble _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	gdouble _tmp39_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	if (use_gradients) {
		cairo_pattern_t* pat = NULL;
		cairo_pattern_t* _tmp0_;
		cairo_pattern_t* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gdouble _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gdouble _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gdouble _tmp10_;
		cairo_pattern_t* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gdouble _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gdouble _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gdouble _tmp20_;
		cairo_pattern_t* _tmp21_;
		_tmp0_ = cairo_pattern_create_linear (0.35, (gdouble) 0, 0.55, 0.9);
		pat = _tmp0_;
		_tmp1_ = pat;
		_tmp2_ = block_widget_get_color (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = colors[_tmp3_ * 9];
		_tmp5_ = block_widget_get_color (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = colors[(_tmp6_ * 9) + 1];
		_tmp8_ = block_widget_get_color (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = colors[(_tmp9_ * 9) + 2];
		cairo_pattern_add_color_stop_rgb (_tmp1_, 0.0, _tmp4_, _tmp7_, _tmp10_);
		_tmp11_ = pat;
		_tmp12_ = block_widget_get_color (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = colors[(_tmp13_ * 9) + 3];
		_tmp15_ = block_widget_get_color (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = colors[(_tmp16_ * 9) + 4];
		_tmp18_ = block_widget_get_color (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = colors[(_tmp19_ * 9) + 5];
		cairo_pattern_add_color_stop_rgb (_tmp11_, 1.0, _tmp14_, _tmp17_, _tmp20_);
		_tmp21_ = pat;
		cairo_set_source (cr, _tmp21_);
		_cairo_pattern_destroy0 (pat);
	} else {
		gint _tmp22_;
		gint _tmp23_;
		gdouble _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gdouble _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		gdouble _tmp30_;
		_tmp22_ = block_widget_get_color (self);
		_tmp23_ = _tmp22_;
		_tmp24_ = colors[_tmp23_ * 9];
		_tmp25_ = block_widget_get_color (self);
		_tmp26_ = _tmp25_;
		_tmp27_ = colors[(_tmp26_ * 9) + 1];
		_tmp28_ = block_widget_get_color (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = colors[(_tmp29_ * 9) + 2];
		cairo_set_source_rgb (cr, _tmp24_, _tmp27_, _tmp30_);
	}
	block_widget_draw_rounded_rectangle (self, cr, 0.05, 0.05, 0.9, 0.9, 0.2);
	cairo_fill_preserve (cr);
	_tmp31_ = block_widget_get_color (self);
	_tmp32_ = _tmp31_;
	_tmp33_ = colors[(_tmp32_ * 9) + 6];
	_tmp34_ = block_widget_get_color (self);
	_tmp35_ = _tmp34_;
	_tmp36_ = colors[(_tmp35_ * 9) + 7];
	_tmp37_ = block_widget_get_color (self);
	_tmp38_ = _tmp37_;
	_tmp39_ = colors[(_tmp38_ * 9) + 8];
	cairo_set_source_rgb (cr, _tmp33_, _tmp36_, _tmp39_);
	cairo_set_line_width (cr, 0.1);
	cairo_stroke (cr);
	block_widget_draw_rounded_rectangle (self, cr, 0.15, 0.15, 0.7, 0.7, 0.08);
	if (use_gradients) {
		cairo_pattern_t* pat = NULL;
		cairo_pattern_t* _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		cairo_pattern_t* _tmp47_;
		_tmp40_ = cairo_pattern_create_linear (-0.3, -0.3, 0.8, 0.8);
		pat = _tmp40_;
		_tmp41_ = block_widget_get_color (self);
		_tmp42_ = _tmp41_;
		switch (_tmp42_) {
			case 3:
			case 4:
			{
				cairo_pattern_t* _tmp43_;
				cairo_pattern_t* _tmp44_;
				_tmp43_ = pat;
				cairo_pattern_add_color_stop_rgba (_tmp43_, 0.0, 1.0, 1.0, 1.0, 1.0);
				_tmp44_ = pat;
				cairo_pattern_add_color_stop_rgba (_tmp44_, 1.0, 1.0, 1.0, 1.0, 0.0);
				break;
			}
			default:
			{
				cairo_pattern_t* _tmp45_;
				cairo_pattern_t* _tmp46_;
				_tmp45_ = pat;
				cairo_pattern_add_color_stop_rgba (_tmp45_, 0.0, 0.9295, 0.9295, 0.9295, 1.0);
				_tmp46_ = pat;
				cairo_pattern_add_color_stop_rgba (_tmp46_, 1.0, 0.9295, 0.9295, 0.9295, 0.0);
				break;
			}
		}
		_tmp47_ = pat;
		cairo_set_source (cr, _tmp47_);
		_cairo_pattern_destroy0 (pat);
	} else {
		cairo_set_source_rgba (cr, 1.0, 1.0, 1.0, 0.35);
	}
	cairo_stroke (cr);
}

const gchar*
block_widget_get_theme (BlockWidget* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_theme;
	result = _tmp0_;
	return result;
}

void
block_widget_set_theme (BlockWidget* self,
                        const gchar* value)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GtkDrawingArea* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_theme;
	if (g_strcmp0 (_tmp0_, value) == 0) {
		return;
	}
	_tmp1_ = g_strdup (value);
	_g_free0 (self->priv->_theme);
	self->priv->_theme = _tmp1_;
	_tmp2_ = self->priv->drawing_area;
	gtk_widget_queue_draw ((GtkWidget*) _tmp2_);
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, block_widget_properties[BLOCK_WIDGET_THEME_PROPERTY]);
}

gint
block_widget_get_color (BlockWidget* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_color;
	return result;
}

void
block_widget_set_color (BlockWidget* self,
                        gint value)
{
	gchar* old_color_class = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gint new_color = 0;
	gchar* new_color_class = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	if (self->priv->_color == value) {
		return;
	}
	_tmp0_ = g_strdup_printf ("color-%d", self->priv->_color);
	old_color_class = _tmp0_;
	_tmp1_ = old_color_class;
	gtk_widget_remove_css_class ((GtkWidget*) self, _tmp1_);
	new_color = CLAMP (value, 0, 6);
	_tmp2_ = g_strdup_printf ("color-%d", new_color);
	new_color_class = _tmp2_;
	_tmp3_ = new_color_class;
	gtk_widget_add_css_class ((GtkWidget*) self, _tmp3_);
	self->priv->_color = value;
	_g_free0 (new_color_class);
	_g_free0 (old_color_class);
	g_object_notify_by_pspec ((GObject *) self, block_widget_properties[BLOCK_WIDGET_COLOR_PROPERTY]);
}

static void
block_widget_class_init (BlockWidgetClass * klass,
                         gpointer klass_data)
{
	block_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BlockWidget_private_offset);
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, gint, gint, gint)) block_widget_real_size_allocate;
	((GtkWidgetClass *) klass)->snapshot = (void (*) (GtkWidget*, GtkSnapshot*)) block_widget_real_snapshot;
	G_OBJECT_CLASS (klass)->get_property = _vala_block_widget_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_block_widget_set_property;
	G_OBJECT_CLASS (klass)->finalize = block_widget_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BLOCK_WIDGET_THEME_PROPERTY, block_widget_properties[BLOCK_WIDGET_THEME_PROPERTY] = g_param_spec_string ("theme", "theme", "theme", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BLOCK_WIDGET_COLOR_PROPERTY, block_widget_properties[BLOCK_WIDGET_COLOR_PROPERTY] = g_param_spec_int ("color", "color", "color", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "block");
}

static void
block_widget_instance_init (BlockWidget * self,
                            gpointer klass)
{
	self->priv = block_widget_get_instance_private (self);
	self->priv->_theme = NULL;
	self->priv->_color = -1;
	self->priv->animation_size_begin = 0;
}

static void
block_widget_finalize (GObject * obj)
{
	BlockWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BLOCK_WIDGET, BlockWidget);
	_g_free0 (self->priv->_theme);
	_g_object_unref0 (self->block);
	_g_object_unref0 (self->priv->drawing_area);
	G_OBJECT_CLASS (block_widget_parent_class)->finalize (obj);
}

static GType
block_widget_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BlockWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) block_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BlockWidget), 0, (GInstanceInitFunc) block_widget_instance_init, NULL };
	GType block_widget_type_id;
	block_widget_type_id = g_type_register_static (gtk_widget_get_type (), "BlockWidget", &g_define_type_info, 0);
	BlockWidget_private_offset = g_type_add_instance_private (block_widget_type_id, sizeof (BlockWidgetPrivate));
	return block_widget_type_id;
}

GType
block_widget_get_type (void)
{
	static volatile gsize block_widget_type_id__once = 0;
	if (g_once_init_enter (&block_widget_type_id__once)) {
		GType block_widget_type_id;
		block_widget_type_id = block_widget_get_type_once ();
		g_once_init_leave (&block_widget_type_id__once, block_widget_type_id);
	}
	return block_widget_type_id__once;
}

static void
_vala_block_widget_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	BlockWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BLOCK_WIDGET, BlockWidget);
	switch (property_id) {
		case BLOCK_WIDGET_THEME_PROPERTY:
		g_value_set_string (value, block_widget_get_theme (self));
		break;
		case BLOCK_WIDGET_COLOR_PROPERTY:
		g_value_set_int (value, block_widget_get_color (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_block_widget_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	BlockWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BLOCK_WIDGET, BlockWidget);
	switch (property_id) {
		case BLOCK_WIDGET_THEME_PROPERTY:
		block_widget_set_theme (self, g_value_get_string (value));
		break;
		case BLOCK_WIDGET_COLOR_PROPERTY:
		block_widget_set_color (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

