/* rygel-plugin-information.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from rygel-plugin-information.vala, do not modify */

/*
 * Copyright (C) 2013 Jens Georg.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-core.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gmodule.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	RYGEL_PLUGIN_INFORMATION_0_PROPERTY,
	RYGEL_PLUGIN_INFORMATION_MODULE_PATH_PROPERTY,
	RYGEL_PLUGIN_INFORMATION_NAME_PROPERTY,
	RYGEL_PLUGIN_INFORMATION_CONFLICTS_PROPERTY,
	RYGEL_PLUGIN_INFORMATION_MODULE_LOADED_PROPERTY,
	RYGEL_PLUGIN_INFORMATION_NUM_PROPERTIES
};
static GParamSpec* rygel_plugin_information_properties[RYGEL_PLUGIN_INFORMATION_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _RygelPluginInformationPrivate {
	gchar* _module_path;
	gchar* _name;
	GHashTable* _conflicts;
	gboolean _module_loaded;
};

static gint RygelPluginInformation_private_offset;
static gpointer rygel_plugin_information_parent_class = NULL;

static RygelPluginInformation* rygel_plugin_information_new (const gchar* module_path,
                                                      const gchar* name,
                                                      GHashTable* conflicts);
static RygelPluginInformation* rygel_plugin_information_construct (GType object_type,
                                                            const gchar* module_path,
                                                            const gchar* name,
                                                            GHashTable* conflicts);
static void _g_free0_ (gpointer var);
static void rygel_plugin_information_finalize (GObject * obj);
static GType rygel_plugin_information_get_type_once (void);
static void _vala_rygel_plugin_information_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_rygel_plugin_information_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
rygel_plugin_information_get_instance_private (RygelPluginInformation* self)
{
	return G_STRUCT_MEMBER_P (self, RygelPluginInformation_private_offset);
}

static RygelPluginInformation*
rygel_plugin_information_construct (GType object_type,
                                    const gchar* module_path,
                                    const gchar* name,
                                    GHashTable* conflicts)
{
	RygelPluginInformation * self = NULL;
	g_return_val_if_fail (module_path != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (conflicts != NULL, NULL);
	self = (RygelPluginInformation*) g_object_new (object_type, "module-path", module_path, "name", name, "conflicts", conflicts, NULL);
	return self;
}

static RygelPluginInformation*
rygel_plugin_information_new (const gchar* module_path,
                              const gchar* name,
                              GHashTable* conflicts)
{
	return rygel_plugin_information_construct (RYGEL_TYPE_PLUGIN_INFORMATION, module_path, name, conflicts);
}

/**
     * Factory method to create a #RygelPluginInformation from #GFile.
     *
     * @param file a #GFile pointing to the sidecar file
     * @return A new instance of #RygelPluginInformation
     */
static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

RygelPluginInformation*
rygel_plugin_information_new_from_file (GFile* file,
                                        GError** error)
{
	GKeyFile* keyfile = NULL;
	GKeyFile* _tmp0_;
	GKeyFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GKeyFile* _tmp4_;
	gchar* name = NULL;
	GKeyFile* _tmp6_;
	gchar* _tmp7_;
	gchar* module = NULL;
	GKeyFile* _tmp8_;
	gchar* _tmp9_;
	GFile* module_dir = NULL;
	GFile* _tmp10_;
	GFile* module_file = NULL;
	GFile* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GFile* _tmp15_;
	GFile* _tmp16_;
	GFile* _tmp17_;
	GHashTable* conflicts = NULL;
	GHashFunc _tmp23_;
	GEqualFunc _tmp24_;
	GHashTable* _tmp25_;
	GFile* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	const gchar* _tmp40_;
	GHashTable* _tmp41_;
	RygelPluginInformation* _tmp42_;
	RygelPluginInformation* _tmp43_;
	GError* _inner_error0_ = NULL;
	RygelPluginInformation* result;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = g_key_file_new ();
	keyfile = _tmp0_;
	_tmp1_ = keyfile;
	_tmp2_ = g_file_get_path (file);
	_tmp3_ = _tmp2_;
	g_key_file_load_from_file (_tmp1_, _tmp3_, G_KEY_FILE_NONE, &_inner_error0_);
	_g_free0 (_tmp3_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_key_file_unref0 (keyfile);
		return NULL;
	}
	_tmp4_ = keyfile;
	if (!g_key_file_has_group (_tmp4_, "Plugin")) {
		GError* _tmp5_;
		_tmp5_ = g_error_new_literal (G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND, _ ("[Plugin] group not found"));
		_inner_error0_ = _tmp5_;
		g_propagate_error (error, _inner_error0_);
		_g_key_file_unref0 (keyfile);
		return NULL;
	}
	_tmp6_ = keyfile;
	_tmp7_ = g_key_file_get_string (_tmp6_, "Plugin", "Name", &_inner_error0_);
	name = _tmp7_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_key_file_unref0 (keyfile);
		return NULL;
	}
	_tmp8_ = keyfile;
	_tmp9_ = g_key_file_get_string (_tmp8_, "Plugin", "Module", &_inner_error0_);
	module = _tmp9_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (name);
		_g_key_file_unref0 (keyfile);
		return NULL;
	}
	_tmp10_ = g_file_get_parent (file);
	module_dir = _tmp10_;
	_tmp11_ = module_dir;
	_tmp12_ = module;
	_tmp13_ = g_strdup_printf ("librygel-%s.%s", _tmp12_, G_MODULE_SUFFIX);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_file_get_child (_tmp11_, _tmp14_);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_);
	module_file = _tmp16_;
	_tmp17_ = module_file;
	if (!g_file_query_exists (_tmp17_, NULL)) {
		GFile* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		GError* _tmp21_;
		GError* _tmp22_;
		_tmp18_ = module_file;
		_tmp19_ = g_file_get_path (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_error_new (G_FILE_ERROR, G_FILE_ERROR_EXIST, _ ("Plugin module %s does not exist"), _tmp20_);
		_tmp22_ = _tmp21_;
		_g_free0 (_tmp20_);
		_inner_error0_ = _tmp22_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (module_file);
		_g_object_unref0 (module_dir);
		_g_free0 (module);
		_g_free0 (name);
		_g_key_file_unref0 (keyfile);
		return NULL;
	}
	_tmp23_ = g_str_hash;
	_tmp24_ = g_str_equal;
	_tmp25_ = g_hash_table_new_full (_tmp23_, _tmp24_, NULL, _g_free0_);
	conflicts = _tmp25_;
	{
		gchar** _tmp26_ = NULL;
		GKeyFile* _tmp27_;
		gsize _tmp28_ = 0;
		gchar** _tmp29_;
		gint _tmp26__length1;
		gint __tmp26__size_;
		_tmp27_ = keyfile;
		_tmp29_ = g_key_file_get_string_list (_tmp27_, "Plugin", "Conflicts", &_tmp28_, &_inner_error0_);
		_tmp26_ = _tmp29_;
		_tmp26__length1 = _tmp28_;
		__tmp26__size_ = _tmp26__length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			_g_hash_table_unref0 (conflicts);
			_g_object_unref0 (module_file);
			_g_object_unref0 (module_dir);
			_g_free0 (module);
			_g_free0 (name);
			_g_key_file_unref0 (keyfile);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		{
			gchar** other_name_collection = NULL;
			gint other_name_collection_length1 = 0;
			gint _other_name_collection_size_ = 0;
			gint other_name_it = 0;
			other_name_collection = _tmp26_;
			other_name_collection_length1 = _tmp26__length1;
			for (other_name_it = 0; other_name_it < other_name_collection_length1; other_name_it = other_name_it + 1) {
				gchar* _tmp30_;
				gchar* other_name = NULL;
				_tmp30_ = g_strdup (other_name_collection[other_name_it]);
				other_name = _tmp30_;
				{
					const gchar* _tmp31_;
					gchar* _tmp32_;
					gchar* _tmp33_;
					GHashTable* _tmp34_;
					const gchar* _tmp35_;
					gchar* _tmp36_;
					_tmp31_ = other_name;
					_tmp32_ = string_strip (_tmp31_);
					_tmp33_ = _tmp32_;
					_g_free0 (_tmp33_);
					_tmp34_ = conflicts;
					_tmp35_ = other_name;
					_tmp36_ = g_strdup (_tmp35_);
					g_hash_table_add (_tmp34_, _tmp36_);
					_g_free0 (other_name);
				}
			}
		}
		_tmp26_ = (_vala_array_free (_tmp26_, _tmp26__length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_hash_table_unref0 (conflicts);
		_g_object_unref0 (module_file);
		_g_object_unref0 (module_dir);
		_g_free0 (module);
		_g_free0 (name);
		_g_key_file_unref0 (keyfile);
		return NULL;
	}
	_tmp37_ = module_file;
	_tmp38_ = g_file_get_path (_tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = name;
	_tmp41_ = conflicts;
	_tmp42_ = rygel_plugin_information_new (_tmp39_, _tmp40_, _tmp41_);
	_tmp43_ = _tmp42_;
	_g_free0 (_tmp39_);
	result = _tmp43_;
	_g_hash_table_unref0 (conflicts);
	_g_object_unref0 (module_file);
	_g_object_unref0 (module_dir);
	_g_free0 (module);
	_g_free0 (name);
	_g_key_file_unref0 (keyfile);
	return result;
}

const gchar*
rygel_plugin_information_get_module_path (RygelPluginInformation* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_module_path;
	result = _tmp0_;
	return result;
}

static void
rygel_plugin_information_set_module_path (RygelPluginInformation* self,
                                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_plugin_information_get_module_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_module_path);
		self->priv->_module_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_plugin_information_properties[RYGEL_PLUGIN_INFORMATION_MODULE_PATH_PROPERTY]);
	}
}

const gchar*
rygel_plugin_information_get_name (RygelPluginInformation* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
rygel_plugin_information_set_name (RygelPluginInformation* self,
                                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_plugin_information_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_plugin_information_properties[RYGEL_PLUGIN_INFORMATION_NAME_PROPERTY]);
	}
}

GHashTable*
rygel_plugin_information_get_conflicts (RygelPluginInformation* self)
{
	GHashTable* result;
	GHashTable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_conflicts;
	result = _tmp0_;
	return result;
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

static void
rygel_plugin_information_set_conflicts (RygelPluginInformation* self,
                                        GHashTable* value)
{
	GHashTable* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_plugin_information_get_conflicts (self);
	if (old_value != value) {
		GHashTable* _tmp0_;
		_tmp0_ = _g_hash_table_ref0 (value);
		_g_hash_table_unref0 (self->priv->_conflicts);
		self->priv->_conflicts = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_plugin_information_properties[RYGEL_PLUGIN_INFORMATION_CONFLICTS_PROPERTY]);
	}
}

gboolean
rygel_plugin_information_get_module_loaded (RygelPluginInformation* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_module_loaded;
	return result;
}

void
rygel_plugin_information_set_module_loaded (RygelPluginInformation* self,
                                            gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_plugin_information_get_module_loaded (self);
	if (old_value != value) {
		self->priv->_module_loaded = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_plugin_information_properties[RYGEL_PLUGIN_INFORMATION_MODULE_LOADED_PROPERTY]);
	}
}

static void
rygel_plugin_information_class_init (RygelPluginInformationClass * klass,
                                     gpointer klass_data)
{
	rygel_plugin_information_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelPluginInformation_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_plugin_information_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_plugin_information_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_plugin_information_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_INFORMATION_MODULE_PATH_PROPERTY, rygel_plugin_information_properties[RYGEL_PLUGIN_INFORMATION_MODULE_PATH_PROPERTY] = g_param_spec_string ("module-path", "module-path", "module-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_INFORMATION_NAME_PROPERTY, rygel_plugin_information_properties[RYGEL_PLUGIN_INFORMATION_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_INFORMATION_CONFLICTS_PROPERTY, rygel_plugin_information_properties[RYGEL_PLUGIN_INFORMATION_CONFLICTS_PROPERTY] = g_param_spec_boxed ("conflicts", "conflicts", "conflicts", G_TYPE_HASH_TABLE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_INFORMATION_MODULE_LOADED_PROPERTY, rygel_plugin_information_properties[RYGEL_PLUGIN_INFORMATION_MODULE_LOADED_PROPERTY] = g_param_spec_boolean ("module-loaded", "module-loaded", "module-loaded", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
rygel_plugin_information_instance_init (RygelPluginInformation * self,
                                        gpointer klass)
{
	self->priv = rygel_plugin_information_get_instance_private (self);
	self->priv->_module_loaded = FALSE;
}

static void
rygel_plugin_information_finalize (GObject * obj)
{
	RygelPluginInformation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_PLUGIN_INFORMATION, RygelPluginInformation);
	_g_free0 (self->priv->_module_path);
	_g_free0 (self->priv->_name);
	_g_hash_table_unref0 (self->priv->_conflicts);
	G_OBJECT_CLASS (rygel_plugin_information_parent_class)->finalize (obj);
}

/**
 * Parse plugin sidecar file and provide path to the module.
 *
 * Sidecar files are keyfiles, loosely compatible with the files used by
 * libpeas.
 *
 * A minimal file for the plugin librygel-sompelugin.so looks like this:
 *
 * [Plugin]
 * Name = SomeNameForThePlugin
 * Module = someplugin
 *
 * Name must not contain any whitespaces.
 */
 G_GNUC_NO_INLINE static GType
rygel_plugin_information_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelPluginInformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_plugin_information_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelPluginInformation), 0, (GInstanceInitFunc) rygel_plugin_information_instance_init, NULL };
	GType rygel_plugin_information_type_id;
	rygel_plugin_information_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelPluginInformation", &g_define_type_info, 0);
	RygelPluginInformation_private_offset = g_type_add_instance_private (rygel_plugin_information_type_id, sizeof (RygelPluginInformationPrivate));
	return rygel_plugin_information_type_id;
}

GType
rygel_plugin_information_get_type (void)
{
	static volatile gsize rygel_plugin_information_type_id__once = 0;
	if (g_once_init_enter (&rygel_plugin_information_type_id__once)) {
		GType rygel_plugin_information_type_id;
		rygel_plugin_information_type_id = rygel_plugin_information_get_type_once ();
		g_once_init_leave (&rygel_plugin_information_type_id__once, rygel_plugin_information_type_id);
	}
	return rygel_plugin_information_type_id__once;
}

static void
_vala_rygel_plugin_information_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	RygelPluginInformation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_PLUGIN_INFORMATION, RygelPluginInformation);
	switch (property_id) {
		case RYGEL_PLUGIN_INFORMATION_MODULE_PATH_PROPERTY:
		g_value_set_string (value, rygel_plugin_information_get_module_path (self));
		break;
		case RYGEL_PLUGIN_INFORMATION_NAME_PROPERTY:
		g_value_set_string (value, rygel_plugin_information_get_name (self));
		break;
		case RYGEL_PLUGIN_INFORMATION_CONFLICTS_PROPERTY:
		g_value_set_boxed (value, rygel_plugin_information_get_conflicts (self));
		break;
		case RYGEL_PLUGIN_INFORMATION_MODULE_LOADED_PROPERTY:
		g_value_set_boolean (value, rygel_plugin_information_get_module_loaded (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_plugin_information_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	RygelPluginInformation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_PLUGIN_INFORMATION, RygelPluginInformation);
	switch (property_id) {
		case RYGEL_PLUGIN_INFORMATION_MODULE_PATH_PROPERTY:
		rygel_plugin_information_set_module_path (self, g_value_get_string (value));
		break;
		case RYGEL_PLUGIN_INFORMATION_NAME_PROPERTY:
		rygel_plugin_information_set_name (self, g_value_get_string (value));
		break;
		case RYGEL_PLUGIN_INFORMATION_CONFLICTS_PROPERTY:
		rygel_plugin_information_set_conflicts (self, g_value_get_boxed (value));
		break;
		case RYGEL_PLUGIN_INFORMATION_MODULE_LOADED_PROPERTY:
		rygel_plugin_information_set_module_loaded (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

