/* CrumbleEffect.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from CrumbleEffect.vala, do not modify */

/* Copyright 2010 Maxim Kartashev
 * Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "shotwell-transitions.h"
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "shotwell-plugin-dev-1.0.h"
#include <glib/gi18n-lib.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>

#define CRUMBLE_EFFECT_DESIRED_FPS 25
#define CRUMBLE_EFFECT_MIN_FPS 15
#define CRUMBLE_EFFECT_STRIPE_WIDTH 10
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define TYPE_CRUMBLE_EFFECT_DESCRIPTOR (crumble_effect_descriptor_get_type ())
#define CRUMBLE_EFFECT_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CRUMBLE_EFFECT_DESCRIPTOR, CrumbleEffectDescriptor))
#define CRUMBLE_EFFECT_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CRUMBLE_EFFECT_DESCRIPTOR, CrumbleEffectDescriptorClass))
#define IS_CRUMBLE_EFFECT_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CRUMBLE_EFFECT_DESCRIPTOR))
#define IS_CRUMBLE_EFFECT_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CRUMBLE_EFFECT_DESCRIPTOR))
#define CRUMBLE_EFFECT_DESCRIPTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CRUMBLE_EFFECT_DESCRIPTOR, CrumbleEffectDescriptorClass))

typedef struct _CrumbleEffectDescriptor CrumbleEffectDescriptor;
typedef struct _CrumbleEffectDescriptorClass CrumbleEffectDescriptorClass;
typedef struct _CrumbleEffectDescriptorPrivate CrumbleEffectDescriptorPrivate;
enum  {
	CRUMBLE_EFFECT_DESCRIPTOR_0_PROPERTY,
	CRUMBLE_EFFECT_DESCRIPTOR_NUM_PROPERTIES
};
static GParamSpec* crumble_effect_descriptor_properties[CRUMBLE_EFFECT_DESCRIPTOR_NUM_PROPERTIES];

#define TYPE_CRUMBLE_EFFECT (crumble_effect_get_type ())
#define CRUMBLE_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CRUMBLE_EFFECT, CrumbleEffect))
#define CRUMBLE_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CRUMBLE_EFFECT, CrumbleEffectClass))
#define IS_CRUMBLE_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CRUMBLE_EFFECT))
#define IS_CRUMBLE_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CRUMBLE_EFFECT))
#define CRUMBLE_EFFECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CRUMBLE_EFFECT, CrumbleEffectClass))

typedef struct _CrumbleEffect CrumbleEffect;
typedef struct _CrumbleEffectClass CrumbleEffectClass;
typedef struct _CrumbleEffectPrivate CrumbleEffectPrivate;
enum  {
	CRUMBLE_EFFECT_0_PROPERTY,
	CRUMBLE_EFFECT_NUM_PROPERTIES
};
static GParamSpec* crumble_effect_properties[CRUMBLE_EFFECT_NUM_PROPERTIES];
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _g_rand_free0(var) ((var == NULL) ? NULL : (var = (g_rand_free (var), NULL)))

struct _CrumbleEffectDescriptor {
	ShotwellTransitionDescriptor parent_instance;
	CrumbleEffectDescriptorPrivate * priv;
};

struct _CrumbleEffectDescriptorClass {
	ShotwellTransitionDescriptorClass parent_class;
};

struct _CrumbleEffect {
	GObject parent_instance;
	CrumbleEffectPrivate * priv;
};

struct _CrumbleEffectClass {
	GObjectClass parent_class;
};

struct _CrumbleEffectPrivate {
	cairo_surface_t** from_stripes;
	gint from_stripes_length1;
	gint _from_stripes_size_;
	gdouble* accelerations;
	gint accelerations_length1;
	gint _accelerations_size_;
	gint stripes_count;
};

static gpointer crumble_effect_descriptor_parent_class = NULL;
static gint CrumbleEffect_private_offset;
static gpointer crumble_effect_parent_class = NULL;
static SpitTransitionsEffectIface * crumble_effect_spit_transitions_effect_parent_iface = NULL;

VALA_EXTERN GType crumble_effect_descriptor_get_type (void) G_GNUC_CONST ;
VALA_EXTERN CrumbleEffectDescriptor* crumble_effect_descriptor_new (void);
VALA_EXTERN CrumbleEffectDescriptor* crumble_effect_descriptor_construct (GType object_type);
static const gchar* crumble_effect_descriptor_real_get_id (ShotwellTransitionDescriptor* base);
static const gchar* crumble_effect_descriptor_real_get_pluggable_name (ShotwellTransitionDescriptor* base);
static SpitTransitionsEffect* crumble_effect_descriptor_real_create (ShotwellTransitionDescriptor* base,
                                                              SpitHostInterface* host);
VALA_EXTERN CrumbleEffect* crumble_effect_new (void);
VALA_EXTERN CrumbleEffect* crumble_effect_construct (GType object_type);
VALA_EXTERN GType crumble_effect_get_type (void) G_GNUC_CONST ;
static GType crumble_effect_descriptor_get_type_once (void);
static void crumble_effect_real_get_fps (SpitTransitionsEffect* base,
                                  gint* desired_fps,
                                  gint* min_fps);
static gboolean crumble_effect_real_needs_clear_background (SpitTransitionsEffect* base);
static void crumble_effect_real_start (SpitTransitionsEffect* base,
                                SpitTransitionsVisuals* visuals,
                                SpitTransitionsMotion* motion);
static void crumble_effect_real_paint (SpitTransitionsEffect* base,
                                SpitTransitionsVisuals* visuals,
                                SpitTransitionsMotion* motion,
                                cairo_t* ctx,
                                gint width,
                                gint height,
                                gint frame_number);
static void crumble_effect_real_advance (SpitTransitionsEffect* base,
                                  SpitTransitionsVisuals* visuals,
                                  SpitTransitionsMotion* motion,
                                  gint frame_number);
static void crumble_effect_real_cancel (SpitTransitionsEffect* base);
static void crumble_effect_finalize (GObject * obj);
static GType crumble_effect_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

CrumbleEffectDescriptor*
crumble_effect_descriptor_construct (GType object_type)
{
	CrumbleEffectDescriptor * self = NULL;
	self = (CrumbleEffectDescriptor*) shotwell_transition_descriptor_construct (object_type);
	return self;
}

CrumbleEffectDescriptor*
crumble_effect_descriptor_new (void)
{
	return crumble_effect_descriptor_construct (TYPE_CRUMBLE_EFFECT_DESCRIPTOR);
}

static const gchar*
crumble_effect_descriptor_real_get_id (ShotwellTransitionDescriptor* base)
{
	CrumbleEffectDescriptor * self;
	const gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CRUMBLE_EFFECT_DESCRIPTOR, CrumbleEffectDescriptor);
	result = "org.gnome.shotwell.transitions.crumble";
	return result;
}

static const gchar*
crumble_effect_descriptor_real_get_pluggable_name (ShotwellTransitionDescriptor* base)
{
	CrumbleEffectDescriptor * self;
	const gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CRUMBLE_EFFECT_DESCRIPTOR, CrumbleEffectDescriptor);
	result = _ ("Crumble");
	return result;
}

static SpitTransitionsEffect*
crumble_effect_descriptor_real_create (ShotwellTransitionDescriptor* base,
                                       SpitHostInterface* host)
{
	CrumbleEffectDescriptor * self;
	CrumbleEffect* _tmp0_;
	SpitTransitionsEffect* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CRUMBLE_EFFECT_DESCRIPTOR, CrumbleEffectDescriptor);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (host, SPIT_TYPE_HOST_INTERFACE), NULL);
	_tmp0_ = crumble_effect_new ();
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, SPIT_TRANSITIONS_TYPE_EFFECT, SpitTransitionsEffect);
	return result;
}

static void
crumble_effect_descriptor_class_init (CrumbleEffectDescriptorClass * klass,
                                      gpointer klass_data)
{
	crumble_effect_descriptor_parent_class = g_type_class_peek_parent (klass);
	((ShotwellTransitionDescriptorClass *) klass)->get_id = (const gchar* (*) (ShotwellTransitionDescriptor*)) crumble_effect_descriptor_real_get_id;
	((ShotwellTransitionDescriptorClass *) klass)->get_pluggable_name = (const gchar* (*) (ShotwellTransitionDescriptor*)) crumble_effect_descriptor_real_get_pluggable_name;
	((ShotwellTransitionDescriptorClass *) klass)->create = (SpitTransitionsEffect* (*) (ShotwellTransitionDescriptor*, SpitHostInterface*)) crumble_effect_descriptor_real_create;
}

static void
crumble_effect_descriptor_instance_init (CrumbleEffectDescriptor * self,
                                         gpointer klass)
{
}

static GType
crumble_effect_descriptor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CrumbleEffectDescriptorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) crumble_effect_descriptor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CrumbleEffectDescriptor), 0, (GInstanceInitFunc) crumble_effect_descriptor_instance_init, NULL };
	GType crumble_effect_descriptor_type_id;
	crumble_effect_descriptor_type_id = g_type_register_static (TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, "CrumbleEffectDescriptor", &g_define_type_info, 0);
	return crumble_effect_descriptor_type_id;
}

GType
crumble_effect_descriptor_get_type (void)
{
	static volatile gsize crumble_effect_descriptor_type_id__once = 0;
	if (g_once_init_enter (&crumble_effect_descriptor_type_id__once)) {
		GType crumble_effect_descriptor_type_id;
		crumble_effect_descriptor_type_id = crumble_effect_descriptor_get_type_once ();
		g_once_init_leave (&crumble_effect_descriptor_type_id__once, crumble_effect_descriptor_type_id);
	}
	return crumble_effect_descriptor_type_id__once;
}

static inline gpointer
crumble_effect_get_instance_private (CrumbleEffect* self)
{
	return G_STRUCT_MEMBER_P (self, CrumbleEffect_private_offset);
}

CrumbleEffect*
crumble_effect_construct (GType object_type)
{
	CrumbleEffect * self = NULL;
	self = (CrumbleEffect*) g_object_new (object_type, NULL);
	return self;
}

CrumbleEffect*
crumble_effect_new (void)
{
	return crumble_effect_construct (TYPE_CRUMBLE_EFFECT);
}

static void
crumble_effect_real_get_fps (SpitTransitionsEffect* base,
                             gint* desired_fps,
                             gint* min_fps)
{
	CrumbleEffect * self;
	gint _vala_desired_fps = 0;
	gint _vala_min_fps = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CRUMBLE_EFFECT, CrumbleEffect);
	_vala_desired_fps = CRUMBLE_EFFECT_DESIRED_FPS;
	_vala_min_fps = CRUMBLE_EFFECT_MIN_FPS;
	if (desired_fps) {
		*desired_fps = _vala_desired_fps;
	}
	if (min_fps) {
		*min_fps = _vala_min_fps;
	}
}

static gboolean
crumble_effect_real_needs_clear_background (SpitTransitionsEffect* base)
{
	CrumbleEffect * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CRUMBLE_EFFECT, CrumbleEffect);
	result = TRUE;
	return result;
}

static void
crumble_effect_real_start (SpitTransitionsEffect* base,
                           SpitTransitionsVisuals* visuals,
                           SpitTransitionsMotion* motion)
{
	CrumbleEffect * self;
	GRand* rand = NULL;
	GRand* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CRUMBLE_EFFECT, CrumbleEffect);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (visuals, SPIT_TRANSITIONS_TYPE_VISUALS));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (motion, SPIT_TRANSITIONS_TYPE_MOTION));
	_tmp0_ = g_rand_new ();
	rand = _tmp0_;
	_tmp1_ = spit_transitions_visuals_get_from_pixbuf (visuals);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		GdkPixbuf* _tmp3_;
		GdkPixbuf* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		cairo_surface_t** _tmp7_;
		gdouble* _tmp8_;
		_tmp3_ = spit_transitions_visuals_get_from_pixbuf (visuals);
		_tmp4_ = _tmp3_;
		_tmp5_ = gdk_pixbuf_get_width (_tmp4_);
		_tmp6_ = _tmp5_;
		self->priv->stripes_count = _tmp6_ / CRUMBLE_EFFECT_STRIPE_WIDTH;
		_tmp7_ = g_new0 (cairo_surface_t*, self->priv->stripes_count + 1);
		self->priv->from_stripes = (_vala_array_free (self->priv->from_stripes, self->priv->from_stripes_length1, (GDestroyNotify) cairo_surface_destroy), NULL);
		self->priv->from_stripes = _tmp7_;
		self->priv->from_stripes_length1 = self->priv->stripes_count;
		self->priv->_from_stripes_size_ = self->priv->from_stripes_length1;
		_tmp8_ = g_new0 (gdouble, self->priv->stripes_count);
		self->priv->accelerations = (g_free (self->priv->accelerations), NULL);
		self->priv->accelerations = _tmp8_;
		self->priv->accelerations_length1 = self->priv->stripes_count;
		self->priv->_accelerations_size_ = self->priv->accelerations_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp9_ = FALSE;
				_tmp9_ = TRUE;
				while (TRUE) {
					cairo_surface_t** _tmp11_;
					gint _tmp11__length1;
					GdkPixbuf* _tmp12_;
					GdkPixbuf* _tmp13_;
					gint _tmp14_;
					gint _tmp15_;
					cairo_surface_t* _tmp16_;
					cairo_t* ctx = NULL;
					cairo_surface_t** _tmp17_;
					gint _tmp17__length1;
					cairo_surface_t* _tmp18_;
					cairo_t* _tmp19_;
					cairo_t* _tmp20_;
					GdkPixbuf* _tmp21_;
					GdkPixbuf* _tmp22_;
					cairo_t* _tmp23_;
					gdouble* _tmp24_;
					gint _tmp24__length1;
					GRand* _tmp25_;
					if (!_tmp9_) {
						gint _tmp10_;
						i = i + 1;
						_tmp10_ = i;
					}
					_tmp9_ = FALSE;
					if (!(i < self->priv->stripes_count)) {
						break;
					}
					_tmp11_ = self->priv->from_stripes;
					_tmp11__length1 = self->priv->from_stripes_length1;
					_tmp12_ = spit_transitions_visuals_get_from_pixbuf (visuals);
					_tmp13_ = _tmp12_;
					_tmp14_ = gdk_pixbuf_get_height (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = cairo_image_surface_create (CAIRO_FORMAT_RGB24, CRUMBLE_EFFECT_STRIPE_WIDTH, _tmp15_);
					_cairo_surface_destroy0 (_tmp11_[i]);
					_tmp11_[i] = _tmp16_;
					_tmp17_ = self->priv->from_stripes;
					_tmp17__length1 = self->priv->from_stripes_length1;
					_tmp18_ = _tmp17_[i];
					_tmp19_ = cairo_create (_tmp18_);
					ctx = _tmp19_;
					_tmp20_ = ctx;
					_tmp21_ = spit_transitions_visuals_get_from_pixbuf (visuals);
					_tmp22_ = _tmp21_;
					gdk_cairo_set_source_pixbuf (_tmp20_, _tmp22_, (gdouble) ((-i) * CRUMBLE_EFFECT_STRIPE_WIDTH), (gdouble) 0);
					_tmp23_ = ctx;
					cairo_paint (_tmp23_);
					_tmp24_ = self->priv->accelerations;
					_tmp24__length1 = self->priv->accelerations_length1;
					_tmp25_ = rand;
					_tmp24_[i] = g_rand_double (_tmp25_);
					_cairo_destroy0 (ctx);
				}
			}
		}
	}
	_g_rand_free0 (rand);
}

static void
crumble_effect_real_paint (SpitTransitionsEffect* base,
                           SpitTransitionsVisuals* visuals,
                           SpitTransitionsMotion* motion,
                           cairo_t* ctx,
                           gint width,
                           gint height,
                           gint frame_number)
{
	CrumbleEffect * self;
	gdouble alpha = 0.0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CRUMBLE_EFFECT, CrumbleEffect);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (visuals, SPIT_TRANSITIONS_TYPE_VISUALS));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (motion, SPIT_TRANSITIONS_TYPE_MOTION));
	g_return_if_fail (ctx != NULL);
	alpha = spit_transitions_motion_get_alpha (motion, frame_number);
	if (alpha < 0.5) {
		alpha = alpha * 2;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp0_ = FALSE;
				_tmp0_ = TRUE;
				while (TRUE) {
					gint x = 0;
					GdkRectangle _tmp2_ = {0};
					GdkRectangle _tmp3_;
					gdouble a = 0.0;
					gdouble* _tmp4_;
					gint _tmp4__length1;
					gdouble _tmp5_;
					gint y = 0;
					GdkRectangle _tmp6_ = {0};
					GdkRectangle _tmp7_;
					GdkPixbuf* _tmp8_;
					GdkPixbuf* _tmp9_;
					gint _tmp10_;
					gint _tmp11_;
					cairo_surface_t** _tmp12_;
					gint _tmp12__length1;
					cairo_surface_t* _tmp13_;
					if (!_tmp0_) {
						gint _tmp1_;
						i = i + 1;
						_tmp1_ = i;
					}
					_tmp0_ = FALSE;
					if (!(i < self->priv->stripes_count)) {
						break;
					}
					spit_transitions_visuals_get_from_pos (visuals, &_tmp2_);
					_tmp3_ = _tmp2_;
					x = _tmp3_.x + (i * CRUMBLE_EFFECT_STRIPE_WIDTH);
					_tmp4_ = self->priv->accelerations;
					_tmp4__length1 = self->priv->accelerations_length1;
					_tmp5_ = _tmp4_[i];
					a = alpha + (alpha * _tmp5_);
					spit_transitions_visuals_get_from_pos (visuals, &_tmp6_);
					_tmp7_ = _tmp6_;
					_tmp8_ = spit_transitions_visuals_get_from_pixbuf (visuals);
					_tmp9_ = _tmp8_;
					_tmp10_ = gdk_pixbuf_get_height (_tmp9_);
					_tmp11_ = _tmp10_;
					y = _tmp7_.y + ((gint) ((_tmp11_ * a) * a));
					_tmp12_ = self->priv->from_stripes;
					_tmp12__length1 = self->priv->from_stripes_length1;
					_tmp13_ = _tmp12_[i];
					cairo_set_source_surface (ctx, _tmp13_, (gdouble) x, (gdouble) y);
					cairo_paint (ctx);
				}
			}
		}
	} else {
		GdkPixbuf* _tmp14_;
		GdkPixbuf* _tmp15_;
		_tmp14_ = spit_transitions_visuals_get_to_pixbuf (visuals);
		_tmp15_ = _tmp14_;
		if (_tmp15_ != NULL) {
			GdkPixbuf* _tmp16_;
			GdkPixbuf* _tmp17_;
			GdkRectangle _tmp18_ = {0};
			GdkRectangle _tmp19_;
			GdkRectangle _tmp20_ = {0};
			GdkRectangle _tmp21_;
			alpha = (alpha - 0.5) * 2;
			_tmp16_ = spit_transitions_visuals_get_to_pixbuf (visuals);
			_tmp17_ = _tmp16_;
			spit_transitions_visuals_get_to_pos (visuals, &_tmp18_);
			_tmp19_ = _tmp18_;
			spit_transitions_visuals_get_to_pos (visuals, &_tmp20_);
			_tmp21_ = _tmp20_;
			gdk_cairo_set_source_pixbuf (ctx, _tmp17_, (gdouble) _tmp19_.x, (gdouble) _tmp21_.y);
			cairo_paint_with_alpha (ctx, alpha);
		} else {
		}
	}
}

static void
crumble_effect_real_advance (SpitTransitionsEffect* base,
                             SpitTransitionsVisuals* visuals,
                             SpitTransitionsMotion* motion,
                             gint frame_number)
{
	CrumbleEffect * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CRUMBLE_EFFECT, CrumbleEffect);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (visuals, SPIT_TRANSITIONS_TYPE_VISUALS));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (motion, SPIT_TRANSITIONS_TYPE_MOTION));
}

static void
crumble_effect_real_cancel (SpitTransitionsEffect* base)
{
	CrumbleEffect * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CRUMBLE_EFFECT, CrumbleEffect);
}

static void
crumble_effect_class_init (CrumbleEffectClass * klass,
                           gpointer klass_data)
{
	crumble_effect_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CrumbleEffect_private_offset);
	G_OBJECT_CLASS (klass)->finalize = crumble_effect_finalize;
}

static void
crumble_effect_spit_transitions_effect_interface_init (SpitTransitionsEffectIface * iface,
                                                       gpointer iface_data)
{
	crumble_effect_spit_transitions_effect_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_fps = (void (*) (SpitTransitionsEffect*, gint*, gint*)) crumble_effect_real_get_fps;
	iface->needs_clear_background = (gboolean (*) (SpitTransitionsEffect*)) crumble_effect_real_needs_clear_background;
	iface->start = (void (*) (SpitTransitionsEffect*, SpitTransitionsVisuals*, SpitTransitionsMotion*)) crumble_effect_real_start;
	iface->paint = (void (*) (SpitTransitionsEffect*, SpitTransitionsVisuals*, SpitTransitionsMotion*, cairo_t*, gint, gint, gint)) crumble_effect_real_paint;
	iface->advance = (void (*) (SpitTransitionsEffect*, SpitTransitionsVisuals*, SpitTransitionsMotion*, gint)) crumble_effect_real_advance;
	iface->cancel = (void (*) (SpitTransitionsEffect*)) crumble_effect_real_cancel;
}

static void
crumble_effect_instance_init (CrumbleEffect * self,
                              gpointer klass)
{
	self->priv = crumble_effect_get_instance_private (self);
}

static void
crumble_effect_finalize (GObject * obj)
{
	CrumbleEffect * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CRUMBLE_EFFECT, CrumbleEffect);
	self->priv->from_stripes = (_vala_array_free (self->priv->from_stripes, self->priv->from_stripes_length1, (GDestroyNotify) cairo_surface_destroy), NULL);
	self->priv->accelerations = (g_free (self->priv->accelerations), NULL);
	G_OBJECT_CLASS (crumble_effect_parent_class)->finalize (obj);
}

static GType
crumble_effect_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CrumbleEffectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) crumble_effect_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CrumbleEffect), 0, (GInstanceInitFunc) crumble_effect_instance_init, NULL };
	static const GInterfaceInfo spit_transitions_effect_info = { (GInterfaceInitFunc) crumble_effect_spit_transitions_effect_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType crumble_effect_type_id;
	crumble_effect_type_id = g_type_register_static (G_TYPE_OBJECT, "CrumbleEffect", &g_define_type_info, 0);
	g_type_add_interface_static (crumble_effect_type_id, SPIT_TRANSITIONS_TYPE_EFFECT, &spit_transitions_effect_info);
	CrumbleEffect_private_offset = g_type_add_instance_private (crumble_effect_type_id, sizeof (CrumbleEffectPrivate));
	return crumble_effect_type_id;
}

GType
crumble_effect_get_type (void)
{
	static volatile gsize crumble_effect_type_id__once = 0;
	if (g_once_init_enter (&crumble_effect_type_id__once)) {
		GType crumble_effect_type_id;
		crumble_effect_type_id = crumble_effect_get_type_once ();
		g_once_init_leave (&crumble_effect_type_id__once, crumble_effect_type_id);
	}
	return crumble_effect_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

