/* AppSettingsView.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from AppSettingsView.vala, do not modify */

/*
* Copyright 2020-2024 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Marius Meisenzahl <mariusmeisenzahl@gmail.com>
*/

#include "applications.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <switchboard.h>
#include <granite-7.h>

#define PERMISSIONS_WIDGETS_APP_SETTINGS_VIEW_BACKGROUND_TABLE "background"
#define PERMISSIONS_WIDGETS_APP_SETTINGS_VIEW_BACKGROUND_ID "background"
#define PERMISSIONS_WIDGETS_APP_SETTINGS_VIEW_LOCATION_TABLE "location"
#define PERMISSIONS_WIDGETS_APP_SETTINGS_VIEW_LOCATION_ID "location"
#define PERMISSIONS_WIDGETS_APP_SETTINGS_VIEW_NOTIFICATIONS_TABLE "notifications"
#define PERMISSIONS_WIDGETS_APP_SETTINGS_VIEW_NOTIFICATION_ID "notification"
#define PERMISSIONS_WIDGETS_APP_SETTINGS_VIEW_SCREENSHOT_TABLE "screenshot"
#define PERMISSIONS_WIDGETS_APP_SETTINGS_VIEW_SCREENSHOT_ID "screenshot"
#define PERMISSIONS_WIDGETS_APP_SETTINGS_VIEW_WALLPAPER_TABLE "wallpaper"
#define PERMISSIONS_WIDGETS_APP_SETTINGS_VIEW_WALLPAPER_ID "wallpaper"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PERMISSIONS_WIDGETS_APP_SETTINGS_VIEW_0_PROPERTY,
	PERMISSIONS_WIDGETS_APP_SETTINGS_VIEW_SELECTED_APP_PROPERTY,
	PERMISSIONS_WIDGETS_APP_SETTINGS_VIEW_NUM_PROPERTIES
};
static GParamSpec* permissions_widgets_app_settings_view_properties[PERMISSIONS_WIDGETS_APP_SETTINGS_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
typedef struct _PermissionsWidgetsAppSettingsViewUpdatePermissionsData PermissionsWidgetsAppSettingsViewUpdatePermissionsData;

struct _PermissionsWidgetsAppSettingsViewPrivate {
	PermissionsBackendApp* _selected_app;
	gchar* location_timestamp;
	GtkListBox* sandbox_box;
	GtkListBox* permission_box;
	GtkButton* reset_button;
	PermissionsWidgetsPermissionSettingsWidget* background_row;
	PermissionsWidgetsPermissionSettingsWidget* notifications_row;
	PermissionsWidgetsPermissionSettingsWidget* location_row;
	PermissionsWidgetsPermissionSettingsWidget* screenshot_row;
	PermissionsWidgetsPermissionSettingsWidget* wallpaper_row;
};

struct _Block6Data {
	int _ref_count_;
	PermissionsWidgetsAppSettingsView* self;
	gboolean should_enable_reset;
	PermissionsPermissionStore* permission_store;
};

struct _Block7Data {
	int _ref_count_;
	Block6Data * _data6_;
	PermissionsBackendPermissionSettings* settings;
};

struct _PermissionsWidgetsAppSettingsViewUpdatePermissionsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PermissionsWidgetsAppSettingsView* self;
	PermissionsPermissionStore* permission_store;
	PermissionsPermissionStore* _tmp0_;
	PermissionsPermissionStore* _tmp1_;
	PermissionsPermissionStore* _tmp2_;
	PermissionStoreDBus* _tmp3_;
	PermissionStoreDBus* _tmp4_;
	GtkListBox* _tmp5_;
	GtkListBox* _tmp6_;
	gchar** background_permission;
	PermissionsPermissionStore* _tmp7_;
	PermissionsBackendApp* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gint _tmp11_;
	gchar** _tmp12_;
	gint background_permission_length1;
	gint _background_permission_size_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	const gchar* _tmp14_;
	PermissionsWidgetsPermissionSettingsWidget* _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	const gchar* _tmp17_;
	PermissionsWidgetsPermissionSettingsWidget* _tmp18_;
	GtkWidget* _tmp19_;
	GtkWidget* _tmp20_;
	GtkListBox* _tmp21_;
	PermissionsWidgetsPermissionSettingsWidget* _tmp22_;
	gchar** location_permission;
	PermissionsPermissionStore* _tmp23_;
	PermissionsBackendApp* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	gint _tmp27_;
	gchar** _tmp28_;
	gint location_permission_length1;
	gint _location_permission_size_;
	gchar** _tmp29_;
	gint _tmp29__length1;
	const gchar* _tmp30_;
	PermissionsWidgetsPermissionSettingsWidget* _tmp31_;
	gchar** _tmp32_;
	gint _tmp32__length1;
	const gchar* _tmp33_;
	gchar** _tmp34_;
	gint _tmp34__length1;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	PermissionsWidgetsPermissionSettingsWidget* _tmp37_;
	GtkWidget* _tmp38_;
	GtkWidget* _tmp39_;
	GtkListBox* _tmp40_;
	PermissionsWidgetsPermissionSettingsWidget* _tmp41_;
	gchar** notifications_permission;
	PermissionsPermissionStore* _tmp42_;
	PermissionsBackendApp* _tmp43_;
	const gchar* _tmp44_;
	const gchar* _tmp45_;
	gint _tmp46_;
	gchar** _tmp47_;
	gint notifications_permission_length1;
	gint _notifications_permission_size_;
	gchar** _tmp48_;
	gint _tmp48__length1;
	const gchar* _tmp49_;
	PermissionsWidgetsPermissionSettingsWidget* _tmp50_;
	gchar** _tmp51_;
	gint _tmp51__length1;
	const gchar* _tmp52_;
	PermissionsWidgetsPermissionSettingsWidget* _tmp53_;
	GtkWidget* _tmp54_;
	GtkWidget* _tmp55_;
	GtkListBox* _tmp56_;
	PermissionsWidgetsPermissionSettingsWidget* _tmp57_;
	gchar** screenshot_permission;
	PermissionsPermissionStore* _tmp58_;
	PermissionsBackendApp* _tmp59_;
	const gchar* _tmp60_;
	const gchar* _tmp61_;
	gint _tmp62_;
	gchar** _tmp63_;
	gint screenshot_permission_length1;
	gint _screenshot_permission_size_;
	gchar** _tmp64_;
	gint _tmp64__length1;
	const gchar* _tmp65_;
	PermissionsWidgetsPermissionSettingsWidget* _tmp66_;
	gchar** _tmp67_;
	gint _tmp67__length1;
	const gchar* _tmp68_;
	PermissionsWidgetsPermissionSettingsWidget* _tmp69_;
	GtkWidget* _tmp70_;
	GtkWidget* _tmp71_;
	GtkListBox* _tmp72_;
	PermissionsWidgetsPermissionSettingsWidget* _tmp73_;
	gchar** wallpaper_permission;
	PermissionsPermissionStore* _tmp74_;
	PermissionsBackendApp* _tmp75_;
	const gchar* _tmp76_;
	const gchar* _tmp77_;
	gint _tmp78_;
	gchar** _tmp79_;
	gint wallpaper_permission_length1;
	gint _wallpaper_permission_size_;
	gchar** _tmp80_;
	gint _tmp80__length1;
	const gchar* _tmp81_;
	PermissionsWidgetsPermissionSettingsWidget* _tmp82_;
	gchar** _tmp83_;
	gint _tmp83__length1;
	const gchar* _tmp84_;
	PermissionsWidgetsPermissionSettingsWidget* _tmp85_;
	GtkWidget* _tmp86_;
	GtkWidget* _tmp87_;
	GtkListBox* _tmp88_;
	PermissionsWidgetsPermissionSettingsWidget* _tmp89_;
	GtkListBox* _tmp90_;
	GtkListBox* _tmp91_;
	GtkListBoxRow* _tmp92_;
};

static gint PermissionsWidgetsAppSettingsView_private_offset;
static gpointer permissions_widgets_app_settings_view_parent_class = NULL;

static void permissions_widgets_app_settings_view_update_view (PermissionsWidgetsAppSettingsView* self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda6_ (Block6Data* _data6_,
                 PermissionsBackendPermissionSettings* settings);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda7_ (Block7Data* _data7_);
static void permissions_widgets_app_settings_view_change_permission_settings (PermissionsWidgetsAppSettingsView* self,
                                                                       PermissionsBackendPermissionSettings* settings);
static void ___lambda7__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void ___lambda6__gfunc (gconstpointer data,
                        gpointer self);
static void __lambda13_ (Block6Data* _data6_);
static void ___lambda13__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda14_ (Block6Data* _data6_);
static void ___lambda14__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda15_ (Block6Data* _data6_);
static void ___lambda15__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda16_ (Block6Data* _data6_);
static void ___lambda16__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda17_ (Block6Data* _data6_);
static void ___lambda17__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void permissions_widgets_app_settings_view_update_permissions (PermissionsWidgetsAppSettingsView* self,
                                                               GAsyncReadyCallback _callback_,
                                                               gpointer _user_data_);
static void permissions_widgets_app_settings_view_update_permissions_finish (PermissionsWidgetsAppSettingsView* self,
                                                                      GAsyncResult* _res_);
static void _permissions_widgets_app_settings_view_update_permissions_g_object_notify (GObject* _sender,
                                                                                GParamSpec* pspec,
                                                                                gpointer self);
static void _permissions_widgets_app_settings_view_update_permissions_permissions_permission_store_changed (PermissionsPermissionStore* _sender,
                                                                                                     gpointer self);
static void permissions_widgets_app_settings_view_update_permissions_data_free (gpointer _data);
static gboolean permissions_widgets_app_settings_view_update_permissions_co (PermissionsWidgetsAppSettingsViewUpdatePermissionsData* _data_);
static void permissions_widgets_app_settings_view_update_permissions_ready (GObject* source_object,
                                                                     GAsyncResult* _res_,
                                                                     gpointer _user_data_);
static GObject * permissions_widgets_app_settings_view_constructor (GType type,
                                                             guint n_construct_properties,
                                                             GObjectConstructParam * construct_properties);
static void _permissions_widgets_app_settings_view_update_view_g_object_notify (GObject* _sender,
                                                                         GParamSpec* pspec,
                                                                         gpointer self);
static void _permissions_widgets_app_settings_view___lambda18_ (PermissionsWidgetsAppSettingsView* self,
                                                         GtkListBoxRow* row);
static void __permissions_widgets_app_settings_view___lambda18__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                                     GtkListBoxRow* row,
                                                                                     gpointer self);
static void _permissions_widgets_app_settings_view___lambda19_ (PermissionsWidgetsAppSettingsView* self,
                                                         GtkListBoxRow* row);
static void __permissions_widgets_app_settings_view___lambda19__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                                     GtkListBoxRow* row,
                                                                                     gpointer self);
static void _permissions_widgets_app_settings_view___lambda20_ (PermissionsWidgetsAppSettingsView* self);
static void __permissions_widgets_app_settings_view___lambda20__gtk_button_clicked (GtkButton* _sender,
                                                                             gpointer self);
static void permissions_widgets_app_settings_view_finalize (GObject * obj);
static GType permissions_widgets_app_settings_view_get_type_once (void);
static void _vala_permissions_widgets_app_settings_view_get_property (GObject * object,
                                                               guint property_id,
                                                               GValue * value,
                                                               GParamSpec * pspec);
static void _vala_permissions_widgets_app_settings_view_set_property (GObject * object,
                                                               guint property_id,
                                                               const GValue * value,
                                                               GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
permissions_widgets_app_settings_view_get_instance_private (PermissionsWidgetsAppSettingsView* self)
{
	return G_STRUCT_MEMBER_P (self, PermissionsWidgetsAppSettingsView_private_offset);
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		PermissionsWidgetsAppSettingsView* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->permission_store);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		PermissionsWidgetsAppSettingsView* self;
		self = _data7_->_data6_->self;
		_g_object_unref0 (_data7_->settings);
		block6_data_unref (_data7_->_data6_);
		_data7_->_data6_ = NULL;
		g_slice_free (Block7Data, _data7_);
	}
}

static void
__lambda7_ (Block7Data* _data7_)
{
	Block6Data* _data6_;
	PermissionsWidgetsAppSettingsView* self;
	_data6_ = _data7_->_data6_;
	self = _data6_->self;
	permissions_widgets_app_settings_view_change_permission_settings (self, _data7_->settings);
}

static void
___lambda7__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda7_ (self);
}

static void
__lambda6_ (Block6Data* _data6_,
            PermissionsBackendPermissionSettings* settings)
{
	PermissionsWidgetsAppSettingsView* self;
	Block7Data* _data7_;
	PermissionsBackendPermissionSettings* _tmp0_;
	gchar* description = NULL;
	gchar* _tmp1_;
	gchar* icon_name = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GQuark _tmp7_ = 0U;
	static GQuark _tmp6_label0 = 0;
	static GQuark _tmp6_label1 = 0;
	static GQuark _tmp6_label2 = 0;
	static GQuark _tmp6_label3 = 0;
	static GQuark _tmp6_label4 = 0;
	static GQuark _tmp6_label5 = 0;
	static GQuark _tmp6_label6 = 0;
	static GQuark _tmp6_label7 = 0;
	PermissionsWidgetsPermissionSettingsWidget* override_row = NULL;
	GHashTable* _tmp24_;
	GHashTable* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	gconstpointer _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	PermissionsWidgetsPermissionSettingsWidget* _tmp31_;
	PermissionsWidgetsPermissionSettingsWidget* _tmp32_;
	gboolean _tmp33_;
	gboolean _tmp34_;
	gboolean _tmp35_;
	gboolean _tmp36_;
	GtkListBox* _tmp37_;
	PermissionsWidgetsPermissionSettingsWidget* _tmp38_;
	self = _data6_->self;
	g_return_if_fail (settings != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->_data6_ = block6_data_ref (_data6_);
	_tmp0_ = _g_object_ref0 (settings);
	_g_object_unref0 (_data7_->settings);
	_data7_->settings = _tmp0_;
	_tmp1_ = g_strdup ("Unknown");
	description = _tmp1_;
	_tmp2_ = g_strdup ("image-missing");
	icon_name = _tmp2_;
	_tmp3_ = permissions_backend_permission_settings_get_context (_data7_->settings);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
	if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("filesystems=home")))) {
		switch (0) {
			default:
			{
				gchar* _tmp8_;
				gchar* _tmp9_;
				_tmp8_ = g_strdup (_ ("Including all documents, downloads, music, pictures, videos, and any h" \
"idden folders."));
				_g_free0 (description);
				description = _tmp8_;
				_tmp9_ = g_strdup ("user-home");
				_g_free0 (icon_name);
				icon_name = _tmp9_;
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("filesystems=host")))) {
		switch (0) {
			default:
			{
				gchar* _tmp10_;
				gchar* _tmp11_;
				_tmp10_ = g_strdup (_ ("Including everyone's Home folders, but not including system internals."));
				_g_free0 (description);
				description = _tmp10_;
				_tmp11_ = g_strdup ("drive-harddisk");
				_g_free0 (icon_name);
				icon_name = _tmp11_;
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label2) ? _tmp6_label2 : (_tmp6_label2 = g_quark_from_static_string ("devices=all")))) {
		switch (0) {
			default:
			{
				gchar* _tmp12_;
				gchar* _tmp13_;
				_tmp12_ = g_strdup (_ ("Manage all connected devices, such as webcams, microphones, and USB de" \
"vices."));
				_g_free0 (description);
				description = _tmp12_;
				_tmp13_ = g_strdup ("camera-web");
				_g_free0 (icon_name);
				icon_name = _tmp13_;
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label3) ? _tmp6_label3 : (_tmp6_label3 = g_quark_from_static_string ("shared=network")))) {
		switch (0) {
			default:
			{
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp14_ = g_strdup (_ ("Connect to the Internet and local networks."));
				_g_free0 (description);
				description = _tmp14_;
				_tmp15_ = g_strdup ("preferences-system-network");
				_g_free0 (icon_name);
				icon_name = _tmp15_;
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label4) ? _tmp6_label4 : (_tmp6_label4 = g_quark_from_static_string ("features=bluetooth")))) {
		switch (0) {
			default:
			{
				gchar* _tmp16_;
				gchar* _tmp17_;
				_tmp16_ = g_strdup (_ ("Manage Bluetooth devices including pairing, unpairing, and discovery."));
				_g_free0 (description);
				description = _tmp16_;
				_tmp17_ = g_strdup ("bluetooth");
				_g_free0 (icon_name);
				icon_name = _tmp17_;
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label5) ? _tmp6_label5 : (_tmp6_label5 = g_quark_from_static_string ("sockets=cups")))) {
		switch (0) {
			default:
			{
				gchar* _tmp18_;
				gchar* _tmp19_;
				_tmp18_ = g_strdup (_ ("Manage printers and see the print queue."));
				_g_free0 (description);
				description = _tmp18_;
				_tmp19_ = g_strdup ("printer");
				_g_free0 (icon_name);
				icon_name = _tmp19_;
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label6) ? _tmp6_label6 : (_tmp6_label6 = g_quark_from_static_string ("sockets=ssh-auth")))) {
		switch (0) {
			default:
			{
				gchar* _tmp20_;
				gchar* _tmp21_;
				_tmp20_ = g_strdup (_ ("Connect to other devices on the network via SSH."));
				_g_free0 (description);
				description = _tmp20_;
				_tmp21_ = g_strdup ("utilities-terminal");
				_g_free0 (icon_name);
				icon_name = _tmp21_;
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label7) ? _tmp6_label7 : (_tmp6_label7 = g_quark_from_static_string ("devices=dri")))) {
		switch (0) {
			default:
			{
				gchar* _tmp22_;
				gchar* _tmp23_;
				_tmp22_ = g_strdup (_ ("Accelerate graphical output."));
				_g_free0 (description);
				description = _tmp22_;
				_tmp23_ = g_strdup ("application-x-firmware");
				_g_free0 (icon_name);
				icon_name = _tmp23_;
				break;
			}
		}
	}
	_tmp24_ = permissions_backend_app_get_permission_names ();
	_tmp25_ = _tmp24_;
	_tmp26_ = permissions_backend_permission_settings_get_context (_data7_->settings);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_hash_table_lookup (_tmp25_, _tmp27_);
	_tmp29_ = description;
	_tmp30_ = icon_name;
	_tmp31_ = permissions_widgets_permission_settings_widget_new ((const gchar*) _tmp28_, _tmp29_, _tmp30_);
	g_object_ref_sink (_tmp31_);
	override_row = _tmp31_;
	_tmp32_ = override_row;
	g_object_bind_property_with_closures ((GObject*) _data7_->settings, "enabled", (GObject*) _tmp32_, "active", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	g_signal_connect_data ((GObject*) _data7_->settings, "notify::enabled", (GCallback) ___lambda7__g_object_notify, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	_tmp33_ = permissions_backend_permission_settings_get_enabled (_data7_->settings);
	_tmp34_ = _tmp33_;
	_tmp35_ = permissions_backend_permission_settings_get_standard (_data7_->settings);
	_tmp36_ = _tmp35_;
	if (_tmp34_ != _tmp36_) {
		_data6_->should_enable_reset = TRUE;
	}
	_tmp37_ = self->priv->sandbox_box;
	_tmp38_ = override_row;
	gtk_list_box_append (_tmp37_, (GtkWidget*) _tmp38_);
	_g_object_unref0 (override_row);
	_g_free0 (icon_name);
	_g_free0 (description);
	block7_data_unref (_data7_);
	_data7_ = NULL;
}

static void
___lambda6__gfunc (gconstpointer data,
                   gpointer self)
{
	__lambda6_ (self, (PermissionsBackendPermissionSettings*) data);
}

static void
__lambda13_ (Block6Data* _data6_)
{
	PermissionsWidgetsAppSettingsView* self;
	const gchar* _tmp0_ = NULL;
	PermissionsWidgetsPermissionSettingsWidget* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gchar** permissions = NULL;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gint permissions_length1;
	gint _permissions_size_;
	PermissionsPermissionStore* _tmp6_;
	PermissionsBackendApp* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	self = _data6_->self;
	_tmp1_ = self->priv->background_row;
	_tmp2_ = permissions_widgets_permission_settings_widget_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = "yes";
	} else {
		_tmp0_ = "no";
	}
	_tmp4_ = g_strdup (_tmp0_);
	_tmp5_ = g_new0 (gchar*, 1 + 1);
	_tmp5_[0] = _tmp4_;
	permissions = _tmp5_;
	permissions_length1 = 1;
	_permissions_size_ = permissions_length1;
	_tmp6_ = _data6_->permission_store;
	_tmp7_ = self->priv->_selected_app;
	_tmp8_ = permissions_backend_app_get_id (_tmp7_);
	_tmp9_ = _tmp8_;
	permissions_permission_store_set_permission (_tmp6_, PERMISSIONS_WIDGETS_APP_SETTINGS_VIEW_BACKGROUND_TABLE, PERMISSIONS_WIDGETS_APP_SETTINGS_VIEW_BACKGROUND_ID, _tmp9_, permissions, (gint) permissions_length1);
	permissions = (_vala_array_free (permissions, permissions_length1, (GDestroyNotify) g_free), NULL);
}

static void
___lambda13__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda13_ (self);
}

static void
__lambda14_ (Block6Data* _data6_)
{
	PermissionsWidgetsAppSettingsView* self;
	const gchar* _tmp0_ = NULL;
	PermissionsWidgetsPermissionSettingsWidget* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gchar** permissions = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gint permissions_length1;
	gint _permissions_size_;
	PermissionsPermissionStore* _tmp8_;
	PermissionsBackendApp* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	self = _data6_->self;
	_tmp1_ = self->priv->location_row;
	_tmp2_ = permissions_widgets_permission_settings_widget_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = "EXACT";
	} else {
		_tmp0_ = "NONE";
	}
	_tmp4_ = g_strdup (_tmp0_);
	_tmp5_ = self->priv->location_timestamp;
	_tmp6_ = g_strdup (_tmp5_);
	_tmp7_ = g_new0 (gchar*, 2 + 1);
	_tmp7_[0] = _tmp4_;
	_tmp7_[1] = _tmp6_;
	permissions = _tmp7_;
	permissions_length1 = 2;
	_permissions_size_ = permissions_length1;
	_tmp8_ = _data6_->permission_store;
	_tmp9_ = self->priv->_selected_app;
	_tmp10_ = permissions_backend_app_get_id (_tmp9_);
	_tmp11_ = _tmp10_;
	permissions_permission_store_set_permission (_tmp8_, PERMISSIONS_WIDGETS_APP_SETTINGS_VIEW_LOCATION_TABLE, PERMISSIONS_WIDGETS_APP_SETTINGS_VIEW_LOCATION_ID, _tmp11_, permissions, (gint) permissions_length1);
	permissions = (_vala_array_free (permissions, permissions_length1, (GDestroyNotify) g_free), NULL);
}

static void
___lambda14__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda14_ (self);
}

static void
__lambda15_ (Block6Data* _data6_)
{
	PermissionsWidgetsAppSettingsView* self;
	const gchar* _tmp0_ = NULL;
	PermissionsWidgetsPermissionSettingsWidget* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gchar** permissions = NULL;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gint permissions_length1;
	gint _permissions_size_;
	PermissionsPermissionStore* _tmp6_;
	PermissionsBackendApp* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	self = _data6_->self;
	_tmp1_ = self->priv->notifications_row;
	_tmp2_ = permissions_widgets_permission_settings_widget_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = "yes";
	} else {
		_tmp0_ = "no";
	}
	_tmp4_ = g_strdup (_tmp0_);
	_tmp5_ = g_new0 (gchar*, 1 + 1);
	_tmp5_[0] = _tmp4_;
	permissions = _tmp5_;
	permissions_length1 = 1;
	_permissions_size_ = permissions_length1;
	_tmp6_ = _data6_->permission_store;
	_tmp7_ = self->priv->_selected_app;
	_tmp8_ = permissions_backend_app_get_id (_tmp7_);
	_tmp9_ = _tmp8_;
	permissions_permission_store_set_permission (_tmp6_, PERMISSIONS_WIDGETS_APP_SETTINGS_VIEW_NOTIFICATIONS_TABLE, PERMISSIONS_WIDGETS_APP_SETTINGS_VIEW_NOTIFICATION_ID, _tmp9_, permissions, (gint) permissions_length1);
	permissions = (_vala_array_free (permissions, permissions_length1, (GDestroyNotify) g_free), NULL);
}

static void
___lambda15__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda15_ (self);
}

static void
__lambda16_ (Block6Data* _data6_)
{
	PermissionsWidgetsAppSettingsView* self;
	const gchar* _tmp0_ = NULL;
	PermissionsWidgetsPermissionSettingsWidget* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gchar** permissions = NULL;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gint permissions_length1;
	gint _permissions_size_;
	PermissionsPermissionStore* _tmp6_;
	PermissionsBackendApp* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	self = _data6_->self;
	_tmp1_ = self->priv->screenshot_row;
	_tmp2_ = permissions_widgets_permission_settings_widget_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = "yes";
	} else {
		_tmp0_ = "no";
	}
	_tmp4_ = g_strdup (_tmp0_);
	_tmp5_ = g_new0 (gchar*, 1 + 1);
	_tmp5_[0] = _tmp4_;
	permissions = _tmp5_;
	permissions_length1 = 1;
	_permissions_size_ = permissions_length1;
	_tmp6_ = _data6_->permission_store;
	_tmp7_ = self->priv->_selected_app;
	_tmp8_ = permissions_backend_app_get_id (_tmp7_);
	_tmp9_ = _tmp8_;
	permissions_permission_store_set_permission (_tmp6_, PERMISSIONS_WIDGETS_APP_SETTINGS_VIEW_SCREENSHOT_TABLE, PERMISSIONS_WIDGETS_APP_SETTINGS_VIEW_SCREENSHOT_ID, _tmp9_, permissions, (gint) permissions_length1);
	permissions = (_vala_array_free (permissions, permissions_length1, (GDestroyNotify) g_free), NULL);
}

static void
___lambda16__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda16_ (self);
}

static void
__lambda17_ (Block6Data* _data6_)
{
	PermissionsWidgetsAppSettingsView* self;
	const gchar* _tmp0_ = NULL;
	PermissionsWidgetsPermissionSettingsWidget* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gchar** permissions = NULL;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gint permissions_length1;
	gint _permissions_size_;
	PermissionsPermissionStore* _tmp6_;
	PermissionsBackendApp* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	self = _data6_->self;
	_tmp1_ = self->priv->wallpaper_row;
	_tmp2_ = permissions_widgets_permission_settings_widget_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = "yes";
	} else {
		_tmp0_ = "no";
	}
	_tmp4_ = g_strdup (_tmp0_);
	_tmp5_ = g_new0 (gchar*, 1 + 1);
	_tmp5_[0] = _tmp4_;
	permissions = _tmp5_;
	permissions_length1 = 1;
	_permissions_size_ = permissions_length1;
	_tmp6_ = _data6_->permission_store;
	_tmp7_ = self->priv->_selected_app;
	_tmp8_ = permissions_backend_app_get_id (_tmp7_);
	_tmp9_ = _tmp8_;
	permissions_permission_store_set_permission (_tmp6_, PERMISSIONS_WIDGETS_APP_SETTINGS_VIEW_WALLPAPER_TABLE, PERMISSIONS_WIDGETS_APP_SETTINGS_VIEW_WALLPAPER_ID, _tmp9_, permissions, (gint) permissions_length1);
	permissions = (_vala_array_free (permissions, permissions_length1, (GDestroyNotify) g_free), NULL);
}

static void
___lambda17__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda17_ (self);
}

static void
_permissions_widgets_app_settings_view_update_permissions_g_object_notify (GObject* _sender,
                                                                           GParamSpec* pspec,
                                                                           gpointer self)
{
	permissions_widgets_app_settings_view_update_permissions ((PermissionsWidgetsAppSettingsView*) self, NULL, NULL);
}

static void
_permissions_widgets_app_settings_view_update_permissions_permissions_permission_store_changed (PermissionsPermissionStore* _sender,
                                                                                                gpointer self)
{
	permissions_widgets_app_settings_view_update_permissions ((PermissionsWidgetsAppSettingsView*) self, NULL, NULL);
}

static void
permissions_widgets_app_settings_view_update_view (PermissionsWidgetsAppSettingsView* self)
{
	Block6Data* _data6_;
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	PermissionsBackendApp* _tmp2_;
	PermissionsBackendApp* _tmp3_;
	GPtrArray* _tmp4_;
	PermissionsPermissionStore* _tmp5_;
	PermissionsPermissionStore* _tmp6_;
	PermissionsWidgetsPermissionSettingsWidget* _tmp7_;
	PermissionsWidgetsPermissionSettingsWidget* _tmp8_;
	PermissionsWidgetsPermissionSettingsWidget* _tmp9_;
	PermissionsWidgetsPermissionSettingsWidget* _tmp10_;
	PermissionsWidgetsPermissionSettingsWidget* _tmp11_;
	PermissionsWidgetsPermissionSettingsWidget* _tmp12_;
	PermissionsWidgetsPermissionSettingsWidget* _tmp13_;
	PermissionsWidgetsPermissionSettingsWidget* _tmp14_;
	PermissionsWidgetsPermissionSettingsWidget* _tmp15_;
	PermissionsWidgetsPermissionSettingsWidget* _tmp16_;
	PermissionsPermissionStore* _tmp17_;
	PermissionsPermissionStore* _tmp18_;
	GtkButton* _tmp19_;
	PermissionsBackendApp* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	PermissionsBackendApp* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	PermissionsBackendApp* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	PermissionsBackendApp* _tmp31_;
	GIcon* _tmp32_;
	GIcon* _tmp33_;
	g_return_if_fail (self != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = self->priv->permission_box;
	gtk_list_box_remove_all (_tmp0_);
	_tmp1_ = self->priv->sandbox_box;
	gtk_list_box_remove_all (_tmp1_);
	_tmp2_ = self->priv->_selected_app;
	if (_tmp2_ == NULL) {
		gtk_widget_set_sensitive ((GtkWidget*) self, FALSE);
		block6_data_unref (_data6_);
		_data6_ = NULL;
		return;
	}
	_data6_->should_enable_reset = FALSE;
	_tmp3_ = self->priv->_selected_app;
	_tmp4_ = _tmp3_->settings;
	g_ptr_array_foreach (_tmp4_, ___lambda6__gfunc, _data6_);
	_tmp5_ = permissions_permission_store_get_default ();
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_data6_->permission_store = _tmp6_;
	_tmp7_ = permissions_widgets_permission_settings_widget_new (_ ("Background Activity"), _ ("Perform tasks and use system resources while its window is closed."), "permissions-background");
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->background_row);
	self->priv->background_row = _tmp7_;
	_tmp8_ = self->priv->background_row;
	g_signal_connect_data ((GObject*) _tmp8_, "notify::active", (GCallback) ___lambda13__g_object_notify, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	_tmp9_ = permissions_widgets_permission_settings_widget_new (_ ("Location Services"), _ ("Determine the location of this device."), "preferences-system-privacy-location");
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->location_row);
	self->priv->location_row = _tmp9_;
	_tmp10_ = self->priv->location_row;
	g_signal_connect_data ((GObject*) _tmp10_, "notify::active", (GCallback) ___lambda14__g_object_notify, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	_tmp11_ = permissions_widgets_permission_settings_widget_new (_ ("Notifications"), _ ("Send notification bubbles that may play sound and appear in Notificati" \
"on Center."), "preferences-system-notifications");
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->notifications_row);
	self->priv->notifications_row = _tmp11_;
	_tmp12_ = self->priv->notifications_row;
	g_signal_connect_data ((GObject*) _tmp12_, "notify::active", (GCallback) ___lambda15__g_object_notify, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	_tmp13_ = permissions_widgets_permission_settings_widget_new (_ ("Screenshot"), _ ("Take pictures of the display without asking first."), "accessories-screenshot-tool");
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->screenshot_row);
	self->priv->screenshot_row = _tmp13_;
	_tmp14_ = self->priv->screenshot_row;
	g_signal_connect_data ((GObject*) _tmp14_, "notify::active", (GCallback) ___lambda16__g_object_notify, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	_tmp15_ = permissions_widgets_permission_settings_widget_new (_ ("Wallpaper"), _ ("Set the wallpaper on the desktop and lock screen."), "preferences-desktop-wallpaper");
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->wallpaper_row);
	self->priv->wallpaper_row = _tmp15_;
	_tmp16_ = self->priv->wallpaper_row;
	g_signal_connect_data ((GObject*) _tmp16_, "notify::active", (GCallback) ___lambda17__g_object_notify, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	permissions_widgets_app_settings_view_update_permissions (self, NULL, NULL);
	_tmp17_ = _data6_->permission_store;
	g_signal_connect_object ((GObject*) _tmp17_, "notify::dbus", (GCallback) _permissions_widgets_app_settings_view_update_permissions_g_object_notify, self, 0);
	_tmp18_ = _data6_->permission_store;
	g_signal_connect_object (_tmp18_, "changed", (GCallback) _permissions_widgets_app_settings_view_update_permissions_permissions_permission_store_changed, self, 0);
	gtk_widget_set_sensitive ((GtkWidget*) self, TRUE);
	_tmp19_ = self->priv->reset_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp19_, _data6_->should_enable_reset);
	_tmp20_ = self->priv->_selected_app;
	_tmp21_ = permissions_backend_app_get_name (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_strdup_printf (_ ("%s permissions"), _tmp22_);
	_tmp24_ = _tmp23_;
	gtk_accessible_update_property ((GtkAccessible*) self, GTK_ACCESSIBLE_PROPERTY_LABEL, _tmp24_, -1, -1);
	_g_free0 (_tmp24_);
	_tmp25_ = self->priv->_selected_app;
	_tmp26_ = permissions_backend_app_get_name (_tmp25_);
	_tmp27_ = _tmp26_;
	switchboard_settings_page_set_title ((SwitchboardSettingsPage*) self, _tmp27_);
	_tmp28_ = self->priv->_selected_app;
	_tmp29_ = permissions_backend_app_get_description (_tmp28_);
	_tmp30_ = _tmp29_;
	switchboard_settings_page_set_description ((SwitchboardSettingsPage*) self, _tmp30_);
	_tmp31_ = self->priv->_selected_app;
	_tmp32_ = permissions_backend_app_get_icon (_tmp31_);
	_tmp33_ = _tmp32_;
	switchboard_settings_page_set_icon ((SwitchboardSettingsPage*) self, _tmp33_);
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

static void
permissions_widgets_app_settings_view_update_permissions_data_free (gpointer _data)
{
	PermissionsWidgetsAppSettingsViewUpdatePermissionsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (PermissionsWidgetsAppSettingsViewUpdatePermissionsData, _data_);
}

static void
permissions_widgets_app_settings_view_update_permissions (PermissionsWidgetsAppSettingsView* self,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_)
{
	PermissionsWidgetsAppSettingsViewUpdatePermissionsData* _data_;
	PermissionsWidgetsAppSettingsView* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (PermissionsWidgetsAppSettingsViewUpdatePermissionsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, permissions_widgets_app_settings_view_update_permissions_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	permissions_widgets_app_settings_view_update_permissions_co (_data_);
}

static void
permissions_widgets_app_settings_view_update_permissions_finish (PermissionsWidgetsAppSettingsView* self,
                                                                 GAsyncResult* _res_)
{
	PermissionsWidgetsAppSettingsViewUpdatePermissionsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
permissions_widgets_app_settings_view_update_permissions_ready (GObject* source_object,
                                                                GAsyncResult* _res_,
                                                                gpointer _user_data_)
{
	PermissionsWidgetsAppSettingsViewUpdatePermissionsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	permissions_widgets_app_settings_view_update_permissions_co (_data_);
}

static gboolean
permissions_widgets_app_settings_view_update_permissions_co (PermissionsWidgetsAppSettingsViewUpdatePermissionsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = permissions_permission_store_get_default ();
	_data_->_tmp1_ = _g_object_ref0 (_data_->_tmp0_);
	_data_->permission_store = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->permission_store;
	_data_->_tmp3_ = permissions_permission_store_get_dbus (_data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	if (_data_->_tmp4_ == NULL) {
		_data_->_tmp5_ = _data_->self->priv->permission_box;
		gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp5_, FALSE);
		_g_object_unref0 (_data_->permission_store);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->self->priv->permission_box;
	gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp6_, TRUE);
	_data_->_tmp7_ = _data_->permission_store;
	_data_->_tmp8_ = _data_->self->priv->_selected_app;
	_data_->_tmp9_ = permissions_backend_app_get_id (_data_->_tmp8_);
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp11_ = 0;
	_data_->_state_ = 1;
	permissions_permission_store_get_permission (_data_->_tmp7_, PERMISSIONS_WIDGETS_APP_SETTINGS_VIEW_BACKGROUND_TABLE, PERMISSIONS_WIDGETS_APP_SETTINGS_VIEW_BACKGROUND_ID, _data_->_tmp10_, permissions_widgets_app_settings_view_update_permissions_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp12_ = permissions_permission_store_get_permission_finish (_data_->_tmp7_, _data_->_res_, &_data_->_tmp11_);
	_data_->background_permission = _data_->_tmp12_;
	_data_->background_permission_length1 = _data_->_tmp11_;
	_data_->_background_permission_size_ = _data_->background_permission_length1;
	_data_->_tmp13_ = _data_->background_permission;
	_data_->_tmp13__length1 = _data_->background_permission_length1;
	_data_->_tmp14_ = _data_->_tmp13_[0];
	if (_data_->_tmp14_ != NULL) {
		_data_->_tmp15_ = _data_->self->priv->background_row;
		_data_->_tmp16_ = _data_->background_permission;
		_data_->_tmp16__length1 = _data_->background_permission_length1;
		_data_->_tmp17_ = _data_->_tmp16_[0];
		permissions_widgets_permission_settings_widget_set_active (_data_->_tmp15_, g_strcmp0 (_data_->_tmp17_, "yes") == 0);
		_data_->_tmp18_ = _data_->self->priv->background_row;
		_data_->_tmp19_ = gtk_widget_get_parent ((GtkWidget*) _data_->_tmp18_);
		_data_->_tmp20_ = _data_->_tmp19_;
		if (_data_->_tmp20_ == NULL) {
			_data_->_tmp21_ = _data_->self->priv->permission_box;
			_data_->_tmp22_ = _data_->self->priv->background_row;
			gtk_list_box_append (_data_->_tmp21_, (GtkWidget*) _data_->_tmp22_);
		}
	}
	_data_->_tmp23_ = _data_->permission_store;
	_data_->_tmp24_ = _data_->self->priv->_selected_app;
	_data_->_tmp25_ = permissions_backend_app_get_id (_data_->_tmp24_);
	_data_->_tmp26_ = _data_->_tmp25_;
	_data_->_tmp27_ = 0;
	_data_->_state_ = 2;
	permissions_permission_store_get_permission (_data_->_tmp23_, PERMISSIONS_WIDGETS_APP_SETTINGS_VIEW_LOCATION_TABLE, PERMISSIONS_WIDGETS_APP_SETTINGS_VIEW_LOCATION_ID, _data_->_tmp26_, permissions_widgets_app_settings_view_update_permissions_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp28_ = permissions_permission_store_get_permission_finish (_data_->_tmp23_, _data_->_res_, &_data_->_tmp27_);
	_data_->location_permission = _data_->_tmp28_;
	_data_->location_permission_length1 = _data_->_tmp27_;
	_data_->_location_permission_size_ = _data_->location_permission_length1;
	_data_->_tmp29_ = _data_->location_permission;
	_data_->_tmp29__length1 = _data_->location_permission_length1;
	_data_->_tmp30_ = _data_->_tmp29_[0];
	if (_data_->_tmp30_ != NULL) {
		_data_->_tmp31_ = _data_->self->priv->location_row;
		_data_->_tmp32_ = _data_->location_permission;
		_data_->_tmp32__length1 = _data_->location_permission_length1;
		_data_->_tmp33_ = _data_->_tmp32_[0];
		permissions_widgets_permission_settings_widget_set_active (_data_->_tmp31_, g_strcmp0 (_data_->_tmp33_, "NONE") != 0);
		_data_->_tmp34_ = _data_->location_permission;
		_data_->_tmp34__length1 = _data_->location_permission_length1;
		_data_->_tmp35_ = _data_->_tmp34_[1];
		_data_->_tmp36_ = g_strdup (_data_->_tmp35_);
		_g_free0 (_data_->self->priv->location_timestamp);
		_data_->self->priv->location_timestamp = _data_->_tmp36_;
		_data_->_tmp37_ = _data_->self->priv->location_row;
		_data_->_tmp38_ = gtk_widget_get_parent ((GtkWidget*) _data_->_tmp37_);
		_data_->_tmp39_ = _data_->_tmp38_;
		if (_data_->_tmp39_ == NULL) {
			_data_->_tmp40_ = _data_->self->priv->permission_box;
			_data_->_tmp41_ = _data_->self->priv->location_row;
			gtk_list_box_append (_data_->_tmp40_, (GtkWidget*) _data_->_tmp41_);
		}
	}
	_data_->_tmp42_ = _data_->permission_store;
	_data_->_tmp43_ = _data_->self->priv->_selected_app;
	_data_->_tmp44_ = permissions_backend_app_get_id (_data_->_tmp43_);
	_data_->_tmp45_ = _data_->_tmp44_;
	_data_->_tmp46_ = 0;
	_data_->_state_ = 3;
	permissions_permission_store_get_permission (_data_->_tmp42_, PERMISSIONS_WIDGETS_APP_SETTINGS_VIEW_NOTIFICATIONS_TABLE, PERMISSIONS_WIDGETS_APP_SETTINGS_VIEW_NOTIFICATION_ID, _data_->_tmp45_, permissions_widgets_app_settings_view_update_permissions_ready, _data_);
	return FALSE;
	_state_3:
	_data_->_tmp47_ = permissions_permission_store_get_permission_finish (_data_->_tmp42_, _data_->_res_, &_data_->_tmp46_);
	_data_->notifications_permission = _data_->_tmp47_;
	_data_->notifications_permission_length1 = _data_->_tmp46_;
	_data_->_notifications_permission_size_ = _data_->notifications_permission_length1;
	_data_->_tmp48_ = _data_->notifications_permission;
	_data_->_tmp48__length1 = _data_->notifications_permission_length1;
	_data_->_tmp49_ = _data_->_tmp48_[0];
	if (_data_->_tmp49_ != NULL) {
		_data_->_tmp50_ = _data_->self->priv->notifications_row;
		_data_->_tmp51_ = _data_->notifications_permission;
		_data_->_tmp51__length1 = _data_->notifications_permission_length1;
		_data_->_tmp52_ = _data_->_tmp51_[0];
		permissions_widgets_permission_settings_widget_set_active (_data_->_tmp50_, g_strcmp0 (_data_->_tmp52_, "yes") == 0);
		_data_->_tmp53_ = _data_->self->priv->notifications_row;
		_data_->_tmp54_ = gtk_widget_get_parent ((GtkWidget*) _data_->_tmp53_);
		_data_->_tmp55_ = _data_->_tmp54_;
		if (_data_->_tmp55_ == NULL) {
			_data_->_tmp56_ = _data_->self->priv->permission_box;
			_data_->_tmp57_ = _data_->self->priv->notifications_row;
			gtk_list_box_append (_data_->_tmp56_, (GtkWidget*) _data_->_tmp57_);
		}
	}
	_data_->_tmp58_ = _data_->permission_store;
	_data_->_tmp59_ = _data_->self->priv->_selected_app;
	_data_->_tmp60_ = permissions_backend_app_get_id (_data_->_tmp59_);
	_data_->_tmp61_ = _data_->_tmp60_;
	_data_->_tmp62_ = 0;
	_data_->_state_ = 4;
	permissions_permission_store_get_permission (_data_->_tmp58_, PERMISSIONS_WIDGETS_APP_SETTINGS_VIEW_SCREENSHOT_TABLE, PERMISSIONS_WIDGETS_APP_SETTINGS_VIEW_SCREENSHOT_ID, _data_->_tmp61_, permissions_widgets_app_settings_view_update_permissions_ready, _data_);
	return FALSE;
	_state_4:
	_data_->_tmp63_ = permissions_permission_store_get_permission_finish (_data_->_tmp58_, _data_->_res_, &_data_->_tmp62_);
	_data_->screenshot_permission = _data_->_tmp63_;
	_data_->screenshot_permission_length1 = _data_->_tmp62_;
	_data_->_screenshot_permission_size_ = _data_->screenshot_permission_length1;
	_data_->_tmp64_ = _data_->screenshot_permission;
	_data_->_tmp64__length1 = _data_->screenshot_permission_length1;
	_data_->_tmp65_ = _data_->_tmp64_[0];
	if (_data_->_tmp65_ != NULL) {
		_data_->_tmp66_ = _data_->self->priv->screenshot_row;
		_data_->_tmp67_ = _data_->screenshot_permission;
		_data_->_tmp67__length1 = _data_->screenshot_permission_length1;
		_data_->_tmp68_ = _data_->_tmp67_[0];
		permissions_widgets_permission_settings_widget_set_active (_data_->_tmp66_, g_strcmp0 (_data_->_tmp68_, "yes") == 0);
		_data_->_tmp69_ = _data_->self->priv->screenshot_row;
		_data_->_tmp70_ = gtk_widget_get_parent ((GtkWidget*) _data_->_tmp69_);
		_data_->_tmp71_ = _data_->_tmp70_;
		if (_data_->_tmp71_ == NULL) {
			_data_->_tmp72_ = _data_->self->priv->permission_box;
			_data_->_tmp73_ = _data_->self->priv->screenshot_row;
			gtk_list_box_append (_data_->_tmp72_, (GtkWidget*) _data_->_tmp73_);
		}
	}
	_data_->_tmp74_ = _data_->permission_store;
	_data_->_tmp75_ = _data_->self->priv->_selected_app;
	_data_->_tmp76_ = permissions_backend_app_get_id (_data_->_tmp75_);
	_data_->_tmp77_ = _data_->_tmp76_;
	_data_->_tmp78_ = 0;
	_data_->_state_ = 5;
	permissions_permission_store_get_permission (_data_->_tmp74_, PERMISSIONS_WIDGETS_APP_SETTINGS_VIEW_WALLPAPER_TABLE, PERMISSIONS_WIDGETS_APP_SETTINGS_VIEW_WALLPAPER_ID, _data_->_tmp77_, permissions_widgets_app_settings_view_update_permissions_ready, _data_);
	return FALSE;
	_state_5:
	_data_->_tmp79_ = permissions_permission_store_get_permission_finish (_data_->_tmp74_, _data_->_res_, &_data_->_tmp78_);
	_data_->wallpaper_permission = _data_->_tmp79_;
	_data_->wallpaper_permission_length1 = _data_->_tmp78_;
	_data_->_wallpaper_permission_size_ = _data_->wallpaper_permission_length1;
	_data_->_tmp80_ = _data_->wallpaper_permission;
	_data_->_tmp80__length1 = _data_->wallpaper_permission_length1;
	_data_->_tmp81_ = _data_->_tmp80_[0];
	if (_data_->_tmp81_ != NULL) {
		_data_->_tmp82_ = _data_->self->priv->wallpaper_row;
		_data_->_tmp83_ = _data_->wallpaper_permission;
		_data_->_tmp83__length1 = _data_->wallpaper_permission_length1;
		_data_->_tmp84_ = _data_->_tmp83_[0];
		permissions_widgets_permission_settings_widget_set_active (_data_->_tmp82_, g_strcmp0 (_data_->_tmp84_, "yes") == 0);
		_data_->_tmp85_ = _data_->self->priv->wallpaper_row;
		_data_->_tmp86_ = gtk_widget_get_parent ((GtkWidget*) _data_->_tmp85_);
		_data_->_tmp87_ = _data_->_tmp86_;
		if (_data_->_tmp87_ == NULL) {
			_data_->_tmp88_ = _data_->self->priv->permission_box;
			_data_->_tmp89_ = _data_->self->priv->wallpaper_row;
			gtk_list_box_append (_data_->_tmp88_, (GtkWidget*) _data_->_tmp89_);
		}
	}
	_data_->_tmp90_ = _data_->self->priv->permission_box;
	_data_->_tmp91_ = _data_->self->priv->permission_box;
	_data_->_tmp92_ = gtk_list_box_get_row_at_index (_data_->_tmp91_, 0);
	gtk_widget_set_visible ((GtkWidget*) _data_->_tmp90_, _data_->_tmp92_ != NULL);
	_data_->wallpaper_permission = (_vala_array_free (_data_->wallpaper_permission, _data_->wallpaper_permission_length1, (GDestroyNotify) g_free), NULL);
	_data_->screenshot_permission = (_vala_array_free (_data_->screenshot_permission, _data_->screenshot_permission_length1, (GDestroyNotify) g_free), NULL);
	_data_->notifications_permission = (_vala_array_free (_data_->notifications_permission, _data_->notifications_permission_length1, (GDestroyNotify) g_free), NULL);
	_data_->location_permission = (_vala_array_free (_data_->location_permission, _data_->location_permission_length1, (GDestroyNotify) g_free), NULL);
	_data_->background_permission = (_vala_array_free (_data_->background_permission, _data_->background_permission_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->permission_store);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static void
permissions_widgets_app_settings_view_change_permission_settings (PermissionsWidgetsAppSettingsView* self,
                                                                  PermissionsBackendPermissionSettings* settings)
{
	PermissionsBackendApp* _tmp0_;
	gboolean should_enable_reset = FALSE;
	PermissionsBackendApp* _tmp23_;
	GtkButton* _tmp24_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	_tmp0_ = self->priv->_selected_app;
	if (_tmp0_ == NULL) {
		return;
	}
	should_enable_reset = FALSE;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				PermissionsBackendApp* _tmp3_;
				GPtrArray* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				PermissionsBackendPermissionSettings* s = NULL;
				PermissionsBackendApp* _tmp7_;
				GPtrArray* _tmp8_;
				gconstpointer _tmp9_;
				PermissionsBackendPermissionSettings* _tmp10_;
				PermissionsBackendPermissionSettings* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = self->priv->_selected_app;
				_tmp4_ = _tmp3_->settings;
				_tmp5_ = vala_g_ptr_array_get_length (_tmp4_);
				_tmp6_ = _tmp5_;
				if (!(i < _tmp6_)) {
					break;
				}
				_tmp7_ = self->priv->_selected_app;
				_tmp8_ = _tmp7_->settings;
				_tmp9_ = g_ptr_array_index (_tmp8_, (guint) i);
				_tmp10_ = _g_object_ref0 ((PermissionsBackendPermissionSettings*) _tmp9_);
				s = _tmp10_;
				_tmp11_ = s;
				_tmp12_ = permissions_backend_permission_settings_get_context (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = permissions_backend_permission_settings_get_context (settings);
				_tmp15_ = _tmp14_;
				if (g_strcmp0 (_tmp13_, _tmp15_) == 0) {
					PermissionsBackendPermissionSettings* _tmp16_;
					gboolean _tmp17_;
					gboolean _tmp18_;
					gboolean _tmp19_;
					gboolean _tmp20_;
					gboolean _tmp21_;
					gboolean _tmp22_;
					_tmp16_ = s;
					_tmp17_ = permissions_backend_permission_settings_get_enabled (settings);
					_tmp18_ = _tmp17_;
					permissions_backend_permission_settings_set_enabled (_tmp16_, _tmp18_);
					_tmp19_ = permissions_backend_permission_settings_get_enabled (settings);
					_tmp20_ = _tmp19_;
					_tmp21_ = permissions_backend_permission_settings_get_standard (settings);
					_tmp22_ = _tmp21_;
					if (_tmp20_ != _tmp22_) {
						should_enable_reset = TRUE;
					}
					_g_object_unref0 (s);
					break;
				}
				_g_object_unref0 (s);
			}
		}
	}
	_tmp23_ = self->priv->_selected_app;
	permissions_backend_app_save_overrides (_tmp23_);
	_tmp24_ = self->priv->reset_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp24_, should_enable_reset);
}

PermissionsWidgetsAppSettingsView*
permissions_widgets_app_settings_view_construct (GType object_type)
{
	PermissionsWidgetsAppSettingsView * self = NULL;
	self = (PermissionsWidgetsAppSettingsView*) switchboard_settings_page_construct (object_type);
	return self;
}

PermissionsWidgetsAppSettingsView*
permissions_widgets_app_settings_view_new (void)
{
	return permissions_widgets_app_settings_view_construct (PERMISSIONS_WIDGETS_TYPE_APP_SETTINGS_VIEW);
}

PermissionsBackendApp*
permissions_widgets_app_settings_view_get_selected_app (PermissionsWidgetsAppSettingsView* self)
{
	PermissionsBackendApp* result;
	PermissionsBackendApp* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_selected_app;
	result = _tmp0_;
	return result;
}

void
permissions_widgets_app_settings_view_set_selected_app (PermissionsWidgetsAppSettingsView* self,
                                                        PermissionsBackendApp* value)
{
	PermissionsBackendApp* old_value;
	g_return_if_fail (self != NULL);
	old_value = permissions_widgets_app_settings_view_get_selected_app (self);
	if (old_value != value) {
		PermissionsBackendApp* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_selected_app);
		self->priv->_selected_app = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, permissions_widgets_app_settings_view_properties[PERMISSIONS_WIDGETS_APP_SETTINGS_VIEW_SELECTED_APP_PROPERTY]);
	}
}

static void
_permissions_widgets_app_settings_view_update_view_g_object_notify (GObject* _sender,
                                                                    GParamSpec* pspec,
                                                                    gpointer self)
{
	permissions_widgets_app_settings_view_update_view ((PermissionsWidgetsAppSettingsView*) self);
}

static void
_permissions_widgets_app_settings_view___lambda18_ (PermissionsWidgetsAppSettingsView* self,
                                                    GtkListBoxRow* row)
{
	g_return_if_fail (row != NULL);
	if (PERMISSIONS_WIDGETS_IS_PERMISSION_SETTINGS_WIDGET (row)) {
		gboolean _tmp0_;
		gboolean _tmp1_;
		_tmp0_ = permissions_widgets_permission_settings_widget_get_active ((PermissionsWidgetsPermissionSettingsWidget*) row);
		_tmp1_ = _tmp0_;
		permissions_widgets_permission_settings_widget_set_active ((PermissionsWidgetsPermissionSettingsWidget*) row, !_tmp1_);
	}
}

static void
__permissions_widgets_app_settings_view___lambda18__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                                GtkListBoxRow* row,
                                                                                gpointer self)
{
	_permissions_widgets_app_settings_view___lambda18_ ((PermissionsWidgetsAppSettingsView*) self, row);
}

static void
_permissions_widgets_app_settings_view___lambda19_ (PermissionsWidgetsAppSettingsView* self,
                                                    GtkListBoxRow* row)
{
	g_return_if_fail (row != NULL);
	if (PERMISSIONS_WIDGETS_IS_PERMISSION_SETTINGS_WIDGET (row)) {
		gboolean _tmp0_;
		gboolean _tmp1_;
		_tmp0_ = permissions_widgets_permission_settings_widget_get_active ((PermissionsWidgetsPermissionSettingsWidget*) row);
		_tmp1_ = _tmp0_;
		permissions_widgets_permission_settings_widget_set_active ((PermissionsWidgetsPermissionSettingsWidget*) row, !_tmp1_);
	}
}

static void
__permissions_widgets_app_settings_view___lambda19__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                                GtkListBoxRow* row,
                                                                                gpointer self)
{
	_permissions_widgets_app_settings_view___lambda19_ ((PermissionsWidgetsAppSettingsView*) self, row);
}

static void
_permissions_widgets_app_settings_view___lambda20_ (PermissionsWidgetsAppSettingsView* self)
{
	PermissionsBackendApp* _tmp0_;
	_tmp0_ = self->priv->_selected_app;
	if (_tmp0_ != NULL) {
		PermissionsBackendApp* _tmp1_;
		_tmp1_ = self->priv->_selected_app;
		permissions_backend_app_reset_settings_to_standard (_tmp1_);
		permissions_widgets_app_settings_view_update_view (self);
	}
}

static void
__permissions_widgets_app_settings_view___lambda20__gtk_button_clicked (GtkButton* _sender,
                                                                        gpointer self)
{
	_permissions_widgets_app_settings_view___lambda20_ ((PermissionsWidgetsAppSettingsView*) self);
}

static GObject *
permissions_widgets_app_settings_view_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PermissionsWidgetsAppSettingsView * self;
	GtkListBox* _tmp0_ = NULL;
	GtkListBox* _tmp1_;
	GtkListBox* _tmp2_;
	GtkListBox* _tmp3_ = NULL;
	GtkListBox* _tmp4_;
	GtkListBox* _tmp5_;
	GraniteHeaderLabel* sandbox_header = NULL;
	GtkListBox* _tmp6_;
	GtkWidget* _tmp7_;
	gchar* _tmp8_;
	GraniteHeaderLabel* _tmp9_ = NULL;
	GtkButton* _tmp10_ = NULL;
	GtkBox* box = NULL;
	GtkBox* _tmp11_;
	GtkBox* _tmp12_;
	GtkListBox* _tmp13_;
	GtkBox* _tmp14_;
	GraniteHeaderLabel* _tmp15_;
	GtkBox* _tmp16_;
	GtkListBox* _tmp17_;
	GtkBox* _tmp18_;
	GtkButton* _tmp19_;
	GtkBox* _tmp20_;
	GtkListBox* _tmp21_;
	GtkListBox* _tmp22_;
	GtkButton* _tmp23_;
	parent_class = G_OBJECT_CLASS (permissions_widgets_app_settings_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PERMISSIONS_WIDGETS_TYPE_APP_SETTINGS_VIEW, PermissionsWidgetsAppSettingsView);
	g_signal_connect_object ((GObject*) self, "notify::selected-app", (GCallback) _permissions_widgets_app_settings_view_update_view_g_object_notify, self, 0);
	_tmp0_ = (GtkListBox*) gtk_list_box_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp0_, TRUE);
	gtk_list_box_set_selection_mode (_tmp0_, GTK_SELECTION_NONE);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->permission_box);
	self->priv->permission_box = _tmp0_;
	_tmp1_ = self->priv->permission_box;
	gtk_widget_add_css_class ((GtkWidget*) _tmp1_, "boxed-list");
	_tmp2_ = self->priv->permission_box;
	gtk_widget_add_css_class ((GtkWidget*) _tmp2_, GRANITE_STYLE_CLASS_RICH_LIST);
	_tmp3_ = (GtkListBox*) gtk_list_box_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp3_, TRUE);
	gtk_list_box_set_selection_mode (_tmp3_, GTK_SELECTION_NONE);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->sandbox_box);
	self->priv->sandbox_box = _tmp3_;
	_tmp4_ = self->priv->sandbox_box;
	gtk_widget_add_css_class ((GtkWidget*) _tmp4_, "boxed-list");
	_tmp5_ = self->priv->sandbox_box;
	gtk_widget_add_css_class ((GtkWidget*) _tmp5_, GRANITE_STYLE_CLASS_RICH_LIST);
	_tmp6_ = self->priv->sandbox_box;
	_tmp7_ = _g_object_ref0 ((GtkWidget*) _tmp6_);
	_tmp8_ = g_strdup (_ ("Access to system features can be restricted to make apps more secure, " \
"but some apps may not function properly without it"));
	_tmp9_ = granite_header_label_new (_ ("Advanced System Access"));
	gtk_widget_set_halign ((GtkWidget*) _tmp9_, GTK_ALIGN_FILL);
	granite_header_label_set_mnemonic_widget (_tmp9_, _tmp7_);
	_g_object_unref0 (_tmp7_);
	granite_header_label_set_secondary_text (_tmp9_, _tmp8_);
	_g_free0 (_tmp8_);
	g_object_ref_sink (_tmp9_);
	sandbox_header = _tmp9_;
	_tmp10_ = (GtkButton*) gtk_button_new_with_label (_ ("Reset to Defaults"));
	gtk_widget_set_halign ((GtkWidget*) _tmp10_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->reset_button);
	self->priv->reset_button = _tmp10_;
	_tmp11_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 12);
	g_object_ref_sink (_tmp11_);
	box = _tmp11_;
	_tmp12_ = box;
	_tmp13_ = self->priv->permission_box;
	gtk_box_append (_tmp12_, (GtkWidget*) _tmp13_);
	_tmp14_ = box;
	_tmp15_ = sandbox_header;
	gtk_box_append (_tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = box;
	_tmp17_ = self->priv->sandbox_box;
	gtk_box_append (_tmp16_, (GtkWidget*) _tmp17_);
	_tmp18_ = box;
	_tmp19_ = self->priv->reset_button;
	gtk_box_append (_tmp18_, (GtkWidget*) _tmp19_);
	_tmp20_ = box;
	switchboard_settings_page_set_child ((SwitchboardSettingsPage*) self, (GtkWidget*) _tmp20_);
	switchboard_settings_page_set_show_end_title_buttons ((SwitchboardSettingsPage*) self, TRUE);
	permissions_widgets_app_settings_view_update_view (self);
	_tmp21_ = self->priv->permission_box;
	g_signal_connect_object (_tmp21_, "row-activated", (GCallback) __permissions_widgets_app_settings_view___lambda18__gtk_list_box_row_activated, self, 0);
	_tmp22_ = self->priv->sandbox_box;
	g_signal_connect_object (_tmp22_, "row-activated", (GCallback) __permissions_widgets_app_settings_view___lambda19__gtk_list_box_row_activated, self, 0);
	_tmp23_ = self->priv->reset_button;
	g_signal_connect_object (_tmp23_, "clicked", (GCallback) __permissions_widgets_app_settings_view___lambda20__gtk_button_clicked, self, 0);
	_g_object_unref0 (box);
	_g_object_unref0 (sandbox_header);
	return obj;
}

static void
permissions_widgets_app_settings_view_class_init (PermissionsWidgetsAppSettingsViewClass * klass,
                                                  gpointer klass_data)
{
	permissions_widgets_app_settings_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PermissionsWidgetsAppSettingsView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_permissions_widgets_app_settings_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_permissions_widgets_app_settings_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = permissions_widgets_app_settings_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = permissions_widgets_app_settings_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PERMISSIONS_WIDGETS_APP_SETTINGS_VIEW_SELECTED_APP_PROPERTY, permissions_widgets_app_settings_view_properties[PERMISSIONS_WIDGETS_APP_SETTINGS_VIEW_SELECTED_APP_PROPERTY] = g_param_spec_object ("selected-app", "selected-app", "selected-app", PERMISSIONS_BACKEND_TYPE_APP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
permissions_widgets_app_settings_view_instance_init (PermissionsWidgetsAppSettingsView * self,
                                                     gpointer klass)
{
	gchar* _tmp0_;
	self->priv = permissions_widgets_app_settings_view_get_instance_private (self);
	self->priv->_selected_app = NULL;
	_tmp0_ = g_strdup ("0");
	self->priv->location_timestamp = _tmp0_;
}

static void
permissions_widgets_app_settings_view_finalize (GObject * obj)
{
	PermissionsWidgetsAppSettingsView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PERMISSIONS_WIDGETS_TYPE_APP_SETTINGS_VIEW, PermissionsWidgetsAppSettingsView);
	_g_object_unref0 (self->priv->_selected_app);
	_g_free0 (self->priv->location_timestamp);
	_g_object_unref0 (self->priv->sandbox_box);
	_g_object_unref0 (self->priv->permission_box);
	_g_object_unref0 (self->priv->reset_button);
	_g_object_unref0 (self->priv->background_row);
	_g_object_unref0 (self->priv->notifications_row);
	_g_object_unref0 (self->priv->location_row);
	_g_object_unref0 (self->priv->screenshot_row);
	_g_object_unref0 (self->priv->wallpaper_row);
	G_OBJECT_CLASS (permissions_widgets_app_settings_view_parent_class)->finalize (obj);
}

static GType
permissions_widgets_app_settings_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PermissionsWidgetsAppSettingsViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) permissions_widgets_app_settings_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PermissionsWidgetsAppSettingsView), 0, (GInstanceInitFunc) permissions_widgets_app_settings_view_instance_init, NULL };
	GType permissions_widgets_app_settings_view_type_id;
	permissions_widgets_app_settings_view_type_id = g_type_register_static (SWITCHBOARD_TYPE_SETTINGS_PAGE, "PermissionsWidgetsAppSettingsView", &g_define_type_info, 0);
	PermissionsWidgetsAppSettingsView_private_offset = g_type_add_instance_private (permissions_widgets_app_settings_view_type_id, sizeof (PermissionsWidgetsAppSettingsViewPrivate));
	return permissions_widgets_app_settings_view_type_id;
}

GType
permissions_widgets_app_settings_view_get_type (void)
{
	static volatile gsize permissions_widgets_app_settings_view_type_id__once = 0;
	if (g_once_init_enter (&permissions_widgets_app_settings_view_type_id__once)) {
		GType permissions_widgets_app_settings_view_type_id;
		permissions_widgets_app_settings_view_type_id = permissions_widgets_app_settings_view_get_type_once ();
		g_once_init_leave (&permissions_widgets_app_settings_view_type_id__once, permissions_widgets_app_settings_view_type_id);
	}
	return permissions_widgets_app_settings_view_type_id__once;
}

static void
_vala_permissions_widgets_app_settings_view_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec)
{
	PermissionsWidgetsAppSettingsView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PERMISSIONS_WIDGETS_TYPE_APP_SETTINGS_VIEW, PermissionsWidgetsAppSettingsView);
	switch (property_id) {
		case PERMISSIONS_WIDGETS_APP_SETTINGS_VIEW_SELECTED_APP_PROPERTY:
		g_value_set_object (value, permissions_widgets_app_settings_view_get_selected_app (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_permissions_widgets_app_settings_view_set_property (GObject * object,
                                                          guint property_id,
                                                          const GValue * value,
                                                          GParamSpec * pspec)
{
	PermissionsWidgetsAppSettingsView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PERMISSIONS_WIDGETS_TYPE_APP_SETTINGS_VIEW, PermissionsWidgetsAppSettingsView);
	switch (property_id) {
		case PERMISSIONS_WIDGETS_APP_SETTINGS_VIEW_SELECTED_APP_PROPERTY:
		permissions_widgets_app_settings_view_set_selected_app (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

