/*558:*/
#line 11804 "../../../texk/web2c/hitexdir/hiformat.w"

#include "hibasetypes.h"
#include <math.h> 
#include <string.h> 
#include <ctype.h> 
#include <zlib.h> 
#include <sys/types.h> 
#include <sys/stat.h> 
#ifdef WIN32
#include <direct.h> 
#endif
#line 11815 "../../../texk/web2c/hitexdir/hiformat.w"
#include <fcntl.h> 
#include "hierror.h"
#include "hiformat.h"
#include "higet.h"

/*19:*/
#line 799 "../../../texk/web2c/hitexdir/hiformat.w"

#define HGET_N(I,X) \
  if ((I)==1) (X)= HGET8;\
  else if ((I)==2) HGET16(X);\
  else if ((I)==3) HGET24(X);\
  else if ((I)==4) HGET32(X);

#define HGET_GLYPH(I,G) \
  HGET_N(I,(G).c); (G).f= HGET8; REF_RNG(font_kind,(G).f);\
  hwrite_glyph(&(G));\
/*:19*//*92:*/
#line 1812 "../../../texk/web2c/hitexdir/hiformat.w"

#define HGET_XDIMEN(I,X) \
  if((I)&b100) HGET32((X).w); else (X).w= 0;\
  if((I)&b010) (X).h= hget_float32();  else (X).h= 0.0;\
  if((I)&b001) (X).v= hget_float32(); else (X).v= 0.0;
/*:92*//*98:*/
#line 1946 "../../../texk/web2c/hitexdir/hiformat.w"

#define HGET_STRETCH(S) { Stch st;  HGET32(st.u); S.o= st.u&3;  st.u&= ~3; S.f= st.f; }
/*:98*//*107:*/
#line 2041 "../../../texk/web2c/hitexdir/hiformat.w"

#define HGET_PENALTY(I,P) \
if (I==1) {int8_t n= HGET8;  P= n; } \
else if (I==2) {int16_t n; HGET16(n);RNG("Penalty",n,-20000,+20000);  P= n; }\
else if (I==3) {int32_t n; HGET32(n);RNG("Penalty",n,-20000,+20000);  P= n; }\
hwrite_signed(P);
/*:107*//*120:*/
#line 2240 "../../../texk/web2c/hitexdir/hiformat.w"

#define HGET_RULE(I,R)\
if ((I)&b100) HGET32((R).h); else (R).h= RUNNING_DIMEN;\
if ((I)&b010) HGET32((R).d); else (R).d= RUNNING_DIMEN;\
if ((I)&b001) HGET32((R).w); else (R).w= RUNNING_DIMEN;
/*:120*//*129:*/
#line 2348 "../../../texk/web2c/hitexdir/hiformat.w"

#define HGET_KERN(I,K) \
K.x= (I)&b100;\
if (((I)&b011)==2) {HGET32(K.d.w); K.d.h= K.d.v= 0.0;}\
else if (((I)&b011)==3) hget_xdimen_node(&(K.d));\
hwrite_kern(&k);
/*:129*//*138:*/
#line 2577 "../../../texk/web2c/hitexdir/hiformat.w"

#define HGET_GLUE(I,G) {\
  if((I)!=b111) { if ((I)&b100) HGET32((G).w.w); else (G).w.w= 0;}\
  if((I)&b010) HGET_STRETCH((G).p) else (G).p.f= 0.0, (G).p.o= 0;\
  if((I)&b001) HGET_STRETCH((G).m) else  (G).m.f= 0.0, (G).m.o= 0;\
  if((I)==b111) hget_xdimen_node(&((G).w)); else (G).w.h= (G).w.v= 0.0;}
/*:138*//*157:*/
#line 3299 "../../../texk/web2c/hitexdir/hiformat.w"

#define HGET_GREF(K,S) {uint8_t n= HGET8; REF(K,n);  return hwritef("\\" S "%d\\",n);}

/*:157*//*166:*/
#line 3555 "../../../texk/web2c/hitexdir/hiformat.w"

#define HGET_BOX(I,B) \
HGET32(B.h);\
if ((I)&b001) HGET32(B.d);  else B.d= 0;\
HGET32(B.w);\
if ((I)&b010) HGET32(B.a); else B.a= 0;\
if ((I)&b100) { B.r= hget_float32(); B.s= HGET8;  B.o= B.s&0xF; B.s= B.s>>4; }\
else {  B.r= 0.0; B.o= B.s= 0; }\
hget_list(&(B.l));
/*:166*//*173:*/
#line 3784 "../../../texk/web2c/hitexdir/hiformat.w"

#define HGET_SET(K,I) \
 { Dimen h,d; HGET32(h);\
   if ((I)&b001) HGET32(d);  else d= 0;\
   if (K==vset_kind && (d> MAX_DIMEN || d<-MAX_DIMEN)) { hwritef(" top"); d^= 0x40000000;}\
   hwrite_dimension(h); hwrite_dimension(d); }\
 { Dimen w; HGET32(w); hwrite_dimension(w);} \
 if ((I)&b010)  { Dimen a; HGET32(a); hwritef(" shifted"); hwrite_dimension(a);}\
 { Stretch p; HGET_STRETCH(p);hwrite_plus(&p);}\
 { Stretch m; HGET_STRETCH(m);hwrite_minus(&m);}\
 if ((I)&b100) {Xdimen x; hget_xdimen_node(&x); hwrite_xdimen_node(&x);} else HGET_REF(xdimen_kind);\
 { List l; hget_list(&l); hwrite_list(&l); }


#define HGET_PACK(K,I) \
 if (K==vpack_kind) {Dimen d; HGET32(d); \
   if (d> MAX_DIMEN || d<-MAX_DIMEN) { hwritef(" top"); d^= 0x40000000;}\
   if (d!=MAX_DIMEN) {hwritef(" max depth");hwrite_dimension(d);}} \
 if ((I)&b010){Dimen s; HGET32(s); hwritef(" shifted");  hwrite_dimension(s); }\
 if ((I)&b001) hwritef(" add"); else hwritef(" to");\
 if ((I)&b100) {Xdimen x; hget_xdimen_node(&x);hwrite_xdimen_node(&x);}\
 else HGET_REF(xdimen_kind);\
 { List l; hget_list(&l); hwrite_list(&l); }
/*:173*//*179:*/
#line 3878 "../../../texk/web2c/hitexdir/hiformat.w"

#define HGET_LEADERS(I) \
if ((I)&b100) hget_glue_node();\
hwrite_leaders_type((I)&b011);\
if (KIND(*hpos)==rule_kind) hget_rule_node(); \
else if (KIND(*hpos)==hbox_kind) hget_hbox_node(); \
else  hget_vbox_node();
/*:179*//*185:*/
#line 3983 "../../../texk/web2c/hitexdir/hiformat.w"

#define HGET_BASELINE(I,B) \
  if((I)&b001) HGET32((B).lsl); else B.lsl= 0; hwrite_dimension(B.lsl);\
  if((I)&b100) hget_glue_node(); \
  else {B.bs.p.o= B.bs.m.o= B.bs.w.w= 0; B.bs.w.h= B.bs.w.v= B.bs.p.f= B.bs.m.f= 0.0; hwrite_glue_node(&(B.bs));}\
  if((I)&b010) hget_glue_node(); \
  else {B.ls.p.o= B.ls.m.o= B.ls.w.w= 0; B.ls.w.h= B.ls.w.v= B.ls.p.f= B.ls.m.f= 0.0; hwrite_glue_node(&(B.ls));}
/*:185*//*193:*/
#line 4087 "../../../texk/web2c/hitexdir/hiformat.w"

#define HGET_LIG(I,L) \
(L).f= HGET8;REF(font_kind,(L).f);\
if ((I)==7) hget_list(&((L).l)); \
else { (L).l.s= (I); (L).l.p= hpos-hstart;  hpos+= (L).l.s;} \
hwrite_ligature(&(L));
/*:193*//*201:*/
#line 4208 "../../../texk/web2c/hitexdir/hiformat.w"

#define HGET_DISC(I,Y)\
if ((I)&b100) {uint8_t r= HGET8; (Y).r= r&0x7F;  RNG("Replace count",(Y).r,0,31); (Y).x= (r&0x80)!=0; }\
else { (Y).r= 0;  (Y).x= false;}\
if ((I)&b010) hget_list(&((Y).p)); else { (Y).p.p= hpos-hstart; (Y).p.s= 0; (Y).p.t= TAG(list_kind,b000); }\
if ((I)&b001) hget_list(&((Y).q)); else { (Y).q.p= hpos-hstart; (Y).q.s= 0; (Y).q.t= TAG(list_kind,b000); }
/*:201*//*208:*/
#line 4349 "../../../texk/web2c/hitexdir/hiformat.w"

#define HGET_PAR(I) \
{ uint8_t n;\
 if ((I)==b100) {n= HGET8; REF(param_kind,n);}\
 if ((I)&b100)  {Xdimen x; hget_xdimen_node(&x); hwrite_xdimen(&x);}  else HGET_REF(xdimen_kind);\
 if ((I)&b010) { List l; hget_param_list(&l); hwrite_param_list(&l); } \
 else if ((I)!=b100) HGET_REF(param_kind) else hwrite_ref(n);\
 { List l; hget_list(&l); hwrite_list(&l); }}
/*:208*//*213:*/
#line 4424 "../../../texk/web2c/hitexdir/hiformat.w"

#define HGET_MATH(I) \
if ((I)&b100) { List l; hget_param_list(&l); hwrite_param_list(&l); } \
else HGET_REF(param_kind);\
if ((I)&b010) hget_hbox_node(); \
{ List l; hget_list(&l); hwrite_list(&l); } \
if ((I)&b001) hget_hbox_node();
/*:213*//*226:*/
#line 4624 "../../../texk/web2c/hitexdir/hiformat.w"

#define HGET_TABLE(I) \
if(I&b010) hwritef(" v"); else hwritef(" h"); \
if ((I)&b001) hwritef(" add"); else hwritef(" to");\
if ((I)&b100) {Xdimen x; hget_xdimen_node(&x); hwrite_xdimen_node(&x);} else HGET_REF(xdimen_kind)\
{ List l; hget_list(&l); hwrite_list(&l); }  \
{ List l; hget_list(&l); hwrite_list(&l); }  
/*:226*//*234:*/
#line 4794 "../../../texk/web2c/hitexdir/hiformat.w"

#define HGET_IMAGE(I) \
{ Image x= {0};\
HGET16(x.n);\
if ((I)&b100) { x.a= hget_float32();\
 if ((I)==b111) {hget_xdimen_node(&x.w);hget_xdimen_node(&x.h);}\
 else if ((I)==b110) {x.hr= HGET8;hget_xdimen_node(&x.w);}\
 else if ((I)==b101) {x.wr= HGET8;hget_xdimen_node(&x.h);}\
 else  {x.wr= HGET8;x.hr= HGET8;}}\
else if((I)==b011) {HGET32(x.w.w);HGET32(x.h.w);} \
else if((I)==b010) { x.a= hget_float32(); HGET32(x.w.w);}\
else if((I)==b001){ x.a= hget_float32(); HGET32(x.h.w);}\
hwrite_image(&x);\
{List d;  hget_list(&d);hwrite_list(&d);}}
/*:234*//*265:*/
#line 5736 "../../../texk/web2c/hitexdir/hiformat.w"

#define HGET_LINK(I) \
{ int n,c; if (I&b001) HGET16(n); else n= HGET8;\
  if (I&b100) c= HGET8; else c= (I&b010)?1:0xFF;\
  hwrite_link(n,c,I&b010); }
/*:265*//*318:*/
#line 7016 "../../../texk/web2c/hitexdir/hiformat.w"

#define HGET_STREAM(I) \
 {uint8_t n= HGET8; REF_RNG(stream_kind,n); hwrite_ref(n);}\
if ((I)&b010) { List l; hget_param_list(&l); hwrite_param_list(&l); } \
else HGET_REF(param_kind);\
{ List l; hget_list(&l); hwrite_list(&l); }
/*:318*//*417:*/
#line 9298 "../../../texk/web2c/hitexdir/hiformat.w"

#define HGET_REF(K) {uint8_t n= HGET8; REF(K,n); hwrite_ref(n);}
/*:417*/
#line 11820 "../../../texk/web2c/hitexdir/hiformat.w"

/*22:*/
#line 898 "../../../texk/web2c/hitexdir/hiformat.w"

#define hwritec(c) (hout?putc(c,hout):0)
#define hwritef(...) (hout?fprintf(hout,__VA_ARGS__):0)
/*:22*/
#line 11821 "../../../texk/web2c/hitexdir/hiformat.w"

/*252:*/
#line 5434 "../../../texk/web2c/hitexdir/hiformat.w"

Label*labels= NULL;
int first_label= -1;
/*:252*//*289:*/
#line 6192 "../../../texk/web2c/hitexdir/hiformat.w"

ColorSet colors_0,colors_n;
int colors_i;
/*:289*//*324:*/
#line 7193 "../../../texk/web2c/hitexdir/hiformat.w"

RangePos*range_pos;
int next_range= 1,max_range;
int*page_on;
/*:324*//*335:*/
#line 7377 "../../../texk/web2c/hitexdir/hiformat.w"

char hbanner[MAX_BANNER+1];
int hbanner_size= 0;
/*:335*//*342:*/
#line 7530 "../../../texk/web2c/hitexdir/hiformat.w"

uint8_t*hpos= NULL,*hstart= NULL,*hend= NULL,*hpos0= NULL;
/*:342*//*348:*/
#line 7611 "../../../texk/web2c/hitexdir/hiformat.w"

char*hin_name= NULL;
uint64_t hin_size= 0;
uint8_t*hin_addr= NULL;
uint64_t hin_time= 0;
/*:348*//*406:*/
#line 9118 "../../../texk/web2c/hitexdir/hiformat.w"

char**hfont_name;
/*:406*//*450:*/
#line 9884 "../../../texk/web2c/hitexdir/hiformat.w"

unsigned int debugflags= DBGNONE;
int option_utf8= false;
int option_hex= false;
int option_force= false;
int option_global= false;
int option_aux= false;
int option_compress= false;
char*stem_name= NULL;
int stem_length= 0;
/*:450*//*453:*/
#line 10018 "../../../texk/web2c/hitexdir/hiformat.w"

FILE*hin= NULL,*hout= NULL,*hlog= NULL;
/*:453*/
#line 11822 "../../../texk/web2c/hitexdir/hiformat.w"

/*273:*/
#line 5820 "../../../texk/web2c/hitexdir/hiformat.w"

Outline*outlines;
/*:273*/
#line 11823 "../../../texk/web2c/hitexdir/hiformat.w"

/*349:*/
#line 7618 "../../../texk/web2c/hitexdir/hiformat.w"

#ifndef USE_MMAP
void hget_unmap(void)
{if(hin_addr!=NULL)free(hin_addr);
hin_addr= NULL;
hin_size= 0;
}
bool hget_map(void)
{FILE*f;
struct stat st;
size_t s,t;
uint64_t u;
f= fopen(hin_name,"rb");
if(f==NULL)
{MESSAGE("Unable to open file: %s\n",hin_name);return false;}
if(stat(hin_name,&st)<0)
{MESSAGE("Unable to obtain file size: %s\n",hin_name);
fclose(f);
return false;
}
if(st.st_size==0)
{MESSAGE("File %s is empty\n",hin_name);
fclose(f);
return false;
}
u= st.st_size;
if(hin_addr!=NULL)hget_unmap();
hin_addr= malloc(u);
if(hin_addr==NULL)
{MESSAGE("Unable to allocate 0x%"PRIx64" byte for File %s\n",u,hin_name);
fclose(f);
return 0;
}
t= 0;
do{
s= fread(hin_addr+t,1,u,f);
if(s<=0)
{MESSAGE("Unable to read file %s\n",hin_name);
fclose(f);
free(hin_addr);
hin_addr= NULL;
return false;
}
t= t+s;
u= u-s;
}while(u> 0);
hin_size= st.st_size;
hin_time= st.st_mtime;
return true;
}

#else
#line 7670 "../../../texk/web2c/hitexdir/hiformat.w"

#include <sys/mman.h> 

void hget_unmap(void)
{munmap(hin_addr,hin_size);
hin_addr= NULL;
hin_size= 0;
}

bool hget_map(void)
{struct stat st;
int fd;
fd= open(hin_name,O_RDONLY,0);
if(fd<0)
{MESSAGE("Unable to open file %s\n",hin_name);return false;}
if(fstat(fd,&st)<0)
{MESSAGE("Unable to get file size\n");
close(fd);
return false;
}
if(st.st_size==0)
{MESSAGE("File %s is empty\n",hin_name);
close(fd);
return false;
}
if(hin_addr!=NULL)hget_unmap();
hin_size= st.st_size;
hin_time= st.st_mtime;
hin_addr= mmap(NULL,hin_size,PROT_READ,MAP_PRIVATE,fd,0);
if(hin_addr==MAP_FAILED)
{close(fd);
hin_addr= NULL;hin_size= 0;
MESSAGE("Unable to map file into memory\n");
return 0;
}
close(fd);
return hin_size;
}
#endif
#line 7709 "../../../texk/web2c/hitexdir/hiformat.w"

/*:349*/
#line 11824 "../../../texk/web2c/hitexdir/hiformat.w"

/*336:*/
#line 7382 "../../../texk/web2c/hitexdir/hiformat.w"


bool hcheck_banner(char*magic)
{
int v,s;
char*t;
t= hbanner;
if(strncmp(magic,hbanner,4)!=0)
{MESSAGE("This is not a %s file\n",magic);return false;}
else t+= 4;
if(hbanner[hbanner_size-1]!='\n')
{MESSAGE("Banner exceeds maximum size=0x%x\n",MAX_BANNER);return false;}
if(*t!=' ')
{MESSAGE("Space expected in banner after %s\n",magic);return false;}
else t++;
v= strtol(t,&t,10);
if(*t!='.')
{MESSAGE("Dot expected in banner after HINT version number\n");return false;}
else t++;
s= strtol(t,&t,10);
if(v!=HINT_VERSION)
{MESSAGE("Wrong HINT version: got %d.%d, expected %d.%d\n",
v,s,HINT_VERSION,HINT_MINOR_VERSION);return false;}
#if 0 
if(s<HINT_MINOR_VERSION)
{MESSAGE("Outdated HINT minor version: got %d.%d, expected %d.%d\n",
v,s,HINT_VERSION,HINT_MINOR_VERSION);}
else
#endif
#line 7411 "../../../texk/web2c/hitexdir/hiformat.w"
 if(s> HINT_MINOR_VERSION)
{MESSAGE("More recent HINT minor version: got %d.%d, expected %d.%d, update your application\n",
v,s,HINT_VERSION,HINT_MINOR_VERSION);}
if(*t!=' '&&*t!='\n')
{MESSAGE("Space expected in banner after HINT minor version\n");return false;}
LOG("%s file version "HINT_VERSION_STRING":%s",magic,t);
DBG(DBGDIR,"banner size=0x%x\n",hbanner_size);
return true;
}
/*:336*/
#line 11825 "../../../texk/web2c/hitexdir/hiformat.w"

/*339:*/
#line 7459 "../../../texk/web2c/hitexdir/hiformat.w"


static size_t hput_banner(char*magic,char*str)
{size_t s= fprintf(hout,"%s "HINT_VERSION_STRING" %s\n",magic,str);
if(s> MAX_BANNER)QUIT("Banner too big");
return s;
}
/*:339*/
#line 11826 "../../../texk/web2c/hitexdir/hiformat.w"

/*358:*/
#line 7951 "../../../texk/web2c/hitexdir/hiformat.w"

Entry*dir= NULL;
uint16_t section_no,max_section_no;
void new_directory(uint32_t entries)
{DBG(DBGDIR,"Creating directory with %d entries\n",entries);
RNG("Directory entries",entries,3,0x10000);
max_section_no= entries-1;
ALLOCATE(dir,entries,Entry);
dir[0].section_no= 0;dir[1].section_no= 1;dir[2].section_no= 2;
}
/*:358*//*359:*/
#line 7964 "../../../texk/web2c/hitexdir/hiformat.w"

void hset_entry(Entry*e,uint16_t i,uint32_t size,uint32_t xsize,char*file_name)
{e->section_no= i;
e->size= size;e->xsize= xsize;
if(file_name==NULL||*file_name==0)
e->file_name= NULL;
else
e->file_name= strdup(file_name);
DBG(DBGDIR,"Creating entry %d: \"%s\" size=0x%x xsize=0x%x\n",i,file_name,size,xsize);
}
/*:359*/
#line 11827 "../../../texk/web2c/hitexdir/hiformat.w"


/*392:*/
#line 8789 "../../../texk/web2c/hitexdir/hiformat.w"

uint32_t definition_bits[0x100/32][32]= {{0}};

#define SET_DBIT(N,K) ((N)> 0xFF?1:(definition_bits[N/32][K]|= (1<<((N)&(32-1)))))
#define GET_DBIT(N,K) ((N)> 0xFF?1:((definition_bits[N/32][K]>>((N)&(32-1)))&1))
#define DEF(D,K,N) (D).k= K; (D).n= (N);SET_DBIT((D).n,(D).k);\
 DBG(DBGDEF,"Defining %s %d\n",definition_name[(D).k],(D).n);\
 RNG("Definition",(D).n,max_fixed[(D).k]+1,max_ref[(D).k]);
#define REF(K,N) REF_RNG(K,N);if(!GET_DBIT(N,K)) \
 QUIT("Reference %d to %s before definition",(N),definition_name[K])
/*:392*//*396:*/
#line 8851 "../../../texk/web2c/hitexdir/hiformat.w"

#define DEF_REF(D,K,M,N)  DEF(D,K,M);\
if ((int)(M)> max_default[K]) QUIT("Defining non default reference %d for %s",M,definition_name[K]); \
if ((int)(N)> max_fixed[K]) QUIT("Defining reference %d for %s by non fixed reference %d",M,definition_name[K],N);
/*:396*/
#line 11829 "../../../texk/web2c/hitexdir/hiformat.w"

/*559:*/
#line 11873 "../../../texk/web2c/hitexdir/hiformat.w"

extern void hget_xdimen_node(Xdimen*x);
extern void hget_def_node(void);
extern void hget_font_def(Info i,uint8_t f);
extern void hget_content_section(void);
extern Tag hget_content_node(void);
extern void hget_glue_node(void);
extern void hget_rule_node(void);
extern void hget_hbox_node(void);
extern void hget_vbox_node(void);
extern void hget_param_list(List*l);
extern int hget_txt(void);
extern int hget_unknown(Tag a);
/*:559*/
#line 11830 "../../../texk/web2c/hitexdir/hiformat.w"

/*21:*/
#line 850 "../../../texk/web2c/hitexdir/hiformat.w"

int nesting= 0;
void hwrite_nesting(void)
{int i;
hwritec('\n');
for(i= 0;i<nesting;i++)hwritec(' ');
}

void hwrite_start(void)
{hwrite_nesting();hwritec('<');nesting++;
}

void hwrite_range(void);
void hwrite_label(void);

void hwrite_end(void)
{nesting--;hwritec('>');
if(section_no==2)
{if(nesting==0)hwrite_range();
hwrite_label();
}
}

void hwrite_comment(char*str)
{char c;
if(str==NULL)return;
hwritef(" (");
while((c= *str++)!=0)
if(c=='('||c==')')hwritec('_');
else if(c=='\n')hwritef("\n(");
else hwritec(c);
hwritec(')');
}

void hwrite_charcode(uint32_t c);
void hwrite_ref(int n);

void hwrite_glyph(Glyph*g)
{char*n= hfont_name[g->f];
hwrite_charcode(g->c);
hwrite_ref(g->f);
if(n!=NULL)hwrite_comment(n);
}
/*:21*//*31:*/
#line 963 "../../../texk/web2c/hitexdir/hiformat.w"

void hwrite_signed(int32_t i)
{if(i<0)hwritef(" -%d",-i);
else hwritef(" +%d",+i);
}
/*:31*//*36:*/
#line 1039 "../../../texk/web2c/hitexdir/hiformat.w"

void hwrite_string(char*str)
{hwritec(' ');
if(str==NULL)hwritef("''");
else
{hwritec('\'');
while(*str!=0)
{if(*str=='\'')hwritec('\'');
hwritec(*str);
str++;
}
hwritec('\'');
}
}


/*:36*//*52:*/
#line 1214 "../../../texk/web2c/hitexdir/hiformat.w"

int hwrite_utf8(uint32_t c)
{if(c<0x80)
{hwritec(c);return 1;}
else if(c<0x800)
{hwritec(0xC0|(c>>6));hwritec(0x80|(c&0x3F));return 2;}
else if(c<0x10000)
{hwritec(0xE0|(c>>12));hwritec(0x80|((c>>6)&0x3F));hwritec(0x80|(c&0x3F));return 3;}
else if(c<0x200000)
{hwritec(0xF0|(c>>18));hwritec(0x80|((c>>12)&0x3F));
hwritec(0x80|((c>>6)&0x3F));hwritec(0x80|(c&0x3F));return 4;}
else
RNG("character code",c,0,0x1FFFFF);
return 0;
}

void hwrite_charcode(uint32_t c)
{if(c<0x20)
{if(option_hex)hwritef(" 0x%02X",c);
else hwritef(" %u",c);
}
else if(c=='\'')hwritef(" ''''");
else if(c<=0x7E)hwritef(" \'%c\'",c);
else if(option_utf8){hwritef(" \'");hwrite_utf8(c);hwritec('\'');}
else if(option_hex)hwritef(" 0x%04X",c);
else hwritef(" %u",c);
}
/*:52*//*68:*/
#line 1507 "../../../texk/web2c/hitexdir/hiformat.w"

#define MAX_HEX_DIGITS 12
void hwrite_float64(float64_t d,bool suffix)
{uint64_t bits,mantissa;
int exp,digits;
if(!suffix)hwritec(' ');
else if(d>=0)hwritec('+');
if(floor(d)==d)
{hwritef("%d",(int)d);return;}
if(floor(10000.0*d)==10000.0*d)
{hwritef("%g",d);return;}
DBG(DBGFLOAT,"Writing hexadecimal float %f\n",d);
if(d<0){hwritec('-');d= -d;}
hwritef("0x");
/*69:*/
#line 1531 "../../../texk/web2c/hitexdir/hiformat.w"

{union{float64_t d;uint64_t bits;}u;
u.d= d;bits= u.bits;
}
mantissa= bits&(((uint64_t)1<<DBL_M_BITS)-1);
mantissa= mantissa+((uint64_t)1<<DBL_M_BITS);
exp= ((bits>>DBL_M_BITS)&((1<<DBL_E_BITS)-1))-DBL_EXCESS;
digits= DBL_M_BITS+1;
DBG(DBGFLOAT,"\tdigits=%d mantissa=0x%"PRIx64" binary exp=%d\n",digits,mantissa,exp);
/*:69*//*70:*/
#line 1545 "../../../texk/web2c/hitexdir/hiformat.w"

{int r;
if(exp>=0)
{r= exp%4;
if(r> 0)
{mantissa= mantissa<<r;exp= exp-r;digits= digits+r;}
}
else
{r= (-exp)%4;
if(r> 0)
{mantissa= mantissa>>r;exp= exp+r;digits= digits-r;}
}
}
exp= exp/4;
DBG(DBGFLOAT,"\tdigits=%d mantissa=0x%"PRIx64" hex exp=%d\n",digits,mantissa,exp);
/*:70*//*71:*/
#line 1566 "../../../texk/web2c/hitexdir/hiformat.w"

mantissa= mantissa<<(64-DBL_M_BITS-4);
/*:71*/
#line 1521 "../../../texk/web2c/hitexdir/hiformat.w"

if(exp> MAX_HEX_DIGITS)
/*72:*/
#line 1574 "../../../texk/web2c/hitexdir/hiformat.w"

{DBG(DBGFLOAT,"writing large number\n");
hwritef("%X.",(uint8_t)(mantissa>>60));
mantissa= mantissa<<4;
do{
hwritef("%X",(uint8_t)(mantissa>>DBL_M_BITS)&0xF);
mantissa= mantissa<<4;
}while(mantissa!=0);
hwritef("x+%X",exp);
}
/*:72*/
#line 1523 "../../../texk/web2c/hitexdir/hiformat.w"

else if(exp>=0)/*73:*/
#line 1588 "../../../texk/web2c/hitexdir/hiformat.w"

{DBG(DBGFLOAT,"writing medium number\n");
do{
hwritef("%X",(uint8_t)(mantissa>>60));
mantissa= mantissa<<4;
if(exp--==0)hwritec('.');
}while(mantissa!=0||exp>=-1);
}
/*:73*/
#line 1524 "../../../texk/web2c/hitexdir/hiformat.w"

else/*74:*/
#line 1599 "../../../texk/web2c/hitexdir/hiformat.w"

{DBG(DBGFLOAT,"writing small number\n");
hwritef("%X.",(uint8_t)(mantissa>>60));
mantissa= mantissa<<4;
do{
hwritef("%X",(uint8_t)(mantissa>>60));
mantissa= mantissa<<4;
}while(mantissa!=0);
hwritef("x-%X",-exp);
}
/*:74*/
#line 1525 "../../../texk/web2c/hitexdir/hiformat.w"

}
/*:68*//*79:*/
#line 1658 "../../../texk/web2c/hitexdir/hiformat.w"

void hwrite_scaled(Scaled x)
{hwrite_float64(x/(float64_t)ONE,false);
}
/*:79*//*84:*/
#line 1718 "../../../texk/web2c/hitexdir/hiformat.w"

void hwrite_dimension(Dimen x)
{hwrite_scaled(x);
hwritef("pt");
}
/*:84*//*91:*/
#line 1799 "../../../texk/web2c/hitexdir/hiformat.w"

void hwrite_xdimen(Xdimen*x)
{hwrite_dimension(x->w);
if(x->h!=0.0){hwrite_float64(x->h,true);hwritec('h');}
if(x->v!=0.0){hwrite_float64(x->v,true);hwritec('v');}
}

void hwrite_xdimen_node(Xdimen*x)
{hwrite_start();hwritef("xdimen");hwrite_xdimen(x);hwrite_end();}
/*:91*//*102:*/
#line 1981 "../../../texk/web2c/hitexdir/hiformat.w"

void hwrite_order(Order o)
{switch(o)
{case normal_o:hwritef("pt");break;
case fil_o:hwritef("fil");break;
case fill_o:hwritef("fill");break;
case filll_o:hwritef("filll");break;
default:QUIT("Illegal order %d",o);break;
}
}

void hwrite_stretch(Stretch*s)
{hwrite_float64(s->f,false);
hwrite_order(s->o);
}
/*:102*//*118:*/
#line 2218 "../../../texk/web2c/hitexdir/hiformat.w"

static void hwrite_rule_dimension(Dimen d,char c)
{if(d==RUNNING_DIMEN)hwritef(" %c",c);
else hwrite_dimension(d);
}

void hwrite_rule(Rule*r)
{hwrite_rule_dimension(r->h,'|');
hwrite_rule_dimension(r->d,'|');
hwrite_rule_dimension(r->w,'_');
}
/*:118*//*127:*/
#line 2327 "../../../texk/web2c/hitexdir/hiformat.w"

void hwrite_explicit(bool x)
{if(x)hwritef(" !");}

void hwrite_kern(Kern*k)
{hwrite_explicit(k->x);
if(k->d.h==0.0&&k->d.v==0.0&&k->d.w==0)hwrite_ref(zero_dimen_no);
else hwrite_xdimen(&(k->d));
}
/*:127*//*136:*/
#line 2544 "../../../texk/web2c/hitexdir/hiformat.w"

void hwrite_plus(Stretch*p)
{if(p->f!=0.0){hwritef(" plus");hwrite_stretch(p);}
}
void hwrite_minus(Stretch*m)
{if(m->f!=0.0){hwritef(" minus");hwrite_stretch(m);}
}

void hwrite_glue(Glue*g)
{hwrite_xdimen(&(g->w));
hwrite_plus(&g->p);hwrite_minus(&g->m);
}

void hwrite_ref_node(Kind k,uint8_t n);
void hwrite_glue_node(Glue*g)
{
if(ZERO_GLUE(*g))hwrite_ref_node(glue_kind,zero_skip_no);
else{hwrite_start();hwritef("glue");hwrite_glue(g);hwrite_end();}
}
/*:136*//*144:*/
#line 2825 "../../../texk/web2c/hitexdir/hiformat.w"

void hwrite_list(List*l)
{uint32_t h= hpos-hstart,e= hend-hstart;
hpos= l->p+hstart;hend= hpos+l->s;
if(KIND(l->t)==list_kind)
{if(INFO(l->t)&b100)/*155:*/
#line 3256 "../../../texk/web2c/hitexdir/hiformat.w"

{if(l->s==0)hwritef(" \"\"");
else
{int pos= nesting+20;
hwritef(" \"");
while(hpos<hend)
{int i= hget_txt();
if(i<0)
{if(pos++<70)hwritec(' ');
else hwrite_nesting(),pos= nesting;
}
else if(i==1&&pos>=100)
{hwritec('\\');hwrite_nesting();pos= nesting;}
else
pos+= i;
}
hwritec('"');
}
}
/*:155*/
#line 2830 "../../../texk/web2c/hitexdir/hiformat.w"
else/*145:*/
#line 2836 "../../../texk/web2c/hitexdir/hiformat.w"

{if(l->s==0)hwritef(" <>");
else
{DBG(DBGNODE,"Write list at 0x%x size=%u\n",l->p,l->s);
hwrite_start();
if(section_no==2)hwrite_label();
if(l->s> 0xFF)hwritef("%d",l->s);
while(hpos<hend)
hget_content_node();
hwrite_end();
}
}
/*:145*/
#line 2830 "../../../texk/web2c/hitexdir/hiformat.w"
}
else QUIT("List expected got %s",content_name[KIND(l->t)]);
hpos= hstart+h;hend= hstart+e;
}
/*:144*//*156:*/
#line 3281 "../../../texk/web2c/hitexdir/hiformat.w"

int hwrite_txt_cc(uint32_t c)
{if(c<0x20)
return hwritef("\\C%d\\",c);
else
switch(c)
{case'\\':return hwritef("\\\\");
case'"':return hwritef("\\\"");
case'<':return hwritef("\\<");
case'>':return hwritef("\\>");
case' ':return hwritef("\\ ");
case'-':return hwritef("\\-");
default:return option_utf8?hwrite_utf8(c):hwritef("\\C%d\\",c);
}
}
/*:156*//*164:*/
#line 3520 "../../../texk/web2c/hitexdir/hiformat.w"

void hwrite_box(Box*b)
{hwrite_dimension(b->h);
hwrite_dimension(b->d);
hwrite_dimension(b->w);
if(b->a!=0){hwritef(" shifted");hwrite_dimension(b->a);}
if(b->r!=0.0&&b->s!=0)
{if(b->s> 0)hwritef(" plus");else hwritef(" minus");
hwrite_float64(b->r,false);hwrite_order(b->o);
}
hwrite_list(&(b->l));
}
/*:164*//*177:*/
#line 3860 "../../../texk/web2c/hitexdir/hiformat.w"

void hwrite_leaders_type(int t)
{
if(t==2)hwritef(" center");
else if(t==3)hwritef(" expand");
}
/*:177*//*191:*/
#line 4062 "../../../texk/web2c/hitexdir/hiformat.w"

void hwrite_ligature(Lig*l)
{uint32_t pos= hpos-hstart;
hwrite_ref(l->f);
hpos= l->l.p+hstart;
hwrite_charcode(hget_utf8());
hwritef(" \"");
while(hpos<hstart+l->l.p+l->l.s)
hwrite_txt_cc(hget_utf8());
hwritec('"');
hpos= hstart+pos;
}
/*:191*//*199:*/
#line 4185 "../../../texk/web2c/hitexdir/hiformat.w"

void hwrite_disc(Disc*h)
{hwrite_explicit(h->x);
if(h->r!=0)hwritef(" %d",h->r);
if(h->p.s!=0||h->q.s!=0)hwrite_list(&(h->p));
if(h->q.s!=0)hwrite_list(&(h->q));
}
void hwrite_disc_node(Disc*h)
{hwrite_start();hwritef("disc");hwrite_disc(h);hwrite_end();}
/*:199*//*232:*/
#line 4769 "../../../texk/web2c/hitexdir/hiformat.w"

void hwrite_image(Image*x)
{RNG("Section number",x->n,3,max_section_no);hwritef(" %u",x->n);
if(x->a!=0.0)hwrite_float64(x->a,false);
if(x->wr!=0)hwritef(" width *%u",x->wr);
else if(x->w.w!=0||x->w.h!=0.0||x->w.v!=0.0)
{hwritef(" width");hwrite_xdimen(&x->w);}
if(x->hr!=0)hwritef(" height *%u",x->hr);
else if(x->h.w!=0||x->h.h!=0.0||x->h.v!=0.0)
{hwritef(" height");hwrite_xdimen(&x->h);}
}
/*:232*//*259:*/
#line 5547 "../../../texk/web2c/hitexdir/hiformat.w"

void hwrite_label(void)
{while(first_label>=0&&(uint32_t)(hpos-hstart)>=labels[first_label].pos)
{Label*t= labels+first_label;
DBG(DBGLABEL,"Inserting label *%d\n",first_label);
hwrite_start();
hwritef("label *%d",first_label);
if(t->where==LABEL_TOP)hwritef(" top");
else if(t->where==LABEL_BOT)hwritef(" bot");
nesting--;hwritec('>');
first_label= labels[first_label].next;
}
}
/*:259*//*260:*/
#line 5586 "../../../texk/web2c/hitexdir/hiformat.w"

void hsort_labels(void)
{int i;
if(max_ref[label_kind]<0)
{first_label= -1;return;}
first_label= max_ref[label_kind];
while(first_label>=0&&labels[first_label].where==LABEL_UNDEF)
first_label--;
if(first_label<0)return;
labels[first_label].next= -1;
DBG(DBGLABEL,"Sorting %d labels\n",first_label+1);
for(i= first_label-1;i>=0;i--)
if(labels[i].where!=LABEL_UNDEF)
{uint32_t pos= labels[i].pos;
if(labels[first_label].pos>=pos)
{labels[i].next= first_label;first_label= i;}
else
{int j;
for(j= first_label;
labels[j].next>=0&&labels[labels[j].next].pos<pos;
j= labels[j].next)continue;
labels[i].next= labels[j].next;labels[j].next= i;
}
}
}
/*:260*//*271:*/
#line 5788 "../../../texk/web2c/hitexdir/hiformat.w"

void hwrite_link(int n,int c,uint8_t on)
{REF_RNG(label_kind,n);
if(labels[n].where==LABEL_UNDEF)
MESSAGE("WARNING: Link to an undefined label %d\n",n);
hwrite_ref(n);
if(on)hwritef(" on");
else hwritef(" off");
if((on&&c!=1)||(!on&&c!=0xFF))
{REF_RNG(color_kind,c);hwrite_ref(c);}
}
/*:271*//*330:*/
#line 7228 "../../../texk/web2c/hitexdir/hiformat.w"

void hwrite_range(void)
{uint32_t p= hpos-hstart;
DBG(DBGRANGE,"Range check at pos 0x%x next at 0x%x\n",p,range_pos[next_range].pos);
while(next_range<max_range&&range_pos[next_range].pos<=p)
{hwrite_start();
hwritef("range *%d ",range_pos[next_range].pg);
if(range_pos[next_range].on)hwritef("on");else hwritef("off");
nesting--;hwritec('>');
next_range++;
}
}
/*:330*//*332:*/
#line 7269 "../../../texk/web2c/hitexdir/hiformat.w"

void hsort_ranges(void)
{int i;
DBG(DBGRANGE,"Range sorting %d positions\n",next_range-1);
for(i= 3;i<next_range;i++)
{int j= i-1;
if(range_pos[i].pos<range_pos[j].pos)
{RangePos t;
t= range_pos[i];
do{
range_pos[j+1]= range_pos[j];
j--;
}while(range_pos[i].pos<range_pos[j].pos);
range_pos[j+1]= t;
}
}
max_range= next_range;next_range= 1;
}
/*:332*//*366:*/
#line 8089 "../../../texk/web2c/hitexdir/hiformat.w"

/*361:*/
#line 7989 "../../../texk/web2c/hitexdir/hiformat.w"

#ifdef WIN32
#include <io.h> 
#define access(N,M) _access(N, M )
#define F_OK 0
#else
#line 7995 "../../../texk/web2c/hitexdir/hiformat.w"
#include <unistd.h> 
#endif
#line 7997 "../../../texk/web2c/hitexdir/hiformat.w"
/*:361*/
#line 8090 "../../../texk/web2c/hitexdir/hiformat.w"

extern char*stem_name;
extern int stem_length;

void hget_section(uint16_t n);
void hwrite_aux_files(void)
{int i;
if(!option_aux)return;
DBG(DBGBASIC|DBGDIR,"Writing %d aux files\n",max_section_no-2);
for(i= 3;i<=max_section_no;i++)
{FILE*f;
char*aux_name= NULL;
if(option_global)
aux_name= strdup(dir[i].file_name);
else
/*362:*/
#line 8014 "../../../texk/web2c/hitexdir/hiformat.w"

{char*path= dir[i].file_name;
int path_length= (int)strlen(path);
/*363:*/
#line 8023 "../../../texk/web2c/hitexdir/hiformat.w"

int aux_length;
enum{absolute= 0,relative= 1}name_type;
char*aux_ext[2]= {".abs/",".rel/"};
int ext_length= 5;
aux_length= stem_length+ext_length+path_length;
ALLOCATE(aux_name,aux_length+1,char);
strcpy(aux_name,stem_name);
if(path[0]=='/')
{name_type= absolute;
strcpy(aux_name+stem_length,aux_ext[name_type]);
strcpy(aux_name+stem_length+ext_length,path+1);
}
else if(path_length> 3&&isalpha(path[0])&&
path[1]==':'&&path[2]=='/')
{name_type= absolute;
strcpy(aux_name+stem_length,aux_ext[name_type]);
strcpy(aux_name+stem_length+ext_length,path);
aux_name[stem_length+ext_length+1]= '_';
}
else
name_type= relative;
/*:363*/
#line 8017 "../../../texk/web2c/hitexdir/hiformat.w"

/*364:*/
#line 8052 "../../../texk/web2c/hitexdir/hiformat.w"

{int k;
for(k= stem_length+ext_length;k<aux_length-3;k++)
if(aux_name[k]=='.'&&aux_name[k+1]=='.'&&aux_name[k+2]=='/')
{aux_name[k]= aux_name[k+1]= '_';k= k+2;}
}
/*:364*/
#line 8018 "../../../texk/web2c/hitexdir/hiformat.w"

DBG(DBGDIR,"Replacing auxiliary file name:\n\t%s\n->\t%s\n",path,aux_name);
}
/*:362*/
#line 8105 "../../../texk/web2c/hitexdir/hiformat.w"

/*360:*/
#line 7980 "../../../texk/web2c/hitexdir/hiformat.w"

if(!option_force&&access(aux_name,F_OK)==0)
{MESSAGE("File '%s' exists.\n""To rewrite the file use the -f option.\n",
aux_name);
continue;
}
/*:360*/
#line 8106 "../../../texk/web2c/hitexdir/hiformat.w"

/*365:*/
#line 8061 "../../../texk/web2c/hitexdir/hiformat.w"

{char*path_end;
path_end= aux_name+1;
while(*path_end!=0)
{if(*path_end=='/')
{struct stat s;
*path_end= 0;
if(stat(aux_name,&s)==-1)
{
#ifdef WIN32
if(mkdir(aux_name)!=0)
#else
#line 8073 "../../../texk/web2c/hitexdir/hiformat.w"
 if(mkdir(aux_name,0777)!=0)
#endif
#line 8075 "../../../texk/web2c/hitexdir/hiformat.w"
 QUIT("Unable to create directory %s",aux_name);
DBG(DBGDIR,"Creating directory %s\n",aux_name);
}else if(!(S_IFDIR&(s.st_mode)))
QUIT("Unable to create directory %s, file exists",aux_name);
*path_end= '/';
}
path_end++;
}
}


/*:365*/
#line 8107 "../../../texk/web2c/hitexdir/hiformat.w"


f= fopen(aux_name,"wb");
if(f==NULL)
QUIT("Unable to open file '%s' for writing",aux_name);
else
{size_t s;
hget_section(i);
DBG(DBGDIR,"Writing file %s\n",aux_name);
s= fwrite(hstart,1,dir[i].size,f);
if(s!=dir[i].size)QUIT("writing file %s",aux_name);
fclose(f);
}
free(aux_name);
}
}
/*:366*//*367:*/
#line 8127 "../../../texk/web2c/hitexdir/hiformat.w"

static void hwrite_entry(int i)
{hwrite_start();
hwritef("section %u",dir[i].section_no);hwrite_string(dir[i].file_name);
hwrite_end();
}

void hwrite_directory(void)
{int i;
if(dir==NULL)QUIT("Directory not allocated");
section_no= 0;
hwritef("<directory %u",max_section_no);
for(i= 3;i<=max_section_no;i++)
hwrite_entry(i);
hwritef("\n>\n");
}
/*:367*//*380:*/
#line 8493 "../../../texk/web2c/hitexdir/hiformat.w"

void hwrite_definitions_start(void)
{section_no= 1;hwritef("<definitions");
}

void hwrite_definitions_end(void)
{hwritef("\n>\n");
}
/*:380*//*389:*/
#line 8639 "../../../texk/web2c/hitexdir/hiformat.w"

void hwrite_max_definitions(void)
{Kind k;
hwrite_start();
hwritef("max");
for(k= 0;k<32;k++)
if(max_ref[k]> max_default[k])
{switch(k)
{/*248:*/
#line 5380 "../../../texk/web2c/hitexdir/hiformat.w"


case label_kind:
if(max_ref[label_kind]> -1)
{hwrite_start();
hwritef("label %d",max_ref[label_kind]);
hwrite_end();
}
if(max_outline> -1)
{hwrite_start();
hwritef("outline %d",max_outline);
hwrite_end();
}
break;
/*:248*/
#line 8647 "../../../texk/web2c/hitexdir/hiformat.w"

default:
hwrite_start();
hwritef("%s %d",definition_name[k],max_ref[k]);
hwrite_end();
break;
}
}
hwrite_end();
}
/*:389*//*404:*/
#line 9004 "../../../texk/web2c/hitexdir/hiformat.w"

void hwrite_parameters(List*l)
{uint32_t h= hpos-hstart,e= hend-hstart;
hpos= l->p+hstart;hend= hpos+l->s;
if(l->s> 0xFF)hwritef(" %d",l->s);
while(hpos<hend)hget_def_node();
hpos= hstart+h;hend= hstart+e;
}
void hwrite_param_list(List*l)
{hwrite_start();
hwrite_parameters(l);
hwrite_end();
}

void hwrite_named_param_list(List*l)
{hwrite_start();
hwritef("param");
hwrite_parameters(l);
hwrite_end();
}
/*:404*//*418:*/
#line 9302 "../../../texk/web2c/hitexdir/hiformat.w"

void hwrite_ref(int n)
{hwritef(" *%d",n);}

void hwrite_ref_node(Kind k,uint8_t n)
{hwrite_start();hwritef("%s",content_name[k]);hwrite_ref(n);hwrite_end();}
/*:418*//*445:*/
#line 9767 "../../../texk/web2c/hitexdir/hiformat.w"

void hwrite_content_section(void)
{section_no= 2;
hwritef("<content");
hsort_ranges();
hsort_labels();
hget_content_section();
hwritef("\n>\n");
}
/*:445*/
#line 11831 "../../../texk/web2c/hitexdir/hiformat.w"

/*337:*/
#line 7429 "../../../texk/web2c/hitexdir/hiformat.w"

void hget_banner(void)
{hbanner_size= 0;
while(hbanner_size<MAX_BANNER&&hpos<hend)
{uint8_t c= HGET8;
hbanner[hbanner_size++]= c;
if(c=='\n')break;
}
hbanner[hbanner_size]= 0;
}
/*:337*//*350:*/
#line 7723 "../../../texk/web2c/hitexdir/hiformat.w"


static void hdecompress(uint16_t n)
{z_stream z;
uint8_t*buffer;
int i;

DBG(DBGCOMPRESS,"Decompressing section %d from 0x%x to 0x%x byte\n",n,dir[n].size,dir[n].xsize);
z.zalloc= (alloc_func)0;
z.zfree= (free_func)0;
z.opaque= (voidpf)0;
z.next_in= hstart;
z.avail_in= hend-hstart;
if(inflateInit(&z)!=Z_OK)
QUIT("Unable to initialize decompression: %s",z.msg);
ALLOCATE(buffer,dir[n].xsize+MAX_TAG_DISTANCE,uint8_t);
DBG(DBGBUFFER,"Allocating output buffer size=0x%x, margin=0x%x\n",dir[n].xsize,MAX_TAG_DISTANCE);
z.next_out= buffer;
z.avail_out= dir[n].xsize+MAX_TAG_DISTANCE;
i= inflate(&z,Z_FINISH);
DBG(DBGCOMPRESS,"in: avail/total=0x%x/0x%lx ""out: avail/total=0x%x/0x%lx, return %d;\n",
z.avail_in,z.total_in,z.avail_out,z.total_out,i);
if(i!=Z_STREAM_END)
QUIT("Unable to complete decompression: %s",z.msg);
if(z.avail_in!=0)
QUIT("Decompression missed input data");
if(z.total_out!=dir[n].xsize)
QUIT("Decompression output size mismatch 0x%lx != 0x%x",z.total_out,dir[n].xsize);
if(inflateEnd(&z)!=Z_OK)
QUIT("Unable to finalize decompression: %s",z.msg);
dir[n].buffer= buffer;
dir[n].bsize= dir[n].xsize;
hpos0= hpos= hstart= buffer;
hend= hstart+dir[n].xsize;
}
/*:350*//*352:*/
#line 7811 "../../../texk/web2c/hitexdir/hiformat.w"

void hget_section(uint16_t n)
{DBG(DBGDIR,"Reading section %d\n",n);
RNG("Section number",n,0,max_section_no);
if(dir[n].buffer!=NULL&&dir[n].xsize> 0)
{hpos0= hpos= hstart= dir[n].buffer;
hend= hstart+dir[n].xsize;
}
else
{hpos0= hpos= hstart= hin_addr+dir[n].pos;
hend= hstart+dir[n].size;
if(dir[n].xsize> 0)hdecompress(n);
}
}
/*:352*//*369:*/
#line 8190 "../../../texk/web2c/hitexdir/hiformat.w"

void hget_entry(Entry*e)
{/*16:*/
#line 726 "../../../texk/web2c/hitexdir/hiformat.w"

Tag a,z;
uint32_t node_pos= (uint32_t)(hpos-hstart);
if(hpos>=hend)QUIT("Attempt to read a start byte at the end of the section");
HGETTAG(a);
/*:16*/
#line 8192 "../../../texk/web2c/hitexdir/hiformat.w"

DBG(DBGDIR,"Reading directory entry\n");
switch(a)
{case TAG(0,b000+0):HGET_ENTRY(b000+0,*e);break;
case TAG(0,b000+1):HGET_ENTRY(b000+1,*e);break;
case TAG(0,b000+2):HGET_ENTRY(b000+2,*e);break;
case TAG(0,b000+3):HGET_ENTRY(b000+3,*e);break;
case TAG(0,b100+0):HGET_ENTRY(b100+0,*e);break;
case TAG(0,b100+1):HGET_ENTRY(b100+1,*e);break;
case TAG(0,b100+2):HGET_ENTRY(b100+2,*e);break;
case TAG(0,b100+3):HGET_ENTRY(b100+3,*e);break;
default:TAGERR(a);break;
}
/*17:*/
#line 733 "../../../texk/web2c/hitexdir/hiformat.w"

HGETTAG(z);
if(a!=z)
QUIT("Tag mismatch [%s,%d]!=[%s,%d] at 0x%x to "SIZE_F"\n",
NAME(a),INFO(a),NAME(z),INFO(z),node_pos,hpos-hstart-1);
/*:17*/
#line 8205 "../../../texk/web2c/hitexdir/hiformat.w"

}
/*:369*//*370:*/
#line 8222 "../../../texk/web2c/hitexdir/hiformat.w"

static void hget_root(Entry*root)
{DBG(DBGDIR,"Root entry at "SIZE_F"\n",hpos-hstart);
hget_entry(root);
root->pos= hpos-hstart;
max_section_no= root->section_no;
root->section_no= 0;
if(max_section_no<2)QUIT("Sections 0, 1, and 2 are mandatory");
}

void hget_directory(void)
{int i;
Entry root= {0};
hget_root(&root);
DBG(DBGDIR,"Directory\n");
new_directory(max_section_no+1);
dir[0]= root;
DBG(DBGDIR,"Directory entry 1 at 0x%"PRIx64"\n",dir[0].pos);
hget_section(0);
for(i= 1;i<=max_section_no;i++)
{hget_entry(&(dir[i]));
dir[i].pos= dir[i-1].pos+dir[i-1].size;
DBG(DBGDIR,"Section %d at 0x%"PRIx64"\n",i,dir[i].pos);
}
}

void hclear_dir(void)
{int i;
if(dir==NULL)return;
for(i= 0;i<3;i++)
if(dir[i].xsize> 0&&dir[i].buffer!=NULL)free(dir[i].buffer);
free(dir);dir= NULL;
}

/*:370*//*390:*/
#line 8660 "../../../texk/web2c/hitexdir/hiformat.w"

void hget_max_definitions(void)
{Kind k;
/*16:*/
#line 726 "../../../texk/web2c/hitexdir/hiformat.w"

Tag a,z;
uint32_t node_pos= (uint32_t)(hpos-hstart);
if(hpos>=hend)QUIT("Attempt to read a start byte at the end of the section");
HGETTAG(a);
/*:16*/
#line 8663 "../../../texk/web2c/hitexdir/hiformat.w"

if(a!=TAG(list_kind,0))QUIT("Start of maximum list expected");
for(k= 0;k<32;k++)max_ref[k]= max_default[k];max_outline= -1;
while(true)
{int n;
if(hpos>=hend)QUIT("Unexpected end of maximum list");
node_pos= hpos-hstart;
HGETTAG(a);
k= KIND(a);
if(k==list_kind)break;
if(INFO(a)&b001)HGET16(n);else n= HGET8;
switch(a)
{/*246:*/
#line 5363 "../../../texk/web2c/hitexdir/hiformat.w"


case TAG(outline_kind,b100):
case TAG(outline_kind,b101):max_outline= n;
DBG(DBGDEF|DBGLABEL,"max(outline) = %d\n",max_outline);break;
/*:246*/
#line 8675 "../../../texk/web2c/hitexdir/hiformat.w"

default:
if(max_fixed[k]> max_default[k])
MESSAGE("Maximum value for kind %s not supported\n",definition_name[k]);else
{RNG("Maximum number",n,max_default[k],MAX_REF(k));
max_ref[k]= n;
DBG(DBGDEF,"max(%s) = %d\n",definition_name[k],max_ref[k]);
}
break;
}
/*17:*/
#line 733 "../../../texk/web2c/hitexdir/hiformat.w"

HGETTAG(z);
if(a!=z)
QUIT("Tag mismatch [%s,%d]!=[%s,%d] at 0x%x to "SIZE_F"\n",
NAME(a),INFO(a),NAME(z),INFO(z),node_pos,hpos-hstart-1);
/*:17*/
#line 8685 "../../../texk/web2c/hitexdir/hiformat.w"

}
if(INFO(a)!=0)QUIT("End of maximum list with info %d",INFO(a));
DBG(DBGDEF,"Getting Max Definitions END\n");
}
/*:390*/
#line 11832 "../../../texk/web2c/hitexdir/hiformat.w"

/*53:*/
#line 1244 "../../../texk/web2c/hitexdir/hiformat.w"

#define HGET_UTF8C(X)  (X)= HGET8; if ((X&0xC0)!=0x80) \
  QUIT("UTF8 continuation byte expected at " SIZE_F " got 0x%02X\n",hpos-hstart-1,X)

uint32_t hget_utf8(void)
{uint8_t a;
a= HGET8;
if(a<0x80)return a;
else
{if((a&0xE0)==0xC0)
{uint8_t b;HGET_UTF8C(b);
return((a&~0xE0)<<6)+(b&~0xC0);
}
else if((a&0xF0)==0xE0)
{uint8_t b,c;HGET_UTF8C(b);HGET_UTF8C(c);
return((a&~0xF0)<<12)+((b&~0xC0)<<6)+(c&~0xC0);
}
else if((a&0xF8)==0xF0)
{uint8_t b,c,d;HGET_UTF8C(b);HGET_UTF8C(c);HGET_UTF8C(d);
return((a&~0xF8)<<18)+((b&~0xC0)<<12)+((c&~0xC0)<<6)+(d&~0xC0);
}
else QUIT("UTF8 byte sequence expected");
}
}
/*:53*//*76:*/
#line 1627 "../../../texk/web2c/hitexdir/hiformat.w"

float32_t hget_float32(void)
{union{float32_t d;uint32_t bits;}u;
HGET32(u.bits);
return u.d;
}
/*:76*//*146:*/
#line 2850 "../../../texk/web2c/hitexdir/hiformat.w"

void hget_size_boundary(Info info)
{uint32_t n;
info= info&0x3;
if(info==0)return;
n= HGET8;
if(n!=0x100-info)QUIT("Non matching boundary byte 0x%x with info value %d at 0x%x",
n,info,(uint32_t)(hpos-hstart-1));
}

uint32_t hget_list_size(Info info)
{uint32_t n= 0;
info= info&0x3;
if(info==0)return 0;
else if(info==1)n= HGET8;
else if(info==2)HGET16(n);
else if(info==3)HGET32(n);
else QUIT("List info %d must be 0, 1, 2, or 3",info);
return n;
}

void hget_list(List*l)
{if(KIND(*hpos)!=list_kind&&KIND(*hpos)!=param_kind)
QUIT("List expected at 0x%x",(uint32_t)(hpos-hstart));
else
{
/*16:*/
#line 726 "../../../texk/web2c/hitexdir/hiformat.w"

Tag a,z;
uint32_t node_pos= (uint32_t)(hpos-hstart);
if(hpos>=hend)QUIT("Attempt to read a start byte at the end of the section");
HGETTAG(a);
/*:16*/
#line 2876 "../../../texk/web2c/hitexdir/hiformat.w"

l->t= a;
HGET_LIST(INFO(a),*l);
/*17:*/
#line 733 "../../../texk/web2c/hitexdir/hiformat.w"

HGETTAG(z);
if(a!=z)
QUIT("Tag mismatch [%s,%d]!=[%s,%d] at 0x%x to "SIZE_F"\n",
NAME(a),INFO(a),NAME(z),INFO(z),node_pos,hpos-hstart-1);
/*:17*/
#line 2879 "../../../texk/web2c/hitexdir/hiformat.w"

DBG(DBGNODE,"Get list at 0x%x size=%u\n",l->p,l->s);
}
}
/*:146*/
#line 11833 "../../../texk/web2c/hitexdir/hiformat.w"

/*18:*/
#line 766 "../../../texk/web2c/hitexdir/hiformat.w"

static void hget_content(Tag a);
Tag hget_content_node(void)
{/*16:*/
#line 726 "../../../texk/web2c/hitexdir/hiformat.w"

Tag a,z;
uint32_t node_pos= (uint32_t)(hpos-hstart);
if(hpos>=hend)QUIT("Attempt to read a start byte at the end of the section");
HGETTAG(a);
/*:16*/
#line 769 "../../../texk/web2c/hitexdir/hiformat.w"
hwrite_start();
if(content_known[KIND(a)]&(1<<INFO(a)))hwritef("%s",content_name[KIND(a)]);
hget_content(a);
/*17:*/
#line 733 "../../../texk/web2c/hitexdir/hiformat.w"

HGETTAG(z);
if(a!=z)
QUIT("Tag mismatch [%s,%d]!=[%s,%d] at 0x%x to "SIZE_F"\n",
NAME(a),INFO(a),NAME(z),INFO(z),node_pos,hpos-hstart-1);
/*:17*/
#line 772 "../../../texk/web2c/hitexdir/hiformat.w"
hwrite_end();
return a;
}

static void hget_content(Tag a)
{
switch(a)
{
/*20:*/
#line 816 "../../../texk/web2c/hitexdir/hiformat.w"

case TAG(glyph_kind,1):{Glyph g;HGET_GLYPH(1,g);}break;
case TAG(glyph_kind,2):{Glyph g;HGET_GLYPH(2,g);}break;
case TAG(glyph_kind,3):{Glyph g;HGET_GLYPH(3,g);}break;
case TAG(glyph_kind,4):{Glyph g;HGET_GLYPH(4,g);}break;
/*:20*//*106:*/
#line 2035 "../../../texk/web2c/hitexdir/hiformat.w"

case TAG(penalty_kind,1):{int32_t p;HGET_PENALTY(1,p);}break;
case TAG(penalty_kind,2):{int32_t p;HGET_PENALTY(2,p);}break;
case TAG(penalty_kind,3):{int32_t p;HGET_PENALTY(3,p);}break;
/*:106*//*111:*/
#line 2114 "../../../texk/web2c/hitexdir/hiformat.w"

case TAG(language_kind,1):REF(language_kind,0);hwrite_ref(0);break;
case TAG(language_kind,2):REF(language_kind,1);hwrite_ref(1);break;
case TAG(language_kind,3):REF(language_kind,2);hwrite_ref(2);break;
case TAG(language_kind,4):REF(language_kind,3);hwrite_ref(3);break;
case TAG(language_kind,5):REF(language_kind,4);hwrite_ref(4);break;
case TAG(language_kind,6):REF(language_kind,5);hwrite_ref(5);break;
case TAG(language_kind,7):REF(language_kind,6);hwrite_ref(6);break;
/*:111*//*119:*/
#line 2231 "../../../texk/web2c/hitexdir/hiformat.w"


case TAG(rule_kind,b011):{Rule r;HGET_RULE(b011,r);hwrite_rule(&(r));}break;
case TAG(rule_kind,b101):{Rule r;HGET_RULE(b101,r);hwrite_rule(&(r));}break;
case TAG(rule_kind,b001):{Rule r;HGET_RULE(b001,r);hwrite_rule(&(r));}break;
case TAG(rule_kind,b110):{Rule r;HGET_RULE(b110,r);hwrite_rule(&(r));}break;
case TAG(rule_kind,b111):{Rule r;HGET_RULE(b111,r);hwrite_rule(&(r));}break;
/*:119*//*128:*/
#line 2340 "../../../texk/web2c/hitexdir/hiformat.w"


case TAG(kern_kind,b010):{Kern k;HGET_KERN(b010,k);}break;
case TAG(kern_kind,b011):{Kern k;HGET_KERN(b011,k);}break;
case TAG(kern_kind,b110):{Kern k;HGET_KERN(b110,k);}break;
case TAG(kern_kind,b111):{Kern k;HGET_KERN(b111,k);}break;
/*:128*//*137:*/
#line 2566 "../../../texk/web2c/hitexdir/hiformat.w"


case TAG(glue_kind,b001):{Glue g;HGET_GLUE(b001,g);hwrite_glue(&g);}break;
case TAG(glue_kind,b010):{Glue g;HGET_GLUE(b010,g);hwrite_glue(&g);}break;
case TAG(glue_kind,b011):{Glue g;HGET_GLUE(b011,g);hwrite_glue(&g);}break;
case TAG(glue_kind,b100):{Glue g;HGET_GLUE(b100,g);hwrite_glue(&g);}break;
case TAG(glue_kind,b101):{Glue g;HGET_GLUE(b101,g);hwrite_glue(&g);}break;
case TAG(glue_kind,b110):{Glue g;HGET_GLUE(b110,g);hwrite_glue(&g);}break;
case TAG(glue_kind,b111):{Glue g;HGET_GLUE(b111,g);hwrite_glue(&g);}break;
/*:137*//*165:*/
#line 3535 "../../../texk/web2c/hitexdir/hiformat.w"


case TAG(hbox_kind,b000):{Box b;HGET_BOX(b000,b);hwrite_box(&b);}break;
case TAG(hbox_kind,b001):{Box b;HGET_BOX(b001,b);hwrite_box(&b);}break;
case TAG(hbox_kind,b010):{Box b;HGET_BOX(b010,b);hwrite_box(&b);}break;
case TAG(hbox_kind,b011):{Box b;HGET_BOX(b011,b);hwrite_box(&b);}break;
case TAG(hbox_kind,b100):{Box b;HGET_BOX(b100,b);hwrite_box(&b);}break;
case TAG(hbox_kind,b101):{Box b;HGET_BOX(b101,b);hwrite_box(&b);}break;
case TAG(hbox_kind,b110):{Box b;HGET_BOX(b110,b);hwrite_box(&b);}break;
case TAG(hbox_kind,b111):{Box b;HGET_BOX(b111,b);hwrite_box(&b);}break;
case TAG(vbox_kind,b000):{Box b;HGET_BOX(b000,b);hwrite_box(&b);}break;
case TAG(vbox_kind,b001):{Box b;HGET_BOX(b001,b);hwrite_box(&b);}break;
case TAG(vbox_kind,b010):{Box b;HGET_BOX(b010,b);hwrite_box(&b);}break;
case TAG(vbox_kind,b011):{Box b;HGET_BOX(b011,b);hwrite_box(&b);}break;
case TAG(vbox_kind,b100):{Box b;HGET_BOX(b100,b);hwrite_box(&b);}break;
case TAG(vbox_kind,b101):{Box b;HGET_BOX(b101,b);hwrite_box(&b);}break;
case TAG(vbox_kind,b110):{Box b;HGET_BOX(b110,b);hwrite_box(&b);}break;
case TAG(vbox_kind,b111):{Box b;HGET_BOX(b111,b);hwrite_box(&b);}break;
/*:165*//*172:*/
#line 3744 "../../../texk/web2c/hitexdir/hiformat.w"


case TAG(hset_kind,b000):HGET_SET(hset_kind,b000);break;
case TAG(hset_kind,b001):HGET_SET(hset_kind,b001);break;
case TAG(hset_kind,b010):HGET_SET(hset_kind,b010);break;
case TAG(hset_kind,b011):HGET_SET(hset_kind,b011);break;
case TAG(hset_kind,b100):HGET_SET(hset_kind,b100);break;
case TAG(hset_kind,b101):HGET_SET(hset_kind,b101);break;
case TAG(hset_kind,b110):HGET_SET(hset_kind,b110);break;
case TAG(hset_kind,b111):HGET_SET(hset_kind,b111);break;

case TAG(vset_kind,b000):HGET_SET(vset_kind,b000);break;
case TAG(vset_kind,b001):HGET_SET(vset_kind,b001);break;
case TAG(vset_kind,b010):HGET_SET(vset_kind,b010);break;
case TAG(vset_kind,b011):HGET_SET(vset_kind,b011);break;
case TAG(vset_kind,b100):HGET_SET(vset_kind,b100);break;
case TAG(vset_kind,b101):HGET_SET(vset_kind,b101);break;
case TAG(vset_kind,b110):HGET_SET(vset_kind,b110);break;
case TAG(vset_kind,b111):HGET_SET(vset_kind,b111);break;

case TAG(hpack_kind,b000):HGET_PACK(hpack_kind,b000);break;
case TAG(hpack_kind,b001):HGET_PACK(hpack_kind,b001);break;
case TAG(hpack_kind,b010):HGET_PACK(hpack_kind,b010);break;
case TAG(hpack_kind,b011):HGET_PACK(hpack_kind,b011);break;
case TAG(hpack_kind,b100):HGET_PACK(hpack_kind,b100);break;
case TAG(hpack_kind,b101):HGET_PACK(hpack_kind,b101);break;
case TAG(hpack_kind,b110):HGET_PACK(hpack_kind,b110);break;
case TAG(hpack_kind,b111):HGET_PACK(hpack_kind,b111);break;

case TAG(vpack_kind,b000):HGET_PACK(vpack_kind,b000);break;
case TAG(vpack_kind,b001):HGET_PACK(vpack_kind,b001);break;
case TAG(vpack_kind,b010):HGET_PACK(vpack_kind,b010);break;
case TAG(vpack_kind,b011):HGET_PACK(vpack_kind,b011);break;
case TAG(vpack_kind,b100):HGET_PACK(vpack_kind,b100);break;
case TAG(vpack_kind,b101):HGET_PACK(vpack_kind,b101);break;
case TAG(vpack_kind,b110):HGET_PACK(vpack_kind,b110);break;
case TAG(vpack_kind,b111):HGET_PACK(vpack_kind,b111);break;
/*:172*//*178:*/
#line 3869 "../../../texk/web2c/hitexdir/hiformat.w"


case TAG(leaders_kind,1):HGET_LEADERS(1);break;
case TAG(leaders_kind,2):HGET_LEADERS(2);break;
case TAG(leaders_kind,3):HGET_LEADERS(3);break;
case TAG(leaders_kind,b100|1):HGET_LEADERS(b100|1);break;
case TAG(leaders_kind,b100|2):HGET_LEADERS(b100|2);break;
case TAG(leaders_kind,b100|3):HGET_LEADERS(b100|3);break;
/*:178*//*184:*/
#line 3972 "../../../texk/web2c/hitexdir/hiformat.w"


case TAG(baseline_kind,b001):{Baseline b;HGET_BASELINE(b001,b);}break;
case TAG(baseline_kind,b010):{Baseline b;HGET_BASELINE(b010,b);}break;
case TAG(baseline_kind,b011):{Baseline b;HGET_BASELINE(b011,b);}break;
case TAG(baseline_kind,b100):{Baseline b;HGET_BASELINE(b100,b);}break;
case TAG(baseline_kind,b101):{Baseline b;HGET_BASELINE(b101,b);}break;
case TAG(baseline_kind,b110):{Baseline b;HGET_BASELINE(b110,b);}break;
case TAG(baseline_kind,b111):{Baseline b;HGET_BASELINE(b111,b);}break;
/*:184*//*192:*/
#line 4077 "../../../texk/web2c/hitexdir/hiformat.w"


case TAG(ligature_kind,1):{Lig l;HGET_LIG(1,l);}break;
case TAG(ligature_kind,2):{Lig l;HGET_LIG(2,l);}break;
case TAG(ligature_kind,3):{Lig l;HGET_LIG(3,l);}break;
case TAG(ligature_kind,4):{Lig l;HGET_LIG(4,l);}break;
case TAG(ligature_kind,5):{Lig l;HGET_LIG(5,l);}break;
case TAG(ligature_kind,6):{Lig l;HGET_LIG(6,l);}break;
case TAG(ligature_kind,7):{Lig l;HGET_LIG(7,l);}break;
/*:192*//*200:*/
#line 4197 "../../../texk/web2c/hitexdir/hiformat.w"


case TAG(disc_kind,b001):{Disc h;HGET_DISC(b001,h);hwrite_disc(&h);}break;
case TAG(disc_kind,b010):{Disc h;HGET_DISC(b010,h);hwrite_disc(&h);}break;
case TAG(disc_kind,b011):{Disc h;HGET_DISC(b011,h);hwrite_disc(&h);}break;
case TAG(disc_kind,b100):{Disc h;HGET_DISC(b100,h);hwrite_disc(&h);}break;
case TAG(disc_kind,b101):{Disc h;HGET_DISC(b101,h);hwrite_disc(&h);}break;
case TAG(disc_kind,b110):{Disc h;HGET_DISC(b110,h);hwrite_disc(&h);}break;
case TAG(disc_kind,b111):{Disc h;HGET_DISC(b111,h);hwrite_disc(&h);}break;
/*:200*//*207:*/
#line 4341 "../../../texk/web2c/hitexdir/hiformat.w"


case TAG(par_kind,b000):HGET_PAR(b000);break;
case TAG(par_kind,b010):HGET_PAR(b010);break;
case TAG(par_kind,b100):HGET_PAR(b100);break;
case TAG(par_kind,b110):HGET_PAR(b110);break;
/*:207*//*212:*/
#line 4414 "../../../texk/web2c/hitexdir/hiformat.w"


case TAG(math_kind,b000):HGET_MATH(b000);break;
case TAG(math_kind,b001):HGET_MATH(b001);break;
case TAG(math_kind,b010):HGET_MATH(b010);break;
case TAG(math_kind,b100):HGET_MATH(b100);break;
case TAG(math_kind,b101):HGET_MATH(b101);break;
case TAG(math_kind,b110):HGET_MATH(b110);break;
/*:212*//*217:*/
#line 4465 "../../../texk/web2c/hitexdir/hiformat.w"


case TAG(math_kind,b111):hwritef(" on");break;
case TAG(math_kind,b011):hwritef(" off");break;
/*:217*//*221:*/
#line 4496 "../../../texk/web2c/hitexdir/hiformat.w"


case TAG(adjust_kind,1):{List l;hget_list(&l);hwrite_list(&l);}break;
/*:221*//*225:*/
#line 4603 "../../../texk/web2c/hitexdir/hiformat.w"


case TAG(table_kind,b000):HGET_TABLE(b000);break;
case TAG(table_kind,b001):HGET_TABLE(b001);break;
case TAG(table_kind,b010):HGET_TABLE(b010);break;
case TAG(table_kind,b011):HGET_TABLE(b011);break;
case TAG(table_kind,b100):HGET_TABLE(b100);break;
case TAG(table_kind,b101):HGET_TABLE(b101);break;
case TAG(table_kind,b110):HGET_TABLE(b110);break;
case TAG(table_kind,b111):HGET_TABLE(b111);break;

case TAG(item_kind,b000):{List l;hget_list(&l);hwrite_list(&l);}break;
case TAG(item_kind,b001):hget_content_node();break;
case TAG(item_kind,b010):hwritef(" 2");hget_content_node();break;
case TAG(item_kind,b011):hwritef(" 3");hget_content_node();break;
case TAG(item_kind,b100):hwritef(" 4");hget_content_node();break;
case TAG(item_kind,b101):hwritef(" 5");hget_content_node();break;
case TAG(item_kind,b110):hwritef(" 6");hget_content_node();break;
case TAG(item_kind,b111):hwritef(" %u",HGET8);hget_content_node();break;
/*:225*//*233:*/
#line 4783 "../../../texk/web2c/hitexdir/hiformat.w"


case TAG(image_kind,b001):HGET_IMAGE(b001);break;
case TAG(image_kind,b010):HGET_IMAGE(b010);break;
case TAG(image_kind,b011):HGET_IMAGE(b011);break;
case TAG(image_kind,b100):HGET_IMAGE(b100);break;
case TAG(image_kind,b101):HGET_IMAGE(b101);break;
case TAG(image_kind,b110):HGET_IMAGE(b110);break;
case TAG(image_kind,b111):HGET_IMAGE(b111);break;
/*:233*//*266:*/
#line 5743 "../../../texk/web2c/hitexdir/hiformat.w"


case TAG(link_kind,b000):HGET_LINK(b000);break;
case TAG(link_kind,b001):HGET_LINK(b001);break;
case TAG(link_kind,b010):HGET_LINK(b010);break;
case TAG(link_kind,b011):HGET_LINK(b011);break;
case TAG(link_kind,b100):HGET_LINK(b100);break;
case TAG(link_kind,b101):HGET_LINK(b101);break;
case TAG(link_kind,b110):HGET_LINK(b110);break;
case TAG(link_kind,b111):HGET_LINK(b111);break;
/*:266*//*297:*/
#line 6319 "../../../texk/web2c/hitexdir/hiformat.w"


case TAG(color_kind,b000):
{uint8_t n= HGET8;
if(n==0xFF)hwritef(" off");
else{REF(color_kind,n);hwrite_ref(n);}
}
break;
/*:297*//*314:*/
#line 6962 "../../../texk/web2c/hitexdir/hiformat.w"


case TAG(stream_kind,b100):{uint8_t n= HGET8;REF_RNG(stream_kind,n);hwrite_ref(n);break;}
/*:314*//*317:*/
#line 7007 "../../../texk/web2c/hitexdir/hiformat.w"


case TAG(stream_kind,b000):HGET_STREAM(b000);break;
case TAG(stream_kind,b010):HGET_STREAM(b010);break;
/*:317*//*416:*/
#line 9281 "../../../texk/web2c/hitexdir/hiformat.w"


case TAG(penalty_kind,0):HGET_REF(penalty_kind);break;
case TAG(kern_kind,b000):HGET_REF(dimen_kind);break;
case TAG(kern_kind,b100):hwritef(" !");HGET_REF(dimen_kind);break;
case TAG(kern_kind,b001):hwritef(" xdimen");HGET_REF(xdimen_kind);break;
case TAG(kern_kind,b101):hwritef(" ! xdimen");HGET_REF(xdimen_kind);break;
case TAG(ligature_kind,0):HGET_REF(ligature_kind);break;
case TAG(disc_kind,0):HGET_REF(disc_kind);break;
case TAG(glue_kind,0):HGET_REF(glue_kind);break;
case TAG(language_kind,b000):HGET_REF(language_kind);break;
case TAG(rule_kind,0):HGET_REF(rule_kind);break;
case TAG(image_kind,0):HGET_REF(image_kind);break;
case TAG(leaders_kind,0):HGET_REF(leaders_kind);break;
case TAG(baseline_kind,0):HGET_REF(baseline_kind);break;
/*:416*/
#line 780 "../../../texk/web2c/hitexdir/hiformat.w"

default:
if(!hget_unknown(a))
TAGERR(a);
break;
}
}
/*:18*//*85:*/
#line 1727 "../../../texk/web2c/hitexdir/hiformat.w"

void hget_dimen(Tag a)
{if(INFO(a)==b000)
{uint8_t r;r= HGET8;REF(dimen_kind,r);hwrite_ref(r);}
else
{uint32_t d;HGET32(d);hwrite_dimension(d);}
}
/*:85*//*93:*/
#line 1819 "../../../texk/web2c/hitexdir/hiformat.w"

void hget_xdimen(Tag a,Xdimen*x)
{switch(a)
{
case TAG(xdimen_kind,b001):HGET_XDIMEN(b001,*x);break;
case TAG(xdimen_kind,b010):HGET_XDIMEN(b010,*x);break;
case TAG(xdimen_kind,b011):HGET_XDIMEN(b011,*x);break;
case TAG(xdimen_kind,b100):HGET_XDIMEN(b100,*x);break;
case TAG(xdimen_kind,b101):HGET_XDIMEN(b101,*x);break;
case TAG(xdimen_kind,b110):HGET_XDIMEN(b110,*x);break;
case TAG(xdimen_kind,b111):HGET_XDIMEN(b111,*x);break;
default:
QUIT("Extent expected got [%s,%d]",NAME(a),INFO(a));
}
}
/*:93*//*94:*/
#line 1843 "../../../texk/web2c/hitexdir/hiformat.w"

void hget_xdimen_node(Xdimen*x)
{/*16:*/
#line 726 "../../../texk/web2c/hitexdir/hiformat.w"

Tag a,z;
uint32_t node_pos= (uint32_t)(hpos-hstart);
if(hpos>=hend)QUIT("Attempt to read a start byte at the end of the section");
HGETTAG(a);
/*:16*/
#line 1845 "../../../texk/web2c/hitexdir/hiformat.w"

if(KIND(a)==xdimen_kind)
hget_xdimen(a,x);
else
QUIT("Extent expected at 0x%x got %s",node_pos,NAME(a));
/*17:*/
#line 733 "../../../texk/web2c/hitexdir/hiformat.w"

HGETTAG(z);
if(a!=z)
QUIT("Tag mismatch [%s,%d]!=[%s,%d] at 0x%x to "SIZE_F"\n",
NAME(a),INFO(a),NAME(z),INFO(z),node_pos,hpos-hstart-1);
/*:17*/
#line 1850 "../../../texk/web2c/hitexdir/hiformat.w"

}
/*:94*//*121:*/
#line 2247 "../../../texk/web2c/hitexdir/hiformat.w"

void hget_rule_node(void)
{/*16:*/
#line 726 "../../../texk/web2c/hitexdir/hiformat.w"

Tag a,z;
uint32_t node_pos= (uint32_t)(hpos-hstart);
if(hpos>=hend)QUIT("Attempt to read a start byte at the end of the section");
HGETTAG(a);
/*:16*/
#line 2249 "../../../texk/web2c/hitexdir/hiformat.w"

if(KIND(a)==rule_kind)
{Rule r;HGET_RULE(INFO(a),r);
hwrite_start();hwritef("rule");hwrite_rule(&r);hwrite_end();
}
else
QUIT("Rule expected at 0x%x got %s",node_pos,NAME(a));
/*17:*/
#line 733 "../../../texk/web2c/hitexdir/hiformat.w"

HGETTAG(z);
if(a!=z)
QUIT("Tag mismatch [%s,%d]!=[%s,%d] at 0x%x to "SIZE_F"\n",
NAME(a),INFO(a),NAME(z),INFO(z),node_pos,hpos-hstart-1);
/*:17*/
#line 2256 "../../../texk/web2c/hitexdir/hiformat.w"

}
/*:121*//*139:*/
#line 2588 "../../../texk/web2c/hitexdir/hiformat.w"

void hget_glue_node(void)
{/*16:*/
#line 726 "../../../texk/web2c/hitexdir/hiformat.w"

Tag a,z;
uint32_t node_pos= (uint32_t)(hpos-hstart);
if(hpos>=hend)QUIT("Attempt to read a start byte at the end of the section");
HGETTAG(a);
/*:16*/
#line 2590 "../../../texk/web2c/hitexdir/hiformat.w"

if(KIND(a)!=glue_kind)
{hpos--;hwrite_ref_node(glue_kind,zero_skip_no);return;}
if(INFO(a)==b000)
{uint8_t n= HGET8;REF(glue_kind,n);hwrite_ref_node(glue_kind,n);}
else
{Glue g;HGET_GLUE(INFO(a),g);hwrite_glue_node(&g);}
/*17:*/
#line 733 "../../../texk/web2c/hitexdir/hiformat.w"

HGETTAG(z);
if(a!=z)
QUIT("Tag mismatch [%s,%d]!=[%s,%d] at 0x%x to "SIZE_F"\n",
NAME(a),INFO(a),NAME(z),INFO(z),node_pos,hpos-hstart-1);
/*:17*/
#line 2597 "../../../texk/web2c/hitexdir/hiformat.w"

}
/*:139*//*158:*/
#line 3311 "../../../texk/web2c/hitexdir/hiformat.w"

int hget_txt(void)
{if(*hpos>=0x80&&*hpos<=0xF7)
{if(option_utf8)
return hwrite_utf8(hget_utf8());
else
return hwritef("\\C%d\\",hget_utf8());
}
else
{uint8_t a;
a= HGET8;
switch(a)
{case txt_font+0:return hwritef("\\0");
case txt_font+1:return hwritef("\\1");
case txt_font+2:return hwritef("\\2");
case txt_font+3:return hwritef("\\3");
case txt_font+4:return hwritef("\\4");
case txt_font+5:return hwritef("\\5");
case txt_font+6:return hwritef("\\6");
case txt_font+7:return hwritef("\\7");
case txt_global+0:HGET_GREF(font_kind,"F");
case txt_global+1:HGET_GREF(penalty_kind,"P");
case txt_global+2:HGET_GREF(kern_kind,"K");
case txt_global+3:HGET_GREF(ligature_kind,"L");
case txt_global+4:HGET_GREF(disc_kind,"D");
case txt_global+5:HGET_GREF(glue_kind,"G");
case txt_global+6:HGET_GREF(language_kind,"S");
case txt_global+7:HGET_GREF(rule_kind,"R");
case txt_global+8:HGET_GREF(image_kind,"I");
case txt_local+0:return hwritef("\\a");
case txt_local+1:return hwritef("\\b");
case txt_local+2:return hwritef("\\c");
case txt_local+3:return hwritef("\\d");
case txt_local+4:return hwritef("\\e");
case txt_local+5:return hwritef("\\f");
case txt_local+6:return hwritef("\\g");
case txt_local+7:return hwritef("\\h");
case txt_local+8:return hwritef("\\i");
case txt_local+9:return hwritef("\\j");
case txt_local+10:return hwritef("\\k");
case txt_local+11:return hwritef("\\l");
case txt_cc:return hwrite_txt_cc(hget_utf8());
case txt_node:{int i;
/*16:*/
#line 726 "../../../texk/web2c/hitexdir/hiformat.w"

Tag a,z;
uint32_t node_pos= (uint32_t)(hpos-hstart);
if(hpos>=hend)QUIT("Attempt to read a start byte at the end of the section");
HGETTAG(a);
/*:16*/
#line 3354 "../../../texk/web2c/hitexdir/hiformat.w"

i= hwritef("<");
i+= hwritef("%s",content_name[KIND(a)]);hget_content(a);
/*17:*/
#line 733 "../../../texk/web2c/hitexdir/hiformat.w"

HGETTAG(z);
if(a!=z)
QUIT("Tag mismatch [%s,%d]!=[%s,%d] at 0x%x to "SIZE_F"\n",
NAME(a),INFO(a),NAME(z),INFO(z),node_pos,hpos-hstart-1);
/*:17*/
#line 3357 "../../../texk/web2c/hitexdir/hiformat.w"

hwritec('>');return i+10;
}
case txt_hyphen:hwritec('-');return 1;
case txt_glue:return-1;
case'<':return hwritef("\\<");
case'>':return hwritef("\\>");
case'"':return hwritef("\\\"");
case'-':return hwritef("\\-");
case txt_ignore:return hwritef("\\@");
default:hwritec(a);return 1;
}
}
}

/*:158*//*167:*/
#line 3566 "../../../texk/web2c/hitexdir/hiformat.w"

void hget_hbox_node(void)
{Box b;
/*16:*/
#line 726 "../../../texk/web2c/hitexdir/hiformat.w"

Tag a,z;
uint32_t node_pos= (uint32_t)(hpos-hstart);
if(hpos>=hend)QUIT("Attempt to read a start byte at the end of the section");
HGETTAG(a);
/*:16*/
#line 3569 "../../../texk/web2c/hitexdir/hiformat.w"

if(KIND(a)!=hbox_kind)QUIT("Hbox expected at 0x%x got %s",node_pos,NAME(a));
HGET_BOX(INFO(a),b);
/*17:*/
#line 733 "../../../texk/web2c/hitexdir/hiformat.w"

HGETTAG(z);
if(a!=z)
QUIT("Tag mismatch [%s,%d]!=[%s,%d] at 0x%x to "SIZE_F"\n",
NAME(a),INFO(a),NAME(z),INFO(z),node_pos,hpos-hstart-1);
/*:17*/
#line 3572 "../../../texk/web2c/hitexdir/hiformat.w"

hwrite_start();
hwritef("hbox");
hwrite_box(&b);
hwrite_end();
}


void hget_vbox_node(void)
{Box b;
/*16:*/
#line 726 "../../../texk/web2c/hitexdir/hiformat.w"

Tag a,z;
uint32_t node_pos= (uint32_t)(hpos-hstart);
if(hpos>=hend)QUIT("Attempt to read a start byte at the end of the section");
HGETTAG(a);
/*:16*/
#line 3582 "../../../texk/web2c/hitexdir/hiformat.w"

if(KIND(a)!=vbox_kind)QUIT("Vbox expected at 0x%x got %s",node_pos,NAME(a));
HGET_BOX(INFO(a),b);
/*17:*/
#line 733 "../../../texk/web2c/hitexdir/hiformat.w"

HGETTAG(z);
if(a!=z)
QUIT("Tag mismatch [%s,%d]!=[%s,%d] at 0x%x to "SIZE_F"\n",
NAME(a),INFO(a),NAME(z),INFO(z),node_pos,hpos-hstart-1);
/*:17*/
#line 3585 "../../../texk/web2c/hitexdir/hiformat.w"

hwrite_start();
hwritef("vbox");
hwrite_box(&b);
hwrite_end();
}
/*:167*//*202:*/
#line 4216 "../../../texk/web2c/hitexdir/hiformat.w"

void hget_disc_node(Disc*h)
{/*16:*/
#line 726 "../../../texk/web2c/hitexdir/hiformat.w"

Tag a,z;
uint32_t node_pos= (uint32_t)(hpos-hstart);
if(hpos>=hend)QUIT("Attempt to read a start byte at the end of the section");
HGETTAG(a);
/*:16*/
#line 4218 "../../../texk/web2c/hitexdir/hiformat.w"

if(KIND(a)!=disc_kind||INFO(a)==b000)
QUIT("Hyphen expected at 0x%x got %s,%d",node_pos,NAME(a),INFO(a));
HGET_DISC(INFO(a),*h);
/*17:*/
#line 733 "../../../texk/web2c/hitexdir/hiformat.w"

HGETTAG(z);
if(a!=z)
QUIT("Tag mismatch [%s,%d]!=[%s,%d] at 0x%x to "SIZE_F"\n",
NAME(a),INFO(a),NAME(z),INFO(z),node_pos,hpos-hstart-1);
/*:17*/
#line 4222 "../../../texk/web2c/hitexdir/hiformat.w"

}
/*:202*//*245:*/
#line 5345 "../../../texk/web2c/hitexdir/hiformat.w"

void hget_outline_or_label_def(Info i,uint32_t node_pos)
{if(i&b100)
/*277:*/
#line 5877 "../../../texk/web2c/hitexdir/hiformat.w"

{int r,d;
List l;
static int outline_no= -1;
hwrite_start();hwritef("outline");
++outline_no;
RNG("outline",outline_no,0,max_outline);
if(i&b001)HGET16(r);else r= HGET8;
REF_RNG(link_kind,r);
if(labels[r].where==LABEL_UNDEF)
MESSAGE("WARNING: Outline with undefined label %d at 0x%x\n",r,node_pos);
hwritef(" *%d",r);
d= HGET8;hwritef(" %d",d);
hget_list(&l);hwrite_list(&l);
hwrite_end();
}
/*:277*/
#line 5348 "../../../texk/web2c/hitexdir/hiformat.w"

else
/*261:*/
#line 5619 "../../../texk/web2c/hitexdir/hiformat.w"

{Label*t;
int n;
if(i&b001)HGET16(n);else n= HGET8;
REF_RNG(label_kind,n);
t= labels+n;
if(t->where!=LABEL_UNDEF)
DBG(DBGLABEL,"Duplicate definition of label %d at 0x%x\n",n,node_pos);
HGET32(t->pos);
t->where= HGET8;
if(t->where==LABEL_UNDEF||t->where> LABEL_MID)
DBG(DBGLABEL,"Label %d where value invalid: %d at 0x%x\n",n,t->where,node_pos);
if(i&b010)
{HGET32(t->pos0);t->f= HGET8;}
else t->pos0= t->pos;
DBG(DBGLABEL,"Defining label %d at 0x%x/0x%x\n",n,t->pos0,t->pos);
}
/*:261*/
#line 5350 "../../../texk/web2c/hitexdir/hiformat.w"

}
/*:245*//*298:*/
#line 6331 "../../../texk/web2c/hitexdir/hiformat.w"

void hwrite_color_pair(uint32_t f,uint32_t b)
{hwritec('<');
if(f==0)hwritec('0');else hwritef("0x%08X",f);
if(b!=0)hwritef(" 0x%08X",b);
hwritec('>');
}

void hget_color_set(uint32_t node_pos,ColorSet cs)
{int i,m;
for(i= 0;i<sizeof(ColorSet)/4;i++)
HGET32(cs[i]);
for(m= 0;m<2;m++)
{uint32_t*c,*d;
bool diff_high,diff_focus;
if(m==0)
{c= cs;d= color_defaults[0];}
else
{c= NIGHT(cs);d= NIGHT(color_defaults[0]);
if(memcmp(c,d,sizeof(ColorSet)/2)==0)
return;
}
hwrite_start();
diff_high= FG(HIGH(c))!=FG(HIGH(d))||BG(HIGH(c))!=BG(HIGH(d));
diff_focus= FG(FOCUS(c))!=FG(FOCUS(d))||BG(FOCUS(c))!=BG(FOCUS(d));
hwrite_color_pair(FG(c),BG(c));
if(diff_high||diff_focus)
{hwritec(' ');hwrite_color_pair(FG(HIGH(c)),BG(HIGH(c)));}
if(diff_focus)
{hwritec(' ');hwrite_color_pair(FG(FOCUS(c)),BG(FOCUS(c)));}
hwrite_end();
}
}
/*:298*//*307:*/
#line 6520 "../../../texk/web2c/hitexdir/hiformat.w"

void hget_unknown_def(void)
{Tag t;signed char i,b= 0,n= 0;
t= HGET8;
i= HGET8;
if(i==0)
QUIT("Zero not allowed for unknown node size at 0x%x\n",(uint32_t)(hpos-hstart-2));
hwrite_start();hwritef("unknown");
b= NODE_HEAD(i);n= NODE_TAIL(i);
if(n==0)
hwritef(" 0x%02X %d",t,b);
else
hwritef(" 0x%02X %d %d",t,b,n);
if(hnode_size[t]==0)
{hnode_size[t]= i;
DBG(DBGTAGS,"Defining node size %d,%d for tag 0x%x\n",b,n,t);
}
hwrite_end();
}
/*:307*//*308:*/
#line 6545 "../../../texk/web2c/hitexdir/hiformat.w"

int hget_unknown(Tag a)
{int b,n;
int8_t s;
s= hnode_size[a];
DBG(DBGTAGS,"Trying unknown tag 0x%x at 0x%x\n",a,(uint32_t)(hpos-hstart-1));
if(s==0)return 0;
b= NODE_HEAD(s);n= NODE_TAIL(s);
DBG(DBGTAGS,"Trying unknown node size %d %d\n",b,n);
hwritef("unknown 0x%02X",a);
while(b> 0){a= HGET8;hwritef(" 0x%02X",a);b--;}
while(n> 0){
a= *hpos;
if(KIND(a)==xdimen_kind){Xdimen x;hget_xdimen_node(&x);hwrite_xdimen_node(&x);}
else if(KIND(a)==param_kind){List l;hget_param_list(&l);hwrite_named_param_list(&l);}
else if(KIND(a)<=list_kind){List l;hget_list(&l);hwrite_list(&l);}
else hget_content_node();
n--;}
return 1;
}
/*:308*//*313:*/
#line 6927 "../../../texk/web2c/hitexdir/hiformat.w"

static bool hget_stream_def(void)
{if(KIND(*hpos)!=stream_kind||!(INFO(*hpos)&b100))
return false;
else
{Ref df;
/*16:*/
#line 726 "../../../texk/web2c/hitexdir/hiformat.w"

Tag a,z;
uint32_t node_pos= (uint32_t)(hpos-hstart);
if(hpos>=hend)QUIT("Attempt to read a start byte at the end of the section");
HGETTAG(a);
/*:16*/
#line 6933 "../../../texk/web2c/hitexdir/hiformat.w"

DBG(DBGDEF,"Defining stream %d at "SIZE_F"\n",*hpos,hpos-hstart-1);
DEF(df,stream_kind,HGET8);
hwrite_start();hwritef("stream");hwrite_ref(df.n);
if(df.n> 0)
{Xdimen x;List l;
if(INFO(a)==b100)/*312:*/
#line 6914 "../../../texk/web2c/hitexdir/hiformat.w"

{Xdimen x;
uint16_t f,r;
uint8_t n;
DBG(DBGDEF,"Defining normal stream %d at "SIZE_F"\n",*(hpos-1),hpos-hstart-2);
hget_xdimen_node(&x);hwrite_xdimen_node(&x);
HGET16(f);RNG("magnification factor",f,0,1000);hwritef(" %d",f);
n= HGET8;if(n==255)hwritef(" *");else{REF_RNG(stream_kind,n);hwrite_ref(n);}
n= HGET8;if(n==255)hwritef(" *");else{REF_RNG(stream_kind,n);hwrite_ref(n);}
HGET16(r);RNG("split ratio",r,0,1000);hwritef(" %d",r);
}
/*:312*/
#line 6939 "../../../texk/web2c/hitexdir/hiformat.w"

else if(INFO(a)==b101)hwritef(" first");
else if(INFO(a)==b110)hwritef(" last");
else if(INFO(a)==b111)hwritef(" top");
hget_list(&l);hwrite_list(&l);
hget_xdimen_node(&x);hwrite_xdimen_node(&x);
hget_glue_node();
hget_list(&l);hwrite_list(&l);
hget_glue_node();
}
/*17:*/
#line 733 "../../../texk/web2c/hitexdir/hiformat.w"

HGETTAG(z);
if(a!=z)
QUIT("Tag mismatch [%s,%d]!=[%s,%d] at 0x%x to "SIZE_F"\n",
NAME(a),INFO(a),NAME(z),INFO(z),node_pos,hpos-hstart-1);
/*:17*/
#line 6949 "../../../texk/web2c/hitexdir/hiformat.w"

hwrite_end();
return true;
}
}

/*:313*//*322:*/
#line 7116 "../../../texk/web2c/hitexdir/hiformat.w"

void hget_page(void)
{char*n;uint8_t p;Xdimen x;List l;
HGET_STRING(n);hwrite_string(n);
p= HGET8;if(p!=1)hwritef(" %d",p);
hget_glue_node();
hget_dimen(TAG(dimen_kind,b001));
hget_xdimen_node(&x);hwrite_xdimen_node(&x);
hget_xdimen_node(&x);hwrite_xdimen_node(&x);
hget_list(&l);hwrite_list(&l);
while(hget_stream_def())continue;
}
/*:322*//*331:*/
#line 7243 "../../../texk/web2c/hitexdir/hiformat.w"

void hget_range(Info info,uint8_t pg)
{uint32_t from,to;
REF(page_kind,pg);
REF(range_kind,(next_range-1)/2);
if(info&b100)
{if(info&b001)HGET32(from);else HGET16(from);}
else from= 0;
if(info&b010)
{if(info&b001)HGET32(to);else HGET16(to);}
else to= HINT_NO_POS;
range_pos[next_range].pg= pg;
range_pos[next_range].on= true;
range_pos[next_range].pos= from;
DBG(DBGRANGE,"Range *%d from 0x%x\n",pg,from);
DBG(DBGRANGE,"Range *%d to 0x%x\n",pg,to);
next_range++;
if(to!=HINT_NO_POS)
{range_pos[next_range].pg= pg;
range_pos[next_range].on= false;
range_pos[next_range].pos= to;
next_range++;
}
}
/*:331*//*381:*/
#line 8505 "../../../texk/web2c/hitexdir/hiformat.w"

void hget_definition_section(void)
{DBG(DBGBASIC|DBGDEF,"Definitions\n");
hget_section(1);
hwrite_definitions_start();
DBG(DBGDEF,"List of maximum values\n");
hget_max_definitions();
/*253:*/
#line 5441 "../../../texk/web2c/hitexdir/hiformat.w"

if(max_ref[label_kind]>=0)
ALLOCATE(labels,max_ref[label_kind]+1,Label);
/*:253*//*274:*/
#line 5824 "../../../texk/web2c/hitexdir/hiformat.w"

if(max_outline>=0)
ALLOCATE(outlines,max_outline+1,Outline);
/*:274*//*290:*/
#line 6197 "../../../texk/web2c/hitexdir/hiformat.w"

{int i;
for(i= 0;i<sizeof(ColorSet)/4;i++)
colors_0[i]= color_defaults[0][i];
}
/*:290*//*325:*/
#line 7199 "../../../texk/web2c/hitexdir/hiformat.w"

ALLOCATE(page_on,max_ref[page_kind]+1,int);
ALLOCATE(range_pos,2*(max_ref[range_kind]+1),RangePos);
/*:325*//*393:*/
#line 8801 "../../../texk/web2c/hitexdir/hiformat.w"

definition_bits[0][list_kind]= (1<<(MAX_LIST_DEFAULT+1))-1;
definition_bits[0][param_kind]= (1<<(MAX_LIST_DEFAULT+1))-1;
definition_bits[0][int_kind]= (1<<(MAX_INT_DEFAULT+1))-1;
definition_bits[0][dimen_kind]= (1<<(MAX_DIMEN_DEFAULT+1))-1;
definition_bits[0][xdimen_kind]= (1<<(MAX_XDIMEN_DEFAULT+1))-1;
definition_bits[0][glue_kind]= (1<<(MAX_GLUE_DEFAULT+1))-1;
definition_bits[0][baseline_kind]= (1<<(MAX_BASELINE_DEFAULT+1))-1;
definition_bits[0][page_kind]= (1<<(MAX_PAGE_DEFAULT+1))-1;
definition_bits[0][stream_kind]= (1<<(MAX_STREAM_DEFAULT+1))-1;
definition_bits[0][range_kind]= (1<<(MAX_RANGE_DEFAULT+1))-1;
definition_bits[0][color_kind]= (1<<(MAX_COLOR_DEFAULT+1))-1;
/*:393*//*408:*/
#line 9126 "../../../texk/web2c/hitexdir/hiformat.w"

ALLOCATE(hfont_name,max_ref[font_kind]+1,char*);
/*:408*/
#line 8512 "../../../texk/web2c/hitexdir/hiformat.w"

hwrite_max_definitions();
DBG(DBGDEF,"List of definitions\n");
while(hpos<hend)
hget_def_node();
hwrite_definitions_end();
}
/*:381*//*398:*/
#line 8870 "../../../texk/web2c/hitexdir/hiformat.w"

void hget_definition(int n,Tag a,uint32_t node_pos)
{switch(KIND(a))
{case font_kind:hget_font_def(INFO(a),n);break;
case param_kind:
{List l;l.t= a;HGET_LIST(INFO(a),l);hwrite_parameters(&l);break;}
case page_kind:hget_page();break;
case dimen_kind:hget_dimen(a);break;
case xdimen_kind:
{Xdimen x;hget_xdimen(a,&x);hwrite_xdimen(&x);break;}
case language_kind:
if(INFO(a)!=b000)
QUIT("Info value of language definition must be zero");
else
{char*n;HGET_STRING(n);hwrite_string(n);}
break;
case color_kind:
switch(INFO(a))
{/*299:*/
#line 6366 "../../../texk/web2c/hitexdir/hiformat.w"

case b000:
{int k;
ColorSet c;
static bool first_color= true;
k= HGET8;
if(k<6)
QUIT("Definition %d of color set needs 6 color pairs only %d given\n",n,k);
hget_color_set(node_pos,c);
if(n==0)
{if(!first_color)
QUIT("Definition of color set zero must be first");
memcpy(&color_defaults[0],&c,sizeof(ColorSet));
}
first_color= false;
}
break;
/*:299*/
#line 8888 "../../../texk/web2c/hitexdir/hiformat.w"

default:
QUIT("Undefined tag %d for color_kind definition at 0x%x",INFO(a),node_pos);
}
break;
default:
hget_content(a);break;
}
}


void hget_def_node()
{Kind k;

/*16:*/
#line 726 "../../../texk/web2c/hitexdir/hiformat.w"

Tag a,z;
uint32_t node_pos= (uint32_t)(hpos-hstart);
if(hpos>=hend)QUIT("Attempt to read a start byte at the end of the section");
HGETTAG(a);
/*:16*/
#line 8902 "../../../texk/web2c/hitexdir/hiformat.w"

k= KIND(a);
if(k==unknown_kind&&INFO(a)==b100)
hget_unknown_def();
else if(k==label_kind)
hget_outline_or_label_def(INFO(a),node_pos);
else
{int n;
n= HGET8;
if(k!=range_kind)REF_RNG(k,n);
SET_DBIT(n,k);
if(k==range_kind)
hget_range(INFO(a),n);
else
{hwrite_start();hwritef("%s *%d",definition_name[k],n);
hget_definition(n,a,node_pos);
hwrite_end();
}
if(n> max_ref[k]||n<=max_fixed[k])
QUIT("Definition %d for %s out of range [%d - %d]",
n,definition_name[k],max_fixed[k]+1,max_ref[k]);
if(max_fixed[k]> max_default[k])
QUIT("Definitions for kind %s not supported",definition_name[k]);
}
/*17:*/
#line 733 "../../../texk/web2c/hitexdir/hiformat.w"

HGETTAG(z);
if(a!=z)
QUIT("Tag mismatch [%s,%d]!=[%s,%d] at 0x%x to "SIZE_F"\n",
NAME(a),INFO(a),NAME(z),INFO(z),node_pos,hpos-hstart-1);
/*:17*/
#line 8926 "../../../texk/web2c/hitexdir/hiformat.w"

}
/*:398*//*405:*/
#line 9027 "../../../texk/web2c/hitexdir/hiformat.w"

void hget_param_list(List*l)
{if(KIND(*hpos)!=param_kind)
QUIT("Parameter list expected at 0x%x",(uint32_t)(hpos-hstart));
else hget_list(l);
}
/*:405*//*412:*/
#line 9180 "../../../texk/web2c/hitexdir/hiformat.w"

static void hget_font_params(void)
{Disc h;
hget_glue_node();
hget_disc_node(&(h));hwrite_disc_node(&h);
DBG(DBGDEF,"Start font parameters\n");
while(KIND(*hpos)!=font_kind)
{Ref df;
/*16:*/
#line 726 "../../../texk/web2c/hitexdir/hiformat.w"

Tag a,z;
uint32_t node_pos= (uint32_t)(hpos-hstart);
if(hpos>=hend)QUIT("Attempt to read a start byte at the end of the section");
HGETTAG(a);
/*:16*/
#line 9188 "../../../texk/web2c/hitexdir/hiformat.w"

df.k= KIND(a);
df.n= HGET8;
DBG(DBGDEF,"Reading font parameter %d: %s\n",df.n,definition_name[df.k]);
if(df.k!=penalty_kind&&df.k!=kern_kind&&df.k!=ligature_kind&&
df.k!=disc_kind&&df.k!=glue_kind&&df.k!=language_kind&&df.k!=rule_kind&&df.k!=image_kind)
QUIT("Font parameter %d has invalid type %s",df.n,content_name[df.n]);
RNG("Font parameter",df.n,0,MAX_FONT_PARAMS);
hwrite_start();hwritef("%s *%d",content_name[KIND(a)],df.n);
hget_definition(df.n,a,node_pos);
hwrite_end();
/*17:*/
#line 733 "../../../texk/web2c/hitexdir/hiformat.w"

HGETTAG(z);
if(a!=z)
QUIT("Tag mismatch [%s,%d]!=[%s,%d] at 0x%x to "SIZE_F"\n",
NAME(a),INFO(a),NAME(z),INFO(z),node_pos,hpos-hstart-1);
/*:17*/
#line 9199 "../../../texk/web2c/hitexdir/hiformat.w"

}
DBG(DBGDEF,"End font parameters\n");
}


void hget_font_def(Info i,uint8_t f)
{char*n;Dimen s= 0;uint16_t m= 0,y;
HGET_STRING(n);hwrite_string(n);hfont_name[f]= strdup(n);
HGET32(s);hwrite_dimension(s);
DBG(DBGDEF,"Font %s size 0x%x\n",n,s);
if(i==b000){HGET16(m);RNG("Font metrics",m,3,max_section_no);}
HGET16(y);RNG("Font glyphs",y,3,max_section_no);
if(i==b000)hwritef(" %d",m);
hwritef(" %d",y);
hget_font_params();
DBG(DBGDEF,"End font definition\n");
}
/*:412*//*446:*/
#line 9780 "../../../texk/web2c/hitexdir/hiformat.w"

void hget_content_section()
{DBG(DBGBASIC|DBGDIR,"Content\n");
hget_section(2);
hwrite_range();
hwrite_label();
while(hpos<hend)
hget_content_node();
}
/*:446*/
#line 11834 "../../../texk/web2c/hitexdir/hiformat.w"


#define STRETCH
#define DESCRIPTION "\nConvert a `short' binary HINT file into a `long' ASCII HINT file.\n"

int main(int argc,char*argv[])
{/*451:*/
#line 9907 "../../../texk/web2c/hitexdir/hiformat.w"

char*prog_name;
char*in_ext;
char*out_ext;
int option_log= false;
#ifndef SKIP
char*file_name= NULL;
int file_name_length= 0;
#endif
#line 9916 "../../../texk/web2c/hitexdir/hiformat.w"
/*:451*/
#line 11840 "../../../texk/web2c/hitexdir/hiformat.w"


in_ext= ".hnt";
out_ext= ".hint";
/*452:*/
#line 9923 "../../../texk/web2c/hitexdir/hiformat.w"

debugflags= DBGBASIC;
prog_name= argv[0];
if(argc<2)
{fprintf(stderr,
"%s: no input file given\n"
"Try '%s --help' for more information\n",prog_name,prog_name);
exit(1);
}
argv++;
while(*argv!=NULL)
{if((*argv)[0]=='-')
{char option= (*argv)[1];
switch(option)
{case'-':
if(strcmp(*argv,"--version")==0)
{fprintf(stderr,"%s version "HINT_VERSION_STRING"\n",prog_name);
exit(0);
}
else if(strcmp(*argv,"--help")==0)
{/*448:*/
#line 9814 "../../../texk/web2c/hitexdir/hiformat.w"

fprintf(stdout,
"Usage: %s [OPTION]... FILENAME%s\n",prog_name,in_ext);
fprintf(stdout,DESCRIPTION);
fprintf(stdout,
"\nOptions:\n"
"\t --help \t display this message\n"
"\t --version\t display the HINT version\n"
"\t -l     \t redirect stderr to a log file\n"
#if defined (STRETCH) || defined (SHRINK)
"\t -o FILE\t specify an output file name\n"
#endif
#line 9826 "../../../texk/web2c/hitexdir/hiformat.w"
#if defined (STRETCH)
"\t -a     \t write auxiliary files\n"
"\t -g     \t do not use localized names (implies -a)\n"
"\t -f     \t force overwriting existing auxiliary files\n"
"\t -u     \t enable writing utf8 character codes\n"
"\t -x     \t enable writing hexadecimal character codes\n"
#elif defined (SHRINK)
#line 9833 "../../../texk/web2c/hitexdir/hiformat.w"
"\t -a     \t use only localized names\n"
"\t -g     \t do not use localized names\n"
"\t -c     \t enable compression\n"
#endif
#line 9837 "../../../texk/web2c/hitexdir/hiformat.w"
);
#ifdef DEBUG
fprintf(stdout,"\t -d XXXX \t set debug flag to hexadecimal value XXXX.\n"
"\t\t\t OR together these values:\n");
fprintf(stdout,"\t\t\t XX=%03X   basic debugging\n",DBGBASIC);
fprintf(stdout,"\t\t\t XX=%03X   tag debugging\n",DBGTAGS);
fprintf(stdout,"\t\t\t XX=%03X   node debugging\n",DBGNODE);
fprintf(stdout,"\t\t\t XX=%03X   definition debugging\n",DBGDEF);
fprintf(stdout,"\t\t\t XX=%03X   directory debugging\n",DBGDIR);
fprintf(stdout,"\t\t\t XX=%03X   range debugging\n",DBGRANGE);
fprintf(stdout,"\t\t\t XX=%03X   float debugging\n",DBGFLOAT);
fprintf(stdout,"\t\t\t XX=%03X   compression debugging\n",DBGCOMPRESS);
fprintf(stdout,"\t\t\t XX=%03X   buffer debugging\n",DBGBUFFER);
fprintf(stdout,"\t\t\t XX=%03X   flex debugging\n",DBGFLEX);
fprintf(stdout,"\t\t\t XX=%03X   bison debugging\n",DBGBISON);
fprintf(stdout,"\t\t\t XX=%03X   TeX debugging\n",DBGTEX);
fprintf(stdout,"\t\t\t XX=%03X   Page debugging\n",DBGPAGE);
fprintf(stdout,"\t\t\t XX=%03X   Font debugging\n",DBGFONT);
fprintf(stdout,"\t\t\t XX=%03X   Render debugging\n",DBGRENDER);
fprintf(stdout,"\t\t\t XX=%03X   Label debugging\n",DBGLABEL);
#endif
#line 9858 "../../../texk/web2c/hitexdir/hiformat.w"
/*:448*/
#line 9943 "../../../texk/web2c/hitexdir/hiformat.w"

fprintf(stdout,"\nFor further information and reporting bugs see https://hint.userweb.mwn.de/\n");
exit(0);
}
case'l':option_log= true;break;
#if defined (STRETCH) || defined (SHRINK)
case'o':argv++;
file_name_length= (int)strlen(*argv);
ALLOCATE(file_name,file_name_length+6,char);
strcpy(file_name,*argv);break;
case'g':option_global= option_aux= true;break;
case'a':option_aux= true;break;
#endif
#line 9956 "../../../texk/web2c/hitexdir/hiformat.w"
#if defined (STRETCH)
case'u':option_utf8= true;break;
case'x':option_hex= true;break;
case'f':option_force= true;break;
#elif defined (SHRINK)
#line 9961 "../../../texk/web2c/hitexdir/hiformat.w"
case'c':option_compress= true;break;
#endif
#line 9963 "../../../texk/web2c/hitexdir/hiformat.w"
 case'd':
argv++;if(*argv==NULL)
{fprintf(stderr,
"%s: option -d expects an argument\n"
"Try '%s --help' for more information\n",prog_name,prog_name);
exit(1);
}
debugflags= strtol(*argv,NULL,16);
break;
default:
{fprintf(stderr,
"%s: unrecognized option '%s'\n"
"Try '%s --help' for more information\n",prog_name,*argv,prog_name);
exit(1);
}
}
}
else
{int path_length= (int)strlen(*argv);
int ext_length= (int)strlen(in_ext);
ALLOCATE(hin_name,path_length+ext_length+1,char);
strcpy(hin_name,*argv);
if(path_length<ext_length
||strncmp(hin_name+path_length-ext_length,in_ext,ext_length)!=0)
{strcat(hin_name,in_ext);
path_length+= ext_length;
}
stem_length= path_length-ext_length;
ALLOCATE(stem_name,stem_length+6,char);
strncpy(stem_name,hin_name,stem_length);
stem_name[stem_length]= 0;
if(*(argv+1)!=NULL)
{fprintf(stderr,
"%s: extra argument after input file name:  '%s'\n"
"Try '%s --help' for more information\n",prog_name,*(argv+1),prog_name);
exit(1);
}
}
argv++;
}
if(hin_name==NULL)
{fprintf(stderr,
"%s: missing input file name\n"
"Try '%s --help' for more information\n",prog_name,prog_name);
exit(1);
}
/*:452*/
#line 11844 "../../../texk/web2c/hitexdir/hiformat.w"

/*454:*/
#line 10028 "../../../texk/web2c/hitexdir/hiformat.w"

if(option_log)
{
strcat(stem_name,".log");
hlog= freopen(stem_name,"w",stderr);
if(hlog==NULL)
{fprintf(stderr,"Unable to open logfile %s",stem_name);
hlog= stderr;
}
stem_name[stem_length]= 0;
}
else
hlog= stderr;
/*:454*/
#line 11845 "../../../texk/web2c/hitexdir/hiformat.w"

/*456:*/
#line 10049 "../../../texk/web2c/hitexdir/hiformat.w"

if(file_name!=NULL)
{int ext_length= (int)strlen(out_ext);
if(file_name_length<=ext_length
||strncmp(file_name+file_name_length-ext_length,out_ext,ext_length)!=0)
{strcat(file_name,out_ext);file_name_length+= ext_length;}
}
else
{file_name_length= stem_length+(int)strlen(out_ext);
ALLOCATE(file_name,file_name_length+1,char);
strcpy(file_name,stem_name);
strcpy(file_name+stem_length,out_ext);
}
{char*aux_name= file_name;
/*365:*/
#line 8061 "../../../texk/web2c/hitexdir/hiformat.w"

{char*path_end;
path_end= aux_name+1;
while(*path_end!=0)
{if(*path_end=='/')
{struct stat s;
*path_end= 0;
if(stat(aux_name,&s)==-1)
{
#ifdef WIN32
if(mkdir(aux_name)!=0)
#else
#line 8073 "../../../texk/web2c/hitexdir/hiformat.w"
 if(mkdir(aux_name,0777)!=0)
#endif
#line 8075 "../../../texk/web2c/hitexdir/hiformat.w"
 QUIT("Unable to create directory %s",aux_name);
DBG(DBGDIR,"Creating directory %s\n",aux_name);
}else if(!(S_IFDIR&(s.st_mode)))
QUIT("Unable to create directory %s, file exists",aux_name);
*path_end= '/';
}
path_end++;
}
}


/*:365*/
#line 10063 "../../../texk/web2c/hitexdir/hiformat.w"

aux_name= NULL;
}
hout= fopen(file_name,"wb");
if(hout==NULL)QUIT("Unable to open output file %s",file_name);
/*:456*/
#line 11846 "../../../texk/web2c/hitexdir/hiformat.w"

/*457:*/
#line 10072 "../../../texk/web2c/hitexdir/hiformat.w"

stem_length= file_name_length-(int)strlen(out_ext);
ALLOCATE(stem_name,stem_length+6,char);
strncpy(stem_name,file_name,stem_length);
stem_name[stem_length]= 0;
/*:457*/
#line 11847 "../../../texk/web2c/hitexdir/hiformat.w"

if(!hget_map())QUIT("Unable to map the input file");
hpos= hstart= hin_addr;
hend= hstart+hin_size;
hget_banner();
if(!hcheck_banner("hint"))QUIT("Invalid banner");
hput_banner("HINT","created by stretch");
hget_directory();
hwrite_directory();
hget_definition_section();
hwrite_content_section();
hwrite_aux_files();
hget_unmap();
/*459:*/
#line 10084 "../../../texk/web2c/hitexdir/hiformat.w"

if(file_name!=NULL)free(file_name);
if(hout!=NULL)fclose(hout);
/*:459*/
#line 11860 "../../../texk/web2c/hitexdir/hiformat.w"

DBG(DBGBASIC,"End of Program\n");
/*460:*/
#line 10088 "../../../texk/web2c/hitexdir/hiformat.w"

if(hlog!=NULL)fclose(hlog);
if(stem_name!=NULL)free(stem_name);
/*:460*/
#line 11862 "../../../texk/web2c/hitexdir/hiformat.w"

return 0;
}
/*:558*/
