// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from qml_group.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include "LayoutPropertyGroup.h"

#include <QQmlEngine>

#include "QuickStyle.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

LayoutPropertyGroup::LayoutPropertyGroup(QuickStyle *style)
    : QObject()
    , m_style(style)
{
    m_alignment = std::make_unique<AlignmentPropertyGroup>(m_style);
    m_padding = std::make_unique<SizePropertyGroup>(m_style);
    m_inset = std::make_unique<SizePropertyGroup>(m_style);
    m_margins = std::make_unique<SizePropertyGroup>(m_style);
}

void LayoutPropertyGroup::update(LayoutProperty *newState)
{
    if (newState == m_state) {
        return;
    }

    m_state = newState;

    if (!newState) {
        m_alignment->update(nullptr);
        m_padding->update(nullptr);
        m_inset->update(nullptr);
        m_margins->update(nullptr);
    } else {
        m_alignment->update(newState->alignment());
        m_padding->update(newState->padding());
        m_inset->update(newState->inset());
        m_margins->update(newState->margins());
    }

    Q_EMIT widthChanged();
    Q_EMIT heightChanged();
    Q_EMIT spacingChanged();
    Q_EMIT updated();
}

void LayoutPropertyGroup::refreshColors()
{
    m_alignment->refreshColors();
    m_padding->refreshColors();
    m_inset->refreshColors();
    m_margins->refreshColors();
}

AlignmentPropertyGroup *LayoutPropertyGroup::alignment() const
{
    return m_alignment.get();
}

QJSValue LayoutPropertyGroup::width() const
{
    if (!m_state) {
        return QJSValue(QJSValue::UndefinedValue);
    }

    auto value = m_state->width();
    if (value) {
        return m_style->engine()->toScriptValue(value.value());
    }

    return QJSValue(QJSValue::UndefinedValue);
}

QJSValue LayoutPropertyGroup::height() const
{
    if (!m_state) {
        return QJSValue(QJSValue::UndefinedValue);
    }

    auto value = m_state->height();
    if (value) {
        return m_style->engine()->toScriptValue(value.value());
    }

    return QJSValue(QJSValue::UndefinedValue);
}

QJSValue LayoutPropertyGroup::spacing() const
{
    if (!m_state) {
        return QJSValue(QJSValue::UndefinedValue);
    }

    auto value = m_state->spacing();
    if (value) {
        return m_style->engine()->toScriptValue(value.value());
    }

    return QJSValue(QJSValue::UndefinedValue);
}

SizePropertyGroup *LayoutPropertyGroup::padding() const
{
    return m_padding.get();
}

SizePropertyGroup *LayoutPropertyGroup::inset() const
{
    return m_inset.get();
}

SizePropertyGroup *LayoutPropertyGroup::margins() const
{
    return m_margins.get();
}

#include "moc_LayoutPropertyGroup.cpp"