// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from property.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include "TextProperty.h"

#include <QRegularExpression>

#include "PropertiesTypes.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

class Union::Properties::TextPropertyPrivate
{
public:
    std::unique_ptr<AlignmentProperty> alignment;
    std::optional<QFont> font;
    std::optional<Union::Color> color;
};

TextProperty::TextProperty()
    : d(std::make_unique<TextPropertyPrivate>())
{
}

TextProperty::TextProperty(const TextProperty &other)
    : d(std::make_unique<TextPropertyPrivate>())
{
    d->alignment = std::make_unique<AlignmentProperty>();
    *(d->alignment) = *(other.d->alignment);
    d->font = other.d->font;
    d->color = other.d->color;
}

TextProperty::TextProperty(TextProperty &&other)
    : d(std::move(other.d))
{
}

TextProperty::~TextProperty() = default;

TextProperty &TextProperty::operator=(const TextProperty &other)
{
    if (this != &other) {
        *(d->alignment) = *(other.d->alignment);
        d->font = other.d->font;
        d->color = other.d->color;
    }
    return *this;
}

TextProperty &TextProperty::operator=(TextProperty &&other)
{
    std::swap(d, other.d);
    return *this;
}

AlignmentProperty *TextProperty::alignment() const
{
    return d->alignment.get();
}

void TextProperty::setAlignment(std::unique_ptr<AlignmentProperty> &&newValue)
{
    d->alignment = std::move(newValue);
}

std::optional<QFont> TextProperty::font() const
{
    return d->font;
}

void TextProperty::setFont(const std::optional<QFont> &newValue)
{
    if (newValue == d->font) {
        return;
    }

    d->font = newValue;
}

std::optional<Union::Color> TextProperty::color() const
{
    return d->color;
}

void TextProperty::setColor(const std::optional<Union::Color> &newValue)
{
    if (newValue == d->color) {
        return;
    }

    d->color = newValue;
}

bool TextProperty::hasAnyValue() const
{
    if (d->alignment && d->alignment->hasAnyValue()) {
        return true;
    }
    if (d->font.has_value()) {
        return true;
    }
    if (d->color.has_value()) {
        return true;
    }
    return false;
}

bool TextProperty::isEmpty() const
{
    if (!hasAnyValue()) {
        return true;
    }

    if (d->alignment && !d->alignment->isEmpty()) {
        return false;
    }
    if (d->font.has_value() && d->font.value() != emptyValue<QFont>()) {
        return false;
    }
    if (d->color.has_value() && d->color.value() != emptyValue<Union::Color>()) {
        return false;
    }

    return true;
}

QString TextProperty::toString(int indentation, ToStringFlags flags) const
{
    if (!hasAnyValue()) {
        return u"(empty)"_s;
    }

    const bool multiline = flags & ToStringFlag::MultiLine;
    const bool types = flags & ToStringFlag::Types;

    QString result;
    QTextStream out(&result);

    constexpr auto indent = [](int amount, bool multiline, bool first) {
        if (multiline) {
            return QByteArray(amount, ' ');
        } else if (!first) {
            return QByteArray(", ");
        } else {
            return QByteArray(" ");
        }
    };

    const QByteArray maybeNewLine = multiline ? "\n" : "";
    const QByteArray empty = "(empty)";

    if (types) {
        out << "TextProperty(" << maybeNewLine;
    } else if (indentation > 0) {
        out << maybeNewLine;
    }

    out << indent(indentation, multiline, true) << "alignment: ";
    if (d->alignment) {
        out << d->alignment->toString(indentation + 2, flags);
    } else {
        out << empty << maybeNewLine;
    }
    out << indent(indentation, multiline, false) << "font: ";
    if (d->font) {
        out << d->font->toString() << maybeNewLine;
    } else {
        out << empty << maybeNewLine;
    }
    out << indent(indentation, multiline, false) << "color: ";
    if (d->color) {
        out << d->color->toString() << maybeNewLine;
    } else {
        out << empty << maybeNewLine;
    }

    if (types) {
        out << indent(indentation - 2, multiline, true) << ")";
    }
    out << maybeNewLine;

    out.flush();

    return result;
}

void TextProperty::resolveProperties(const TextProperty *source, TextProperty *destination)
{
    if (!source || !destination) {
        return;
    }

    if (source->d->alignment) {
        if (!destination->d->alignment) {
            destination->d->alignment = std::make_unique<AlignmentProperty>();
        }
        AlignmentProperty::resolveProperties(source->d->alignment.get(), destination->d->alignment.get());
    }
    if (!destination->d->font.has_value()) {
        destination->d->font = source->d->font;
    }
    if (!destination->d->color.has_value()) {
        destination->d->color = source->d->color;
    }
}

std::unique_ptr<TextProperty> TextProperty::empty()
{
    auto result = std::make_unique<TextProperty>();
    result->d->alignment = AlignmentProperty::empty();
    result->d->font = emptyValue<QFont>();
    result->d->color = emptyValue<Union::Color>();
    return result;
}

bool Union::Properties::operator==(const TextProperty &left, const TextProperty &right)
{
    if (left.alignment() && right.alignment()) {
        if (*(left.alignment()) != *(right.alignment())) {
            return false;
        }
    } else if (left.alignment() != right.alignment()) {
        return false;
    }
    if (left.font() != right.font()) {
        return false;
    }
    if (left.color() != right.color()) {
        return false;
    }
    return true;
}

QDebug operator<<(QDebug debug, Union::Properties::TextProperty *type)
{
    QDebugStateSaver saver(debug);
    debug.nospace() << qPrintable(type->toString(0, ToStringFlag::Types));
    return debug;
}