/** @file
 * VirtualBox API class wrapper code for IPlatformARM.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2026 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_PLATFORMARM

#include "PlatformARMWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(PlatformARMWrap)

//
// IPlatformARM properties
//

STDMETHODIMP PlatformARMWrap::COMGETTER(InternalAndReservedAttribute1IPlatformARM)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformARMWrap::COMGETTER(InternalAndReservedAttribute2IPlatformARM)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformARMWrap::COMGETTER(InternalAndReservedAttribute3IPlatformARM)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformARMWrap::COMGETTER(InternalAndReservedAttribute4IPlatformARM)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformARMWrap::COMGETTER(InternalAndReservedAttribute5IPlatformARM)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformARMWrap::COMGETTER(InternalAndReservedAttribute6IPlatformARM)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformARMWrap::COMGETTER(InternalAndReservedAttribute7IPlatformARM)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformARMWrap::COMGETTER(InternalAndReservedAttribute8IPlatformARM)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformARMWrap::COMGETTER(InternalAndReservedAttribute9IPlatformARM)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformARMWrap::COMGETTER(InternalAndReservedAttribute10IPlatformARM)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformARMWrap::COMGETTER(InternalAndReservedAttribute11IPlatformARM)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformARMWrap::COMGETTER(InternalAndReservedAttribute12IPlatformARM)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformARMWrap::COMGETTER(InternalAndReservedAttribute13IPlatformARM)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformARMWrap::COMGETTER(InternalAndReservedAttribute14IPlatformARM)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformARMWrap::COMGETTER(InternalAndReservedAttribute15IPlatformARM)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformARMWrap::COMGETTER(InternalAndReservedAttribute16IPlatformARM)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IPlatformARM methods
//

STDMETHODIMP PlatformARMWrap::GetCPUProperty(CPUPropertyTypeARM_T aProperty,
                                             BOOL *aValue)
{
    LogRelFlow(("{%p} %s: enter aProperty=%RU32 aValue=%p\n", this, "PlatformARM::getCPUProperty", aProperty, aValue));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aValue);


        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMARM_GETCPUPROPERTY_ENTER(this, aProperty);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getCPUProperty(aProperty,
                                 aValue);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMARM_GETCPUPROPERTY_RETURN(this, hrc, 0 /*normal*/, aProperty, *aValue != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMARM_GETCPUPROPERTY_RETURN(this, hrc, 1 /*hrc exception*/, aProperty, *aValue != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMARM_GETCPUPROPERTY_RETURN(this, hrc, 9 /*unhandled exception*/, aProperty, *aValue != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave aValue=%RTbool hrc=%Rhrc\n", this, "PlatformARM::getCPUProperty", *aValue, hrc));
    return hrc;
}

STDMETHODIMP PlatformARMWrap::SetCPUProperty(CPUPropertyTypeARM_T aProperty,
                                             BOOL aValue)
{
    LogRelFlow(("{%p} %s: enter aProperty=%RU32 aValue=%RTbool\n", this, "PlatformARM::setCPUProperty", aProperty, aValue));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMARM_SETCPUPROPERTY_ENTER(this, aProperty, aValue != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setCPUProperty(aProperty,
                                 aValue != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMARM_SETCPUPROPERTY_RETURN(this, hrc, 0 /*normal*/, aProperty, aValue != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMARM_SETCPUPROPERTY_RETURN(this, hrc, 1 /*hrc exception*/, aProperty, aValue != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMARM_SETCPUPROPERTY_RETURN(this, hrc, 9 /*unhandled exception*/, aProperty, aValue != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "PlatformARM::setCPUProperty", hrc));
    return hrc;
}

STDMETHODIMP PlatformARMWrap::InternalAndReservedMethod1IPlatformARM()
{
    return E_NOTIMPL;
}

STDMETHODIMP PlatformARMWrap::InternalAndReservedMethod2IPlatformARM()
{
    return E_NOTIMPL;
}

STDMETHODIMP PlatformARMWrap::InternalAndReservedMethod3IPlatformARM()
{
    return E_NOTIMPL;
}

STDMETHODIMP PlatformARMWrap::InternalAndReservedMethod4IPlatformARM()
{
    return E_NOTIMPL;
}

STDMETHODIMP PlatformARMWrap::InternalAndReservedMethod5IPlatformARM()
{
    return E_NOTIMPL;
}

STDMETHODIMP PlatformARMWrap::InternalAndReservedMethod6IPlatformARM()
{
    return E_NOTIMPL;
}

STDMETHODIMP PlatformARMWrap::InternalAndReservedMethod7IPlatformARM()
{
    return E_NOTIMPL;
}

STDMETHODIMP PlatformARMWrap::InternalAndReservedMethod8IPlatformARM()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(PlatformARMWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(PlatformARMWrap, IPlatformARM)
#endif // VBOX_WITH_XPCOM
