/** @file
 * VirtualBox API class wrapper code for IRecordingSettings.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2026 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_RECORDINGSETTINGS

#include "RecordingSettingsWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(RecordingSettingsWrap)

//
// IRecordingSettings properties
//

STDMETHODIMP RecordingSettingsWrap::COMGETTER(Paused)(BOOL *aPaused)
{
    LogRelFlow(("{%p} %s: enter aPaused=%p\n", this, "RecordingSettings::getPaused", aPaused));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPaused);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_GET_PAUSED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPaused(aPaused);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_GET_PAUSED_RETURN(this, hrc, 0 /*normal*/,*aPaused != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_GET_PAUSED_RETURN(this, hrc, 1 /*hrc exception*/,*aPaused != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_GET_PAUSED_RETURN(this, hrc, 9 /*unhandled exception*/,*aPaused != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPaused=%RTbool hrc=%Rhrc\n", this, "RecordingSettings::getPaused", *aPaused, hrc));
    return hrc;
}

STDMETHODIMP RecordingSettingsWrap::COMSETTER(Paused)(BOOL aPaused)
{
    LogRelFlow(("{%p} %s: enter aPaused=%RTbool\n", this, "RecordingSettings::setPaused", aPaused));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_SET_PAUSED_ENTER(this, aPaused != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setPaused(aPaused != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_SET_PAUSED_RETURN(this, hrc, 0 /*normal*/,aPaused != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_SET_PAUSED_RETURN(this, hrc, 1 /*hrc exception*/,aPaused != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_SET_PAUSED_RETURN(this, hrc, 9 /*unhandled exception*/,aPaused != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "RecordingSettings::setPaused", hrc));
    return hrc;
}

STDMETHODIMP RecordingSettingsWrap::COMGETTER(Enabled)(BOOL *aEnabled)
{
    LogRelFlow(("{%p} %s: enter aEnabled=%p\n", this, "RecordingSettings::getEnabled", aEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_GET_ENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEnabled(aEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_GET_ENABLED_RETURN(this, hrc, 0 /*normal*/,*aEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_GET_ENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_GET_ENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEnabled=%RTbool hrc=%Rhrc\n", this, "RecordingSettings::getEnabled", *aEnabled, hrc));
    return hrc;
}

STDMETHODIMP RecordingSettingsWrap::COMSETTER(Enabled)(BOOL aEnabled)
{
    LogRelFlow(("{%p} %s: enter aEnabled=%RTbool\n", this, "RecordingSettings::setEnabled", aEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_SET_ENABLED_ENTER(this, aEnabled != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setEnabled(aEnabled != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_SET_ENABLED_RETURN(this, hrc, 0 /*normal*/,aEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_SET_ENABLED_RETURN(this, hrc, 1 /*hrc exception*/,aEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_SET_ENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,aEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "RecordingSettings::setEnabled", hrc));
    return hrc;
}

STDMETHODIMP RecordingSettingsWrap::COMGETTER(Screens)(ComSafeArrayOut(IRecordingScreenSettings *, aScreens))
{
    LogRelFlow(("{%p} %s: enter aScreens=%p\n", this, "RecordingSettings::getScreens", aScreens));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aScreens);
        ArrayComTypeOutConverter<IRecordingScreenSettings> TmpScreens(ComSafeArrayOutArg(aScreens));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_GET_SCREENS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getScreens(TmpScreens.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_GET_SCREENS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpScreens.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_GET_SCREENS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_GET_SCREENS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aScreens=%zu hrc=%Rhrc\n", this, "RecordingSettings::getScreens", ComSafeArraySize(*aScreens), hrc));
    return hrc;
}

STDMETHODIMP RecordingSettingsWrap::COMGETTER(Progress)(IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aProgress=%p\n", this, "RecordingSettings::getProgress", aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_GET_PROGRESS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProgress(TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_GET_PROGRESS_RETURN(this, hrc, 0 /*normal*/,(void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_GET_PROGRESS_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_GET_PROGRESS_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aProgress=%p hrc=%Rhrc\n", this, "RecordingSettings::getProgress", *aProgress, hrc));
    return hrc;
}


//
// IRecordingSettings methods
//

STDMETHODIMP RecordingSettingsWrap::GetScreenSettings(ULONG aScreenId,
                                                      IRecordingScreenSettings **aRecordScreenSettings)
{
    LogRelFlow(("{%p} %s: enter aScreenId=%RU32 aRecordScreenSettings=%p\n", this, "RecordingSettings::getScreenSettings", aScreenId, aRecordScreenSettings));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRecordScreenSettings);


        
        ComTypeOutConverter<IRecordingScreenSettings> TmpRecordScreenSettings(aRecordScreenSettings);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_GETSCREENSETTINGS_ENTER(this, aScreenId);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getScreenSettings(aScreenId,
                                    TmpRecordScreenSettings.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_GETSCREENSETTINGS_RETURN(this, hrc, 0 /*normal*/, aScreenId, (void *)TmpRecordScreenSettings.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_GETSCREENSETTINGS_RETURN(this, hrc, 1 /*hrc exception*/, aScreenId, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_GETSCREENSETTINGS_RETURN(this, hrc, 9 /*unhandled exception*/, aScreenId, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aRecordScreenSettings=%p hrc=%Rhrc\n", this, "RecordingSettings::getScreenSettings", *aRecordScreenSettings, hrc));
    return hrc;
}

STDMETHODIMP RecordingSettingsWrap::Start(IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aProgress=%p\n", this, "RecordingSettings::start", aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_START_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = start(TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_START_RETURN(this, hrc, 0 /*normal*/, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_START_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_START_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "RecordingSettings::start", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP RecordingSettingsWrap::Resume()
{
    LogRelFlow(("{%p} %s: enter\n", this, "RecordingSettings::resume"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_RESUME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = resume();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_RESUME_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_RESUME_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_RESUME_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "RecordingSettings::resume", hrc));
    return hrc;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(RecordingSettingsWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(RecordingSettingsWrap, IRecordingSettings)
#endif // VBOX_WITH_XPCOM
