/*
 * Decompiled with CFR 0.152.
 */
package org.a11y.brlapi.commands;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.a11y.brlapi.ExitException;
import org.a11y.brlapi.KeywordMap;
import org.a11y.brlapi.Program;
import org.a11y.brlapi.ProgramException;
import org.a11y.brlapi.Strings;
import org.a11y.brlapi.SyntaxException;
import org.a11y.brlapi.clients.ApiErrorClient;
import org.a11y.brlapi.clients.ApiExceptionClient;
import org.a11y.brlapi.clients.BoundCommandsClient;
import org.a11y.brlapi.clients.ComputerBrailleClient;
import org.a11y.brlapi.clients.DriverKeysClient;
import org.a11y.brlapi.clients.EchoClient;
import org.a11y.brlapi.clients.GetDriverClient;
import org.a11y.brlapi.clients.GetModelClient;
import org.a11y.brlapi.clients.GetSizeClient;
import org.a11y.brlapi.clients.ListParametersClient;
import org.a11y.brlapi.clients.PauseClient;
import org.a11y.brlapi.clients.SetParameterClient;
import org.a11y.brlapi.clients.WriteArgumentsClient;
import org.a11y.brlapi.clients.WriteDotsClient;
import org.a11y.brlapi.clients.WriteTextClient;
import org.a11y.brlapi.programs.VersionProgram;

public class ApiToolCommand
extends Program {
    private static final KeywordMap<Class<? extends Program>> knownPrograms = new KeywordMap();
    private String programName = null;
    private Class<? extends Program> programType = null;
    private String[] programArguments = null;

    private static void addProgram(Class<? extends Program> clazz) {
        String string = clazz.getSimpleName();
        string = ApiToolCommand.isClient(clazz) ? Strings.replaceAll(string, "Client$", "") : Strings.replaceAll(string, "Program$", "");
        string = ApiToolCommand.toOperandName(Strings.wordify(string));
        knownPrograms.put(string, clazz);
    }

    public ApiToolCommand(String ... stringArray) {
        super(stringArray);
        this.addRequiredParameters("program/client");
        this.addRepeatingParameter("argument");
    }

    @Override
    public String getPurpose() {
        return "Command line access to the functionality provided by the BrlAPI interface.";
    }

    @Override
    protected final void extendUsageSummary(StringBuilder stringBuilder) {
        super.extendUsageSummary(stringBuilder);
        if (knownPrograms.isEmpty()) {
            stringBuilder.append("\nNo programs or clients have been defined.");
        } else {
            stringBuilder.append("\nThese programs and clients have been defined").append(" (each has its own -help option):");
            for (String string : knownPrograms.getKeywords()) {
                stringBuilder.append("\n  ").append(string);
            }
        }
    }

    @Override
    protected final void processParameters(String[] stringArray) throws SyntaxException {
        int n = stringArray.length;
        if (n == 0) {
            throw new SyntaxException("missing program/client name", new Object[0]);
        }
        this.programName = stringArray[0];
        this.programType = knownPrograms.get(this.programName);
        if (this.programType == null) {
            throw new SyntaxException("unknown program/client: %s", this.programName);
        }
        this.programArguments = new String[--n];
        System.arraycopy(stringArray, 1, this.programArguments, 0, n);
    }

    @Override
    protected final void runProgram() throws ProgramException {
        String string = this.getObjectName();
        Program program = null;
        try {
            Constructor<? extends Program> constructor = this.programType.getConstructor(this.programArguments.getClass());
            program = constructor.newInstance(new Object[]{this.programArguments});
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ProgramException("constructor not found: %s", string);
        }
        catch (InstantiationException instantiationException) {
            throw new ProgramException("instantiation failed: %s: %s", string, instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ProgramException("access denied: %s: %s", string, illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            Object object = String.format("construction failed: %s: %s", string, throwable.getClass().getSimpleName());
            String string2 = throwable.getMessage();
            if (string2 != null) {
                object = (String)object + ": " + string2;
            }
            throw new ProgramException((String)object, new Object[0]);
        }
        program.setProgramName(this.programName).run();
    }

    public static void main(String ... stringArray) {
        try {
            new ApiToolCommand(stringArray).setProgramName("apitool").run();
        }
        catch (ExitException exitException) {
            System.exit(exitException.getExitCode());
        }
    }

    static {
        ApiToolCommand.addProgram(ApiErrorClient.class);
        ApiToolCommand.addProgram(ApiExceptionClient.class);
        ApiToolCommand.addProgram(BoundCommandsClient.class);
        ApiToolCommand.addProgram(ComputerBrailleClient.class);
        ApiToolCommand.addProgram(DriverKeysClient.class);
        ApiToolCommand.addProgram(EchoClient.class);
        ApiToolCommand.addProgram(GetDriverClient.class);
        ApiToolCommand.addProgram(GetModelClient.class);
        ApiToolCommand.addProgram(GetSizeClient.class);
        ApiToolCommand.addProgram(ListParametersClient.class);
        ApiToolCommand.addProgram(PauseClient.class);
        ApiToolCommand.addProgram(SetParameterClient.class);
        ApiToolCommand.addProgram(VersionProgram.class);
        ApiToolCommand.addProgram(WriteArgumentsClient.class);
        ApiToolCommand.addProgram(WriteDotsClient.class);
        ApiToolCommand.addProgram(WriteTextClient.class);
    }
}

