/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.turboproject;

import java.util.Date;
import net.sf.mpxj.common.DateHelper;

final class PEPUtility {
    private static final long EPOCH = 946598400000L;

    PEPUtility() {
    }

    public static final int getInt(byte[] data, int offset) {
        int result = 0;
        int i = offset;
        for (int shiftBy = 0; shiftBy < 32; shiftBy += 8) {
            result |= (data[i] & 0xFF) << shiftBy;
            ++i;
        }
        return result;
    }

    public static final int getShort(byte[] data, int offset) {
        int result = 0;
        int i = offset;
        for (int shiftBy = 0; shiftBy < 16; shiftBy += 8) {
            result |= (data[i] & 0xFF) << shiftBy;
            ++i;
        }
        return result;
    }

    public static final String getString(byte[] data, int offset) {
        return PEPUtility.getString(data, offset, data.length - offset);
    }

    public static final String getString(byte[] data, int offset, int maxLength) {
        char c;
        StringBuilder buffer = new StringBuilder();
        for (int loop = 0; loop < maxLength && (c = (char)data[offset + loop]) != '\u0000'; ++loop) {
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static final Date getStartDate(byte[] data, int offset) {
        long days = PEPUtility.getShort(data, offset);
        Date result = days == 32768L ? null : DateHelper.getDateFromLong(946598400000L + days * 86400000L);
        return result;
    }

    public static final Date getFinishDate(byte[] data, int offset) {
        long days = PEPUtility.getShort(data, offset);
        Date result = days == 32768L ? null : DateHelper.getDateFromLong(946598400000L + (days - 1L) * 86400000L);
        return result;
    }
}

