/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.dialogs.MessageBoxModern;
import org.jkiss.dbeaver.ui.dialogs.Reply;
import org.jkiss.utils.CommonUtils;

public final class MessageBoxBuilder {
    private final MessageBoxModern dialog;
    @Nullable
    private List<Reply> replies;
    @Nullable
    private Reply defaultReply;

    private MessageBoxBuilder(@Nullable Shell shell) {
        this.dialog = new MessageBoxModern(shell);
    }

    public static MessageBoxBuilder builder(@Nullable Shell shell) {
        return new MessageBoxBuilder(shell);
    }

    public static MessageBoxBuilder builder() {
        return new MessageBoxBuilder(null);
    }

    @NotNull
    public MessageBoxBuilder setTitle(@NotNull String title) {
        this.dialog.setTitle(title);
        return this;
    }

    @NotNull
    public MessageBoxBuilder setMessage(@NotNull String message) {
        this.dialog.setMessage(message);
        return this;
    }

    @NotNull
    public MessageBoxBuilder setPrimaryImage(@NotNull DBPImage image) {
        this.dialog.setPrimaryImage(image);
        return this;
    }

    @NotNull
    public MessageBoxBuilder setReplies(Reply ... replies) {
        this.replies = new ArrayList<Reply>(Arrays.asList(replies));
        return this;
    }

    @NotNull
    public MessageBoxBuilder setReplies(@NotNull List<Reply> replies) {
        this.replies = new ArrayList<Reply>(replies);
        return this;
    }

    @NotNull
    public MessageBoxBuilder setDefaultReply(@NotNull Reply defaultReply) {
        this.defaultReply = defaultReply;
        return this;
    }

    @NotNull
    public MessageBoxBuilder setCustomArea(@NotNull Consumer<? super Composite> customArea) {
        this.dialog.setCustomArea(customArea);
        return this;
    }

    @NotNull
    public MessageBoxBuilder setCustomButton(@NotNull Consumer<? super Composite> customButton) {
        this.dialog.setCustomButton(customButton);
        return this;
    }

    @NotNull
    public MessageBoxBuilder setLabels(@NotNull String[] buttons) {
        this.dialog.setLabels(Arrays.asList(buttons));
        return this;
    }

    @NotNull
    public MessageBoxBuilder setDefaultFocus(int index) {
        this.dialog.setDefaultAnswerIdx(index);
        return this;
    }

    @Nullable
    public Reply showMessageBox() {
        int defaultIdx = 0;
        if (this.replies != null) {
            ArrayList<String> labels = new ArrayList<String>(this.replies.size());
            for (int i = 0; i < this.replies.size(); ++i) {
                Reply reply = this.replies.get(i);
                if (reply == this.defaultReply) {
                    defaultIdx = i;
                }
                labels.add(reply != null ? reply.getDisplayString() : "[null]");
            }
            this.dialog.setLabels(labels);
        }
        if (this.replies != null) {
            this.dialog.setDefaultAnswerIdx(defaultIdx);
        }
        int answerIdx = this.dialog.open();
        if (this.replies == null || !CommonUtils.isValidIndex((int)answerIdx, (int)this.replies.size())) {
            return switch (this.dialog.getReturnCode()) {
                case 0 -> Reply.OK;
                case 1 -> Reply.CANCEL;
                case 3 -> Reply.NO;
                default -> null;
            };
        }
        return this.replies.get(answerIdx);
    }
}

