/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import jakarta.annotation.PostConstruct;
import java.util.function.Consumer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSourceContainerProvider;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.AbstractPartListener;
import org.jkiss.dbeaver.ui.UIExecutionQueue;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.AbstractPageListener;
import org.jkiss.dbeaver.ui.controls.breadcrumb.BreadcrumbViewer;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorPreferences;
import org.jkiss.dbeaver.ui.editors.ILazyEditorInput;
import org.jkiss.dbeaver.ui.editors.INavigatorEditorInput;
import org.jkiss.dbeaver.ui.navigator.breadcrumb.NodeBreadcrumbViewer;

public class BreadcrumbTrim {
    private static final String BREADCRUMBS_ID = "org.jkiss.dbeaver.core.ui.Breadcrumb";
    private static final String BOTTOM_TRIM_ID = "org.eclipse.ui.trim.status";

    @PostConstruct
    public void createControls(Composite parent) {
        NodeBreadcrumbViewer viewer = new NodeBreadcrumbViewer(parent, 1024);
        BreadcrumbTrim.installListeners((BreadcrumbViewer)viewer);
        UIUtils.asyncExec(BreadcrumbTrim::updateElementVisibility);
    }

    private static void updateElementVisibility() {
        for (IWorkbenchWindow window : Workbench.getInstance().getWorkbenchWindows()) {
            if (!(window instanceof WorkbenchWindow)) continue;
            WorkbenchWindow workbenchWindow = (WorkbenchWindow)window;
            BreadcrumbTrim.updateElementVisibility(workbenchWindow);
        }
    }

    private static void updateElementVisibility(@NotNull WorkbenchWindow window) {
        Object object;
        MUIElement element;
        boolean breadcrumbsVisible;
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        MWindow model = window.getModel();
        EModelService modelService = (EModelService)window.getService(EModelService.class);
        boolean dirty = false;
        MUIElement breadcrumbsElement = modelService.find(BREADCRUMBS_ID, (MUIElement)model);
        boolean bl = breadcrumbsVisible = DatabaseEditorPreferences.BreadcrumbLocation.get((DBPPreferenceStore)store) == DatabaseEditorPreferences.BreadcrumbLocation.IN_STATUS_BAR;
        if (breadcrumbsElement != null && breadcrumbsElement.isToBeRendered() != breadcrumbsVisible) {
            breadcrumbsElement.setToBeRendered(breadcrumbsVisible);
            dirty = true;
        }
        MUIElement statusLineElement = modelService.find("org.eclipse.ui.StatusLine", (MUIElement)model);
        boolean statusLineVisible = store.getBoolean("ui.statusBar.show.statusLine");
        if (statusLineElement != null && statusLineElement.isToBeRendered() != statusLineVisible) {
            statusLineElement.setToBeRendered(statusLineVisible);
            dirty = true;
        }
        if (dirty && (element = modelService.find(BOTTOM_TRIM_ID, (MUIElement)model)) != null && (object = element.getWidget()) instanceof Composite) {
            Composite composite = (Composite)object;
            composite.layout(true, true);
        }
    }

    private static void installListeners(final @NotNull BreadcrumbViewer viewer) {
        IPropertyListener propertyListener = new IPropertyListener(){

            public void propertyChanged(Object source, int propId) {
                if (propId != 258 && propId != 257) {
                    return;
                }
                if (source instanceof IEditorPart) {
                    IEditorPart editorPart = (IEditorPart)source;
                    BreadcrumbTrim.setInput(viewer, editorPart.getEditorInput());
                }
            }
        };
        AbstractPartListener partListener = new AbstractPartListener(propertyListener){
            IEditorPart lastEditorPart;
            final /* synthetic */ 1 val$propertyListener;
            {
                this.val$propertyListener = var2_2;
            }

            public void partActivated(IWorkbenchPart part) {
                if (part instanceof IEditorPart) {
                    IEditorPart editorPart = (IEditorPart)part;
                    UIExecutionQueue.queueExec(() -> this.setLastEditorPart(editorPart, true));
                }
            }

            public void partClosed(IWorkbenchPart part) {
                if (part instanceof IEditorPart) {
                    IEditorPart editorPart = (IEditorPart)part;
                    UIExecutionQueue.queueExec(() -> this.setLastEditorPart(editorPart, false));
                }
            }

            private void setLastEditorPart(@Nullable IEditorPart part, boolean activated) {
                boolean shouldSetLastEditor;
                if (viewer.getControl() == null || viewer.getControl().isDisposed()) {
                    return;
                }
                boolean shouldRemoveLastEditor = activated != (this.lastEditorPart == part) && this.lastEditorPart != null;
                boolean bl = shouldSetLastEditor = activated && part != null;
                if (shouldRemoveLastEditor) {
                    this.lastEditorPart.removePropertyListener((IPropertyListener)this.val$propertyListener);
                    this.lastEditorPart = null;
                    viewer.setInput(null);
                }
                if (shouldSetLastEditor) {
                    this.lastEditorPart = part;
                    this.lastEditorPart.addPropertyListener((IPropertyListener)this.val$propertyListener);
                    BreadcrumbTrim.setInput(viewer, part.getEditorInput());
                }
            }
        };
        AbstractPageListener pageListener = new AbstractPageListener(partListener){
            final /* synthetic */ 2 val$partListener;
            {
                this.val$partListener = var1_1;
            }

            public void pageOpened(IWorkbenchPage page) {
                page.addPartListener((IPartListener)this.val$partListener);
            }

            public void pageClosed(IWorkbenchPage page) {
                page.removePartListener((IPartListener)this.val$partListener);
            }
        };
        IWorkbenchWindow window = UIUtils.getActiveWorkbenchWindow();
        window.addPageListener((IPageListener)pageListener);
        for (IWorkbenchPage page : window.getPages()) {
            page.addPartListener((IPartListener)partListener);
        }
        DBWorkbench.getPlatform().getPreferenceStore().addPropertyChangeListener(event -> {
            switch (event.getProperty()) {
                case "ui.statusBar.show.breadcrumbs": 
                case "ui.statusBar.show.statusLine": {
                    BreadcrumbTrim.updateElementVisibility();
                    break;
                }
            }
        });
    }

    private static void setInput(@NotNull BreadcrumbViewer viewer, @NotNull IEditorInput input) {
        if (viewer.getControl().isDisposed()) {
            return;
        }
        if (!BreadcrumbTrim.tryExtractNode(input, arg_0 -> ((BreadcrumbViewer)viewer).setInput(arg_0))) {
            viewer.setInput(null);
        }
    }

    private static boolean tryExtractNode(@NotNull IEditorInput input, @NotNull Consumer<? super DBNNode> consumer) {
        INavigatorEditorInput navigatorEditorInput;
        DBNNode node;
        if (input instanceof ILazyEditorInput) {
            ILazyEditorInput lazyEditorInput = (ILazyEditorInput)input;
            if (input instanceof DBPDataSourceContainerProvider) {
                DBNDatabaseNode node2;
                DBPDataSourceContainerProvider provider = (DBPDataSourceContainerProvider)input;
                DBPProject project = lazyEditorInput.getProject();
                if (project == null || !project.isOpen() || !project.isRegistryLoaded()) {
                    return false;
                }
                DBNModel navigatorModel = project.getNavigatorModel();
                if (navigatorModel != null && (node2 = navigatorModel.findNode((DBSObject)provider.getDataSourceContainer())) != null) {
                    consumer.accept((DBNNode)node2);
                    return true;
                }
            }
        }
        if (input instanceof INavigatorEditorInput && (node = (navigatorEditorInput = (INavigatorEditorInput)input).getNavigatorNode()) != null) {
            consumer.accept((DBNNode)node);
            return true;
        }
        return false;
    }
}

