/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.chat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.UUID;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.freeplane.plugin.ai.chat.AssistantProfile;
import org.freeplane.plugin.ai.chat.AssistantProfileSelectionModel;

class AssistantProfileManagerDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final AssistantProfileSelectionModel selectionModel;
    private final DefaultListModel<AssistantProfile> listModel = new DefaultListModel();
    private final JList<AssistantProfile> profilesList = new JList<AssistantProfile>(this.listModel);
    private final JTextField nameField = new JTextField();
    private final JTextArea promptArea = new JTextArea();
    private final JButton deleteButton = new JButton("Delete");

    AssistantProfileManagerDialog(Window owner, AssistantProfileSelectionModel selectionModel) {
        super(owner);
        this.selectionModel = selectionModel;
        this.setTitle("Assistant Profiles");
        this.setModal(true);
        this.setLayout(new BorderLayout(10, 10));
        this.setPreferredSize(new Dimension(520, 360));
        this.buildUi();
        this.loadProfiles();
        this.pack();
        this.setLocationRelativeTo(null);
    }

    void openDialog() {
        this.setVisible(true);
    }

    private void buildUi() {
        this.profilesList.setSelectionMode(0);
        this.profilesList.addListSelectionListener(event -> {
            if (event.getValueIsAdjusting()) {
                return;
            }
            AssistantProfile profile = this.profilesList.getSelectedValue();
            if (profile == null) {
                this.nameField.setText("");
                this.promptArea.setText("");
                this.deleteButton.setEnabled(false);
                return;
            }
            this.nameField.setText(profile.getName());
            this.promptArea.setText(profile.getPrompt());
            this.deleteButton.setEnabled(this.listModel.getSize() > 1);
        });
        this.nameField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent event) {
                AssistantProfileManagerDialog.this.updateSelectedProfileFromFields();
            }
        });
        JPanel listPanel = new JPanel(new BorderLayout(5, 5));
        listPanel.add((Component)new JLabel("Profiles"), "North");
        listPanel.add((Component)new JScrollPane(this.profilesList), "Center");
        JPanel editorPanel = new JPanel(new BorderLayout(5, 5));
        editorPanel.add((Component)new JLabel("Name"), "North");
        editorPanel.add((Component)this.nameField, "Center");
        JPanel promptPanel = new JPanel(new BorderLayout(5, 5));
        promptPanel.add((Component)new JLabel("Prompt"), "North");
        this.promptArea.setLineWrap(true);
        this.promptArea.setWrapStyleWord(true);
        promptPanel.add((Component)new JScrollPane(this.promptArea), "Center");
        JPanel rightPanel = new JPanel(new BorderLayout(5, 5));
        rightPanel.add((Component)editorPanel, "North");
        rightPanel.add((Component)promptPanel, "Center");
        JPanel contentPanel = new JPanel(new BorderLayout(10, 10));
        contentPanel.add((Component)listPanel, "West");
        contentPanel.add((Component)rightPanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton newButton = new JButton("New");
        JButton okButton = new JButton("OK");
        JButton cancelButton = new JButton("Cancel");
        newButton.addActionListener(event -> this.createProfile());
        okButton.addActionListener(event -> this.confirmDialog());
        this.deleteButton.addActionListener(event -> this.deleteProfile());
        cancelButton.addActionListener(event -> this.closeDialog());
        buttonPanel.add(newButton);
        buttonPanel.add(okButton);
        buttonPanel.add(this.deleteButton);
        buttonPanel.add(cancelButton);
        this.add((Component)contentPanel, "Center");
        this.add((Component)buttonPanel, "South");
    }

    private void loadProfiles() {
        this.listModel.clear();
        for (AssistantProfile profile : this.selectionModel.getProfiles()) {
            this.listModel.addElement(profile);
        }
        if (!this.listModel.isEmpty()) {
            this.profilesList.setSelectedIndex(0);
        }
    }

    private void createProfile() {
        AssistantProfile profile = new AssistantProfile(UUID.randomUUID().toString(), "New Profile", "");
        this.listModel.addElement(profile);
        this.profilesList.setSelectedValue(profile, true);
        SwingUtilities.invokeLater(this.nameField::requestFocusInWindow);
    }

    private void deleteProfile() {
        AssistantProfile profile = this.profilesList.getSelectedValue();
        if (profile == null || this.listModel.getSize() <= 1) {
            return;
        }
        int index = this.profilesList.getSelectedIndex();
        this.listModel.removeElement(profile);
        if (index >= this.listModel.getSize()) {
            index = this.listModel.getSize() - 1;
        }
        if (index >= 0) {
            this.profilesList.setSelectedIndex(index);
        } else {
            this.nameField.setText("");
            this.promptArea.setText("");
        }
        this.persistProfiles();
    }

    private void updateSelectedProfileFromFields() {
        AssistantProfile profile = this.profilesList.getSelectedValue();
        if (profile == null) {
            return;
        }
        profile.setName(this.nameField.getText());
        profile.setPrompt(this.promptArea.getText());
        this.profilesList.repaint();
    }

    private void confirmDialog() {
        this.updateSelectedProfileFromFields();
        this.persistProfiles();
        this.closeDialog();
    }

    private void persistProfiles() {
        ArrayList<AssistantProfile> profiles = new ArrayList<AssistantProfile>();
        for (int index = 0; index < this.listModel.getSize(); ++index) {
            profiles.add(this.listModel.getElementAt(index));
        }
        this.selectionModel.saveProfiles(profiles);
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

