/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandSetter;
import io.sf.carte.doc.style.css.property.IdentifierValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueList;

class GridPlacementShorthandSetter
extends ShorthandSetter {
    final String[] subparray;

    GridPlacementShorthandSetter(BaseCSSStyleDeclaration style, String shorthandName) {
        super(style, shorthandName);
        this.subparray = this.getShorthandDatabase().getShorthandSubproperties(shorthandName);
    }

    @Override
    public short assignSubproperties() {
        byte kwscan = this.scanForCssWideKeywords(this.currentValue);
        if (kwscan == 1) {
            return 0;
        }
        if (kwscan == 2) {
            return 2;
        }
        this.setPropertyToDefault(this.subparray[0]);
        this.setPropertyToDefault(this.subparray[1]);
        StyleValue firstValue = this.gridLine();
        if (firstValue != null) {
            this.setSubpropertyValue(this.subparray[0], firstValue);
            if (this.currentValue != null) {
                StyleValue secondValue;
                this.nextCurrentValue();
                if (this.currentValue != null && (secondValue = this.gridLine()) != null && this.currentValue == null) {
                    this.setSubpropertyValue(this.subparray[1], secondValue);
                    this.flush();
                    return 0;
                }
            } else {
                if (firstValue.getPrimitiveType() == CSSValue.Type.IDENT) {
                    this.setSubpropertyValue(this.subparray[1], firstValue);
                }
                this.flush();
                return 0;
            }
        }
        return 2;
    }

    StyleValue gridLine() {
        LexicalUnit.LexicalType lut = this.currentValue.getLexicalUnitType();
        if (lut == LexicalUnit.LexicalType.IDENT) {
            String sv = this.currentValue.getStringValue();
            if ("auto".equalsIgnoreCase(sv)) {
                this.nextCurrentValue();
                IdentifierValue ident = new IdentifierValue("auto");
                ident.setSubproperty(true);
                if (this.isFinalCurrentValue()) {
                    return ident;
                }
            } else if ("span".equalsIgnoreCase(sv)) {
                ValueList list = ValueList.createWSValueList();
                list.add(this.valueFactory.createCSSValueItem(this.currentValue, true).getCSSValue());
                this.nextCurrentValue();
                if (this.currentValue != null && ((lut = this.currentValue.getLexicalUnitType()) == LexicalUnit.LexicalType.INTEGER || lut == LexicalUnit.LexicalType.IDENT)) {
                    list.add(this.valueFactory.createCSSValueItem(this.currentValue, true).getCSSValue());
                    this.nextCurrentValue();
                    if (this.isFinalCurrentValue()) {
                        return list;
                    }
                }
            } else {
                StyleValue customIdent = this.createCSSValue(this.getShorthandName(), this.currentValue);
                this.nextCurrentValue();
                if (this.isFinalCurrentValue()) {
                    return customIdent;
                }
            }
        } else if (lut == LexicalUnit.LexicalType.INTEGER) {
            StyleValue cssInt = this.createCSSValue(this.getShorthandName(), this.currentValue);
            this.nextCurrentValue();
            if (this.isFinalCurrentValue()) {
                return cssInt;
            }
            if (this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT) {
                ValueList list = ValueList.createWSValueList();
                list.add(cssInt);
                list.add(this.valueFactory.createCSSValueItem(this.currentValue, true).getCSSValue());
                this.nextCurrentValue();
                if (this.isFinalCurrentValue()) {
                    return list;
                }
            }
        }
        return null;
    }

    boolean isFinalCurrentValue() {
        return this.currentValue == null || this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_SLASH;
    }
}

